package osfamilies

// OSFamily describes an OS Family, usually from a constructor or
// a kernel.
type OSFamily string

// OSFamily definitions.
const (
	TwoN            OSFamily = "2N"
	TwoWire         OSFamily = "2Wire"
	ThreeCom        OSFamily = "3Com"
	ThreeM          OSFamily = "3M"
	FourG           OSFamily = "4G"
	ATec            OSFamily = "A-Tec"
	ADIC            OSFamily = "ADIC"
	AKCP            OSFamily = "AKCP"
	AMX             OSFamily = "AMX"
	APC             OSFamily = "APC"
	ARCA            OSFamily = "ARCA"
	ATandT          OSFamily = "AT&T"
	AVM             OSFamily = "AVM"
	AVtech          OSFamily = "AVtech"
	AXIS            OSFamily = "AXIS"
	Aastra          OSFamily = "Aastra"
	AcBel           OSFamily = "AcBel"
	Aceex           OSFamily = "Aceex"
	Acer            OSFamily = "Acer"
	Acme            OSFamily = "Acme"
	Acorp           OSFamily = "Acorp"
	Actiontec       OSFamily = "Actiontec"
	Adaptec         OSFamily = "Adaptec"
	Adtran          OSFamily = "Adtran"
	Adva            OSFamily = "Adva"
	Advanced        OSFamily = "Advanced"
	Aerohive        OSFamily = "Aerohive"
	Aethra          OSFamily = "Aethra"
	Agfa            OSFamily = "Agfa"
	AirLive         OSFamily = "AirLive"
	AirMagnet       OSFamily = "AirMagnet"
	AirSpan         OSFamily = "AirSpan"
	Airaya          OSFamily = "Airaya"
	Airlink101      OSFamily = "Airlink101"
	Airnet          OSFamily = "Airnet"
	Airvana         OSFamily = "Airvana"
	Alaxala         OSFamily = "Alaxala"
	Alcatel         OSFamily = "Alcatel"
	AlcatelLucent   OSFamily = "Alcatel-Lucent"
	Alice           OSFamily = "Alice"
	AllenBradley    OSFamily = "Allen-Bradley"
	Allied          OSFamily = "Allied"
	Allnet          OSFamily = "Allnet"
	Allworx         OSFamily = "Allworx"
	Alvarion        OSFamily = "Alvarion"
	Amazon          OSFamily = "Amazon"
	Ambit           OSFamily = "Ambit"
	Amiga           OSFamily = "Amiga"
	Anue            OSFamily = "Anue"
	Apple           OSFamily = "Apple"
	Arcor           OSFamily = "Arcor"
	Areca           OSFamily = "Areca"
	Argon           OSFamily = "Argon"
	Argosy          OSFamily = "Argosy"
	Arris           OSFamily = "Arris"
	Aruba           OSFamily = "Aruba"
	Asmax           OSFamily = "Asmax"
	Asus            OSFamily = "Asus"
	Atari           OSFamily = "Atari"
	Atcom           OSFamily = "Atcom"
	AudioCodes      OSFamily = "AudioCodes"
	AudioControl    OSFamily = "AudioControl"
	Avaya           OSFamily = "Avaya"
	Avocent         OSFamily = "Avocent"
	Axcient         OSFamily = "Axcient"
	AzBox           OSFamily = "AzBox"
	BECK            OSFamily = "BECK"
	BSD             OSFamily = "BSD"
	BSDI            OSFamily = "BSDI"
	BT              OSFamily = "BT"
	Barracuda       OSFamily = "Barracuda"
	Barrelfish      OSFamily = "Barrelfish"
	Basler          OSFamily = "Basler"
	Bay             OSFamily = "Bay"
	BeaconMedaes    OSFamily = "BeaconMedaes"
	Beat            OSFamily = "Beat"
	Belkin          OSFamily = "Belkin"
	Bell            OSFamily = "Bell"
	Billion         OSFamily = "Billion"
	BinTec          OSFamily = "BinTec"
	BlackBox        OSFamily = "BlackBox"
	Blackboard      OSFamily = "Blackboard"
	Blue            OSFamily = "Blue"
	BlueArc         OSFamily = "BlueArc"
	Bluebird        OSFamily = "Bluebird"
	Bomara          OSFamily = "Bomara"
	Bosch           OSFamily = "Bosch"
	Bose            OSFamily = "Bose"
	Boundless       OSFamily = "Boundless"
	Bowers          OSFamily = "Bowers"
	British         OSFamily = "British"
	BroadMax        OSFamily = "BroadMax"
	Brocade         OSFamily = "Brocade"
	Brother         OSFamily = "Brother"
	Buffalo         OSFamily = "Buffalo"
	Burny           OSFamily = "Burny"
	Bush            OSFamily = "Bush"
	CNav            OSFamily = "C-Nav"
	CAEN            OSFamily = "CAEN"
	CMI             OSFamily = "CMI"
	Cabletron       OSFamily = "Cabletron"
	Caldera         OSFamily = "Caldera"
	Calix           OSFamily = "Calix"
	Cameo           OSFamily = "Cameo"
	Canon           OSFamily = "Canon"
	Casio           OSFamily = "Casio"
	Cayman          OSFamily = "Cayman"
	Ceedtec         OSFamily = "Ceedtec"
	Check           OSFamily = "Check"
	Chip            OSFamily = "Chip"
	CipherLab       OSFamily = "CipherLab"
	Cisco           OSFamily = "Cisco"
	Citrix          OSFamily = "Citrix"
	CoRAID          OSFamily = "CoRAID"
	Cobalt          OSFamily = "Cobalt"
	Cognex          OSFamily = "Cognex"
	Comau           OSFamily = "Comau"
	Compal          OSFamily = "Compal"
	Compaq          OSFamily = "Compaq"
	Comtrend        OSFamily = "Comtrend"
	Conceptronic    OSFamily = "Conceptronic"
	Control4        OSFamily = "Control4"
	Coyote          OSFamily = "Coyote"
	Cray            OSFamily = "Cray"
	Crestron        OSFamily = "Crestron"
	CyanogenMod     OSFamily = "CyanogenMod"
	Cyberoam        OSFamily = "Cyberoam"
	Cymphonix       OSFamily = "Cymphonix"
	DLink           OSFamily = "D-Link"
	DEC             OSFamily = "DEC"
	DMP             OSFamily = "DMP"
	DTE             OSFamily = "DTE"
	DVTel           OSFamily = "DVTel"
	DYMO            OSFamily = "DYMO"
	Data            OSFamily = "Data"
	Datalogic       OSFamily = "Datalogic"
	Daysequerra     OSFamily = "Daysequerra"
	Decru           OSFamily = "Decru"
	Dedicated       OSFamily = "Dedicated"
	Dell            OSFamily = "Dell"
	Denon           OSFamily = "Denon"
	Denver          OSFamily = "Denver"
	Develop         OSFamily = "Develop"
	Dick            OSFamily = "Dick"
	Digi            OSFamily = "Digi"
	Digital         OSFamily = "Digital"
	Digitus         OSFamily = "Digitus"
	Digium          OSFamily = "Digium"
	DirecTV         OSFamily = "DirecTV"
	Dish            OSFamily = "Dish"
	Dolby           OSFamily = "Dolby"
	DragonFly       OSFamily = "DragonFly"
	DragonWave      OSFamily = "DragonWave"
	DrayTek         OSFamily = "DrayTek"
	Draytek         OSFamily = "Draytek"
	Drayton         OSFamily = "Drayton"
	Dream           OSFamily = "Dream"
	Drobo           OSFamily = "Drobo"
	EMC             OSFamily = "EMC"
	ESI             OSFamily = "ESI"
	ETH             OSFamily = "ETH"
	EasyPath        OSFamily = "EasyPath"
	Eaton           OSFamily = "Eaton"
	Efficient       OSFamily = "Efficient"
	Eicon           OSFamily = "Eicon"
	Elfiq           OSFamily = "Elfiq"
	Elk             OSFamily = "Elk"
	Elsag           OSFamily = "Elsag"
	Ember           OSFamily = "Ember"
	Emerson         OSFamily = "Emerson"
	EnGenius        OSFamily = "EnGenius"
	Encore          OSFamily = "Encore"
	Endian          OSFamily = "Endian"
	Enerdis         OSFamily = "Enerdis"
	Engetron        OSFamily = "Engetron"
	Enistic         OSFamily = "Enistic"
	Enlogic         OSFamily = "Enlogic"
	Enterasys       OSFamily = "Enterasys"
	Epson           OSFamily = "Epson"
	Ericsson        OSFamily = "Ericsson"
	Espressif       OSFamily = "Espressif"
	Essentia        OSFamily = "Essentia"
	EtherWerX       OSFamily = "EtherWerX"
	Exabyte         OSFamily = "Exabyte"
	Excito          OSFamily = "Excito"
	Express         OSFamily = "Express"
	Exterity        OSFamily = "Exterity"
	Extreme         OSFamily = "Extreme"
	F5              OSFamily = "F5"
	FORE            OSFamily = "FORE"
	Fatek           OSFamily = "Fatek"
	FireBrick       OSFamily = "FireBrick"
	Force10         OSFamily = "Force10"
	Fortinet        OSFamily = "Fortinet"
	Foscam          OSFamily = "Foscam"
	Foundry         OSFamily = "Foundry"
	Free            OSFamily = "Free"
	FreeBSD         OSFamily = "FreeBSD"
	FreeNAS         OSFamily = "FreeNAS"
	Freecom         OSFamily = "Freecom"
	Fronius         OSFamily = "Fronius"
	Frontier        OSFamily = "Frontier"
	Fuji            OSFamily = "Fuji"
	Fujian          OSFamily = "Fujian"
	Fujitsu         OSFamily = "Fujitsu"
	Funkwerk        OSFamily = "Funkwerk"
	GNU             OSFamily = "GNU"
	GalaxyMetalGear OSFamily = "GalaxyMetalGear"
	Gargoyle        OSFamily = "Gargoyle"
	Garmin          OSFamily = "Garmin"
	GbE2c           OSFamily = "GbE2c"
	Geist           OSFamily = "Geist"
	Gemtek          OSFamily = "Gemtek"
	General         OSFamily = "General"
	Generex         OSFamily = "Generex"
	Gennet          OSFamily = "Gennet"
	Genua           OSFamily = "Genua"
	George          OSFamily = "George"
	Geovision       OSFamily = "Geovision"
	GlobespanVirata OSFamily = "GlobespanVirata"
	GoPro           OSFamily = "GoPro"
	Google          OSFamily = "Google"
	Grace           OSFamily = "Grace"
	Grandstream     OSFamily = "Grandstream"
	Green           OSFamily = "Green"
	H3C             OSFamily = "H3C"
	HID             OSFamily = "HID"
	HP              OSFamily = "HP"
	HW              OSFamily = "HW"
	Haiku           OSFamily = "Haiku"
	Hamlet          OSFamily = "Hamlet"
	Harris          OSFamily = "Harris"
	Hawking         OSFamily = "Hawking"
	Hay             OSFamily = "Hay"
	Head            OSFamily = "Head"
	Henry           OSFamily = "Henry"
	HighFlying      OSFamily = "High-Flying"
	Hikvision       OSFamily = "Hikvision"
	Hioki           OSFamily = "Hioki"
	Hirschmann      OSFamily = "Hirschmann"
	Hitron          OSFamily = "Hitron"
	Hotway          OSFamily = "Hotway"
	Huawei          OSFamily = "Huawei"
	Hybertone       OSFamily = "Hybertone"
	IBM             OSFamily = "IBM"
	IEI             OSFamily = "IEI"
	IGEL            OSFamily = "IGEL"
	IHome           OSFamily = "IHome"
	IOData          OSFamily = "IO-Data"
	IOGear          OSFamily = "IOGear"
	ION             OSFamily = "ION"
	IPAD            OSFamily = "IPAD"
	IPCop           OSFamily = "IPCop"
	IPFire          OSFamily = "IPFire"
	ISS             OSFamily = "ISS"
	ITW             OSFamily = "ITW"
	Icom            OSFamily = "Icom"
	Icy             OSFamily = "Icy"
	Imperva         OSFamily = "Imperva"
	Infoblox        OSFamily = "Infoblox"
	Infomir         OSFamily = "Infomir"
	Infrant         OSFamily = "Infrant"
	Inova           OSFamily = "Inova"
	Instar          OSFamily = "Instar"
	Intel           OSFamily = "Intel"
	Interbell       OSFamily = "Interbell"
	Interflex       OSFamily = "Interflex"
	Intermec        OSFamily = "Intermec"
	Interpeak       OSFamily = "Interpeak"
	Intertex        OSFamily = "Intertex"
	Intracom        OSFamily = "Intracom"
	Inventel        OSFamily = "Inventel"
	Iomega          OSFamily = "Iomega"
	IronPort        OSFamily = "IronPort"
	Isilon          OSFamily = "Isilon"
	Iskratel        OSFamily = "Iskratel"
	JTEKT           OSFamily = "JTEKT"
	Joyent          OSFamily = "Joyent"
	Juniper         OSFamily = "Juniper"
	KA9Q            OSFamily = "KA9Q"
	KCorp           OSFamily = "KCorp"
	KWSoftware      OSFamily = "KW-Software"
	KabaBenzing     OSFamily = "Kaba-Benzing"
	Kaiomy          OSFamily = "Kaiomy"
	Kapsch          OSFamily = "Kapsch"
	Kartina         OSFamily = "Kartina"
	Kemp            OSFamily = "Kemp"
	Keyence         OSFamily = "Keyence"
	Kodak           OSFamily = "Kodak"
	Kongsberg       OSFamily = "Kongsberg"
	Konica          OSFamily = "Konica"
	Koukaam         OSFamily = "Koukaam"
	Kronos          OSFamily = "Kronos"
	Kyocera         OSFamily = "Kyocera"
	LG              OSFamily = "LG"
	LaCie           OSFamily = "LaCie"
	LaCrosse        OSFamily = "LaCrosse"
	LaSAT           OSFamily = "LaSAT"
	Lancom          OSFamily = "Lancom"
	Lanier          OSFamily = "Lanier"
	Lantronix       OSFamily = "Lantronix"
	Larus           OSFamily = "Larus"
	Leica           OSFamily = "Leica"
	Lenel           OSFamily = "Lenel"
	Leolink         OSFamily = "Leolink"
	LevelOne        OSFamily = "LevelOne"
	Lexmark         OSFamily = "Lexmark"
	Liebert         OSFamily = "Liebert"
	LifeSize        OSFamily = "LifeSize"
	Linksys         OSFamily = "Linksys"
	Linux           OSFamily = "Linux"
	LogiLink        OSFamily = "LogiLink"
	Logitech        OSFamily = "Logitech"
	Lorex           OSFamily = "Lorex"
	Lucent          OSFamily = "Lucent"
	Luminary        OSFamily = "Luminary"
	Luxul           OSFamily = "Luxul"
	Lyngsoe         OSFamily = "Lyngsoe"
	MGE             OSFamily = "MGE"
	MOXA            OSFamily = "MOXA"
	MPI             OSFamily = "MPI"
	Macsense        OSFamily = "Macsense"
	Maipu           OSFamily = "Maipu"
	Mapower         OSFamily = "Mapower"
	Marantz         OSFamily = "Marantz"
	McAfee          OSFamily = "McAfee"
	Meinberg        OSFamily = "Meinberg"
	Meru            OSFamily = "Meru"
	Metrix          OSFamily = "Metrix"
	MicroNet        OSFamily = "MicroNet"
	Microsoft       OSFamily = "Microsoft"
	Microware       OSFamily = "Microware"
	MikroTik        OSFamily = "MikroTik"
	Milight         OSFamily = "Milight"
	Minix           OSFamily = "Minix"
	Minolta         OSFamily = "Minolta"
	Mirapoint       OSFamily = "Mirapoint"
	Mitel           OSFamily = "Mitel"
	Mitrastar       OSFamily = "Mitrastar"
	Mitsubishi      OSFamily = "Mitsubishi"
	Modtronix       OSFamily = "Modtronix"
	Motorola        OSFamily = "Motorola"
	MusicianLink    OSFamily = "MusicianLink"
	NCR             OSFamily = "NCR"
	NEC             OSFamily = "NEC"
	NOXON           OSFamily = "NOXON"
	NRG             OSFamily = "NRG"
	NSFOCUS         OSFamily = "NSFOCUS"
	NTI             OSFamily = "NTI"
	NTT             OSFamily = "NTT"
	Nashuatec       OSFamily = "Nashuatec"
	National        OSFamily = "National"
	NeXT            OSFamily = "NeXT"
	Neopost         OSFamily = "Neopost"
	Ness            OSFamily = "Ness"
	Nest            OSFamily = "Nest"
	NetApp          OSFamily = "NetApp"
	NetBSD          OSFamily = "NetBSD"
	NetBurner       OSFamily = "NetBurner"
	NetOptics       OSFamily = "NetOptics"
	Netasq          OSFamily = "Netasq"
	Netcomm         OSFamily = "Netcomm"
	Netgear         OSFamily = "Netgear"
	Netgem          OSFamily = "Netgem"
	Netopia         OSFamily = "Netopia"
	Network         OSFamily = "Network"
	NetworkAlchemy  OSFamily = "NetworkAlchemy"
	NetworksAOK     OSFamily = "NetworksAOK"
	Neuf            OSFamily = "Neuf"
	Newave          OSFamily = "Newave"
	NexStor         OSFamily = "NexStor"
	Nexenta         OSFamily = "Nexenta"
	Nexsan          OSFamily = "Nexsan"
	Nibe            OSFamily = "Nibe"
	Nintendo        OSFamily = "Nintendo"
	NodeMCU         OSFamily = "NodeMCU"
	Nokia           OSFamily = "Nokia"
	Nomadix         OSFamily = "Nomadix"
	Nortel          OSFamily = "Nortel"
	Novatel         OSFamily = "Novatel"
	Novell          OSFamily = "Novell"
	NutOS           OSFamily = "Nut/OS"
	OSRAM           OSFamily = "OSRAM"
	Obihai          OSFamily = "Obihai"
	Ocean           OSFamily = "Ocean"
	Oki             OSFamily = "Oki"
	Olivetti        OSFamily = "Olivetti"
	Olympus         OSFamily = "Olympus"
	Omron           OSFamily = "Omron"
	On              OSFamily = "On"
	OnStor          OSFamily = "OnStor"
	Onboard         OSFamily = "Onboard"
	OneAccess       OSFamily = "OneAccess"
	OpenBSD         OSFamily = "OpenBSD"
	OpenBox         OSFamily = "OpenBox"
	Opto            OSFamily = "Opto"
	Oracle          OSFamily = "Oracle"
	Orange          OSFamily = "Orange"
	Osmosys         OSFamily = "Osmosys"
	Ouya            OSFamily = "Ouya"
	PCBSD           OSFamily = "PC-BSD"
	PCMeasure       OSFamily = "PCMeasure"
	PORTech         OSFamily = "PORTech"
	Packard         OSFamily = "Packard"
	Packet8         OSFamily = "Packet8"
	PacketFront     OSFamily = "PacketFront"
	Packeteer       OSFamily = "Packeteer"
	Palmmicro       OSFamily = "Palmmicro"
	Palo            OSFamily = "Palo"
	Panasas         OSFamily = "Panasas"
	Panasonic       OSFamily = "Panasonic"
	Papouch         OSFamily = "Papouch"
	Patton          OSFamily = "Patton"
	Peplink         OSFamily = "Peplink"
	Perfectone      OSFamily = "Perfectone"
	Perle           OSFamily = "Perle"
	Phar            OSFamily = "Phar"
	PheeNet         OSFamily = "PheeNet"
	Philips         OSFamily = "Philips"
	Phoenix         OSFamily = "Phoenix"
	Pingtel         OSFamily = "Pingtel"
	Pioneer         OSFamily = "Pioneer"
	Pirelli         OSFamily = "Pirelli"
	Planet          OSFamily = "Planet"
	Polycom         OSFamily = "Polycom"
	Precise         OSFamily = "Precise"
	Printronix      OSFamily = "Printronix"
	Priva           OSFamily = "Priva"
	Promise         OSFamily = "Promise"
	Proxim          OSFamily = "Proxim"
	QEMU            OSFamily = "QEMU"
	QNAP            OSFamily = "QNAP"
	QNX             OSFamily = "QNX"
	QTech           OSFamily = "QTech"
	Qualisys        OSFamily = "Qualisys"
	Quantum         OSFamily = "Quantum"
	Quarterdeck     OSFamily = "Quarterdeck"
	RAD             OSFamily = "RAD"
	RCA             OSFamily = "RCA"
	RF              OSFamily = "RF"
	RFSpace         OSFamily = "RF-Space"
	RGB             OSFamily = "RGB"
	RIM             OSFamily = "RIM"
	RISCOS          OSFamily = "RISCOS"
	RISE            OSFamily = "RISE"
	RSA             OSFamily = "RSA"
	Rabbit          OSFamily = "Rabbit"
	Radware         OSFamily = "Radware"
	Raritan         OSFamily = "Raritan"
	ReactOS         OSFamily = "ReactOS"
	RedM            OSFamily = "Red-M"
	Redback         OSFamily = "Redback"
	Reliable        OSFamily = "Reliable"
	Repotech        OSFamily = "Repotech"
	Revo            OSFamily = "Revo"
	Ricoh           OSFamily = "Ricoh"
	Rigol           OSFamily = "Rigol"
	Rio             OSFamily = "Rio"
	Riverbed        OSFamily = "Riverbed"
	Roberts         OSFamily = "Roberts"
	Rockwell        OSFamily = "Rockwell"
	Roku            OSFamily = "Roku"
	Ruckus          OSFamily = "Ruckus"
	RuggedCom       OSFamily = "RuggedCom"
	Ruijie          OSFamily = "Ruijie"
	SCO             OSFamily = "SCO"
	SEH             OSFamily = "SEH"
	SGI             OSFamily = "SGI"
	SMA             OSFamily = "SMA"
	SMC             OSFamily = "SMC"
	SNR             OSFamily = "SNR"
	Sagem           OSFamily = "Sagem"
	Sagemcom        OSFamily = "Sagemcom"
	Samsung         OSFamily = "Samsung"
	Sandstrom       OSFamily = "Sandstrom"
	Sanyo           OSFamily = "Sanyo"
	Sapling         OSFamily = "Sapling"
	Satel           OSFamily = "Satel"
	Savin           OSFamily = "Savin"
	Schneider       OSFamily = "Schneider"
	Schrack         OSFamily = "Schrack"
	Schweitzer      OSFamily = "Schweitzer"
	Scientific      OSFamily = "Scientific"
	Seagate         OSFamily = "Seagate"
	Secure          OSFamily = "Secure"
	Seiko           OSFamily = "Seiko"
	Senao           OSFamily = "Senao"
	Sensatronics    OSFamily = "Sensatronics"
	Sequent         OSFamily = "Sequent"
	Sharp           OSFamily = "Sharp"
	Shenzhen        OSFamily = "Shenzhen"
	ShoreTel        OSFamily = "ShoreTel"
	Siemens         OSFamily = "Siemens"
	Silicondust     OSFamily = "Silicondust"
	Sinus           OSFamily = "Sinus"
	Sipura          OSFamily = "Sipura"
	Sitecom         OSFamily = "Sitecom"
	Sling           OSFamily = "Sling"
	Slingbox        OSFamily = "Slingbox"
	Smart           OSFamily = "Smart"
	Smartlink       OSFamily = "Smartlink"
	Snom            OSFamily = "Snom"
	Solwise         OSFamily = "Solwise"
	SonicWALL       OSFamily = "SonicWALL"
	Sonos           OSFamily = "Sonos"
	Sonus           OSFamily = "Sonus"
	Sony            OSFamily = "Sony"
	Source          OSFamily = "Source"
	Specialix       OSFamily = "Specialix"
	Sphairon        OSFamily = "Sphairon"
	Star            OSFamily = "Star"
	Starbridge      OSFamily = "Starbridge"
	Stonewater      OSFamily = "Stonewater"
	StorageTek      OSFamily = "StorageTek"
	Stratus         OSFamily = "Stratus"
	Suga            OSFamily = "Suga"
	Sun             OSFamily = "Sun"
	SunPower        OSFamily = "SunPower"
	Supermicro      OSFamily = "Supermicro"
	Syllable        OSFamily = "Syllable"
	Symantec        OSFamily = "Symantec"
	Symbian         OSFamily = "Symbian"
	Symbol          OSFamily = "Symbol"
	Symmetricon     OSFamily = "Symmetricon"
	Synology        OSFamily = "Synology"
	THome           OSFamily = "T-Home"
	TMarc           OSFamily = "T-Marc"
	TPLINK          OSFamily = "TP-LINK"
	TPLink          OSFamily = "TP-Link"
	TRENDnet        OSFamily = "TRENDnet"
	Tadiran         OSFamily = "Tadiran"
	Tahoe           OSFamily = "Tahoe"
	Tandberg        OSFamily = "Tandberg"
	Tandem          OSFamily = "Tandem"
	TechniSat       OSFamily = "TechniSat"
	Tektronix       OSFamily = "Tektronix"
	Telco           OSFamily = "Telco"
	Teldat          OSFamily = "Teldat"
	Telekom         OSFamily = "Telekom"
	Telewell        OSFamily = "Telewell"
	Telex           OSFamily = "Telex"
	Telsey          OSFamily = "Telsey"
	Teltronics      OSFamily = "Teltronics"
	TenAsys         OSFamily = "TenAsys"
	Tenda           OSFamily = "Tenda"
	Teradici        OSFamily = "Teradici"
	Terratec        OSFamily = "Terratec"
	Texas           OSFamily = "Texas"
	Thales          OSFamily = "Thales"
	Thecus          OSFamily = "Thecus"
	Thomson         OSFamily = "Thomson"
	Tiandy          OSFamily = "Tiandy"
	Tibbo           OSFamily = "Tibbo"
	Tigo            OSFamily = "Tigo"
	Tintri          OSFamily = "Tintri"
	TippingPoint    OSFamily = "TippingPoint"
	Tizen           OSFamily = "Tizen"
	Topfield        OSFamily = "Topfield"
	Toptech         OSFamily = "Toptech"
	Toshiba         OSFamily = "Toshiba"
	Trane           OSFamily = "Trane"
	TransAct        OSFamily = "TransAct"
	Tranzeo         OSFamily = "Tranzeo"
	Trapeze         OSFamily = "Trapeze"
	Tripp           OSFamily = "Tripp"
	Tut             OSFamily = "Tut"
	Tyco            OSFamily = "Tyco"
	USRobotics      OSFamily = "USRobotics"
	UTStarcom       OSFamily = "UTStarcom"
	Ubee            OSFamily = "Ubee"
	Ubicom          OSFamily = "Ubicom"
	Ubiquiti        OSFamily = "Ubiquiti"
	Universal       OSFamily = "Universal"
	VBrick          OSFamily = "VBrick"
	VIPA            OSFamily = "VIPA"
	VMware          OSFamily = "VMware"
	VTrak           OSFamily = "VTrak"
	Vantage         OSFamily = "Vantage"
	Vegastream      OSFamily = "Vegastream"
	Viasat          OSFamily = "Viasat"
	Vilar           OSFamily = "Vilar"
	Virdi           OSFamily = "Virdi"
	Visual          OSFamily = "Visual"
	Vocality        OSFamily = "Vocality"
	Vodafone        OSFamily = "Vodafone"
	Vodavi          OSFamily = "Vodavi"
	Vonage          OSFamily = "Vonage"
	WandT           OSFamily = "W&T"
	WAGO            OSFamily = "WAGO"
	WIZnet          OSFamily = "WIZnet"
	Wago            OSFamily = "Wago"
	Walker          OSFamily = "Walker"
	WatchGuard      OSFamily = "WatchGuard"
	WebSense        OSFamily = "WebSense"
	Welltech        OSFamily = "Welltech"
	Westell         OSFamily = "Westell"
	Westermo        OSFamily = "Westermo"
	Western         OSFamily = "Western"
	Wind            OSFamily = "Wind"
	Windows         OSFamily = "Windows"
	World           OSFamily = "World"
	WowWee          OSFamily = "WowWee"
	Wyse            OSFamily = "Wyse"
	XAVi            OSFamily = "XAVi"
	XEUdotCom       OSFamily = "XEU.com"
	XMOS            OSFamily = "XMOS"
	Xerox           OSFamily = "Xerox"
	Xiaomi          OSFamily = "Xiaomi"
	Xirrus          OSFamily = "Xirrus"
	Xylan           OSFamily = "Xylan"
	Xyplex          OSFamily = "Xyplex"
	Yamaha          OSFamily = "Yamaha"
	Yealink         OSFamily = "Yealink"
	ZKTeco          OSFamily = "ZKTeco"
	ZTE             OSFamily = "ZTE"
	Zebra           OSFamily = "Zebra"
	Zelax           OSFamily = "Zelax"
	Zerto           OSFamily = "Zerto"
	Zhone           OSFamily = "Zhone"
	Zipato          OSFamily = "Zipato"
	ZoneAlarm       OSFamily = "ZoneAlarm"
	Zoom            OSFamily = "Zoom"
	ZyXEL           OSFamily = "ZyXEL"
	Zyfer           OSFamily = "Zyfer"
	cab             OSFamily = "cab"
	eCosCentric     OSFamily = "eCosCentric"
	iDirect         OSFamily = "iDirect"
	iPXE            OSFamily = "iPXE"
	iRobot          OSFamily = "iRobot"
	illumos         OSFamily = "illumos"
	ipTIME          OSFamily = "ipTIME"
	lwIP            OSFamily = "lwIP"
	m3              OSFamily = "m3"
	mbNet           OSFamily = "mbNet"
	nCircle         OSFamily = "nCircle"
)
