# open-source-web-scanners
A list of open source web security scanners on GitHub and GitLab (just added), ordered by Stars. It does not provide in-depth analysis - for more analysis or a wider range of tools, see the links below.

Note that some large projects have multiple repos - in which case the second most relevant repo is included immediately after.

## General Purpose Web Scanners

Tools which can find a range of 'unknown' vulnerabilities on any websites.

| Main Site | Last Commit | Committers | Stars |
| --- | --- | --- | --- |
| [ZAP](https://www.zaproxy.org) | [![Last Commit](https://img.shields.io/github/last-commit/zaproxy/zaproxy)](https://github.com/zaproxy/zaproxy/commits) | [![Contributors](https://img.shields.io/github/contributors/zaproxy/zaproxy)](https://github.com/zaproxy/zaproxy/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/zaproxy/zaproxy)](https://github.com/zaproxy/zaproxy/stargazers) |
| - [ZAP Extensions](https://github.com/zaproxy/zap-extensions) | [![Last Commit](https://img.shields.io/github/last-commit/zaproxy/zap-extensions)](https://github.com/zaproxy/zap-extensions/commits) | [![Contributors](https://img.shields.io/github/contributors/zaproxy/zap-extensions)](https://github.com/zaproxy/zap-extensions/graphs/contributors)| [![Stars](https://img.shields.io/github/stars/zaproxy/zap-extensions)](https://github.com/zaproxy/zap-extensions/stargazers) |
| [Hetty](https://hetty.xyz/) | [![Last Commit](https://img.shields.io/github/last-commit/dstotijn/hetty)](https://github.com/dstotijn/hetty/commits) | [![Contributors](https://img.shields.io/github/contributors/dstotijn/hetty)](https://github.com/dstotijn/hetty/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/dstotijn/hetty)](https://github.com/dstotijn/hetty/stargazers) |
| [W3af](http://w3af.org/) | [![Last Commit](https://img.shields.io/github/last-commit/andresriancho/w3af/develop)](https://github.com/andresriancho/w3af/commits) | [![Contributors](https://img.shields.io/github/contributors/andresriancho/w3af)](https://github.com/andresriancho/w3af/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/andresriancho/w3af)](https://github.com/andresriancho/w3af/stargazers) |
| [Arachni](https://www.arachni-scanner.com/) | [![Last Commit](https://img.shields.io/github/last-commit/Arachni/arachni)](https://github.com/Arachni/arachni/commits) | [![Contributors](https://img.shields.io/github/contributors/Arachni/arachni)](https://github.com/Arachni/arachni/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/Arachni/arachni)](https://github.com/Arachni/arachni/stargazers) |
| [Astra](https://github.com/flipkart-incubator/Astra) | [![Last Commit](https://img.shields.io/github/last-commit/flipkart-incubator/Astra)](https://github.com/flipkart-incubator/Astra/commits) | [![Contributors](https://img.shields.io/github/contributors/flipkart-incubator/Astra)](https://github.com/flipkart-incubator/Astra/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/flipkart-incubator/Astra)](https://github.com/flipkart-incubator/Astra/stargazers) |
| [Skipfish](https://code.google.com/archive/p/skipfish/) | [![Last Commit](https://img.shields.io/github/last-commit/spinkham/skipfish)](https://github.com/spinkham/skipfish/commits) | [![Contributors](https://img.shields.io/github/contributors/spinkham/skipfish)](https://github.com/spinkham/skipfish/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/spinkham/skipfish)](https://github.com/spinkham/skipfish/stargazers) |
| [Sitadel](https://github.com/shenril/Sitadel) | [![Last Commit](https://img.shields.io/github/last-commit/shenril/Sitadel)](https://github.com/shenril/Sitadel/commits) | [![Contributors](https://img.shields.io/github/contributors/shenril/Sitadel)](https://github.com/shenril/Sitadel/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/shenril/Sitadel)](https://github.com/shenril/Sitadel/stargazers) |
| [Taipan](https://github.com/enkomio/Taipan) | [![Last Commit](https://img.shields.io/github/last-commit/enkomio/Taipan)](https://github.com/enkomio/Taipan/commits) | [![Contributors](https://img.shields.io/github/contributors/enkomio/Taipan)](https://github.com/enkomio/Taipan/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/enkomio/Taipan)](https://github.com/enkomio/Taipan/stargazers) |
| [Wapiti](https://wapiti-scanner.github.io/) | [![Last Commit](https://img.shields.io/github/last-commit/wapiti-scanner/wapiti)](https://github.com/wapiti-scanner/wapiti/commits) | [![Contributors](https://img.shields.io/github/contributors/wapiti-scanner/wapiti)](https://github.com/wapiti-scanner/wapiti/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/wapiti-scanner/wapiti)](https://github.com/wapiti-scanner/wapiti/stargazers) |
| [Vega](https://subgraph.com/vega/) | [![Last Commit](https://img.shields.io/github/last-commit/subgraph/Vega)](https://github.com/subgraph/Vega/commits) | [![Contributors](https://img.shields.io/github/contributors/subgraph/Vega)](https://github.com/subgraph/Vega/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/subgraph/Vega)](https://github.com/subgraph/Vega/stargazers) |
| [Tuplar](https://github.com/tulpar/tulpar) | [![Last Commit](https://img.shields.io/github/last-commit/tulpar/tulpar)](https://github.com/tulpar/tulpar/commits) | [![Contributors](https://img.shields.io/github/contributors/tulpar/tulpar)](https://github.com/tulpar/tulpar/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/tulpar/tulpar)](https://github.com/tulpar/tulpar/stargazers) |
| [Ugly-duckling](https://github.com/detectify/ugly-duckling) | [![Last Commit](https://img.shields.io/github/last-commit/detectify/ugly-duckling)](https://github.com/detectify/ugly-duckling/commits) | [![Contributors](https://img.shields.io/github/contributors/detectify/ugly-duckling)](https://github.com/detectify/ugly-duckling/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/detectify/ugly-duckling)](https://github.com/detectify/ugly-duckling/stargazers) |
| [Jawfish](https://github.com/war-and-code/jawfish) | [![Last Commit](https://img.shields.io/github/last-commit/war-and-code/jawfish)](https://github.com/war-and-code/jawfishO/commits) | [![Contributors](https://img.shields.io/github/contributors/war-and-code/jawfish)](https://github.com/war-and-code/jawfish/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/war-and-code/jawfish)](https://github.com/war-and-code/jawfish/stargazers) |
| [Browserker](https://gitlab.com/wirepair/browserker/) | [![Last Commit](https://badgen.net/gitlab/last-commit/wirepair/browserker)](https://gitlab.com/wirepair/browserker/-/commits/master) | [![Contributors](https://badgen.net/gitlab/contributors/wirepair/browserker/)](https://gitlab.com/wirepair/browserker/-/graphs/master) | [![Stars](https://badgen.net/gitlab/stars/wirepair/browserker/)](https://gitlab.com/wirepair/browserker/-/starrers) |

## Infrastructure Web Scanners

Tools which can find a range of 'known' vulnerabilities on any websites.

| Main Site | Last Commit | Committers | Stars |
| --- | --- | --- | --- |
| [Nuclei](https://nuclei.projectdiscovery.io/) | [![Last Commit](https://img.shields.io/github/last-commit/projectdiscovery/nuclei)](https://github.com/projectdiscovery/nuclei/commits) | [![Contributors](https://img.shields.io/github/contributors/projectdiscovery/nuclei)](https://github.com/projectdiscovery/nuclei/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/projectdiscovery/nuclei)](https://github.com/projectdiscovery/nuclei/stargazers) |
| - [Nuclei Templates](https://github.com/projectdiscovery/nuclei-templates/) | [![Last Commit](https://img.shields.io/github/last-commit/projectdiscovery/nuclei-templates)](https://github.com/projectdiscovery/nuclei-templates/commits) | [![Contributors](https://img.shields.io/github/contributors/projectdiscovery/nuclei-templates)](https://github.com/projectdiscovery/nuclei-templates/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/projectdiscovery/nuclei-templates)](https://github.com/projectdiscovery/nuclei-templates/stargazers) |
| [Tsunami](https://github.com/google/tsunami-security-scanner) | [![Last Commit](https://img.shields.io/github/last-commit/google/tsunami-security-scanner)](https://github.com/google/tsunami-security-scanner/commits) | [![Contributors](https://img.shields.io/github/contributors/google/tsunami-security-scanner)](https://github.com/google/tsunami-security-scanner/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/google/tsunami-security-scanner)](https://github.com/google/tsunami-security-scanner/stargazers) |
| [Nikto](https://cirt.net/Nikto2) | [![Last Commit](https://img.shields.io/github/last-commit/sullo/nikto)](https://github.com/sullo/nikto/commits) | [![Contributors](https://img.shields.io/github/contributors/sullo/nikto)](https://github.com/sullo/nikto/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/sullo/nikto)](https://github.com/sullo/nikto/stargazers) |
| [Striker](https://github.com/s0md3v/Striker) | [![Last Commit](https://img.shields.io/github/last-commit/s0md3v/Striker)](https://github.com/s0md3v/Striker/commits) | [![Contributors](https://img.shields.io/github/contributors/s0md3v/Striker)](https://github.com/s0md3v/Striker/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/s0md3v/Striker)](https://github.com/s0md3v/Striker/stargazers) |
| [Jaeles](https://github.com/jaeles-project/jaeles) | [![Last Commit](https://img.shields.io/github/last-commit/jaeles-project/jaeles)](https://github.com/jaeles-project/jaeles/commits) | [![Contributors](https://img.shields.io/github/contributors/jaeles-project/jaeles)](https://github.com/jaeles-project/jaeles/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/jaeles-project/jaeles)](https://github.com/jaeles-project/jaeles/stargazers) |
| - [Jaeles-Signatures](https://github.com/jaeles-project/jaeles-signatures) | [![Last Commit](https://img.shields.io/github/last-commit/jaeles-project/jaeles-signatures)](https://github.com/jaeles-project/jaeles-signatures/commits) | [![Contributors](https://img.shields.io/github/contributors/jaeles-project/jaeles-signatures)](https://github.com/jaeles-project/jaeles-signatures/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/jaeles-project/jaeles-signatures)](https://github.com/jaeles-project/jaeles-signatures/stargazers) |
| [Yasuo](https://github.com/0xsauby/yasuo) | [![Last Commit](https://img.shields.io/github/last-commit/0xsauby/yasuo)](https://github.com/0xsauby/yasuo/commits) | [![Contributors](https://img.shields.io/github/contributors/0xsauby/yasuo)](https://github.com/0xsauby/yasuo/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/0xsauby/yasuo)](https://github.com/0xsauby/yasuo/stargazers) |
| [Observatory](https://observatory.mozilla.org/) | [![Last Commit](https://img.shields.io/github/last-commit/mozilla/http-observatory-website)](https://github.com/mozilla/http-observatory-website/commits) | [![Contributors](https://img.shields.io/github/contributors/mozilla/http-observatory-website)](https://github.com/mozilla/http-observatory-website/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/mozilla/http-observatory-website)](https://github.com/mozilla/http-observatory-website/stargazers) |
| [Spaghetti](https://github.com/infosecsecurity/Spaghetti) | [![Last Commit](https://img.shields.io/github/last-commit/infosecsecurity/Spaghetti)](https://github.com/infosecsecurity/Spaghetti/commits) | [![Contributors](https://img.shields.io/github/contributors/infosecsecurity/Spaghetti)](https://github.com/infosecsecurity/Spaghetti/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/infosecsecurity/Spaghetti)](https://github.com/infosecsecurity/Spaghetti/stargazers) |

## Fuzzers / Brute Forcers

Tools which focus on throwing 'bad stuff' at things - the user typically has to work out if it sticks.

| Main Site | Last Commit | Committers | Stars |
| --- | --- | --- | --- |
| [dirsearch](https://github.com/maurosoria/dirsearch) | [![Last Commit](https://img.shields.io/github/last-commit/maurosoria/dirsearch)](https://github.com/maurosoria/dirsearch/commits) | [![Contributors](https://img.shields.io/github/contributors/maurosoria/dirsearch)](https://github.com/maurosoria/dirsearch/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/maurosoria/dirsearch)](https://github.com/maurosoria/dirsearch/stargazers) |
| [Ffuf](https://github.com/ffuf/ffuf) | [![Last Commit](https://img.shields.io/github/last-commit/ffuf/ffuf)](https://github.com/ffuf/ffuf/commits) | [![Contributors](https://img.shields.io/github/contributors/ffuf/ffuf)](https://github.com/ffuf/ffuf/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/ffuf/ffuf)](https://github.com/ffuf/ffuf/stargazers) |
| [gobuster](https://github.com/OJ/gobuster) | [![Last Commit](https://img.shields.io/github/last-commit/OJ/gobuster)](https://github.com/OJ/gobuster/commits) | [![Contributors](https://img.shields.io/github/contributors/OJ/gobuster)](https://github.com/OJ/gobuster/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/OJ/gobuster)](https://github.com/OJ/gobuster/stargazers) |
| [Wfuzz](https://wfuzz.readthedocs.io/en/latest/) | [![Last Commit](https://img.shields.io/github/last-commit/xmendez/wfuzz)](https://github.com/xmendez/wfuzz/commits) | [![Contributors](https://img.shields.io/github/contributors/xmendez/wfuzz)](https://github.com/xmendez/wfuzz/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/xmendez/wfuzz)](https://github.com/xmendez/wfuzz/stargazers) |
| [feroxbuster](https://github.com/epi052/feroxbuster) | [![Last Commit](https://img.shields.io/github/last-commit/epi052/feroxbuster)](https://github.com/epi052/feroxbuster/commits) | [![Contributors](https://img.shields.io/github/contributors/epi052/feroxbuster)](https://github.com/epi052/feroxbuster/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/epi052/feroxbuster)](https://github.com/epi052/feroxbuster/stargazers) |
| [rustbusterv](https://github.com/phra/rustbuster) | [![Last Commit](https://img.shields.io/github/last-commit/phra/rustbuster)](https://github.com/phra/rustbuster/commits) | [![Contributors](https://img.shields.io/github/contributors/phra/rustbuster)](https://github.com/phra/rustbuster/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/phra/rustbuster)](https://github.com/phra/rustbuster/stargazers) |
| [vaf](https://github.com/d4rckh/vaf) | [![Last Commit](https://img.shields.io/github/last-commit/d4rckh/vaf)](https://github.com/d4rckh/vaf/commits) | [![Contributors](https://img.shields.io/github/contributors/d4rckh/vaf)](https://github.com/d4rckh/vaf/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/d4rckh/vaf)](https://github.com/d4rckh/vaf/stargazers) |

## CMS Web Scanners

Tools which can find a range of 'known' vulnerabilities on one or more CMS websites.

| Main Site | Last Commit | Committers | Stars |
| --- | --- | --- | --- |
| [WPscan](https://wpscan.org/) | [![Last Commit](https://img.shields.io/github/last-commit/wpscanteam/wpscan)](https://github.com/wpscanteam/wpscan/commits) | [![Contributors](https://img.shields.io/github/contributors/wpscanteam/wpscan)](https://github.com/wpscanteam/wpscan/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/wpscanteam/wpscan)](https://github.com/wpscanteam/wpscan/stargazers) |
| [Volnx](https://github.com/anouarbensaad/vulnx) | [![Last Commit](https://img.shields.io/github/last-commit/anouarbensaad/vulnx)](https://github.com/anouarbensaad/vulnx/commits) | [![Contributors](https://img.shields.io/github/contributors/anouarbensaad/vulnx)](https://github.com/anouarbensaad/vulnx/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/anouarbensaad/vulnx)](https://github.com/anouarbensaad/vulnx/stargazers) |
| [Droopescan](https://github.com/SamJoan/droopescan) | [![Last Commit](https://img.shields.io/github/last-commit/SamJoan/droopescan)](https://github.com/SamJoan/droopescan/commits) | [![Contributors](https://img.shields.io/github/contributors/SamJoan/droopescan)](https://github.com/SamJoan/droopescan/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/SamJoan/droopescan)](https://github.com/SamJoan/droopescan/stargazers) |
| [CMSScan](https://github.com/ajinabraham/CMSScan) | [![Last Commit](https://img.shields.io/github/last-commit/ajinabraham/CMSScan)](https://github.com/ajinabraham/CMSScan/commits) | [![Contributors](https://img.shields.io/github/contributors/ajinabraham/CMSScan)](https://github.com/ajinabraham/CMSScan/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/ajinabraham/CMSScan)](https://github.com/ajinabraham/CMSScan/stargazers) |
| [JoomScan](https://wiki.owasp.org/index.php/Category:OWASP_Joomla_Vulnerability_Scanner_Project) | [![Last Commit](https://img.shields.io/github/last-commit/OWASP/joomscan)](https://github.com/OWASP/joomscan/commits) | [![Contributors](https://img.shields.io/github/contributors/OWASP/joomscan)](https://github.com/OWASP/joomscan/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/OWASP/joomscan)](https://github.com/OWASP/joomscan/stargazers) |
| [Clusterd](https://github.com/hatRiot/clusterd) | [![Last Commit](https://img.shields.io/github/last-commit/hatRiot/clusterd)](https://github.com/hatRiot/clusterd/commits) | [![Contributors](https://img.shields.io/github/contributors/hatRiot/clusterd)](https://github.com/hatRiot/clusterd/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/hatRiot/clusterd)](https://github.com/hatRiot/clusterd/stargazers) |

## API Web Scanners

Tools which focus on web APIs.

| Main Site | Last Commit | Committers | Stars |
| --- | --- | --- | --- |
| [Cherrybomb](https://github.com/blst-security/cherrybomb) | [![Last Commit](https://img.shields.io/github/last-commit/blst-security/cherrybomb)](https://github.com/blst-security/cherrybomb/commits) | [![Contributors](https://img.shields.io/github/contributors/blst-security/cherrybomb)](https://github.com/blst-security/cherrybomb/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/blst-security/cherrybomb)](https://github.com/blst-security/cherrybomb/stargazers) |
| [Automatic API Attack Tool](https://github.com/imperva/automatic-api-attack-tool) | [![Last Commit](https://img.shields.io/github/last-commit/imperva/automatic-api-attack-tool)](https://github.com/imperva/automatic-api-attack-tool/commits) | [![Contributors](https://img.shields.io/github/contributors/imperva/automatic-api-attack-tool)](https://github.com/imperva/automatic-api-attack-tool/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/imperva/automatic-api-attack-tool)](https://github.com/imperva/automatic-api-attack-tool/stargazers) |

## Specialised Scanners

Tools which focus on specific types of vulnerabilities.

| Main Site | Last Commit | Committers | Stars |
| --- | --- | --- | --- |
| [Sqlmap](https://sqlmap.org/) | [![Last Commit](https://img.shields.io/github/last-commit/sqlmapproject/sqlmap)](https://github.com/sqlmapproject/sqlmap/commits) | [![Contributors](https://img.shields.io/github/contributors/sqlmapproject/sqlmap)](https://github.com/sqlmapproject/sqlmap/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/sqlmapproject/sqlmap)](https://github.com/sqlmapproject/sqlmap/stargazers) |
| [Comix](https://github.com/commixproject/commix) | [![Last Commit](https://img.shields.io/github/last-commit/commixproject/commix)](https://github.com/commixproject/commix/commits) | [![Contributors](https://img.shields.io/github/contributors/commixproject/commix)](https://github.com/commixproject/commix/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/commixproject/commix)](https://github.com/commixproject/commix/stargazers) |
| [Xsscrapy](https://github.com/DanMcInerney/xsscrapy) | [![Last Commit](https://img.shields.io/github/last-commit/DanMcInerney/xsscrapy)](https://github.com/DanMcInerney/xsscrapy/commits) | [![Contributors](https://img.shields.io/github/contributors/DanMcInerney/xsscrapy)](https://github.com/DanMcInerney/xsscrapy/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/DanMcInerney/xsscrapy)](https://github.com/DanMcInerney/xsscrapy/stargazers) |
| [Domdig](https://github.com/fcavallarin/domdig) | [![Last Commit](https://img.shields.io/github/last-commit/fcavallarin/domdig)](https://github.com/fcavallarin/domdig/commits) | [![Contributors](https://img.shields.io/github/contributors/fcavallarin/domdig)](https://github.com/USER_REPO/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/fcavallarin/domdig)](https://github.com/fcavallarin/domdig/stargazers) |

## Links

* [Free for Open Source Application Security Tools](https://owasp.org/www-community/Free_for_Open_Source_Application_Security_Tools) - includes commercial tools as well
* [Vulnerability Scanning Tools](https://owasp.org/www-community/Vulnerability_Scanning_Tools) - covers more tools, includes commercial tools as well
* [Linux Security Tools](https://linuxsecurity.expert/security-tools/) - covers more tools and evaluates more criteria
* [Web Hackers Weapons](https://github.com/hahwul/WebHackersWeapons) - covers more tools
* [Arsenal of cloud native security tools](https://www.marcolancini.it/2018/blog-arsenal-cloud-native-security-tools/)

## Contribute

PR's welcomed.

Template line for GitHub projects (replace USER_REPO):
```
| []() | [![Last Commit](https://img.shields.io/github/last-commit/USER_REPO)](https://github.com/USER_REPO/commits) | [![Contributors](https://img.shields.io/github/contributors/USER_REPO)](https://github.com/USER_REPO/graphs/contributors) | [![Stars](https://img.shields.io/github/stars/USER_REPO)](https://github.com/USER_REPO/stargazers) |
```
Template line for GitLab projects (replace USER_REPO):
```
| []() | [![Last Commit](https://badgen.net/gitlab/last-commit/USER_REPO)](https://gitlab.com/USER_REPO/-/commits/master) | [![Contributors](https://badgen.net/gitlab/contributors/USER_REPO/)](https://gitlab.com/USER_REPO/-/graphs/master) | [![Stars](https://badgen.net/gitlab/stars/USER_REPO/)](https://gitlab.com/USER_REPO/-/starrers) |
```