<p align="center">
  <a href="http://afrog.net"><img src="images/afrog-logo.svg" width="60px" alt="afrog"></a>
</p>
<!-- </a> <h1 align="center">afrog</h1> -->

<h4 align="center">A Security Tool for Bug Bounty, Pentest and Red Teaming</h4>

<p align="center">
<img src="https://img.shields.io/github/go-mod/go-version/zan8in/afrog/v2?filename=go.mod">
<a href="https://github.com/zan8in/afrog/releases"><img src="https://img.shields.io/github/downloads/zan8in/afrog/total">
<a href="https://github.com/zan8in/afrog/graphs/contributors"><img src="https://img.shields.io/github/contributors-anon/zan8in/afrog">
<a href="https://github.com/zan8in/afrog/releases/"><img src="https://img.shields.io/github/release/zan8in/afrog">
<a href="https://github.com/zan8in/afrog/issues"><img src="https://img.shields.io/github/issues-raw/zan8in/afrog">
<a href="https://github.com/zan8in/afrog/discussions"><img src="https://img.shields.io/github/discussions/zan8in/afrog">
</p>

<p align="center" dir="auto">
  <a href="https://github.com/zan8in/afrog/releases">Download</a> •
  <a href="https://github.com/zan8in/afrog/wiki">Wiki</a> •
  <a href="https://github.com/zan8in/afrog/blob/main/afrog-helper-function.md">Helper Function</a>

</p>

## PoC Contributors

<div><table frame=void>
	<tr>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/1.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://blog.csdn.net/U_U520"><sub>不动明王</sub></a>
        </td>    
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/2.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://www.linuxlz.com/"><sub>雪山</sub></a>
        </td> 
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/3.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/White-hua"><sub>White-hua</sub></a>
        </td> 
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/5.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0)"><sub>123456</sub></a>
        </td> 
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/6.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/ifofor"><sub>ifofor</sub></a>
        </td> 
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/7.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/SkinAir"><sub>Air</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/8.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/zhizhuoshuma"><sub>执着</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/4.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/purple-WL"><sub>purple-WL</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/9.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>throat</sub></a>
        </td>
	</tr>
    <tr>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/10.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="http://secx.store:4000/archives/"><sub>Secx</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/11.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/yueyu0740"><sub>冰河</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/12.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>Sheen</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/13.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>a16</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/14.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>A1</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/15.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/rainbow2972"><sub>rainbow2972</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/16.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/wuha0926"><sub>wuha0926</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/17.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>茄子</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/18.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>lei_sec</sub></a>
        </td>
	</tr>	
    <tr>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/19.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/G-H-Z"><sub>G-H-Z</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/20.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/LDDP"><sub>wh1te</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/21.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>清月</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/22.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>york</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/23.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>7eleven.eth</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/24.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/Double-q1015"><sub>Double...</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/25.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/iceyjchen"><sub>ICEY_</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/26.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/Ablackcatlazy"><sub>lazy</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/27.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/Lay0us1"><sub>Lay0us</sub></a>
        </td>
    </tr>	
    <tr>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/28.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>m4sk</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/29.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://www.yuque.com/chenmoshuren/qyxg2k"><sub>沉默树人</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/30.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>陈麻子</sub></a>
        </td>
         <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/31.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/leonardo-o1"><sub>leonardo-o1</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/32.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>江湖人称魏...</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/33.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>若兮风</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/34.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>-sudo</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/35.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/Cuerz"><sub>Cuerz</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/36.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>laohuan12138</sub></a>
        </td>
    </tr>
    <tr>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/37.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/exp0l0zzz"><sub>exp0l0zzz</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/38.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/1derian"><sub>1derian</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/39.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/CMDB-M"><sub>CMDB-M</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/40.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:(0);"><sub>li1u</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/41.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/oxsonder"><sub>oxsonder</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/42.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>Zhiliao</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/43.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>段</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/44.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/HuiTaiL6"><sub>HuiTaiL</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/45.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/Miracles666"><sub>Miracles666</sub></a>
        </td>
    </td>
     <tr>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/46.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>Observer</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/47.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>黑熊</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/48.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>TryA9ain</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/49.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/fgz00"><sub>fgz00</sub></a>
        </td>
         <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/50.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/Y3y1ng"><sub>Y3y1ng</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/51.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>二大爷</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/52.png&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/wanswu"><sub>Wans</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/53.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="https://github.com/hbdxmz"><sub>海边的小米粥</sub></a>
        </td>
        <td align="center">
            <img src="https://images.weserv.nl/?url=raw.githubusercontent.com/zan8in/afrog/main/images/contributors/54.jpg&mask=circle&w=60&h=60"
                   alt="Typora-Logo"
                 />
            <br>
            <a href="javascript:void(0);"><sub>Wen</sub></a>
        </td>
    </tr>
</table></div>



## What is afrog

afrog is a high-performance vulnerability scanner that is fast and stable. It supports user-defined PoC and comes with several built-in types, such as CVE, CNVD, default passwords, information disclosure, fingerprint identification, unauthorized access, arbitrary file reading, and command execution. With afrog, network security professionals can quickly validate and remediate vulnerabilities, which helps to enhance their security defense capabilities.

## Features

* [x] Open source
* [x] Fast, stable, with low false positives
* [x] Detailed HTML vulnerability reports
* [x] Customizable and stably updatable PoCs
* [x] Active community exchange group

## Installation

### Prerequisites

- [Go](https://go.dev/) version 1.19 or higher.

you can install it with:

**Binary**
```sh
$ https://github.com/zan8in/afrog/releases
```

**Github**
```sh
$ git clone https://github.com/zan8in/afrog.git
$ cd afrog
$ go build cmd/afrog/main.go
$ ./afrog -h
```

**Go**
```sh
$ go install -v github.com/zan8in/afrog/v2/cmd/afrog@latest
```

## Running afrog

By default, afrog scans all built-in PoCs, and if it finds any vulnerabilities, it automatically creates an HTML report with the date of the scan as the filename.

```sh
afrog -t https://example.com
```

**Warning occurs when running afrog**

If you see an error message saying:
```
[ERR] ceye reverse service not set: /home/afrog/.config/afrog/afrog-config.yaml
```
it means you need to modify the [configuration file](#configuration-file).

To execute a custom PoC directory, you can use the following command:

```sh
afrog -t https://example.com -P mypocs/
```

Use the command `-s keyword` to perform a fuzzy search on all PoCs and scan the search results. Multiple keywords can be used, separated by commas. For example: `-s weblogic,jboss`.

```sh
afrog -t https://example.com -s weblogic,jboss
```

Use the command `-S keyword` to scan vulnerabilities based on their severity level. Severity levels include: `info`, `low`, `medium`, `high`, and `critical`. For example, to only scan high and critical vulnerabilities, use the command `-S high,critical`.

```sh
afrog -t https://example.com -S high,critical
```

You can scan multiple URLs at the same time as well.

```sh
afrog -T urls.txt
```

## Configuration file

The first time you start afrog, it will automatically create a configuration file called `afrog-config.yaml`, which will be saved in the current user directory under `$HOME/.config/afrog/afrog-config.yaml`.

Here is an example config file:

```yaml
reverse:
  ceye:
    api-key: "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
    domain: "xxxxxx.ceye.io"
  jndi:
    jndi_address: "x.x.x.x"
    ldap_port: "1389"
    api_port: "34567"
```

`reverse` is a reverse connection platform used to verify command execution vulnerabilities that cannot be echoed back. Currently, only ceye can be used for verification. 

### Ceye Configuration
To obtain ceye, follow these steps:

- Go to the [ceye.io](http://ceye.io/) website and register an account.
- Log in and go to the personal settings page.
- Copy the `domain` and `api-key` and correctly configure them in the `afrog-config.yaml` file.

### JNDI Configuration

The JNDI vulnerability refers to security vulnerabilities that exploit the JNDI (Java Naming and Directory Interface) functionality in Java applications. This type of vulnerability can lead to remote code execution or other security issues.

To obtain JNDI, follow these steps:

- To obtain the source code and compile the JAR file, please visit the official website [github.com/r00tSe7en/JNDIMonitor](https://github.com/r00tSe7en/JNDIMonitor). Alternatively, you can go to the official afrog website [afrog/helper/jndi](https://github.com/zan8in/afrog/tree/main/helper/jndi) to download the pre-compiled JAR file
- Upload the `JNDIMonitor-2.0.1-SNAPSHOT.jar` file to the server (such as a VPS server), and execute the following startup command:

```sh
java -jar ./JNDIMonitor-2.0.1-SNAPSHOT.jar -i 0.0.0.0 -l 1389 -p 3456
```

Below are example methods for writing POCs. [Please click to view](https://github.com/zan8in/afrog/wiki/Examples#solr-log4j-rce).

## Json Output (For developers)

### Json
Optional command: `-json` `-j`, Save the scan results to a JSON file. The JSON file includes the following contents by default: `target`, `fulltarget`, `id`, and `info`. The info field includes the following sub-fields: `name`, `author`, `severity`, `description`, and `reference`. If you want to save both `request` and `response` contents, please use the [-json-all](#jsonall) command parameter.

```sh
afrog  -t https://example.com -json result.json
afrog  -t https://example.com -j result.json
```

### Warning
The content of the JSON file is updated in real time. However, there is an important note to keep in mind: before the scan is completed, if developers want to parse the file content, they need to add a '`]`' symbol to the end of the file by themselves, otherwise it will cause parsing errors. Of course, if you wait for the scan to complete before parsing the file, this issue will not occur.

### JsonAll

Optional command: `-json-all` `-ja`, The only difference between the `-json-all` and `-json` commands is that `-json-all` writes all vulnerability results, including `request` and `response`, to a JSON file.

```sh
afrog -t https://example.com -json-all result.json
afrog -t https://example.com -ja result.json
```


## Screenshot

![](https://github.com/zan8in/afrog/blob/main/images/1.png)

<!-- ![](https://github.com/zan8in/afrog/blob/main/images/report-new.png) -->

## As Library

### Simple Example

Scan the website `http://example.com`

```golang
package main

import (
	"fmt"

	"github.com/zan8in/afrog/v2"
)

func main() {
	if err := afrog.NewScanner([]string{"http://example.com"}, afrog.Scanner{}); err != nil {
		fmt.Println(err.Error())
	}
}

```

More examples:

- [Basic scanner](examples/basic_scan/main.go)
- [Read URL batch scan from file](examples/batch_scan/main.go)

## Discussion group

To join the afrog communication group on WeChat, please first add the afrog personal account and mark it as **afrog**. Then, you will be added to the group by the administrator.

<img src="https://github.com/zan8in/afrog/blob/main/images/discussion.jpg" width="33%" />

## 404Starlink
<img src="https://github.com/knownsec/404StarLink-Project/raw/master/logo.png" width="30%">

afrog has joined [404Starlink](https://github.com/knownsec/404StarLink)

## Disclaimer

This tool is intended only for **legally authorized** enterprise security construction purposes. If you want to test the functionality of this tool, you should build a target environment by yourself.

To prevent malicious use, all PoCs included in this project are theoretical assessments of vulnerabilities. The tool does not exploit vulnerabilities, launch real attacks or exploits on targets.

When using this tool for vulnerability scanning, it is important to ensure that your behavior complies with local laws and regulations, and that you have obtained sufficient authorization. **Do not scan unauthorized targets**.

If you engage in any illegal behavior while using this tool, you will be solely responsible for any corresponding consequences, and we will not bear any legal or joint responsibility.

Before installing and using this tool, please **read each clause carefully and thoroughly**. Restrictions, disclaimers, or other clauses that may significantly affect your rights and interests may be highlighted in bold or underlined to draw your attention. Unless you have fully read, fully understood, and agreed to all the terms of this agreement, do not install or use this tool. Your use of the tool or your acceptance of this agreement in any other express or implied manner will be deemed as your acknowledgment and agreement to be bound by this agreement.