using System;
using System.Globalization;
using System.Security.Cryptography;
using System.Text;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	internal class Reg
	{
		private static bool _RegOK = false;

		public static string RegUser = "";

		public static int LeftDays = 30;

		public static bool A1K3
		{
			get
			{
				return _RegOK;
			}
			set
			{
				_RegOK = value;
			}
		}

		private static string GetMD5Hash(string Source)
		{
			//IL_000c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0012: Expected O, but got Unknown
			byte[] bytes = Encoding.UTF8.GetBytes(Source);
			MD5 val = (MD5)new MD5CryptoServiceProvider();
			byte[] value = ((HashAlgorithm)val).ComputeHash(bytes);
			string text = BitConverter.ToString(value).Replace("-", "");
			return text.Substring(8, 16);
		}

		private static uint String2UInt32(string Str)
		{
			try
			{
				string mD5Hash = GetMD5Hash(Str);
				ulong num = ulong.Parse(mD5Hash, NumberStyles.HexNumber);
				return (uint)(num % 1000000uL);
			}
			catch
			{
				return 0u;
			}
		}

		public static bool ValidateRegCode2(string Username, string RegCode)
		{
			//IL_0091: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (RegCode.IndexOf('-') <= 0)
				{
					return false;
				}
				string[] array = RegCode.Split(new char[1]
				{
					'-'
				});
				if (array.Length != 2)
				{
					return false;
				}
				string str = array[0];
				string s = array[1];
				uint num = String2UInt32(str);
				uint num2 = uint.Parse(s);
				string source = (num2 - num).ToString();
				string mD5Hash = GetMD5Hash(source);
				if (mD5Hash.Equals("B1B77A53F0264B1D"))
				{
					_RegOK = true;
					RegUser = Username;
					return true;
				}
				return false;
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
				return false;
			}
		}

		public static bool ValidateRegCode(string Username, string RegCode)
		{
			//IL_00b0: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (RegCode.Length != 19)
				{
					return false;
				}
				char[] array = RegCode.ToCharArray();
				if (array[4] != '-')
				{
					return false;
				}
				if (array[9] != '-')
				{
					return false;
				}
				if (array[14] != '-')
				{
					return false;
				}
				RegCode = RegCode.Replace("-", "");
				ulong num = Hash2UInt64(RegCode);
				string hash = GetHash(Username);
				ulong num2 = Hash2UInt64(hash);
				string source = (num - num2).ToString();
				string hash2 = GetHash(source);
				if (hash2.Equals("1FEDF23C6CB786AA"))
				{
					_RegOK = true;
					RegUser = Username;
					return true;
				}
				return false;
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
				return false;
			}
		}

		private static ulong Hash2UInt64(string Str)
		{
			try
			{
				return ulong.Parse(Str, NumberStyles.HexNumber);
			}
			catch
			{
				return 0uL;
			}
		}

		private static string GetHash(string Source)
		{
			//IL_000c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0012: Expected O, but got Unknown
			byte[] bytes = Encoding.UTF8.GetBytes(Source);
			SHA512 val = (SHA512)new SHA512Managed();
			byte[] value = ((HashAlgorithm)val).ComputeHash(bytes);
			string text = BitConverter.ToString(value).Replace("-", "");
			char[] array = text.ToCharArray();
			StringBuilder stringBuilder = new StringBuilder();
			for (int i = 0; i < 128; i++)
			{
				if (i % 8 == 0)
				{
					stringBuilder.Append(array[i].ToString());
				}
			}
			return stringBuilder.ToString();
		}

		public static string Encrypt(string toEncrypt)
		{
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0022: Expected O, but got Unknown
			byte[] bytes = Encoding.UTF8.GetBytes("WebCruiser1.00ByHttp:Sec4app.com");
			byte[] bytes2 = Encoding.UTF8.GetBytes(toEncrypt);
			RijndaelManaged val = new RijndaelManaged();
			((SymmetricAlgorithm)val).set_Key(bytes);
			((SymmetricAlgorithm)val).set_Mode((CipherMode)2);
			((SymmetricAlgorithm)val).set_Padding((PaddingMode)2);
			ICryptoTransform val2 = ((SymmetricAlgorithm)val).CreateEncryptor();
			byte[] array = val2.TransformFinalBlock(bytes2, 0, bytes2.Length);
			return Convert.ToBase64String(array, 0, array.Length);
		}

		public static string Decrypt(string toDecrypt)
		{
			//IL_0017: Unknown result type (might be due to invalid IL or missing references)
			//IL_001d: Expected O, but got Unknown
			byte[] bytes = Encoding.UTF8.GetBytes("WebCruiser1.00ByHttp:Sec4app.com");
			byte[] array = Convert.FromBase64String(toDecrypt);
			RijndaelManaged val = new RijndaelManaged();
			((SymmetricAlgorithm)val).set_Key(bytes);
			((SymmetricAlgorithm)val).set_Mode((CipherMode)2);
			((SymmetricAlgorithm)val).set_Padding((PaddingMode)2);
			ICryptoTransform val2 = ((SymmetricAlgorithm)val).CreateDecryptor();
			byte[] bytes2 = val2.TransformFinalBlock(array, 0, array.Length);
			return Encoding.UTF8.GetString(bytes2);
		}
	}
}
