using System;
using System.ComponentModel;
using System.Configuration;
using System.Drawing;
using System.Resources;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	public class FormSetting : Form
	{
		private IContainer components;

		private ToolStrip toolStripSetting;

		private ToolStripSeparator toolStripSeparator1;

		private TabControl tabSetting;

		private TabPage tabProxy;

		private Label label10;

		private CheckBox chkUseProxy;

		private TextBox txtProxyPassword;

		private TextBox txtProxyUsername;

		private Label label4;

		private Label label3;

		private TextBox txtProxyPort;

		private Label label2;

		private Label label1;

		private TextBox txtProxyAddr;

		private TabPage tabAdvanced;

		private TextBox txtRepExpr3;

		private Label label12;

		private TextBox txtFiltExpr3;

		private CheckBox chkReplace3;

		private TextBox txtRepExpr2;

		private Label label9;

		private TextBox txtFiltExpr2;

		private CheckBox chkReplace2;

		private TextBox txtRepExpr1;

		private Label label5;

		private TextBox txtFiltExpr1;

		private CheckBox chkReplace1;

		private TabPage tabScanner;

		private TabPage tabAccess;

		private TextBox txtAccessColumns;

		private Label label11;

		private Label label8;

		private TextBox txtAccessTables;

		private TabPage tabAdmin;

		private Label label17;

		private TextBox txtAdminPage;

		private Label label16;

		private TextBox txtAdminPath;

		private ToolStripButton ButtonSaveSetting;

		private ToolStripSeparator toolStripSeparator2;

		private TabPage tabXSInj;

		private TextBox txtXSinjUsage;

		private Label label20;

		private Label label19;

		private TextBox txtXSRecord;

		private TextBox txtXSInjURL;

		private ToolTip ToolTipSetting;

		private GroupBox GroupBoxVulSetting;

		private CheckBox CheckBoxXSS;

		private CheckBox CheckBoxSQLInjection;

		private CheckBox CheckBoxScanCookieSQL;

		private CheckBox CheckBoxScanPostSQL;

		private CheckBox CheckBoxScanURLSQL;

		private Label label15;

		private CheckBox checkBoxLFI;

		private CheckBox checkBoxRFI;

		private CheckBox checkBoxBackup;

		private GroupBox GroupBoxScanSetting;

		private Label label6;

		private TextBox txtUserAgent;

		private Label label13;

		private TextBox txtScanDepth;

		private Label label14;

		private TextBox txtMaxThread;

		private TextBox txtCrawlableExt;

		private TextBox txtDelay;

		private Label label7;

		private GroupBox groupBoxReplaceSetting;

		private CheckBox checkBoxSingleThread;

		private TextBox txtCSRF;

		private Label label18;

		private Label label21;

		private Label label22;

		public FormSetting()
			: this()
		{
			InitializeComponent();
			chkUseProxy.set_Checked(WebCruiserWVS.Default.UseProxy);
			((Control)txtProxyAddr).set_Text(WebCruiserWVS.Default.ProxyAddress);
			((Control)txtProxyPort).set_Text(WebCruiserWVS.Default.ProxyPort.ToString());
			((Control)txtProxyUsername).set_Text(WebCruiserWVS.Default.ProxyUsername);
			((Control)txtProxyPassword).set_Text(WebCruiserWVS.Default.ProxyPassword);
			((Control)txtUserAgent).set_Text(WebCruiserWVS.Default.UserAgent);
			((Control)txtMaxThread).set_Text(WebCruiserWVS.Default.MaxHTTPThread.ToString());
			checkBoxSingleThread.set_Checked(WebCruiserWVS.Default.UseSingleThread);
			((Control)txtDelay).set_Text(WebCruiserWVS.Default.SecondsDelay.ToString());
			chkReplace1.set_Checked(WebCruiserWVS.Default.chkReplace1);
			((Control)txtFiltExpr1).set_Text(WebCruiserWVS.Default.FiltExpr1);
			((Control)txtRepExpr1).set_Text(WebCruiserWVS.Default.RepExpr1);
			chkReplace2.set_Checked(WebCruiserWVS.Default.chkReplace2);
			((Control)txtFiltExpr2).set_Text(WebCruiserWVS.Default.FiltExpr2);
			((Control)txtRepExpr2).set_Text(WebCruiserWVS.Default.RepExpr2);
			chkReplace3.set_Checked(WebCruiserWVS.Default.chkReplace3);
			((Control)txtFiltExpr3).set_Text(WebCruiserWVS.Default.FiltExpr3);
			((Control)txtRepExpr3).set_Text(WebCruiserWVS.Default.RepExpr3);
			((Control)txtCrawlableExt).set_Text(WebCruiserWVS.Default.CrawlableExt);
			((Control)txtScanDepth).set_Text(WebCruiserWVS.Default.ScanDepth.ToString());
			((Control)txtCSRF).set_Text(WebCruiserWVS.Default.CSRFKeyWords);
			CheckBoxSQLInjection.set_Checked(WebCruiserWVS.Default.ScanSQLInjection);
			CheckBoxScanURLSQL.set_Checked(WebCruiserWVS.Default.ScanURLSQL);
			CheckBoxScanPostSQL.set_Checked(WebCruiserWVS.Default.ScanPostSQL);
			CheckBoxScanCookieSQL.set_Checked(WebCruiserWVS.Default.ScanCookieSQL);
			EnableSQLInjectionCheckBox(CheckBoxSQLInjection.get_Checked());
			CheckBoxXSS.set_Checked(WebCruiserWVS.Default.ScanXSS);
			checkBoxLFI.set_Checked(WebCruiserWVS.Default.ScanLFI);
			checkBoxRFI.set_Checked(WebCruiserWVS.Default.ScanRFI);
			checkBoxBackup.set_Checked(WebCruiserWVS.Default.ScanBackup);
			string[] array = WebCruiserWVS.Default.AccessTables.Split(new char[1]
			{
				':'
			});
			string[] array2 = array;
			foreach (string str in array2)
			{
				TextBox obj = txtAccessTables;
				((Control)obj).set_Text(((Control)obj).get_Text() + str + "\r\n");
			}
			string[] array3 = WebCruiserWVS.Default.AccessColumns.Split(new char[1]
			{
				':'
			});
			string[] array4 = array3;
			foreach (string str2 in array4)
			{
				TextBox obj2 = txtAccessColumns;
				((Control)obj2).set_Text(((Control)obj2).get_Text() + str2 + "\r\n");
			}
			string[] array5 = WebCruiserWVS.Default.AdminPath.Split(new char[1]
			{
				':'
			});
			string[] array6 = array5;
			foreach (string str3 in array6)
			{
				TextBox obj3 = txtAdminPath;
				((Control)obj3).set_Text(((Control)obj3).get_Text() + str3 + "\r\n");
			}
			string[] array7 = WebCruiserWVS.Default.AdminPage.Split(new char[1]
			{
				':'
			});
			string[] array8 = array7;
			foreach (string str4 in array8)
			{
				TextBox obj4 = txtAdminPage;
				((Control)obj4).set_Text(((Control)obj4).get_Text() + str4 + "\r\n");
			}
			((Control)txtXSInjURL).set_Text(WebCruiserWVS.Default.CrossSiteURL);
			((Control)txtXSRecord).set_Text(WebCruiserWVS.Default.CrossSiteRecord);
		}

		private void CheckBoxSQLInjection_CheckedChanged(object sender, EventArgs e)
		{
			EnableSQLInjectionCheckBox(CheckBoxSQLInjection.get_Checked());
		}

		private void EnableSQLInjectionCheckBox(bool CheckedState)
		{
			((Control)CheckBoxScanURLSQL).set_Enabled(CheckedState);
			((Control)CheckBoxScanPostSQL).set_Enabled(CheckedState);
			((Control)CheckBoxScanCookieSQL).set_Enabled(CheckedState);
		}

		private void ButtonSaveSetting_Click(object sender, EventArgs e)
		{
			//IL_055b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0576: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				WCRSetting.UseProxy = chkUseProxy.get_Checked();
				WebCruiserWVS.Default.UseProxy = WCRSetting.UseProxy;
				WCRSetting.ProxyAddress = ((Control)txtProxyAddr).get_Text();
				WebCruiserWVS.Default.ProxyAddress = WCRSetting.ProxyAddress;
				WCRSetting.ProxyPort = int.Parse(((Control)txtProxyPort).get_Text());
				WebCruiserWVS.Default.ProxyPort = WCRSetting.ProxyPort;
				WCRSetting.ProxyUsername = ((Control)txtProxyUsername).get_Text();
				WebCruiserWVS.Default.ProxyUsername = WCRSetting.ProxyUsername;
				WCRSetting.ProxyPassword = ((Control)txtProxyPassword).get_Text();
				WebCruiserWVS.Default.ProxyPassword = WCRSetting.ProxyPassword;
				WCRSetting.chkReplace1 = chkReplace1.get_Checked();
				WebCruiserWVS.Default.chkReplace1 = WCRSetting.chkReplace1;
				WCRSetting.FiltExpr1 = ((Control)txtFiltExpr1).get_Text();
				WebCruiserWVS.Default.FiltExpr1 = WCRSetting.FiltExpr1;
				WCRSetting.RepExpr1 = ((Control)txtRepExpr1).get_Text();
				WebCruiserWVS.Default.RepExpr1 = WCRSetting.RepExpr1;
				WCRSetting.chkReplace2 = chkReplace2.get_Checked();
				WebCruiserWVS.Default.chkReplace2 = WCRSetting.chkReplace2;
				WCRSetting.FiltExpr2 = ((Control)txtFiltExpr2).get_Text();
				WebCruiserWVS.Default.FiltExpr2 = WCRSetting.FiltExpr2;
				WCRSetting.RepExpr2 = ((Control)txtRepExpr2).get_Text();
				WebCruiserWVS.Default.RepExpr2 = WCRSetting.RepExpr2;
				WCRSetting.chkReplace3 = chkReplace3.get_Checked();
				WebCruiserWVS.Default.chkReplace3 = WCRSetting.chkReplace3;
				WCRSetting.FiltExpr3 = ((Control)txtFiltExpr3).get_Text();
				WebCruiserWVS.Default.FiltExpr3 = WCRSetting.FiltExpr3;
				WCRSetting.RepExpr3 = ((Control)txtRepExpr3).get_Text();
				WebCruiserWVS.Default.RepExpr3 = WCRSetting.RepExpr3;
				WebCruiserWVS.Default.CSRFKeyWords = WCRSetting.CSRFKeywords;
				WCRSetting.UserAgent = ((Control)txtUserAgent).get_Text();
				WebCruiserWVS.Default.UserAgent = WCRSetting.UserAgent;
				WCRSetting.MaxHTTPThreadNum = int.Parse(((Control)txtMaxThread).get_Text());
				WebCruiserWVS.Default.MaxHTTPThread = WCRSetting.MaxHTTPThreadNum;
				WCRSetting.UseSingleThread = checkBoxSingleThread.get_Checked();
				WebCruiserWVS.Default.UseSingleThread = WCRSetting.UseSingleThread;
				WCRSetting.SecondsDelay = int.Parse(((Control)txtDelay).get_Text());
				WebCruiserWVS.Default.SecondsDelay = WCRSetting.SecondsDelay;
				WCRSetting.ScanDepth = int.Parse(((Control)txtScanDepth).get_Text());
				WebCruiserWVS.Default.ScanDepth = WCRSetting.ScanDepth;
				WCRSetting.CrawlableExt = ((Control)txtCrawlableExt).get_Text();
				WCRSetting.CrawlableExt = WCRSetting.CrawlableExt.Replace(" ", "").Trim();
				WebCruiserWVS.Default.CrawlableExt = WCRSetting.CrawlableExt;
				WCRSetting.ScanSQLInjection = CheckBoxSQLInjection.get_Checked();
				WebCruiserWVS.Default.ScanSQLInjection = WCRSetting.ScanSQLInjection;
				if (WCRSetting.ScanSQLInjection)
				{
					WCRSetting.ScanURLSQL = CheckBoxScanURLSQL.get_Checked();
					WebCruiserWVS.Default.ScanURLSQL = WCRSetting.ScanURLSQL;
					WCRSetting.ScanPostSQL = CheckBoxScanPostSQL.get_Checked();
					WebCruiserWVS.Default.ScanPostSQL = WCRSetting.ScanPostSQL;
					WCRSetting.ScanCookieSQL = CheckBoxScanCookieSQL.get_Checked();
					WebCruiserWVS.Default.ScanCookieSQL = WCRSetting.ScanCookieSQL;
				}
				else
				{
					WCRSetting.ScanURLSQL = false;
					WebCruiserWVS.Default.ScanURLSQL = false;
					WCRSetting.ScanPostSQL = false;
					WebCruiserWVS.Default.ScanPostSQL = false;
					WCRSetting.ScanCookieSQL = false;
					WebCruiserWVS.Default.ScanCookieSQL = false;
				}
				WCRSetting.ScanXSS = CheckBoxXSS.get_Checked();
				WebCruiserWVS.Default.ScanXSS = WCRSetting.ScanXSS;
				WCRSetting.ScanLFI = checkBoxLFI.get_Checked();
				WebCruiserWVS.Default.ScanLFI = WCRSetting.ScanLFI;
				WCRSetting.ScanRFI = checkBoxRFI.get_Checked();
				WebCruiserWVS.Default.ScanRFI = WCRSetting.ScanRFI;
				WCRSetting.ScanBackup = checkBoxBackup.get_Checked();
				WebCruiserWVS.Default.ScanBackup = WCRSetting.ScanBackup;
				string accessTables = ((Control)txtAccessTables).get_Text().Trim().Replace("\r\n", ":")
					.Replace(" ", "");
				WebCruiserWVS.Default.AccessTables = accessTables;
				string accessColumns = ((Control)txtAccessColumns).get_Text().Trim().Replace("\r\n", ":")
					.Replace(" ", "");
				WebCruiserWVS.Default.AccessColumns = accessColumns;
				string adminPath = ((Control)txtAdminPath).get_Text().Trim().Replace("\r\n", ":")
					.Replace(" ", "");
				WebCruiserWVS.Default.AdminPath = adminPath;
				string adminPage = ((Control)txtAdminPage).get_Text().Trim().Replace("\r\n", ":")
					.Replace(" ", "");
				WebCruiserWVS.Default.AdminPage = adminPage;
				string crossSiteURL = (WCRSetting.CrossSiteURL = ((Control)txtXSInjURL).get_Text().Trim());
				WebCruiserWVS.Default.CrossSiteURL = crossSiteURL;
				string crossSiteRecord = (WCRSetting.CrossSiteRecord = ((Control)txtXSRecord).get_Text().Trim());
				WebCruiserWVS.Default.CrossSiteRecord = crossSiteRecord;
				((SettingsBase)WebCruiserWVS.Default).Save();
				if (WCRSetting.UseProxy)
				{
					WCRSetting.RefreshIESettings(WCRSetting.ProxyAddress + ":" + WCRSetting.ProxyPort);
				}
				else
				{
					WCRSetting.RefreshIESettings("");
				}
				MessageBox.Show("Save & Apply OK!", "Done", (MessageBoxButtons)0, (MessageBoxIcon)64);
			}
			catch (Exception ex)
			{
				MessageBox.Show("Please Check your Input!\r\n" + ex.ToString());
			}
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_0015: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0053: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Expected O, but got Unknown
			//IL_005e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0068: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_0073: Expected O, but got Unknown
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_007e: Expected O, but got Unknown
			//IL_007f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0089: Expected O, but got Unknown
			//IL_008a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Expected O, but got Unknown
			//IL_0095: Unknown result type (might be due to invalid IL or missing references)
			//IL_009f: Expected O, but got Unknown
			//IL_00a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00aa: Expected O, but got Unknown
			//IL_00ab: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b5: Expected O, but got Unknown
			//IL_00b6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c0: Expected O, but got Unknown
			//IL_00c1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00cb: Expected O, but got Unknown
			//IL_00cc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d6: Expected O, but got Unknown
			//IL_00d7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e1: Expected O, but got Unknown
			//IL_00e2: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ec: Expected O, but got Unknown
			//IL_00ed: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f7: Expected O, but got Unknown
			//IL_00f8: Unknown result type (might be due to invalid IL or missing references)
			//IL_0102: Expected O, but got Unknown
			//IL_0103: Unknown result type (might be due to invalid IL or missing references)
			//IL_010d: Expected O, but got Unknown
			//IL_010e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0118: Expected O, but got Unknown
			//IL_0119: Unknown result type (might be due to invalid IL or missing references)
			//IL_0123: Expected O, but got Unknown
			//IL_0124: Unknown result type (might be due to invalid IL or missing references)
			//IL_012e: Expected O, but got Unknown
			//IL_012f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0139: Expected O, but got Unknown
			//IL_013a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0144: Expected O, but got Unknown
			//IL_0145: Unknown result type (might be due to invalid IL or missing references)
			//IL_014f: Expected O, but got Unknown
			//IL_0150: Unknown result type (might be due to invalid IL or missing references)
			//IL_015a: Expected O, but got Unknown
			//IL_015b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0165: Expected O, but got Unknown
			//IL_0166: Unknown result type (might be due to invalid IL or missing references)
			//IL_0170: Expected O, but got Unknown
			//IL_0171: Unknown result type (might be due to invalid IL or missing references)
			//IL_017b: Expected O, but got Unknown
			//IL_017c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0186: Expected O, but got Unknown
			//IL_0187: Unknown result type (might be due to invalid IL or missing references)
			//IL_0191: Expected O, but got Unknown
			//IL_0192: Unknown result type (might be due to invalid IL or missing references)
			//IL_019c: Expected O, but got Unknown
			//IL_019d: Unknown result type (might be due to invalid IL or missing references)
			//IL_01a7: Expected O, but got Unknown
			//IL_01a8: Unknown result type (might be due to invalid IL or missing references)
			//IL_01b2: Expected O, but got Unknown
			//IL_01b3: Unknown result type (might be due to invalid IL or missing references)
			//IL_01bd: Expected O, but got Unknown
			//IL_01be: Unknown result type (might be due to invalid IL or missing references)
			//IL_01c8: Expected O, but got Unknown
			//IL_01c9: Unknown result type (might be due to invalid IL or missing references)
			//IL_01d3: Expected O, but got Unknown
			//IL_01d4: Unknown result type (might be due to invalid IL or missing references)
			//IL_01de: Expected O, but got Unknown
			//IL_01df: Unknown result type (might be due to invalid IL or missing references)
			//IL_01e9: Expected O, but got Unknown
			//IL_01ea: Unknown result type (might be due to invalid IL or missing references)
			//IL_01f4: Expected O, but got Unknown
			//IL_01f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ff: Expected O, but got Unknown
			//IL_0200: Unknown result type (might be due to invalid IL or missing references)
			//IL_020a: Expected O, but got Unknown
			//IL_020b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0215: Expected O, but got Unknown
			//IL_0216: Unknown result type (might be due to invalid IL or missing references)
			//IL_0220: Expected O, but got Unknown
			//IL_0221: Unknown result type (might be due to invalid IL or missing references)
			//IL_022b: Expected O, but got Unknown
			//IL_022c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0236: Expected O, but got Unknown
			//IL_0237: Unknown result type (might be due to invalid IL or missing references)
			//IL_0241: Expected O, but got Unknown
			//IL_0242: Unknown result type (might be due to invalid IL or missing references)
			//IL_024c: Expected O, but got Unknown
			//IL_024d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0257: Expected O, but got Unknown
			//IL_0258: Unknown result type (might be due to invalid IL or missing references)
			//IL_0262: Expected O, but got Unknown
			//IL_0263: Unknown result type (might be due to invalid IL or missing references)
			//IL_026d: Expected O, but got Unknown
			//IL_026e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0278: Expected O, but got Unknown
			//IL_0279: Unknown result type (might be due to invalid IL or missing references)
			//IL_0283: Expected O, but got Unknown
			//IL_0284: Unknown result type (might be due to invalid IL or missing references)
			//IL_028e: Expected O, but got Unknown
			//IL_028f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0299: Expected O, but got Unknown
			//IL_029a: Unknown result type (might be due to invalid IL or missing references)
			//IL_02a4: Expected O, but got Unknown
			//IL_02a5: Unknown result type (might be due to invalid IL or missing references)
			//IL_02af: Expected O, but got Unknown
			//IL_02b0: Unknown result type (might be due to invalid IL or missing references)
			//IL_02ba: Expected O, but got Unknown
			//IL_02bb: Unknown result type (might be due to invalid IL or missing references)
			//IL_02c5: Expected O, but got Unknown
			//IL_02c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_02d0: Expected O, but got Unknown
			//IL_02d1: Unknown result type (might be due to invalid IL or missing references)
			//IL_02db: Expected O, but got Unknown
			//IL_02dc: Unknown result type (might be due to invalid IL or missing references)
			//IL_02e6: Expected O, but got Unknown
			//IL_02e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_02f1: Expected O, but got Unknown
			//IL_02f2: Unknown result type (might be due to invalid IL or missing references)
			//IL_02fc: Expected O, but got Unknown
			//IL_02fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0307: Expected O, but got Unknown
			//IL_030e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0318: Expected O, but got Unknown
			//IL_0319: Unknown result type (might be due to invalid IL or missing references)
			//IL_0323: Expected O, but got Unknown
			//IL_0324: Unknown result type (might be due to invalid IL or missing references)
			//IL_032e: Expected O, but got Unknown
			//IL_032f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0339: Expected O, but got Unknown
			//IL_033a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0344: Expected O, but got Unknown
			//IL_03c9: Unknown result type (might be due to invalid IL or missing references)
			//IL_03f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_043e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0465: Unknown result type (might be due to invalid IL or missing references)
			//IL_04a4: Unknown result type (might be due to invalid IL or missing references)
			//IL_04d7: Unknown result type (might be due to invalid IL or missing references)
			//IL_04e1: Expected O, but got Unknown
			//IL_04e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_050e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0558: Unknown result type (might be due to invalid IL or missing references)
			//IL_05fa: Unknown result type (might be due to invalid IL or missing references)
			//IL_060e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0644: Unknown result type (might be due to invalid IL or missing references)
			//IL_0679: Unknown result type (might be due to invalid IL or missing references)
			//IL_068d: Unknown result type (might be due to invalid IL or missing references)
			//IL_06b7: Unknown result type (might be due to invalid IL or missing references)
			//IL_07a3: Unknown result type (might be due to invalid IL or missing references)
			//IL_07b7: Unknown result type (might be due to invalid IL or missing references)
			//IL_07db: Unknown result type (might be due to invalid IL or missing references)
			//IL_07f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_0840: Unknown result type (might be due to invalid IL or missing references)
			//IL_0854: Unknown result type (might be due to invalid IL or missing references)
			//IL_087b: Unknown result type (might be due to invalid IL or missing references)
			//IL_08c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_08da: Unknown result type (might be due to invalid IL or missing references)
			//IL_0901: Unknown result type (might be due to invalid IL or missing references)
			//IL_094c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0960: Unknown result type (might be due to invalid IL or missing references)
			//IL_0987: Unknown result type (might be due to invalid IL or missing references)
			//IL_09cf: Unknown result type (might be due to invalid IL or missing references)
			//IL_09e3: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a0a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a52: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a66: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a8d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ad5: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ae9: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b10: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b5b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b6f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b96: Unknown result type (might be due to invalid IL or missing references)
			//IL_0bde: Unknown result type (might be due to invalid IL or missing references)
			//IL_0bf2: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c19: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d5d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d71: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d95: Unknown result type (might be due to invalid IL or missing references)
			//IL_0daf: Unknown result type (might be due to invalid IL or missing references)
			//IL_0df9: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e0d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e34: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e73: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e87: Unknown result type (might be due to invalid IL or missing references)
			//IL_0eae: Unknown result type (might be due to invalid IL or missing references)
			//IL_0eeb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0eff: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f26: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f65: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f79: Unknown result type (might be due to invalid IL or missing references)
			//IL_0fad: Unknown result type (might be due to invalid IL or missing references)
			//IL_0fcd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0fe1: Unknown result type (might be due to invalid IL or missing references)
			//IL_1008: Unknown result type (might be due to invalid IL or missing references)
			//IL_1036: Unknown result type (might be due to invalid IL or missing references)
			//IL_104a: Unknown result type (might be due to invalid IL or missing references)
			//IL_106e: Unknown result type (might be due to invalid IL or missing references)
			//IL_10a9: Unknown result type (might be due to invalid IL or missing references)
			//IL_10bd: Unknown result type (might be due to invalid IL or missing references)
			//IL_10e1: Unknown result type (might be due to invalid IL or missing references)
			//IL_1114: Unknown result type (might be due to invalid IL or missing references)
			//IL_1128: Unknown result type (might be due to invalid IL or missing references)
			//IL_114c: Unknown result type (might be due to invalid IL or missing references)
			//IL_117b: Unknown result type (might be due to invalid IL or missing references)
			//IL_118f: Unknown result type (might be due to invalid IL or missing references)
			//IL_11b3: Unknown result type (might be due to invalid IL or missing references)
			//IL_11ee: Unknown result type (might be due to invalid IL or missing references)
			//IL_1202: Unknown result type (might be due to invalid IL or missing references)
			//IL_1226: Unknown result type (might be due to invalid IL or missing references)
			//IL_1256: Unknown result type (might be due to invalid IL or missing references)
			//IL_126a: Unknown result type (might be due to invalid IL or missing references)
			//IL_1291: Unknown result type (might be due to invalid IL or missing references)
			//IL_12dc: Unknown result type (might be due to invalid IL or missing references)
			//IL_12f0: Unknown result type (might be due to invalid IL or missing references)
			//IL_1314: Unknown result type (might be due to invalid IL or missing references)
			//IL_132e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1475: Unknown result type (might be due to invalid IL or missing references)
			//IL_1489: Unknown result type (might be due to invalid IL or missing references)
			//IL_14ad: Unknown result type (might be due to invalid IL or missing references)
			//IL_14c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1510: Unknown result type (might be due to invalid IL or missing references)
			//IL_1524: Unknown result type (might be due to invalid IL or missing references)
			//IL_1548: Unknown result type (might be due to invalid IL or missing references)
			//IL_1585: Unknown result type (might be due to invalid IL or missing references)
			//IL_1599: Unknown result type (might be due to invalid IL or missing references)
			//IL_15bd: Unknown result type (might be due to invalid IL or missing references)
			//IL_15e1: Unknown result type (might be due to invalid IL or missing references)
			//IL_15f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_1619: Unknown result type (might be due to invalid IL or missing references)
			//IL_1649: Unknown result type (might be due to invalid IL or missing references)
			//IL_165d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1681: Unknown result type (might be due to invalid IL or missing references)
			//IL_16c1: Unknown result type (might be due to invalid IL or missing references)
			//IL_16d5: Unknown result type (might be due to invalid IL or missing references)
			//IL_16f9: Unknown result type (might be due to invalid IL or missing references)
			//IL_172d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1741: Unknown result type (might be due to invalid IL or missing references)
			//IL_1765: Unknown result type (might be due to invalid IL or missing references)
			//IL_1786: Unknown result type (might be due to invalid IL or missing references)
			//IL_179a: Unknown result type (might be due to invalid IL or missing references)
			//IL_17be: Unknown result type (might be due to invalid IL or missing references)
			//IL_17eb: Unknown result type (might be due to invalid IL or missing references)
			//IL_17ff: Unknown result type (might be due to invalid IL or missing references)
			//IL_1823: Unknown result type (might be due to invalid IL or missing references)
			//IL_186c: Unknown result type (might be due to invalid IL or missing references)
			//IL_1880: Unknown result type (might be due to invalid IL or missing references)
			//IL_18a4: Unknown result type (might be due to invalid IL or missing references)
			//IL_18e1: Unknown result type (might be due to invalid IL or missing references)
			//IL_18f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_1919: Unknown result type (might be due to invalid IL or missing references)
			//IL_193d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1951: Unknown result type (might be due to invalid IL or missing references)
			//IL_1975: Unknown result type (might be due to invalid IL or missing references)
			//IL_19a5: Unknown result type (might be due to invalid IL or missing references)
			//IL_19b9: Unknown result type (might be due to invalid IL or missing references)
			//IL_19dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b15: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b29: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b4d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b67: Unknown result type (might be due to invalid IL or missing references)
			//IL_1bb3: Unknown result type (might be due to invalid IL or missing references)
			//IL_1bc7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1bee: Unknown result type (might be due to invalid IL or missing references)
			//IL_1c37: Unknown result type (might be due to invalid IL or missing references)
			//IL_1c4b: Unknown result type (might be due to invalid IL or missing references)
			//IL_1c6f: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ca0: Unknown result type (might be due to invalid IL or missing references)
			//IL_1cb4: Unknown result type (might be due to invalid IL or missing references)
			//IL_1cdb: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d0e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d22: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d49: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d7f: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d93: Unknown result type (might be due to invalid IL or missing references)
			//IL_1db7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1de3: Unknown result type (might be due to invalid IL or missing references)
			//IL_1df7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e1e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e54: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e68: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e8c: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ead: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ec1: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ee8: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f0e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f22: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f52: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f82: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f96: Unknown result type (might be due to invalid IL or missing references)
			//IL_1fbd: Unknown result type (might be due to invalid IL or missing references)
			//IL_205b: Unknown result type (might be due to invalid IL or missing references)
			//IL_206f: Unknown result type (might be due to invalid IL or missing references)
			//IL_2099: Unknown result type (might be due to invalid IL or missing references)
			//IL_20e4: Unknown result type (might be due to invalid IL or missing references)
			//IL_20f8: Unknown result type (might be due to invalid IL or missing references)
			//IL_213a: Unknown result type (might be due to invalid IL or missing references)
			//IL_217e: Unknown result type (might be due to invalid IL or missing references)
			//IL_2192: Unknown result type (might be due to invalid IL or missing references)
			//IL_21b9: Unknown result type (might be due to invalid IL or missing references)
			//IL_21f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_2207: Unknown result type (might be due to invalid IL or missing references)
			//IL_222e: Unknown result type (might be due to invalid IL or missing references)
			//IL_2269: Unknown result type (might be due to invalid IL or missing references)
			//IL_227d: Unknown result type (might be due to invalid IL or missing references)
			//IL_22bf: Unknown result type (might be due to invalid IL or missing references)
			//IL_2362: Unknown result type (might be due to invalid IL or missing references)
			//IL_2376: Unknown result type (might be due to invalid IL or missing references)
			//IL_23a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_23df: Unknown result type (might be due to invalid IL or missing references)
			//IL_23f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_241a: Unknown result type (might be due to invalid IL or missing references)
			//IL_243d: Unknown result type (might be due to invalid IL or missing references)
			//IL_2451: Unknown result type (might be due to invalid IL or missing references)
			//IL_2478: Unknown result type (might be due to invalid IL or missing references)
			//IL_24a4: Unknown result type (might be due to invalid IL or missing references)
			//IL_24b8: Unknown result type (might be due to invalid IL or missing references)
			//IL_24df: Unknown result type (might be due to invalid IL or missing references)
			//IL_251b: Unknown result type (might be due to invalid IL or missing references)
			//IL_252f: Unknown result type (might be due to invalid IL or missing references)
			//IL_2553: Unknown result type (might be due to invalid IL or missing references)
			//IL_2583: Unknown result type (might be due to invalid IL or missing references)
			//IL_2597: Unknown result type (might be due to invalid IL or missing references)
			//IL_25d9: Unknown result type (might be due to invalid IL or missing references)
			//IL_267c: Unknown result type (might be due to invalid IL or missing references)
			//IL_2690: Unknown result type (might be due to invalid IL or missing references)
			//IL_26ba: Unknown result type (might be due to invalid IL or missing references)
			//IL_2704: Unknown result type (might be due to invalid IL or missing references)
			//IL_2718: Unknown result type (might be due to invalid IL or missing references)
			//IL_273f: Unknown result type (might be due to invalid IL or missing references)
			//IL_277e: Unknown result type (might be due to invalid IL or missing references)
			//IL_2792: Unknown result type (might be due to invalid IL or missing references)
			//IL_27d4: Unknown result type (might be due to invalid IL or missing references)
			//IL_2814: Unknown result type (might be due to invalid IL or missing references)
			//IL_2828: Unknown result type (might be due to invalid IL or missing references)
			//IL_284f: Unknown result type (might be due to invalid IL or missing references)
			//IL_288a: Unknown result type (might be due to invalid IL or missing references)
			//IL_289e: Unknown result type (might be due to invalid IL or missing references)
			//IL_28e0: Unknown result type (might be due to invalid IL or missing references)
			//IL_2925: Unknown result type (might be due to invalid IL or missing references)
			//IL_294c: Unknown result type (might be due to invalid IL or missing references)
			//IL_2980: Unknown result type (might be due to invalid IL or missing references)
			//IL_29a7: Unknown result type (might be due to invalid IL or missing references)
			//IL_29d6: Unknown result type (might be due to invalid IL or missing references)
			//IL_29fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_2a3b: Unknown result type (might be due to invalid IL or missing references)
			//IL_2a62: Unknown result type (might be due to invalid IL or missing references)
			//IL_2a93: Unknown result type (might be due to invalid IL or missing references)
			//IL_2aaf: Unknown result type (might be due to invalid IL or missing references)
			//IL_2ae7: Unknown result type (might be due to invalid IL or missing references)
			components = (IContainer)new Container();
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormSetting));
			toolStripSetting = new ToolStrip();
			toolStripSeparator1 = new ToolStripSeparator();
			ButtonSaveSetting = new ToolStripButton();
			toolStripSeparator2 = new ToolStripSeparator();
			tabSetting = new TabControl();
			tabScanner = new TabPage();
			GroupBoxVulSetting = new GroupBox();
			checkBoxBackup = new CheckBox();
			checkBoxRFI = new CheckBox();
			checkBoxLFI = new CheckBox();
			CheckBoxScanCookieSQL = new CheckBox();
			CheckBoxScanPostSQL = new CheckBox();
			CheckBoxScanURLSQL = new CheckBox();
			CheckBoxXSS = new CheckBox();
			CheckBoxSQLInjection = new CheckBox();
			tabProxy = new TabPage();
			label15 = new Label();
			label10 = new Label();
			chkUseProxy = new CheckBox();
			txtProxyPassword = new TextBox();
			txtProxyUsername = new TextBox();
			label4 = new Label();
			label3 = new Label();
			txtProxyPort = new TextBox();
			label2 = new Label();
			label1 = new Label();
			txtProxyAddr = new TextBox();
			tabAdvanced = new TabPage();
			groupBoxReplaceSetting = new GroupBox();
			chkReplace1 = new CheckBox();
			txtFiltExpr1 = new TextBox();
			txtRepExpr3 = new TextBox();
			label5 = new Label();
			label12 = new Label();
			txtRepExpr1 = new TextBox();
			txtFiltExpr3 = new TextBox();
			chkReplace2 = new CheckBox();
			chkReplace3 = new CheckBox();
			txtFiltExpr2 = new TextBox();
			txtRepExpr2 = new TextBox();
			label9 = new Label();
			GroupBoxScanSetting = new GroupBox();
			checkBoxSingleThread = new CheckBox();
			label6 = new Label();
			txtUserAgent = new TextBox();
			label13 = new Label();
			txtScanDepth = new TextBox();
			label14 = new Label();
			txtMaxThread = new TextBox();
			txtCrawlableExt = new TextBox();
			txtDelay = new TextBox();
			label7 = new Label();
			tabAccess = new TabPage();
			txtAccessColumns = new TextBox();
			label11 = new Label();
			label8 = new Label();
			txtAccessTables = new TextBox();
			tabXSInj = new TabPage();
			txtXSRecord = new TextBox();
			txtXSInjURL = new TextBox();
			label20 = new Label();
			label19 = new Label();
			txtXSinjUsage = new TextBox();
			tabAdmin = new TabPage();
			label17 = new Label();
			txtAdminPage = new TextBox();
			label16 = new Label();
			txtAdminPath = new TextBox();
			ToolTipSetting = new ToolTip(components);
			label18 = new Label();
			txtCSRF = new TextBox();
			label21 = new Label();
			label22 = new Label();
			((Control)toolStripSetting).SuspendLayout();
			((Control)tabSetting).SuspendLayout();
			((Control)tabScanner).SuspendLayout();
			((Control)GroupBoxVulSetting).SuspendLayout();
			((Control)tabProxy).SuspendLayout();
			((Control)tabAdvanced).SuspendLayout();
			((Control)groupBoxReplaceSetting).SuspendLayout();
			((Control)GroupBoxScanSetting).SuspendLayout();
			((Control)tabAccess).SuspendLayout();
			((Control)tabXSInj).SuspendLayout();
			((Control)tabAdmin).SuspendLayout();
			((Control)this).SuspendLayout();
			toolStripSetting.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripSetting).set_Dock((DockStyle)2);
			toolStripSetting.set_GripStyle((ToolStripGripStyle)0);
			toolStripSetting.set_ImageScalingSize(new Size(20, 20));
			toolStripSetting.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[3]
			{
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)ButtonSaveSetting,
				(ToolStripItem)toolStripSeparator2
			});
			((Control)toolStripSetting).set_Location(new Point(0, 537));
			((Control)toolStripSetting).set_Name("toolStripSetting");
			((Control)toolStripSetting).set_Size(new Size(1381, 25));
			((Control)toolStripSetting).set_TabIndex(0);
			((Control)toolStripSetting).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 25));
			((ToolStripItem)ButtonSaveSetting).set_AutoSize(false);
			((ToolStripItem)ButtonSaveSetting).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)ButtonSaveSetting).set_Image((Image)((ResourceManager)(object)val).GetObject("ButtonSaveSetting.Image"));
			((ToolStripItem)ButtonSaveSetting).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonSaveSetting).set_Name("ButtonSaveSetting");
			((ToolStripItem)ButtonSaveSetting).set_Size(new Size(150, 22));
			((ToolStripItem)ButtonSaveSetting).set_Text("Save && Apply Settings");
			((ToolStripItem)ButtonSaveSetting).add_Click((EventHandler)ButtonSaveSetting_Click);
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			((Control)tabSetting).get_Controls().Add((Control)(object)tabScanner);
			((Control)tabSetting).get_Controls().Add((Control)(object)tabProxy);
			((Control)tabSetting).get_Controls().Add((Control)(object)tabAdvanced);
			((Control)tabSetting).get_Controls().Add((Control)(object)tabAccess);
			((Control)tabSetting).get_Controls().Add((Control)(object)tabXSInj);
			((Control)tabSetting).get_Controls().Add((Control)(object)tabAdmin);
			((Control)tabSetting).set_Dock((DockStyle)5);
			((Control)tabSetting).set_Location(new Point(0, 0));
			((Control)tabSetting).set_Margin(new Padding(4, 4, 4, 4));
			((Control)tabSetting).set_Name("tabSetting");
			tabSetting.set_SelectedIndex(0);
			((Control)tabSetting).set_Size(new Size(1381, 537));
			((Control)tabSetting).set_TabIndex(1);
			((Control)tabScanner).get_Controls().Add((Control)(object)GroupBoxVulSetting);
			tabScanner.set_Location(new Point(4, 25));
			((Control)tabScanner).set_Margin(new Padding(4, 4, 4, 4));
			((Control)tabScanner).set_Name("tabScanner");
			((Control)tabScanner).set_Size(new Size(1373, 508));
			tabScanner.set_TabIndex(2);
			((Control)tabScanner).set_Text("Scanner");
			tabScanner.set_UseVisualStyleBackColor(true);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)checkBoxBackup);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)checkBoxRFI);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)checkBoxLFI);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)CheckBoxScanCookieSQL);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)CheckBoxScanPostSQL);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)CheckBoxScanURLSQL);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)CheckBoxXSS);
			((Control)GroupBoxVulSetting).get_Controls().Add((Control)(object)CheckBoxSQLInjection);
			((Control)GroupBoxVulSetting).set_Location(new Point(11, 19));
			((Control)GroupBoxVulSetting).set_Margin(new Padding(4, 4, 4, 4));
			((Control)GroupBoxVulSetting).set_Name("GroupBoxVulSetting");
			((Control)GroupBoxVulSetting).set_Padding(new Padding(4, 4, 4, 4));
			((Control)GroupBoxVulSetting).set_Size(new Size(816, 440));
			((Control)GroupBoxVulSetting).set_TabIndex(7);
			GroupBoxVulSetting.set_TabStop(false);
			((Control)GroupBoxVulSetting).set_Text("Scanner Setting");
			((Control)checkBoxBackup).set_AutoSize(true);
			((Control)checkBoxBackup).set_Location(new Point(24, 225));
			((Control)checkBoxBackup).set_Margin(new Padding(4, 4, 4, 4));
			((Control)checkBoxBackup).set_Name("checkBoxBackup");
			((Control)checkBoxBackup).set_Size(new Size(501, 19));
			((Control)checkBoxBackup).set_TabIndex(8);
			((Control)checkBoxBackup).set_Text("Scan Obsolete Backup files (Potential Information Leakage) ");
			((ButtonBase)checkBoxBackup).set_UseVisualStyleBackColor(true);
			((Control)checkBoxRFI).set_AutoSize(true);
			((Control)checkBoxRFI).set_Location(new Point(24, 198));
			((Control)checkBoxRFI).set_Margin(new Padding(4, 4, 4, 4));
			((Control)checkBoxRFI).set_Name("checkBoxRFI");
			((Control)checkBoxRFI).set_Size(new Size(373, 19));
			((Control)checkBoxRFI).set_TabIndex(7);
			((Control)checkBoxRFI).set_Text("Scan RFI (Remote File Inclusion) && Redirect");
			((ButtonBase)checkBoxRFI).set_UseVisualStyleBackColor(true);
			((Control)checkBoxLFI).set_AutoSize(true);
			((Control)checkBoxLFI).set_Location(new Point(24, 170));
			((Control)checkBoxLFI).set_Margin(new Padding(4, 4, 4, 4));
			((Control)checkBoxLFI).set_Name("checkBoxLFI");
			((Control)checkBoxLFI).set_Size(new Size(429, 19));
			((Control)checkBoxLFI).set_TabIndex(6);
			((Control)checkBoxLFI).set_Text("Scan LFI (Local File Inclusion, Path Manipulation)");
			((ButtonBase)checkBoxLFI).set_UseVisualStyleBackColor(true);
			((Control)CheckBoxScanCookieSQL).set_AutoSize(true);
			((Control)CheckBoxScanCookieSQL).set_Location(new Point(51, 115));
			((Control)CheckBoxScanCookieSQL).set_Margin(new Padding(4, 4, 4, 4));
			((Control)CheckBoxScanCookieSQL).set_Name("CheckBoxScanCookieSQL");
			((Control)CheckBoxScanCookieSQL).set_Size(new Size(229, 19));
			((Control)CheckBoxScanCookieSQL).set_TabIndex(5);
			((Control)CheckBoxScanCookieSQL).set_Text("Scan Cookie SQL Injection");
			((ButtonBase)CheckBoxScanCookieSQL).set_UseVisualStyleBackColor(true);
			((Control)CheckBoxScanPostSQL).set_AutoSize(true);
			((Control)CheckBoxScanPostSQL).set_Location(new Point(51, 84));
			((Control)CheckBoxScanPostSQL).set_Margin(new Padding(4, 4, 4, 4));
			((Control)CheckBoxScanPostSQL).set_Name("CheckBoxScanPostSQL");
			((Control)CheckBoxScanPostSQL).set_Size(new Size(213, 19));
			((Control)CheckBoxScanPostSQL).set_TabIndex(4);
			((Control)CheckBoxScanPostSQL).set_Text("Scan Post SQL Injection");
			((ButtonBase)CheckBoxScanPostSQL).set_UseVisualStyleBackColor(true);
			((Control)CheckBoxScanURLSQL).set_AutoSize(true);
			((Control)CheckBoxScanURLSQL).set_Location(new Point(51, 52));
			((Control)CheckBoxScanURLSQL).set_Margin(new Padding(4, 4, 4, 4));
			((Control)CheckBoxScanURLSQL).set_Name("CheckBoxScanURLSQL");
			((Control)CheckBoxScanURLSQL).set_Size(new Size(205, 19));
			((Control)CheckBoxScanURLSQL).set_TabIndex(3);
			((Control)CheckBoxScanURLSQL).set_Text("Scan URL SQL Injection");
			((ButtonBase)CheckBoxScanURLSQL).set_UseVisualStyleBackColor(true);
			((Control)CheckBoxXSS).set_AutoSize(true);
			((Control)CheckBoxXSS).set_Location(new Point(24, 142));
			((Control)CheckBoxXSS).set_Margin(new Padding(4, 4, 4, 4));
			((Control)CheckBoxXSS).set_Name("CheckBoxXSS");
			((Control)CheckBoxXSS).set_Size(new Size(229, 19));
			((Control)CheckBoxXSS).set_TabIndex(1);
			((Control)CheckBoxXSS).set_Text("Scan Cross Site Scripting");
			((ButtonBase)CheckBoxXSS).set_UseVisualStyleBackColor(true);
			((Control)CheckBoxSQLInjection).set_AutoSize(true);
			((Control)CheckBoxSQLInjection).set_Location(new Point(24, 25));
			((Control)CheckBoxSQLInjection).set_Margin(new Padding(4, 4, 4, 4));
			((Control)CheckBoxSQLInjection).set_Name("CheckBoxSQLInjection");
			((Control)CheckBoxSQLInjection).set_Size(new Size(173, 19));
			((Control)CheckBoxSQLInjection).set_TabIndex(0);
			((Control)CheckBoxSQLInjection).set_Text("Scan SQL Injection");
			((ButtonBase)CheckBoxSQLInjection).set_UseVisualStyleBackColor(true);
			CheckBoxSQLInjection.add_CheckedChanged((EventHandler)CheckBoxSQLInjection_CheckedChanged);
			((Control)tabProxy).get_Controls().Add((Control)(object)label15);
			((Control)tabProxy).get_Controls().Add((Control)(object)label10);
			((Control)tabProxy).get_Controls().Add((Control)(object)chkUseProxy);
			((Control)tabProxy).get_Controls().Add((Control)(object)txtProxyPassword);
			((Control)tabProxy).get_Controls().Add((Control)(object)txtProxyUsername);
			((Control)tabProxy).get_Controls().Add((Control)(object)label4);
			((Control)tabProxy).get_Controls().Add((Control)(object)label3);
			((Control)tabProxy).get_Controls().Add((Control)(object)txtProxyPort);
			((Control)tabProxy).get_Controls().Add((Control)(object)label2);
			((Control)tabProxy).get_Controls().Add((Control)(object)label1);
			((Control)tabProxy).get_Controls().Add((Control)(object)txtProxyAddr);
			tabProxy.set_Location(new Point(4, 25));
			((Control)tabProxy).set_Margin(new Padding(4, 4, 4, 4));
			((Control)tabProxy).set_Name("tabProxy");
			((Control)tabProxy).set_Padding(new Padding(4, 4, 4, 4));
			((Control)tabProxy).set_Size(new Size(1373, 502));
			tabProxy.set_TabIndex(0);
			((Control)tabProxy).set_Text("Proxy");
			tabProxy.set_UseVisualStyleBackColor(true);
			((Control)label15).set_AutoSize(true);
			((Control)label15).set_Location(new Point(8, 195));
			((Control)label15).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label15).set_Name("label15");
			((Control)label15).set_Size(new Size(431, 15));
			((Control)label15).set_TabIndex(10);
			((Control)label15).set_Text("* If target is 127.0.0.1, the proxy will be bypassed!");
			((Control)label10).set_AutoSize(true);
			((Control)label10).set_Location(new Point(8, 168));
			((Control)label10).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label10).set_Name("label10");
			((Control)label10).set_Size(new Size(431, 15));
			((Control)label10).set_TabIndex(9);
			((Control)label10).set_Text("* Leave Username/Password Blank For Active Directory!");
			((Control)chkUseProxy).set_AutoSize(true);
			((Control)chkUseProxy).set_Location(new Point(91, 21));
			((Control)chkUseProxy).set_Margin(new Padding(4, 4, 4, 4));
			((Control)chkUseProxy).set_Name("chkUseProxy");
			((Control)chkUseProxy).set_Size(new Size(173, 19));
			((Control)chkUseProxy).set_TabIndex(8);
			((Control)chkUseProxy).set_Text("Use a Proxy Server");
			((ButtonBase)chkUseProxy).set_UseVisualStyleBackColor(true);
			((Control)txtProxyPassword).set_Location(new Point(89, 131));
			((Control)txtProxyPassword).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtProxyPassword).set_Name("txtProxyPassword");
			txtProxyPassword.set_PasswordChar('*');
			((Control)txtProxyPassword).set_Size(new Size(171, 25));
			((Control)txtProxyPassword).set_TabIndex(7);
			((Control)txtProxyUsername).set_Location(new Point(89, 95));
			((Control)txtProxyUsername).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtProxyUsername).set_Name("txtProxyUsername");
			((Control)txtProxyUsername).set_Size(new Size(171, 25));
			((Control)txtProxyUsername).set_TabIndex(6);
			((Control)label4).set_AutoSize(true);
			((Control)label4).set_Location(new Point(8, 136));
			((Control)label4).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label4).set_Name("label4");
			((Control)label4).set_Size(new Size(79, 15));
			((Control)label4).set_TabIndex(5);
			((Control)label4).set_Text("Password:");
			((Control)label3).set_AutoSize(true);
			((Control)label3).set_Location(new Point(8, 101));
			((Control)label3).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label3).set_Name("label3");
			((Control)label3).set_Size(new Size(79, 15));
			((Control)label3).set_TabIndex(4);
			((Control)label3).set_Text("Username:");
			((Control)txtProxyPort).set_Location(new Point(321, 59));
			((Control)txtProxyPort).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtProxyPort).set_Name("txtProxyPort");
			((Control)txtProxyPort).set_Size(new Size(57, 25));
			((Control)txtProxyPort).set_TabIndex(3);
			((Control)label2).set_AutoSize(true);
			((Control)label2).set_Location(new Point(271, 64));
			((Control)label2).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label2).set_Name("label2");
			((Control)label2).set_Size(new Size(47, 15));
			((Control)label2).set_TabIndex(2);
			((Control)label2).set_Text("Port:");
			((Control)label1).set_AutoSize(true);
			((Control)label1).set_Location(new Point(8, 64));
			((Control)label1).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label1).set_Name("label1");
			((Control)label1).set_Size(new Size(71, 15));
			((Control)label1).set_TabIndex(1);
			((Control)label1).set_Text("Address:");
			((Control)txtProxyAddr).set_Location(new Point(89, 59));
			((Control)txtProxyAddr).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtProxyAddr).set_Name("txtProxyAddr");
			((Control)txtProxyAddr).set_Size(new Size(171, 25));
			((Control)txtProxyAddr).set_TabIndex(0);
			((Control)tabAdvanced).get_Controls().Add((Control)(object)groupBoxReplaceSetting);
			((Control)tabAdvanced).get_Controls().Add((Control)(object)GroupBoxScanSetting);
			tabAdvanced.set_Location(new Point(4, 25));
			((Control)tabAdvanced).set_Margin(new Padding(4, 4, 4, 4));
			((Control)tabAdvanced).set_Name("tabAdvanced");
			((Control)tabAdvanced).set_Padding(new Padding(4, 4, 4, 4));
			((Control)tabAdvanced).set_Size(new Size(1373, 508));
			tabAdvanced.set_TabIndex(1);
			((Control)tabAdvanced).set_Text("Advanced");
			tabAdvanced.set_UseVisualStyleBackColor(true);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)chkReplace1);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)txtFiltExpr1);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)txtRepExpr3);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)label5);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)label12);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)txtRepExpr1);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)txtFiltExpr3);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)chkReplace2);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)chkReplace3);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)txtFiltExpr2);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)txtRepExpr2);
			((Control)groupBoxReplaceSetting).get_Controls().Add((Control)(object)label9);
			((Control)groupBoxReplaceSetting).set_Location(new Point(11, 314));
			((Control)groupBoxReplaceSetting).set_Margin(new Padding(4, 4, 4, 4));
			((Control)groupBoxReplaceSetting).set_Name("groupBoxReplaceSetting");
			((Control)groupBoxReplaceSetting).set_Padding(new Padding(4, 4, 4, 4));
			((Control)groupBoxReplaceSetting).set_Size(new Size(815, 164));
			((Control)groupBoxReplaceSetting).set_TabIndex(37);
			groupBoxReplaceSetting.set_TabStop(false);
			((Control)groupBoxReplaceSetting).set_Text("Replace Setting");
			((Control)chkReplace1).set_AutoSize(true);
			((Control)chkReplace1).set_Location(new Point(27, 39));
			((Control)chkReplace1).set_Margin(new Padding(4, 4, 4, 4));
			((Control)chkReplace1).set_Name("chkReplace1");
			((Control)chkReplace1).set_Size(new Size(85, 19));
			((Control)chkReplace1).set_TabIndex(10);
			((Control)chkReplace1).set_Text("Replace");
			((ButtonBase)chkReplace1).set_UseVisualStyleBackColor(true);
			((Control)txtFiltExpr1).set_Location(new Point(116, 36));
			((Control)txtFiltExpr1).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtFiltExpr1).set_Name("txtFiltExpr1");
			((Control)txtFiltExpr1).set_Size(new Size(65, 25));
			((Control)txtFiltExpr1).set_TabIndex(11);
			((Control)txtRepExpr3).set_Location(new Point(224, 109));
			((Control)txtRepExpr3).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtRepExpr3).set_Name("txtRepExpr3");
			((Control)txtRepExpr3).set_Size(new Size(119, 25));
			((Control)txtRepExpr3).set_TabIndex(23);
			((Control)label5).set_AutoSize(true);
			((Control)label5).set_Location(new Point(192, 41));
			((Control)label5).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label5).set_Name("label5");
			((Control)label5).set_Size(new Size(23, 15));
			((Control)label5).set_TabIndex(12);
			((Control)label5).set_Text("By");
			((Control)label12).set_AutoSize(true);
			((Control)label12).set_Location(new Point(192, 114));
			((Control)label12).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label12).set_Name("label12");
			((Control)label12).set_Size(new Size(23, 15));
			((Control)label12).set_TabIndex(22);
			((Control)label12).set_Text("By");
			((Control)txtRepExpr1).set_Location(new Point(224, 36));
			((Control)txtRepExpr1).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtRepExpr1).set_Name("txtRepExpr1");
			((Control)txtRepExpr1).set_Size(new Size(119, 25));
			((Control)txtRepExpr1).set_TabIndex(13);
			((Control)txtFiltExpr3).set_Location(new Point(116, 109));
			((Control)txtFiltExpr3).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtFiltExpr3).set_Name("txtFiltExpr3");
			((Control)txtFiltExpr3).set_Size(new Size(65, 25));
			((Control)txtFiltExpr3).set_TabIndex(21);
			((Control)chkReplace2).set_AutoSize(true);
			((Control)chkReplace2).set_Location(new Point(27, 75));
			((Control)chkReplace2).set_Margin(new Padding(4, 4, 4, 4));
			((Control)chkReplace2).set_Name("chkReplace2");
			((Control)chkReplace2).set_Size(new Size(85, 19));
			((Control)chkReplace2).set_TabIndex(15);
			((Control)chkReplace2).set_Text("Replace");
			((ButtonBase)chkReplace2).set_UseVisualStyleBackColor(true);
			((Control)chkReplace3).set_AutoSize(true);
			((Control)chkReplace3).set_Location(new Point(27, 111));
			((Control)chkReplace3).set_Margin(new Padding(4, 4, 4, 4));
			((Control)chkReplace3).set_Name("chkReplace3");
			((Control)chkReplace3).set_Size(new Size(85, 19));
			((Control)chkReplace3).set_TabIndex(20);
			((Control)chkReplace3).set_Text("Replace");
			((ButtonBase)chkReplace3).set_UseVisualStyleBackColor(true);
			((Control)txtFiltExpr2).set_Location(new Point(116, 72));
			((Control)txtFiltExpr2).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtFiltExpr2).set_Name("txtFiltExpr2");
			((Control)txtFiltExpr2).set_Size(new Size(65, 25));
			((Control)txtFiltExpr2).set_TabIndex(16);
			((Control)txtRepExpr2).set_Location(new Point(224, 72));
			((Control)txtRepExpr2).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtRepExpr2).set_Name("txtRepExpr2");
			((Control)txtRepExpr2).set_Size(new Size(119, 25));
			((Control)txtRepExpr2).set_TabIndex(18);
			((Control)label9).set_AutoSize(true);
			((Control)label9).set_Location(new Point(192, 78));
			((Control)label9).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label9).set_Name("label9");
			((Control)label9).set_Size(new Size(23, 15));
			((Control)label9).set_TabIndex(17);
			((Control)label9).set_Text("By");
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)txtCSRF);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)label18);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)checkBoxSingleThread);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)label6);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)txtUserAgent);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)label13);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)txtScanDepth);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)label14);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)txtMaxThread);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)txtCrawlableExt);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)txtDelay);
			((Control)GroupBoxScanSetting).get_Controls().Add((Control)(object)label7);
			((Control)GroupBoxScanSetting).set_Location(new Point(11, 8));
			((Control)GroupBoxScanSetting).set_Margin(new Padding(4, 4, 4, 4));
			((Control)GroupBoxScanSetting).set_Name("GroupBoxScanSetting");
			((Control)GroupBoxScanSetting).set_Padding(new Padding(4, 4, 4, 4));
			((Control)GroupBoxScanSetting).set_Size(new Size(815, 299));
			((Control)GroupBoxScanSetting).set_TabIndex(36);
			GroupBoxScanSetting.set_TabStop(false);
			((Control)GroupBoxScanSetting).set_Text("Parameter Setting");
			((Control)checkBoxSingleThread).set_AutoSize(true);
			((Control)checkBoxSingleThread).set_Location(new Point(24, 244));
			((Control)checkBoxSingleThread).set_Margin(new Padding(4, 4, 4, 4));
			((Control)checkBoxSingleThread).set_Name("checkBoxSingleThread");
			((Control)checkBoxSingleThread).set_Size(new Size(701, 19));
			((Control)checkBoxSingleThread).set_TabIndex(35);
			((Control)checkBoxSingleThread).set_Text("Using Single HTTP Thread (Default: No, exclude HEAD ), and Time Interval in Seconds:");
			((ButtonBase)checkBoxSingleThread).set_UseVisualStyleBackColor(true);
			((Control)label6).set_AutoSize(true);
			((Control)label6).set_Location(new Point(24, 35));
			((Control)label6).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label6).set_Name("label6");
			((Control)label6).set_Size(new Size(95, 15));
			((Control)label6).set_TabIndex(33);
			((Control)label6).set_Text("User-Agent:");
			((Control)txtUserAgent).set_Location(new Point(127, 30));
			((Control)txtUserAgent).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtUserAgent).set_Name("txtUserAgent");
			((Control)txtUserAgent).set_Size(new Size(679, 25));
			((Control)txtUserAgent).set_TabIndex(34);
			((Control)label13).set_AutoSize(true);
			((Control)label13).set_Location(new Point(541, 210));
			((Control)label13).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label13).set_Name("label13");
			((Control)label13).set_Size(new Size(199, 15));
			((Control)label13).set_TabIndex(0);
			((Control)label13).set_Text("Scan Depth (Default: 5):");
			((Control)txtScanDepth).set_Location(new Point(755, 204));
			((Control)txtScanDepth).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtScanDepth).set_Name("txtScanDepth");
			((Control)txtScanDepth).set_Size(new Size(51, 25));
			((Control)txtScanDepth).set_TabIndex(1);
			((Control)label14).set_AutoSize(true);
			((Control)label14).set_Location(new Point(24, 71));
			((Control)label14).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label14).set_Name("label14");
			((Control)label14).set_Size(new Size(759, 15));
			((Control)label14).set_TabIndex(2);
			((Control)label14).set_Text("Crawl links in pseudo-static pages, and files with the following extension (Seperated By ':'):");
			((Control)txtMaxThread).set_Location(new Point(359, 204));
			((Control)txtMaxThread).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtMaxThread).set_Name("txtMaxThread");
			((Control)txtMaxThread).set_Size(new Size(52, 25));
			((Control)txtMaxThread).set_TabIndex(30);
			((Control)txtCrawlableExt).set_Location(new Point(24, 89));
			((Control)txtCrawlableExt).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtCrawlableExt).set_Name("txtCrawlableExt");
			((Control)txtCrawlableExt).set_Size(new Size(781, 25));
			((Control)txtCrawlableExt).set_TabIndex(3);
			((Control)txtDelay).set_Location(new Point(755, 242));
			((Control)txtDelay).set_Margin(new Padding(4, 4, 4, 4));
			((TextBoxBase)txtDelay).set_MaxLength(4);
			((Control)txtDelay).set_Name("txtDelay");
			((Control)txtDelay).set_Size(new Size(51, 25));
			((Control)txtDelay).set_TabIndex(31);
			((Control)label7).set_AutoSize(true);
			((Control)label7).set_Location(new Point(24, 210));
			((Control)label7).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label7).set_Name("label7");
			((Control)label7).set_Size(new Size(335, 15));
			((Control)label7).set_TabIndex(29);
			((Control)label7).set_Text("Maximum HTTP Thread Number (Default: 10):");
			((Control)tabAccess).get_Controls().Add((Control)(object)label21);
			((Control)tabAccess).get_Controls().Add((Control)(object)txtAccessColumns);
			((Control)tabAccess).get_Controls().Add((Control)(object)label11);
			((Control)tabAccess).get_Controls().Add((Control)(object)label8);
			((Control)tabAccess).get_Controls().Add((Control)(object)txtAccessTables);
			tabAccess.set_Location(new Point(4, 25));
			((Control)tabAccess).set_Margin(new Padding(4, 4, 4, 4));
			((Control)tabAccess).set_Name("tabAccess");
			((Control)tabAccess).set_Size(new Size(1373, 508));
			tabAccess.set_TabIndex(4);
			((Control)tabAccess).set_Text("Microsoft Access");
			tabAccess.set_UseVisualStyleBackColor(true);
			((Control)txtAccessColumns).set_Anchor((AnchorStyles)7);
			((Control)txtAccessColumns).set_Location(new Point(321, 24));
			((Control)txtAccessColumns).set_Margin(new Padding(4, 4, 4, 4));
			((TextBoxBase)txtAccessColumns).set_Multiline(true);
			((Control)txtAccessColumns).set_Name("txtAccessColumns");
			txtAccessColumns.set_ScrollBars((ScrollBars)2);
			((Control)txtAccessColumns).set_Size(new Size(265, 439));
			((Control)txtAccessColumns).set_TabIndex(3);
			ToolTipSetting.SetToolTip((Control)(object)txtAccessColumns, "Editable");
			((Control)label11).set_AutoSize(true);
			((Control)label11).set_Location(new Point(324, 5));
			((Control)label11).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label11).set_Name("label11");
			((Control)label11).set_Size(new Size(159, 15));
			((Control)label11).set_TabIndex(2);
			((Control)label11).set_Text("Columns Dictionary:");
			((Control)label8).set_AutoSize(true);
			((Control)label8).set_Location(new Point(5, 5));
			((Control)label8).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label8).set_Name("label8");
			((Control)label8).set_Size(new Size(151, 15));
			((Control)label8).set_TabIndex(1);
			((Control)label8).set_Text("Tables Dictionary:");
			((Control)txtAccessTables).set_Anchor((AnchorStyles)7);
			((Control)txtAccessTables).set_Location(new Point(4, 24));
			((Control)txtAccessTables).set_Margin(new Padding(4, 4, 4, 4));
			((TextBoxBase)txtAccessTables).set_Multiline(true);
			((Control)txtAccessTables).set_Name("txtAccessTables");
			txtAccessTables.set_ScrollBars((ScrollBars)2);
			((Control)txtAccessTables).set_Size(new Size(265, 439));
			((Control)txtAccessTables).set_TabIndex(0);
			ToolTipSetting.SetToolTip((Control)(object)txtAccessTables, "Editable");
			((Control)tabXSInj).get_Controls().Add((Control)(object)txtXSRecord);
			((Control)tabXSInj).get_Controls().Add((Control)(object)txtXSInjURL);
			((Control)tabXSInj).get_Controls().Add((Control)(object)label20);
			((Control)tabXSInj).get_Controls().Add((Control)(object)label19);
			((Control)tabXSInj).get_Controls().Add((Control)(object)txtXSinjUsage);
			tabXSInj.set_Location(new Point(4, 25));
			((Control)tabXSInj).set_Margin(new Padding(4, 4, 4, 4));
			((Control)tabXSInj).set_Name("tabXSInj");
			((Control)tabXSInj).set_Size(new Size(1373, 508));
			tabXSInj.set_TabIndex(6);
			((Control)tabXSInj).set_Text("Oracle CrossSite SQL Injection");
			tabXSInj.set_UseVisualStyleBackColor(true);
			((Control)txtXSRecord).set_Location(new Point(173, 51));
			((Control)txtXSRecord).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtXSRecord).set_Name("txtXSRecord");
			((Control)txtXSRecord).set_Size(new Size(467, 25));
			((Control)txtXSRecord).set_TabIndex(4);
			((Control)txtXSInjURL).set_Location(new Point(173, 19));
			((Control)txtXSInjURL).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtXSInjURL).set_Name("txtXSInjURL");
			((Control)txtXSInjURL).set_Size(new Size(467, 25));
			((Control)txtXSInjURL).set_TabIndex(3);
			((Control)label20).set_AutoSize(true);
			((Control)label20).set_Location(new Point(12, 55));
			((Control)label20).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label20).set_Name("label20");
			((Control)label20).set_Size(new Size(151, 15));
			((Control)label20).set_TabIndex(2);
			((Control)label20).set_Text("Cross Site Record:");
			((Control)label19).set_AutoSize(true);
			((Control)label19).set_Location(new Point(12, 21));
			((Control)label19).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label19).set_Name("label19");
			((Control)label19).set_Size(new Size(127, 15));
			((Control)label19).set_TabIndex(1);
			((Control)label19).set_Text("Cross Site URL:");
			((Control)txtXSinjUsage).set_Location(new Point(12, 85));
			((Control)txtXSinjUsage).set_Margin(new Padding(4, 4, 4, 4));
			((TextBoxBase)txtXSinjUsage).set_Multiline(true);
			((Control)txtXSinjUsage).set_Name("txtXSinjUsage");
			((TextBoxBase)txtXSinjUsage).set_ReadOnly(true);
			((Control)txtXSinjUsage).set_Size(new Size(628, 364));
			((Control)txtXSinjUsage).set_TabIndex(0);
			((Control)txtXSinjUsage).set_Text(((ResourceManager)(object)val).GetString("txtXSinjUsage.Text"));
			((Control)tabAdmin).get_Controls().Add((Control)(object)label22);
			((Control)tabAdmin).get_Controls().Add((Control)(object)label17);
			((Control)tabAdmin).get_Controls().Add((Control)(object)txtAdminPage);
			((Control)tabAdmin).get_Controls().Add((Control)(object)label16);
			((Control)tabAdmin).get_Controls().Add((Control)(object)txtAdminPath);
			tabAdmin.set_Location(new Point(4, 25));
			((Control)tabAdmin).set_Margin(new Padding(4, 4, 4, 4));
			((Control)tabAdmin).set_Name("tabAdmin");
			((Control)tabAdmin).set_Size(new Size(1373, 508));
			tabAdmin.set_TabIndex(5);
			((Control)tabAdmin).set_Text("Admin Entrance Dictionary");
			tabAdmin.set_UseVisualStyleBackColor(true);
			((Control)label17).set_AutoSize(true);
			((Control)label17).set_Location(new Point(320, 5));
			((Control)label17).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label17).set_Name("label17");
			((Control)label17).set_Size(new Size(207, 15));
			((Control)label17).set_TabIndex(3);
			((Control)label17).set_Text("Admin Page(No Extension):");
			((Control)txtAdminPage).set_Anchor((AnchorStyles)7);
			((Control)txtAdminPage).set_Location(new Point(321, 24));
			((Control)txtAdminPage).set_Margin(new Padding(4, 4, 4, 4));
			((TextBoxBase)txtAdminPage).set_Multiline(true);
			((Control)txtAdminPage).set_Name("txtAdminPage");
			txtAdminPage.set_ScrollBars((ScrollBars)2);
			((Control)txtAdminPage).set_Size(new Size(265, 442));
			((Control)txtAdminPage).set_TabIndex(2);
			ToolTipSetting.SetToolTip((Control)(object)txtAdminPage, "Editable");
			((Control)label16).set_AutoSize(true);
			((Control)label16).set_Location(new Point(7, 5));
			((Control)label16).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label16).set_Name("label16");
			((Control)label16).set_Size(new Size(207, 15));
			((Control)label16).set_TabIndex(1);
			((Control)label16).set_Text("Admin Path(End with '/'):");
			((Control)txtAdminPath).set_Anchor((AnchorStyles)7);
			((Control)txtAdminPath).set_Location(new Point(4, 24));
			((Control)txtAdminPath).set_Margin(new Padding(4, 4, 4, 4));
			((TextBoxBase)txtAdminPath).set_Multiline(true);
			((Control)txtAdminPath).set_Name("txtAdminPath");
			txtAdminPath.set_ScrollBars((ScrollBars)2);
			((Control)txtAdminPath).set_Size(new Size(265, 442));
			((Control)txtAdminPath).set_TabIndex(0);
			ToolTipSetting.SetToolTip((Control)(object)txtAdminPath, "Editable");
			((Control)label18).set_AutoSize(true);
			((Control)label18).set_Location(new Point(24, 135));
			((Control)label18).set_Name("label18");
			((Control)label18).set_Size(new Size(751, 15));
			((Control)label18).set_TabIndex(36);
			((Control)label18).set_Text("Treat as CSRF field if the parameter name contains the following keywords (Seperated By '|'):");
			((Control)txtCSRF).set_Location(new Point(24, 152));
			((Control)txtCSRF).set_Name("txtCSRF");
			((Control)txtCSRF).set_Size(new Size(781, 25));
			((Control)txtCSRF).set_TabIndex(37);
			((Control)label21).set_AutoSize(true);
			((Control)label21).set_Location(new Point(8, 469));
			((Control)label21).set_Name("label21");
			((Control)label21).set_Size(new Size(551, 15));
			((Control)label21).set_TabIndex(4);
			((Control)label21).set_Text("The dictionaries are editable, just paste your dictionaries in them.");
			((Control)label22).set_AutoSize(true);
			((Control)label22).set_Location(new Point(7, 473));
			((Control)label22).set_Name("label22");
			((Control)label22).set_Size(new Size(607, 15));
			((Control)label22).set_TabIndex(4);
			((Control)label22).set_Text("The admin path and page are editable, just paste your dictionaries in them.");
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(8f, 15f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(1381, 562));
			((Control)this).get_Controls().Add((Control)(object)tabSetting);
			((Control)this).get_Controls().Add((Control)(object)toolStripSetting);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Form)this).set_Margin(new Padding(4, 4, 4, 4));
			((Control)this).set_Name("FormSetting");
			((Control)this).set_Text("FormSetting");
			((Control)toolStripSetting).ResumeLayout(false);
			((Control)toolStripSetting).PerformLayout();
			((Control)tabSetting).ResumeLayout(false);
			((Control)tabScanner).ResumeLayout(false);
			((Control)GroupBoxVulSetting).ResumeLayout(false);
			((Control)GroupBoxVulSetting).PerformLayout();
			((Control)tabProxy).ResumeLayout(false);
			((Control)tabProxy).PerformLayout();
			((Control)tabAdvanced).ResumeLayout(false);
			((Control)groupBoxReplaceSetting).ResumeLayout(false);
			((Control)groupBoxReplaceSetting).PerformLayout();
			((Control)GroupBoxScanSetting).ResumeLayout(false);
			((Control)GroupBoxScanSetting).PerformLayout();
			((Control)tabAccess).ResumeLayout(false);
			((Control)tabAccess).PerformLayout();
			((Control)tabXSInj).ResumeLayout(false);
			((Control)tabXSInj).PerformLayout();
			((Control)tabAdmin).ResumeLayout(false);
			((Control)tabAdmin).PerformLayout();
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
