using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Net;
using System.Resources;
using System.Text.RegularExpressions;
using System.Threading;
using System.Timers;
using System.Web;
using System.Web.UI;
using System.Windows.Forms;
using System.Xml;

namespace WebCruiserWVS
{
	public class FormScanner : Form
	{
		private delegate void dd(string s);

		private delegate void ddc(TreeView s, TreeView d);

		private delegate ListViewItem dl(int i);

		private FormMain mainfrm;

		private WebSite SiteA;

		private int ScanDepth;

		private List<string> urlList = new List<string>();

		private bool IsCrawlOnly;

		private Timer ScannerTimer;

		private IContainer components;

		private SplitContainer splitScanner;

		private TreeView treeViewWVS;

		private ToolStrip toolStripScanner;

		private ToolStripButton toolStripWVScan;

		private ToolStripSeparator toolStripSeparator1;

		private ToolStripButton toolStripURLScan;

		private ToolStripSeparator toolStripSeparator2;

		private ToolStripButton toolStripClearWVS;

		private ToolStripSeparator toolStripSeparator4;

		private ImageList ImageListScanner;

		private ToolStripSeparator toolStripSeparator7;

		private ListViewNF listViewWVS;

		private ColumnHeader columnAddress;

		private ColumnHeader columnVul;

		private ToolStripButton toolStripCrawler;

		private ToolStripButton toolStripPageScan;

		private ToolStripSeparator toolStripSeparator3;

		private ColumnHeader columnActionUrl;

		private ColumnHeader columnParameter;

		private TabControl tabDir_VulnInfo;

		private TabPage tabDir;

		private TabPage tabVulnInfo;

		private ListView lvVulnInfo;

		private ColumnHeader columnKey;

		private ColumnHeader columnValue;

		public FormScanner(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
			SiteA = mainfrm.CurrentSite;
			SiteA.delegateAddVulnToWVS = AddVulnToListViewWVS;
			InitSystemTimer();
		}

		public void EnableFunc(bool RegOK)
		{
			((ToolStripItem)toolStripWVScan).set_Enabled(RegOK);
		}

		private void InitSystemTimer()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_002c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0036: Expected O, but got Unknown
			ScannerTimer = new Timer();
			ScannerTimer.set_Interval(8000.0);
			ScannerTimer.add_Elapsed(new ElapsedEventHandler(ScannerTimer_Elapsed));
			ScannerTimer.set_Enabled(true);
		}

		private void CloneTreeView(TreeView SourceTree, TreeView DestTree)
		{
			//IL_002c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0032: Expected O, but got Unknown
			//IL_003e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0048: Expected O, but got Unknown
			if (!((Control)treeViewWVS).get_InvokeRequired())
			{
				DestTree.get_Nodes().Clear();
				foreach (TreeNode node in SourceTree.get_Nodes())
				{
					TreeNode val = node;
					DestTree.get_Nodes().Add((TreeNode)val.Clone());
				}
				DestTree.ExpandAll();
			}
			else
			{
				ddc ddc = CloneTreeView;
				((Control)this).Invoke((Delegate)ddc, new object[2]
				{
					SourceTree,
					DestTree
				});
			}
		}

		private void AddUrl2TreeViewWVS(string sURL)
		{
			//IL_0056: Unknown result type (might be due to invalid IL or missing references)
			//IL_005c: Expected O, but got Unknown
			//IL_0139: Unknown result type (might be due to invalid IL or missing references)
			//IL_0140: Expected O, but got Unknown
			//IL_0140: Unknown result type (might be due to invalid IL or missing references)
			//IL_0147: Expected O, but got Unknown
			try
			{
				if (string.IsNullOrEmpty(sURL))
				{
					return;
				}
				if (sURL.IndexOf('^') > 0)
				{
					string[] array = sURL.Split(new char[1]
					{
						'^'
					});
					sURL = array[0];
				}
				sURL = sURL.Replace("&amp;", "&").Replace("/./", "/");
				Uri val = new Uri(sURL);
				if (!val.get_Host().Equals(SiteA.DomainHost))
				{
					return;
				}
				if (!((Control)treeViewWVS).get_InvokeRequired())
				{
					int num = sURL.IndexOf('/', 9) + 1;
					if (num <= 0)
					{
						return;
					}
					string[] array2 = sURL.Substring(num).Split(new char[1]
					{
						'?'
					});
					string[] array3 = array2[0].Split(new char[1]
					{
						'/'
					});
					string text = "";
					if (array2.Length > 1)
					{
						for (int i = 1; i < array2.Length; i++)
						{
							if (!string.IsNullOrEmpty(text))
							{
								text += "?";
							}
							text += array2[i];
						}
						string[] array4;
						string[] array5 = (array4 = array3);
						int num2 = array3.Length - 1;
						nint num3 = num2;
						array5[num2] = array4[num3] + "?" + text;
					}
					TreeNode val2 = new TreeNode();
					TreeNode val3 = new TreeNode();
					for (int j = 0; j < array3.Length; j++)
					{
						if (string.IsNullOrEmpty(array3[j]))
						{
							return;
						}
						if (j == 0)
						{
							val2 = ContainsTreeNode(treeViewWVS.get_Nodes(), array3[0]);
							if (val2 == null)
							{
								val2 = treeViewWVS.get_Nodes().Add(array3[0]);
							}
							continue;
						}
						val3 = ContainsTreeNode(val2.get_Nodes(), array3[j]);
						if (val3 == null)
						{
							val3 = val2.get_Nodes().Add(array3[j]);
						}
						val2 = val3;
					}
					treeViewWVS.ExpandAll();
					((Control)treeViewWVS).Refresh();
					return;
				}
				dd dd = AddUrl2TreeViewWVS;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					sURL
				});
			}
			catch (Exception)
			{
			}
		}

		public void AddNewVuln(Vulnerability vuln)
		{
			SiteA.allVulnList.Add(vuln);
			AddVulnToListViewWVS(vuln);
		}

		public void AddVulnToListViewWVS(Vulnerability vuln)
		{
			if (!((Control)listViewWVS).get_InvokeRequired())
			{
				ListViewItem val = ((ListView)listViewWVS).get_Items().Add(vuln.vulnReferUrl);
				val.get_SubItems().Add(vuln.vulnDescription);
				val.get_SubItems().Add(vuln.vulnActionUrl);
				val.get_SubItems().Add(vuln.vulnParameter);
				val.set_ImageKey("vul.png");
				val.EnsureVisible();
				((Control)listViewWVS).Refresh();
			}
			else
			{
				DelegateAddVulnToWVS delegateAddVulnToWVS = AddVulnToListViewWVS;
				((Control)this).Invoke((Delegate)delegateAddVulnToWVS, new object[1]
				{
					vuln
				});
			}
		}

		private TreeNode ContainsTreeNode(TreeNodeCollection tn, string Text)
		{
			string text = Text;
			string text2 = "";
			if (Text.IndexOf('?') >= 0)
			{
				string[] array = Text.Split(new char[1]
				{
					'?'
				});
				text = array[0];
				if (array.Length >= 2)
				{
					string[] array2 = array[1].Split(new char[1]
					{
						'&'
					});
					string[] array3 = array2;
					foreach (string text3 in array3)
					{
						string[] array4 = text3.Split(new char[1]
						{
							'='
						});
						text = text + "?" + array4[0];
					}
				}
			}
			for (int j = 0; j < tn.get_Count(); j++)
			{
				text2 = tn.get_Item(j).get_Text();
				if (text2.IndexOf('?') >= 0)
				{
					string[] array5 = text2.Split(new char[1]
					{
						'?'
					});
					if (array5.Length < 2)
					{
						text2 = array5[0];
					}
					else
					{
						text2 = array5[0];
						string[] array6 = array5[1].Split(new char[1]
						{
							'&'
						});
						string[] array7 = array6;
						foreach (string text4 in array7)
						{
							string[] array8 = text4.Split(new char[1]
							{
								'='
							});
							text2 = text2 + "?" + array8[0];
						}
					}
				}
				if (text2.Equals(text))
				{
					return tn.get_Item(j);
				}
			}
			return null;
		}

		private void CheckRobots(object data)
		{
			//IL_004b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0055: Invalid comparison between Unknown and I4
			//IL_0073: Unknown result type (might be due to invalid IL or missing references)
			//IL_0079: Expected O, but got Unknown
			//IL_0094: Unknown result type (might be due to invalid IL or missing references)
			//IL_009b: Expected O, but got Unknown
			try
			{
				string sURL = SiteA.HTTPRoot + "robots.txt";
				HttpWebResponse httpWebResponse = SiteA.GetHttpWebResponse(sURL, RequestType.GET, "", "", "", WebSite.EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					return;
				}
				if ((int)httpWebResponse.get_StatusCode() == 200)
				{
					string sourceCodeFromHttpWebResponse = mainfrm.CurrentSite.GetSourceCodeFromHttpWebResponse(httpWebResponse);
					Regex val = new Regex("(?<=allow:\\s+)[^\\s?*$]+", (RegexOptions)17);
					MatchCollection val2 = val.Matches(sourceCodeFromHttpWebResponse);
					foreach (Match item in val2)
					{
						Match val3 = item;
						string value = ((Capture)val3).get_Value();
						if (value.Length > 1)
						{
							value = SiteA.HTTPRoot + value.Substring(1);
							if (!SiteA.Is404URL(value, "CheckRobots"))
							{
								AddUrl2TreeViewWVS(value);
							}
						}
					}
				}
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
			}
			catch (Exception)
			{
			}
		}

		private void CheckSiteMapXML(object data)
		{
			//IL_004b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0055: Invalid comparison between Unknown and I4
			//IL_0073: Unknown result type (might be due to invalid IL or missing references)
			//IL_0079: Expected O, but got Unknown
			//IL_0094: Unknown result type (might be due to invalid IL or missing references)
			//IL_009b: Expected O, but got Unknown
			try
			{
				string sURL = SiteA.HTTPRoot + "sitemap.xml";
				HttpWebResponse httpWebResponse = SiteA.GetHttpWebResponse(sURL, RequestType.GET, "", "", "", WebSite.EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					return;
				}
				if ((int)httpWebResponse.get_StatusCode() == 200)
				{
					string sourceCodeFromHttpWebResponse = mainfrm.CurrentSite.GetSourceCodeFromHttpWebResponse(httpWebResponse);
					Regex val = new Regex("(?<=<loc>)[\\S]+(?=<\\/loc>)", (RegexOptions)17);
					MatchCollection val2 = val.Matches(sourceCodeFromHttpWebResponse);
					foreach (Match item in val2)
					{
						Match val3 = item;
						string value = ((Capture)val3).get_Value();
						if (value.Length > 1 && WebSite.IsValidLink(value) && !SiteA.Is404URL(value, "CheckSiteMapXML"))
						{
							AddUrl2TreeViewWVS(value);
						}
					}
				}
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
			}
			catch (Exception)
			{
			}
		}

		private bool IsWebPage(string sURL)
		{
			string fileExt = SiteA.GetFileExt(sURL);
			if (string.IsNullOrEmpty(fileExt))
			{
				return true;
			}
			fileExt = fileExt.Substring(1).ToLower();
			string[] array = WCRSetting.CrawlableExt.Split(new char[1]
			{
				':'
			});
			for (int i = 0; i < array.Length; i++)
			{
				if (fileExt.Equals(array[i]))
				{
					return true;
				}
			}
			return false;
		}

		public void DisplayProgress(string Text)
		{
			mainfrm.DisplayLogList(Text);
		}

		private void CrawlPage(object Data)
		{
			//IL_0126: Unknown result type (might be due to invalid IL or missing references)
			//IL_012d: Expected O, but got Unknown
			if (WebSite.CurrentStatus == TaskStatus.Stop)
			{
				return;
			}
			try
			{
				string text = (string)Data;
				if (SiteA.HasCrawledURL(text))
				{
					return;
				}
				SiteA.AddCrawledURL(WebSite.URL2DistinctURL(text));
				if (!IsWebPage(text))
				{
					return;
				}
				string fileExt = SiteA.GetFileExt(text);
				DisplayProgress("Depth: " + ScanDepth + "  Scanning: " + text);
				HttpWebResponse httpWebResponse = SiteA.GetHttpWebResponse(text, RequestType.GET, "", "", "", WebSite.EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					return;
				}
				string sourceCodeFromHttpWebResponse = mainfrm.CurrentSite.GetSourceCodeFromHttpWebResponse(httpWebResponse);
				string text2 = ((object)((WebResponse)httpWebResponse).get_ResponseUri()).ToString();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				if (!text2.Equals(text))
				{
					SiteA.AddCrawledURL(WebSite.URL2DistinctURL(text2));
				}
				string pathFromURL = WebSite.GetPathFromURL(text2);
				string[] linksFromSource = SiteA.GetLinksFromSource(sourceCodeFromHttpWebResponse, pathFromURL, fileExt);
				string text3 = "";
				for (int i = 0; i < linksFromSource.Length; i++)
				{
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						break;
					}
					text3 = linksFromSource[i];
					Uri val = new Uri(text3);
					if (val.get_Host().Equals(SiteA.DomainHost) && !SiteA.Is404URL(text3, "CrawlPage"))
					{
						AddUrl2TreeViewWVS(text3);
						AddUrl2TreeViewWVS(WebSite.URL2NoParaURL(text3));
						if (!SiteA.HasScannedURL(text3) && !IsCrawlOnly && IsWebPage(text3))
						{
							ThreadPool.QueueUserWorkItem(new WaitCallback(CheckVulnerability), text3);
						}
					}
				}
			}
			catch (Exception)
			{
			}
		}

		private void CrawlAndScanCurrentPage(object Data)
		{
			//IL_011f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0126: Expected O, but got Unknown
			if (WebSite.CurrentStatus == TaskStatus.Stop)
			{
				return;
			}
			try
			{
				string text = (string)Data;
				string pathFromURL = WebSite.GetPathFromURL(text);
				if (SiteA.HasCrawledURL(text))
				{
					return;
				}
				SiteA.AddCrawledURL(WebSite.URL2DistinctURL(text));
				if (!IsWebPage(text))
				{
					return;
				}
				string fileExt = SiteA.GetFileExt(text);
				HttpWebResponse httpWebResponse = SiteA.GetHttpWebResponse(text, RequestType.GET, "", "", "", WebSite.EscapeCookie, "", "");
				if (httpWebResponse == null)
				{
					return;
				}
				string sourceCodeFromHttpWebResponse = mainfrm.CurrentSite.GetSourceCodeFromHttpWebResponse(httpWebResponse);
				string text2 = ((object)((WebResponse)httpWebResponse).get_ResponseUri()).ToString();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				if (!text2.Equals(text))
				{
					SiteA.AddCrawledURL(WebSite.URL2DistinctURL(text2));
				}
				string pathFromURL2 = WebSite.GetPathFromURL(text2);
				string[] linksFromSource = SiteA.GetLinksFromSource(sourceCodeFromHttpWebResponse, pathFromURL2, fileExt);
				string[] array = linksFromSource;
				foreach (string text3 in array)
				{
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						break;
					}
					string pathFromURL3 = WebSite.GetPathFromURL(text3);
					if (pathFromURL3.IndexOf(pathFromURL) < 0)
					{
						continue;
					}
					Uri val = new Uri(text3);
					if (val.get_Host().Equals(SiteA.DomainHost) && !SiteA.Is404URL(text3, "CrawlAndScanCurrentPage"))
					{
						AddUrl2TreeViewWVS(text3);
						AddUrl2TreeViewWVS(WebSite.URL2NoParaURL(text3));
						if (!SiteA.HasScannedURL(text3) && IsWebPage(text3))
						{
							ThreadPool.QueueUserWorkItem(new WaitCallback(CheckVulnerability), text3);
						}
					}
				}
			}
			catch (Exception)
			{
			}
		}

		private void CheckVulnerability(object data)
		{
			try
			{
				if (IsCrawlOnly || WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return;
				}
				string text = (string)data;
				text = HttpUtility.UrlDecode(text);
				text = text.TrimEnd('\'', '"', '#');
				if (SiteA.GetFileExt(text).Equals(".js"))
				{
					return;
				}
				if (!SiteA.HasScannedURL(text))
				{
					SiteA.AddScannedURL(WebSite.URL2DistinctURL(text));
					if (text.IndexOf('=') > 0)
					{
						if (WCRSetting.ScanSQLInjection)
						{
							DisplayProgress("Checking SQL Injection: " + text);
							VulnSQLInjection[] sQLInjectionVulnCollection = SiteA.GetSQLInjectionVulnCollection(text, RequestType.GET, text, skipScanned: true, testEscapeSpace: false, "");
							if (sQLInjectionVulnCollection.Length == 0)
							{
								sQLInjectionVulnCollection = SiteA.GetSQLInjectionVulnCollection(text, RequestType.GET, text, skipScanned: true, testEscapeSpace: true, "");
							}
							VulnSQLInjection[] array = sQLInjectionVulnCollection;
							foreach (VulnSQLInjection vuln in array)
							{
								AddNewVuln(vuln);
							}
						}
						if (WCRSetting.ScanXSS)
						{
							DisplayProgress("Checking URL XSS: " + text);
							VulnXSS[] xSSVulnCollection = SiteA.GetXSSVulnCollection(text, RequestType.GET, isSkipScanned: true, isDetectCsrf: false, null);
							VulnXSS[] array2 = xSSVulnCollection;
							foreach (VulnXSS vuln2 in array2)
							{
								AddNewVuln(vuln2);
							}
						}
						if (WCRSetting.ScanLFI)
						{
							DisplayProgress("Checking LFI: " + text);
							VulnLFI[] lFIVulnCollection = SiteA.GetLFIVulnCollection(text, RequestType.GET, isSkipScanned: true, isDetectCsrf: false, null);
							VulnLFI[] array3 = lFIVulnCollection;
							foreach (VulnLFI vuln3 in array3)
							{
								AddNewVuln(vuln3);
							}
						}
						if (WCRSetting.ScanRFI)
						{
							DisplayProgress("Checking RFI: " + text);
							Vulnerability[] rFIVulnCollection = SiteA.GetRFIVulnCollection(text, RequestType.GET, isSkipScanned: true, isDetectCsrf: false, null);
							Vulnerability[] array4 = rFIVulnCollection;
							foreach (Vulnerability vuln4 in array4)
							{
								AddNewVuln(vuln4);
							}
						}
					}
					if (WCRSetting.ScanBackup)
					{
						DisplayProgress("Checking Obsolete Backup: " + text);
						VulnBackup[] backupVulnCollection = SiteA.GetBackupVulnCollection(text, isSkipScanned: true);
						VulnBackup[] array5 = backupVulnCollection;
						foreach (VulnBackup vuln5 in array5)
						{
							AddNewVuln(vuln5);
						}
					}
				}
				if (WebSite.CurrentStatus != TaskStatus.Stop)
				{
					DisplayProgress("Checking Form Vuln with Referer: " + text);
					Vulnerability[] formVulnCollection = SiteA.GetFormVulnCollection(text, skipScanned: true);
					Vulnerability[] array6 = formVulnCollection;
					foreach (Vulnerability vuln6 in array6)
					{
						AddNewVuln(vuln6);
					}
				}
			}
			catch
			{
			}
		}

		private void TreeNode2URLS(string Path, TreeNode tn)
		{
			//IL_0077: Unknown result type (might be due to invalid IL or missing references)
			//IL_007d: Expected O, but got Unknown
			if (WebSite.CurrentStatus == TaskStatus.Stop)
			{
				return;
			}
			if (tn.get_Nodes().get_Count() == 0)
			{
				string sURL = Path + tn.get_Text();
				if (IsWebPage(sURL))
				{
					urlList.Add(Path + tn.get_Text());
				}
				return;
			}
			urlList.Add(Path + tn.get_Text() + "/");
			foreach (TreeNode node in tn.get_Nodes())
			{
				TreeNode tn2 = node;
				TreeNode2URLS(Path + tn.get_Text() + "/", tn2);
			}
		}

		private void CrawlTreeViewWVS()
		{
			//IL_000b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0011: Expected O, but got Unknown
			//IL_0034: Unknown result type (might be due to invalid IL or missing references)
			//IL_003a: Expected O, but got Unknown
			try
			{
				urlList.Clear();
				TreeView val = new TreeView();
				CloneTreeView(treeViewWVS, val);
				foreach (TreeNode node in val.get_Nodes())
				{
					TreeNode val2 = node;
					if (val2.get_Nodes().get_Count() == 0)
					{
						string text = SiteA.HTTPRoot + val2.get_Text();
						if (IsWebPage(text))
						{
							urlList.Add(text);
						}
					}
					else
					{
						TreeNode2URLS(SiteA.HTTPRoot, val2);
					}
				}
				for (int i = 0; i < urlList.Count; i++)
				{
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						break;
					}
					if (IsWebPage(urlList[i]))
					{
						CrawlPage(urlList[i]);
					}
				}
			}
			catch
			{
			}
		}

		private ListViewItem GetListViewItem(int Index)
		{
			//IL_0044: Unknown result type (might be due to invalid IL or missing references)
			//IL_004a: Expected O, but got Unknown
			if (!((Control)listViewWVS).get_InvokeRequired())
			{
				return ((ListView)listViewWVS).get_Items().get_Item(Index);
			}
			dl dl = GetListViewItem;
			return (ListViewItem)((Control)this).Invoke((Delegate)dl, new object[1]
			{
				Index
			});
		}

		private XmlDocument TreeNode2XmlElement(XmlDocument WVSXml, XmlElement ParentElem, TreeNode tn)
		{
			//IL_0031: Unknown result type (might be due to invalid IL or missing references)
			//IL_0037: Expected O, but got Unknown
			XmlElement val = WVSXml.CreateElement("DIR");
			val.SetAttribute("Value", tn.get_Text());
			foreach (TreeNode node in tn.get_Nodes())
			{
				TreeNode tn2 = node;
				WVSXml = TreeNode2XmlElement(WVSXml, val, tn2);
			}
			((XmlNode)ParentElem).AppendChild((XmlNode)(object)val);
			return WVSXml;
		}

		public XmlDocument GetXmlDocumentFromDirTree()
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_0067: Unknown result type (might be due to invalid IL or missing references)
			//IL_006e: Expected O, but got Unknown
			XmlDocument val = new XmlDocument();
			XmlNode val2 = (XmlNode)(object)val.CreateXmlDeclaration("1.0", "utf-8", "");
			((XmlNode)val).AppendChild(val2);
			XmlElement val3 = val.CreateElement("ROOT");
			((XmlNode)val).AppendChild((XmlNode)(object)val3);
			XmlElement val4 = val.CreateElement("SiteDirTree");
			((XmlNode)val3).AppendChild((XmlNode)(object)val4);
			foreach (TreeNode node in treeViewWVS.get_Nodes())
			{
				TreeNode tn = node;
				val = TreeNode2XmlElement(val, val4, tn);
			}
			return val;
		}

		public XmlDocument GetXmlDocumentFromWVS()
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			XmlDocument val = new XmlDocument();
			XmlNode val2 = (XmlNode)(object)val.CreateXmlDeclaration("1.0", "utf-8", "");
			((XmlNode)val).AppendChild(val2);
			XmlElement val3 = val.CreateElement("ROOT");
			((XmlNode)val).AppendChild((XmlNode)(object)val3);
			XmlElement val4 = val.CreateElement("SiteVulList");
			((XmlNode)val3).AppendChild((XmlNode)(object)val4);
			foreach (Vulnerability allVuln in SiteA.allVulnList)
			{
				XmlElement val5 = val.CreateElement("VulRow");
				XmlElement val6 = val.CreateElement("ReferURL");
				((XmlNode)val6).set_InnerText(allVuln.vulnReferUrl);
				((XmlNode)val5).AppendChild((XmlNode)(object)val6);
				val6 = val.CreateElement("ActionURL");
				((XmlNode)val6).set_InnerText(allVuln.vulnActionUrl);
				((XmlNode)val5).AppendChild((XmlNode)(object)val6);
				val6 = val.CreateElement("Parameter");
				((XmlNode)val6).set_InnerText(allVuln.vulnParameter);
				((XmlNode)val5).AppendChild((XmlNode)(object)val6);
				val6 = val.CreateElement("Vulnerability");
				((XmlNode)val6).set_InnerText(allVuln.vulnDescription);
				((XmlNode)val5).AppendChild((XmlNode)(object)val6);
				((XmlNode)val4).AppendChild((XmlNode)(object)val5);
			}
			return val;
		}

		private void ExportWVS(string WVSXmlFileName)
		{
			//IL_004a: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				XmlDocument xmlDocumentFromWVS = GetXmlDocumentFromWVS();
				int num = 1;
				while (File.Exists(Application.get_StartupPath() + "\\" + WVSXmlFileName))
				{
					WVSXmlFileName = num + "_" + WVSXmlFileName;
					num++;
				}
				xmlDocumentFromWVS.Save(WVSXmlFileName);
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private string GenReport(XmlDocument WcrXml)
		{
			//IL_002e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0034: Expected O, but got Unknown
			//IL_0035: Unknown result type (might be due to invalid IL or missing references)
			//IL_003b: Expected O, but got Unknown
			//IL_026c: Unknown result type (might be due to invalid IL or missing references)
			string text = SiteA.DomainHost + "_Scan_Report_" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".html";
			StringWriter val = new StringWriter();
			try
			{
				HtmlTextWriter val2 = new HtmlTextWriter((TextWriter)(object)val);
				val2.RenderBeginTag((HtmlTextWriterTag)43);
				val2.RenderBeginTag((HtmlTextWriterTag)41);
				((TextWriter)(object)val2).Write("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">");
				((TextWriter)(object)val2).Write("<style>table{table-layout:fixed;overflow:hidden;}</style>");
				val2.RenderBeginTag((HtmlTextWriterTag)89);
				((TextWriter)(object)val2).Write("Scan Report");
				val2.RenderEndTag();
				val2.RenderEndTag();
				val2.RenderBeginTag((HtmlTextWriterTag)12);
				val2.RenderBeginTag((HtmlTextWriterTag)16);
				((TextWriter)(object)val2).Write("<br><br><br><br><br><br><br><br>");
				val2.RenderBeginTag((HtmlTextWriterTag)35);
				((TextWriter)(object)val2).Write(SiteA.DomainHost + " Scan Report<br>");
				val2.RenderEndTag();
				((TextWriter)(object)val2).Write("<br><br><br><br><br><br><br><br>Created By WebCruiser - Web Vulnerability Scanner<br>" + DateTime.Now.ToString("yyyy-MM-dd"));
				((TextWriter)(object)val2).Write("<div style=\"page-break-after:always\">&nbsp;</div>");
				XmlNodeList val3 = ((XmlNode)WcrXml).SelectNodes("//ROOT/SiteVulList/VulRow");
				if (val3.get_Count() > 0)
				{
					val2.RenderBeginTag((HtmlTextWriterTag)36);
					((TextWriter)(object)val2).Write("Vulnerability Result");
					val2.RenderEndTag();
					for (int i = 0; i < val3.get_Count(); i++)
					{
						val2.AddAttribute("border", "1");
						val2.AddAttribute("width", "640");
						val2.AddAttribute("cellspacing", "0");
						val2.AddAttribute("bordercolordark", "009099");
						val2.RenderBeginTag((HtmlTextWriterTag)82);
						((TextWriter)(object)val2).Write("<tr><td width=\"150\">No.</td><td>" + (i + 1) + "</td></tr>");
						XmlNode val4 = val3.get_ItemOf(i);
						for (int j = 0; j < val4.get_ChildNodes().get_Count(); j++)
						{
							((TextWriter)(object)val2).Write("<tr><td width=\"150\">");
							((TextWriter)(object)val2).Write(val4.get_ChildNodes().get_ItemOf(j).get_Name());
							((TextWriter)(object)val2).Write("</td><td>");
							((TextWriter)(object)val2).Write(val4.get_ChildNodes().get_ItemOf(j).get_InnerText()
								.Replace("<>", "&lt;&gt;"));
							((TextWriter)(object)val2).Write("</td></tr>");
						}
						val2.RenderEndTag();
						((TextWriter)(object)val2).Write("<br>");
					}
				}
				val2.RenderEndTag();
				val2.RenderEndTag();
				val2.RenderEndTag();
				File.WriteAllText(text, ((object)val).ToString());
				return text;
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
				File.WriteAllText(text, ((object)val).ToString());
				return text;
			}
		}

		private void toolStripWVScan_Click(object sender, EventArgs e)
		{
			ScanCurrentSite(isCrawlOnly: false);
		}

		private string GetScannerSettingString()
		{
			string str = "Scanner will use the following settings:\r\n";
			str = str + "Scan SQL Injection:                         " + (WCRSetting.ScanSQLInjection ? "Yes" : "No") + "\r\n";
			if (WCRSetting.ScanSQLInjection)
			{
				str = str + "    Scan URL SQL Injection:               " + (WCRSetting.ScanURLSQL ? "Yes" : "No") + "\r\n";
				str = str + "    Scan POST SQL Injection:             " + (WCRSetting.ScanPostSQL ? "Yes" : "No") + "\r\n";
				str = str + "    Scan Cookie SQL Injection:           " + (WCRSetting.ScanCookieSQL ? "Yes" : "No") + "\r\n";
			}
			str = str + "Scan XSS (Cross Site Scripting):         " + (WCRSetting.ScanXSS ? "Yes" : "No") + "\r\n";
			str = str + "Scan LFI (Local File Inclusion):            " + (WCRSetting.ScanLFI ? "Yes" : "No") + "\r\n";
			str = str + "Scan RFI (Remote File Inclusion)/Redirect:  " + (WCRSetting.ScanRFI ? "Yes" : "No") + "\r\n";
			str = str + "Scan Obsolete Backup (Information Leakage):  " + (WCRSetting.ScanBackup ? "Yes" : "No") + "\r\n";
			str = str + "* Use single HTTP thread (Default: No):  " + (WCRSetting.UseSingleThread ? "Yes" : "No") + "\r\n";
			if (WCRSetting.UseSingleThread)
			{
				str = str + "* Time Interval :  " + WCRSetting.SecondsDelay + " Seconds\r\n";
			}
			return str;
		}

		private bool IsPrivateOrDemoSite()
		{
			string domainHost = SiteA.DomainHost;
			if (domainHost.Equals("127.0.0.1"))
			{
				return true;
			}
			if (domainHost.Equals("vulnweb.janusec.com"))
			{
				return true;
			}
			if (Regex.IsMatch(domainHost, "(192\\.168\\.|10\\.)[\\d\\.]+"))
			{
				return true;
			}
			return false;
		}

		private string GetFreeEditionNotice()
		{
			string str = "The Free Edition can scan the following address for non-commercial use:\r\n";
			str += "- 127.0.0.1   (IP Address Only)\r\n";
			str += "- 192.168.*.* (IP Address Only)\r\n";
			return str + "- 10.*.*.*     (IP Address Only)\r\n";
		}

		public void ScanCurrentSite(bool isCrawlOnly)
		{
			//IL_003c: Unknown result type (might be due to invalid IL or missing references)
			//IL_006e: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a6: Invalid comparison between Unknown and I4
			//IL_00d3: Unknown result type (might be due to invalid IL or missing references)
			IsCrawlOnly = isCrawlOnly;
			SiteA.URL = mainfrm.URL;
			if (string.IsNullOrEmpty(SiteA.URL))
			{
				MessageBox.Show("Please input a valid URL!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				mainfrm.URLTextBoxFocus();
				return;
			}
			if (WCRSetting.wvsEdition == WVSEdition.Free && !IsPrivateOrDemoSite())
			{
				string freeEditionNotice = GetFreeEditionNotice();
				MessageBox.Show(freeEditionNotice, "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			string str = (IsCrawlOnly ? "" : GetScannerSettingString());
			string text = "Software Disclaimer: \r\n\r\n* You must be authorized from the web application owner.\r\n* Backup the database before scanning so as to avoid disaster.\r\n* Use it at your own risk.\r\n* Login as a legal user will help you find more vulnerabilities.\r\n* But not login is better if you intend to scan the login page.\r\n* Continue?\r\n\r\n" + str;
			if ((int)MessageBox.Show(text, "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) == 2)
			{
				return;
			}
			if (SiteA.Is404URL(SiteA.URL, "ScanCurrentSite"))
			{
				MessageBox.Show("Please input a valid URL!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			AddUrl2TreeViewWVS(SiteA.URL);
			if (isCrawlOnly)
			{
				mainfrm.DisplayProgress("Crawling site ...");
			}
			else
			{
				mainfrm.DisplayProgress("Scanning site ...");
			}
			ThreadPool.QueueUserWorkItem(new WaitCallback(CheckRobots));
			ThreadPool.QueueUserWorkItem(new WaitCallback(CheckSiteMapXML));
			ThreadPool.QueueUserWorkItem(new WaitCallback(CrawlPage), SiteA.URL);
			Thread thread = new Thread((ThreadStart)delegate
			{
				for (int i = 0; i < WCRSetting.ScanDepth; i++)
				{
					while (SiteA.HTTPThreadNum > 0)
					{
						Thread.Sleep(200);
					}
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						break;
					}
					if (i == 0)
					{
						ThreadPool.QueueUserWorkItem(new WaitCallback(CheckVulnerability), SiteA.URL);
					}
					ScanDepth = i + 1;
					Thread.Sleep(1000);
					CrawlTreeViewWVS();
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						break;
					}
				}
			});
			thread.Start();
		}

		private void toolStripURLScan_Click(object sender, EventArgs e)
		{
			ScanCurrentURL();
		}

		public void ScanCurrentURL()
		{
			//IL_001f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0051: Unknown result type (might be due to invalid IL or missing references)
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_007a: Invalid comparison between Unknown and I4
			if (string.IsNullOrEmpty(SiteA.URL))
			{
				MessageBox.Show("Please input a valid URL!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				mainfrm.URLTextBoxFocus();
				return;
			}
			if (WCRSetting.wvsEdition == WVSEdition.Free && !IsPrivateOrDemoSite())
			{
				string freeEditionNotice = GetFreeEditionNotice();
				MessageBox.Show(freeEditionNotice, "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			string scannerSettingString = GetScannerSettingString();
			string text = "Software Disclaimer: \r\n\r\n* You must be authorized from the web application owner.\r\n* Backup the database before scanning so as to avoid disaster.\r\n* Use it at your own risk.\r\n* Login as a legal user will help you find more vulnerabilities.\r\n* But not login is better if you intend to scan the login page.\r\n* Continue?\r\n\r\n" + scannerSettingString;
			if ((int)MessageBox.Show(text, "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) != 2)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(CheckVulnerability), SiteA.URL);
				mainfrm.DisplayProgress("Scanning URL ...");
			}
		}

		public void ScanCurrentPage()
		{
			//IL_001f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0051: Unknown result type (might be due to invalid IL or missing references)
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_007a: Invalid comparison between Unknown and I4
			if (string.IsNullOrEmpty(SiteA.URL))
			{
				MessageBox.Show("Please input a valid URL!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				mainfrm.URLTextBoxFocus();
				return;
			}
			if (WCRSetting.wvsEdition == WVSEdition.Free && !IsPrivateOrDemoSite())
			{
				string freeEditionNotice = GetFreeEditionNotice();
				MessageBox.Show(freeEditionNotice, "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			string scannerSettingString = GetScannerSettingString();
			string text = "Software Disclaimer: \r\n\r\n* You must be authorized from the web application owner.\r\n* Backup the database before scanning so as to avoid disaster.\r\n* Use it at your own risk.\r\n* Login as a legal user will help you find more vulnerabilities.\r\n* But not login is better if you intend to scan the login page.\r\n* Continue?\r\n\r\n" + scannerSettingString;
			if ((int)MessageBox.Show(text, "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) != 2)
			{
				mainfrm.DisplayProgress("Scanning Page ...");
				ThreadPool.QueueUserWorkItem(new WaitCallback(CheckVulnerability), SiteA.URL);
				WebSite.DebugLog("Scan Page, crawl links and scan ...");
				ThreadPool.QueueUserWorkItem(new WaitCallback(CrawlAndScanCurrentPage), SiteA.URL);
			}
		}

		private void toolStripClearWVS_Click(object sender, EventArgs e)
		{
			treeViewWVS.get_Nodes().Clear();
			((ListView)listViewWVS).get_Items().Clear();
			lvVulnInfo.get_Items().Clear();
			SiteA.allVulnList.Clear();
			SiteA.ClearWVS();
			SiteA.wvsFileName = "";
			mainfrm.ClearLogList();
			SiteA.HTTPThreadNum = 0;
		}

		private void XmlNode2TreeNode(XmlNode dir, TreeNode ParentTn)
		{
			//IL_0014: Unknown result type (might be due to invalid IL or missing references)
			//IL_001a: Expected O, but got Unknown
			foreach (XmlNode childNode in dir.get_ChildNodes())
			{
				XmlNode val = childNode;
				TreeNode parentTn = ParentTn.get_Nodes().Add(((XmlNode)val.get_Attributes().get_ItemOf("Value")).get_Value());
				if (val.get_ChildNodes().get_Count() > 0)
				{
					XmlNode2TreeNode(val, parentTn);
				}
			}
		}

		public void LoadFromXmlDocument(XmlDocument WVSXml)
		{
			//IL_001d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0023: Expected O, but got Unknown
			//IL_00c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ce: Expected O, but got Unknown
			//IL_00e0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e7: Expected O, but got Unknown
			XmlNodeList val = ((XmlNode)WVSXml).SelectNodes("//ROOT/SiteDirTree/DIR");
			foreach (XmlNode item in val)
			{
				XmlNode val2 = item;
				TreeNode parentTn = treeViewWVS.get_Nodes().Add(((XmlNode)val2.get_Attributes().get_ItemOf("Value")).get_Value());
				if (val2.get_ChildNodes().get_Count() > 0)
				{
					XmlNode2TreeNode(val2, parentTn);
				}
			}
			treeViewWVS.ExpandAll();
			XmlNodeList val3 = ((XmlNode)WVSXml).SelectNodes("//ROOT/SiteVulList/VulRow");
			((ListView)listViewWVS).get_Items().Clear();
			SiteA.allVulnList.Clear();
			foreach (XmlNode item2 in val3)
			{
				XmlNode val4 = item2;
				ListViewItem val5 = new ListViewItem(val4.get_ChildNodes().get_ItemOf(0).get_InnerText());
				val5.get_SubItems().Add(val4.get_ChildNodes().get_ItemOf(2).get_InnerText());
				val5.set_ImageKey("vul.png");
				((ListView)listViewWVS).get_Items().Add(val5);
			}
		}

		private void toolStripImpWVS_Click(object sender, EventArgs e)
		{
			//IL_0020: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Invalid comparison between Unknown and I4
			//IL_003a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0040: Expected O, but got Unknown
			//IL_0057: Unknown result type (might be due to invalid IL or missing references)
			//IL_005c: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Unknown result type (might be due to invalid IL or missing references)
			//IL_005f: Invalid comparison between Unknown and I4
			//IL_0078: Unknown result type (might be due to invalid IL or missing references)
			//IL_007e: Expected O, but got Unknown
			//IL_0097: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (((ListView)listViewWVS).get_Items().get_Count() <= 0)
				{
					goto IL_003a;
				}
				if ((int)MessageBox.Show("* Import Vuls Will Clear Current Vuls Information.\r\n* Continue?\r\n", "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) == 2)
				{
					return;
				}
				((ListView)listViewWVS).get_Items().Clear();
				goto IL_003a;
				IL_003a:
				OpenFileDialog val = new OpenFileDialog();
				((FileDialog)val).set_Filter("XML File(*.xml)|*.xml");
				((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
				DialogResult val2 = ((CommonDialog)val).ShowDialog();
				if ((int)val2 == 1)
				{
					string fileName = ((FileDialog)val).get_FileName();
					((Component)val).Dispose();
					if (!string.IsNullOrEmpty(fileName))
					{
						XmlDocument val3 = new XmlDocument();
						val3.Load(fileName);
						LoadFromXmlDocument(val3);
					}
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void toolStripExpWVS_Click(object sender, EventArgs e)
		{
			//IL_0046: Unknown result type (might be due to invalid IL or missing references)
			//IL_004c: Expected O, but got Unknown
			//IL_006a: Unknown result type (might be due to invalid IL or missing references)
			//IL_006f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0070: Unknown result type (might be due to invalid IL or missing references)
			//IL_0072: Invalid comparison between Unknown and I4
			//IL_0093: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (((ListView)listViewWVS).get_Items().get_Count() >= 1)
				{
					string fileName = SiteA.DomainHost + "_Vuls_" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xml";
					SaveFileDialog val = new SaveFileDialog();
					((FileDialog)val).set_Filter("XML File(*.xml) | *.xml");
					((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
					((FileDialog)val).set_FileName(fileName);
					DialogResult val2 = ((CommonDialog)val).ShowDialog();
					if ((int)val2 == 1)
					{
						fileName = ((FileDialog)val).get_FileName();
						((Component)val).Dispose();
						ExportWVS(fileName);
					}
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void treeViewWVS_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
		{
			//IL_0019: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0032: Expected O, but got Unknown
			Point val = default(Point);
			((Point)(ref val))._002Ector(((MouseEventArgs)e).get_X(), ((MouseEventArgs)e).get_Y());
			TreeNode nodeAt = treeViewWVS.GetNodeAt(val);
			treeViewWVS.set_SelectedNode(nodeAt);
			ContextMenuStrip val2 = new ContextMenuStrip();
			((ToolStrip)val2).get_Items().Add("Copy To ClipBoard", (Image)null, (EventHandler)SiteTreeItemClick);
			((Control)treeViewWVS).set_ContextMenuStrip(val2);
		}

		private void SiteTreeItemClick(object sender, EventArgs e)
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				string text;
				if ((text = ((ToolStripItem)(ToolStripMenuItem)sender).get_Text()) != null && text == "Copy To ClipBoard")
				{
					Clipboard.SetText(treeViewWVS.get_SelectedNode().get_Text());
				}
			}
			catch
			{
			}
		}

		private void listViewWVS_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_0018: Unknown result type (might be due to invalid IL or missing references)
			//IL_001e: Expected O, but got Unknown
			try
			{
				if (((ListView)listViewWVS).get_SelectedItems().get_Count() >= 1)
				{
					ContextMenuStrip val = new ContextMenuStrip();
					((ToolStrip)val).get_Items().Add("Navigate Refer URL", (Image)null, (EventHandler)WVSItemClick);
					((ToolStrip)val).get_Items().Add("Copy Refer URL", (Image)null, (EventHandler)WVSItemClick);
					((ToolStrip)val).get_Items().Add("Copy Action URL", (Image)null, (EventHandler)WVSItemClick);
					int index = ((ListView)listViewWVS).get_SelectedIndices().get_Item(0);
					Vulnerability vulnerability = SiteA.allVulnList[index];
					_ = vulnerability.vulnDescription;
					switch (vulnerability.vulnType)
					{
					case VulnType.SQLInjection:
						((ToolStrip)val).get_Items().Add("SQL INJECTION POC", (Image)null, (EventHandler)WVSItemClick);
						break;
					case VulnType.XSS:
					case VulnType.LFI:
					case VulnType.RFI:
					case VulnType.Redirect:
						((ToolStrip)val).get_Items().Add(vulnerability.vulnType.ToString() + " POC", (Image)null, (EventHandler)WVSItemClick);
						break;
					}
					((ToolStrip)val).get_Items().Add("Sort by Refer URL", (Image)null, (EventHandler)WVSItemClick);
					((ToolStrip)val).get_Items().Add("Delete Vulnerability", (Image)null, (EventHandler)WVSItemClick);
					((ToolStrip)val).get_Items().Add("Count", (Image)null, (EventHandler)WVSItemClick);
					((Control)listViewWVS).set_ContextMenuStrip(val);
					DisplayVulnInfo(vulnerability);
				}
			}
			catch (Exception)
			{
			}
		}

		private void DisplayVulnInfo(Vulnerability vuln)
		{
			//IL_0026: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Expected O, but got Unknown
			//IL_005f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0065: Expected O, but got Unknown
			//IL_008e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Expected O, but got Unknown
			//IL_00c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00cd: Expected O, but got Unknown
			//IL_00f6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fc: Expected O, but got Unknown
			//IL_0125: Unknown result type (might be due to invalid IL or missing references)
			//IL_012b: Expected O, but got Unknown
			//IL_0160: Unknown result type (might be due to invalid IL or missing references)
			//IL_0166: Expected O, but got Unknown
			tabDir_VulnInfo.SelectTab(tabVulnInfo);
			lvVulnInfo.get_Items().Clear();
			ListViewItem val = new ListViewItem("Vuln Type");
			val.get_SubItems().Add(vuln.vulnType.ToString());
			lvVulnInfo.get_Items().Add(val);
			val = new ListViewItem("Refer Address");
			val.get_SubItems().Add(vuln.vulnReferUrl);
			lvVulnInfo.get_Items().Add(val);
			val = new ListViewItem("Request Type");
			val.get_SubItems().Add(vuln.vulnRequestType.ToString());
			lvVulnInfo.get_Items().Add(val);
			val = new ListViewItem("Action URL");
			val.get_SubItems().Add(vuln.vulnActionUrl);
			lvVulnInfo.get_Items().Add(val);
			val = new ListViewItem("Parameter");
			val.get_SubItems().Add(vuln.vulnParameter);
			lvVulnInfo.get_Items().Add(val);
			val = new ListViewItem("Description");
			val.get_SubItems().Add(vuln.vulnDescription);
			lvVulnInfo.get_Items().Add(val);
			if (vuln.vulnType == VulnType.SQLInjection)
			{
				val = new ListViewItem("POC");
				val.get_SubItems().Add((vuln as VulnSQLInjection).vulnPocUrlString);
				lvVulnInfo.get_Items().Add(val);
			}
		}

		private void WVSItemClick(object sender, EventArgs e)
		{
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0225: Unknown result type (might be due to invalid IL or missing references)
			//IL_02cd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0445: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (((ListView)listViewWVS).get_SelectedItems().get_Count() < 1)
				{
					return;
				}
				int index = ((ListView)listViewWVS).get_SelectedIndices().get_Item(0);
				Vulnerability vulnerability = SiteA.allVulnList[index];
				switch (((ToolStripItem)(ToolStripMenuItem)sender).get_Text())
				{
				case "Navigate Refer URL":
					WebSite.URL2NoParaURL(vulnerability.vulnReferUrl);
					mainfrm.NavigatePage(vulnerability.vulnReferUrl, RequestType.GET, "");
					break;
				case "SQL INJECTION POC":
					mainfrm.InitByVulnSQLInjection(vulnerability as VulnSQLInjection);
					mainfrm.SelectTool("SQL");
					break;
				case "Copy Refer URL":
					Clipboard.SetText(vulnerability.vulnReferUrl);
					break;
				case "Copy Action URL":
					Clipboard.SetText(vulnerability.vulnActionUrl);
					break;
				case "Delete Vulnerability":
					((ListView)listViewWVS).get_SelectedItems().get_Item(0).Remove();
					SiteA.allVulnList.RemoveAt(index);
					break;
				case "XSS POC":
				case "LFI POC":
				case "RFI POC":
				case "Redirect POC":
					_ = vulnerability.vulnReferUrl;
					_ = vulnerability.vulnActionUrl;
					mainfrm.ExecPOC(vulnerability);
					mainfrm.SelectTool("POC");
					break;
				case "Sort by Refer URL":
					if (mainfrm.CurrentSite.HTTPThreadNum > 0)
					{
						MessageBox.Show("Scanning in process, please wait it finished!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
						break;
					}
					SiteA.allVulnList.Sort();
					((ListView)listViewWVS).get_Items().Clear();
					foreach (Vulnerability allVuln in SiteA.allVulnList)
					{
						AddVulnToListViewWVS(allVuln);
					}
					break;
				case "Count":
				{
					if (mainfrm.CurrentSite.HTTPThreadNum > 0)
					{
						MessageBox.Show("Scanning in process, please wait it finished!\r\nVulnerabilities Count: " + SiteA.allVulnList.Count, "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
						break;
					}
					int num = 0;
					int num2 = 0;
					int num3 = 0;
					int num4 = 0;
					int num5 = 0;
					int num6 = 0;
					foreach (Vulnerability allVuln2 in SiteA.allVulnList)
					{
						switch (allVuln2.vulnType)
						{
						case VulnType.SQLInjection:
							num++;
							break;
						case VulnType.XSS:
							num2++;
							break;
						case VulnType.LFI:
							num3++;
							break;
						case VulnType.RFI:
							num4++;
							break;
						case VulnType.Redirect:
							num5++;
							break;
						case VulnType.Backup:
							num6++;
							break;
						}
					}
					string str = "Vulnerabilities Count: " + SiteA.allVulnList.Count + "\r\n";
					str = str + "SQL Injection: " + num + "\r\n";
					str = str + "XSS: " + num2 + "\r\n";
					str = str + "LFI: " + num3 + "\r\n";
					str = str + "RFI: " + num4 + "\r\n";
					str = str + "Redirect: " + num5 + "\r\n";
					str = str + "Backup: " + num6 + "\r\n";
					MessageBox.Show(str, "Count", (MessageBoxButtons)0, (MessageBoxIcon)64);
					break;
				}
				}
			}
			catch (Exception)
			{
			}
		}

		private void ScannerTimer_Elapsed(object sender, EventArgs e)
		{
			if (DateTime.Now.Subtract(SiteA.LastGetTime).TotalSeconds > 60.0 && SiteA.HTTPThreadNum > 0)
			{
				WebSite.DebugLog("Idle time more than 60s, reset HTTP Thread Number " + SiteA.HTTPThreadNum + " ==> 0.");
				SiteA.HTTPThreadNum = 0;
			}
		}

		private void toolStripCrawler_Click(object sender, EventArgs e)
		{
			tabDir_VulnInfo.SelectTab(tabDir);
			ScanCurrentSite(isCrawlOnly: true);
		}

		private void toolStripPageScan_Click(object sender, EventArgs e)
		{
			ScanCurrentPage();
		}

		private void lvVulnInfo_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_0015: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			try
			{
				if (lvVulnInfo.get_SelectedItems().get_Count() >= 1)
				{
					ContextMenuStrip val = new ContextMenuStrip();
					((ToolStrip)val).get_Items().Add("Copy", (Image)null, (EventHandler)VulnInfoItemClick);
					((Control)lvVulnInfo).set_ContextMenuStrip(val);
				}
			}
			catch (Exception)
			{
			}
		}

		private void VulnInfoItemClick(object sender, EventArgs e)
		{
			//IL_0028: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (lvVulnInfo.get_SelectedItems().get_Count() >= 1)
				{
					lvVulnInfo.get_SelectedIndices().get_Item(0);
					string text;
					if ((text = ((ToolStripItem)(ToolStripMenuItem)sender).get_Text()) != null && text == "Copy")
					{
						string text2 = lvVulnInfo.get_SelectedItems().get_Item(0).get_SubItems()
							.get_Item(1)
							.get_Text();
						Clipboard.SetText(text2);
					}
				}
			}
			catch (Exception)
			{
			}
		}

		public void ClearCurrentVulnList()
		{
			((ListView)listViewWVS).get_Items().Clear();
			SiteA.allVulnList.Clear();
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_0015: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0053: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Expected O, but got Unknown
			//IL_005e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0068: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_0073: Expected O, but got Unknown
			//IL_007f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0089: Expected O, but got Unknown
			//IL_008a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Expected O, but got Unknown
			//IL_0095: Unknown result type (might be due to invalid IL or missing references)
			//IL_009f: Expected O, but got Unknown
			//IL_00a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00aa: Expected O, but got Unknown
			//IL_00b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00bb: Expected O, but got Unknown
			//IL_00bc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c6: Expected O, but got Unknown
			//IL_00c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d1: Expected O, but got Unknown
			//IL_00d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_00dc: Expected O, but got Unknown
			//IL_00dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e7: Expected O, but got Unknown
			//IL_00e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f2: Expected O, but got Unknown
			//IL_00f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fd: Expected O, but got Unknown
			//IL_00fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0108: Expected O, but got Unknown
			//IL_0109: Unknown result type (might be due to invalid IL or missing references)
			//IL_0113: Expected O, but got Unknown
			//IL_0114: Unknown result type (might be due to invalid IL or missing references)
			//IL_011e: Expected O, but got Unknown
			//IL_011f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0129: Expected O, but got Unknown
			//IL_012a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0134: Expected O, but got Unknown
			//IL_01a6: Unknown result type (might be due to invalid IL or missing references)
			//IL_0212: Unknown result type (might be due to invalid IL or missing references)
			//IL_0284: Unknown result type (might be due to invalid IL or missing references)
			//IL_02ba: Unknown result type (might be due to invalid IL or missing references)
			//IL_02ee: Unknown result type (might be due to invalid IL or missing references)
			//IL_030f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0326: Unknown result type (might be due to invalid IL or missing references)
			//IL_0378: Unknown result type (might be due to invalid IL or missing references)
			//IL_039f: Unknown result type (might be due to invalid IL or missing references)
			//IL_03c2: Unknown result type (might be due to invalid IL or missing references)
			//IL_03cc: Expected O, but got Unknown
			//IL_03ea: Unknown result type (might be due to invalid IL or missing references)
			//IL_040b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0422: Unknown result type (might be due to invalid IL or missing references)
			//IL_04aa: Unknown result type (might be due to invalid IL or missing references)
			//IL_04dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0518: Unknown result type (might be due to invalid IL or missing references)
			//IL_0522: Expected O, but got Unknown
			//IL_05bb: Unknown result type (might be due to invalid IL or missing references)
			//IL_05f1: Unknown result type (might be due to invalid IL or missing references)
			//IL_063d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0647: Expected O, but got Unknown
			//IL_06d5: Unknown result type (might be due to invalid IL or missing references)
			//IL_06df: Expected O, but got Unknown
			//IL_06e5: Unknown result type (might be due to invalid IL or missing references)
			//IL_070b: Unknown result type (might be due to invalid IL or missing references)
			//IL_07a9: Unknown result type (might be due to invalid IL or missing references)
			//IL_07d0: Unknown result type (might be due to invalid IL or missing references)
			//IL_0813: Unknown result type (might be due to invalid IL or missing references)
			//IL_081d: Expected O, but got Unknown
			//IL_0823: Unknown result type (might be due to invalid IL or missing references)
			//IL_0847: Unknown result type (might be due to invalid IL or missing references)
			//IL_08a1: Unknown result type (might be due to invalid IL or missing references)
			//IL_08c8: Unknown result type (might be due to invalid IL or missing references)
			//IL_08d2: Expected O, but got Unknown
			//IL_08d8: Unknown result type (might be due to invalid IL or missing references)
			//IL_08fc: Unknown result type (might be due to invalid IL or missing references)
			//IL_0946: Unknown result type (might be due to invalid IL or missing references)
			//IL_096d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0977: Expected O, but got Unknown
			//IL_097d: Unknown result type (might be due to invalid IL or missing references)
			//IL_09a1: Unknown result type (might be due to invalid IL or missing references)
			//IL_09eb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a12: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a1c: Expected O, but got Unknown
			//IL_0a22: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a46: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a90: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ab7: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ac1: Expected O, but got Unknown
			//IL_0ac7: Unknown result type (might be due to invalid IL or missing references)
			//IL_0aeb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b35: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b4a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b66: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ba5: Unknown result type (might be due to invalid IL or missing references)
			//IL_0baf: Expected O, but got Unknown
			components = (IContainer)new Container();
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormScanner));
			splitScanner = new SplitContainer();
			tabDir_VulnInfo = new TabControl();
			tabDir = new TabPage();
			treeViewWVS = new TreeView();
			tabVulnInfo = new TabPage();
			lvVulnInfo = new ListView();
			columnKey = new ColumnHeader();
			columnValue = new ColumnHeader();
			listViewWVS = new ListViewNF();
			columnAddress = new ColumnHeader();
			columnVul = new ColumnHeader();
			columnActionUrl = new ColumnHeader();
			columnParameter = new ColumnHeader();
			ImageListScanner = new ImageList(components);
			toolStripScanner = new ToolStrip();
			toolStripCrawler = new ToolStripButton();
			toolStripSeparator7 = new ToolStripSeparator();
			toolStripURLScan = new ToolStripButton();
			toolStripSeparator1 = new ToolStripSeparator();
			toolStripPageScan = new ToolStripButton();
			toolStripSeparator3 = new ToolStripSeparator();
			toolStripWVScan = new ToolStripButton();
			toolStripSeparator2 = new ToolStripSeparator();
			toolStripClearWVS = new ToolStripButton();
			toolStripSeparator4 = new ToolStripSeparator();
			((Control)splitScanner.get_Panel1()).SuspendLayout();
			((Control)splitScanner.get_Panel2()).SuspendLayout();
			((Control)splitScanner).SuspendLayout();
			((Control)tabDir_VulnInfo).SuspendLayout();
			((Control)tabDir).SuspendLayout();
			((Control)tabVulnInfo).SuspendLayout();
			((Control)toolStripScanner).SuspendLayout();
			((Control)this).SuspendLayout();
			splitScanner.set_Dock((DockStyle)5);
			((Control)splitScanner).set_Location(new Point(0, 25));
			((Control)splitScanner).set_Name("splitScanner");
			splitScanner.set_Orientation((Orientation)0);
			((Control)splitScanner.get_Panel1()).get_Controls().Add((Control)(object)tabDir_VulnInfo);
			((Control)splitScanner.get_Panel2()).get_Controls().Add((Control)(object)listViewWVS);
			((Control)splitScanner).set_Size(new Size(642, 361));
			splitScanner.set_SplitterDistance(150);
			((Control)splitScanner).set_TabIndex(0);
			tabDir_VulnInfo.set_Alignment((TabAlignment)1);
			((Control)tabDir_VulnInfo).get_Controls().Add((Control)(object)tabDir);
			((Control)tabDir_VulnInfo).get_Controls().Add((Control)(object)tabVulnInfo);
			((Control)tabDir_VulnInfo).set_Dock((DockStyle)5);
			((Control)tabDir_VulnInfo).set_Location(new Point(0, 0));
			((Control)tabDir_VulnInfo).set_Name("tabDir_VulnInfo");
			tabDir_VulnInfo.set_SelectedIndex(0);
			((Control)tabDir_VulnInfo).set_Size(new Size(642, 150));
			((Control)tabDir_VulnInfo).set_TabIndex(6);
			((Control)tabDir).get_Controls().Add((Control)(object)treeViewWVS);
			tabDir.set_Location(new Point(4, 4));
			((Control)tabDir).set_Name("tabDir");
			((Control)tabDir).set_Padding(new Padding(3));
			((Control)tabDir).set_Size(new Size(634, 124));
			tabDir.set_TabIndex(0);
			((Control)tabDir).set_Text("Directory");
			tabDir.set_UseVisualStyleBackColor(true);
			((Control)treeViewWVS).set_Dock((DockStyle)5);
			treeViewWVS.set_FullRowSelect(true);
			((Control)treeViewWVS).set_Location(new Point(3, 3));
			((Control)treeViewWVS).set_Name("treeViewWVS");
			((Control)treeViewWVS).set_Size(new Size(628, 118));
			((Control)treeViewWVS).set_TabIndex(5);
			treeViewWVS.add_NodeMouseClick(new TreeNodeMouseClickEventHandler(treeViewWVS_NodeMouseClick));
			((Control)tabVulnInfo).get_Controls().Add((Control)(object)lvVulnInfo);
			tabVulnInfo.set_Location(new Point(4, 4));
			((Control)tabVulnInfo).set_Name("tabVulnInfo");
			((Control)tabVulnInfo).set_Padding(new Padding(3));
			((Control)tabVulnInfo).set_Size(new Size(634, 104));
			tabVulnInfo.set_TabIndex(1);
			((Control)tabVulnInfo).set_Text("Vulnerability Information");
			tabVulnInfo.set_UseVisualStyleBackColor(true);
			lvVulnInfo.get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[2]
			{
				columnKey,
				columnValue
			});
			((Control)lvVulnInfo).set_Dock((DockStyle)5);
			lvVulnInfo.set_FullRowSelect(true);
			lvVulnInfo.set_HeaderStyle((ColumnHeaderStyle)1);
			((Control)lvVulnInfo).set_Location(new Point(3, 3));
			lvVulnInfo.set_MultiSelect(false);
			((Control)lvVulnInfo).set_Name("lvVulnInfo");
			((Control)lvVulnInfo).set_Size(new Size(628, 98));
			((Control)lvVulnInfo).set_TabIndex(0);
			lvVulnInfo.set_UseCompatibleStateImageBehavior(false);
			lvVulnInfo.set_View((View)1);
			((Control)lvVulnInfo).add_MouseClick(new MouseEventHandler(lvVulnInfo_MouseClick));
			columnKey.set_Text("Items");
			columnKey.set_Width(100);
			columnValue.set_Text("Detailed Information");
			columnValue.set_Width(1500);
			((ListView)listViewWVS).get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[4]
			{
				columnAddress,
				columnVul,
				columnActionUrl,
				columnParameter
			});
			((Control)listViewWVS).set_Dock((DockStyle)5);
			((ListView)listViewWVS).set_FullRowSelect(true);
			((Control)listViewWVS).set_Location(new Point(0, 0));
			((ListView)listViewWVS).set_MultiSelect(false);
			((Control)listViewWVS).set_Name("listViewWVS");
			((Control)listViewWVS).set_Size(new Size(642, 207));
			((ListView)listViewWVS).set_SmallImageList(ImageListScanner);
			((Control)listViewWVS).set_TabIndex(3);
			((ListView)listViewWVS).set_UseCompatibleStateImageBehavior(false);
			((ListView)listViewWVS).set_View((View)1);
			((Control)listViewWVS).add_MouseClick(new MouseEventHandler(listViewWVS_MouseClick));
			columnAddress.set_Text("Address (Refer URL)");
			columnAddress.set_Width(600);
			columnVul.set_Text("Vulnerability");
			columnVul.set_Width(180);
			columnActionUrl.set_Text("Action URL");
			columnActionUrl.set_Width(600);
			columnParameter.set_Text("Parameter");
			columnParameter.set_Width(120);
			ImageListScanner.set_ImageStream((ImageListStreamer)((ResourceManager)(object)val).GetObject("ImageListScanner.ImageStream"));
			ImageListScanner.set_TransparentColor(Color.get_Transparent());
			ImageListScanner.get_Images().SetKeyName(0, "vul.png");
			toolStripScanner.set_BackColor(SystemColors.get_ButtonFace());
			toolStripScanner.set_GripStyle((ToolStripGripStyle)0);
			toolStripScanner.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[10]
			{
				(ToolStripItem)toolStripCrawler,
				(ToolStripItem)toolStripSeparator7,
				(ToolStripItem)toolStripURLScan,
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)toolStripPageScan,
				(ToolStripItem)toolStripSeparator3,
				(ToolStripItem)toolStripWVScan,
				(ToolStripItem)toolStripSeparator2,
				(ToolStripItem)toolStripClearWVS,
				(ToolStripItem)toolStripSeparator4
			});
			toolStripScanner.set_LayoutStyle((ToolStripLayoutStyle)1);
			((Control)toolStripScanner).set_Location(new Point(0, 0));
			((Control)toolStripScanner).set_Name("toolStripScanner");
			((Control)toolStripScanner).set_Size(new Size(642, 25));
			((Control)toolStripScanner).set_TabIndex(1);
			((Control)toolStripScanner).set_Text("toolStrip1");
			((ToolStripItem)toolStripCrawler).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)toolStripCrawler).set_Image((Image)((ResourceManager)(object)val).GetObject("toolStripCrawler.Image"));
			((ToolStripItem)toolStripCrawler).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripCrawler).set_Name("toolStripCrawler");
			((ToolStripItem)toolStripCrawler).set_Size(new Size(56, 22));
			((ToolStripItem)toolStripCrawler).set_Text("Crawler");
			((ToolStripItem)toolStripCrawler).set_ToolTipText("Crawl links only.");
			((ToolStripItem)toolStripCrawler).add_Click((EventHandler)toolStripCrawler_Click);
			((ToolStripItem)toolStripSeparator7).set_Name("toolStripSeparator7");
			((ToolStripItem)toolStripSeparator7).set_Size(new Size(6, 25));
			((ToolStripItem)toolStripURLScan).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)toolStripURLScan).set_Image((Image)((ResourceManager)(object)val).GetObject("toolStripURLScan.Image"));
			((ToolStripItem)toolStripURLScan).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripURLScan).set_Name("toolStripURLScan");
			((ToolStripItem)toolStripURLScan).set_Size(new Size(113, 22));
			((ToolStripItem)toolStripURLScan).set_Text("Scan Current URL");
			((ToolStripItem)toolStripURLScan).add_Click((EventHandler)toolStripURLScan_Click);
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 25));
			((ToolStripItem)toolStripPageScan).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)toolStripPageScan).set_Image((Image)((ResourceManager)(object)val).GetObject("toolStripPageScan.Image"));
			((ToolStripItem)toolStripPageScan).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripPageScan).set_Name("toolStripPageScan");
			((ToolStripItem)toolStripPageScan).set_Size(new Size(119, 22));
			((ToolStripItem)toolStripPageScan).set_Text("Scan Current Page");
			((ToolStripItem)toolStripPageScan).add_Click((EventHandler)toolStripPageScan_Click);
			((ToolStripItem)toolStripSeparator3).set_Name("toolStripSeparator3");
			((ToolStripItem)toolStripSeparator3).set_Size(new Size(6, 25));
			((ToolStripItem)toolStripWVScan).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)toolStripWVScan).set_Image((Image)((ResourceManager)(object)val).GetObject("toolStripWVScan.Image"));
			((ToolStripItem)toolStripWVScan).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripWVScan).set_Name("toolStripWVScan");
			((ToolStripItem)toolStripWVScan).set_Size(new Size(111, 22));
			((ToolStripItem)toolStripWVScan).set_Text("Scan Current Site");
			((ToolStripItem)toolStripWVScan).add_Click((EventHandler)toolStripWVScan_Click);
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			((ToolStripItem)toolStripClearWVS).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)toolStripClearWVS).set_Image((Image)((ResourceManager)(object)val).GetObject("toolStripClearWVS.Image"));
			((ToolStripItem)toolStripClearWVS).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripClearWVS).set_Name("toolStripClearWVS");
			((ToolStripItem)toolStripClearWVS).set_Size(new Size(94, 22));
			((ToolStripItem)toolStripClearWVS).set_Text("Reset Scanner");
			((ToolStripItem)toolStripClearWVS).add_Click((EventHandler)toolStripClearWVS_Click);
			((ToolStripItem)toolStripSeparator4).set_Name("toolStripSeparator4");
			((ToolStripItem)toolStripSeparator4).set_Size(new Size(6, 25));
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(642, 386));
			((Control)this).get_Controls().Add((Control)(object)splitScanner);
			((Control)this).get_Controls().Add((Control)(object)toolStripScanner);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Form)this).set_Icon((Icon)((ResourceManager)(object)val).GetObject("$this.Icon"));
			((Control)this).set_Name("FormScanner");
			((Control)this).set_Text("FormScanner");
			((Control)splitScanner.get_Panel1()).ResumeLayout(false);
			((Control)splitScanner.get_Panel2()).ResumeLayout(false);
			((Control)splitScanner).ResumeLayout(false);
			((Control)tabDir_VulnInfo).ResumeLayout(false);
			((Control)tabDir).ResumeLayout(false);
			((Control)tabVulnInfo).ResumeLayout(false);
			((Control)toolStripScanner).ResumeLayout(false);
			((Control)toolStripScanner).PerformLayout();
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
