using System;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Web.UI;
using System.Windows.Forms;
using System.Xml;

namespace WebCruiserWVS
{
	public class FormReport : Form
	{
		private FormMain mainfrm;

		private IContainer components;

		private TextBox txtReportAuthor;

		private Label label22;

		private Button btnGenReport;

		public FormReport(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
		}

		private void btnGenReport_Click(object sender, EventArgs e)
		{
			//IL_004a: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.UpdateXMLData(mainfrm.CurrentSite.WcrXml);
			string str = GenReport(mainfrm.CurrentSite.WcrXml);
			MessageBox.Show("Generate Report " + str + " OK!", "Done", (MessageBoxButtons)0, (MessageBoxIcon)64);
		}

		private string GenReport(XmlDocument WcrXml)
		{
			//IL_0033: Unknown result type (might be due to invalid IL or missing references)
			//IL_0039: Expected O, but got Unknown
			//IL_003a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0040: Expected O, but got Unknown
			//IL_01bd: Unknown result type (might be due to invalid IL or missing references)
			//IL_01c4: Expected O, but got Unknown
			//IL_0590: Unknown result type (might be due to invalid IL or missing references)
			//IL_0597: Expected O, but got Unknown
			//IL_05d5: Unknown result type (might be due to invalid IL or missing references)
			//IL_05dc: Expected O, but got Unknown
			//IL_061c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0623: Expected O, but got Unknown
			//IL_07a2: Unknown result type (might be due to invalid IL or missing references)
			string text = mainfrm.CurrentSite.DomainHost + "_Scan_Report_" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".html";
			StringWriter val = new StringWriter();
			try
			{
				HtmlTextWriter val2 = new HtmlTextWriter((TextWriter)(object)val);
				val2.RenderBeginTag((HtmlTextWriterTag)43);
				val2.RenderBeginTag((HtmlTextWriterTag)41);
				((TextWriter)(object)val2).Write("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">");
				((TextWriter)(object)val2).Write("<style>table{table-layout:fixed;overflow:hidden;}</style>");
				val2.RenderBeginTag((HtmlTextWriterTag)89);
				((TextWriter)(object)val2).Write("Scan Report");
				val2.RenderEndTag();
				val2.RenderEndTag();
				val2.RenderBeginTag((HtmlTextWriterTag)12);
				val2.RenderBeginTag((HtmlTextWriterTag)16);
				((TextWriter)(object)val2).Write("<br><br><br><br><br><br><br><br>");
				val2.RenderBeginTag((HtmlTextWriterTag)35);
				((TextWriter)(object)val2).Write(mainfrm.CurrentSite.DomainHost + " Scan Report<br>");
				val2.RenderEndTag();
				string text2 = ((Control)txtReportAuthor).get_Text().Trim();
				if (!string.IsNullOrEmpty(text2))
				{
					((TextWriter)(object)val2).Write("<br><br><br><br><br><br><br><br>Made By " + text2);
				}
				((TextWriter)(object)val2).Write("<br><br><br><br><br><br><br><br>Created By WebCruiser - Web Vulnerability Scanner<br>" + DateTime.Now.ToString("yyyy-MM-dd"));
				((TextWriter)(object)val2).Write("<div style=\"page-break-after:always\">&nbsp;</div>");
				XmlNodeList val3 = ((XmlNode)WcrXml).SelectNodes("//ROOT/SiteSQLEnv/EnvRow");
				if (val3.get_Count() > 0)
				{
					val2.RenderBeginTag((HtmlTextWriterTag)36);
					((TextWriter)(object)val2).Write("Basic Information");
					val2.RenderEndTag();
					val2.AddAttribute("border", "1");
					val2.AddAttribute("width", "640");
					val2.AddAttribute("cellspacing", "0");
					val2.AddAttribute("bordercolordark", "009099");
					val2.RenderBeginTag((HtmlTextWriterTag)82);
					string text3 = "";
					foreach (XmlNode item in val3)
					{
						XmlNode val4 = item;
						string text4 = val4.get_ChildNodes().get_ItemOf(1).get_InnerText();
						if (string.IsNullOrEmpty(text4))
						{
							text4 = "&nbsp;";
						}
						string text5 = text3;
						text3 = text5 + "<tr><td width=\"130\">" + val4.get_ChildNodes().get_ItemOf(0).get_InnerText() + "</td><td> " + text4 + " </td></tr>";
					}
					((TextWriter)(object)val2).Write(text3);
					val2.RenderEndTag();
					((TextWriter)(object)val2).Write("<br>");
				}
				XmlNodeList val5 = ((XmlNode)WcrXml).SelectNodes("//ROOT/SiteVulList/VulRow");
				if (val5.get_Count() > 0)
				{
					val2.RenderBeginTag((HtmlTextWriterTag)36);
					((TextWriter)(object)val2).Write("Vulnerability Result");
					val2.RenderEndTag();
					for (int i = 0; i < val5.get_Count(); i++)
					{
						val2.AddAttribute("border", "1");
						val2.AddAttribute("width", "640");
						val2.AddAttribute("cellspacing", "0");
						val2.AddAttribute("bordercolordark", "009099");
						val2.RenderBeginTag((HtmlTextWriterTag)82);
						((TextWriter)(object)val2).Write("<tr><td width=\"150\">No.</td><td>" + (i + 1) + "</td></tr>");
						XmlNode val6 = val5.get_ItemOf(i);
						for (int j = 0; j < val6.get_ChildNodes().get_Count(); j++)
						{
							((TextWriter)(object)val2).Write("<tr><td width=\"150\">");
							((TextWriter)(object)val2).Write(val6.get_ChildNodes().get_ItemOf(j).get_Name());
							((TextWriter)(object)val2).Write("</td><td>");
							((TextWriter)(object)val2).Write(val6.get_ChildNodes().get_ItemOf(j).get_InnerText()
								.Replace("<", "&lt;")
								.Replace(">", "&gt;"));
							((TextWriter)(object)val2).Write("</td></tr>");
						}
						val2.RenderEndTag();
						((TextWriter)(object)val2).Write("<br>");
					}
				}
				if (mainfrm.CurrentSite.paramType != ParameterType.UnKnown && mainfrm.CurrentSite.injectMethod != InjectMethod.ToBeDetect)
				{
					val2.RenderBeginTag((HtmlTextWriterTag)36);
					((TextWriter)(object)val2).Write("Proof Of Concept - SQL INJECTION");
					val2.RenderEndTag();
					val2.AddAttribute("border", "1");
					val2.AddAttribute("width", "640");
					val2.AddAttribute("cellspacing", "0");
					val2.AddAttribute("bordercolordark", "009099");
					val2.RenderBeginTag((HtmlTextWriterTag)82);
					((TextWriter)(object)val2).Write("<tr><td width=\"140\">Parameter</td><td>Value</td></tr>");
					((TextWriter)(object)val2).Write("<tr><td>URL</td><td>" + mainfrm.URL + "</td></tr>");
					((TextWriter)(object)val2).Write("<tr><td>RequestType</td><td>" + mainfrm.ReqType.ToString() + "</td></tr>");
					((TextWriter)(object)val2).Write("<tr><td>DatabaseType</td><td>" + mainfrm.CurrentSite.DatabaseType.ToString() + "</td></tr>");
					((TextWriter)(object)val2).Write("<tr><td>ParameterType</td><td>" + mainfrm.CurrentSite.paramType.ToString() + "</td></tr>");
					((TextWriter)(object)val2).Write("<tr><td>GettingDataBy</td><td>" + mainfrm.CurrentSite.injectMethod.ToString() + "</td></tr>");
					val2.RenderEndTag();
					((TextWriter)(object)val2).Write("<br>");
				}
				XmlNodeList val7 = ((XmlNode)WcrXml).SelectNodes("//ROOT/SiteDBStructure/Database");
				if (val7.get_Count() > 0)
				{
					string text6 = "";
					foreach (XmlNode item2 in val7)
					{
						XmlNode val8 = item2;
						text6 = text6 + ((XmlNode)val8.get_Attributes().get_ItemOf("Text")).get_Value() + "<br>";
						foreach (XmlNode childNode in val8.get_ChildNodes())
						{
							XmlNode val9 = childNode;
							text6 = text6 + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + ((XmlNode)val9.get_Attributes().get_ItemOf("Text")).get_Value() + "<br>";
							foreach (XmlNode childNode2 in val9.get_ChildNodes())
							{
								XmlNode val10 = childNode2;
								text6 = text6 + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + ((XmlNode)val10.get_Attributes().get_ItemOf("Text")).get_Value() + "<br>";
							}
						}
					}
					val2.RenderBeginTag((HtmlTextWriterTag)36);
					((TextWriter)(object)val2).Write("Proof Of Concept - Getting Database Structure ");
					val2.RenderEndTag();
					string str = "DB-----Table---Column\r\n";
					str += text6;
					str = str.Replace("\r\n", "<br>").Replace(" ", "&nbsp;");
					val2.AddAttribute("border", "1");
					val2.AddAttribute("width", "640");
					val2.AddAttribute("cellspacing", "0");
					val2.AddAttribute("bordercolordark", "009099");
					val2.RenderBeginTag((HtmlTextWriterTag)82);
					((TextWriter)(object)val2).Write("<tr><td>");
					((TextWriter)(object)val2).Write(str);
					((TextWriter)(object)val2).Write("</td></tr>");
					val2.RenderEndTag();
					((TextWriter)(object)val2).Write("<br>");
				}
				val2.RenderEndTag();
				val2.RenderEndTag();
				val2.RenderEndTag();
				File.WriteAllText(text, ((object)val).ToString());
				return text;
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
				File.WriteAllText(text, ((object)val).ToString());
				return text;
			}
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_000c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0016: Expected O, but got Unknown
			//IL_0017: Unknown result type (might be due to invalid IL or missing references)
			//IL_0021: Expected O, but got Unknown
			//IL_0031: Unknown result type (might be due to invalid IL or missing references)
			//IL_0058: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00eb: Unknown result type (might be due to invalid IL or missing references)
			//IL_010f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0163: Unknown result type (might be due to invalid IL or missing references)
			//IL_0175: Unknown result type (might be due to invalid IL or missing references)
			//IL_018a: Unknown result type (might be due to invalid IL or missing references)
			txtReportAuthor = new TextBox();
			label22 = new Label();
			btnGenReport = new Button();
			((Control)this).SuspendLayout();
			((Control)txtReportAuthor).set_Location(new Point(80, 54));
			((Control)txtReportAuthor).set_Name("txtReportAuthor");
			((Control)txtReportAuthor).set_Size(new Size(210, 21));
			((Control)txtReportAuthor).set_TabIndex(5);
			((Control)txtReportAuthor).set_Text("WebCruiser");
			((Control)label22).set_AutoSize(true);
			((Control)label22).set_Location(new Point(20, 57));
			((Control)label22).set_Name("label22");
			((Control)label22).set_Size(new Size(47, 12));
			((Control)label22).set_TabIndex(4);
			((Control)label22).set_Text("Made By");
			((Control)btnGenReport).set_Location(new Point(317, 52));
			((Control)btnGenReport).set_Name("btnGenReport");
			((Control)btnGenReport).set_Size(new Size(127, 23));
			((Control)btnGenReport).set_TabIndex(3);
			((Control)btnGenReport).set_Text("Generate Report");
			((ButtonBase)btnGenReport).set_UseVisualStyleBackColor(true);
			((Control)btnGenReport).add_Click((EventHandler)btnGenReport_Click);
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Control)this).set_BackColor(SystemColors.get_Window());
			((Form)this).set_ClientSize(new Size(486, 317));
			((Control)this).get_Controls().Add((Control)(object)txtReportAuthor);
			((Control)this).get_Controls().Add((Control)(object)label22);
			((Control)this).get_Controls().Add((Control)(object)btnGenReport);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormReport");
			((Control)this).set_Text("FormReport");
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
