using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Reflection;
using System.Resources;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading;
using System.Timers;
using System.Windows.Forms;
using System.Xml;
using Microsoft.Win32;
using WebCruiserWVS.Properties;

namespace WebCruiserWVS
{
	public class FormMain : Form
	{
		private delegate void dd(string s);

		private delegate string ds();

		private delegate void EnableTextBox(bool TrueFalse);

		public struct TxtBoxInfo
		{
			public TextBox txtBox;

			public string Text;
		}

		private delegate void ddSetTextBox(TxtBoxInfo txtBoxInfo);

		private delegate void ddEnableBtnStop(bool TrueFalse);

		private delegate void ddd(FormScanner fm);

		private RequestType CurrentRequestType;

		private Timer ScanTimer;

		public WebSite CurrentSite;

		public FormBrowser BrowserForm;

		private FormScanner ScannerForm;

		private FormSQL SQLForm;

		private FormPOC POCForm;

		private FormCode CodeForm;

		private FormCookie CookieForm;

		private FormSetting SettingForm;

		private FormAdmin AdminForm;

		private FormReport ReportForm;

		private FormAbout AboutForm;

		public FormBruter BruterForm;

		private IContainer components;

		private MenuStrip menuStripMain;

		private ToolStrip toolStripMain;

		private StatusStrip statusStripMain;

		private ToolStrip toolStripURL;

		private SplitContainer splitMain;

		private ToolStripMenuItem MenuItemFile;

		private TreeView treeViewToolTree;

		private ToolStripLabel toolStripLabel1;

		private ToolStripSeparator toolStripSeparator1;

		private ToolStripTextBox txtURL;

		private ToolStripButton toolStripBtnGo;

		private ToolStripButton toolStripBtnPause;

		private ToolStripButton toolStripBtnStop;

		private ImageList WCRImageList;

		private ToolStripStatusLabel toolStripStatusProgress;

		private ToolStripComboBox cmbReqType;

		private ToolStrip toolStripData;

		private ToolStripLabel lblSubmitData;

		private ToolStripSeparator toolStripSeparator2;

		private ToolStripTextBox txtSubmitData;

		private ToolStripSeparator toolStripSeparator3;

		private ToolStripStatusLabel toolStripStatusSep1;

		private ToolStripMenuItem MenuItemExit;

		private ToolStripButton toolStripButtonNew;

		private ToolStripButton toolStripButtonOpen;

		private ToolStripButton toolStripButtonSave;

		private ToolStripSeparator toolStripSeparator4;

		private ToolStripMenuItem MenuItemTool;

		private ToolStripMenuItem MenuItemHelp;

		private ToolStripMenuItem MenuItemNew;

		private ToolStripMenuItem MenuItemOpen;

		private ToolStripMenuItem MenuItemSave;

		private ToolStripMenuItem MenuItemAbout;

		private ToolStripMenuItem MenuItemCheckUpdate;

		private ToolStripMenuItem MenuItemWebBrowser;

		private ToolStripSeparator toolStripSeparator5;

		private ToolStripSeparator toolStripSeparator6;

		private ToolStripSeparator toolStripSeparator7;

		private ToolStripSeparator toolStripSeparator8;

		private ToolStripMenuItem MenuItemSaveAs;

		private ToolStripMenuItem MenuItemScanner;

		private ToolStripSeparator toolStripSeparator9;

		private ToolStripMenuItem MenuItemSQLInjection;

		private ToolStripMenuItem MenuItemXSS;

		private ToolStripButton toolStripButtonBrowser;

		private ToolStripButton toolStripButtonScanner;

		private ToolStripSeparator toolStripSeparator10;

		private ToolStripButton toolStripButtonSQL;

		private ToolStripButton toolStripButtonXSS;

		private ToolStripSeparator toolStripSeparator11;

		private ToolStripButton ButtonSetting;

		private ToolStripMenuItem MenuItemReport;

		private ToolStripSeparator toolStripSeparator12;

		private ToolStripStatusLabel lblThreadNum;

		private ToolStripSeparator toolStripSeparator13;

		private ToolStripButton ButtonScanURL;

		private ToolStripButton ButtonScanSite;

		private ToolStripSeparator toolStripSeparator14;

		private ToolStripSeparator toolStripSeparator15;

		private ToolStripMenuItem MenuItemOrder;

		private ToolStripSeparator toolStripSeparator16;

		private ToolStripButton ButtonAutoFill;

		private ToolStripButton ButtonCookie;

		private ToolStripButton ButtonResend;

		private ToolStripSeparator toolStripSeparator17;

		private ToolStripMenuItem MenuItemOnlineHelp;

		private ToolStripMenuItem MenuItemFeedback;

		private ToolStripMenuItem MenuItemConfig;

		private ToolStripMenuItem MenuItemSettings;

		private ToolStripMenuItem MenuItemWebsite;

		private ToolStripMenuItem MenuItemResend;

		private ToolStripMenuItem MenuItemCookie;

		private ToolStripSeparator toolStripSeparator19;

		private ToolStripMenuItem MenuItemRefreshURL;

		private ToolStripMenuItem MenuItemEscapeCookie;

		private ToolStripSeparator toolStripSeparator20;

		private ToolStripMenuItem MenuItemView;

		private ToolStripMenuItem MenuItemWebEncoding;

		private ToolStripMenuItem MenuItemDBEncoding;

		private ToolStripMenuItem MenuItemWebEncodingUTF8;

		private ToolStripMenuItem MenuItemWebEncodingUTF16;

		private ToolStripMenuItem MenuItemWebEncodingISO8859;

		private ToolStripMenuItem MenuItemWebEncodingGB2312;

		private ToolStripMenuItem MenuItemWebEncodingBIG5;

		private ToolStripMenuItem MenuItemDBEncodingUTF8;

		private ToolStripMenuItem MenuItemDBEncodingUTF16;

		private ToolStripMenuItem MenuItemDBEncodingISO8859;

		private ToolStripMenuItem MenuItemDBEncodingGB2312;

		private ToolStripMenuItem MenuItemDBEncodingBIG5;

		private ToolStripButton ButtonBruter;

		private ToolStripButton ButtonScanPage;

		private ToolStripLabel lblBlank;

		private ToolStripSeparator toolStripSeparator18;

		private ListViewNF lvRecentLog;

		private ColumnHeader columnProgress;

		private SplitContainer splitUpDown;

		private ToolStripComboBox cmbEnctype;

		private ToolStripSeparator toolStripSeparator21;

		public RequestType ReqType
		{
			get
			{
				return CurrentRequestType;
			}
			set
			{
				CurrentRequestType = value;
				InitByRequestType(CurrentRequestType);
			}
		}

		public string URL
		{
			get
			{
				return GetCurrentURL();
			}
			set
			{
				CurrentSite.URL = value;
				UpdateURLText(value);
			}
		}

		public string SubmitData
		{
			get
			{
				return GetSubmitData();
			}
			set
			{
				UpdateSubmitData(value);
			}
		}

		public FormMain()
			: this()
		{
			//IL_0098: Unknown result type (might be due to invalid IL or missing references)
			//IL_009e: Invalid comparison between Unknown and I4
			//IL_00de: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e8: Expected O, but got Unknown
			//IL_0115: Unknown result type (might be due to invalid IL or missing references)
			//IL_011f: Expected O, but got Unknown
			InitializeComponent();
			CurrentSite = new WebSite("");
			CurrentSite.delegateLog = DisplayLogList;
			cmbReqType.set_SelectedIndex(0);
			cmbEnctype.set_SelectedIndex(0);
			treeViewToolTree.ExpandAll();
			CheckAndInitWVSEdition();
			InitForm();
			InitSetting();
			CheckRegistration();
			WebBrowserVersionEmulation();
			string downloadURL;
			string newVersionNo = GetNewVersionNo(out downloadURL);
			if (!string.IsNullOrEmpty(newVersionNo) && (int)MessageBox.Show("New version found: " + newVersionNo, "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) == 1)
			{
				Process.Start(downloadURL);
			}
			if (WCRSetting.UseProxy)
			{
				WCRSetting.RefreshIESettings(WCRSetting.ProxyAddress + ":" + WCRSetting.ProxyPort);
			}
			toolStripURL.set_ImageList(WCRImageList);
			ScanTimer = new Timer();
			ScanTimer.set_Enabled(true);
			ScanTimer.set_Interval(5000.0);
			ScanTimer.add_Elapsed(new ElapsedEventHandler(ScanTimer_Tick));
		}

		private void CheckAndInitWVSEdition()
		{
			WCRSetting.wvsEdition = WVSEdition.Enterprise;
			((Control)this).set_Text("WebCruiser - Web Vulnerability Scanner Enterprise Edition");
		}

		private string GetNewVersionNo(out string downloadURL)
		{
			//IL_0037: Unknown result type (might be due to invalid IL or missing references)
			//IL_003d: Expected O, but got Unknown
			try
			{
				string strA = Assembly.GetExecutingAssembly().GetName().Version!.ToString();
				string sourceCode = CurrentSite.GetSourceCode("http://www.janusec.com/download/version.xml", RequestType.GET, "");
				if (!string.IsNullOrEmpty(sourceCode))
				{
					XmlDocument val = new XmlDocument();
					val.LoadXml(sourceCode);
					string value = ((XmlNode)((XmlNode)val).SelectSingleNode("//ROOT/Version").get_Attributes().get_ItemOf("Value")).get_Value();
					int num = string.Compare(strA, value);
					if (num < 0)
					{
						string str = "";
						switch (WCRSetting.wvsEdition)
						{
						case WVSEdition.Enterprise:
							str = "Ent";
							break;
						case WVSEdition.Personal:
							str = "Pro";
							break;
						case WVSEdition.Free:
							str = "Free";
							break;
						}
						downloadURL = ((XmlNode)((XmlNode)val).SelectSingleNode("//ROOT/Download/URL[@Edition=\"" + str + "\"]").get_Attributes().get_ItemOf("Value")).get_Value();
						return value;
					}
				}
				downloadURL = "";
				return "";
			}
			catch
			{
				downloadURL = "";
				return "";
			}
		}

		private void InitForm()
		{
			BrowserForm = new FormBrowser(this);
			((Form)BrowserForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)BrowserForm);
			((Control)BrowserForm).set_Dock((DockStyle)5);
			((Form)this).LayoutMdi((MdiLayout)0);
			((Control)BrowserForm).Show();
			ScannerForm = new FormScanner(this);
			((Form)ScannerForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)ScannerForm);
			((Control)ScannerForm).set_Dock((DockStyle)5);
			SQLForm = new FormSQL(this);
			((Form)SQLForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)SQLForm);
			((Control)SQLForm).set_Dock((DockStyle)5);
			POCForm = new FormPOC(this);
			((Form)POCForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)POCForm);
			((Control)POCForm).set_Dock((DockStyle)5);
			CodeForm = new FormCode(this);
			((Form)CodeForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)CodeForm);
			((Control)CodeForm).set_Dock((DockStyle)5);
			CookieForm = new FormCookie(this);
			((Form)CookieForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)CookieForm);
			((Control)CookieForm).set_Dock((DockStyle)5);
			SettingForm = new FormSetting();
			((Form)SettingForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)SettingForm);
			((Control)SettingForm).set_Dock((DockStyle)5);
			AdminForm = new FormAdmin(this);
			((Form)AdminForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)AdminForm);
			((Control)AdminForm).set_Dock((DockStyle)5);
			ReportForm = new FormReport(this);
			((Form)ReportForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)ReportForm);
			((Control)ReportForm).set_Dock((DockStyle)5);
			AboutForm = new FormAbout(this);
			((Form)AboutForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)AboutForm);
			((Control)AboutForm).set_Dock((DockStyle)5);
			BruterForm = new FormBruter(this);
			((Form)BruterForm).set_MdiParent((Form)(object)this);
			((Control)splitMain.get_Panel2()).get_Controls().Add((Control)(object)BruterForm);
			((Control)BruterForm).set_Dock((DockStyle)5);
		}

		private void InitSetting()
		{
			WCRSetting.UseProxy = WebCruiserWVS.Default.UseProxy;
			WCRSetting.ProxyAddress = WebCruiserWVS.Default.ProxyAddress;
			WCRSetting.ProxyPort = WebCruiserWVS.Default.ProxyPort;
			WCRSetting.ProxyUsername = WebCruiserWVS.Default.ProxyUsername;
			WCRSetting.ProxyPassword = WebCruiserWVS.Default.ProxyPassword;
			WCRSetting.UserAgent = WebCruiserWVS.Default.UserAgent;
			WCRSetting.MaxHTTPThreadNum = WebCruiserWVS.Default.MaxHTTPThread;
			ThreadPool.SetMaxThreads(WCRSetting.MaxHTTPThreadNum + 10, (WCRSetting.MaxHTTPThreadNum + 10) * 2);
			WCRSetting.UseSingleThread = WebCruiserWVS.Default.UseSingleThread;
			WCRSetting.SecondsDelay = WebCruiserWVS.Default.SecondsDelay;
			WCRSetting.ScanSQLInjection = WebCruiserWVS.Default.ScanSQLInjection;
			WCRSetting.ScanURLSQL = WebCruiserWVS.Default.ScanURLSQL;
			WCRSetting.ScanPostSQL = WebCruiserWVS.Default.ScanPostSQL;
			WCRSetting.ScanCookieSQL = WebCruiserWVS.Default.ScanCookieSQL;
			WCRSetting.ScanXSS = WebCruiserWVS.Default.ScanXSS;
			WCRSetting.ScanLFI = WebCruiserWVS.Default.ScanLFI;
			WCRSetting.ScanRFI = WebCruiserWVS.Default.ScanRFI;
			WCRSetting.ScanBackup = WebCruiserWVS.Default.ScanBackup;
			WCRSetting.chkReplace1 = WebCruiserWVS.Default.chkReplace1;
			WCRSetting.FiltExpr1 = WebCruiserWVS.Default.FiltExpr1;
			WCRSetting.RepExpr1 = WebCruiserWVS.Default.RepExpr1;
			WCRSetting.chkReplace2 = WebCruiserWVS.Default.chkReplace2;
			WCRSetting.FiltExpr2 = WebCruiserWVS.Default.FiltExpr2;
			WCRSetting.RepExpr2 = WebCruiserWVS.Default.RepExpr2;
			WCRSetting.chkReplace3 = WebCruiserWVS.Default.chkReplace3;
			WCRSetting.FiltExpr3 = WebCruiserWVS.Default.FiltExpr3;
			WCRSetting.RepExpr3 = WebCruiserWVS.Default.RepExpr3;
			WCRSetting.Edition = WebCruiserWVS.Default.Edition;
			WCRSetting.ScanDepth = WebCruiserWVS.Default.ScanDepth;
			WCRSetting.CrawlableExt = WebCruiserWVS.Default.CrawlableExt;
			WCRSetting.CrossSiteURL = WebCruiserWVS.Default.CrossSiteURL;
			WCRSetting.CrossSiteRecord = WebCruiserWVS.Default.CrossSiteRecord;
			WCRSetting.CSRFKeywords = WebCruiserWVS.Default.CSRFKeyWords;
		}

		private void CheckRegistration()
		{
			try
			{
				RegistryKey val = Registry.CurrentUser.OpenSubKey("Software\\Sec4App\\WebCruiser", true);
				if (val == null)
				{
					val = Registry.CurrentUser.CreateSubKey("Software\\Sec4App\\WebCruiser");
					string toEncrypt = DateTime.Now.ToString("yyyy-MM-dd");
					toEncrypt = Reg.Encrypt(toEncrypt);
					val.SetValue("InitDate", (object)toEncrypt);
					AboutForm.InitRegControl();
					return;
				}
				string text = (string)val.GetValue("Username");
				string text2 = (string)val.GetValue("RegCode");
				if (!string.IsNullOrEmpty(text) && !string.IsNullOrEmpty(text2) && (Reg.ValidateRegCode(text, text2) || Reg.ValidateRegCode2(text, text2)))
				{
					Reg.A1K3 = true;
				}
				if (!Reg.A1K3)
				{
					string text3 = (string)val.GetValue("InitDate");
					int num;
					if (string.IsNullOrEmpty(text3))
					{
						num = 30;
					}
					else
					{
						text3 = Reg.Decrypt(text3);
						DateTime value = DateTime.ParseExact(text3, "yyyy-MM-dd", null);
						num = DateTime.Now.Subtract(value).Days;
					}
					Reg.LeftDays = 30 - num;
				}
				AboutForm.InitRegControl();
				string text4 = (string)val.GetValue("Edition");
				if (!string.IsNullOrEmpty(text4) && text4.Equals("Debug"))
				{
					WebSite.LogScannedURL = true;
				}
				val.Close();
			}
			catch
			{
				Reg.A1K3 = false;
				AboutForm.InitRegControl();
			}
		}

		private void WebBrowserVersionEmulation()
		{
			string text = Process.GetCurrentProcess().get_ProcessName() + ".exe";
			RegistryKey val = Registry.CurrentUser.OpenSubKey("Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_BROWSER_EMULATION", (RegistryKeyPermissionCheck)2) ?? Registry.CurrentUser.CreateSubKey("Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_BROWSER_EMULATION");
			if (val != null)
			{
				val.SetValue(text, (object)11001, (RegistryValueKind)4);
				val.Close();
			}
		}

		public void AddNewVuln(Vulnerability vuln)
		{
			ScannerForm.AddNewVuln(vuln);
		}

		public void DisplayProgress(string Text)
		{
			if (!((Control)statusStripMain).get_InvokeRequired())
			{
				((ToolStripItem)toolStripStatusProgress).set_Text(Text);
				((Control)statusStripMain).Refresh();
			}
			else
			{
				dd dd = DisplayProgress;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					Text
				});
			}
		}

		public void DisplayLogList(string log)
		{
			//IL_002d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0033: Expected O, but got Unknown
			if (!((Control)lvRecentLog).get_InvokeRequired())
			{
				log = DateTime.Now.ToString("HH:mm:ss") + " " + log;
				ListViewItem val = new ListViewItem(log);
				((ListView)lvRecentLog).get_Items().Add(val);
				int count = ((ListView)lvRecentLog).get_Items().get_Count();
				if (count > 100)
				{
					((ListView)lvRecentLog).get_Items().RemoveAt(0);
				}
				val.EnsureVisible();
				((Control)lvRecentLog).Refresh();
				WebSite.DebugLog(log);
			}
			else
			{
				DelegateDisplayLog delegateDisplayLog = DisplayLogList;
				((Control)this).Invoke((Delegate)delegateDisplayLog, new object[1]
				{
					log
				});
			}
		}

		public void DisplayProgressNoLog(string Text)
		{
			if (!((Control)statusStripMain).get_InvokeRequired())
			{
				((ToolStripItem)toolStripStatusProgress).set_Text(Text);
				((Control)statusStripMain).Refresh();
			}
			else
			{
				dd dd = DisplayProgressNoLog;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					Text
				});
			}
		}

		public string GetCurrentURL()
		{
			if (!((Control)toolStripMain).get_InvokeRequired())
			{
				return ((ToolStripItem)txtURL).get_Text().Trim();
			}
			ds ds = GetCurrentURL;
			return (string)((Control)this).Invoke((Delegate)ds, new object[0]);
		}

		private void UpdateComboReqType(string ReqType)
		{
			if (!((Control)toolStripURL).get_InvokeRequired())
			{
				cmbReqType.set_SelectedIndex(cmbReqType.FindString(ReqType));
				return;
			}
			dd dd = UpdateComboReqType;
			((Control)this).Invoke((Delegate)dd, new object[1]
			{
				ReqType
			});
		}

		public void UpdateComboEncType(string enctype)
		{
			if (!((Control)toolStripData).get_InvokeRequired())
			{
				cmbEnctype.set_SelectedIndex(cmbEnctype.FindString(enctype));
				return;
			}
			dd dd = UpdateComboEncType;
			((Control)this).Invoke((Delegate)dd, new object[1]
			{
				enctype
			});
		}

		private void EnableTxtSubmitData(bool TrueFalse)
		{
			if (!((Control)toolStripData).get_InvokeRequired())
			{
				((Control)toolStripData).set_Visible(TrueFalse);
				((ToolStripItem)txtSubmitData).set_Width(((Control)toolStripData).get_Width() - 322);
			}
			else
			{
				EnableTextBox enableTextBox = EnableTxtSubmitData;
				((Control)this).Invoke((Delegate)enableTextBox, new object[1]
				{
					TrueFalse
				});
			}
		}

		public void UpdateURLText(string URLText)
		{
			if (!((Control)toolStripURL).get_InvokeRequired())
			{
				((ToolStripItem)txtURL).set_Text(URLText);
				return;
			}
			dd dd = UpdateURLText;
			((Control)this).Invoke((Delegate)dd, new object[1]
			{
				URLText
			});
		}

		public void UpdateSubmitData(string SubmitData)
		{
			if (!((Control)toolStripData).get_InvokeRequired())
			{
				((ToolStripItem)txtSubmitData).set_Text(SubmitData);
				return;
			}
			dd dd = UpdateSubmitData;
			((Control)this).Invoke((Delegate)dd, new object[1]
			{
				SubmitData
			});
		}

		private string GetSubmitData()
		{
			if (!((Control)toolStripData).get_InvokeRequired())
			{
				return ((ToolStripItem)txtSubmitData).get_Text();
			}
			ds ds = GetSubmitData;
			return (string)((Control)this).Invoke((Delegate)ds, new object[0]);
		}

		public void InitByRequestType(RequestType ReqType)
		{
			switch (ReqType)
			{
			case RequestType.GET:
				UpdateComboReqType("GET");
				EnableTxtSubmitData(TrueFalse: false);
				break;
			case RequestType.POST:
				UpdateComboReqType("POST");
				EnableTxtSubmitData(TrueFalse: true);
				break;
			case RequestType.COOKIE:
				UpdateComboReqType("COOKIE");
				EnableTxtSubmitData(TrueFalse: true);
				break;
			}
		}

		private void SetTextBoxText(TxtBoxInfo txtBoxInfo)
		{
			//IL_0052: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (!((Control)txtBoxInfo.txtBox).get_InvokeRequired())
				{
					((Control)txtBoxInfo.txtBox).set_Text(txtBoxInfo.Text);
					return;
				}
				ddSetTextBox ddSetTextBox = SetTextBoxText;
				((Control)this).Invoke((Delegate)ddSetTextBox, new object[1]
				{
					txtBoxInfo
				});
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void UpdateTextBoxText(TextBox txtBox, string Text)
		{
			TxtBoxInfo textBoxText = default(TxtBoxInfo);
			textBoxText.txtBox = txtBox;
			textBoxText.Text = Text;
			SetTextBoxText(textBoxText);
		}

		private void txtURL_KeyPress(object sender, KeyPressEventArgs e)
		{
			if (e.get_KeyChar() == '\r')
			{
				WebBrowserGo();
			}
		}

		private void WebBrowserGo()
		{
			//IL_00af: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b5: Invalid comparison between Unknown and I4
			SelectTool("WebBrowser");
			string text = ((ToolStripItem)txtURL).get_Text().Trim();
			CurrentSite.URL = text;
			string text2 = "";
			string text3 = CurrentRequestType.ToString() + "  " + text;
			if (CurrentRequestType != 0)
			{
				text2 = ((ToolStripItem)txtSubmitData).get_Text();
				text3 = text3 + "^" + text2;
				if (CurrentRequestType == RequestType.POST)
				{
					text2 = CurrentSite.ConvertPostDataByContentType(text2, ((ToolStripItem)cmbEnctype).get_Text());
				}
			}
			else if (text.IndexOf('^') > 0)
			{
				if ((int)MessageBox.Show("* URL is not a valid for GET Request.\r\n* Do you want it switch to POST?\r\n", "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) == 2)
				{
					return;
				}
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				text = array[0];
				string text4 = "";
				for (int i = 1; i < array.Length; i++)
				{
					if (!string.IsNullOrEmpty(text4))
					{
						text4 += "^";
					}
					text4 += array[i];
				}
				CurrentRequestType = RequestType.POST;
				InitByRequestType(CurrentRequestType);
				UpdateURLText(text);
				UpdateSubmitData(text4);
				text2 = ((ToolStripItem)txtSubmitData).get_Text();
				text2 = CurrentSite.ConvertPostDataByContentType(text2, ((ToolStripItem)cmbEnctype).get_Text());
			}
			BrowserForm.NavigatePage(text, CurrentRequestType, text2, ((ToolStripItem)cmbEnctype).get_Text());
			if (WebSite.LogScannedURL)
			{
				WebSite.DebugLog(text3);
			}
		}

		private void toolStripBtnGo_Click(object sender, EventArgs e)
		{
			WebBrowserGo();
		}

		private void FormMain_Resize(object sender, EventArgs e)
		{
			((ToolStripItem)txtURL).set_Width(((Control)toolStripMain).get_Width() - 211);
			((ToolStripItem)txtSubmitData).set_Width(((Control)toolStripData).get_Width() - 322);
			((ToolStripItem)toolStripStatusProgress).set_Width(((Control)statusStripMain).get_Width() - 150);
			splitMain.set_SplitterDistance(185);
			((ListView)lvRecentLog).get_Columns().get_Item(0).set_Width(((Control)lvRecentLog).get_Width() - 10);
		}

		private void cmbReqType_DropDownClosed(object sender, EventArgs e)
		{
			if (((ToolStripItem)cmbReqType).get_Text().Equals("GET"))
			{
				CurrentRequestType = RequestType.GET;
			}
			else if (((ToolStripItem)cmbReqType).get_Text().Equals("POST"))
			{
				CurrentRequestType = RequestType.POST;
			}
			else if (((ToolStripItem)cmbReqType).get_Text().Equals("COOKIE"))
			{
				CurrentRequestType = RequestType.COOKIE;
			}
			InitByRequestType(CurrentRequestType);
		}

		private void HideAllToolForm()
		{
			((Control)BrowserForm).Hide();
			((Control)ScannerForm).Hide();
			((Control)SQLForm).Hide();
			((Control)POCForm).Hide();
			((Control)CodeForm).Hide();
			((Control)CookieForm).Hide();
			((Control)SettingForm).Hide();
			((Control)AdminForm).Hide();
			((Control)ReportForm).Hide();
			((Control)AboutForm).Hide();
		}

		public void SelectTool(string ToolName)
		{
			//IL_0266: Unknown result type (might be due to invalid IL or missing references)
			switch (ToolName)
			{
			case "WebBrowser":
				HideAllToolForm();
				((Control)BrowserForm).Show();
				BrowserForm.SelectTabByName("tabBrowser");
				break;
			case "Scanner":
				HideAllToolForm();
				((Control)ScannerForm).Show();
				break;
			case "SQL":
				HideAllToolForm();
				((Control)SQLForm).Show();
				SQLForm.SelectTabByName("tabEnv");
				break;
			case "POC":
				HideAllToolForm();
				((Control)POCForm).Show();
				break;
			case "Code":
				HideAllToolForm();
				((Control)CodeForm).Show();
				break;
			case "Cookie":
				HideAllToolForm();
				((Control)CookieForm).Show();
				break;
			case "Setting":
				HideAllToolForm();
				((Control)SettingForm).Show();
				break;
			case "Admin":
				HideAllToolForm();
				((Control)AdminForm).Show();
				break;
			case "Report":
				HideAllToolForm();
				((Control)ReportForm).Show();
				break;
			case "Resend":
				HideAllToolForm();
				((Control)BrowserForm).Show();
				BrowserForm.SelectTabByName("tabResend");
				break;
			case "Bruter":
				HideAllToolForm();
				((Control)BruterForm).Show();
				break;
			case "StringTool":
				HideAllToolForm();
				((Control)SQLForm).Show();
				SQLForm.SelectTabByName("tabEscapeString");
				break;
			case "About":
				HideAllToolForm();
				((Control)AboutForm).Show();
				break;
			default:
				MessageBox.Show("Not Handled");
				break;
			case "POCTool":
			case "SystemTool":
				break;
			}
		}

		private void treeViewToolTree_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
		{
			//IL_0019: Unknown result type (might be due to invalid IL or missing references)
			Point val = default(Point);
			((Point)(ref val))._002Ector(((MouseEventArgs)e).get_X(), ((MouseEventArgs)e).get_Y());
			TreeNode nodeAt = treeViewToolTree.GetNodeAt(val);
			string name = nodeAt.get_Name();
			SelectTool(name);
		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			Application.Exit();
		}

		public string GetSourceCodeFromWebBrowser()
		{
			return BrowserForm.GetSourceCodeFromWebBrowser();
		}

		public void UpdateCodeText(string Code)
		{
			CodeForm.UpdateCodeText(Code);
		}

		public void SelectCode(int Location, int Length)
		{
			CodeForm.SelectCode(Location, Length);
		}

		public void NavigatePage(string sURL, RequestType ReqType, string SubmitData)
		{
			SelectTool("WebBrowser");
			BrowserForm.NavigatePage(sURL, ReqType, SubmitData, ((ToolStripItem)cmbEnctype).get_Text());
		}

		public void InitFunctionByRegistration(bool RegOK, int LeftDays)
		{
			bool flag = false;
			flag = WCRSetting.wvsEdition == WVSEdition.Free || RegOK || ((LeftDays > 0) ? true : false);
			EnableFunction(flag);
		}

		public void EnableFunction(bool EnableFunc)
		{
			((ToolStripItem)toolStripBtnGo).set_Enabled(EnableFunc);
			ScannerForm.EnableFunc(EnableFunc);
			SQLForm.EnableFunc(EnableFunc);
		}

		private void MenuItemWebBrowser_Click(object sender, EventArgs e)
		{
			SelectTool("WebBrowser");
		}

		private void MenuItemScanner_Click(object sender, EventArgs e)
		{
			SelectTool("Scanner");
		}

		private void MenuItemSQLInjection_Click(object sender, EventArgs e)
		{
			SelectTool("SQL");
		}

		private void MenuItemXSS_Click(object sender, EventArgs e)
		{
			SelectTool("POC");
		}

		private void MenuItemSetting_Click(object sender, EventArgs e)
		{
			SelectTool("Setting");
		}

		private void toolStripButtonBrowser_Click(object sender, EventArgs e)
		{
			SelectTool("WebBrowser");
		}

		private void toolStripButtonScanner_Click(object sender, EventArgs e)
		{
			SelectTool("Scanner");
		}

		private void toolStripButtonSQL_Click(object sender, EventArgs e)
		{
			SelectTool("SQL");
		}

		private void toolStripButtonXSS_Click(object sender, EventArgs e)
		{
			SelectTool("POC");
		}

		private void toolStripButtonSetting_Click(object sender, EventArgs e)
		{
			SelectTool("Setting");
		}

		private void toolStripButtonReport_Click(object sender, EventArgs e)
		{
			SelectTool("Report");
		}

		private void MenuItemReport_Click(object sender, EventArgs e)
		{
			SelectTool("Report");
		}

		private void MenuItemAbout_Click(object sender, EventArgs e)
		{
			SelectTool("About");
		}

		private void CheckUpdate(object data)
		{
			//IL_0024: Unknown result type (might be due to invalid IL or missing references)
			//IL_002a: Invalid comparison between Unknown and I4
			//IL_0041: Unknown result type (might be due to invalid IL or missing references)
			string downloadURL;
			string newVersionNo = GetNewVersionNo(out downloadURL);
			if (!string.IsNullOrEmpty(newVersionNo))
			{
				if ((int)MessageBox.Show("New version found: " + newVersionNo, "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) == 1)
				{
					Process.Start(downloadURL);
				}
			}
			else
			{
				MessageBox.Show("Current version is up-to-date!", "Information", (MessageBoxButtons)0, (MessageBoxIcon)64);
			}
		}

		private void MenuItemCheckUpdate_Click(object sender, EventArgs e)
		{
			ThreadPool.QueueUserWorkItem(new WaitCallback(CheckUpdate));
		}

		public void InitByVulnSQLInjection(VulnSQLInjection vulnSQL)
		{
			SQLForm.InitByVulnSQLInjection(vulnSQL);
		}

		public void UpdateKeyWordText(string ItemText)
		{
			SQLForm.UpdateKeyWordText(ItemText);
		}

		public void XPathPOC(string RefURL, string XPathForm, string Parameter)
		{
			BrowserForm.XPathPOC(RefURL, XPathForm, Parameter);
		}

		public void ExecPOC(Vulnerability vulnXSS)
		{
			POCForm.ExecPOC(vulnXSS);
		}

		private void txtSubmitData_KeyPress(object sender, KeyPressEventArgs e)
		{
			if (e.get_KeyChar() == '\r')
			{
				WebBrowserGo();
			}
		}

		public void DisplayThreadNum(string Text)
		{
			if (!((Control)statusStripMain).get_InvokeRequired())
			{
				((ToolStripItem)lblThreadNum).set_Text(Text);
				((Control)statusStripMain).Refresh();
			}
			else
			{
				dd dd = DisplayThreadNum;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					Text
				});
			}
		}

		private void ScanTimer_Tick(object sender, EventArgs e)
		{
			try
			{
				DisplayThreadNum("HTTP Thread: " + CurrentSite.HTTPThreadNum);
				ScanTimer.set_AutoReset(true);
				TimeSpan timeSpan = DateTime.Now.Subtract(CurrentSite.LastGetTime);
				if (timeSpan.TotalSeconds > 30.0)
				{
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						WebSite.CurrentStatus = TaskStatus.Ready;
						CurrentSite.HTTPThreadNum = 0;
					}
					EnableBtnStop(TrueFalse: true);
				}
				if (CurrentSite.HTTPThreadNum > 0)
				{
					DisplayProgress("Scanning...");
				}
				if (timeSpan.TotalSeconds > 30.0 && CurrentSite.HTTPThreadNum == 0)
				{
					DisplayProgress("Done");
				}
				if (timeSpan.TotalSeconds > 40.0 && CurrentSite.HTTPThreadNum > 0)
				{
					WebSite.DebugLog("Idle time more than 40s, reset HTTP Thread Number " + CurrentSite.HTTPThreadNum + " ==> 0.");
					CurrentSite.HTTPThreadNum = 0;
				}
			}
			catch
			{
			}
		}

		private void EnableBtnStop(bool TrueFalse)
		{
			if (!((Control)toolStripMain).get_InvokeRequired())
			{
				((ToolStripItem)toolStripBtnStop).set_Enabled(TrueFalse);
				return;
			}
			ddEnableBtnStop ddEnableBtnStop = EnableBtnStop;
			((Control)this).Invoke((Delegate)ddEnableBtnStop, new object[1]
			{
				TrueFalse
			});
		}

		private void toolStripBtnPause_Click(object sender, EventArgs e)
		{
			if (WebSite.CurrentStatus == TaskStatus.Ready)
			{
				WebSite.CurrentStatus = TaskStatus.Pause;
				((ToolStripItem)toolStripBtnPause).set_ImageKey("start.png");
				DisplayProgress("PAUSE");
			}
			else if (WebSite.CurrentStatus == TaskStatus.Pause)
			{
				WebSite.CurrentStatus = TaskStatus.Ready;
				((ToolStripItem)toolStripBtnPause).set_ImageKey("pause.png");
			}
		}

		private void toolStripBtnStop_Click(object sender, EventArgs e)
		{
			WebSite.CurrentStatus = TaskStatus.Stop;
			((ToolStripItem)toolStripBtnStop).set_Enabled(false);
			DisplayProgress("Terminating tasks... ");
			CurrentSite.LastGetTime = DateTime.Now;
		}

		private void FormMain_FormClosing(object sender, FormClosingEventArgs e)
		{
			//IL_0029: Unknown result type (might be due to invalid IL or missing references)
			//IL_002f: Invalid comparison between Unknown and I4
			if (WebSite.MultiProcessNum > 0 && (int)MessageBox.Show("* Multi-Site Scanning Task Is Not Complete.\r\n* Site Number: " + WebSite.MultiProcessNum + "\r\n* Continue Exit?\r\n", "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) == 2)
			{
				((CancelEventArgs)e).set_Cancel(true);
			}
		}

		public void DisposeSubForm(FormScanner SubForm)
		{
			if (!((Control)SubForm).get_InvokeRequired())
			{
				((Component)SubForm).Dispose();
				return;
			}
			ddd ddd = DisposeSubForm;
			((Control)this).Invoke((Delegate)ddd, new object[1]
			{
				SubForm
			});
		}

		private void toolStripButtonSave_Click(object sender, EventArgs e)
		{
			SaveWVSData(IsSaveAs: false);
		}

		private void MenuItemSave_Click(object sender, EventArgs e)
		{
			SaveWVSData(IsSaveAs: false);
		}

		private void SaveWVSData(bool IsSaveAs)
		{
			//IL_0030: Unknown result type (might be due to invalid IL or missing references)
			//IL_0036: Expected O, but got Unknown
			//IL_0054: Unknown result type (might be due to invalid IL or missing references)
			//IL_0059: Unknown result type (might be due to invalid IL or missing references)
			//IL_005a: Unknown result type (might be due to invalid IL or missing references)
			//IL_005c: Invalid comparison between Unknown and I4
			//IL_0083: Unknown result type (might be due to invalid IL or missing references)
			//IL_008a: Expected O, but got Unknown
			if (string.IsNullOrEmpty(CurrentSite.wvsFileName) || IsSaveAs)
			{
				string fileName = "WebCruiserWVS_" + CurrentSite.DomainHost + ".dat";
				SaveFileDialog val = new SaveFileDialog();
				((FileDialog)val).set_Filter("Data File(*.dat) | *.dat");
				((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
				((FileDialog)val).set_FileName(fileName);
				DialogResult val2 = ((CommonDialog)val).ShowDialog();
				if ((int)val2 != 1)
				{
					return;
				}
				CurrentSite.wvsFileName = ((FileDialog)val).get_FileName();
			}
			Stream stream = new FileStream(CurrentSite.wvsFileName, FileMode.Create, FileAccess.ReadWrite);
			BinaryFormatter val3 = new BinaryFormatter();
			val3.Serialize(stream, (object)CurrentSite.allVulnList);
			stream.Dispose();
			DisplayProgress(CurrentSite.wvsFileName + " Saved!");
		}

		private XmlDocument GetCurrentSiteXml()
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			XmlDocument val = new XmlDocument();
			XmlNode val2 = (XmlNode)(object)val.CreateXmlDeclaration("1.0", "utf-8", "");
			((XmlNode)val).AppendChild(val2);
			XmlElement val3 = val.CreateElement("ROOT");
			((XmlNode)val).AppendChild((XmlNode)(object)val3);
			XmlElement val4 = val.CreateElement("CurrentSite");
			((XmlNode)val3).AppendChild((XmlNode)(object)val4);
			XmlElement val5 = val.CreateElement("URL");
			val5.SetAttribute("Value", CurrentSite.URL);
			((XmlNode)val4).AppendChild((XmlNode)(object)val5);
			XmlElement val6 = val.CreateElement("RequestType");
			val6.SetAttribute("Value", CurrentRequestType.ToString());
			((XmlNode)val4).AppendChild((XmlNode)(object)val6);
			XmlElement val7 = val.CreateElement("SubmitData");
			val7.SetAttribute("Value", ((ToolStripItem)txtSubmitData).get_Text());
			((XmlNode)val4).AppendChild((XmlNode)(object)val7);
			XmlElement val8 = val.CreateElement("DatabaseType");
			val8.SetAttribute("Value", CurrentSite.DatabaseType.ToString());
			((XmlNode)val4).AppendChild((XmlNode)(object)val8);
			XmlElement val9 = val.CreateElement("CurrentKeyWord");
			val9.SetAttribute("Value", CurrentSite.CurrentKeyWord);
			((XmlNode)val4).AppendChild((XmlNode)(object)val9);
			XmlElement val10 = val.CreateElement("CurrentInjType");
			val10.SetAttribute("Value", CurrentSite.paramType.ToString());
			((XmlNode)val4).AppendChild((XmlNode)(object)val10);
			XmlElement val11 = val.CreateElement("CurrentBlindInjType");
			val11.SetAttribute("Value", CurrentSite.injectMethod.ToString());
			val11.SetAttribute("UnionFieldIndex", CurrentSite.unionFieldIndex.ToString());
			val11.SetAttribute("UnionFieldsCount", CurrentSite.unionFieldsCount.ToString());
			((XmlNode)val4).AppendChild((XmlNode)(object)val11);
			XmlElement val12 = val.CreateElement("WebRoot");
			val12.SetAttribute("Value", CurrentSite.WebRoot);
			((XmlNode)val4).AppendChild((XmlNode)(object)val12);
			XmlElement val13 = val.CreateElement("EscapeCookie");
			val13.SetAttribute("Value", WebSite.EscapeCookie.ToString());
			((XmlNode)val4).AppendChild((XmlNode)(object)val13);
			return val;
		}

		public void UpdateXMLData(XmlDocument WcrXml)
		{
			//IL_0176: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				XmlNode val = ((XmlNode)WcrXml).SelectSingleNode("//ROOT");
				XmlDocument currentSiteXml = GetCurrentSiteXml();
				XmlNode val2 = WcrXml.ImportNode(((XmlNode)currentSiteXml).SelectSingleNode("//ROOT/CurrentSite"), true);
				XmlNode val3 = ((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite");
				if (val3 == null)
				{
					val.AppendChild(val2);
				}
				else
				{
					val.ReplaceChild(val2, val3);
				}
				XmlDocument xmlDocumentFromDirTree = ScannerForm.GetXmlDocumentFromDirTree();
				XmlNode val4 = WcrXml.ImportNode(((XmlNode)xmlDocumentFromDirTree).SelectSingleNode("//ROOT/SiteDirTree"), true);
				XmlNode val5 = ((XmlNode)WcrXml).SelectSingleNode("//ROOT/SiteDirTree");
				if (val5 == null)
				{
					val.AppendChild(val2);
				}
				else
				{
					val.ReplaceChild(val4, val5);
				}
				XmlDocument xmlDocumentFromWVS = ScannerForm.GetXmlDocumentFromWVS();
				XmlNode val6 = WcrXml.ImportNode(((XmlNode)xmlDocumentFromWVS).SelectSingleNode("//ROOT/SiteVulList"), true);
				XmlNode val7 = ((XmlNode)WcrXml).SelectSingleNode("//ROOT/SiteVulList");
				if (val7 == null)
				{
					val.AppendChild(val6);
				}
				else
				{
					val.ReplaceChild(val6, val7);
				}
				XmlDocument xmlDocumentFromDBTree = SQLForm.GetXmlDocumentFromDBTree();
				XmlNode val8 = WcrXml.ImportNode(((XmlNode)xmlDocumentFromDBTree).SelectSingleNode("//ROOT/SiteDBStructure"), true);
				XmlNode val9 = ((XmlNode)WcrXml).SelectSingleNode("//ROOT/SiteDBStructure");
				if (val9 == null)
				{
					val.AppendChild(val8);
				}
				else
				{
					val.ReplaceChild(val8, val9);
				}
				XmlDocument xmlDocumentFromEnv = SQLForm.GetXmlDocumentFromEnv();
				XmlNode val10 = WcrXml.ImportNode(((XmlNode)xmlDocumentFromEnv).SelectSingleNode("//ROOT/SiteSQLEnv"), true);
				XmlNode val11 = ((XmlNode)WcrXml).SelectSingleNode("//ROOT/SiteSQLEnv");
				if (val11 == null)
				{
					val.AppendChild(val10);
				}
				else
				{
					val.ReplaceChild(val10, val11);
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void MenuItemSaveAs_Click(object sender, EventArgs e)
		{
			SaveWVSData(IsSaveAs: true);
		}

		private void toolStripButtonOpen_Click(object sender, EventArgs e)
		{
			OpenWVSData();
		}

		private void MenuItemOpen_Click(object sender, EventArgs e)
		{
			OpenWVSData();
		}

		private void OpenWVSData()
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_001d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_0023: Unknown result type (might be due to invalid IL or missing references)
			//IL_0025: Invalid comparison between Unknown and I4
			//IL_005d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0063: Expected O, but got Unknown
			OpenFileDialog val = new OpenFileDialog();
			((FileDialog)val).set_Filter("Data File(*.dat) | *.dat");
			((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
			DialogResult val2 = ((CommonDialog)val).ShowDialog();
			if ((int)val2 != 1)
			{
				return;
			}
			CurrentSite.wvsFileName = ((FileDialog)val).get_FileName();
			((Component)val).Dispose();
			ScannerForm.ClearCurrentVulnList();
			Stream stream = new FileStream(CurrentSite.wvsFileName, FileMode.Open, FileAccess.Read);
			BinaryFormatter val3 = new BinaryFormatter();
			CurrentSite.allVulnList = (List<Vulnerability>)val3.Deserialize(stream);
			stream.Dispose();
			foreach (Vulnerability allVuln in CurrentSite.allVulnList)
			{
				ScannerForm.AddVulnToListViewWVS(allVuln);
			}
			SelectTool("Scanner");
		}

		private void LoadFromXmlDocument(XmlDocument WcrXml)
		{
			try
			{
				ScannerForm.LoadFromXmlDocument(WcrXml);
				SQLForm.LoadFromXmlDocument(WcrXml);
				URL = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/URL").get_Attributes().get_ItemOf("Value")).get_Value();
				string value = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/RequestType").get_Attributes().get_ItemOf("Value")).get_Value();
				UpdateComboReqType(value);
				ReqType = (RequestType)Enum.Parse(typeof(RequestType), value);
				SubmitData = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/SubmitData").get_Attributes().get_ItemOf("Value")).get_Value();
				CurrentSite.WebRoot = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/WebRoot").get_Attributes().get_ItemOf("Value")).get_Value();
				WebSite.EscapeCookie = bool.Parse(((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/EscapeCookie").get_Attributes().get_ItemOf("Value")).get_Value());
				CookieForm.EscapeCookie(WebSite.EscapeCookie);
			}
			catch
			{
			}
		}

		private void MenuItemNew_Click(object sender, EventArgs e)
		{
			NewScan();
		}

		private void NewScan()
		{
			Process.GetCurrentProcess().get_ProcessName();
			Process.Start(Application.get_ExecutablePath());
		}

		private void toolStripButtonNew_Click(object sender, EventArgs e)
		{
			NewScan();
		}

		private void ButtonScanSite_Click(object sender, EventArgs e)
		{
			SelectTool("Scanner");
			ScannerForm.ScanCurrentSite(isCrawlOnly: false);
		}

		private void ButtonScanURL_Click(object sender, EventArgs e)
		{
			SelectTool("Scanner");
			ScannerForm.ScanCurrentURL();
		}

		private void ButtonScanPage_Click(object sender, EventArgs e)
		{
			SelectTool("Scanner");
			ScannerForm.ScanCurrentPage();
		}

		public void URLTextBoxFocus()
		{
			((ToolStripControlHost)txtURL).Focus();
		}

		private void MenuItemOrder_Click(object sender, EventArgs e)
		{
			string text = "http://www.janusec.com/downloads/";
			try
			{
				Process.Start(text);
			}
			catch
			{
				NavigatePage(text, RequestType.GET, "");
			}
		}

		private void ButtonAutoFill_Click(object sender, EventArgs e)
		{
			BrowserForm.FillInForm(((ToolStripItem)txtSubmitData).get_Text());
		}

		public int GetWCRBrowserFrameNum()
		{
			return BrowserForm.GetWCRBrowserFrameNum();
		}

		public string GetWCRBrowserFrameSource(int i)
		{
			return BrowserForm.GetWCRBrowserFrameSource(i);
		}

		public string GetWCRBrowserFrameURL(int i)
		{
			return BrowserForm.GetWCRBrowserFrameURL(i);
		}

		private void txtURL_DoubleClick(object sender, EventArgs e)
		{
			txtURL.SelectAll();
		}

		private void ButtonCookie_Click(object sender, EventArgs e)
		{
			SelectTool("Cookie");
		}

		private void ButtonTest_Click(object sender, EventArgs e)
		{
		}

		private void txtSubmitData_DoubleClick(object sender, EventArgs e)
		{
			txtSubmitData.SelectAll();
		}

		private void ButtonResend_Click(object sender, EventArgs e)
		{
			SelectTool("Resend");
		}

		private void MenuItemOnlineHelp_Click(object sender, EventArgs e)
		{
			string text = "http://www.janusec.com/documentation/";
			try
			{
				Process.Start(text);
			}
			catch
			{
				NavigatePage(text, RequestType.GET, "");
			}
		}

		private void MenuItemFeedback_Click(object sender, EventArgs e)
		{
			try
			{
				Process.Start("mailto:janusecurity@gmail.com");
			}
			catch
			{
			}
		}

		private void MenuItemSettings_Click(object sender, EventArgs e)
		{
			SelectTool("Setting");
		}

		private void MenuItemWebsite_Click(object sender, EventArgs e)
		{
			string text = "http://www.janusec.com/";
			try
			{
				Process.Start(text);
			}
			catch
			{
				NavigatePage(text, RequestType.GET, "");
			}
		}

		private void MenuItemResend_Click(object sender, EventArgs e)
		{
			SelectTool("Resend");
		}

		private void MenuItemCookie_Click(object sender, EventArgs e)
		{
			SelectTool("Cookie");
		}

		private void MenuItemRefreshURL_Click(object sender, EventArgs e)
		{
			if (MenuItemRefreshURL.get_Checked())
			{
				MenuItemRefreshURL.set_Checked(false);
				WCRSetting.RefreshURL = false;
			}
			else
			{
				MenuItemRefreshURL.set_Checked(true);
				WCRSetting.RefreshURL = true;
			}
		}

		private void MenuItemEscapeCookie_Click(object sender, EventArgs e)
		{
			if (MenuItemEscapeCookie.get_Checked())
			{
				MenuItemEscapeCookie.set_Checked(false);
				WebSite.EscapeCookie = false;
				CookieForm.EscapeCookie(IsEscape: false);
			}
			else
			{
				MenuItemEscapeCookie.set_Checked(true);
				WebSite.EscapeCookie = true;
				CookieForm.EscapeCookie(IsEscape: true);
			}
		}

		public void EscapeCookie(bool IsEscape)
		{
			if (IsEscape)
			{
				MenuItemEscapeCookie.set_Checked(true);
			}
			else
			{
				MenuItemEscapeCookie.set_Checked(false);
			}
		}

		private void MenuItemTextAd_MouseMove(object sender, MouseEventArgs e)
		{
			((Control)this).set_Cursor(Cursors.get_Hand());
		}

		private void MenuItemTextAd_MouseLeave(object sender, EventArgs e)
		{
			((Control)this).set_Cursor(Cursors.get_Arrow());
		}

		private void MenuItemWebEncoding_Click(object sender, EventArgs e)
		{
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_004f: Unknown result type (might be due to invalid IL or missing references)
			//IL_006c: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				MenuItemWebEncodingUTF8.set_Checked(false);
				MenuItemWebEncodingUTF16.set_Checked(false);
				MenuItemWebEncodingISO8859.set_Checked(false);
				MenuItemWebEncodingGB2312.set_Checked(false);
				MenuItemWebEncodingBIG5.set_Checked(false);
				((ToolStripMenuItem)sender).set_Checked(true);
				CurrentSite.WebEncoding = Encoding.GetEncoding(((ToolStripItem)(ToolStripMenuItem)sender).get_Text());
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void MenuItemDBEncoding_Click(object sender, EventArgs e)
		{
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_004f: Unknown result type (might be due to invalid IL or missing references)
			//IL_006c: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				MenuItemDBEncodingUTF8.set_Checked(false);
				MenuItemDBEncodingUTF16.set_Checked(false);
				MenuItemDBEncodingISO8859.set_Checked(false);
				MenuItemDBEncodingGB2312.set_Checked(false);
				MenuItemDBEncodingBIG5.set_Checked(false);
				((ToolStripMenuItem)sender).set_Checked(true);
				CurrentSite.DBEncoding = Encoding.GetEncoding(((ToolStripItem)(ToolStripMenuItem)sender).get_Text());
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void ButtonBruter_Click(object sender, EventArgs e)
		{
			SelectTool("Bruter");
		}

		private void lvRecentLog_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			ContextMenuStrip val = new ContextMenuStrip();
			((ToolStrip)val).get_Items().Add("Copy", (Image)null, (EventHandler)RecentLogListClick);
			((ToolStrip)val).get_Items().Add("Copy All", (Image)null, (EventHandler)RecentLogListClick);
			((Control)lvRecentLog).set_ContextMenuStrip(val);
		}

		private void RecentLogListClick(object sender, EventArgs e)
		{
			//IL_0019: Unknown result type (might be due to invalid IL or missing references)
			//IL_0089: Unknown result type (might be due to invalid IL or missing references)
			//IL_008f: Expected O, but got Unknown
			try
			{
				if (((ListView)lvRecentLog).get_SelectedItems().get_Count() < 1)
				{
					return;
				}
				switch (((ToolStripItem)(ToolStripMenuItem)sender).get_Text())
				{
				case "Copy":
				{
					string text2 = ((ListView)lvRecentLog).get_SelectedItems().get_Item(0).get_Text();
					Clipboard.SetText(text2);
					break;
				}
				case "Copy All":
				{
					string text = "";
					foreach (ListViewItem item in ((ListView)lvRecentLog).get_Items())
					{
						ListViewItem val = item;
						text = text + val.get_SubItems().get_Item(0).get_Text() + "\r\n";
					}
					Clipboard.SetText(text);
					break;
				}
				}
			}
			catch (Exception)
			{
			}
		}

		public void ClearLogList()
		{
			((ListView)lvRecentLog).get_Items().Clear();
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_0010: Unknown result type (might be due to invalid IL or missing references)
			//IL_0016: Expected O, but got Unknown
			//IL_001b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0021: Expected O, but got Unknown
			//IL_0026: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Expected O, but got Unknown
			//IL_0031: Unknown result type (might be due to invalid IL or missing references)
			//IL_0037: Expected O, but got Unknown
			//IL_003c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0043: Expected O, but got Unknown
			//IL_0062: Unknown result type (might be due to invalid IL or missing references)
			//IL_0069: Expected O, but got Unknown
			//IL_006e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0075: Expected O, but got Unknown
			//IL_007a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0081: Expected O, but got Unknown
			//IL_0086: Unknown result type (might be due to invalid IL or missing references)
			//IL_008d: Expected O, but got Unknown
			//IL_0092: Unknown result type (might be due to invalid IL or missing references)
			//IL_0099: Expected O, but got Unknown
			//IL_009e: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a5: Expected O, but got Unknown
			//IL_00aa: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b1: Expected O, but got Unknown
			//IL_00b6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00bd: Expected O, but got Unknown
			//IL_00f6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fd: Expected O, but got Unknown
			//IL_0102: Unknown result type (might be due to invalid IL or missing references)
			//IL_0109: Expected O, but got Unknown
			//IL_0113: Unknown result type (might be due to invalid IL or missing references)
			//IL_011a: Expected O, but got Unknown
			//IL_011b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0125: Expected O, but got Unknown
			//IL_0126: Unknown result type (might be due to invalid IL or missing references)
			//IL_0130: Expected O, but got Unknown
			//IL_0137: Unknown result type (might be due to invalid IL or missing references)
			//IL_0141: Expected O, but got Unknown
			//IL_0142: Unknown result type (might be due to invalid IL or missing references)
			//IL_014c: Expected O, but got Unknown
			//IL_014d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0157: Expected O, but got Unknown
			//IL_0158: Unknown result type (might be due to invalid IL or missing references)
			//IL_0162: Expected O, but got Unknown
			//IL_0163: Unknown result type (might be due to invalid IL or missing references)
			//IL_016d: Expected O, but got Unknown
			//IL_016e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0178: Expected O, but got Unknown
			//IL_0179: Unknown result type (might be due to invalid IL or missing references)
			//IL_0183: Expected O, but got Unknown
			//IL_0184: Unknown result type (might be due to invalid IL or missing references)
			//IL_018e: Expected O, but got Unknown
			//IL_018f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0199: Expected O, but got Unknown
			//IL_019a: Unknown result type (might be due to invalid IL or missing references)
			//IL_01a4: Expected O, but got Unknown
			//IL_01a5: Unknown result type (might be due to invalid IL or missing references)
			//IL_01af: Expected O, but got Unknown
			//IL_01b0: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ba: Expected O, but got Unknown
			//IL_01bb: Unknown result type (might be due to invalid IL or missing references)
			//IL_01c5: Expected O, but got Unknown
			//IL_01c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_01d0: Expected O, but got Unknown
			//IL_01d1: Unknown result type (might be due to invalid IL or missing references)
			//IL_01db: Expected O, but got Unknown
			//IL_01dc: Unknown result type (might be due to invalid IL or missing references)
			//IL_01e6: Expected O, but got Unknown
			//IL_01e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_01f1: Expected O, but got Unknown
			//IL_01f2: Unknown result type (might be due to invalid IL or missing references)
			//IL_01fc: Expected O, but got Unknown
			//IL_01fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0207: Expected O, but got Unknown
			//IL_0208: Unknown result type (might be due to invalid IL or missing references)
			//IL_0212: Expected O, but got Unknown
			//IL_0213: Unknown result type (might be due to invalid IL or missing references)
			//IL_021d: Expected O, but got Unknown
			//IL_021e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0228: Expected O, but got Unknown
			//IL_0229: Unknown result type (might be due to invalid IL or missing references)
			//IL_0233: Expected O, but got Unknown
			//IL_0234: Unknown result type (might be due to invalid IL or missing references)
			//IL_023e: Expected O, but got Unknown
			//IL_023f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0249: Expected O, but got Unknown
			//IL_024a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0254: Expected O, but got Unknown
			//IL_0255: Unknown result type (might be due to invalid IL or missing references)
			//IL_025f: Expected O, but got Unknown
			//IL_0260: Unknown result type (might be due to invalid IL or missing references)
			//IL_026a: Expected O, but got Unknown
			//IL_026b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0275: Expected O, but got Unknown
			//IL_0276: Unknown result type (might be due to invalid IL or missing references)
			//IL_0280: Expected O, but got Unknown
			//IL_0281: Unknown result type (might be due to invalid IL or missing references)
			//IL_028b: Expected O, but got Unknown
			//IL_028c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0296: Expected O, but got Unknown
			//IL_0297: Unknown result type (might be due to invalid IL or missing references)
			//IL_02a1: Expected O, but got Unknown
			//IL_02a2: Unknown result type (might be due to invalid IL or missing references)
			//IL_02ac: Expected O, but got Unknown
			//IL_02ad: Unknown result type (might be due to invalid IL or missing references)
			//IL_02b7: Expected O, but got Unknown
			//IL_02b8: Unknown result type (might be due to invalid IL or missing references)
			//IL_02c2: Expected O, but got Unknown
			//IL_02c3: Unknown result type (might be due to invalid IL or missing references)
			//IL_02cd: Expected O, but got Unknown
			//IL_02ce: Unknown result type (might be due to invalid IL or missing references)
			//IL_02d8: Expected O, but got Unknown
			//IL_02d9: Unknown result type (might be due to invalid IL or missing references)
			//IL_02e3: Expected O, but got Unknown
			//IL_02e4: Unknown result type (might be due to invalid IL or missing references)
			//IL_02ee: Expected O, but got Unknown
			//IL_02ef: Unknown result type (might be due to invalid IL or missing references)
			//IL_02f9: Expected O, but got Unknown
			//IL_02fa: Unknown result type (might be due to invalid IL or missing references)
			//IL_0304: Expected O, but got Unknown
			//IL_0305: Unknown result type (might be due to invalid IL or missing references)
			//IL_030f: Expected O, but got Unknown
			//IL_0310: Unknown result type (might be due to invalid IL or missing references)
			//IL_031a: Expected O, but got Unknown
			//IL_031b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0325: Expected O, but got Unknown
			//IL_0326: Unknown result type (might be due to invalid IL or missing references)
			//IL_0330: Expected O, but got Unknown
			//IL_0331: Unknown result type (might be due to invalid IL or missing references)
			//IL_033b: Expected O, but got Unknown
			//IL_033c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0346: Expected O, but got Unknown
			//IL_0347: Unknown result type (might be due to invalid IL or missing references)
			//IL_0351: Expected O, but got Unknown
			//IL_0352: Unknown result type (might be due to invalid IL or missing references)
			//IL_035c: Expected O, but got Unknown
			//IL_035d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0367: Expected O, but got Unknown
			//IL_0368: Unknown result type (might be due to invalid IL or missing references)
			//IL_0372: Expected O, but got Unknown
			//IL_0373: Unknown result type (might be due to invalid IL or missing references)
			//IL_037d: Expected O, but got Unknown
			//IL_037e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0388: Expected O, but got Unknown
			//IL_0389: Unknown result type (might be due to invalid IL or missing references)
			//IL_0393: Expected O, but got Unknown
			//IL_0394: Unknown result type (might be due to invalid IL or missing references)
			//IL_039e: Expected O, but got Unknown
			//IL_039f: Unknown result type (might be due to invalid IL or missing references)
			//IL_03a9: Expected O, but got Unknown
			//IL_03aa: Unknown result type (might be due to invalid IL or missing references)
			//IL_03b4: Expected O, but got Unknown
			//IL_03b5: Unknown result type (might be due to invalid IL or missing references)
			//IL_03bf: Expected O, but got Unknown
			//IL_03c0: Unknown result type (might be due to invalid IL or missing references)
			//IL_03ca: Expected O, but got Unknown
			//IL_03cb: Unknown result type (might be due to invalid IL or missing references)
			//IL_03d5: Expected O, but got Unknown
			//IL_03d6: Unknown result type (might be due to invalid IL or missing references)
			//IL_03e0: Expected O, but got Unknown
			//IL_03e1: Unknown result type (might be due to invalid IL or missing references)
			//IL_03eb: Expected O, but got Unknown
			//IL_03ec: Unknown result type (might be due to invalid IL or missing references)
			//IL_03f6: Expected O, but got Unknown
			//IL_03f7: Unknown result type (might be due to invalid IL or missing references)
			//IL_0401: Expected O, but got Unknown
			//IL_0402: Unknown result type (might be due to invalid IL or missing references)
			//IL_040c: Expected O, but got Unknown
			//IL_040d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0417: Expected O, but got Unknown
			//IL_0418: Unknown result type (might be due to invalid IL or missing references)
			//IL_0422: Expected O, but got Unknown
			//IL_0423: Unknown result type (might be due to invalid IL or missing references)
			//IL_042d: Expected O, but got Unknown
			//IL_042e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0438: Expected O, but got Unknown
			//IL_0439: Unknown result type (might be due to invalid IL or missing references)
			//IL_0443: Expected O, but got Unknown
			//IL_0444: Unknown result type (might be due to invalid IL or missing references)
			//IL_044e: Expected O, but got Unknown
			//IL_044f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0459: Expected O, but got Unknown
			//IL_045a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0464: Expected O, but got Unknown
			//IL_0465: Unknown result type (might be due to invalid IL or missing references)
			//IL_046f: Expected O, but got Unknown
			//IL_0470: Unknown result type (might be due to invalid IL or missing references)
			//IL_047a: Expected O, but got Unknown
			//IL_047b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0485: Expected O, but got Unknown
			//IL_0486: Unknown result type (might be due to invalid IL or missing references)
			//IL_0490: Expected O, but got Unknown
			//IL_0491: Unknown result type (might be due to invalid IL or missing references)
			//IL_049b: Expected O, but got Unknown
			//IL_049c: Unknown result type (might be due to invalid IL or missing references)
			//IL_04a6: Expected O, but got Unknown
			//IL_04a7: Unknown result type (might be due to invalid IL or missing references)
			//IL_04b1: Expected O, but got Unknown
			//IL_04b2: Unknown result type (might be due to invalid IL or missing references)
			//IL_04bc: Expected O, but got Unknown
			//IL_04bd: Unknown result type (might be due to invalid IL or missing references)
			//IL_04c7: Expected O, but got Unknown
			//IL_04c8: Unknown result type (might be due to invalid IL or missing references)
			//IL_04d2: Expected O, but got Unknown
			//IL_04d3: Unknown result type (might be due to invalid IL or missing references)
			//IL_04dd: Expected O, but got Unknown
			//IL_04de: Unknown result type (might be due to invalid IL or missing references)
			//IL_04e8: Expected O, but got Unknown
			//IL_04e9: Unknown result type (might be due to invalid IL or missing references)
			//IL_04f3: Expected O, but got Unknown
			//IL_04f4: Unknown result type (might be due to invalid IL or missing references)
			//IL_04fe: Expected O, but got Unknown
			//IL_04ff: Unknown result type (might be due to invalid IL or missing references)
			//IL_0509: Expected O, but got Unknown
			//IL_050a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0514: Expected O, but got Unknown
			//IL_0515: Unknown result type (might be due to invalid IL or missing references)
			//IL_051f: Expected O, but got Unknown
			//IL_0520: Unknown result type (might be due to invalid IL or missing references)
			//IL_052a: Expected O, but got Unknown
			//IL_052b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0535: Expected O, but got Unknown
			//IL_0536: Unknown result type (might be due to invalid IL or missing references)
			//IL_0540: Expected O, but got Unknown
			//IL_054c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0556: Expected O, but got Unknown
			//IL_05df: Unknown result type (might be due to invalid IL or missing references)
			//IL_05fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0622: Unknown result type (might be due to invalid IL or missing references)
			//IL_0652: Unknown result type (might be due to invalid IL or missing references)
			//IL_066c: Unknown result type (might be due to invalid IL or missing references)
			//IL_06c3: Unknown result type (might be due to invalid IL or missing references)
			//IL_094b: Unknown result type (might be due to invalid IL or missing references)
			//IL_096e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0978: Expected O, but got Unknown
			//IL_098a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0994: Expected O, but got Unknown
			//IL_099a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0be4: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c42: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c69: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d09: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d35: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d3f: Expected O, but got Unknown
			//IL_0d5c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d9f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0da9: Expected O, but got Unknown
			//IL_0dc6: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e10: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e2c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e36: Expected O, but got Unknown
			//IL_0e53: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ea1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0eeb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f12: Unknown result type (might be due to invalid IL or missing references)
			//IL_0fdd: Unknown result type (might be due to invalid IL or missing references)
			//IL_1024: Unknown result type (might be due to invalid IL or missing references)
			//IL_1082: Unknown result type (might be due to invalid IL or missing references)
			//IL_10cf: Unknown result type (might be due to invalid IL or missing references)
			//IL_1106: Unknown result type (might be due to invalid IL or missing references)
			//IL_1164: Unknown result type (might be due to invalid IL or missing references)
			//IL_11b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_11e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_1246: Unknown result type (might be due to invalid IL or missing references)
			//IL_1293: Unknown result type (might be due to invalid IL or missing references)
			//IL_12ca: Unknown result type (might be due to invalid IL or missing references)
			//IL_1343: Unknown result type (might be due to invalid IL or missing references)
			//IL_13c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_13fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_144b: Unknown result type (might be due to invalid IL or missing references)
			//IL_1499: Unknown result type (might be due to invalid IL or missing references)
			//IL_14e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1535: Unknown result type (might be due to invalid IL or missing references)
			//IL_15cf: Unknown result type (might be due to invalid IL or missing references)
			//IL_1606: Unknown result type (might be due to invalid IL or missing references)
			//IL_1654: Unknown result type (might be due to invalid IL or missing references)
			//IL_16a2: Unknown result type (might be due to invalid IL or missing references)
			//IL_16f0: Unknown result type (might be due to invalid IL or missing references)
			//IL_173e: Unknown result type (might be due to invalid IL or missing references)
			//IL_17cb: Unknown result type (might be due to invalid IL or missing references)
			//IL_1812: Unknown result type (might be due to invalid IL or missing references)
			//IL_185f: Unknown result type (might be due to invalid IL or missing references)
			//IL_18aa: Unknown result type (might be due to invalid IL or missing references)
			//IL_191c: Unknown result type (might be due to invalid IL or missing references)
			//IL_19c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_19fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_1a4c: Unknown result type (might be due to invalid IL or missing references)
			//IL_1a9a: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ae8: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b36: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b83: Unknown result type (might be due to invalid IL or missing references)
			//IL_1baa: Unknown result type (might be due to invalid IL or missing references)
			//IL_1be5: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d12: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d39: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d7d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d87: Expected O, but got Unknown
			//IL_1d8d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1db1: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e10: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e1a: Expected O, but got Unknown
			//IL_1e20: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e44: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ea3: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ead: Expected O, but got Unknown
			//IL_1eb3: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ed7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f31: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f51: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f75: Unknown result type (might be due to invalid IL or missing references)
			//IL_1fcc: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ff0: Unknown result type (might be due to invalid IL or missing references)
			//IL_204a: Unknown result type (might be due to invalid IL or missing references)
			//IL_206a: Unknown result type (might be due to invalid IL or missing references)
			//IL_208e: Unknown result type (might be due to invalid IL or missing references)
			//IL_20e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_2108: Unknown result type (might be due to invalid IL or missing references)
			//IL_212c: Unknown result type (might be due to invalid IL or missing references)
			//IL_2186: Unknown result type (might be due to invalid IL or missing references)
			//IL_21a6: Unknown result type (might be due to invalid IL or missing references)
			//IL_21ca: Unknown result type (might be due to invalid IL or missing references)
			//IL_2221: Unknown result type (might be due to invalid IL or missing references)
			//IL_2245: Unknown result type (might be due to invalid IL or missing references)
			//IL_2298: Unknown result type (might be due to invalid IL or missing references)
			//IL_22a2: Expected O, but got Unknown
			//IL_22a8: Unknown result type (might be due to invalid IL or missing references)
			//IL_22cc: Unknown result type (might be due to invalid IL or missing references)
			//IL_2316: Unknown result type (might be due to invalid IL or missing references)
			//IL_2336: Unknown result type (might be due to invalid IL or missing references)
			//IL_235a: Unknown result type (might be due to invalid IL or missing references)
			//IL_23a4: Unknown result type (might be due to invalid IL or missing references)
			//IL_23d4: Unknown result type (might be due to invalid IL or missing references)
			//IL_2413: Unknown result type (might be due to invalid IL or missing references)
			//IL_243f: Unknown result type (might be due to invalid IL or missing references)
			//IL_2463: Unknown result type (might be due to invalid IL or missing references)
			//IL_24c9: Unknown result type (might be due to invalid IL or missing references)
			//IL_24f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_2525: Unknown result type (might be due to invalid IL or missing references)
			//IL_258b: Unknown result type (might be due to invalid IL or missing references)
			//IL_25b7: Unknown result type (might be due to invalid IL or missing references)
			//IL_25db: Unknown result type (might be due to invalid IL or missing references)
			//IL_2626: Unknown result type (might be due to invalid IL or missing references)
			//IL_2674: Unknown result type (might be due to invalid IL or missing references)
			//IL_269b: Unknown result type (might be due to invalid IL or missing references)
			//IL_26ea: Unknown result type (might be due to invalid IL or missing references)
			//IL_2717: Unknown result type (might be due to invalid IL or missing references)
			//IL_273b: Unknown result type (might be due to invalid IL or missing references)
			//IL_277b: Unknown result type (might be due to invalid IL or missing references)
			//IL_279c: Unknown result type (might be due to invalid IL or missing references)
			//IL_2819: Unknown result type (might be due to invalid IL or missing references)
			//IL_282d: Unknown result type (might be due to invalid IL or missing references)
			//IL_2851: Unknown result type (might be due to invalid IL or missing references)
			//IL_2868: Unknown result type (might be due to invalid IL or missing references)
			//IL_28a8: Unknown result type (might be due to invalid IL or missing references)
			//IL_28db: Unknown result type (might be due to invalid IL or missing references)
			//IL_28f7: Unknown result type (might be due to invalid IL or missing references)
			//IL_292a: Unknown result type (might be due to invalid IL or missing references)
			//IL_2941: Unknown result type (might be due to invalid IL or missing references)
			//IL_294b: Expected O, but got Unknown
			//IL_297b: Unknown result type (might be due to invalid IL or missing references)
			//IL_29e0: Unknown result type (might be due to invalid IL or missing references)
			//IL_2a2f: Unknown result type (might be due to invalid IL or missing references)
			//IL_2a39: Expected O, but got Unknown
			//IL_2a3f: Unknown result type (might be due to invalid IL or missing references)
			//IL_2a63: Unknown result type (might be due to invalid IL or missing references)
			//IL_2ac2: Unknown result type (might be due to invalid IL or missing references)
			//IL_2acc: Expected O, but got Unknown
			//IL_2ad2: Unknown result type (might be due to invalid IL or missing references)
			//IL_2af6: Unknown result type (might be due to invalid IL or missing references)
			//IL_2b55: Unknown result type (might be due to invalid IL or missing references)
			//IL_2b5f: Expected O, but got Unknown
			//IL_2b65: Unknown result type (might be due to invalid IL or missing references)
			//IL_2b89: Unknown result type (might be due to invalid IL or missing references)
			//IL_2bd4: Unknown result type (might be due to invalid IL or missing references)
			//IL_2c47: Unknown result type (might be due to invalid IL or missing references)
			//IL_2c6e: Unknown result type (might be due to invalid IL or missing references)
			//IL_2caa: Unknown result type (might be due to invalid IL or missing references)
			//IL_2cdd: Unknown result type (might be due to invalid IL or missing references)
			//IL_2d0a: Unknown result type (might be due to invalid IL or missing references)
			//IL_2d14: Expected O, but got Unknown
			//IL_2d3d: Unknown result type (might be due to invalid IL or missing references)
			//IL_2d64: Unknown result type (might be due to invalid IL or missing references)
			//IL_2d6e: Expected O, but got Unknown
			//IL_2d9e: Unknown result type (might be due to invalid IL or missing references)
			//IL_2e06: Unknown result type (might be due to invalid IL or missing references)
			//IL_2e39: Unknown result type (might be due to invalid IL or missing references)
			//IL_2e65: Unknown result type (might be due to invalid IL or missing references)
			//IL_2e89: Unknown result type (might be due to invalid IL or missing references)
			//IL_2ecf: Unknown result type (might be due to invalid IL or missing references)
			//IL_2f3b: Unknown result type (might be due to invalid IL or missing references)
			//IL_2fb2: Unknown result type (might be due to invalid IL or missing references)
			//IL_2fe5: Unknown result type (might be due to invalid IL or missing references)
			//IL_3020: Unknown result type (might be due to invalid IL or missing references)
			//IL_302a: Expected O, but got Unknown
			//IL_3055: Unknown result type (might be due to invalid IL or missing references)
			//IL_3071: Unknown result type (might be due to invalid IL or missing references)
			//IL_30ee: Unknown result type (might be due to invalid IL or missing references)
			//IL_30f8: Expected O, but got Unknown
			//IL_3116: Unknown result type (might be due to invalid IL or missing references)
			//IL_3145: Unknown result type (might be due to invalid IL or missing references)
			//IL_314f: Expected O, but got Unknown
			components = (IContainer)new Container();
			TreeNode val = new TreeNode("Browser");
			TreeNode val2 = new TreeNode("Scanner");
			TreeNode val3 = new TreeNode("SQL Injection");
			TreeNode val4 = new TreeNode("XSS/LFI/RFI/Redirect");
			TreeNode val5 = new TreeNode("AdminEntrance");
			TreeNode val6 = new TreeNode("POC", (TreeNode[])(object)new TreeNode[3]
			{
				val3,
				val4,
				val5
			});
			TreeNode val7 = new TreeNode("ResendTool");
			TreeNode val8 = new TreeNode("BruterTool");
			TreeNode val9 = new TreeNode("CookieTool");
			TreeNode val10 = new TreeNode("CodeTool");
			TreeNode val11 = new TreeNode("StringTool");
			TreeNode val12 = new TreeNode("Settings");
			TreeNode val13 = new TreeNode("Report");
			TreeNode val14 = new TreeNode("Tools", (TreeNode[])(object)new TreeNode[7]
			{
				val7,
				val8,
				val9,
				val10,
				val11,
				val12,
				val13
			});
			TreeNode val15 = new TreeNode("About");
			ComponentResourceManager val16 = new ComponentResourceManager(typeof(FormMain));
			splitMain = new SplitContainer();
			treeViewToolTree = new TreeView();
			WCRImageList = new ImageList(components);
			menuStripMain = new MenuStrip();
			MenuItemFile = new ToolStripMenuItem();
			MenuItemNew = new ToolStripMenuItem();
			MenuItemOpen = new ToolStripMenuItem();
			toolStripSeparator8 = new ToolStripSeparator();
			MenuItemSave = new ToolStripMenuItem();
			MenuItemSaveAs = new ToolStripMenuItem();
			toolStripSeparator6 = new ToolStripSeparator();
			MenuItemExit = new ToolStripMenuItem();
			MenuItemTool = new ToolStripMenuItem();
			MenuItemWebBrowser = new ToolStripMenuItem();
			MenuItemScanner = new ToolStripMenuItem();
			toolStripSeparator9 = new ToolStripSeparator();
			MenuItemSQLInjection = new ToolStripMenuItem();
			MenuItemXSS = new ToolStripMenuItem();
			toolStripSeparator5 = new ToolStripSeparator();
			MenuItemResend = new ToolStripMenuItem();
			MenuItemCookie = new ToolStripMenuItem();
			toolStripSeparator12 = new ToolStripSeparator();
			MenuItemReport = new ToolStripMenuItem();
			MenuItemView = new ToolStripMenuItem();
			MenuItemWebEncoding = new ToolStripMenuItem();
			MenuItemWebEncodingUTF8 = new ToolStripMenuItem();
			MenuItemWebEncodingUTF16 = new ToolStripMenuItem();
			MenuItemWebEncodingISO8859 = new ToolStripMenuItem();
			MenuItemWebEncodingGB2312 = new ToolStripMenuItem();
			MenuItemWebEncodingBIG5 = new ToolStripMenuItem();
			MenuItemDBEncoding = new ToolStripMenuItem();
			MenuItemDBEncodingUTF8 = new ToolStripMenuItem();
			MenuItemDBEncodingUTF16 = new ToolStripMenuItem();
			MenuItemDBEncodingISO8859 = new ToolStripMenuItem();
			MenuItemDBEncodingGB2312 = new ToolStripMenuItem();
			MenuItemDBEncodingBIG5 = new ToolStripMenuItem();
			MenuItemConfig = new ToolStripMenuItem();
			MenuItemSettings = new ToolStripMenuItem();
			toolStripSeparator19 = new ToolStripSeparator();
			MenuItemRefreshURL = new ToolStripMenuItem();
			MenuItemEscapeCookie = new ToolStripMenuItem();
			MenuItemHelp = new ToolStripMenuItem();
			MenuItemOnlineHelp = new ToolStripMenuItem();
			MenuItemOrder = new ToolStripMenuItem();
			MenuItemCheckUpdate = new ToolStripMenuItem();
			MenuItemFeedback = new ToolStripMenuItem();
			MenuItemWebsite = new ToolStripMenuItem();
			toolStripSeparator7 = new ToolStripSeparator();
			MenuItemAbout = new ToolStripMenuItem();
			toolStripMain = new ToolStrip();
			toolStripButtonNew = new ToolStripButton();
			toolStripButtonOpen = new ToolStripButton();
			toolStripButtonSave = new ToolStripButton();
			toolStripSeparator4 = new ToolStripSeparator();
			toolStripButtonBrowser = new ToolStripButton();
			toolStripButtonScanner = new ToolStripButton();
			toolStripSeparator10 = new ToolStripSeparator();
			toolStripButtonSQL = new ToolStripButton();
			toolStripSeparator20 = new ToolStripSeparator();
			toolStripButtonXSS = new ToolStripButton();
			toolStripSeparator11 = new ToolStripSeparator();
			ButtonResend = new ToolStripButton();
			ButtonBruter = new ToolStripButton();
			ButtonCookie = new ToolStripButton();
			toolStripSeparator17 = new ToolStripSeparator();
			ButtonSetting = new ToolStripButton();
			toolStripSeparator13 = new ToolStripSeparator();
			lblBlank = new ToolStripLabel();
			toolStripSeparator18 = new ToolStripSeparator();
			ButtonScanSite = new ToolStripButton();
			toolStripSeparator14 = new ToolStripSeparator();
			ButtonScanPage = new ToolStripButton();
			toolStripSeparator15 = new ToolStripSeparator();
			ButtonScanURL = new ToolStripButton();
			statusStripMain = new StatusStrip();
			toolStripStatusProgress = new ToolStripStatusLabel();
			toolStripStatusSep1 = new ToolStripStatusLabel();
			lblThreadNum = new ToolStripStatusLabel();
			toolStripURL = new ToolStrip();
			toolStripLabel1 = new ToolStripLabel();
			toolStripSeparator1 = new ToolStripSeparator();
			txtURL = new ToolStripTextBox();
			toolStripSeparator3 = new ToolStripSeparator();
			cmbReqType = new ToolStripComboBox();
			toolStripBtnGo = new ToolStripButton();
			toolStripBtnPause = new ToolStripButton();
			toolStripBtnStop = new ToolStripButton();
			toolStripData = new ToolStrip();
			lblSubmitData = new ToolStripLabel();
			toolStripSeparator2 = new ToolStripSeparator();
			txtSubmitData = new ToolStripTextBox();
			toolStripSeparator16 = new ToolStripSeparator();
			cmbEnctype = new ToolStripComboBox();
			toolStripSeparator21 = new ToolStripSeparator();
			ButtonAutoFill = new ToolStripButton();
			splitUpDown = new SplitContainer();
			lvRecentLog = new ListViewNF();
			columnProgress = new ColumnHeader();
			((Control)splitMain.get_Panel1()).SuspendLayout();
			((Control)splitMain).SuspendLayout();
			((Control)menuStripMain).SuspendLayout();
			((Control)toolStripMain).SuspendLayout();
			((Control)statusStripMain).SuspendLayout();
			((Control)toolStripURL).SuspendLayout();
			((Control)toolStripData).SuspendLayout();
			((Control)splitUpDown.get_Panel1()).SuspendLayout();
			((Control)splitUpDown.get_Panel2()).SuspendLayout();
			((Control)splitUpDown).SuspendLayout();
			((Control)this).SuspendLayout();
			((Control)splitMain).set_BackColor(SystemColors.get_ButtonFace());
			splitMain.set_Dock((DockStyle)5);
			((Control)splitMain).set_Location(new Point(0, 0));
			((Control)splitMain).set_Name("splitMain");
			((Control)splitMain.get_Panel1()).set_BackColor(Color.get_WhiteSmoke());
			((Control)splitMain.get_Panel1()).get_Controls().Add((Control)(object)treeViewToolTree);
			((Control)splitMain.get_Panel2()).set_BackColor(Color.get_WhiteSmoke());
			((Control)splitMain).set_Size(new Size(984, 375));
			splitMain.set_SplitterDistance(191);
			((Control)splitMain).set_TabIndex(4);
			((Control)treeViewToolTree).set_Dock((DockStyle)5);
			treeViewToolTree.set_ImageIndex(0);
			treeViewToolTree.set_ImageList(WCRImageList);
			((Control)treeViewToolTree).set_Location(new Point(0, 0));
			((Control)treeViewToolTree).set_Name("treeViewToolTree");
			val.set_ImageKey("ie.png");
			val.set_Name("WebBrowser");
			val.set_Text("Browser");
			val2.set_ImageKey("scan.png");
			val2.set_Name("Scanner");
			val2.set_Text("Scanner");
			val3.set_ImageKey("db.png");
			val3.set_Name("SQL");
			val3.set_Text("SQL Injection");
			val4.set_ImageKey("xss.png");
			val4.set_Name("POC");
			val4.set_Text("XSS/LFI/RFI/Redirect");
			val5.set_ImageKey("admin.png");
			val5.set_Name("Admin");
			val5.set_Text("AdminEntrance");
			val6.set_ImageKey("tool.png");
			val6.set_Name("POCTool");
			val6.set_Text("POC");
			val6.set_ToolTipText("Proof of Concept");
			val7.set_ImageKey("resend.png");
			val7.set_Name("Resend");
			val7.set_Text("ResendTool");
			val8.set_ImageKey("bruter.png");
			val8.set_Name("Bruter");
			val8.set_Text("BruterTool");
			val9.set_ImageKey("cookie.png");
			val9.set_Name("Cookie");
			val9.set_Text("CookieTool");
			val10.set_ImageKey("code.png");
			val10.set_Name("Code");
			val10.set_Text("CodeTool");
			val11.set_ImageKey("encode.png");
			val11.set_Name("StringTool");
			val11.set_Text("StringTool");
			val12.set_ImageKey("tool.png");
			val12.set_Name("Setting");
			val12.set_Text("Settings");
			val13.set_ImageKey("report.png");
			val13.set_Name("Report");
			val13.set_Text("Report");
			val14.set_ImageKey("tool.png");
			val14.set_Name("SystemTool");
			val14.set_Text("Tools");
			val15.set_ImageKey("about.png");
			val15.set_Name("About");
			val15.set_Text("About");
			treeViewToolTree.get_Nodes().AddRange((TreeNode[])(object)new TreeNode[5]
			{
				val,
				val2,
				val6,
				val14,
				val15
			});
			treeViewToolTree.set_SelectedImageIndex(0);
			((Control)treeViewToolTree).set_Size(new Size(191, 375));
			((Control)treeViewToolTree).set_TabIndex(0);
			treeViewToolTree.add_NodeMouseClick(new TreeNodeMouseClickEventHandler(treeViewToolTree_NodeMouseClick));
			WCRImageList.set_ImageStream((ImageListStreamer)((ResourceManager)(object)val16).GetObject("WCRImageList.ImageStream"));
			WCRImageList.set_TransparentColor(Color.get_Transparent());
			WCRImageList.get_Images().SetKeyName(0, "select.png");
			WCRImageList.get_Images().SetKeyName(1, "ie.png");
			WCRImageList.get_Images().SetKeyName(2, "scan.png");
			WCRImageList.get_Images().SetKeyName(3, "env.png");
			WCRImageList.get_Images().SetKeyName(4, "db.png");
			WCRImageList.get_Images().SetKeyName(5, "xss.png");
			WCRImageList.get_Images().SetKeyName(6, "cmd.png");
			WCRImageList.get_Images().SetKeyName(7, "admin.png");
			WCRImageList.get_Images().SetKeyName(8, "file.png");
			WCRImageList.get_Images().SetKeyName(9, "tool.png");
			WCRImageList.get_Images().SetKeyName(10, "code.png");
			WCRImageList.get_Images().SetKeyName(11, "about.png");
			WCRImageList.get_Images().SetKeyName(12, "go.png");
			WCRImageList.get_Images().SetKeyName(13, "start.png");
			WCRImageList.get_Images().SetKeyName(14, "pause.png");
			WCRImageList.get_Images().SetKeyName(15, "stop.png");
			WCRImageList.get_Images().SetKeyName(16, "table.png");
			WCRImageList.get_Images().SetKeyName(17, "column.png");
			WCRImageList.get_Images().SetKeyName(18, "vul.png");
			WCRImageList.get_Images().SetKeyName(19, "xml.png");
			WCRImageList.get_Images().SetKeyName(20, "report.png");
			WCRImageList.get_Images().SetKeyName(21, "cookie.png");
			WCRImageList.get_Images().SetKeyName(22, "resend.png");
			WCRImageList.get_Images().SetKeyName(23, "encode.png");
			WCRImageList.get_Images().SetKeyName(24, "bruter.png");
			((ToolStrip)menuStripMain).set_ImageScalingSize(new Size(20, 20));
			((ToolStrip)menuStripMain).get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[5]
			{
				(ToolStripItem)MenuItemFile,
				(ToolStripItem)MenuItemTool,
				(ToolStripItem)MenuItemView,
				(ToolStripItem)MenuItemConfig,
				(ToolStripItem)MenuItemHelp
			});
			((Control)menuStripMain).set_Location(new Point(0, 0));
			((Control)menuStripMain).set_Name("menuStripMain");
			((Control)menuStripMain).set_Size(new Size(984, 25));
			((Control)menuStripMain).set_TabIndex(0);
			((Control)menuStripMain).set_Text("menuStrip1");
			((ToolStripDropDownItem)MenuItemFile).get_DropDownItems().AddRange((ToolStripItem[])(object)new ToolStripItem[7]
			{
				(ToolStripItem)MenuItemNew,
				(ToolStripItem)MenuItemOpen,
				(ToolStripItem)toolStripSeparator8,
				(ToolStripItem)MenuItemSave,
				(ToolStripItem)MenuItemSaveAs,
				(ToolStripItem)toolStripSeparator6,
				(ToolStripItem)MenuItemExit
			});
			((ToolStripItem)MenuItemFile).set_Name("MenuItemFile");
			((ToolStripItem)MenuItemFile).set_Size(new Size(39, 21));
			((ToolStripItem)MenuItemFile).set_Text("&File");
			((ToolStripItem)MenuItemNew).set_Image((Image)((ResourceManager)(object)val16).GetObject("MenuItemNew.Image"));
			((ToolStripItem)MenuItemNew).set_Name("MenuItemNew");
			((ToolStripItem)MenuItemNew).set_Size(new Size(130, 22));
			((ToolStripItem)MenuItemNew).set_Text("New");
			((ToolStripItem)MenuItemNew).add_Click((EventHandler)MenuItemNew_Click);
			((ToolStripItem)MenuItemOpen).set_Image((Image)((ResourceManager)(object)val16).GetObject("MenuItemOpen.Image"));
			((ToolStripItem)MenuItemOpen).set_Name("MenuItemOpen");
			((ToolStripItem)MenuItemOpen).set_Size(new Size(130, 22));
			((ToolStripItem)MenuItemOpen).set_Text("Open");
			((ToolStripItem)MenuItemOpen).add_Click((EventHandler)MenuItemOpen_Click);
			((ToolStripItem)toolStripSeparator8).set_Name("toolStripSeparator8");
			((ToolStripItem)toolStripSeparator8).set_Size(new Size(127, 6));
			((ToolStripItem)MenuItemSave).set_Image((Image)((ResourceManager)(object)val16).GetObject("MenuItemSave.Image"));
			((ToolStripItem)MenuItemSave).set_Name("MenuItemSave");
			((ToolStripItem)MenuItemSave).set_Size(new Size(130, 22));
			((ToolStripItem)MenuItemSave).set_Text("Save");
			((ToolStripItem)MenuItemSave).add_Click((EventHandler)MenuItemSave_Click);
			((ToolStripItem)MenuItemSaveAs).set_Name("MenuItemSaveAs");
			((ToolStripItem)MenuItemSaveAs).set_Size(new Size(130, 22));
			((ToolStripItem)MenuItemSaveAs).set_Text("Save As...");
			((ToolStripItem)MenuItemSaveAs).add_Click((EventHandler)MenuItemSaveAs_Click);
			((ToolStripItem)toolStripSeparator6).set_Name("toolStripSeparator6");
			((ToolStripItem)toolStripSeparator6).set_Size(new Size(127, 6));
			((ToolStripItem)MenuItemExit).set_Name("MenuItemExit");
			((ToolStripItem)MenuItemExit).set_Size(new Size(130, 22));
			((ToolStripItem)MenuItemExit).set_Text("E&xit");
			((ToolStripItem)MenuItemExit).add_Click((EventHandler)exitToolStripMenuItem_Click);
			((ToolStripDropDownItem)MenuItemTool).get_DropDownItems().AddRange((ToolStripItem[])(object)new ToolStripItem[10]
			{
				(ToolStripItem)MenuItemWebBrowser,
				(ToolStripItem)MenuItemScanner,
				(ToolStripItem)toolStripSeparator9,
				(ToolStripItem)MenuItemSQLInjection,
				(ToolStripItem)MenuItemXSS,
				(ToolStripItem)toolStripSeparator5,
				(ToolStripItem)MenuItemResend,
				(ToolStripItem)MenuItemCookie,
				(ToolStripItem)toolStripSeparator12,
				(ToolStripItem)MenuItemReport
			});
			((ToolStripItem)MenuItemTool).set_Name("MenuItemTool");
			((ToolStripItem)MenuItemTool).set_Size(new Size(52, 21));
			((ToolStripItem)MenuItemTool).set_Text("&Tools");
			((ToolStripItem)MenuItemWebBrowser).set_Image((Image)(object)Resources.ie);
			((ToolStripItem)MenuItemWebBrowser).set_Name("MenuItemWebBrowser");
			((ToolStripItem)MenuItemWebBrowser).set_Size(new Size(232, 22));
			((ToolStripItem)MenuItemWebBrowser).set_Text("WebBrowser");
			((ToolStripItem)MenuItemWebBrowser).add_Click((EventHandler)MenuItemWebBrowser_Click);
			((ToolStripItem)MenuItemScanner).set_Image((Image)(object)Resources.scan);
			((ToolStripItem)MenuItemScanner).set_Name("MenuItemScanner");
			((ToolStripItem)MenuItemScanner).set_Size(new Size(232, 22));
			((ToolStripItem)MenuItemScanner).set_Text("Vulnerability Scanner");
			((ToolStripItem)MenuItemScanner).add_Click((EventHandler)MenuItemScanner_Click);
			((ToolStripItem)toolStripSeparator9).set_Name("toolStripSeparator9");
			((ToolStripItem)toolStripSeparator9).set_Size(new Size(229, 6));
			((ToolStripItem)MenuItemSQLInjection).set_Image((Image)(object)Resources.db);
			((ToolStripItem)MenuItemSQLInjection).set_Name("MenuItemSQLInjection");
			((ToolStripItem)MenuItemSQLInjection).set_Size(new Size(232, 22));
			((ToolStripItem)MenuItemSQLInjection).set_Text("SQL Injection");
			((ToolStripItem)MenuItemSQLInjection).add_Click((EventHandler)MenuItemSQLInjection_Click);
			((ToolStripItem)MenuItemXSS).set_Image((Image)(object)Resources.xss);
			((ToolStripItem)MenuItemXSS).set_Name("MenuItemXSS");
			((ToolStripItem)MenuItemXSS).set_Size(new Size(232, 22));
			((ToolStripItem)MenuItemXSS).set_Text("POC (XSS/LFI/RFI/Redirect)");
			((ToolStripItem)MenuItemXSS).add_Click((EventHandler)MenuItemXSS_Click);
			((ToolStripItem)toolStripSeparator5).set_Name("toolStripSeparator5");
			((ToolStripItem)toolStripSeparator5).set_Size(new Size(229, 6));
			((ToolStripItem)MenuItemResend).set_Image((Image)(object)Resources.resend);
			((ToolStripItem)MenuItemResend).set_Name("MenuItemResend");
			((ToolStripItem)MenuItemResend).set_Size(new Size(232, 22));
			((ToolStripItem)MenuItemResend).set_Text("Resend");
			((ToolStripItem)MenuItemResend).add_Click((EventHandler)MenuItemResend_Click);
			((ToolStripItem)MenuItemCookie).set_Image((Image)(object)Resources.cookie);
			((ToolStripItem)MenuItemCookie).set_Name("MenuItemCookie");
			((ToolStripItem)MenuItemCookie).set_Size(new Size(232, 22));
			((ToolStripItem)MenuItemCookie).set_Text("Cookie");
			((ToolStripItem)MenuItemCookie).add_Click((EventHandler)MenuItemCookie_Click);
			((ToolStripItem)toolStripSeparator12).set_Name("toolStripSeparator12");
			((ToolStripItem)toolStripSeparator12).set_Size(new Size(229, 6));
			((ToolStripItem)MenuItemReport).set_Image((Image)(object)Resources.report);
			((ToolStripItem)MenuItemReport).set_Name("MenuItemReport");
			((ToolStripItem)MenuItemReport).set_Size(new Size(232, 22));
			((ToolStripItem)MenuItemReport).set_Text("Report");
			((ToolStripItem)MenuItemReport).add_Click((EventHandler)MenuItemReport_Click);
			((ToolStripDropDownItem)MenuItemView).get_DropDownItems().AddRange((ToolStripItem[])(object)new ToolStripItem[2]
			{
				(ToolStripItem)MenuItemWebEncoding,
				(ToolStripItem)MenuItemDBEncoding
			});
			((ToolStripItem)MenuItemView).set_Name("MenuItemView");
			((ToolStripItem)MenuItemView).set_Size(new Size(47, 21));
			((ToolStripItem)MenuItemView).set_Text("&View");
			((ToolStripDropDownItem)MenuItemWebEncoding).get_DropDownItems().AddRange((ToolStripItem[])(object)new ToolStripItem[5]
			{
				(ToolStripItem)MenuItemWebEncodingUTF8,
				(ToolStripItem)MenuItemWebEncodingUTF16,
				(ToolStripItem)MenuItemWebEncodingISO8859,
				(ToolStripItem)MenuItemWebEncodingGB2312,
				(ToolStripItem)MenuItemWebEncodingBIG5
			});
			((ToolStripItem)MenuItemWebEncoding).set_Name("MenuItemWebEncoding");
			((ToolStripItem)MenuItemWebEncoding).set_Size(new Size(189, 22));
			((ToolStripItem)MenuItemWebEncoding).set_Text("Web Encoding");
			((ToolStripItem)MenuItemWebEncodingUTF8).set_Name("MenuItemWebEncodingUTF8");
			((ToolStripItem)MenuItemWebEncodingUTF8).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemWebEncodingUTF8).set_Text("UTF-8");
			((ToolStripItem)MenuItemWebEncodingUTF8).add_Click((EventHandler)MenuItemWebEncoding_Click);
			((ToolStripItem)MenuItemWebEncodingUTF16).set_Name("MenuItemWebEncodingUTF16");
			((ToolStripItem)MenuItemWebEncodingUTF16).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemWebEncodingUTF16).set_Text("UTF-16");
			((ToolStripItem)MenuItemWebEncodingUTF16).add_Click((EventHandler)MenuItemWebEncoding_Click);
			((ToolStripItem)MenuItemWebEncodingISO8859).set_Name("MenuItemWebEncodingISO8859");
			((ToolStripItem)MenuItemWebEncodingISO8859).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemWebEncodingISO8859).set_Text("ISO-8859-1");
			((ToolStripItem)MenuItemWebEncodingISO8859).add_Click((EventHandler)MenuItemWebEncoding_Click);
			((ToolStripItem)MenuItemWebEncodingGB2312).set_Name("MenuItemWebEncodingGB2312");
			((ToolStripItem)MenuItemWebEncodingGB2312).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemWebEncodingGB2312).set_Text("GB2312");
			((ToolStripItem)MenuItemWebEncodingGB2312).add_Click((EventHandler)MenuItemWebEncoding_Click);
			((ToolStripItem)MenuItemWebEncodingBIG5).set_Name("MenuItemWebEncodingBIG5");
			((ToolStripItem)MenuItemWebEncodingBIG5).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemWebEncodingBIG5).set_Text("BIG5");
			((ToolStripItem)MenuItemWebEncodingBIG5).add_Click((EventHandler)MenuItemWebEncoding_Click);
			((ToolStripDropDownItem)MenuItemDBEncoding).get_DropDownItems().AddRange((ToolStripItem[])(object)new ToolStripItem[5]
			{
				(ToolStripItem)MenuItemDBEncodingUTF8,
				(ToolStripItem)MenuItemDBEncodingUTF16,
				(ToolStripItem)MenuItemDBEncodingISO8859,
				(ToolStripItem)MenuItemDBEncodingGB2312,
				(ToolStripItem)MenuItemDBEncodingBIG5
			});
			((ToolStripItem)MenuItemDBEncoding).set_Name("MenuItemDBEncoding");
			((ToolStripItem)MenuItemDBEncoding).set_Size(new Size(189, 22));
			((ToolStripItem)MenuItemDBEncoding).set_Text("Database Encoding");
			((ToolStripItem)MenuItemDBEncodingUTF8).set_Name("MenuItemDBEncodingUTF8");
			((ToolStripItem)MenuItemDBEncodingUTF8).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemDBEncodingUTF8).set_Text("UTF-8");
			((ToolStripItem)MenuItemDBEncodingUTF8).add_Click((EventHandler)MenuItemDBEncoding_Click);
			((ToolStripItem)MenuItemDBEncodingUTF16).set_Name("MenuItemDBEncodingUTF16");
			((ToolStripItem)MenuItemDBEncodingUTF16).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemDBEncodingUTF16).set_Text("UTF-16");
			((ToolStripItem)MenuItemDBEncodingUTF16).add_Click((EventHandler)MenuItemDBEncoding_Click);
			((ToolStripItem)MenuItemDBEncodingISO8859).set_Name("MenuItemDBEncodingISO8859");
			((ToolStripItem)MenuItemDBEncodingISO8859).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemDBEncodingISO8859).set_Text("ISO-8859-1");
			((ToolStripItem)MenuItemDBEncodingISO8859).add_Click((EventHandler)MenuItemDBEncoding_Click);
			((ToolStripItem)MenuItemDBEncodingGB2312).set_Name("MenuItemDBEncodingGB2312");
			((ToolStripItem)MenuItemDBEncodingGB2312).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemDBEncodingGB2312).set_Text("GB2312");
			((ToolStripItem)MenuItemDBEncodingGB2312).add_Click((EventHandler)MenuItemDBEncoding_Click);
			((ToolStripItem)MenuItemDBEncodingBIG5).set_Name("MenuItemDBEncodingBIG5");
			((ToolStripItem)MenuItemDBEncodingBIG5).set_Size(new Size(142, 22));
			((ToolStripItem)MenuItemDBEncodingBIG5).set_Text("BIG5");
			((ToolStripItem)MenuItemDBEncodingBIG5).add_Click((EventHandler)MenuItemDBEncoding_Click);
			((ToolStripDropDownItem)MenuItemConfig).get_DropDownItems().AddRange((ToolStripItem[])(object)new ToolStripItem[4]
			{
				(ToolStripItem)MenuItemSettings,
				(ToolStripItem)toolStripSeparator19,
				(ToolStripItem)MenuItemRefreshURL,
				(ToolStripItem)MenuItemEscapeCookie
			});
			((ToolStripItem)MenuItemConfig).set_Name("MenuItemConfig");
			((ToolStripItem)MenuItemConfig).set_Size(new Size(99, 21));
			((ToolStripItem)MenuItemConfig).set_Text("&Configuration");
			((ToolStripItem)MenuItemSettings).set_Image((Image)(object)Resources.tool);
			((ToolStripItem)MenuItemSettings).set_Name("MenuItemSettings");
			((ToolStripItem)MenuItemSettings).set_Size(new Size(287, 22));
			((ToolStripItem)MenuItemSettings).set_Text("Settings");
			((ToolStripItem)MenuItemSettings).add_Click((EventHandler)MenuItemSettings_Click);
			((ToolStripItem)toolStripSeparator19).set_Name("toolStripSeparator19");
			((ToolStripItem)toolStripSeparator19).set_Size(new Size(284, 6));
			MenuItemRefreshURL.set_Checked(true);
			MenuItemRefreshURL.set_CheckState((CheckState)1);
			((ToolStripItem)MenuItemRefreshURL).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)MenuItemRefreshURL).set_Name("MenuItemRefreshURL");
			((ToolStripItem)MenuItemRefreshURL).set_Size(new Size(287, 22));
			((ToolStripItem)MenuItemRefreshURL).set_Text("Refresh URL when Navigating");
			((ToolStripItem)MenuItemRefreshURL).add_Click((EventHandler)MenuItemRefreshURL_Click);
			MenuItemEscapeCookie.set_Checked(true);
			MenuItemEscapeCookie.set_CheckState((CheckState)1);
			((ToolStripItem)MenuItemEscapeCookie).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)MenuItemEscapeCookie).set_Name("MenuItemEscapeCookie");
			((ToolStripItem)MenuItemEscapeCookie).set_Size(new Size(287, 22));
			((ToolStripItem)MenuItemEscapeCookie).set_Text("Escape Special Characters in Cookie");
			((ToolStripItem)MenuItemEscapeCookie).add_Click((EventHandler)MenuItemEscapeCookie_Click);
			((ToolStripDropDownItem)MenuItemHelp).get_DropDownItems().AddRange((ToolStripItem[])(object)new ToolStripItem[7]
			{
				(ToolStripItem)MenuItemOnlineHelp,
				(ToolStripItem)MenuItemOrder,
				(ToolStripItem)MenuItemCheckUpdate,
				(ToolStripItem)MenuItemFeedback,
				(ToolStripItem)MenuItemWebsite,
				(ToolStripItem)toolStripSeparator7,
				(ToolStripItem)MenuItemAbout
			});
			((ToolStripItem)MenuItemHelp).set_Name("MenuItemHelp");
			((ToolStripItem)MenuItemHelp).set_Size(new Size(47, 21));
			((ToolStripItem)MenuItemHelp).set_Text("&Help");
			((ToolStripItem)MenuItemOnlineHelp).set_Name("MenuItemOnlineHelp");
			((ToolStripItem)MenuItemOnlineHelp).set_Size(new Size(195, 22));
			((ToolStripItem)MenuItemOnlineHelp).set_Text("Online Help");
			((ToolStripItem)MenuItemOnlineHelp).add_Click((EventHandler)MenuItemOnlineHelp_Click);
			((ToolStripItem)MenuItemOrder).set_Name("MenuItemOrder");
			((ToolStripItem)MenuItemOrder).set_Size(new Size(195, 22));
			((ToolStripItem)MenuItemOrder).set_Text("Order WebCruiser");
			((ToolStripItem)MenuItemOrder).add_Click((EventHandler)MenuItemOrder_Click);
			((ToolStripItem)MenuItemCheckUpdate).set_Name("MenuItemCheckUpdate");
			((ToolStripItem)MenuItemCheckUpdate).set_Size(new Size(195, 22));
			((ToolStripItem)MenuItemCheckUpdate).set_Text("Check Updates");
			((ToolStripItem)MenuItemCheckUpdate).add_Click((EventHandler)MenuItemCheckUpdate_Click);
			((ToolStripItem)MenuItemFeedback).set_Name("MenuItemFeedback");
			((ToolStripItem)MenuItemFeedback).set_Size(new Size(195, 22));
			((ToolStripItem)MenuItemFeedback).set_Text("Feedback to Author");
			((ToolStripItem)MenuItemFeedback).add_Click((EventHandler)MenuItemFeedback_Click);
			((ToolStripItem)MenuItemWebsite).set_Name("MenuItemWebsite");
			((ToolStripItem)MenuItemWebsite).set_Size(new Size(195, 22));
			((ToolStripItem)MenuItemWebsite).set_Text("WebCruiser Website");
			((ToolStripItem)MenuItemWebsite).add_Click((EventHandler)MenuItemWebsite_Click);
			((ToolStripItem)toolStripSeparator7).set_Name("toolStripSeparator7");
			((ToolStripItem)toolStripSeparator7).set_Size(new Size(192, 6));
			((ToolStripItem)MenuItemAbout).set_Name("MenuItemAbout");
			((ToolStripItem)MenuItemAbout).set_Size(new Size(195, 22));
			((ToolStripItem)MenuItemAbout).set_Text("About WebCruiser");
			((ToolStripItem)MenuItemAbout).add_Click((EventHandler)MenuItemAbout_Click);
			toolStripMain.set_ImageScalingSize(new Size(20, 20));
			toolStripMain.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[24]
			{
				(ToolStripItem)toolStripButtonNew,
				(ToolStripItem)toolStripButtonOpen,
				(ToolStripItem)toolStripButtonSave,
				(ToolStripItem)toolStripSeparator4,
				(ToolStripItem)toolStripButtonBrowser,
				(ToolStripItem)toolStripButtonScanner,
				(ToolStripItem)toolStripSeparator10,
				(ToolStripItem)toolStripButtonSQL,
				(ToolStripItem)toolStripSeparator20,
				(ToolStripItem)toolStripButtonXSS,
				(ToolStripItem)toolStripSeparator11,
				(ToolStripItem)ButtonResend,
				(ToolStripItem)ButtonBruter,
				(ToolStripItem)ButtonCookie,
				(ToolStripItem)toolStripSeparator17,
				(ToolStripItem)ButtonSetting,
				(ToolStripItem)toolStripSeparator13,
				(ToolStripItem)lblBlank,
				(ToolStripItem)toolStripSeparator18,
				(ToolStripItem)ButtonScanSite,
				(ToolStripItem)toolStripSeparator14,
				(ToolStripItem)ButtonScanPage,
				(ToolStripItem)toolStripSeparator15,
				(ToolStripItem)ButtonScanURL
			});
			((Control)toolStripMain).set_Location(new Point(0, 25));
			((Control)toolStripMain).set_Name("toolStripMain");
			((Control)toolStripMain).set_Size(new Size(984, 27));
			((Control)toolStripMain).set_TabIndex(1);
			((Control)toolStripMain).set_Text("toolStrip1");
			((ToolStripItem)toolStripButtonNew).set_DisplayStyle((ToolStripItemDisplayStyle)2);
			((ToolStripItem)toolStripButtonNew).set_Image((Image)((ResourceManager)(object)val16).GetObject("toolStripButtonNew.Image"));
			((ToolStripItem)toolStripButtonNew).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripButtonNew).set_Name("toolStripButtonNew");
			((ToolStripItem)toolStripButtonNew).set_Size(new Size(24, 24));
			((ToolStripItem)toolStripButtonNew).set_Text("toolStripButton1");
			((ToolStripItem)toolStripButtonNew).set_ToolTipText("New Scan");
			((ToolStripItem)toolStripButtonNew).add_Click((EventHandler)toolStripButtonNew_Click);
			((ToolStripItem)toolStripButtonOpen).set_DisplayStyle((ToolStripItemDisplayStyle)2);
			((ToolStripItem)toolStripButtonOpen).set_Image((Image)((ResourceManager)(object)val16).GetObject("toolStripButtonOpen.Image"));
			((ToolStripItem)toolStripButtonOpen).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripButtonOpen).set_Name("toolStripButtonOpen");
			((ToolStripItem)toolStripButtonOpen).set_Size(new Size(24, 24));
			((ToolStripItem)toolStripButtonOpen).set_Text("toolStripButton2");
			((ToolStripItem)toolStripButtonOpen).set_ToolTipText("Open Vulnerabilities Data File.");
			((ToolStripItem)toolStripButtonOpen).add_Click((EventHandler)toolStripButtonOpen_Click);
			((ToolStripItem)toolStripButtonSave).set_DisplayStyle((ToolStripItemDisplayStyle)2);
			((ToolStripItem)toolStripButtonSave).set_Image((Image)((ResourceManager)(object)val16).GetObject("toolStripButtonSave.Image"));
			((ToolStripItem)toolStripButtonSave).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripButtonSave).set_Name("toolStripButtonSave");
			((ToolStripItem)toolStripButtonSave).set_Size(new Size(24, 24));
			((ToolStripItem)toolStripButtonSave).set_Text("toolStripButton3");
			((ToolStripItem)toolStripButtonSave).set_ToolTipText("Save Current Vulnerabilities.");
			((ToolStripItem)toolStripButtonSave).add_Click((EventHandler)toolStripButtonSave_Click);
			((ToolStripItem)toolStripSeparator4).set_Name("toolStripSeparator4");
			((ToolStripItem)toolStripSeparator4).set_Size(new Size(6, 27));
			((ToolStripItem)toolStripButtonBrowser).set_Image((Image)(object)Resources.ie);
			((ToolStripItem)toolStripButtonBrowser).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripButtonBrowser).set_Name("toolStripButtonBrowser");
			((ToolStripItem)toolStripButtonBrowser).set_Size(new Size(80, 24));
			((ToolStripItem)toolStripButtonBrowser).set_Text("Browser");
			((ToolStripItem)toolStripButtonBrowser).set_ToolTipText("Web Browser");
			((ToolStripItem)toolStripButtonBrowser).add_Click((EventHandler)toolStripButtonBrowser_Click);
			((ToolStripItem)toolStripButtonScanner).set_Image((Image)(object)Resources.scan);
			((ToolStripItem)toolStripButtonScanner).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripButtonScanner).set_Name("toolStripButtonScanner");
			((ToolStripItem)toolStripButtonScanner).set_Size(new Size(78, 24));
			((ToolStripItem)toolStripButtonScanner).set_Text("Scanner");
			((ToolStripItem)toolStripButtonScanner).set_ToolTipText("Vulnerability Scanner");
			((ToolStripItem)toolStripButtonScanner).add_Click((EventHandler)toolStripButtonScanner_Click);
			((ToolStripItem)toolStripSeparator10).set_Name("toolStripSeparator10");
			((ToolStripItem)toolStripSeparator10).set_Size(new Size(6, 27));
			((ToolStripItem)toolStripButtonSQL).set_Image((Image)(object)Resources.db);
			((ToolStripItem)toolStripButtonSQL).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripButtonSQL).set_Name("toolStripButtonSQL");
			((ToolStripItem)toolStripButtonSQL).set_Size(new Size(55, 24));
			((ToolStripItem)toolStripButtonSQL).set_Text("SQL");
			((ToolStripItem)toolStripButtonSQL).set_ToolTipText("SQL Injection POC Tool");
			((ToolStripItem)toolStripButtonSQL).add_Click((EventHandler)toolStripButtonSQL_Click);
			((ToolStripItem)toolStripSeparator20).set_Name("toolStripSeparator20");
			((ToolStripItem)toolStripSeparator20).set_Size(new Size(6, 27));
			((ToolStripItem)toolStripButtonXSS).set_Image((Image)(object)Resources.xss);
			((ToolStripItem)toolStripButtonXSS).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripButtonXSS).set_Name("toolStripButtonXSS");
			((ToolStripItem)toolStripButtonXSS).set_Size(new Size(57, 24));
			((ToolStripItem)toolStripButtonXSS).set_Text("POC");
			((ToolStripItem)toolStripButtonXSS).set_ToolTipText("POC Tool for XSS (Cross Site Scripting) / LFI (Local File Inclusion) / RFI (Remote File Inclusion) / Redirect ");
			((ToolStripItem)toolStripButtonXSS).add_Click((EventHandler)toolStripButtonXSS_Click);
			((ToolStripItem)toolStripSeparator11).set_Name("toolStripSeparator11");
			((ToolStripItem)toolStripSeparator11).set_Size(new Size(6, 27));
			((ToolStripItem)ButtonResend).set_Image((Image)(object)Resources.resend);
			((ToolStripItem)ButtonResend).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonResend).set_Name("ButtonResend");
			((ToolStripItem)ButtonResend).set_Size(new Size(75, 24));
			((ToolStripItem)ButtonResend).set_Text("Resend");
			((ToolStripItem)ButtonResend).set_ToolTipText("Resend Tool");
			((ToolStripItem)ButtonResend).add_Click((EventHandler)ButtonResend_Click);
			((ToolStripItem)ButtonBruter).set_Image((Image)(object)Resources.bruter);
			((ToolStripItem)ButtonBruter).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonBruter).set_Name("ButtonBruter");
			((ToolStripItem)ButtonBruter).set_Size(new Size(68, 24));
			((ToolStripItem)ButtonBruter).set_Text("Bruter");
			((ToolStripItem)ButtonBruter).set_ToolTipText("Brute force tool. Launch it from Resend tool is preferred.");
			((ToolStripItem)ButtonBruter).add_Click((EventHandler)ButtonBruter_Click);
			((ToolStripItem)ButtonCookie).set_Image((Image)((ResourceManager)(object)val16).GetObject("ButtonCookie.Image"));
			((ToolStripItem)ButtonCookie).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonCookie).set_Name("ButtonCookie");
			((ToolStripItem)ButtonCookie).set_Size(new Size(73, 24));
			((ToolStripItem)ButtonCookie).set_Text("Cookie");
			((ToolStripItem)ButtonCookie).add_Click((EventHandler)ButtonCookie_Click);
			((ToolStripItem)toolStripSeparator17).set_Name("toolStripSeparator17");
			((ToolStripItem)toolStripSeparator17).set_Size(new Size(6, 27));
			((ToolStripItem)ButtonSetting).set_Image((Image)(object)Resources.tool);
			((ToolStripItem)ButtonSetting).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonSetting).set_Name("ButtonSetting");
			((ToolStripItem)ButtonSetting).set_Size(new Size(72, 24));
			((ToolStripItem)ButtonSetting).set_Text("Setting");
			((ToolStripItem)ButtonSetting).add_Click((EventHandler)toolStripButtonSetting_Click);
			((ToolStripItem)toolStripSeparator13).set_Name("toolStripSeparator13");
			((ToolStripItem)toolStripSeparator13).set_Size(new Size(6, 27));
			((ToolStripItem)lblBlank).set_AutoSize(false);
			((ToolStripItem)lblBlank).set_Name("lblBlank");
			((ToolStripItem)lblBlank).set_Size(new Size(28, 22));
			((ToolStripItem)lblBlank).set_Text("     ");
			((ToolStripItem)toolStripSeparator18).set_Alignment((ToolStripItemAlignment)1);
			((ToolStripItem)toolStripSeparator18).set_Name("toolStripSeparator18");
			((ToolStripItem)toolStripSeparator18).set_Size(new Size(6, 27));
			((ToolStripItem)ButtonScanSite).set_Alignment((ToolStripItemAlignment)1);
			((ToolStripItem)ButtonScanSite).set_Image((Image)(object)Resources.scan);
			((ToolStripItem)ButtonScanSite).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonScanSite).set_Name("ButtonScanSite");
			((ToolStripItem)ButtonScanSite).set_Size(new Size(80, 24));
			((ToolStripItem)ButtonScanSite).set_Text("ScanSite");
			((ToolStripItem)ButtonScanSite).set_ToolTipText("Scan current site");
			((ToolStripItem)ButtonScanSite).add_Click((EventHandler)ButtonScanSite_Click);
			((ToolStripItem)toolStripSeparator14).set_Alignment((ToolStripItemAlignment)1);
			((ToolStripItem)toolStripSeparator14).set_Name("toolStripSeparator14");
			((ToolStripItem)toolStripSeparator14).set_Size(new Size(6, 27));
			((ToolStripItem)ButtonScanPage).set_Alignment((ToolStripItemAlignment)1);
			((ToolStripItem)ButtonScanPage).set_Image((Image)(object)Resources.scan);
			((ToolStripItem)ButtonScanPage).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonScanPage).set_Name("ButtonScanPage");
			((ToolStripItem)ButtonScanPage).set_RightToLeft((RightToLeft)0);
			((ToolStripItem)ButtonScanPage).set_Size(new Size(88, 24));
			((ToolStripItem)ButtonScanPage).set_Text("ScanPage");
			((ToolStripItem)ButtonScanPage).set_ToolTipText("Scan current url and sub directory links in current page, all links under parent or other directories will be skipped.");
			((ToolStripItem)ButtonScanPage).add_Click((EventHandler)ButtonScanPage_Click);
			((ToolStripItem)toolStripSeparator15).set_Alignment((ToolStripItemAlignment)1);
			((ToolStripItem)toolStripSeparator15).set_Name("toolStripSeparator15");
			((ToolStripItem)toolStripSeparator15).set_Size(new Size(6, 27));
			((ToolStripItem)ButtonScanURL).set_Alignment((ToolStripItemAlignment)1);
			((ToolStripItem)ButtonScanURL).set_Image((Image)(object)Resources.scan);
			((ToolStripItem)ButtonScanURL).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonScanURL).set_Name("ButtonScanURL");
			((ToolStripItem)ButtonScanURL).set_Size(new Size(82, 24));
			((ToolStripItem)ButtonScanURL).set_Text("ScanURL");
			((ToolStripItem)ButtonScanURL).set_ToolTipText("Scan current url.");
			((ToolStripItem)ButtonScanURL).add_Click((EventHandler)ButtonScanURL_Click);
			((ToolStrip)statusStripMain).set_ImageScalingSize(new Size(20, 20));
			((ToolStrip)statusStripMain).get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[3]
			{
				(ToolStripItem)toolStripStatusProgress,
				(ToolStripItem)toolStripStatusSep1,
				(ToolStripItem)lblThreadNum
			});
			((Control)statusStripMain).set_Location(new Point(0, 568));
			((Control)statusStripMain).set_Name("statusStripMain");
			((Control)statusStripMain).set_Size(new Size(984, 25));
			((Control)statusStripMain).set_TabIndex(2);
			((Control)statusStripMain).set_Text("statusStrip1");
			((ToolStripItem)toolStripStatusProgress).set_AutoSize(false);
			((ToolStripItem)toolStripStatusProgress).set_Name("toolStripStatusProgress");
			((ToolStripItem)toolStripStatusProgress).set_Size(new Size(740, 20));
			((ToolStripItem)toolStripStatusProgress).set_Text("Done");
			((ToolStripItem)toolStripStatusProgress).set_TextAlign((ContentAlignment)16);
			((ToolStripItem)toolStripStatusSep1).set_ForeColor(SystemColors.get_ControlDark());
			((ToolStripItem)toolStripStatusSep1).set_Name("toolStripStatusSep1");
			((ToolStripItem)toolStripStatusSep1).set_Size(new Size(11, 20));
			((ToolStripItem)toolStripStatusSep1).set_Text("|");
			((ToolStripItem)lblThreadNum).set_AutoSize(false);
			((ToolStripItem)lblThreadNum).set_Name("lblThreadNum");
			((ToolStripItem)lblThreadNum).set_Size(new Size(125, 20));
			((ToolStripItem)lblThreadNum).set_TextAlign((ContentAlignment)16);
			toolStripURL.set_ImageScalingSize(new Size(20, 20));
			toolStripURL.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[8]
			{
				(ToolStripItem)toolStripLabel1,
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)txtURL,
				(ToolStripItem)toolStripSeparator3,
				(ToolStripItem)cmbReqType,
				(ToolStripItem)toolStripBtnGo,
				(ToolStripItem)toolStripBtnPause,
				(ToolStripItem)toolStripBtnStop
			});
			((Control)toolStripURL).set_Location(new Point(0, 52));
			((Control)toolStripURL).set_Margin(new Padding(0, 0, 0, 1));
			((Control)toolStripURL).set_Name("toolStripURL");
			((Control)toolStripURL).set_Padding(new Padding(0, 0, 1, 1));
			((Control)toolStripURL).set_Size(new Size(984, 28));
			((Control)toolStripURL).set_TabIndex(3);
			((Control)toolStripURL).set_Text("toolStrip1");
			((ToolStripItem)toolStripLabel1).set_Name("toolStripLabel1");
			((ToolStripItem)toolStripLabel1).set_Size(new Size(34, 24));
			((ToolStripItem)toolStripLabel1).set_Text("URL:");
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 27));
			((ToolStripItem)txtURL).set_AutoSize(false);
			((ToolStripItem)txtURL).set_BackColor(SystemColors.get_Window());
			((ToolStripItem)txtURL).set_Name("txtURL");
			((ToolStripItem)txtURL).set_Overflow((ToolStripItemOverflow)0);
			((ToolStripItem)txtURL).set_Size(new Size(725, 23));
			((ToolStripControlHost)txtURL).add_KeyPress(new KeyPressEventHandler(txtURL_KeyPress));
			((ToolStripItem)txtURL).add_DoubleClick((EventHandler)txtURL_DoubleClick);
			((ToolStripItem)toolStripSeparator3).set_Name("toolStripSeparator3");
			((ToolStripItem)toolStripSeparator3).set_Size(new Size(6, 27));
			cmbReqType.set_DropDownStyle((ComboBoxStyle)2);
			cmbReqType.get_Items().AddRange(new object[3]
			{
				"GET",
				"POST",
				"COOKIE"
			});
			((ToolStripItem)cmbReqType).set_Name("cmbReqType");
			((ToolStripItem)cmbReqType).set_Size(new Size(75, 27));
			((ToolStripItem)cmbReqType).set_ToolTipText("Request Type");
			cmbReqType.add_DropDownClosed((EventHandler)cmbReqType_DropDownClosed);
			((ToolStripItem)toolStripBtnGo).set_DisplayStyle((ToolStripItemDisplayStyle)2);
			((ToolStripItem)toolStripBtnGo).set_Image((Image)((ResourceManager)(object)val16).GetObject("toolStripBtnGo.Image"));
			((ToolStripItem)toolStripBtnGo).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripBtnGo).set_Name("toolStripBtnGo");
			((ToolStripItem)toolStripBtnGo).set_Size(new Size(24, 24));
			((ToolStripItem)toolStripBtnGo).set_Text("toolStripButton1");
			((ToolStripItem)toolStripBtnGo).set_ToolTipText("Browser");
			((ToolStripItem)toolStripBtnGo).add_Click((EventHandler)toolStripBtnGo_Click);
			((ToolStripItem)toolStripBtnPause).set_DisplayStyle((ToolStripItemDisplayStyle)2);
			((ToolStripItem)toolStripBtnPause).set_Image((Image)((ResourceManager)(object)val16).GetObject("toolStripBtnPause.Image"));
			((ToolStripItem)toolStripBtnPause).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripBtnPause).set_Name("toolStripBtnPause");
			((ToolStripItem)toolStripBtnPause).set_Size(new Size(24, 24));
			((ToolStripItem)toolStripBtnPause).set_Text("toolStripButton1");
			((ToolStripItem)toolStripBtnPause).set_ToolTipText("Pause");
			((ToolStripItem)toolStripBtnPause).add_Click((EventHandler)toolStripBtnPause_Click);
			((ToolStripItem)toolStripBtnStop).set_DisplayStyle((ToolStripItemDisplayStyle)2);
			((ToolStripItem)toolStripBtnStop).set_Image((Image)((ResourceManager)(object)val16).GetObject("toolStripBtnStop.Image"));
			((ToolStripItem)toolStripBtnStop).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)toolStripBtnStop).set_Name("toolStripBtnStop");
			((ToolStripItem)toolStripBtnStop).set_Size(new Size(24, 24));
			((ToolStripItem)toolStripBtnStop).set_Text("toolStripButton1");
			((ToolStripItem)toolStripBtnStop).set_ToolTipText("Stop");
			((ToolStripItem)toolStripBtnStop).add_Click((EventHandler)toolStripBtnStop_Click);
			toolStripData.set_ImageScalingSize(new Size(20, 20));
			toolStripData.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[7]
			{
				(ToolStripItem)lblSubmitData,
				(ToolStripItem)toolStripSeparator2,
				(ToolStripItem)txtSubmitData,
				(ToolStripItem)toolStripSeparator16,
				(ToolStripItem)cmbEnctype,
				(ToolStripItem)toolStripSeparator21,
				(ToolStripItem)ButtonAutoFill
			});
			((Control)toolStripData).set_Location(new Point(0, 76));
			((Control)toolStripData).set_Name("toolStripData");
			((Control)toolStripData).set_Size(new Size(944, 25));
			((Control)toolStripData).set_TabIndex(6);
			((Control)toolStripData).set_Visible(false);
			((ToolStripItem)lblSubmitData).set_Name("lblSubmitData");
			((ToolStripItem)lblSubmitData).set_Size(new Size(35, 22));
			((ToolStripItem)lblSubmitData).set_Text("Data");
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			((ToolStripItem)txtSubmitData).set_AutoSize(false);
			((ToolStripItem)txtSubmitData).set_Font(new Font("SimSun", 9f, (FontStyle)0, (GraphicsUnit)3, (byte)134));
			((ToolStripItem)txtSubmitData).set_Name("txtSubmitData");
			((ToolStripItem)txtSubmitData).set_Overflow((ToolStripItemOverflow)0);
			((ToolStripItem)txtSubmitData).set_Size(new Size(550, 21));
			((ToolStripItem)txtSubmitData).set_ToolTipText("Format: username=admin&password=123456");
			((ToolStripControlHost)txtSubmitData).add_KeyPress(new KeyPressEventHandler(txtSubmitData_KeyPress));
			((ToolStripItem)txtSubmitData).add_DoubleClick((EventHandler)txtSubmitData_DoubleClick);
			((ToolStripItem)toolStripSeparator16).set_Name("toolStripSeparator16");
			((ToolStripItem)toolStripSeparator16).set_Size(new Size(6, 25));
			cmbEnctype.set_DropDownStyle((ComboBoxStyle)2);
			cmbEnctype.get_Items().AddRange(new object[3]
			{
				"application/x-www-form-urlencoded",
				"multipart/form-data",
				"text/plain"
			});
			((ToolStripItem)cmbEnctype).set_Name("cmbEnctype");
			((ToolStripItem)cmbEnctype).set_Size(new Size(220, 25));
			((ToolStripItem)cmbEnctype).set_ToolTipText("Content-Type or form enctype");
			((ToolStripItem)toolStripSeparator21).set_Name("toolStripSeparator21");
			((ToolStripItem)toolStripSeparator21).set_Size(new Size(6, 25));
			((ToolStripItem)ButtonAutoFill).set_DisplayStyle((ToolStripItemDisplayStyle)2);
			((ToolStripItem)ButtonAutoFill).set_Image((Image)(object)Resources.fill);
			((ToolStripItem)ButtonAutoFill).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonAutoFill).set_Name("ButtonAutoFill");
			((ToolStripItem)ButtonAutoFill).set_Size(new Size(24, 22));
			((ToolStripItem)ButtonAutoFill).set_Text("Fill in Form");
			((ToolStripItem)ButtonAutoFill).add_Click((EventHandler)ButtonAutoFill_Click);
			splitUpDown.set_Dock((DockStyle)5);
			((Control)splitUpDown).set_Location(new Point(0, 80));
			((Control)splitUpDown).set_Name("splitUpDown");
			splitUpDown.set_Orientation((Orientation)0);
			((Control)splitUpDown.get_Panel1()).get_Controls().Add((Control)(object)splitMain);
			((Control)splitUpDown.get_Panel2()).get_Controls().Add((Control)(object)lvRecentLog);
			((Control)splitUpDown).set_Size(new Size(984, 488));
			splitUpDown.set_SplitterDistance(375);
			((Control)splitUpDown).set_TabIndex(9);
			((ListView)lvRecentLog).get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[1]
			{
				columnProgress
			});
			((Control)lvRecentLog).set_Dock((DockStyle)5);
			((ListView)lvRecentLog).set_FullRowSelect(true);
			((ListView)lvRecentLog).set_HeaderStyle((ColumnHeaderStyle)0);
			((Control)lvRecentLog).set_Location(new Point(0, 0));
			((ListView)lvRecentLog).set_MultiSelect(false);
			((Control)lvRecentLog).set_Name("lvRecentLog");
			((Control)lvRecentLog).set_Size(new Size(984, 109));
			((Control)lvRecentLog).set_TabIndex(8);
			((ListView)lvRecentLog).set_UseCompatibleStateImageBehavior(false);
			((ListView)lvRecentLog).set_View((View)1);
			((Control)lvRecentLog).add_MouseClick(new MouseEventHandler(lvRecentLog_MouseClick));
			columnProgress.set_Text("Progress");
			columnProgress.set_Width(940);
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(984, 593));
			((Control)this).get_Controls().Add((Control)(object)splitUpDown);
			((Control)this).get_Controls().Add((Control)(object)toolStripData);
			((Control)this).get_Controls().Add((Control)(object)toolStripURL);
			((Control)this).get_Controls().Add((Control)(object)statusStripMain);
			((Control)this).get_Controls().Add((Control)(object)toolStripMain);
			((Control)this).get_Controls().Add((Control)(object)menuStripMain);
			((Form)this).set_Icon((Icon)((ResourceManager)(object)val16).GetObject("$this.Icon"));
			((Form)this).set_IsMdiContainer(true);
			((Form)this).set_MainMenuStrip(menuStripMain);
			((Control)this).set_MinimumSize(new Size(960, 589));
			((Control)this).set_Name("FormMain");
			((Form)this).set_StartPosition((FormStartPosition)1);
			((Control)this).set_Text("WebCruiser - Web Vulnerability Scanner");
			((Form)this).add_FormClosing(new FormClosingEventHandler(FormMain_FormClosing));
			((Control)this).add_Resize((EventHandler)FormMain_Resize);
			((Control)splitMain.get_Panel1()).ResumeLayout(false);
			((Control)splitMain).ResumeLayout(false);
			((Control)menuStripMain).ResumeLayout(false);
			((Control)menuStripMain).PerformLayout();
			((Control)toolStripMain).ResumeLayout(false);
			((Control)toolStripMain).PerformLayout();
			((Control)statusStripMain).ResumeLayout(false);
			((Control)statusStripMain).PerformLayout();
			((Control)toolStripURL).ResumeLayout(false);
			((Control)toolStripURL).PerformLayout();
			((Control)toolStripData).ResumeLayout(false);
			((Control)toolStripData).PerformLayout();
			((Control)splitUpDown.get_Panel1()).ResumeLayout(false);
			((Control)splitUpDown.get_Panel2()).ResumeLayout(false);
			((Control)splitUpDown).ResumeLayout(false);
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
