using System;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	public class FormBruter : Form
	{
		private delegate void dd(string s);

		private FormMain mainfrm;

		private string referUrl = "";

		private string actionUrl = "";

		private string noParaUrlForGET;

		private string paraData0 = "";

		private RequestType reqType;

		private string source0 = "";

		private bool isFoundOnce;

		private string enctype;

		private IContainer components;

		private GroupBox groupBox1;

		private RadioButton radioBtnCombo;

		private RadioButton radioBtnDict2;

		private TextBox txtURL;

		private TextBox txtPostData;

		private Button btnGo;

		private ListView listViewPWD;

		private ColumnHeader colUsername;

		private ColumnHeader colPassword;

		private Label label3;

		private Label label2;

		private TextBox txtPassFile;

		private TextBox txtUserFile;

		private Label label4;

		private TextBox txtComboFile;

		private Button btnSelectUserFile;

		private Button btnSelectComboFile;

		private Button btnSelectPassFile;

		private ComboBox cmbUsername;

		private ComboBox cmbPassword;

		private Label label1;

		private Label label5;

		private Label label6;

		private Button btnResetField;

		private ToolTip toolTipForBruter;

		private ComboBox cmbMethod;

		private CheckBox chkOnceStop;

		private ComboBox cmbCSRF;

		private Label label7;

		private Label label8;

		private Button btnSwithToResend;

		public FormBruter(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
		}

		private string GetParaDataByUrl(string sUrl)
		{
			int num = sUrl.IndexOf('?');
			if (num > 0)
			{
				return sUrl.Substring(num + 1);
			}
			return "";
		}

		private string GetNoParaUrl(string sUrl)
		{
			int num = sUrl.IndexOf('?');
			if (num > 0)
			{
				return sUrl.Substring(0, num);
			}
			return sUrl;
		}

		private string GetReferUrlByHeaders(string headers)
		{
			return ((Capture)Regex.Match(headers, "(?<=^Referer:\\s)[\\S]+", (RegexOptions)1)).get_Value();
		}

		public void InitByRequestInfo(RequestType rt, string sUrl, string headers, string postData)
		{
			actionUrl = sUrl;
			reqType = rt;
			if (rt == RequestType.GET)
			{
				paraData0 = GetParaDataByUrl(sUrl);
				noParaUrlForGET = GetNoParaUrl(sUrl);
				((Control)txtPostData).set_Text("");
				((TextBoxBase)txtPostData).set_ReadOnly(true);
			}
			else
			{
				if (postData.IndexOf("Content-Disposition: form-data; name=") >= 0)
				{
					postData = WebSite.ConvertToFormUrlencoded(postData);
					enctype = "multipart/form-data";
				}
				else
				{
					enctype = "";
				}
				paraData0 = postData;
				((Control)txtPostData).set_Text(postData);
				((TextBoxBase)txtPostData).set_ReadOnly(false);
			}
			referUrl = GetReferUrlByHeaders(headers);
			((Control)txtURL).set_Text(actionUrl);
			InitSelectableFields(paraData0);
		}

		private void InitSelectableFields(string paraData)
		{
			try
			{
				if (string.IsNullOrEmpty(paraData))
				{
					return;
				}
				if (reqType == RequestType.GET)
				{
					cmbMethod.set_SelectedItem((object)"GET");
				}
				else
				{
					cmbMethod.set_SelectedItem((object)"POST");
				}
				string[] array = paraData.Split(new char[1]
				{
					'&'
				});
				cmbUsername.get_Items().Clear();
				cmbPassword.get_Items().Clear();
				cmbCSRF.get_Items().Clear();
				((Control)cmbUsername).set_Text("");
				((Control)cmbPassword).set_Text("");
				((Control)cmbCSRF).set_Text("");
				cmbCSRF.get_Items().Add((object)"");
				string[] array2 = array;
				foreach (string text in array2)
				{
					string text2 = text.Substring(0, text.IndexOf('='));
					cmbUsername.get_Items().Add((object)text2);
					cmbPassword.get_Items().Add((object)text2);
					cmbCSRF.get_Items().Add((object)text2);
					if (Regex.IsMatch(text2, "username", (RegexOptions)1))
					{
						cmbUsername.set_SelectedItem((object)text2);
					}
					else if (Regex.IsMatch(text2, "password|passwd", (RegexOptions)1))
					{
						cmbPassword.set_SelectedItem((object)text2);
					}
					else if (Regex.IsMatch(text2, WCRSetting.CSRFKeywords, (RegexOptions)1))
					{
						cmbCSRF.set_SelectedItem((object)text2);
					}
				}
				actionUrl = ((Control)txtURL).get_Text();
			}
			catch (Exception)
			{
			}
		}

		private void btnSelectUserFile_Click(object sender, EventArgs e)
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_001d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_0030: Unknown result type (might be due to invalid IL or missing references)
			//IL_0032: Invalid comparison between Unknown and I4
			OpenFileDialog val = new OpenFileDialog();
			((FileDialog)val).set_Filter("Text File(*.txt)|*.txt");
			((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
			DialogResult val2 = ((CommonDialog)val).ShowDialog();
			string fileName = ((FileDialog)val).get_FileName();
			((Component)val).Dispose();
			if ((int)val2 == 1)
			{
				((Control)txtUserFile).set_Text(fileName);
			}
		}

		private void btnSelectPassFile_Click(object sender, EventArgs e)
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_001d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_0030: Unknown result type (might be due to invalid IL or missing references)
			//IL_0032: Invalid comparison between Unknown and I4
			OpenFileDialog val = new OpenFileDialog();
			((FileDialog)val).set_Filter("Text File(*.txt)|*.txt");
			((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
			DialogResult val2 = ((CommonDialog)val).ShowDialog();
			string fileName = ((FileDialog)val).get_FileName();
			((Component)val).Dispose();
			if ((int)val2 == 1)
			{
				((Control)txtPassFile).set_Text(fileName);
			}
		}

		private void btnSelectComboFile_Click(object sender, EventArgs e)
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_001d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_0030: Unknown result type (might be due to invalid IL or missing references)
			//IL_0032: Invalid comparison between Unknown and I4
			OpenFileDialog val = new OpenFileDialog();
			((FileDialog)val).set_Filter("Text File(*.txt)|*.txt");
			((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
			DialogResult val2 = ((CommonDialog)val).ShowDialog();
			string fileName = ((FileDialog)val).get_FileName();
			((Component)val).Dispose();
			if ((int)val2 == 1)
			{
				((Control)txtComboFile).set_Text(fileName);
			}
		}

		private string FormatParameterString(string paraUsername, string paraPassword)
		{
			string text = paraUsername + "={USERNAME}&" + paraPassword + "={PASSWORD}";
			string[] array = paraData0.Split(new char[1]
			{
				'&'
			});
			string[] array2 = array;
			foreach (string text2 in array2)
			{
				string text3 = text2.Substring(0, text2.IndexOf('='));
				if (!text3.Equals(paraUsername) && !text3.Equals(paraPassword))
				{
					text = text + "&" + text2;
				}
			}
			return text;
		}

		private void AddItem2ListViewPWD(string Text)
		{
			if (!((Control)listViewPWD).get_InvokeRequired())
			{
				string[] separator = new string[1]
				{
					"^^"
				};
				string[] array = Text.Split(separator, StringSplitOptions.None);
				ListViewItem val = listViewPWD.get_Items().Add(array[0]);
				val.set_ImageKey("vul.png");
				val.get_SubItems().Add(array[1]);
				((Control)listViewPWD).Refresh();
			}
			else
			{
				dd dd = AddItem2ListViewPWD;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					Text
				});
			}
		}

		private string DoCheckUserAndPasswd(string formattedPara, string user, string passwd, string csrfFieldName, WebForm webForm)
		{
			if (passwd.Contains("%username%"))
			{
				passwd = passwd.Replace("%username%", user);
			}
			string str = formattedPara.Replace("{USERNAME}", user).Replace("{PASSWORD}", passwd);
			string sUrl = ((reqType != 0) ? (actionUrl + "^" + str) : (noParaUrlForGET + "?" + str));
			mainfrm.DisplayLogList("Checking: " + user + " : " + passwd);
			string sourceCodeWithCsrfField = mainfrm.CurrentSite.GetSourceCodeWithCsrfField(sUrl, reqType, csrfFieldName, webForm);
			if (string.IsNullOrEmpty(sourceCodeWithCsrfField))
			{
				mainfrm.DisplayLogList("Got null response, retry  " + user + " : " + passwd);
				sourceCodeWithCsrfField = mainfrm.CurrentSite.GetSourceCodeWithCsrfField(sUrl, reqType, csrfFieldName, webForm);
			}
			if (string.IsNullOrEmpty(sourceCodeWithCsrfField))
			{
				mainfrm.DisplayLogList("Got null response the second time, skipped.");
				return "";
			}
			string keyWordBySource = WebSite.GetKeyWordBySource(source0, sourceCodeWithCsrfField);
			if (!string.IsNullOrEmpty(keyWordBySource))
			{
				mainfrm.DisplayLogList("Found: " + user + " : " + passwd);
				return user + "^^" + passwd;
			}
			return "";
		}

		private void btnGo_Click(object sender, EventArgs e)
		{
			//IL_0064: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				isFoundOnce = false;
				actionUrl = ((Control)txtURL).get_Text();
				if (reqType == RequestType.GET)
				{
					InitByRequestInfo(reqType, actionUrl, "", "");
				}
				if (((ListControl)cmbUsername).get_SelectedIndex() < 0 || ((ListControl)cmbPassword).get_SelectedIndex() < 0)
				{
					MessageBox.Show("Please select both username and password fields at first!");
					return;
				}
				string formattedPara = FormatParameterString(((Control)cmbUsername).get_Text(), ((Control)cmbPassword).get_Text());
				string text = ((reqType != 0) ? (actionUrl + "^" + paraData0) : actionUrl);
				string csrfFieldName = ((Control)cmbCSRF).get_Text();
				WebForm webForm = new WebForm(text, referUrl, enctype);
				source0 = mainfrm.CurrentSite.GetSourceCodeWithCsrfField(text, reqType, csrfFieldName, webForm);
				bool stopWhenFoundOnce = chkOnceStop.get_Checked();
				if (radioBtnDict2.get_Checked())
				{
					string[] users = File.ReadAllLines(((Control)txtUserFile).get_Text());
					string[] passwds = File.ReadAllLines(((Control)txtPassFile).get_Text());
					Thread thread = new Thread((ThreadStart)delegate
					{
						string[] array3 = users;
						foreach (string text4 in array3)
						{
							if (!string.IsNullOrEmpty(text4))
							{
								string[] array4 = passwds;
								foreach (string passwd2 in array4)
								{
									if (isFoundOnce)
									{
										return;
									}
									string text5 = DoCheckUserAndPasswd(formattedPara, text4, passwd2, csrfFieldName, webForm);
									if (!string.IsNullOrEmpty(text5))
									{
										AddItem2ListViewPWD(text5);
										if (stopWhenFoundOnce)
										{
											isFoundOnce = true;
											mainfrm.DisplayProgress("Done");
											return;
										}
									}
								}
							}
						}
					});
					thread.Start();
				}
				else if (radioBtnCombo.get_Checked())
				{
					string[] userPasswds = File.ReadAllLines(((Control)txtComboFile).get_Text());
					Thread thread2 = new Thread((ThreadStart)delegate
					{
						string[] array = userPasswds;
						foreach (string text2 in array)
						{
							if (isFoundOnce)
							{
								break;
							}
							string[] array2 = text2.Split(new char[1]
							{
								':'
							});
							string user = array2[0];
							string passwd = "";
							if (array2.Length > 1)
							{
								passwd = array2[1];
							}
							string text3 = DoCheckUserAndPasswd(formattedPara, user, passwd, csrfFieldName, webForm);
							if (!string.IsNullOrEmpty(text3))
							{
								AddItem2ListViewPWD(text3);
								if (stopWhenFoundOnce)
								{
									isFoundOnce = true;
									mainfrm.DisplayProgress("Done");
									break;
								}
							}
						}
					});
					thread2.Start();
				}
				mainfrm.DisplayProgress("Done");
			}
			catch (Exception)
			{
			}
		}

		private void cmbUsernameOrPassword_DropDown(object sender, EventArgs e)
		{
			if ((sender as ComboBox).get_Items().get_Count() < 1)
			{
				if (reqType == RequestType.GET)
				{
					paraData0 = GetParaDataByUrl(((Control)txtURL).get_Text());
				}
				else
				{
					paraData0 = ((Control)txtPostData).get_Text();
				}
				InitSelectableFields(paraData0);
			}
		}

		private void btnResetField_Click(object sender, EventArgs e)
		{
			if (reqType == RequestType.GET)
			{
				paraData0 = GetParaDataByUrl(((Control)txtURL).get_Text());
			}
			else
			{
				paraData0 = ((Control)txtPostData).get_Text();
			}
			InitSelectableFields(paraData0);
		}

		private void cmbMethod_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (((ListControl)cmbMethod).get_SelectedIndex() == 0)
			{
				reqType = RequestType.GET;
				((TextBoxBase)txtPostData).set_ReadOnly(true);
				((Control)txtPostData).set_Visible(false);
			}
			else if (((ListControl)cmbMethod).get_SelectedIndex() == 1)
			{
				reqType = RequestType.POST;
				((TextBoxBase)txtPostData).set_ReadOnly(false);
				((Control)txtPostData).set_Visible(true);
			}
		}

		private void listViewPWD_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_0015: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			try
			{
				if (listViewPWD.get_SelectedItems().get_Count() >= 1)
				{
					ContextMenuStrip val = new ContextMenuStrip();
					((ToolStrip)val).get_Items().Add("Copy", (Image)null, (EventHandler)PasswdItemRightClick);
					((ToolStrip)val).get_Items().Add("Delete", (Image)null, (EventHandler)PasswdItemRightClick);
					((ToolStrip)val).get_Items().Add("Clear", (Image)null, (EventHandler)PasswdItemRightClick);
					((Control)listViewPWD).set_ContextMenuStrip(val);
				}
			}
			catch (Exception)
			{
			}
		}

		private void PasswdItemRightClick(object sender, EventArgs e)
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				switch (((ToolStripItem)(ToolStripMenuItem)sender).get_Text())
				{
				case "Copy":
				{
					ListViewItem val = listViewPWD.get_SelectedItems().get_Item(0);
					string text = val.get_Text() + "  " + val.get_SubItems().get_Item(1).get_Text();
					Clipboard.SetText(text);
					break;
				}
				case "Delete":
				{
					int index = listViewPWD.get_SelectedItems().get_Item(0).get_Index();
					listViewPWD.get_Items().RemoveAt(index);
					break;
				}
				case "Clear":
					listViewPWD.get_Items().Clear();
					break;
				}
			}
			catch (Exception)
			{
			}
		}

		private void btnSwithToResend_Click(object sender, EventArgs e)
		{
			mainfrm.SelectTool("Resend");
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_000c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0016: Expected O, but got Unknown
			//IL_0017: Unknown result type (might be due to invalid IL or missing references)
			//IL_0021: Expected O, but got Unknown
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Expected O, but got Unknown
			//IL_002d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0037: Expected O, but got Unknown
			//IL_0038: Unknown result type (might be due to invalid IL or missing references)
			//IL_0042: Expected O, but got Unknown
			//IL_0043: Unknown result type (might be due to invalid IL or missing references)
			//IL_004d: Expected O, but got Unknown
			//IL_004e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0058: Expected O, but got Unknown
			//IL_0059: Unknown result type (might be due to invalid IL or missing references)
			//IL_0063: Expected O, but got Unknown
			//IL_0064: Unknown result type (might be due to invalid IL or missing references)
			//IL_006e: Expected O, but got Unknown
			//IL_006f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0079: Expected O, but got Unknown
			//IL_007a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0084: Expected O, but got Unknown
			//IL_0085: Unknown result type (might be due to invalid IL or missing references)
			//IL_008f: Expected O, but got Unknown
			//IL_0090: Unknown result type (might be due to invalid IL or missing references)
			//IL_009a: Expected O, but got Unknown
			//IL_009b: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a5: Expected O, but got Unknown
			//IL_00a6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b0: Expected O, but got Unknown
			//IL_00b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00bb: Expected O, but got Unknown
			//IL_00bc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c6: Expected O, but got Unknown
			//IL_00c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d1: Expected O, but got Unknown
			//IL_00d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_00dc: Expected O, but got Unknown
			//IL_00dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e7: Expected O, but got Unknown
			//IL_00e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f2: Expected O, but got Unknown
			//IL_00f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fd: Expected O, but got Unknown
			//IL_00fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0108: Expected O, but got Unknown
			//IL_0109: Unknown result type (might be due to invalid IL or missing references)
			//IL_0113: Expected O, but got Unknown
			//IL_0114: Unknown result type (might be due to invalid IL or missing references)
			//IL_011e: Expected O, but got Unknown
			//IL_0125: Unknown result type (might be due to invalid IL or missing references)
			//IL_012f: Expected O, but got Unknown
			//IL_0130: Unknown result type (might be due to invalid IL or missing references)
			//IL_013a: Expected O, but got Unknown
			//IL_013b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0145: Expected O, but got Unknown
			//IL_0146: Unknown result type (might be due to invalid IL or missing references)
			//IL_0150: Expected O, but got Unknown
			//IL_0151: Unknown result type (might be due to invalid IL or missing references)
			//IL_015b: Expected O, but got Unknown
			//IL_015c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0166: Expected O, but got Unknown
			//IL_028c: Unknown result type (might be due to invalid IL or missing references)
			//IL_02a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_02c4: Unknown result type (might be due to invalid IL or missing references)
			//IL_02de: Unknown result type (might be due to invalid IL or missing references)
			//IL_0341: Unknown result type (might be due to invalid IL or missing references)
			//IL_0355: Unknown result type (might be due to invalid IL or missing references)
			//IL_037c: Unknown result type (might be due to invalid IL or missing references)
			//IL_03bf: Unknown result type (might be due to invalid IL or missing references)
			//IL_03d3: Unknown result type (might be due to invalid IL or missing references)
			//IL_03f7: Unknown result type (might be due to invalid IL or missing references)
			//IL_044e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0462: Unknown result type (might be due to invalid IL or missing references)
			//IL_0486: Unknown result type (might be due to invalid IL or missing references)
			//IL_04dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_04f1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0515: Unknown result type (might be due to invalid IL or missing references)
			//IL_0577: Unknown result type (might be due to invalid IL or missing references)
			//IL_058b: Unknown result type (might be due to invalid IL or missing references)
			//IL_05af: Unknown result type (might be due to invalid IL or missing references)
			//IL_05e5: Unknown result type (might be due to invalid IL or missing references)
			//IL_05f9: Unknown result type (might be due to invalid IL or missing references)
			//IL_0620: Unknown result type (might be due to invalid IL or missing references)
			//IL_065c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0670: Unknown result type (might be due to invalid IL or missing references)
			//IL_0697: Unknown result type (might be due to invalid IL or missing references)
			//IL_06d3: Unknown result type (might be due to invalid IL or missing references)
			//IL_06e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_070e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0741: Unknown result type (might be due to invalid IL or missing references)
			//IL_0755: Unknown result type (might be due to invalid IL or missing references)
			//IL_077c: Unknown result type (might be due to invalid IL or missing references)
			//IL_07af: Unknown result type (might be due to invalid IL or missing references)
			//IL_07c3: Unknown result type (might be due to invalid IL or missing references)
			//IL_07ea: Unknown result type (might be due to invalid IL or missing references)
			//IL_0826: Unknown result type (might be due to invalid IL or missing references)
			//IL_083a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0861: Unknown result type (might be due to invalid IL or missing references)
			//IL_08b5: Unknown result type (might be due to invalid IL or missing references)
			//IL_08c9: Unknown result type (might be due to invalid IL or missing references)
			//IL_08f0: Unknown result type (might be due to invalid IL or missing references)
			//IL_0938: Unknown result type (might be due to invalid IL or missing references)
			//IL_094c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0973: Unknown result type (might be due to invalid IL or missing references)
			//IL_09b9: Unknown result type (might be due to invalid IL or missing references)
			//IL_09cd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a0c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a4e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a5e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a78: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a8c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ab0: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b52: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b66: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b99: Unknown result type (might be due to invalid IL or missing references)
			//IL_0bd4: Unknown result type (might be due to invalid IL or missing references)
			//IL_0bde: Expected O, but got Unknown
			//IL_0c37: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c4b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c72: Unknown result type (might be due to invalid IL or missing references)
			//IL_0cbb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ccf: Unknown result type (might be due to invalid IL or missing references)
			//IL_0cf6: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d3c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d50: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d74: Unknown result type (might be due to invalid IL or missing references)
			//IL_0db6: Unknown result type (might be due to invalid IL or missing references)
			//IL_0dca: Unknown result type (might be due to invalid IL or missing references)
			//IL_0dee: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e2e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e42: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e69: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ea0: Unknown result type (might be due to invalid IL or missing references)
			//IL_0eb4: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ed8: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f88: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f9c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0fc0: Unknown result type (might be due to invalid IL or missing references)
			//IL_100a: Unknown result type (might be due to invalid IL or missing references)
			//IL_102e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1061: Unknown result type (might be due to invalid IL or missing references)
			//IL_1085: Unknown result type (might be due to invalid IL or missing references)
			//IL_10c2: Unknown result type (might be due to invalid IL or missing references)
			//IL_10e9: Unknown result type (might be due to invalid IL or missing references)
			//IL_111d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1144: Unknown result type (might be due to invalid IL or missing references)
			//IL_1199: Unknown result type (might be due to invalid IL or missing references)
			//IL_11b5: Unknown result type (might be due to invalid IL or missing references)
			//IL_12db: Unknown result type (might be due to invalid IL or missing references)
			components = (IContainer)new Container();
			groupBox1 = new GroupBox();
			chkOnceStop = new CheckBox();
			btnSelectComboFile = new Button();
			btnSelectPassFile = new Button();
			btnSelectUserFile = new Button();
			label4 = new Label();
			txtComboFile = new TextBox();
			label3 = new Label();
			label2 = new Label();
			txtPassFile = new TextBox();
			txtUserFile = new TextBox();
			radioBtnCombo = new RadioButton();
			radioBtnDict2 = new RadioButton();
			txtURL = new TextBox();
			txtPostData = new TextBox();
			btnGo = new Button();
			listViewPWD = new ListView();
			colUsername = new ColumnHeader();
			colPassword = new ColumnHeader();
			cmbUsername = new ComboBox();
			cmbPassword = new ComboBox();
			label1 = new Label();
			label5 = new Label();
			label6 = new Label();
			btnResetField = new Button();
			toolTipForBruter = new ToolTip(components);
			cmbMethod = new ComboBox();
			cmbCSRF = new ComboBox();
			label7 = new Label();
			label8 = new Label();
			btnSwithToResend = new Button();
			((Control)groupBox1).SuspendLayout();
			((Control)this).SuspendLayout();
			((Control)groupBox1).get_Controls().Add((Control)(object)chkOnceStop);
			((Control)groupBox1).get_Controls().Add((Control)(object)btnSelectComboFile);
			((Control)groupBox1).get_Controls().Add((Control)(object)btnSelectPassFile);
			((Control)groupBox1).get_Controls().Add((Control)(object)btnSelectUserFile);
			((Control)groupBox1).get_Controls().Add((Control)(object)label4);
			((Control)groupBox1).get_Controls().Add((Control)(object)txtComboFile);
			((Control)groupBox1).get_Controls().Add((Control)(object)label3);
			((Control)groupBox1).get_Controls().Add((Control)(object)label2);
			((Control)groupBox1).get_Controls().Add((Control)(object)txtPassFile);
			((Control)groupBox1).get_Controls().Add((Control)(object)txtUserFile);
			((Control)groupBox1).get_Controls().Add((Control)(object)radioBtnCombo);
			((Control)groupBox1).get_Controls().Add((Control)(object)radioBtnDict2);
			((Control)groupBox1).set_Location(new Point(17, 212));
			((Control)groupBox1).set_Margin(new Padding(4, 4, 4, 4));
			((Control)groupBox1).set_Name("groupBox1");
			((Control)groupBox1).set_Padding(new Padding(4, 4, 4, 4));
			((Control)groupBox1).set_Size(new Size(975, 202));
			((Control)groupBox1).set_TabIndex(0);
			groupBox1.set_TabStop(false);
			((Control)groupBox1).set_Text("Option");
			((Control)chkOnceStop).set_AutoSize(true);
			chkOnceStop.set_Checked(true);
			chkOnceStop.set_CheckState((CheckState)1);
			((Control)chkOnceStop).set_Location(new Point(43, 175));
			((Control)chkOnceStop).set_Margin(new Padding(4, 4, 4, 4));
			((Control)chkOnceStop).set_Name("chkOnceStop");
			((Control)chkOnceStop).set_Size(new Size(333, 19));
			((Control)chkOnceStop).set_TabIndex(11);
			((Control)chkOnceStop).set_Text("Stop when found one username/password.");
			((ButtonBase)chkOnceStop).set_UseVisualStyleBackColor(true);
			((Control)btnSelectComboFile).set_Location(new Point(739, 138));
			((Control)btnSelectComboFile).set_Margin(new Padding(4, 4, 4, 4));
			((Control)btnSelectComboFile).set_Name("btnSelectComboFile");
			((Control)btnSelectComboFile).set_Size(new Size(41, 29));
			((Control)btnSelectComboFile).set_TabIndex(10);
			((Control)btnSelectComboFile).set_Text("...");
			((ButtonBase)btnSelectComboFile).set_UseVisualStyleBackColor(true);
			((Control)btnSelectComboFile).add_Click((EventHandler)btnSelectComboFile_Click);
			((Control)btnSelectPassFile).set_Location(new Point(739, 79));
			((Control)btnSelectPassFile).set_Margin(new Padding(4, 4, 4, 4));
			((Control)btnSelectPassFile).set_Name("btnSelectPassFile");
			((Control)btnSelectPassFile).set_Size(new Size(41, 29));
			((Control)btnSelectPassFile).set_TabIndex(9);
			((Control)btnSelectPassFile).set_Text("...");
			((ButtonBase)btnSelectPassFile).set_UseVisualStyleBackColor(true);
			((Control)btnSelectPassFile).add_Click((EventHandler)btnSelectPassFile_Click);
			((Control)btnSelectUserFile).set_Location(new Point(739, 50));
			((Control)btnSelectUserFile).set_Margin(new Padding(4, 4, 4, 4));
			((Control)btnSelectUserFile).set_Name("btnSelectUserFile");
			((Control)btnSelectUserFile).set_Size(new Size(41, 29));
			((Control)btnSelectUserFile).set_TabIndex(8);
			((Control)btnSelectUserFile).set_Text("...");
			((ButtonBase)btnSelectUserFile).set_UseVisualStyleBackColor(true);
			((Control)btnSelectUserFile).add_Click((EventHandler)btnSelectUserFile_Click);
			((Control)label4).set_AutoSize(true);
			((Control)label4).set_Location(new Point(69, 145));
			((Control)label4).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label4).set_Name("label4");
			((Control)label4).set_Size(new Size(127, 15));
			((Control)label4).set_TabIndex(7);
			((Control)label4).set_Text("Combo List File");
			((Control)txtComboFile).set_Location(new Point(240, 140));
			((Control)txtComboFile).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtComboFile).set_Name("txtComboFile");
			((Control)txtComboFile).set_Size(new Size(488, 25));
			((Control)txtComboFile).set_TabIndex(6);
			((Control)txtComboFile).set_Text("combo.txt");
			((Control)label3).set_AutoSize(true);
			((Control)label3).set_Location(new Point(69, 86));
			((Control)label3).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label3).set_Name("label3");
			((Control)label3).set_Size(new Size(151, 15));
			((Control)label3).set_TabIndex(5);
			((Control)label3).set_Text("Password List File");
			((Control)label2).set_AutoSize(true);
			((Control)label2).set_Location(new Point(69, 56));
			((Control)label2).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label2).set_Name("label2");
			((Control)label2).set_Size(new Size(151, 15));
			((Control)label2).set_TabIndex(4);
			((Control)label2).set_Text("Username List File");
			((Control)txtPassFile).set_Location(new Point(240, 81));
			((Control)txtPassFile).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtPassFile).set_Name("txtPassFile");
			((Control)txtPassFile).set_Size(new Size(488, 25));
			((Control)txtPassFile).set_TabIndex(3);
			((Control)txtPassFile).set_Text("password.txt");
			((Control)txtUserFile).set_Location(new Point(240, 51));
			((Control)txtUserFile).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtUserFile).set_Name("txtUserFile");
			((Control)txtUserFile).set_Size(new Size(488, 25));
			((Control)txtUserFile).set_TabIndex(2);
			((Control)txtUserFile).set_Text("username.txt");
			((Control)radioBtnCombo).set_AutoSize(true);
			((Control)radioBtnCombo).set_Location(new Point(43, 111));
			((Control)radioBtnCombo).set_Margin(new Padding(4, 4, 4, 4));
			((Control)radioBtnCombo).set_Name("radioBtnCombo");
			((Control)radioBtnCombo).set_Size(new Size(300, 19));
			((Control)radioBtnCombo).set_TabIndex(1);
			((Control)radioBtnCombo).set_Text("Use Combo (username:password) list");
			((ButtonBase)radioBtnCombo).set_UseVisualStyleBackColor(true);
			((Control)radioBtnDict2).set_AutoSize(true);
			radioBtnDict2.set_Checked(true);
			((Control)radioBtnDict2).set_Location(new Point(43, 26));
			((Control)radioBtnDict2).set_Margin(new Padding(4, 4, 4, 4));
			((Control)radioBtnDict2).set_Name("radioBtnDict2");
			((Control)radioBtnDict2).set_Size(new Size(692, 19));
			((Control)radioBtnDict2).set_TabIndex(0);
			radioBtnDict2.set_TabStop(true);
			((Control)radioBtnDict2).set_Text("Use username list and password list (if password include username, use %username% )");
			((ButtonBase)radioBtnDict2).set_UseVisualStyleBackColor(true);
			((Control)txtURL).set_Location(new Point(17, 49));
			((Control)txtURL).set_Margin(new Padding(4, 4, 4, 4));
			((Control)txtURL).set_Name("txtURL");
			((Control)txtURL).set_Size(new Size(975, 25));
			((Control)txtURL).set_TabIndex(1);
			((Control)txtURL).set_Tag((object)"");
			toolTipForBruter.SetToolTip((Control)(object)txtURL, "Launch this bruter tool from Resend Tool is preferred! Or input the action URL here.");
			((Control)txtPostData).set_Location(new Point(17, 83));
			((Control)txtPostData).set_Margin(new Padding(4, 4, 4, 4));
			((TextBoxBase)txtPostData).set_Multiline(true);
			((Control)txtPostData).set_Name("txtPostData");
			txtPostData.set_ScrollBars((ScrollBars)2);
			((Control)txtPostData).set_Size(new Size(975, 60));
			((Control)txtPostData).set_TabIndex(2);
			((Control)txtPostData).set_Tag((object)"");
			toolTipForBruter.SetToolTip((Control)(object)txtPostData, "Launch this bruter tool from Resend Tool is preferred! Or input the post data here, example: username=admin&password=123456");
			((Control)btnGo).set_BackColor(SystemColors.get_Control());
			((Control)btnGo).set_ForeColor(Color.get_Red());
			((Control)btnGo).set_Location(new Point(870, 174));
			((Control)btnGo).set_Margin(new Padding(4, 4, 4, 4));
			((Control)btnGo).set_Name("btnGo");
			((Control)btnGo).set_Size(new Size(122, 29));
			((Control)btnGo).set_TabIndex(4);
			((Control)btnGo).set_Text("Go");
			toolTipForBruter.SetToolTip((Control)(object)btnGo, "Launch Brute Force");
			((ButtonBase)btnGo).set_UseVisualStyleBackColor(false);
			((Control)btnGo).add_Click((EventHandler)btnGo_Click);
			listViewPWD.get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[2]
			{
				colUsername,
				colPassword
			});
			listViewPWD.set_FullRowSelect(true);
			((Control)listViewPWD).set_Location(new Point(19, 422));
			((Control)listViewPWD).set_Margin(new Padding(4, 4, 4, 4));
			listViewPWD.set_MultiSelect(false);
			((Control)listViewPWD).set_Name("listViewPWD");
			((Control)listViewPWD).set_Size(new Size(973, 120));
			((Control)listViewPWD).set_TabIndex(5);
			listViewPWD.set_UseCompatibleStateImageBehavior(false);
			listViewPWD.set_View((View)1);
			((Control)listViewPWD).add_MouseClick(new MouseEventHandler(listViewPWD_MouseClick));
			colUsername.set_Text("Username");
			colUsername.set_Width(238);
			colPassword.set_Text("Password");
			colPassword.set_Width(306);
			((ListControl)cmbUsername).set_FormattingEnabled(true);
			((Control)cmbUsername).set_Location(new Point(93, 177));
			((Control)cmbUsername).set_Margin(new Padding(4, 4, 4, 4));
			((Control)cmbUsername).set_Name("cmbUsername");
			((Control)cmbUsername).set_Size(new Size(132, 23));
			((Control)cmbUsername).set_TabIndex(6);
			cmbUsername.add_DropDown((EventHandler)cmbUsernameOrPassword_DropDown);
			((ListControl)cmbPassword).set_FormattingEnabled(true);
			((Control)cmbPassword).set_Location(new Point(310, 177));
			((Control)cmbPassword).set_Margin(new Padding(4, 4, 4, 4));
			((Control)cmbPassword).set_Name("cmbPassword");
			((Control)cmbPassword).set_Size(new Size(132, 23));
			((Control)cmbPassword).set_TabIndex(7);
			cmbPassword.add_DropDown((EventHandler)cmbUsernameOrPassword_DropDown);
			((Control)label1).set_AutoSize(true);
			((Control)label1).set_Location(new Point(19, 181));
			((Control)label1).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label1).set_Name("label1");
			((Control)label1).set_Size(new Size(71, 15));
			((Control)label1).set_TabIndex(8);
			((Control)label1).set_Text("Username");
			((Control)label5).set_AutoSize(true);
			((Control)label5).set_Location(new Point(234, 181));
			((Control)label5).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label5).set_Name("label5");
			((Control)label5).set_Size(new Size(71, 15));
			((Control)label5).set_TabIndex(9);
			((Control)label5).set_Text("Password");
			((Control)label6).set_AutoSize(true);
			((Control)label6).set_Location(new Point(17, 147));
			((Control)label6).set_Margin(new Padding(4, 0, 4, 0));
			((Control)label6).set_Name("label6");
			((Control)label6).set_Size(new Size(391, 15));
			((Control)label6).set_TabIndex(10);
			((Control)label6).set_Text("PostData Example: username=admin&&password=123456");
			((Control)btnResetField).set_Location(new Point(787, 174));
			((Control)btnResetField).set_Margin(new Padding(4, 4, 4, 4));
			((Control)btnResetField).set_Name("btnResetField");
			((Control)btnResetField).set_Size(new Size(59, 29));
			((Control)btnResetField).set_TabIndex(11);
			((Control)btnResetField).set_Text("Reset");
			toolTipForBruter.SetToolTip((Control)(object)btnResetField, "Reset selectable fields if fields changed.");
			((ButtonBase)btnResetField).set_UseVisualStyleBackColor(true);
			((Control)btnResetField).add_Click((EventHandler)btnResetField_Click);
			cmbMethod.set_DropDownStyle((ComboBoxStyle)2);
			((ListControl)cmbMethod).set_FormattingEnabled(true);
			cmbMethod.get_Items().AddRange(new object[2]
			{
				"GET",
				"POST"
			});
			((Control)cmbMethod).set_Location(new Point(697, 177));
			((Control)cmbMethod).set_Margin(new Padding(4, 4, 4, 4));
			((Control)cmbMethod).set_Name("cmbMethod");
			((Control)cmbMethod).set_Size(new Size(65, 23));
			((Control)cmbMethod).set_TabIndex(12);
			cmbMethod.add_SelectedIndexChanged((EventHandler)cmbMethod_SelectedIndexChanged);
			((ListControl)cmbCSRF).set_FormattingEnabled(true);
			((Control)cmbCSRF).set_Location(new Point(543, 177));
			((Control)cmbCSRF).set_Name("cmbCSRF");
			((Control)cmbCSRF).set_Size(new Size(121, 23));
			((Control)cmbCSRF).set_TabIndex(13);
			((Control)label7).set_AutoSize(true);
			((Control)label7).set_Location(new Point(458, 181));
			((Control)label7).set_Name("label7");
			((Control)label7).set_Size(new Size(79, 15));
			((Control)label7).set_TabIndex(14);
			((Control)label7).set_Text("Anti CSRF");
			((Control)label8).set_AutoSize(true);
			((Control)label8).set_Location(new Point(17, 17));
			((Control)label8).set_Name("label8");
			((Control)label8).set_Size(new Size(383, 15));
			((Control)label8).set_TabIndex(15);
			((Control)label8).set_Text("Please load from resend tool by click \"Bruter\":");
			((Control)btnSwithToResend).set_Location(new Point(450, 13));
			((Control)btnSwithToResend).set_Name("btnSwithToResend");
			((Control)btnSwithToResend).set_Size(new Size(255, 25));
			((Control)btnSwithToResend).set_TabIndex(16);
			((Control)btnSwithToResend).set_Text("Switch to Resend tool");
			((ButtonBase)btnSwithToResend).set_UseVisualStyleBackColor(true);
			((Control)btnSwithToResend).add_Click((EventHandler)btnSwithToResend_Click);
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(8f, 15f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(1011, 563));
			((Control)this).get_Controls().Add((Control)(object)btnSwithToResend);
			((Control)this).get_Controls().Add((Control)(object)label8);
			((Control)this).get_Controls().Add((Control)(object)label7);
			((Control)this).get_Controls().Add((Control)(object)cmbCSRF);
			((Control)this).get_Controls().Add((Control)(object)cmbMethod);
			((Control)this).get_Controls().Add((Control)(object)btnResetField);
			((Control)this).get_Controls().Add((Control)(object)label6);
			((Control)this).get_Controls().Add((Control)(object)label5);
			((Control)this).get_Controls().Add((Control)(object)label1);
			((Control)this).get_Controls().Add((Control)(object)cmbPassword);
			((Control)this).get_Controls().Add((Control)(object)cmbUsername);
			((Control)this).get_Controls().Add((Control)(object)listViewPWD);
			((Control)this).get_Controls().Add((Control)(object)btnGo);
			((Control)this).get_Controls().Add((Control)(object)txtPostData);
			((Control)this).get_Controls().Add((Control)(object)txtURL);
			((Control)this).get_Controls().Add((Control)(object)groupBox1);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Form)this).set_Margin(new Padding(4, 4, 4, 4));
			((Control)this).set_Name("FormBruter");
			((Control)this).set_Text("FormBruter");
			((Control)groupBox1).ResumeLayout(false);
			((Control)groupBox1).PerformLayout();
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
