using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Net;
using System.Resources;
using System.Runtime.InteropServices;
using System.Security;
using System.Security.Permissions;
using System.Text;
using System.Web;
using System.Windows.Forms;
using Microsoft.JScript;
using SHDocVw;

namespace WebCruiserWVS
{
	public class FormBrowser : Form
	{
		private FormMain mainfrm;

		private string LastDomainHost = "";

		private string LastURL = "";

		private WebBrowser wb;

		private List<RequestInfo> UrlList = new List<RequestInfo>();

		private RequestInfo currentRequest;

		private bool isMultipartFormDataResend;

		private IContainer components;

		private WebBrowser WCRBrowser;

		private Timer BrowserTimer;

		private TabControl tabBrowserForm;

		private TabPage tabBrowser;

		private TabPage tabResend;

		private ToolStrip toolStripResend;

		private ToolStripLabel lblMethond;

		private ToolStripSeparator toolStripSeparator1;

		private ToolStripTextBox txtResendURL;

		private ToolStripButton ButtonResend;

		private ToolStripSeparator toolStripSeparator2;

		private ToolStripSeparator toolStripSeparator3;

		private ToolStripSeparator toolStripSeparator4;

		private ImageList ImageListBrowser;

		private SplitContainer splitConResend;

		private TextBox txtResendPostData;

		private ToolStripButton btnBruter;

		private TextBox txtReqHeader;

		private TabControl tabPostData;

		private TabPage tabRawViewPage;

		private TabPage tabTabularPage;

		private ListView listViewReqList;

		private ColumnHeader colUrl;

		private TabControl tabReqResp;

		private TabPage tabReqPage;

		private SplitContainer splitRequest;

		private TabPage tabRespPage;

		private SplitContainer splitConResp;

		private TextBox txtResendResponseCode;

		private ToolStrip toolStripResendResponse;

		private ToolStripSeparator toolStripSeparator5;

		private ToolStripLabel LabelResponseCode;

		private ToolStripSeparator toolStripSeparator6;

		private ToolStripSeparator toolStripSeparator7;

		private ToolStripButton ButtonLoadInBrowser;

		private ColumnHeader colMethod;

		private TextBox txtRespHeaders;

		private ListView lvPostDataKeyValue;

		private ColumnHeader colParaName;

		private ColumnHeader colParaValue;

		public FormBrowser(FormMain fm)
			: this()
		{
			//IL_0052: Unknown result type (might be due to invalid IL or missing references)
			//IL_005c: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_0073: Expected O, but got Unknown
			//IL_0080: Unknown result type (might be due to invalid IL or missing references)
			//IL_008a: Expected O, but got Unknown
			InitializeComponent();
			mainfrm = fm;
			LoadDefaultPage();
			((Control)toolStripResendResponse).set_Visible(true);
			try
			{
				wb = (WebBrowser)((WebBrowserBase)WCRBrowser).get_ActiveXInstance();
				((DWebBrowserEvents2_Event)wb).add_BeforeNavigate2(new DWebBrowserEvents2_BeforeNavigate2EventHandler(wb_BeforeNavigate2));
				((DWebBrowserEvents2_Event)wb).add_NewWindow3(new DWebBrowserEvents2_NewWindow3EventHandler(wb_NewWindow3));
				((IWebBrowser2)wb).set_Silent(true);
			}
			catch
			{
			}
		}

		private void wb_NewWindow3(ref object ppDisp, ref bool Cancel, uint dwFlags, string bstrUrlContext, string bstrUrl)
		{
			//IL_0029: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (bstrUrl.IndexOf("http") >= 0)
				{
					Cancel = true;
					WCRBrowser.Navigate(bstrUrl, false);
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void LoadDefaultPage()
		{
			WCRBrowser.Navigate("about:blank");
			string str = "<br>WebCruiser Web Vulnerability Scanner 3<br><br>";
			str += "- Vulnerability Scanner: <br>";
			str += "&nbsp;&nbsp;&nbsp;- SQL Injection, Cross-site Scripting (XSS)<br>";
			str += "&nbsp;&nbsp;&nbsp;- Local File Inclusion (LFI), Remote File Inclusion (RFI), Redirect, Obsolete Backup<br>";
			str += "- SQL Injection Tool: SQL Server, MySQL, Oracle, DB2, PostgreSQL, SQLite, Access<br>";
			str += "- XSS, LFI, RFI, Redirect POC Tool.<br>";
			str += "- Resend & Bruter Tool.<br>";
			str += "- Cookie Tool.<br>";
			if (WCRSetting.wvsEdition == WVSEdition.Free)
			{
				str += "<br>The Free Edition can scan the following address for non-commercial use:<br>";
				str += "- 127.0.0.1   (IP Address Only)<br>";
				str += "- 192.168.*.* (IP Address Only)<br>";
				str += "- 10.*.*.*     (IP Address Only)<br>";
			}
			str += "<br>&copy;Janusec https://www.janusec.com<br>";
			WCRBrowser.get_Document().Write(str);
		}

		public void NavigatePage(string sURL, RequestType ReqType, string SubmitData, string enctype)
		{
			//IL_00e1: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				byte[] array = null;
				string text = "User-Agent: " + WCRSetting.UserAgent + "\r\n";
				switch (ReqType)
				{
				case RequestType.POST:
					text = ((!enctype.Equals("multipart/form-data")) ? (text + "Content-Type: " + enctype + "\r\n") : (text + "Content-Type: multipart/form-data; boundary=----WebFormBoundary0x5743525F575653\r\n"));
					array = Encoding.UTF8.GetBytes(mainfrm.CurrentSite.ConvertPostDataByContentType(SubmitData, enctype));
					break;
				case RequestType.COOKIE:
					SubmitData = SubmitData.Replace("&", ";");
					mainfrm.CurrentSite.SetCookie(sURL, SubmitData, isClear: false);
					break;
				}
				mainfrm.DisplayProgress("Navigating ...");
				BrowserTimer.Start();
				WCRBrowser.Navigate(sURL, (string)null, array, text);
				tabBrowserForm.SelectTab(tabBrowser);
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message + "\r\nWebBrowser Closed! Please Exit and Run again!");
			}
		}

		private void HTTPFileReset()
		{
			mainfrm.CurrentSite.paramType = ParameterType.UnKnown;
			mainfrm.CurrentSite.injectMethod = InjectMethod.ToBeDetect;
			mainfrm.UpdateKeyWordText("");
		}

		private void WebBrowserLoadCompleted()
		{
			//IL_013c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0147: Expected O, but got Unknown
			try
			{
				string text = ((object)WCRBrowser.get_Url()).ToString();
				if (text.IndexOf("about:") != 0)
				{
					if (WCRSetting.RefreshURL)
					{
						mainfrm.URL = text;
					}
					string encoding = WCRBrowser.get_Document().get_Encoding();
					if (string.IsNullOrEmpty(encoding))
					{
						mainfrm.CurrentSite.WebEncoding = Encoding.Default;
					}
					else
					{
						mainfrm.CurrentSite.WebEncoding = Encoding.GetEncoding(encoding);
					}
					mainfrm.CurrentSite.DBEncoding = mainfrm.CurrentSite.WebEncoding;
				}
				if (!string.IsNullOrEmpty(LastDomainHost))
				{
					HTTPFileReset();
				}
				if (!mainfrm.CurrentSite.DomainHost.Equals(LastDomainHost))
				{
					mainfrm.CurrentSite.WcrFileName = "";
				}
				LastDomainHost = mainfrm.CurrentSite.DomainHost;
				mainfrm.DisplayProgress("Done");
				string webBrowserCookie = GetWebBrowserCookie();
				if (!string.IsNullOrEmpty(webBrowserCookie))
				{
					webBrowserCookie = webBrowserCookie.Replace(';', ',');
					mainfrm.CurrentSite.cc.SetCookies(new Uri(mainfrm.CurrentSite.HTTPRoot), webBrowserCookie);
				}
			}
			catch (Exception)
			{
			}
		}

		public string GetWebBrowserCookie()
		{
			string text = "";
			try
			{
				return GetCookieInternal(mainfrm.CurrentSite.currentUri, throwIfNoCookie: true);
			}
			catch (Exception)
			{
				return WCRBrowser.get_Document().get_Cookie();
			}
		}

		private void WCRBrowser_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
		{
			//IL_0006: Unknown result type (might be due to invalid IL or missing references)
			//IL_000c: Invalid comparison between Unknown and I4
			if ((int)WCRBrowser.get_ReadyState() == 4)
			{
				LastURL = ((object)WCRBrowser.get_Url()).ToString();
				WebBrowserLoadCompleted();
			}
		}

		private void WCRBrowser_StatusTextChanged(object sender, EventArgs e)
		{
			mainfrm.DisplayProgressNoLog(WCRBrowser.get_StatusText().Replace("&", "&&"));
		}

		public string GetSourceCodeFromWebBrowser()
		{
			//IL_005f: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				string encoding = WCRBrowser.get_Document().get_Encoding();
				StreamReader streamReader = ((!string.IsNullOrEmpty(encoding)) ? new StreamReader(WCRBrowser.get_DocumentStream(), Encoding.GetEncoding(encoding)) : new StreamReader(WCRBrowser.get_DocumentStream(), Encoding.Default));
				string result = streamReader.ReadToEnd();
				streamReader.Close();
				return result;
			}
			catch
			{
				MessageBox.Show("* Null Source Code: Disabled OR No Page Navigated!\r\n* Try To Get Code From URL.");
				return "";
			}
		}

		public void XPathPOC(string RefURL, string XPathForm, string Parameter)
		{
			//IL_007e: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00be: Expected O, but got Unknown
			//IL_017b: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.NavigatePage(RefURL, RequestType.GET, "");
			string[] paraNameValue = WebSite.GetParaNameValue(Parameter, '=');
			string value = paraNameValue[0];
			string expression = paraNameValue[1];
			string[] array = new string[2];
			if (XPathForm.IndexOf('^') > 0)
			{
				array = WebSite.GetParaNameValue(XPathForm, '^');
			}
			else
			{
				if (XPathForm.IndexOf('?') <= 0)
				{
					return;
				}
				array = WebSite.GetParaNameValue(XPathForm, '?');
			}
			string[] array2 = array[1].Split(new char[1]
			{
				'&'
			});
			MessageBox.Show("* It Will Open The XPath Page And Fill In Input Fields Automatically! \r\n* When Page Load Completed, Click OK To Continue!", "Information", (MessageBoxButtons)0, (MessageBoxIcon)64);
			mainfrm.DisplayLogList("Preparing XPath Data...");
			foreach (HtmlElement item in WCRBrowser.get_Document().get_All())
			{
				HtmlElement val = item;
				for (int i = 0; i < array2.Length; i++)
				{
					string[] paraNameValue2 = WebSite.GetParaNameValue(array2[i], '=');
					if (val.get_Name().Equals(paraNameValue2[0]))
					{
						val.SetAttribute("value", GlobalObject.unescape((object)WebSite.RemoveTestInput(paraNameValue2[1])));
					}
				}
				if (val.get_Name().Equals(value))
				{
					val.SetAttribute("value", GlobalObject.unescape((object)(WebSite.RemoveTestInput(expression) + "%27] | * | user[@role=%27admin")));
				}
			}
			mainfrm.DisplayProgress("Done");
			MessageBox.Show("* XPath Data Filled OK, You Can View Or Change It Now!\r\n* Then Click Button To Submit The Form Manually! \r\n* You Will Get The Response Possibly Include Confidential Data!", "Information", (MessageBoxButtons)0, (MessageBoxIcon)64);
		}

		private void BrowserTimer_Tick(object sender, EventArgs e)
		{
			//IL_0006: Unknown result type (might be due to invalid IL or missing references)
			//IL_000c: Invalid comparison between Unknown and I4
			try
			{
				if ((int)WCRBrowser.get_ReadyState() != 4)
				{
					if (WCRBrowser.get_Url() != (Uri)null && LastURL != ((object)WCRBrowser.get_Url()).ToString())
					{
						LastURL = ((object)WCRBrowser.get_Url()).ToString();
						WebBrowserLoadCompleted();
					}
					WCRBrowser.Stop();
				}
				BrowserTimer.Stop();
			}
			catch (Exception)
			{
			}
		}

		public void FillInForm(string Expression)
		{
			mainfrm.DisplayProgress("Filling Forms...");
			Expression = Expression.Replace("&amp;", "&");
			Expression = HttpUtility.UrlDecode(Expression, mainfrm.CurrentSite.WebEncoding);
			string[] array = Expression.Split(new char[1]
			{
				'&'
			});
			string[] array2 = array;
			foreach (string expression in array2)
			{
				string[] paraNameValue = WebSite.GetParaNameValue(expression, '=');
				try
				{
					WCRBrowser.get_Document().get_All().get_Item(paraNameValue[0])
						.SetAttribute("value", GlobalObject.unescape((object)paraNameValue[1]));
				}
				catch
				{
				}
				HtmlWindowCollection frames = WCRBrowser.get_Document().get_Window().get_Frames();
				for (int j = 0; j < frames.get_Count(); j++)
				{
					try
					{
						HtmlDocument document = WCRBrowser.get_Document().get_Window().get_Frames()
							.get_Item(j)
							.get_Document();
						document.get_All().get_Item(paraNameValue[0]).SetAttribute("value", GlobalObject.unescape((object)paraNameValue[1]));
					}
					catch
					{
					}
				}
			}
			mainfrm.DisplayProgress("Done");
		}

		public int GetWCRBrowserFrameNum()
		{
			HtmlWindowCollection frames = WCRBrowser.get_Document().get_Window().get_Frames();
			return frames.get_Count();
		}

		public string GetWCRBrowserFrameSource(int i)
		{
			//IL_0036: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				return WCRBrowser.get_Document().get_Window().get_Frames()
					.get_Item(i)
					.get_Document()
					.get_Body()
					.get_OuterHtml();
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
				return "";
			}
		}

		public string GetWCRBrowserFrameURL(int i)
		{
			//IL_0031: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				Uri url = WCRBrowser.get_Document().get_Window().get_Frames()
					.get_Item(i)
					.get_Url();
				return url.get_AbsoluteUri();
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
				return "";
			}
		}

		private void wb_BeforeNavigate2(object pDisp, ref object URL, ref object Flags, ref object TargetFrameName, ref object PostData, ref object Headers, ref bool Cancel)
		{
			//IL_00b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00bb: Expected O, but got Unknown
			try
			{
				string text = URL as string;
				if (text.Equals("about:blank"))
				{
					return;
				}
				RequestType requestType;
				if (PostData != null)
				{
					string text2 = Encoding.ASCII.GetString(PostData as byte[]);
					if (text2.IndexOf("Content-Disposition: form-data; name=") > 0)
					{
						text2 = WebSite.ConvertToFormUrlencoded(text2);
						mainfrm.UpdateComboEncType("multipart/form-data");
					}
					else
					{
						mainfrm.UpdateComboEncType("application/x-www-form-urlencoded");
					}
					if (mainfrm.ReqType != RequestType.COOKIE)
					{
						mainfrm.UpdateSubmitData(text2);
					}
					requestType = RequestType.POST;
				}
				else
				{
					requestType = RequestType.GET;
				}
				if (text.IndexOf("javascript:", StringComparison.OrdinalIgnoreCase) != 0)
				{
					string text3 = Headers as string;
					string cookieStrFromCC = mainfrm.CurrentSite.GetCookieStrFromCC(new Uri(text));
					if (!string.IsNullOrEmpty(cookieStrFromCC))
					{
						text3 = text3 + "Cookie: " + cookieStrFromCC;
					}
					RequestInfo item = new RequestInfo(requestType, text, text3, PostData as byte[]);
					UrlList.Insert(0, item);
					ListViewItem val = listViewReqList.get_Items().Insert(0, requestType.ToString());
					val.get_SubItems().Add(text);
				}
			}
			catch (Exception)
			{
			}
		}

		private void txtResendURL_DoubleClick(object sender, EventArgs e)
		{
			txtResendURL.SelectAll();
		}

		private void ButtonResend_Click(object sender, EventArgs e)
		{
			//IL_0119: Unknown result type (might be due to invalid IL or missing references)
			//IL_0152: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				((ToolStripItem)LabelResponseCode).set_Text("");
				int index = listViewReqList.get_SelectedIndices().get_Item(0);
				currentRequest = UrlList[index];
				string text = ((Control)txtResendPostData).get_Text();
				string text2 = ((ToolStripItem)txtResendURL).get_Text();
				if (!string.IsNullOrEmpty(text2))
				{
					tabReqResp.SelectTab(tabRespPage);
					mainfrm.DisplayProgress("Resend...");
					string enctype = "";
					if (((Control)txtReqHeader).get_Text().IndexOf("Content-Type: multipart/form-data; boundary=") >= 0)
					{
						enctype = "multipart/form-data";
						text = WebSite.ConvertToFormUrlencoded(text);
					}
					HttpWebResponse httpWebResponse = mainfrm.CurrentSite.GetHttpWebResponse(text2, currentRequest.Method, text, enctype, "", WebSite.EscapeCookie, "", "");
					string sourceCodeFromHttpWebResponse = mainfrm.CurrentSite.GetSourceCodeFromHttpWebResponse(httpWebResponse);
					((Control)txtResendResponseCode).set_Text(sourceCodeFromHttpWebResponse);
					((Control)txtRespHeaders).set_Text(((object)((WebResponse)httpWebResponse).get_Headers()).ToString());
					((ToolStripItem)LabelResponseCode).set_Text(((object)httpWebResponse.get_StatusCode()).ToString());
					((WebResponse)httpWebResponse).Close();
					httpWebResponse = null;
					mainfrm.DisplayProgress("Done");
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void ButtonLoadInBrowser_Click(object sender, EventArgs e)
		{
			//IL_0040: Unknown result type (might be due to invalid IL or missing references)
			//IL_0046: Invalid comparison between Unknown and I4
			//IL_0084: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				string text = ((Control)txtResendResponseCode).get_Text();
				if (!string.IsNullOrEmpty(text))
				{
					Encoding webEncoding = mainfrm.CurrentSite.WebEncoding;
					WCRBrowser.Navigate("about:blank");
					do
					{
						Application.DoEvents();
					}
					while ((int)WCRBrowser.get_ReadyState() != 4);
					mainfrm.CurrentSite.WebEncoding = webEncoding;
					WCRBrowser.get_Document().Write(text);
					tabBrowserForm.SelectTab(tabBrowser);
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void toolStripResend_Resize(object sender, EventArgs e)
		{
			((ToolStripItem)txtResendURL).set_Width(((Control)toolStripResend).get_Width() - 170);
		}

		public void SelectTabByName(string TabName)
		{
			try
			{
				tabBrowserForm.SelectTab(TabName);
			}
			catch (Exception)
			{
			}
		}

		private void btnBruter_Click(object sender, EventArgs e)
		{
			string text = ((ToolStripItem)txtResendURL).get_Text();
			if (!string.IsNullOrEmpty(text))
			{
				mainfrm.SelectTool("Bruter");
				mainfrm.BruterForm.InitByRequestInfo(currentRequest.Method, currentRequest.URL, ((Control)txtReqHeader).get_Text(), ((Control)txtResendPostData).get_Text());
			}
		}

		private void listViewReqList_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_00c8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ce: Expected O, but got Unknown
			try
			{
				if (listViewReqList.get_SelectedItems().get_Count() >= 1)
				{
					int index = listViewReqList.get_SelectedIndices().get_Item(0);
					currentRequest = UrlList[index];
					((ToolStripItem)txtResendURL).set_Text(currentRequest.URL);
					((ToolStripItem)lblMethond).set_Text(currentRequest.Method.ToString());
					((Control)txtReqHeader).set_Text(currentRequest.Headers);
					if (currentRequest.Method == RequestType.POST)
					{
						((Control)txtResendPostData).set_Text(Encoding.ASCII.GetString(currentRequest.PostData));
					}
					else
					{
						((Control)txtResendPostData).set_Text("");
					}
					ContextMenuStrip val = new ContextMenuStrip();
					((ToolStrip)val).get_Items().Add("Clear", (Image)null, (EventHandler)UrlItemRightClick);
					((ToolStrip)val).get_Items().Add("Delete", (Image)null, (EventHandler)UrlItemRightClick);
					((Control)listViewReqList).set_ContextMenuStrip(val);
				}
			}
			catch (Exception)
			{
			}
		}

		private void UrlItemRightClick(object sender, EventArgs e)
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				switch (((ToolStripItem)(ToolStripMenuItem)sender).get_Text())
				{
				case "Clear":
					UrlList.Clear();
					listViewReqList.get_Items().Clear();
					break;
				case "Delete":
				{
					int index = listViewReqList.get_SelectedItems().get_Item(0).get_Index();
					UrlList.RemoveAt(index);
					listViewReqList.get_Items().RemoveAt(index);
					break;
				}
				}
			}
			catch (Exception)
			{
			}
		}

		private string GetNewValue(string key, string oldValue)
		{
			//IL_0009: Unknown result type (might be due to invalid IL or missing references)
			//IL_0012: Unknown result type (might be due to invalid IL or missing references)
			//IL_0018: Invalid comparison between Unknown and I4
			FormValue formValue = new FormValue(key, oldValue);
			((Form)formValue).ShowDialog();
			string result = oldValue;
			if ((int)((Form)formValue).get_DialogResult() == 1)
			{
				result = formValue.value;
			}
			((Component)formValue).Dispose();
			return result;
		}

		private void lvPostDataKeyValue_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			//IL_0087: Unknown result type (might be due to invalid IL or missing references)
			//IL_008e: Expected O, but got Unknown
			try
			{
				ListViewItem val = lvPostDataKeyValue.get_SelectedItems().get_Item(0);
				string text = val.get_SubItems().get_Item(0).get_Text();
				string text2 = "";
				if (val.get_SubItems().get_Count() > 1)
				{
					text2 = val.get_SubItems().get_Item(1).get_Text();
					val.get_SubItems().get_Item(1).set_Text(GetNewValue(text, text2));
					string text3 = "";
					foreach (ListViewItem item in lvPostDataKeyValue.get_Items())
					{
						ListViewItem val2 = item;
						string text4 = val2.get_Text();
						string text5 = val2.get_SubItems().get_Item(1).get_Text();
						if (!string.IsNullOrEmpty(text3))
						{
							text3 += "&";
						}
						text3 = text3 + text4 + "=" + text5;
					}
					if (isMultipartFormDataResend)
					{
						((Control)txtResendPostData).set_Text(mainfrm.CurrentSite.ConvertPostDataByContentType(text3, "multipart/form-data"));
					}
					else
					{
						((Control)txtResendPostData).set_Text(text3);
					}
				}
				else
				{
					val.get_SubItems().Add(GetNewValue(text, ""));
				}
			}
			catch (Exception)
			{
			}
		}

		private void tabPostData_SelectedIndexChanged(object sender, EventArgs e)
		{
			//IL_00c1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c8: Expected O, but got Unknown
			try
			{
				if (tabPostData.get_SelectedIndex() != 1)
				{
					return;
				}
				string text = ((Control)txtResendPostData).get_Text();
				lvPostDataKeyValue.get_Items().Clear();
				if (string.IsNullOrEmpty(text))
				{
					return;
				}
				if (text.IndexOf("Content-Disposition: form-data; name=") >= 0)
				{
					text = WebSite.ConvertToFormUrlencoded(text);
					isMultipartFormDataResend = true;
				}
				else
				{
					isMultipartFormDataResend = false;
				}
				string[] array = text.Split(new char[1]
				{
					'&'
				});
				string[] array2 = array;
				foreach (string text2 in array2)
				{
					int num = text2.IndexOf('=');
					string text3 = text2;
					if (num > 0)
					{
						text3 = text2.Substring(0, num);
					}
					string text4 = "";
					if (text2.Length > text3.Length + 1)
					{
						text4 = text2.Substring(num + 1);
					}
					ListViewItem val = new ListViewItem(text3);
					val.get_SubItems().Add(text4);
					lvPostDataKeyValue.get_Items().Add(val);
				}
			}
			catch (Exception)
			{
			}
		}

		[DllImport("wininet.dll", CharSet = CharSet.Unicode, EntryPoint = "InternetGetCookieExW", ExactSpelling = true, SetLastError = true)]
		[SuppressUnmanagedCodeSecurity]
		[SecurityCritical]
		internal static extern bool InternetGetCookieEx([In] string Url, [In] string cookieName, [Out] StringBuilder cookieData, [In][Out] ref uint pchCookieData, uint flags, IntPtr reserved);

		[SecurityCritical]
		public static string GetCookieInternal(Uri uri, bool throwIfNoCookie)
		{
			try
			{
				uint pchCookieData = 0u;
				string url = UriToString(uri);
				uint flags = 8192u;
				if (InternetGetCookieEx(url, null, null, ref pchCookieData, flags, IntPtr.Zero))
				{
					pchCookieData++;
					StringBuilder stringBuilder = new StringBuilder((int)pchCookieData);
					if (InternetGetCookieEx(url, null, stringBuilder, ref pchCookieData, flags, IntPtr.Zero))
					{
						DemandWebPermission(uri);
						return stringBuilder.ToString();
					}
				}
				int lastWin32Error = Marshal.GetLastWin32Error();
				if (throwIfNoCookie || lastWin32Error != 259)
				{
					return "";
				}
				return "";
			}
			catch (Exception)
			{
				return "";
			}
		}

		private static void DemandWebPermission(Uri uri)
		{
			//IL_0018: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Unknown result type (might be due to invalid IL or missing references)
			string text = UriToString(uri);
			if (uri.get_IsFile())
			{
				string localPath = uri.get_LocalPath();
				((CodeAccessPermission)new FileIOPermission((FileIOPermissionAccess)1, localPath)).Demand();
			}
			else
			{
				((CodeAccessPermission)new WebPermission((NetworkAccess)64, text)).Demand();
			}
		}

		private static string UriToString(Uri uri)
		{
			//IL_0025: Unknown result type (might be due to invalid IL or missing references)
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			if (uri == (Uri)null)
			{
				throw new ArgumentNullException("uri");
			}
			UriComponents val = (UriComponents)(uri.get_IsAbsoluteUri() ? 127 : int.MinValue);
			return new StringBuilder(uri.GetComponents(val, (UriFormat)3), 2083).ToString();
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_0015: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Expected O, but got Unknown
			//IL_002d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0037: Expected O, but got Unknown
			//IL_0038: Unknown result type (might be due to invalid IL or missing references)
			//IL_0042: Expected O, but got Unknown
			//IL_0043: Unknown result type (might be due to invalid IL or missing references)
			//IL_004d: Expected O, but got Unknown
			//IL_004e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0058: Expected O, but got Unknown
			//IL_0059: Unknown result type (might be due to invalid IL or missing references)
			//IL_0063: Expected O, but got Unknown
			//IL_0064: Unknown result type (might be due to invalid IL or missing references)
			//IL_006e: Expected O, but got Unknown
			//IL_006f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0079: Expected O, but got Unknown
			//IL_007a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0084: Expected O, but got Unknown
			//IL_0085: Unknown result type (might be due to invalid IL or missing references)
			//IL_008f: Expected O, but got Unknown
			//IL_0090: Unknown result type (might be due to invalid IL or missing references)
			//IL_009a: Expected O, but got Unknown
			//IL_009b: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a5: Expected O, but got Unknown
			//IL_00a6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b0: Expected O, but got Unknown
			//IL_00b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00bb: Expected O, but got Unknown
			//IL_00bc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c6: Expected O, but got Unknown
			//IL_00c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d1: Expected O, but got Unknown
			//IL_00d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_00dc: Expected O, but got Unknown
			//IL_00dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e7: Expected O, but got Unknown
			//IL_00e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f2: Expected O, but got Unknown
			//IL_00f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fd: Expected O, but got Unknown
			//IL_00fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0108: Expected O, but got Unknown
			//IL_0109: Unknown result type (might be due to invalid IL or missing references)
			//IL_0113: Expected O, but got Unknown
			//IL_0114: Unknown result type (might be due to invalid IL or missing references)
			//IL_011e: Expected O, but got Unknown
			//IL_011f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0129: Expected O, but got Unknown
			//IL_012a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0134: Expected O, but got Unknown
			//IL_0135: Unknown result type (might be due to invalid IL or missing references)
			//IL_013f: Expected O, but got Unknown
			//IL_0140: Unknown result type (might be due to invalid IL or missing references)
			//IL_014a: Expected O, but got Unknown
			//IL_014b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0155: Expected O, but got Unknown
			//IL_0156: Unknown result type (might be due to invalid IL or missing references)
			//IL_0160: Expected O, but got Unknown
			//IL_0161: Unknown result type (might be due to invalid IL or missing references)
			//IL_016b: Expected O, but got Unknown
			//IL_016c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0176: Expected O, but got Unknown
			//IL_0177: Unknown result type (might be due to invalid IL or missing references)
			//IL_0181: Expected O, but got Unknown
			//IL_0182: Unknown result type (might be due to invalid IL or missing references)
			//IL_018c: Expected O, but got Unknown
			//IL_018d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0197: Expected O, but got Unknown
			//IL_0198: Unknown result type (might be due to invalid IL or missing references)
			//IL_01a2: Expected O, but got Unknown
			//IL_01a3: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ad: Expected O, but got Unknown
			//IL_01ae: Unknown result type (might be due to invalid IL or missing references)
			//IL_01b8: Expected O, but got Unknown
			//IL_01b9: Unknown result type (might be due to invalid IL or missing references)
			//IL_01c3: Expected O, but got Unknown
			//IL_01c4: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ce: Expected O, but got Unknown
			//IL_01d5: Unknown result type (might be due to invalid IL or missing references)
			//IL_01df: Expected O, but got Unknown
			//IL_0357: Unknown result type (might be due to invalid IL or missing references)
			//IL_038d: Unknown result type (might be due to invalid IL or missing references)
			//IL_03d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_03f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_040d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0453: Unknown result type (might be due to invalid IL or missing references)
			//IL_0467: Unknown result type (might be due to invalid IL or missing references)
			//IL_047b: Unknown result type (might be due to invalid IL or missing references)
			//IL_04a5: Unknown result type (might be due to invalid IL or missing references)
			//IL_04c8: Unknown result type (might be due to invalid IL or missing references)
			//IL_04d2: Expected O, but got Unknown
			//IL_0518: Unknown result type (might be due to invalid IL or missing references)
			//IL_0539: Unknown result type (might be due to invalid IL or missing references)
			//IL_0553: Unknown result type (might be due to invalid IL or missing references)
			//IL_05c5: Unknown result type (might be due to invalid IL or missing references)
			//IL_05fb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0630: Unknown result type (might be due to invalid IL or missing references)
			//IL_0651: Unknown result type (might be due to invalid IL or missing references)
			//IL_066b: Unknown result type (might be due to invalid IL or missing references)
			//IL_06bd: Unknown result type (might be due to invalid IL or missing references)
			//IL_071d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0799: Unknown result type (might be due to invalid IL or missing references)
			//IL_07cf: Unknown result type (might be due to invalid IL or missing references)
			//IL_080a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0814: Expected O, but got Unknown
			//IL_0865: Unknown result type (might be due to invalid IL or missing references)
			//IL_08ec: Unknown result type (might be due to invalid IL or missing references)
			//IL_0924: Unknown result type (might be due to invalid IL or missing references)
			//IL_0963: Unknown result type (might be due to invalid IL or missing references)
			//IL_097f: Unknown result type (might be due to invalid IL or missing references)
			//IL_09fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a24: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a7a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a9e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ad1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b10: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b4a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b71: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b7b: Expected O, but got Unknown
			//IL_0b81: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ba5: Unknown result type (might be due to invalid IL or missing references)
			//IL_0bef: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c16: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c20: Expected O, but got Unknown
			//IL_0c26: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c4a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0cd7: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d0d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d58: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d79: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d93: Unknown result type (might be due to invalid IL or missing references)
			//IL_0dd9: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e0f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e43: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e64: Unknown result type (might be due to invalid IL or missing references)
			//IL_0e7e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0efa: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f30: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f6b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0f75: Expected O, but got Unknown
			//IL_0fd1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ff2: Unknown result type (might be due to invalid IL or missing references)
			//IL_100c: Unknown result type (might be due to invalid IL or missing references)
			//IL_1052: Unknown result type (might be due to invalid IL or missing references)
			//IL_10d9: Unknown result type (might be due to invalid IL or missing references)
			//IL_1110: Unknown result type (might be due to invalid IL or missing references)
			//IL_115b: Unknown result type (might be due to invalid IL or missing references)
			//IL_1185: Unknown result type (might be due to invalid IL or missing references)
			//IL_11c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_11e3: Unknown result type (might be due to invalid IL or missing references)
			//IL_125d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1284: Unknown result type (might be due to invalid IL or missing references)
			//IL_12c3: Unknown result type (might be due to invalid IL or missing references)
			//IL_12f6: Unknown result type (might be due to invalid IL or missing references)
			//IL_1336: Unknown result type (might be due to invalid IL or missing references)
			//IL_135d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1367: Expected O, but got Unknown
			//IL_136d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1394: Unknown result type (might be due to invalid IL or missing references)
			//IL_13de: Unknown result type (might be due to invalid IL or missing references)
			//IL_13f9: Unknown result type (might be due to invalid IL or missing references)
			//IL_1403: Expected O, but got Unknown
			//IL_1409: Unknown result type (might be due to invalid IL or missing references)
			//IL_144a: Unknown result type (might be due to invalid IL or missing references)
			//IL_1466: Unknown result type (might be due to invalid IL or missing references)
			components = (IContainer)new Container();
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormBrowser));
			BrowserTimer = new Timer(components);
			tabBrowserForm = new TabControl();
			tabBrowser = new TabPage();
			WCRBrowser = new WebBrowser();
			tabResend = new TabPage();
			tabReqResp = new TabControl();
			tabReqPage = new TabPage();
			splitRequest = new SplitContainer();
			listViewReqList = new ListView();
			colMethod = new ColumnHeader();
			colUrl = new ColumnHeader();
			splitConResend = new SplitContainer();
			txtReqHeader = new TextBox();
			toolStripResend = new ToolStrip();
			toolStripSeparator4 = new ToolStripSeparator();
			lblMethond = new ToolStripLabel();
			toolStripSeparator1 = new ToolStripSeparator();
			txtResendURL = new ToolStripTextBox();
			toolStripSeparator2 = new ToolStripSeparator();
			ButtonResend = new ToolStripButton();
			toolStripSeparator3 = new ToolStripSeparator();
			btnBruter = new ToolStripButton();
			tabPostData = new TabControl();
			tabRawViewPage = new TabPage();
			txtResendPostData = new TextBox();
			tabTabularPage = new TabPage();
			lvPostDataKeyValue = new ListView();
			colParaName = new ColumnHeader();
			colParaValue = new ColumnHeader();
			tabRespPage = new TabPage();
			splitConResp = new SplitContainer();
			txtRespHeaders = new TextBox();
			txtResendResponseCode = new TextBox();
			toolStripResendResponse = new ToolStrip();
			toolStripSeparator5 = new ToolStripSeparator();
			LabelResponseCode = new ToolStripLabel();
			toolStripSeparator6 = new ToolStripSeparator();
			ButtonLoadInBrowser = new ToolStripButton();
			toolStripSeparator7 = new ToolStripSeparator();
			ImageListBrowser = new ImageList(components);
			((Control)tabBrowserForm).SuspendLayout();
			((Control)tabBrowser).SuspendLayout();
			((Control)tabResend).SuspendLayout();
			((Control)tabReqResp).SuspendLayout();
			((Control)tabReqPage).SuspendLayout();
			((Control)splitRequest.get_Panel1()).SuspendLayout();
			((Control)splitRequest.get_Panel2()).SuspendLayout();
			((Control)splitRequest).SuspendLayout();
			((Control)splitConResend.get_Panel1()).SuspendLayout();
			((Control)splitConResend.get_Panel2()).SuspendLayout();
			((Control)splitConResend).SuspendLayout();
			((Control)toolStripResend).SuspendLayout();
			((Control)tabPostData).SuspendLayout();
			((Control)tabRawViewPage).SuspendLayout();
			((Control)tabTabularPage).SuspendLayout();
			((Control)tabRespPage).SuspendLayout();
			((Control)splitConResp.get_Panel1()).SuspendLayout();
			((Control)splitConResp.get_Panel2()).SuspendLayout();
			((Control)splitConResp).SuspendLayout();
			((Control)toolStripResendResponse).SuspendLayout();
			((Control)this).SuspendLayout();
			BrowserTimer.set_Interval(30000);
			BrowserTimer.add_Tick((EventHandler)BrowserTimer_Tick);
			((Control)tabBrowserForm).get_Controls().Add((Control)(object)tabBrowser);
			((Control)tabBrowserForm).get_Controls().Add((Control)(object)tabResend);
			((Control)tabBrowserForm).set_Dock((DockStyle)5);
			tabBrowserForm.set_ImageList(ImageListBrowser);
			((Control)tabBrowserForm).set_Location(new Point(0, 0));
			((Control)tabBrowserForm).set_Name("tabBrowserForm");
			tabBrowserForm.set_SelectedIndex(0);
			((Control)tabBrowserForm).set_Size(new Size(760, 450));
			((Control)tabBrowserForm).set_TabIndex(2);
			((Control)tabBrowser).get_Controls().Add((Control)(object)WCRBrowser);
			tabBrowser.set_ImageKey("ie.png");
			tabBrowser.set_Location(new Point(4, 23));
			((Control)tabBrowser).set_Name("tabBrowser");
			((Control)tabBrowser).set_Padding(new Padding(3));
			((Control)tabBrowser).set_Size(new Size(752, 423));
			tabBrowser.set_TabIndex(0);
			((Control)tabBrowser).set_Text("WebBrowser");
			tabBrowser.set_UseVisualStyleBackColor(true);
			((Control)WCRBrowser).set_Dock((DockStyle)5);
			((Control)WCRBrowser).set_Location(new Point(3, 3));
			((Control)WCRBrowser).set_Margin(new Padding(3, 4, 3, 4));
			((Control)WCRBrowser).set_MinimumSize(new Size(23, 25));
			((Control)WCRBrowser).set_Name("WCRBrowser");
			((Control)WCRBrowser).set_Size(new Size(746, 417));
			((Control)WCRBrowser).set_TabIndex(1);
			WCRBrowser.add_DocumentCompleted(new WebBrowserDocumentCompletedEventHandler(WCRBrowser_DocumentCompleted));
			WCRBrowser.add_StatusTextChanged((EventHandler)WCRBrowser_StatusTextChanged);
			((Control)tabResend).get_Controls().Add((Control)(object)tabReqResp);
			tabResend.set_ImageKey("resend.png");
			tabResend.set_Location(new Point(4, 23));
			((Control)tabResend).set_Name("tabResend");
			((Control)tabResend).set_Padding(new Padding(3));
			((Control)tabResend).set_Size(new Size(752, 423));
			tabResend.set_TabIndex(1);
			((Control)tabResend).set_Text("Resend");
			tabResend.set_UseVisualStyleBackColor(true);
			((Control)tabReqResp).get_Controls().Add((Control)(object)tabReqPage);
			((Control)tabReqResp).get_Controls().Add((Control)(object)tabRespPage);
			((Control)tabReqResp).set_Dock((DockStyle)5);
			((Control)tabReqResp).set_Location(new Point(3, 3));
			((Control)tabReqResp).set_Name("tabReqResp");
			tabReqResp.set_SelectedIndex(0);
			((Control)tabReqResp).set_Size(new Size(746, 417));
			((Control)tabReqResp).set_TabIndex(0);
			((Control)tabReqPage).get_Controls().Add((Control)(object)splitRequest);
			tabReqPage.set_Location(new Point(4, 22));
			((Control)tabReqPage).set_Name("tabReqPage");
			((Control)tabReqPage).set_Padding(new Padding(3));
			((Control)tabReqPage).set_Size(new Size(738, 391));
			tabReqPage.set_TabIndex(0);
			((Control)tabReqPage).set_Text("Request");
			tabReqPage.set_UseVisualStyleBackColor(true);
			splitRequest.set_BorderStyle((BorderStyle)1);
			splitRequest.set_Dock((DockStyle)5);
			((Control)splitRequest).set_Location(new Point(3, 3));
			((Control)splitRequest).set_Name("splitRequest");
			((Control)splitRequest.get_Panel1()).get_Controls().Add((Control)(object)listViewReqList);
			((Control)splitRequest.get_Panel2()).get_Controls().Add((Control)(object)splitConResend);
			((Control)splitRequest).set_Size(new Size(732, 385));
			splitRequest.set_SplitterDistance(193);
			((Control)splitRequest).set_TabIndex(0);
			listViewReqList.get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[2]
			{
				colMethod,
				colUrl
			});
			((Control)listViewReqList).set_Dock((DockStyle)5);
			listViewReqList.set_FullRowSelect(true);
			listViewReqList.set_GridLines(true);
			((Control)listViewReqList).set_Location(new Point(0, 0));
			listViewReqList.set_MultiSelect(false);
			((Control)listViewReqList).set_Name("listViewReqList");
			((Control)listViewReqList).set_Size(new Size(191, 383));
			((Control)listViewReqList).set_TabIndex(0);
			listViewReqList.set_UseCompatibleStateImageBehavior(false);
			listViewReqList.set_View((View)1);
			((Control)listViewReqList).add_MouseClick(new MouseEventHandler(listViewReqList_MouseClick));
			colMethod.set_Text("Method");
			colMethod.set_Width(50);
			colUrl.set_Text("URL");
			colUrl.set_Width(400);
			splitConResend.set_Dock((DockStyle)5);
			((Control)splitConResend).set_Location(new Point(0, 0));
			((Control)splitConResend).set_Name("splitConResend");
			splitConResend.set_Orientation((Orientation)0);
			((Control)splitConResend.get_Panel1()).get_Controls().Add((Control)(object)txtReqHeader);
			((Control)splitConResend.get_Panel1()).get_Controls().Add((Control)(object)toolStripResend);
			((Control)splitConResend.get_Panel2()).get_Controls().Add((Control)(object)tabPostData);
			((Control)splitConResend).set_Size(new Size(533, 383));
			splitConResend.set_SplitterDistance(70);
			((Control)splitConResend).set_TabIndex(3);
			((Control)txtReqHeader).set_Dock((DockStyle)5);
			((Control)txtReqHeader).set_Location(new Point(0, 25));
			((TextBoxBase)txtReqHeader).set_Multiline(true);
			((Control)txtReqHeader).set_Name("txtReqHeader");
			((TextBoxBase)txtReqHeader).set_ReadOnly(true);
			((Control)txtReqHeader).set_Size(new Size(533, 45));
			((Control)txtReqHeader).set_TabIndex(3);
			toolStripResend.set_BackColor(SystemColors.get_ButtonFace());
			toolStripResend.set_GripStyle((ToolStripGripStyle)0);
			toolStripResend.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[8]
			{
				(ToolStripItem)toolStripSeparator4,
				(ToolStripItem)lblMethond,
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)txtResendURL,
				(ToolStripItem)toolStripSeparator2,
				(ToolStripItem)ButtonResend,
				(ToolStripItem)toolStripSeparator3,
				(ToolStripItem)btnBruter
			});
			((Control)toolStripResend).set_Location(new Point(0, 0));
			((Control)toolStripResend).set_Name("toolStripResend");
			((Control)toolStripResend).set_Size(new Size(533, 25));
			((Control)toolStripResend).set_TabIndex(0);
			((Control)toolStripResend).set_Text("toolStrip1");
			((Control)toolStripResend).add_Resize((EventHandler)toolStripResend_Resize);
			((ToolStripItem)toolStripSeparator4).set_Name("toolStripSeparator4");
			((ToolStripItem)toolStripSeparator4).set_Size(new Size(6, 25));
			((ToolStripItem)lblMethond).set_Name("lblMethond");
			((ToolStripItem)lblMethond).set_Size(new Size(24, 22));
			((ToolStripItem)lblMethond).set_Text("    ");
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 25));
			((ToolStripItem)txtResendURL).set_AutoSize(false);
			((ToolStripItem)txtResendURL).set_Name("txtResendURL");
			((ToolStripItem)txtResendURL).set_Overflow((ToolStripItemOverflow)0);
			((ToolStripItem)txtResendURL).set_Size(new Size(320, 25));
			((ToolStripItem)txtResendURL).add_DoubleClick((EventHandler)txtResendURL_DoubleClick);
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			((ToolStripItem)ButtonResend).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)ButtonResend).set_Image((Image)((ResourceManager)(object)val).GetObject("ButtonResend.Image"));
			((ToolStripItem)ButtonResend).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonResend).set_Name("ButtonResend");
			((ToolStripItem)ButtonResend).set_Size(new Size(55, 22));
			((ToolStripItem)ButtonResend).set_Text("Resend");
			((ToolStripItem)ButtonResend).add_Click((EventHandler)ButtonResend_Click);
			((ToolStripItem)toolStripSeparator3).set_Name("toolStripSeparator3");
			((ToolStripItem)toolStripSeparator3).set_Size(new Size(6, 25));
			((ToolStripItem)btnBruter).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnBruter).set_Image((Image)((ResourceManager)(object)val).GetObject("btnBruter.Image"));
			((ToolStripItem)btnBruter).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnBruter).set_Name("btnBruter");
			((ToolStripItem)btnBruter).set_Size(new Size(48, 22));
			((ToolStripItem)btnBruter).set_Text("Bruter");
			((ToolStripItem)btnBruter).set_ToolTipText("Bruter using username/password dictionary.");
			((ToolStripItem)btnBruter).add_Click((EventHandler)btnBruter_Click);
			tabPostData.set_Alignment((TabAlignment)1);
			((Control)tabPostData).get_Controls().Add((Control)(object)tabRawViewPage);
			((Control)tabPostData).get_Controls().Add((Control)(object)tabTabularPage);
			((Control)tabPostData).set_Dock((DockStyle)5);
			((Control)tabPostData).set_Location(new Point(0, 0));
			((Control)tabPostData).set_Name("tabPostData");
			tabPostData.set_SelectedIndex(0);
			((Control)tabPostData).set_Size(new Size(533, 309));
			((Control)tabPostData).set_TabIndex(3);
			tabPostData.add_SelectedIndexChanged((EventHandler)tabPostData_SelectedIndexChanged);
			((Control)tabRawViewPage).get_Controls().Add((Control)(object)txtResendPostData);
			tabRawViewPage.set_Location(new Point(4, 4));
			((Control)tabRawViewPage).set_Name("tabRawViewPage");
			((Control)tabRawViewPage).set_Padding(new Padding(3));
			((Control)tabRawViewPage).set_Size(new Size(525, 283));
			tabRawViewPage.set_TabIndex(0);
			((Control)tabRawViewPage).set_Text("RawView");
			tabRawViewPage.set_UseVisualStyleBackColor(true);
			((Control)txtResendPostData).set_Dock((DockStyle)5);
			((Control)txtResendPostData).set_Location(new Point(3, 3));
			((TextBoxBase)txtResendPostData).set_Multiline(true);
			((Control)txtResendPostData).set_Name("txtResendPostData");
			((Control)txtResendPostData).set_Size(new Size(519, 277));
			((Control)txtResendPostData).set_TabIndex(0);
			((Control)tabTabularPage).get_Controls().Add((Control)(object)lvPostDataKeyValue);
			tabTabularPage.set_Location(new Point(4, 4));
			((Control)tabTabularPage).set_Name("tabTabularPage");
			((Control)tabTabularPage).set_Padding(new Padding(3));
			((Control)tabTabularPage).set_Size(new Size(525, 283));
			tabTabularPage.set_TabIndex(1);
			((Control)tabTabularPage).set_Text("TabularView");
			tabTabularPage.set_UseVisualStyleBackColor(true);
			lvPostDataKeyValue.get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[2]
			{
				colParaName,
				colParaValue
			});
			((Control)lvPostDataKeyValue).set_Dock((DockStyle)5);
			lvPostDataKeyValue.set_FullRowSelect(true);
			((Control)lvPostDataKeyValue).set_Location(new Point(3, 3));
			lvPostDataKeyValue.set_MultiSelect(false);
			((Control)lvPostDataKeyValue).set_Name("lvPostDataKeyValue");
			((Control)lvPostDataKeyValue).set_Size(new Size(519, 277));
			((Control)lvPostDataKeyValue).set_TabIndex(0);
			lvPostDataKeyValue.set_UseCompatibleStateImageBehavior(false);
			lvPostDataKeyValue.set_View((View)1);
			((Control)lvPostDataKeyValue).add_MouseDoubleClick(new MouseEventHandler(lvPostDataKeyValue_MouseDoubleClick));
			colParaName.set_Text("ParameterName");
			colParaName.set_Width(120);
			colParaValue.set_Text("ParameterValue");
			colParaValue.set_Width(380);
			((Control)tabRespPage).get_Controls().Add((Control)(object)splitConResp);
			tabRespPage.set_Location(new Point(4, 22));
			((Control)tabRespPage).set_Name("tabRespPage");
			((Control)tabRespPage).set_Padding(new Padding(3));
			((Control)tabRespPage).set_Size(new Size(738, 391));
			tabRespPage.set_TabIndex(1);
			((Control)tabRespPage).set_Text("Response");
			tabRespPage.set_UseVisualStyleBackColor(true);
			splitConResp.set_Dock((DockStyle)5);
			((Control)splitConResp).set_Location(new Point(3, 3));
			((Control)splitConResp).set_Name("splitConResp");
			splitConResp.set_Orientation((Orientation)0);
			((Control)splitConResp.get_Panel1()).get_Controls().Add((Control)(object)txtRespHeaders);
			((Control)splitConResp.get_Panel2()).get_Controls().Add((Control)(object)txtResendResponseCode);
			((Control)splitConResp.get_Panel2()).get_Controls().Add((Control)(object)toolStripResendResponse);
			((Control)splitConResp).set_Size(new Size(732, 385));
			splitConResp.set_SplitterDistance(80);
			((Control)splitConResp).set_TabIndex(0);
			((Control)txtRespHeaders).set_Dock((DockStyle)5);
			((Control)txtRespHeaders).set_Location(new Point(0, 0));
			((TextBoxBase)txtRespHeaders).set_Multiline(true);
			((Control)txtRespHeaders).set_Name("txtRespHeaders");
			((TextBoxBase)txtRespHeaders).set_ReadOnly(true);
			txtRespHeaders.set_ScrollBars((ScrollBars)2);
			((Control)txtRespHeaders).set_Size(new Size(732, 80));
			((Control)txtRespHeaders).set_TabIndex(0);
			((Control)txtResendResponseCode).set_Dock((DockStyle)5);
			((Control)txtResendResponseCode).set_Location(new Point(0, 0));
			((TextBoxBase)txtResendResponseCode).set_Multiline(true);
			((Control)txtResendResponseCode).set_Name("txtResendResponseCode");
			txtResendResponseCode.set_ScrollBars((ScrollBars)3);
			((Control)txtResendResponseCode).set_Size(new Size(732, 276));
			((Control)txtResendResponseCode).set_TabIndex(0);
			toolStripResendResponse.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripResendResponse).set_Dock((DockStyle)2);
			toolStripResendResponse.set_GripStyle((ToolStripGripStyle)0);
			toolStripResendResponse.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[5]
			{
				(ToolStripItem)toolStripSeparator5,
				(ToolStripItem)LabelResponseCode,
				(ToolStripItem)toolStripSeparator6,
				(ToolStripItem)ButtonLoadInBrowser,
				(ToolStripItem)toolStripSeparator7
			});
			((Control)toolStripResendResponse).set_Location(new Point(0, 276));
			((Control)toolStripResendResponse).set_Name("toolStripResendResponse");
			((Control)toolStripResendResponse).set_Size(new Size(732, 25));
			((Control)toolStripResendResponse).set_TabIndex(2);
			((Control)toolStripResendResponse).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator5).set_Name("toolStripSeparator5");
			((ToolStripItem)toolStripSeparator5).set_Size(new Size(6, 25));
			((ToolStripItem)LabelResponseCode).set_AutoSize(false);
			((ToolStripItem)LabelResponseCode).set_Name("LabelResponseCode");
			((ToolStripItem)LabelResponseCode).set_Size(new Size(150, 22));
			((ToolStripItem)LabelResponseCode).set_Text("StatusCode");
			((ToolStripItem)LabelResponseCode).set_TextAlign((ContentAlignment)16);
			((ToolStripItem)toolStripSeparator6).set_Name("toolStripSeparator6");
			((ToolStripItem)toolStripSeparator6).set_Size(new Size(6, 25));
			((ToolStripItem)ButtonLoadInBrowser).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)ButtonLoadInBrowser).set_Image((Image)((ResourceManager)(object)val).GetObject("ButtonLoadInBrowser.Image"));
			((ToolStripItem)ButtonLoadInBrowser).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonLoadInBrowser).set_Name("ButtonLoadInBrowser");
			((ToolStripItem)ButtonLoadInBrowser).set_Size(new Size(134, 22));
			((ToolStripItem)ButtonLoadInBrowser).set_Text("Load in WebBrowser");
			((ToolStripItem)ButtonLoadInBrowser).add_Click((EventHandler)ButtonLoadInBrowser_Click);
			((ToolStripItem)toolStripSeparator7).set_Name("toolStripSeparator7");
			((ToolStripItem)toolStripSeparator7).set_Size(new Size(6, 25));
			ImageListBrowser.set_ImageStream((ImageListStreamer)((ResourceManager)(object)val).GetObject("ImageListBrowser.ImageStream"));
			ImageListBrowser.set_TransparentColor(Color.get_Transparent());
			ImageListBrowser.get_Images().SetKeyName(0, "ie.png");
			ImageListBrowser.get_Images().SetKeyName(1, "resend.png");
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(760, 450));
			((Control)this).get_Controls().Add((Control)(object)tabBrowserForm);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormBrowser");
			((Control)this).set_Text("WebBrowser");
			((Control)tabBrowserForm).ResumeLayout(false);
			((Control)tabBrowser).ResumeLayout(false);
			((Control)tabResend).ResumeLayout(false);
			((Control)tabReqResp).ResumeLayout(false);
			((Control)tabReqPage).ResumeLayout(false);
			((Control)splitRequest.get_Panel1()).ResumeLayout(false);
			((Control)splitRequest.get_Panel2()).ResumeLayout(false);
			((Control)splitRequest).ResumeLayout(false);
			((Control)splitConResend.get_Panel1()).ResumeLayout(false);
			((Control)splitConResend.get_Panel1()).PerformLayout();
			((Control)splitConResend.get_Panel2()).ResumeLayout(false);
			((Control)splitConResend).ResumeLayout(false);
			((Control)toolStripResend).ResumeLayout(false);
			((Control)toolStripResend).PerformLayout();
			((Control)tabPostData).ResumeLayout(false);
			((Control)tabRawViewPage).ResumeLayout(false);
			((Control)tabRawViewPage).PerformLayout();
			((Control)tabTabularPage).ResumeLayout(false);
			((Control)tabRespPage).ResumeLayout(false);
			((Control)splitConResp.get_Panel1()).ResumeLayout(false);
			((Control)splitConResp.get_Panel1()).PerformLayout();
			((Control)splitConResp.get_Panel2()).ResumeLayout(false);
			((Control)splitConResp.get_Panel2()).PerformLayout();
			((Control)splitConResp).ResumeLayout(false);
			((Control)toolStripResendResponse).ResumeLayout(false);
			((Control)toolStripResendResponse).PerformLayout();
			((Control)this).ResumeLayout(false);
		}
	}
}
