using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Resources;
using System.Windows.Forms;
using Microsoft.Win32;

namespace WebCruiserWVS
{
	public class FormAbout : Form
	{
		private FormMain mainfrm;

		private IContainer components;

		private SplitContainer splitAbout;

		private TextBox txtHelp;

		private Label lblRegInfo;

		private Button btnReg;

		private TextBox txtRegCode;

		private TextBox txtRegUsername;

		private Label lblRegCode;

		private Label lblRegUsername;

		private LinkLabel linkLabelSite2;

		private LinkLabel linkLabelMail;

		private LinkLabel linkAvangate;

		public FormAbout(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
		}

		public void InitRegControl()
		{
			//IL_0113: Unknown result type (might be due to invalid IL or missing references)
			if (WCRSetting.wvsEdition == WVSEdition.Free)
			{
				((Control)lblRegInfo).set_Visible(false);
				((Control)lblRegUsername).set_Visible(false);
				((Control)lblRegCode).set_Visible(false);
				((Control)txtRegUsername).set_Visible(false);
				((Control)txtRegCode).set_Visible(false);
				((Control)btnReg).set_Visible(false);
				((Control)linkAvangate).set_Visible(false);
				return;
			}
			if (Reg.A1K3)
			{
				((Control)lblRegInfo).set_Text("This copy of WebCruiser is licensed to: " + Reg.RegUser);
				((Control)lblRegUsername).set_Visible(false);
				((Control)lblRegCode).set_Visible(false);
				((Control)txtRegUsername).set_Visible(false);
				((Control)txtRegCode).set_Visible(false);
				((Control)btnReg).set_Visible(false);
				((Control)linkAvangate).set_Visible(false);
			}
			else if (Reg.LeftDays > 0)
			{
				((Control)lblRegInfo).set_Text("This Copy of WebCruiser is UnRegistered! You can use it for " + Reg.LeftDays + " days.");
			}
			else
			{
				((Control)lblRegInfo).set_Text("This Copy of WebCruiser is UnRegistered and Expired! Please Register If You Would Like To Continue Using It!");
				MessageBox.Show("This Copy of WebCruiser is UnRegistered and Expired! Please Register If You Would Like To Continue Using It!", "", (MessageBoxButtons)0, (MessageBoxIcon)48);
			}
			mainfrm.InitFunctionByRegistration(Reg.A1K3, Reg.LeftDays);
		}

		private void btnReg_Click(object sender, EventArgs e)
		{
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_0132: Unknown result type (might be due to invalid IL or missing references)
			string text = ((Control)txtRegUsername).get_Text().Trim();
			if (string.IsNullOrEmpty(text) || text.Length < 2)
			{
				MessageBox.Show("Username should has at least 2 letters!");
				return;
			}
			string text2 = ((Control)txtRegCode).get_Text();
			if (string.IsNullOrEmpty(text2))
			{
				MessageBox.Show("RegCode can not be null!");
			}
			else if (Reg.ValidateRegCode(text, text2) || Reg.ValidateRegCode2(text, text2))
			{
				RegistryKey val = Registry.CurrentUser.CreateSubKey("Software\\Sec4App\\WebCruiser");
				val.SetValue("Username", (object)text);
				val.SetValue("RegCode", (object)text2);
				string toEncrypt = DateTime.Now.ToString("yyyy-MM-dd");
				toEncrypt = Reg.Encrypt(toEncrypt);
				val.SetValue("InitDate", (object)toEncrypt);
				((Control)lblRegInfo).set_Text("This copy of WebCruiser is licensed to: " + text);
				MessageBox.Show("Thank You For Registration!", "Registration OK!");
				((Control)lblRegUsername).set_Visible(false);
				((Control)lblRegCode).set_Visible(false);
				((Control)txtRegUsername).set_Visible(false);
				((Control)txtRegCode).set_Visible(false);
				((Control)btnReg).set_Visible(false);
				((Control)linkAvangate).set_Visible(false);
				Reg.A1K3 = true;
				Reg.RegUser = text;
			}
			else
			{
				MessageBox.Show("Invalid RegCode !");
			}
		}

		private void linkLblSite_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			string text = "http://www.janusec.com/";
			try
			{
				Process.Start(text);
			}
			catch
			{
				mainfrm.NavigatePage(text, RequestType.GET, "");
			}
		}

		private void linkLabelSite2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			string text = "https://www.janusec.com/";
			try
			{
				Process.Start(text);
			}
			catch
			{
				mainfrm.NavigatePage(text, RequestType.GET, "");
			}
		}

		private void linkLabelMail_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			string text = "mailto:support@janusec.com?subject=WebCruiserWVS";
			try
			{
				Process.Start(text);
			}
			catch
			{
			}
		}

		private void linkAvangate_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			//IL_0057: Unknown result type (might be due to invalid IL or missing references)
			linkAvangate.set_LinkVisited(true);
			string text = "";
			if (WCRSetting.wvsEdition == WVSEdition.Enterprise)
			{
				text = "https://secure.avangate.com/order/checkout.php?PRODS=4540841&QTY=1&CART=1";
			}
			else if (WCRSetting.wvsEdition == WVSEdition.Personal)
			{
				text = "https://secure.avangate.com/order/checkout.php?PRODS=4540814&QTY=1&CART=1";
			}
			try
			{
				Process.Start(text);
			}
			catch
			{
				Clipboard.SetText(text);
				MessageBox.Show("* Default browser not found, please open the following URL for order information.\r\n* " + text + "\r\n* This URL has been set to ClipBoard and you can paste it to you browser directly.", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
			}
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_000a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0010: Expected O, but got Unknown
			//IL_0011: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0053: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Expected O, but got Unknown
			//IL_005e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0068: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_0073: Expected O, but got Unknown
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_007e: Expected O, but got Unknown
			//IL_007f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0089: Expected O, but got Unknown
			//IL_00d9: Unknown result type (might be due to invalid IL or missing references)
			//IL_021d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0249: Unknown result type (might be due to invalid IL or missing references)
			//IL_0267: Unknown result type (might be due to invalid IL or missing references)
			//IL_0278: Unknown result type (might be due to invalid IL or missing references)
			//IL_02c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_030c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0330: Unknown result type (might be due to invalid IL or missing references)
			//IL_0370: Unknown result type (might be due to invalid IL or missing references)
			//IL_037a: Expected O, but got Unknown
			//IL_038f: Unknown result type (might be due to invalid IL or missing references)
			//IL_03b3: Unknown result type (might be due to invalid IL or missing references)
			//IL_03f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_03fd: Expected O, but got Unknown
			//IL_0412: Unknown result type (might be due to invalid IL or missing references)
			//IL_0439: Unknown result type (might be due to invalid IL or missing references)
			//IL_0479: Unknown result type (might be due to invalid IL or missing references)
			//IL_0483: Expected O, but got Unknown
			//IL_0490: Unknown result type (might be due to invalid IL or missing references)
			//IL_04b4: Unknown result type (might be due to invalid IL or missing references)
			//IL_050b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0532: Unknown result type (might be due to invalid IL or missing references)
			//IL_0556: Unknown result type (might be due to invalid IL or missing references)
			//IL_057d: Unknown result type (might be due to invalid IL or missing references)
			//IL_05ad: Unknown result type (might be due to invalid IL or missing references)
			//IL_05d1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0611: Unknown result type (might be due to invalid IL or missing references)
			//IL_0635: Unknown result type (might be due to invalid IL or missing references)
			//IL_0671: Unknown result type (might be due to invalid IL or missing references)
			//IL_0698: Unknown result type (might be due to invalid IL or missing references)
			//IL_06c9: Unknown result type (might be due to invalid IL or missing references)
			//IL_06e5: Unknown result type (might be due to invalid IL or missing references)
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormAbout));
			splitAbout = new SplitContainer();
			txtHelp = new TextBox();
			linkAvangate = new LinkLabel();
			linkLabelMail = new LinkLabel();
			linkLabelSite2 = new LinkLabel();
			btnReg = new Button();
			txtRegCode = new TextBox();
			txtRegUsername = new TextBox();
			lblRegCode = new Label();
			lblRegUsername = new Label();
			lblRegInfo = new Label();
			((ISupportInitialize)splitAbout).BeginInit();
			((Control)splitAbout.get_Panel1()).SuspendLayout();
			((Control)splitAbout.get_Panel2()).SuspendLayout();
			((Control)splitAbout).SuspendLayout();
			((Control)this).SuspendLayout();
			splitAbout.set_Dock((DockStyle)5);
			((Control)splitAbout).set_Location(new Point(0, 0));
			((Control)splitAbout).set_Name("splitAbout");
			splitAbout.set_Orientation((Orientation)0);
			((Control)splitAbout.get_Panel1()).get_Controls().Add((Control)(object)txtHelp);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)linkAvangate);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)linkLabelMail);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)linkLabelSite2);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)btnReg);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)txtRegCode);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)txtRegUsername);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)lblRegCode);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)lblRegUsername);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)lblRegInfo);
			((Control)splitAbout).set_Size(new Size(634, 371));
			splitAbout.set_SplitterDistance(257);
			((Control)splitAbout).set_TabIndex(0);
			((Control)txtHelp).set_BackColor(SystemColors.get_Control());
			((Control)txtHelp).set_Dock((DockStyle)5);
			((Control)txtHelp).set_Location(new Point(0, 0));
			((Control)txtHelp).set_Margin(new Padding(2));
			((TextBoxBase)txtHelp).set_Multiline(true);
			((Control)txtHelp).set_Name("txtHelp");
			((TextBoxBase)txtHelp).set_ReadOnly(true);
			txtHelp.set_ScrollBars((ScrollBars)2);
			((Control)txtHelp).set_Size(new Size(634, 257));
			((Control)txtHelp).set_TabIndex(9);
			((Control)txtHelp).set_Text(((ResourceManager)(object)val).GetString("txtHelp.Text"));
			((Control)linkAvangate).set_AutoSize(true);
			((Control)linkAvangate).set_Location(new Point(478, 86));
			((Control)linkAvangate).set_Name("linkAvangate");
			((Control)linkAvangate).set_Size(new Size(107, 12));
			((Control)linkAvangate).set_TabIndex(21);
			linkAvangate.set_TabStop(true);
			((Control)linkAvangate).set_Text("Buy from Avangate");
			linkAvangate.add_LinkClicked(new LinkLabelLinkClickedEventHandler(linkAvangate_LinkClicked));
			((Control)linkLabelMail).set_AutoSize(true);
			((Control)linkLabelMail).set_Location(new Point(3, 82));
			((Control)linkLabelMail).set_Name("linkLabelMail");
			((Control)linkLabelMail).set_Size(new Size(119, 12));
			((Control)linkLabelMail).set_TabIndex(20);
			linkLabelMail.set_TabStop(true);
			((Control)linkLabelMail).set_Text("support@janusec.com");
			linkLabelMail.add_LinkClicked(new LinkLabelLinkClickedEventHandler(linkLabelMail_LinkClicked));
			((Control)linkLabelSite2).set_AutoSize(true);
			((Control)linkLabelSite2).set_Location(new Point(3, 59));
			((Control)linkLabelSite2).set_Name("linkLabelSite2");
			((Control)linkLabelSite2).set_Size(new Size(143, 12));
			((Control)linkLabelSite2).set_TabIndex(19);
			linkLabelSite2.set_TabStop(true);
			((Control)linkLabelSite2).set_Text("https://www.janusec.com");
			linkLabelSite2.add_LinkClicked(new LinkLabelLinkClickedEventHandler(linkLabelSite2_LinkClicked));
			((Control)btnReg).set_Location(new Point(394, 81));
			((Control)btnReg).set_Name("btnReg");
			((Control)btnReg).set_Size(new Size(75, 23));
			((Control)btnReg).set_TabIndex(17);
			((Control)btnReg).set_Text("Register");
			((ButtonBase)btnReg).set_UseVisualStyleBackColor(true);
			((Control)btnReg).add_Click((EventHandler)btnReg_Click);
			((Control)txtRegCode).set_Location(new Point(394, 56));
			((Control)txtRegCode).set_Name("txtRegCode");
			((Control)txtRegCode).set_Size(new Size(193, 21));
			((Control)txtRegCode).set_TabIndex(16);
			((Control)txtRegUsername).set_Location(new Point(394, 30));
			((Control)txtRegUsername).set_Name("txtRegUsername");
			((Control)txtRegUsername).set_Size(new Size(193, 21));
			((Control)txtRegUsername).set_TabIndex(15);
			((Control)lblRegCode).set_AutoSize(true);
			((Control)lblRegCode).set_Location(new Point(321, 59));
			((Control)lblRegCode).set_Name("lblRegCode");
			((Control)lblRegCode).set_Size(new Size(53, 12));
			((Control)lblRegCode).set_TabIndex(14);
			((Control)lblRegCode).set_Text("RegCode:");
			((Control)lblRegUsername).set_AutoSize(true);
			((Control)lblRegUsername).set_Location(new Point(321, 33));
			((Control)lblRegUsername).set_Name("lblRegUsername");
			((Control)lblRegUsername).set_Size(new Size(59, 12));
			((Control)lblRegUsername).set_TabIndex(13);
			((Control)lblRegUsername).set_Text("Username:");
			((Control)lblRegInfo).set_AutoSize(true);
			((Control)lblRegInfo).set_Location(new Point(3, 10));
			((Control)lblRegInfo).set_Name("lblRegInfo");
			((Control)lblRegInfo).set_Size(new Size(461, 12));
			((Control)lblRegInfo).set_TabIndex(1);
			((Control)lblRegInfo).set_Text("This Copy of WebCruiser is UnRegistered! You can use it for another 30 days.");
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(634, 371));
			((Control)this).get_Controls().Add((Control)(object)splitAbout);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormAbout");
			((Control)this).set_Text("FormAbout");
			((Control)splitAbout.get_Panel1()).ResumeLayout(false);
			((Control)splitAbout.get_Panel1()).PerformLayout();
			((Control)splitAbout.get_Panel2()).ResumeLayout(false);
			((Control)splitAbout.get_Panel2()).PerformLayout();
			((ISupportInitialize)splitAbout).EndInit();
			((Control)splitAbout).ResumeLayout(false);
			((Control)this).ResumeLayout(false);
		}
	}
}
