using System;

namespace WebCruiserWVS
{
	[Serializable]
	public class VulnSQLInjection : Vulnerability
	{
		public InjectMethod vulnInjectMethod;

		public ParameterType vulnParameterType;

		public string vulnKeyword;

		public string vulnLogicOperator;

		public string vulnPrefix;

		public string vulnPostfix;

		public string vulnPocUrlString;

		public DBType vulnDatabaseType;

		public string vulnRegex;

		public int maxItemLength;

		public bool needEscapeSpace;

		public int unionFieldsCount;

		public int unionFieldIndex;

		public double t0InMs;

		public bool shouldSource1EqualsSource0;

		public VulnSQLInjection(RequestType requestType, string actionUrl, string referUrl, string parameter, InjectMethod injMethod, ParameterType ParameterType, string keyword, string description, string logicOperator, string prefix, string postfix, string pocUrlString, DBType dbType, string regex, int maxLength, bool escapeSpace)
		{
			vulnType = VulnType.SQLInjection;
			vulnRequestType = requestType;
			vulnActionUrl = actionUrl;
			vulnReferUrl = referUrl;
			vulnParameter = parameter;
			vulnInjectMethod = injMethod;
			vulnParameterType = ParameterType;
			vulnKeyword = keyword;
			vulnDescription = description;
			vulnLogicOperator = logicOperator;
			vulnPrefix = prefix;
			vulnPostfix = postfix;
			vulnPocUrlString = pocUrlString;
			vulnDatabaseType = dbType;
			vulnRegex = regex;
			maxItemLength = maxLength;
			needEscapeSpace = escapeSpace;
		}
	}
}
