using System;
using System.ComponentModel;
using System.Drawing;
using System.Resources;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	public class FormValue : Form
	{
		private IContainer components;

		private Label lblKey;

		private Button btnOK;

		private TextBox txtValue;

		public string value => ((Control)txtValue).get_Text();

		public FormValue(string key, string oldValue)
			: this()
		{
			InitializeComponent();
			((Control)lblKey).set_Text(key + ":");
			((Control)txtValue).set_Text(oldValue);
		}

		private void btnOK_Click(object sender, EventArgs e)
		{
			((Form)this).set_DialogResult((DialogResult)1);
		}

		private void txtValue_KeyPress(object sender, KeyPressEventArgs e)
		{
			if (e.get_KeyChar() == '\r')
			{
				((Form)this).set_DialogResult((DialogResult)1);
			}
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_000a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0010: Expected O, but got Unknown
			//IL_0011: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_004b: Unknown result type (might be due to invalid IL or missing references)
			//IL_006f: Unknown result type (might be due to invalid IL or missing references)
			//IL_00af: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d3: Unknown result type (might be due to invalid IL or missing references)
			//IL_0125: Unknown result type (might be due to invalid IL or missing references)
			//IL_014c: Unknown result type (might be due to invalid IL or missing references)
			//IL_016f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0179: Expected O, but got Unknown
			//IL_0184: Unknown result type (might be due to invalid IL or missing references)
			//IL_019d: Unknown result type (might be due to invalid IL or missing references)
			//IL_01e6: Unknown result type (might be due to invalid IL or missing references)
			//IL_01f0: Expected O, but got Unknown
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormValue));
			lblKey = new Label();
			btnOK = new Button();
			txtValue = new TextBox();
			((Control)this).SuspendLayout();
			((Control)lblKey).set_AutoSize(true);
			((Control)lblKey).set_Location(new Point(7, 3));
			((Control)lblKey).set_Name("lblKey");
			((Control)lblKey).set_Size(new Size(35, 12));
			((Control)lblKey).set_TabIndex(5);
			((Control)lblKey).set_Text("Key :");
			lblKey.set_TextAlign((ContentAlignment)16);
			((Control)btnOK).set_Location(new Point(479, 18));
			((Control)btnOK).set_Name("btnOK");
			((Control)btnOK).set_Size(new Size(75, 23));
			((Control)btnOK).set_TabIndex(4);
			((Control)btnOK).set_Text("OK");
			((ButtonBase)btnOK).set_UseVisualStyleBackColor(true);
			((Control)btnOK).add_Click((EventHandler)btnOK_Click);
			((Control)txtValue).set_Location(new Point(7, 19));
			((Control)txtValue).set_Name("txtValue");
			((Control)txtValue).set_Size(new Size(466, 21));
			((Control)txtValue).set_TabIndex(3);
			((Control)txtValue).add_KeyPress(new KeyPressEventHandler(txtValue_KeyPress));
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(566, 49));
			((Control)this).get_Controls().Add((Control)(object)lblKey);
			((Control)this).get_Controls().Add((Control)(object)btnOK);
			((Control)this).get_Controls().Add((Control)(object)txtValue);
			((Form)this).set_Icon((Icon)((ResourceManager)(object)val).GetObject("$this.Icon"));
			((Form)this).set_MaximizeBox(false);
			((Form)this).set_MinimizeBox(false);
			((Control)this).set_Name("FormValue");
			((Form)this).set_ShowInTaskbar(false);
			((Form)this).set_StartPosition((FormStartPosition)4);
			((Control)this).set_Text("Input new value");
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
