using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	public class FormPOC : Form
	{
		private FormMain mainfrm;

		private Vulnerability currentVuln;

		private IContainer components;

		private TextBox txtRefPage;

		private Label label19;

		private TextBox txtActionURL;

		private Label label20;

		private TextBox txtXSSUsage;

		private Button btnOpenRefPage;

		private Button btnXSSTest;

		public FormPOC(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
		}

		private void btnXSSTest_Click(object sender, EventArgs e)
		{
			switch (currentVuln.vulnType)
			{
			case VulnType.XSS:
				DoXSSTest();
				break;
			case VulnType.LFI:
			case VulnType.RFI:
			case VulnType.Redirect:
				DoFITest();
				break;
			}
		}

		private void DoXSSTest()
		{
			string text = "";
			string text2 = ((Control)txtActionURL).get_Text().Trim();
			text2.IndexOf('^');
			text2.IndexOf('=');
			VulnXSS vulnXSS = currentVuln as VulnXSS;
			RequestType vulnRequestType = currentVuln.vulnRequestType;
			if (vulnRequestType == RequestType.COOKIE)
			{
				text = mainfrm.CurrentSite.GetSourceCodeWithCookieOption(text2, RequestType.COOKIE, vulnXSS.vulnNeedEscapeCookie);
			}
			else
			{
				WebForm webForm = new WebForm(text2, currentVuln.vulnReferUrl, currentVuln.vulnPostEncType);
				text = mainfrm.CurrentSite.GetSourceCodeByReplaceCsrfCode(text2, vulnRequestType, isDetectCsrf: true, webForm);
			}
			mainfrm.UpdateCodeText(text);
			mainfrm.SelectTool("Code");
		}

		private void DoFITest()
		{
			string text = "";
			string text2 = ((Control)txtActionURL).get_Text().Trim();
			text2.IndexOf('^');
			text2.IndexOf('=');
			RequestType vulnRequestType = currentVuln.vulnRequestType;
			WebForm webForm = new WebForm(text2, currentVuln.vulnReferUrl, currentVuln.vulnPostEncType);
			text = mainfrm.CurrentSite.GetSourceCodeByReplaceCsrfCode(text2, vulnRequestType, isDetectCsrf: true, webForm);
			mainfrm.UpdateCodeText(text);
			mainfrm.SelectTool("Code");
		}

		private void btnOpenRefPage_Click(object sender, EventArgs e)
		{
			string text = ((Control)txtRefPage).get_Text();
			if (!string.IsNullOrEmpty(text))
			{
				mainfrm.NavigatePage(((Control)txtRefPage).get_Text(), RequestType.GET, "");
			}
		}

		public void ExecPOC(Vulnerability vuln)
		{
			currentVuln = vuln;
			((Control)txtRefPage).set_Text(vuln.vulnReferUrl);
			((Control)txtActionURL).set_Text(vuln.vulnActionUrl);
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_000c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0016: Expected O, but got Unknown
			//IL_0017: Unknown result type (might be due to invalid IL or missing references)
			//IL_0021: Expected O, but got Unknown
			//IL_0022: Unknown result type (might be due to invalid IL or missing references)
			//IL_002c: Expected O, but got Unknown
			//IL_002d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0037: Expected O, but got Unknown
			//IL_0038: Unknown result type (might be due to invalid IL or missing references)
			//IL_0042: Expected O, but got Unknown
			//IL_0043: Unknown result type (might be due to invalid IL or missing references)
			//IL_004d: Expected O, but got Unknown
			//IL_005c: Unknown result type (might be due to invalid IL or missing references)
			//IL_008f: Unknown result type (might be due to invalid IL or missing references)
			//IL_00bb: Unknown result type (might be due to invalid IL or missing references)
			//IL_00df: Unknown result type (might be due to invalid IL or missing references)
			//IL_010f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0145: Unknown result type (might be due to invalid IL or missing references)
			//IL_0171: Unknown result type (might be due to invalid IL or missing references)
			//IL_0198: Unknown result type (might be due to invalid IL or missing references)
			//IL_01cb: Unknown result type (might be due to invalid IL or missing references)
			//IL_020a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0241: Unknown result type (might be due to invalid IL or missing references)
			//IL_0265: Unknown result type (might be due to invalid IL or missing references)
			//IL_02bb: Unknown result type (might be due to invalid IL or missing references)
			//IL_02df: Unknown result type (might be due to invalid IL or missing references)
			//IL_0334: Unknown result type (might be due to invalid IL or missing references)
			//IL_0350: Unknown result type (might be due to invalid IL or missing references)
			txtRefPage = new TextBox();
			label19 = new Label();
			txtActionURL = new TextBox();
			label20 = new Label();
			txtXSSUsage = new TextBox();
			btnOpenRefPage = new Button();
			btnXSSTest = new Button();
			((Control)this).SuspendLayout();
			((Control)txtRefPage).set_Location(new Point(5, 29));
			((Control)txtRefPage).set_Name("txtRefPage");
			((TextBoxBase)txtRefPage).set_ReadOnly(true);
			((Control)txtRefPage).set_Size(new Size(733, 21));
			((Control)txtRefPage).set_TabIndex(19);
			((Control)label19).set_AutoSize(true);
			((Control)label19).set_Location(new Point(5, 9));
			((Control)label19).set_Name("label19");
			((Control)label19).set_Size(new Size(71, 12));
			((Control)label19).set_TabIndex(18);
			((Control)label19).set_Text("Refer Page:");
			((Control)txtActionURL).set_Location(new Point(5, 70));
			((TextBoxBase)txtActionURL).set_Multiline(true);
			((Control)txtActionURL).set_Name("txtActionURL");
			((Control)txtActionURL).set_Size(new Size(733, 216));
			((Control)txtActionURL).set_TabIndex(17);
			((Control)label20).set_AutoSize(true);
			((Control)label20).set_Location(new Point(5, 55));
			((Control)label20).set_Name("label20");
			((Control)label20).set_Size(new Size(299, 12));
			((Control)label20).set_TabIndex(16);
			((Control)label20).set_Text("ActionURL( ? for Get, and  ^ for POST or Cookie):");
			((Control)txtXSSUsage).set_Location(new Point(5, 358));
			((TextBoxBase)txtXSSUsage).set_Multiline(true);
			((Control)txtXSSUsage).set_Name("txtXSSUsage");
			((TextBoxBase)txtXSSUsage).set_ReadOnly(true);
			((Control)txtXSSUsage).set_Size(new Size(733, 73));
			((Control)txtXSSUsage).set_TabIndex(24);
			((Control)txtXSSUsage).set_Text("Usage: \r\n* Launch from Scanner.\r\n* Right click vulnerability item and select \"XSS/LFI/RFI/Redirect POC\".\r\n* Click \"Submit POC Test\" to get the response code.");
			((Control)btnOpenRefPage).set_Location(new Point(618, 291));
			((Control)btnOpenRefPage).set_Name("btnOpenRefPage");
			((Control)btnOpenRefPage).set_Size(new Size(120, 23));
			((Control)btnOpenRefPage).set_TabIndex(23);
			((Control)btnOpenRefPage).set_Text("Open Refer Page");
			((ButtonBase)btnOpenRefPage).set_UseVisualStyleBackColor(true);
			((Control)btnOpenRefPage).add_Click((EventHandler)btnOpenRefPage_Click);
			((Control)btnXSSTest).set_Location(new Point(4, 291));
			((Control)btnXSSTest).set_Name("btnXSSTest");
			((Control)btnXSSTest).set_Size(new Size(118, 23));
			((Control)btnXSSTest).set_TabIndex(22);
			((Control)btnXSSTest).set_Text("Submit POC Test");
			((ButtonBase)btnXSSTest).set_UseVisualStyleBackColor(true);
			((Control)btnXSSTest).add_Click((EventHandler)btnXSSTest_Click);
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(750, 456));
			((Control)this).get_Controls().Add((Control)(object)txtXSSUsage);
			((Control)this).get_Controls().Add((Control)(object)btnOpenRefPage);
			((Control)this).get_Controls().Add((Control)(object)btnXSSTest);
			((Control)this).get_Controls().Add((Control)(object)txtRefPage);
			((Control)this).get_Controls().Add((Control)(object)label19);
			((Control)this).get_Controls().Add((Control)(object)txtActionURL);
			((Control)this).get_Controls().Add((Control)(object)label20);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormPOC");
			((Control)this).set_Text("FormXSS");
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
