using System;
using System.ComponentModel;
using System.Drawing;
using System.Resources;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	public class FormCookie : Form
	{
		private FormMain mainfrm;

		private IContainer components;

		private ToolStrip toolStripCookei;

		private ToolStripSeparator toolStripSeparator1;

		private ToolStripComboBox cmbEscapeCookie;

		private ToolStripSeparator toolStripSeparator2;

		private ToolStripButton btnGetCookie;

		private ToolStripSeparator toolStripSeparator3;

		private ToolStripButton btnSetCookie;

		private ToolStripSeparator toolStripSeparator4;

		private ToolStripButton btnClearCookie;

		private ToolStripLabel toolStripLabel1;

		private ToolStripTextBox txtCurrentPath;

		private ToolStripSeparator toolStripSeparator5;

		private ToolTip toolTip1;

		private ToolStrip toolStripSetDetailCookie;

		private SplitContainer splitContainer1;

		private TextBox txtCookie;

		private TextBox txtCookieDetail;

		private ToolStripLabel toolStripLabel2;

		private ToolStripTextBox txtCookieName;

		private ToolStripLabel toolStripLabel3;

		private ToolStripTextBox txtCookieValue;

		private ToolStripLabel toolStripLabel4;

		private ToolStripLabel toolStripLabel5;

		private ToolStripComboBox cmbExpired;

		private ToolStripButton btnChange;

		private ToolStripComboBox cmbCookiePath;

		private ToolStripSeparator toolStripSeparator6;

		private ToolStripButton btnScanCookie;

		public FormCookie(FormMain fm)
			: this()
		{
			InitializeComponent();
			cmbEscapeCookie.set_SelectedIndex(0);
			cmbExpired.set_SelectedIndex(0);
			mainfrm = fm;
		}

		private string GetCurrentCookiePath(Uri uri)
		{
			try
			{
				return uri.get_AbsolutePath();
			}
			catch
			{
				return "/";
			}
		}

		private void GetAllCookie()
		{
			//IL_00a5: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				Uri currentUri = mainfrm.CurrentSite.currentUri;
				((ToolStripItem)txtCurrentPath).set_Text(GetCurrentCookiePath(currentUri));
				((Control)txtCookie).set_Text(mainfrm.CurrentSite.GetCookieStrFromCC(currentUri));
				string str = "WebCruiser Cookie:\r\n";
				str += mainfrm.CurrentSite.GetCookieDetailsFromCC(currentUri);
				str += "\r\n\r\nInternal WebBrowser Cookie:\r\n";
				str += mainfrm.BrowserForm.GetWebBrowserCookie();
				((Control)txtCookieDetail).set_Text(str);
				((ToolStripItem)btnSetCookie).set_Enabled(true);
			}
			catch (Exception)
			{
				MessageBox.Show("Please Navigate the Web site at first!  ", "Information");
			}
		}

		private void btnGetCookie_Click(object sender, EventArgs e)
		{
			if (!string.IsNullOrEmpty(mainfrm.URL))
			{
				GetAllCookie();
				cmbCookiePath.get_Items().Clear();
				cmbCookiePath.get_Items().Add((object)"/");
				string absolutePath = mainfrm.CurrentSite.currentUri.get_AbsolutePath();
				string[] array = absolutePath.Split(new char[1]
				{
					'/'
				});
				string text = "/";
				for (int i = 1; i < array.Length - 1; i++)
				{
					text = text + array[i] + "/";
					cmbCookiePath.get_Items().Add((object)text);
				}
				cmbCookiePath.get_Items().Add((object)absolutePath);
				cmbCookiePath.set_SelectedIndex(0);
			}
		}

		private void btnSetCookie_Click(object sender, EventArgs e)
		{
			char[] trimChars = new char[2]
			{
				' ',
				';'
			};
			string text = ((Control)txtCookie).get_Text().Trim(trimChars);
			if (!string.IsNullOrEmpty(text))
			{
				((Control)txtCookie).set_Text(text);
				mainfrm.CurrentSite.SetCookie(mainfrm.CurrentSite.URL, text, isClear: false);
				((Control)txtCookie).set_Text(mainfrm.CurrentSite.GetCookieStrFromCC(mainfrm.CurrentSite.currentUri));
				((Control)txtCookieDetail).set_Text(mainfrm.CurrentSite.GetCookieDetailsFromCC(mainfrm.CurrentSite.currentUri));
			}
		}

		private void cmbEscapeCookie_DropDownClosed(object sender, EventArgs e)
		{
			if (cmbEscapeCookie.get_SelectedIndex() == 0)
			{
				WebSite.EscapeCookie = true;
				mainfrm.EscapeCookie(IsEscape: true);
			}
			else
			{
				WebSite.EscapeCookie = false;
				mainfrm.EscapeCookie(IsEscape: false);
			}
		}

		public void EscapeCookie(bool IsEscape)
		{
			if (IsEscape)
			{
				cmbEscapeCookie.set_SelectedIndex(0);
			}
			else
			{
				cmbEscapeCookie.set_SelectedIndex(1);
			}
		}

		private void btnClearCookie_Click(object sender, EventArgs e)
		{
			try
			{
				ClearWebBrowserCookie();
				char[] trimChars = new char[2]
				{
					' ',
					';'
				};
				string text = ((Control)txtCookie).get_Text().Trim(trimChars);
				if (!string.IsNullOrEmpty(text))
				{
					((Control)txtCookie).set_Text(text);
					mainfrm.CurrentSite.SetCookie(mainfrm.CurrentSite.URL, text, isClear: true);
					((Control)txtCookie).set_Text(mainfrm.CurrentSite.GetCookieStrFromCC(mainfrm.CurrentSite.currentUri));
					((Control)txtCookieDetail).set_Text(mainfrm.CurrentSite.GetCookieDetailsFromCC(mainfrm.CurrentSite.currentUri));
					((ToolStripItem)btnSetCookie).set_Enabled(true);
				}
			}
			catch (Exception)
			{
			}
		}

		[DllImport("wininet.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern bool InternetSetOption(int hInternet, int dwOption, IntPtr lpBuffer, int dwBufferLength);

		private unsafe static void ClearWebBrowserCookie()
		{
			//IL_001e: Unknown result type (might be due to invalid IL or missing references)
			int num = 3;
			int* value = &num;
			if (!InternetSetOption(0, 81, new IntPtr(value), 4))
			{
				MessageBox.Show("Clear WebBrowserCookie failed !");
			}
		}

		private void btnChange_Click(object sender, EventArgs e)
		{
			string str = ((ToolStripItem)txtCookieName).get_Text().Trim();
			string text = ((ToolStripItem)txtCookieValue).get_Text();
			string cookiePath = ((ToolStripItem)cmbCookiePath).get_Text().Trim();
			bool isExpired = false;
			if (cmbExpired.get_SelectedIndex() == 1)
			{
				isExpired = true;
			}
			string cookieExpression = str + "=" + text;
			mainfrm.CurrentSite.SetSingleCookie(mainfrm.URL, cookieExpression, cookiePath, WebSite.EscapeCookie, isExpired);
			GetAllCookie();
		}

		private void btnScanCookie_Click(object sender, EventArgs e)
		{
			char[] trimChars = new char[2]
			{
				' ',
				';'
			};
			string text = ((Control)txtCookie).get_Text().Trim(trimChars);
			if (string.IsNullOrEmpty(text))
			{
				return;
			}
			string sURL = mainfrm.URL;
			text = text.Replace("; ", ";").Replace(";", "&");
			string testURL = sURL + "^" + text;
			mainfrm.DisplayLogList("Checking Cookie SQL Injection ...");
			mainfrm.SelectTool("Scanner");
			Thread thread = new Thread((ThreadStart)delegate
			{
				VulnSQLInjection[] sQLInjectionVulnCollection = mainfrm.CurrentSite.GetSQLInjectionVulnCollection(testURL, RequestType.COOKIE, sURL, skipScanned: false, testEscapeSpace: false, "");
				VulnSQLInjection[] array = sQLInjectionVulnCollection;
				foreach (VulnSQLInjection vuln in array)
				{
					mainfrm.AddNewVuln(vuln);
				}
			});
			thread.Start();
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			//IL_000b: Expected O, but got Unknown
			//IL_0015: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0053: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Expected O, but got Unknown
			//IL_005e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0068: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_0073: Expected O, but got Unknown
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_007e: Expected O, but got Unknown
			//IL_007f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0089: Expected O, but got Unknown
			//IL_008a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Expected O, but got Unknown
			//IL_0095: Unknown result type (might be due to invalid IL or missing references)
			//IL_009f: Expected O, but got Unknown
			//IL_00a0: Unknown result type (might be due to invalid IL or missing references)
			//IL_00aa: Expected O, but got Unknown
			//IL_00ab: Unknown result type (might be due to invalid IL or missing references)
			//IL_00b5: Expected O, but got Unknown
			//IL_00bc: Unknown result type (might be due to invalid IL or missing references)
			//IL_00c6: Expected O, but got Unknown
			//IL_00c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d1: Expected O, but got Unknown
			//IL_00d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_00dc: Expected O, but got Unknown
			//IL_00dd: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e7: Expected O, but got Unknown
			//IL_00e8: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f2: Expected O, but got Unknown
			//IL_00f3: Unknown result type (might be due to invalid IL or missing references)
			//IL_00fd: Expected O, but got Unknown
			//IL_00fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0108: Expected O, but got Unknown
			//IL_0109: Unknown result type (might be due to invalid IL or missing references)
			//IL_0113: Expected O, but got Unknown
			//IL_0114: Unknown result type (might be due to invalid IL or missing references)
			//IL_011e: Expected O, but got Unknown
			//IL_011f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0129: Expected O, but got Unknown
			//IL_012a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0134: Expected O, but got Unknown
			//IL_0135: Unknown result type (might be due to invalid IL or missing references)
			//IL_013f: Expected O, but got Unknown
			//IL_0140: Unknown result type (might be due to invalid IL or missing references)
			//IL_014a: Expected O, but got Unknown
			//IL_014b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0155: Expected O, but got Unknown
			//IL_01a2: Unknown result type (might be due to invalid IL or missing references)
			//IL_0252: Unknown result type (might be due to invalid IL or missing references)
			//IL_0279: Unknown result type (might be due to invalid IL or missing references)
			//IL_02b8: Unknown result type (might be due to invalid IL or missing references)
			//IL_0313: Unknown result type (might be due to invalid IL or missing references)
			//IL_034d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0371: Unknown result type (might be due to invalid IL or missing references)
			//IL_03b4: Unknown result type (might be due to invalid IL or missing references)
			//IL_03d7: Unknown result type (might be due to invalid IL or missing references)
			//IL_03fe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0408: Expected O, but got Unknown
			//IL_040e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0432: Unknown result type (might be due to invalid IL or missing references)
			//IL_047c: Unknown result type (might be due to invalid IL or missing references)
			//IL_04af: Unknown result type (might be due to invalid IL or missing references)
			//IL_04b9: Expected O, but got Unknown
			//IL_04bf: Unknown result type (might be due to invalid IL or missing references)
			//IL_04e3: Unknown result type (might be due to invalid IL or missing references)
			//IL_052d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0554: Unknown result type (might be due to invalid IL or missing references)
			//IL_055e: Expected O, but got Unknown
			//IL_0564: Unknown result type (might be due to invalid IL or missing references)
			//IL_0588: Unknown result type (might be due to invalid IL or missing references)
			//IL_05e2: Unknown result type (might be due to invalid IL or missing references)
			//IL_0609: Unknown result type (might be due to invalid IL or missing references)
			//IL_0613: Expected O, but got Unknown
			//IL_0619: Unknown result type (might be due to invalid IL or missing references)
			//IL_063d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0692: Unknown result type (might be due to invalid IL or missing references)
			//IL_06a6: Unknown result type (might be due to invalid IL or missing references)
			//IL_06dc: Unknown result type (might be due to invalid IL or missing references)
			//IL_078a: Unknown result type (might be due to invalid IL or missing references)
			//IL_07b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_07f1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0825: Unknown result type (might be due to invalid IL or missing references)
			//IL_0849: Unknown result type (might be due to invalid IL or missing references)
			//IL_0880: Unknown result type (might be due to invalid IL or missing references)
			//IL_08a4: Unknown result type (might be due to invalid IL or missing references)
			//IL_08db: Unknown result type (might be due to invalid IL or missing references)
			//IL_08ff: Unknown result type (might be due to invalid IL or missing references)
			//IL_096b: Unknown result type (might be due to invalid IL or missing references)
			//IL_099e: Unknown result type (might be due to invalid IL or missing references)
			//IL_09a8: Expected O, but got Unknown
			//IL_09ae: Unknown result type (might be due to invalid IL or missing references)
			//IL_09d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a18: Unknown result type (might be due to invalid IL or missing references)
			//IL_0a84: Unknown result type (might be due to invalid IL or missing references)
			//IL_0abe: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b00: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b21: Unknown result type (might be due to invalid IL or missing references)
			//IL_0b3d: Unknown result type (might be due to invalid IL or missing references)
			components = (IContainer)new Container();
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormCookie));
			toolStripCookei = new ToolStrip();
			toolStripSeparator1 = new ToolStripSeparator();
			cmbEscapeCookie = new ToolStripComboBox();
			toolStripSeparator2 = new ToolStripSeparator();
			toolStripLabel1 = new ToolStripLabel();
			txtCurrentPath = new ToolStripTextBox();
			toolStripSeparator5 = new ToolStripSeparator();
			btnGetCookie = new ToolStripButton();
			toolStripSeparator3 = new ToolStripSeparator();
			btnSetCookie = new ToolStripButton();
			toolStripSeparator4 = new ToolStripSeparator();
			btnClearCookie = new ToolStripButton();
			toolStripSeparator6 = new ToolStripSeparator();
			btnScanCookie = new ToolStripButton();
			toolTip1 = new ToolTip(components);
			txtCookie = new TextBox();
			toolStripSetDetailCookie = new ToolStrip();
			toolStripLabel2 = new ToolStripLabel();
			txtCookieName = new ToolStripTextBox();
			toolStripLabel3 = new ToolStripLabel();
			txtCookieValue = new ToolStripTextBox();
			toolStripLabel4 = new ToolStripLabel();
			cmbCookiePath = new ToolStripComboBox();
			toolStripLabel5 = new ToolStripLabel();
			cmbExpired = new ToolStripComboBox();
			btnChange = new ToolStripButton();
			splitContainer1 = new SplitContainer();
			txtCookieDetail = new TextBox();
			((Control)toolStripCookei).SuspendLayout();
			((Control)toolStripSetDetailCookie).SuspendLayout();
			((Control)splitContainer1.get_Panel1()).SuspendLayout();
			((Control)splitContainer1.get_Panel2()).SuspendLayout();
			((Control)splitContainer1).SuspendLayout();
			((Control)this).SuspendLayout();
			toolStripCookei.set_BackColor(SystemColors.get_ButtonFace());
			toolStripCookei.set_GripStyle((ToolStripGripStyle)0);
			toolStripCookei.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[13]
			{
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)cmbEscapeCookie,
				(ToolStripItem)toolStripSeparator2,
				(ToolStripItem)toolStripLabel1,
				(ToolStripItem)txtCurrentPath,
				(ToolStripItem)toolStripSeparator5,
				(ToolStripItem)btnGetCookie,
				(ToolStripItem)toolStripSeparator3,
				(ToolStripItem)btnSetCookie,
				(ToolStripItem)toolStripSeparator4,
				(ToolStripItem)btnClearCookie,
				(ToolStripItem)toolStripSeparator6,
				(ToolStripItem)btnScanCookie
			});
			((Control)toolStripCookei).set_Location(new Point(0, 0));
			((Control)toolStripCookei).set_Name("toolStripCookei");
			((Control)toolStripCookei).set_Size(new Size(801, 25));
			((Control)toolStripCookei).set_TabIndex(4);
			((Control)toolStripCookei).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 25));
			cmbEscapeCookie.set_DropDownStyle((ComboBoxStyle)2);
			cmbEscapeCookie.get_Items().AddRange(new object[2]
			{
				"Escape Special Characters(Default)",
				"Not Escape"
			});
			((ToolStripItem)cmbEscapeCookie).set_Name("cmbEscapeCookie");
			((ToolStripItem)cmbEscapeCookie).set_Size(new Size(200, 25));
			cmbEscapeCookie.add_DropDownClosed((EventHandler)cmbEscapeCookie_DropDownClosed);
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			((ToolStripItem)toolStripLabel1).set_Name("toolStripLabel1");
			((ToolStripItem)toolStripLabel1).set_Size(new Size(36, 22));
			((ToolStripItem)toolStripLabel1).set_Text("Path:");
			((ToolStripItem)txtCurrentPath).set_Name("txtCurrentPath");
			txtCurrentPath.set_ReadOnly(true);
			((ToolStripItem)txtCurrentPath).set_Size(new Size(180, 25));
			((ToolStripItem)toolStripSeparator5).set_Name("toolStripSeparator5");
			((ToolStripItem)toolStripSeparator5).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetCookie).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetCookie).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetCookie.Image"));
			((ToolStripItem)btnGetCookie).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetCookie).set_Name("btnGetCookie");
			((ToolStripItem)btnGetCookie).set_Size(new Size(73, 22));
			((ToolStripItem)btnGetCookie).set_Text("GetCookie");
			((ToolStripItem)btnGetCookie).add_Click((EventHandler)btnGetCookie_Click);
			((ToolStripItem)toolStripSeparator3).set_Name("toolStripSeparator3");
			((ToolStripItem)toolStripSeparator3).set_Size(new Size(6, 25));
			((ToolStripItem)btnSetCookie).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnSetCookie).set_Enabled(false);
			((ToolStripItem)btnSetCookie).set_Image((Image)((ResourceManager)(object)val).GetObject("btnSetCookie.Image"));
			((ToolStripItem)btnSetCookie).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnSetCookie).set_Name("btnSetCookie");
			((ToolStripItem)btnSetCookie).set_Size(new Size(71, 22));
			((ToolStripItem)btnSetCookie).set_Text("SetCookie");
			((ToolStripItem)btnSetCookie).add_Click((EventHandler)btnSetCookie_Click);
			((ToolStripItem)toolStripSeparator4).set_Name("toolStripSeparator4");
			((ToolStripItem)toolStripSeparator4).set_Size(new Size(6, 25));
			((ToolStripItem)btnClearCookie).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnClearCookie).set_Image((Image)((ResourceManager)(object)val).GetObject("btnClearCookie.Image"));
			((ToolStripItem)btnClearCookie).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnClearCookie).set_Name("btnClearCookie");
			((ToolStripItem)btnClearCookie).set_Size(new Size(42, 22));
			((ToolStripItem)btnClearCookie).set_Text("Clear");
			((ToolStripItem)btnClearCookie).set_ToolTipText("Clear Cookies");
			((ToolStripItem)btnClearCookie).add_Click((EventHandler)btnClearCookie_Click);
			((ToolStripItem)toolStripSeparator6).set_Name("toolStripSeparator6");
			((ToolStripItem)toolStripSeparator6).set_Size(new Size(6, 25));
			((ToolStripItem)btnScanCookie).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnScanCookie).set_Image((Image)((ResourceManager)(object)val).GetObject("btnScanCookie.Image"));
			((ToolStripItem)btnScanCookie).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnScanCookie).set_Name("btnScanCookie");
			((ToolStripItem)btnScanCookie).set_Size(new Size(77, 22));
			((ToolStripItem)btnScanCookie).set_Text("CookieTest");
			((ToolStripItem)btnScanCookie).set_ToolTipText("Scan Cookie SQL Injection");
			((ToolStripItem)btnScanCookie).add_Click((EventHandler)btnScanCookie_Click);
			((Control)txtCookie).set_Dock((DockStyle)5);
			((Control)txtCookie).set_Location(new Point(0, 0));
			((Control)txtCookie).set_Margin(new Padding(3, 4, 3, 4));
			((TextBoxBase)txtCookie).set_Multiline(true);
			((Control)txtCookie).set_Name("txtCookie");
			((Control)txtCookie).set_Size(new Size(801, 150));
			((Control)txtCookie).set_TabIndex(5);
			toolTip1.SetToolTip((Control)(object)txtCookie, "key1=value1; key2=value2");
			((Control)toolStripSetDetailCookie).set_Dock((DockStyle)2);
			toolStripSetDetailCookie.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[9]
			{
				(ToolStripItem)toolStripLabel2,
				(ToolStripItem)txtCookieName,
				(ToolStripItem)toolStripLabel3,
				(ToolStripItem)txtCookieValue,
				(ToolStripItem)toolStripLabel4,
				(ToolStripItem)cmbCookiePath,
				(ToolStripItem)toolStripLabel5,
				(ToolStripItem)cmbExpired,
				(ToolStripItem)btnChange
			});
			((Control)toolStripSetDetailCookie).set_Location(new Point(0, 329));
			((Control)toolStripSetDetailCookie).set_Name("toolStripSetDetailCookie");
			((Control)toolStripSetDetailCookie).set_Size(new Size(801, 25));
			((Control)toolStripSetDetailCookie).set_TabIndex(7);
			((Control)toolStripSetDetailCookie).set_Text("toolStrip1");
			((ToolStripItem)toolStripLabel2).set_Name("toolStripLabel2");
			((ToolStripItem)toolStripLabel2).set_Size(new Size(43, 22));
			((ToolStripItem)toolStripLabel2).set_Text("Name");
			((ToolStripItem)txtCookieName).set_Name("txtCookieName");
			((ToolStripItem)txtCookieName).set_Size(new Size(60, 25));
			((ToolStripItem)toolStripLabel3).set_Name("toolStripLabel3");
			((ToolStripItem)toolStripLabel3).set_Size(new Size(40, 22));
			((ToolStripItem)toolStripLabel3).set_Text("Value");
			((ToolStripItem)txtCookieValue).set_Name("txtCookieValue");
			((ToolStripItem)txtCookieValue).set_Size(new Size(160, 25));
			((ToolStripItem)toolStripLabel4).set_Name("toolStripLabel4");
			((ToolStripItem)toolStripLabel4).set_Size(new Size(33, 22));
			((ToolStripItem)toolStripLabel4).set_Text("Path");
			((ToolStripItem)cmbCookiePath).set_Name("cmbCookiePath");
			((ToolStripItem)cmbCookiePath).set_Size(new Size(180, 25));
			((ToolStripItem)toolStripLabel5).set_Name("toolStripLabel5");
			((ToolStripItem)toolStripLabel5).set_Size(new Size(52, 22));
			((ToolStripItem)toolStripLabel5).set_Text("Expired");
			cmbExpired.set_DropDownStyle((ComboBoxStyle)2);
			cmbExpired.get_Items().AddRange(new object[2]
			{
				"Not expired",
				"expired"
			});
			((ToolStripItem)cmbExpired).set_Name("cmbExpired");
			((ToolStripItem)cmbExpired).set_Size(new Size(90, 25));
			((ToolStripItem)btnChange).set_Alignment((ToolStripItemAlignment)1);
			((ToolStripItem)btnChange).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnChange).set_Image((Image)((ResourceManager)(object)val).GetObject("btnChange.Image"));
			((ToolStripItem)btnChange).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnChange).set_Name("btnChange");
			((ToolStripItem)btnChange).set_Size(new Size(56, 22));
			((ToolStripItem)btnChange).set_Text("Change");
			((ToolStripItem)btnChange).add_Click((EventHandler)btnChange_Click);
			splitContainer1.set_Dock((DockStyle)5);
			((Control)splitContainer1).set_Location(new Point(0, 25));
			((Control)splitContainer1).set_Name("splitContainer1");
			splitContainer1.set_Orientation((Orientation)0);
			((Control)splitContainer1.get_Panel1()).get_Controls().Add((Control)(object)txtCookie);
			((Control)splitContainer1.get_Panel2()).get_Controls().Add((Control)(object)txtCookieDetail);
			((Control)splitContainer1).set_Size(new Size(801, 304));
			splitContainer1.set_SplitterDistance(150);
			((Control)splitContainer1).set_TabIndex(8);
			((Control)txtCookieDetail).set_Dock((DockStyle)5);
			((Control)txtCookieDetail).set_Location(new Point(0, 0));
			((TextBoxBase)txtCookieDetail).set_Multiline(true);
			((Control)txtCookieDetail).set_Name("txtCookieDetail");
			((TextBoxBase)txtCookieDetail).set_ReadOnly(true);
			((Control)txtCookieDetail).set_Size(new Size(801, 150));
			((Control)txtCookieDetail).set_TabIndex(0);
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(801, 354));
			((Control)this).get_Controls().Add((Control)(object)splitContainer1);
			((Control)this).get_Controls().Add((Control)(object)toolStripSetDetailCookie);
			((Control)this).get_Controls().Add((Control)(object)toolStripCookei);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormCookie");
			((Control)this).set_Text("FormCookie");
			((Control)toolStripCookei).ResumeLayout(false);
			((Control)toolStripCookei).PerformLayout();
			((Control)toolStripSetDetailCookie).ResumeLayout(false);
			((Control)toolStripSetDetailCookie).PerformLayout();
			((Control)splitContainer1.get_Panel1()).ResumeLayout(false);
			((Control)splitContainer1.get_Panel1()).PerformLayout();
			((Control)splitContainer1.get_Panel2()).ResumeLayout(false);
			((Control)splitContainer1.get_Panel2()).PerformLayout();
			((Control)splitContainer1).ResumeLayout(false);
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
