using System;
using System.ComponentModel;
using System.Drawing;
using System.Net;
using System.Resources;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	public class FormCode : Form
	{
		private FormMain mainfrm;

		private IContainer components;

		private ToolStrip toolStripCode;

		private ToolStripButton btnGetCode;

		private ToolStripSeparator toolStripSeparator1;

		private ToolStripButton btnGetWBCode;

		private ToolStripSeparator toolStripSeparator2;

		private TextBox txtCode;

		private ToolStripSeparator toolStripSeparator3;

		public FormCode(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
		}

		private void btnGetCode_Click(object sender, EventArgs e)
		{
			//IL_00e8: Unknown result type (might be due to invalid IL or missing references)
			string currentURL = mainfrm.GetCurrentURL();
			mainfrm.URL = currentURL;
			((TextBoxBase)txtCode).Clear();
			mainfrm.DisplayProgress("Getting Source ...");
			string urlencodedPostData = "";
			string customCookie = "";
			if (mainfrm.ReqType == RequestType.POST)
			{
				urlencodedPostData = mainfrm.SubmitData;
			}
			else if (mainfrm.ReqType == RequestType.COOKIE)
			{
				customCookie = mainfrm.SubmitData;
			}
			try
			{
				HttpWebResponse httpWebResponse = mainfrm.CurrentSite.GetHttpWebResponse(currentURL, mainfrm.ReqType, urlencodedPostData, "", customCookie, WebSite.EscapeCookie, "", "");
				if (httpWebResponse != null)
				{
					string sourceCodeFromHttpWebResponse = mainfrm.CurrentSite.GetSourceCodeFromHttpWebResponse(httpWebResponse);
					((Control)txtCode).set_Text(sourceCodeFromHttpWebResponse.Replace("\0", ""));
					mainfrm.DisplayProgress("HTTP Status: " + ((object)httpWebResponse.get_StatusCode()).ToString());
					((WebResponse)httpWebResponse).Close();
					httpWebResponse = null;
				}
			}
			catch (Exception)
			{
			}
		}

		private void btnGetWBCode_Click(object sender, EventArgs e)
		{
			((TextBoxBase)txtCode).Clear();
			string sourceCodeFromWebBrowser = mainfrm.GetSourceCodeFromWebBrowser();
			((Control)txtCode).set_Text(sourceCodeFromWebBrowser);
		}

		public void UpdateCodeText(string Code)
		{
			((Control)txtCode).set_Text(Code);
		}

		public void SelectCode(int Location, int Length)
		{
			((TextBoxBase)txtCode).Select(Location, Length);
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_000a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0010: Expected O, but got Unknown
			//IL_0011: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0053: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Expected O, but got Unknown
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_00e7: Unknown result type (might be due to invalid IL or missing references)
			//IL_010e: Unknown result type (might be due to invalid IL or missing references)
			//IL_014d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0174: Unknown result type (might be due to invalid IL or missing references)
			//IL_017e: Expected O, but got Unknown
			//IL_0184: Unknown result type (might be due to invalid IL or missing references)
			//IL_01ab: Unknown result type (might be due to invalid IL or missing references)
			//IL_01f5: Unknown result type (might be due to invalid IL or missing references)
			//IL_021c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0226: Expected O, but got Unknown
			//IL_022c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0253: Unknown result type (might be due to invalid IL or missing references)
			//IL_029d: Unknown result type (might be due to invalid IL or missing references)
			//IL_02c7: Unknown result type (might be due to invalid IL or missing references)
			//IL_0309: Unknown result type (might be due to invalid IL or missing references)
			//IL_032a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0346: Unknown result type (might be due to invalid IL or missing references)
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormCode));
			toolStripCode = new ToolStrip();
			toolStripSeparator1 = new ToolStripSeparator();
			btnGetCode = new ToolStripButton();
			toolStripSeparator2 = new ToolStripSeparator();
			btnGetWBCode = new ToolStripButton();
			toolStripSeparator3 = new ToolStripSeparator();
			txtCode = new TextBox();
			((Control)toolStripCode).SuspendLayout();
			((Control)this).SuspendLayout();
			toolStripCode.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripCode).set_Dock((DockStyle)2);
			toolStripCode.set_GripStyle((ToolStripGripStyle)0);
			toolStripCode.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[5]
			{
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)btnGetCode,
				(ToolStripItem)toolStripSeparator2,
				(ToolStripItem)btnGetWBCode,
				(ToolStripItem)toolStripSeparator3
			});
			((Control)toolStripCode).set_Location(new Point(0, 341));
			((Control)toolStripCode).set_Name("toolStripCode");
			((Control)toolStripCode).set_Size(new Size(575, 25));
			((Control)toolStripCode).set_TabIndex(0);
			((Control)toolStripCode).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetCode).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetCode).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetCode.Image"));
			((ToolStripItem)btnGetCode).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetCode).set_Name("btnGetCode");
			((ToolStripItem)btnGetCode).set_Size(new Size(175, 22));
			((ToolStripItem)btnGetCode).set_Text("Get Code From Current URL");
			((ToolStripItem)btnGetCode).add_Click((EventHandler)btnGetCode_Click);
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetWBCode).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetWBCode).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetWBCode.Image"));
			((ToolStripItem)btnGetWBCode).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetWBCode).set_Name("btnGetWBCode");
			((ToolStripItem)btnGetWBCode).set_Size(new Size(200, 22));
			((ToolStripItem)btnGetWBCode).set_Text("Get Code From Current Browser");
			((ToolStripItem)btnGetWBCode).add_Click((EventHandler)btnGetWBCode_Click);
			((ToolStripItem)toolStripSeparator3).set_Name("toolStripSeparator3");
			((ToolStripItem)toolStripSeparator3).set_Size(new Size(6, 25));
			((Control)txtCode).set_Dock((DockStyle)5);
			((TextBoxBase)txtCode).set_HideSelection(false);
			((Control)txtCode).set_Location(new Point(0, 0));
			((TextBoxBase)txtCode).set_Multiline(true);
			((Control)txtCode).set_Name("txtCode");
			txtCode.set_ScrollBars((ScrollBars)3);
			((Control)txtCode).set_Size(new Size(575, 341));
			((Control)txtCode).set_TabIndex(6);
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(575, 366));
			((Control)this).get_Controls().Add((Control)(object)txtCode);
			((Control)this).get_Controls().Add((Control)(object)toolStripCode);
			((Control)this).set_Cursor(Cursors.get_Arrow());
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormCode");
			((Control)this).set_Text("FormCode");
			((Control)toolStripCode).ResumeLayout(false);
			((Control)toolStripCode).PerformLayout();
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
