using System;
using System.ComponentModel;
using System.Drawing;
using System.Net;
using System.Resources;
using System.Threading;
using System.Windows.Forms;

namespace WebCruiserWVS
{
	public class FormAdmin : Form
	{
		private delegate void dd(string s);

		private FormMain mainfrm;

		private IContainer components;

		private ToolStrip toolStripAdmin;

		private ToolStripSeparator toolStripSeparator1;

		private ToolStripButton btnGetAdmin;

		private ToolStripSeparator toolStripSeparator2;

		private ListView listViewAdminEntrance;

		private ColumnHeader columnHeader4;

		public FormAdmin(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
		}

		private void btnGetAdmin_Click(object sender, EventArgs e)
		{
			//IL_001f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0067: Unknown result type (might be due to invalid IL or missing references)
			//IL_006d: Invalid comparison between Unknown and I4
			if (string.IsNullOrEmpty(mainfrm.URL))
			{
				MessageBox.Show("Please input the URL at first!", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
				return;
			}
			listViewAdminEntrance.get_Items().Clear();
			string fileExt = mainfrm.CurrentSite.GetFileExt(mainfrm.URL);
			if (!string.IsNullOrEmpty(fileExt) || (int)MessageBox.Show("* Open a URL with a filename will help to find the admin entrance.\r\n* Such as: http://127.0.0.1/index.asp \r\n* Continue?\r\n", "Confirm", (MessageBoxButtons)1, (MessageBoxIcon)64) != 2)
			{
				mainfrm.DisplayLogList("Checking Potential Adminstration Entrance...");
				string[] array = WebCruiserWVS.Default.AdminPath.Split(new char[1]
				{
					':'
				});
				int num = array.Length;
				for (int i = 0; i < num; i++)
				{
					string state = array[i];
					ThreadPool.QueueUserWorkItem(new WaitCallback(GetAdminDoWork), state);
				}
			}
		}

		private void GetAdminDoWork(object data)
		{
			//IL_0073: Unknown result type (might be due to invalid IL or missing references)
			//IL_007d: Invalid comparison between Unknown and I4
			//IL_0144: Unknown result type (might be due to invalid IL or missing references)
			//IL_014e: Invalid comparison between Unknown and I4
			//IL_01b4: Unknown result type (might be due to invalid IL or missing references)
			string str = (string)data;
			string text = mainfrm.CurrentSite.HTTPRoot + str;
			try
			{
				if (WebSite.CurrentStatus == TaskStatus.Stop)
				{
					return;
				}
				mainfrm.DisplayLogList("Checking: " + text);
				HttpWebResponse httpWebResponse = mainfrm.CurrentSite.GetHttpWebResponse(text, RequestType.GET, "", "", "", WebSite.EscapeCookie, "", "");
				if ((int)httpWebResponse.get_StatusCode() != 200)
				{
					goto IL_01a1;
				}
				mainfrm.DisplayLogList("Found: " + text);
				AddItem2listViewAdminEntrance(text);
				if (string.IsNullOrEmpty(mainfrm.CurrentSite.FileExt))
				{
					return;
				}
				string[] array = WebCruiserWVS.Default.AdminPage.Split(new char[1]
				{
					':'
				});
				int num = array.Length;
				for (int i = 0; i < num; i++)
				{
					if (WebSite.CurrentStatus == TaskStatus.Stop)
					{
						return;
					}
					string text2 = text + array[i] + mainfrm.CurrentSite.FileExt;
					httpWebResponse = mainfrm.CurrentSite.GetHttpWebResponse(text2, RequestType.GET, "", "", "", WebSite.EscapeCookie, "", "");
					if ((int)httpWebResponse.get_StatusCode() == 200)
					{
						AddItem2listViewAdminEntrance(text2);
						mainfrm.DisplayLogList("Checking: " + text2 + " Found!");
					}
					else
					{
						mainfrm.DisplayLogList("Checking: " + text2 + " Not Found!");
					}
				}
				goto IL_01a1;
				IL_01a1:
				((WebResponse)httpWebResponse).Close();
				httpWebResponse = null;
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void AddItem2listViewAdminEntrance(string ItemText)
		{
			if (!((Control)listViewAdminEntrance).get_InvokeRequired())
			{
				listViewAdminEntrance.get_Items().Add(ItemText);
				return;
			}
			dd dd = AddItem2listViewAdminEntrance;
			((Control)this).Invoke((Delegate)dd, new object[1]
			{
				ItemText
			});
		}

		private void listViewAdminEntrance_MouseClick(object sender, MouseEventArgs e)
		{
			//IL_0014: Unknown result type (might be due to invalid IL or missing references)
			//IL_001a: Expected O, but got Unknown
			if (listViewAdminEntrance.get_SelectedItems().get_Count() >= 1)
			{
				ContextMenuStrip val = new ContextMenuStrip();
				((ToolStrip)val).get_Items().Add("Copy URL To ClipBoard", (Image)null, (EventHandler)listViewAdminEntranceItemClick);
				((Control)listViewAdminEntrance).set_ContextMenuStrip(val);
			}
		}

		private void listViewAdminEntranceItemClick(object sender, EventArgs e)
		{
			//IL_0001: Unknown result type (might be due to invalid IL or missing references)
			try
			{
				string text;
				if ((text = ((ToolStripItem)(ToolStripMenuItem)sender).get_Text()) != null && text == "Copy URL To ClipBoard")
				{
					Clipboard.SetText(listViewAdminEntrance.get_SelectedItems().get_Item(0).get_Text());
				}
			}
			catch
			{
			}
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_000a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0010: Expected O, but got Unknown
			//IL_0011: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_00ca: Unknown result type (might be due to invalid IL or missing references)
			//IL_00f1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0130: Unknown result type (might be due to invalid IL or missing references)
			//IL_0157: Unknown result type (might be due to invalid IL or missing references)
			//IL_0161: Expected O, but got Unknown
			//IL_0167: Unknown result type (might be due to invalid IL or missing references)
			//IL_018e: Unknown result type (might be due to invalid IL or missing references)
			//IL_01d8: Unknown result type (might be due to invalid IL or missing references)
			//IL_0217: Unknown result type (might be due to invalid IL or missing references)
			//IL_0241: Unknown result type (might be due to invalid IL or missing references)
			//IL_027c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0286: Expected O, but got Unknown
			//IL_02b1: Unknown result type (might be due to invalid IL or missing references)
			//IL_02cd: Unknown result type (might be due to invalid IL or missing references)
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormAdmin));
			toolStripAdmin = new ToolStrip();
			toolStripSeparator1 = new ToolStripSeparator();
			btnGetAdmin = new ToolStripButton();
			toolStripSeparator2 = new ToolStripSeparator();
			listViewAdminEntrance = new ListView();
			columnHeader4 = new ColumnHeader();
			((Control)toolStripAdmin).SuspendLayout();
			((Control)this).SuspendLayout();
			toolStripAdmin.set_BackColor(SystemColors.get_ButtonFace());
			((Control)toolStripAdmin).set_Dock((DockStyle)2);
			toolStripAdmin.set_GripStyle((ToolStripGripStyle)0);
			toolStripAdmin.get_Items().AddRange((ToolStripItem[])(object)new ToolStripItem[3]
			{
				(ToolStripItem)toolStripSeparator1,
				(ToolStripItem)btnGetAdmin,
				(ToolStripItem)toolStripSeparator2
			});
			((Control)toolStripAdmin).set_Location(new Point(0, 298));
			((Control)toolStripAdmin).set_Name("toolStripAdmin");
			((Control)toolStripAdmin).set_Size(new Size(485, 25));
			((Control)toolStripAdmin).set_TabIndex(0);
			((Control)toolStripAdmin).set_Text("toolStrip1");
			((ToolStripItem)toolStripSeparator1).set_Name("toolStripSeparator1");
			((ToolStripItem)toolStripSeparator1).set_Size(new Size(6, 25));
			((ToolStripItem)btnGetAdmin).set_DisplayStyle((ToolStripItemDisplayStyle)1);
			((ToolStripItem)btnGetAdmin).set_Image((Image)((ResourceManager)(object)val).GetObject("btnGetAdmin.Image"));
			((ToolStripItem)btnGetAdmin).set_ImageTransparentColor(Color.get_Magenta());
			((ToolStripItem)btnGetAdmin).set_Name("btnGetAdmin");
			((ToolStripItem)btnGetAdmin).set_Size(new Size(174, 22));
			((ToolStripItem)btnGetAdmin).set_Text("Get Administration Entrance");
			((ToolStripItem)btnGetAdmin).add_Click((EventHandler)btnGetAdmin_Click);
			((ToolStripItem)toolStripSeparator2).set_Name("toolStripSeparator2");
			((ToolStripItem)toolStripSeparator2).set_Size(new Size(6, 25));
			listViewAdminEntrance.get_Columns().AddRange((ColumnHeader[])(object)new ColumnHeader[1]
			{
				columnHeader4
			});
			((Control)listViewAdminEntrance).set_Dock((DockStyle)5);
			((Control)listViewAdminEntrance).set_Location(new Point(0, 0));
			((Control)listViewAdminEntrance).set_Name("listViewAdminEntrance");
			((Control)listViewAdminEntrance).set_Size(new Size(485, 298));
			((Control)listViewAdminEntrance).set_TabIndex(2);
			listViewAdminEntrance.set_UseCompatibleStateImageBehavior(false);
			listViewAdminEntrance.set_View((View)1);
			((Control)listViewAdminEntrance).add_MouseClick(new MouseEventHandler(listViewAdminEntrance_MouseClick));
			columnHeader4.set_Text("Potential Adminstration Entrance");
			columnHeader4.set_Width(710);
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(485, 323));
			((Control)this).get_Controls().Add((Control)(object)listViewAdminEntrance);
			((Control)this).get_Controls().Add((Control)(object)toolStripAdmin);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormAdmin");
			((Control)this).set_Text("FormAdmin");
			((Control)toolStripAdmin).ResumeLayout(false);
			((Control)toolStripAdmin).PerformLayout();
			((Control)this).ResumeLayout(false);
			((Control)this).PerformLayout();
		}
	}
}
