using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Resources;
using System.Windows.Forms;
using Microsoft.Win32;

namespace WebCruiserWVS
{
	public class FormAbout : Form
	{
		private FormMain mainfrm;

		private IContainer components;

		private SplitContainer splitAbout;

		private TextBox txtHelp;

		private Label lblRegInfo;

		private LinkLabel linkLblBuy;

		private Button btnReg;

		private TextBox txtRegCode;

		private TextBox txtRegUsername;

		private Label lblRegCode;

		private Label lblRegUsername;

		private LinkLabel linkLabelSite2;

		private LinkLabel linkLabelMail;

		private LinkLabel linkAvangate;

		public FormAbout(FormMain fm)
			: this()
		{
			InitializeComponent();
			mainfrm = fm;
		}

		public void InitRegControl()
		{
			//IL_012b: Unknown result type (might be due to invalid IL or missing references)
			if (WCRSetting.wvsEdition == WVSEdition.Free)
			{
				((Control)lblRegInfo).set_Visible(false);
				((Control)lblRegUsername).set_Visible(false);
				((Control)lblRegCode).set_Visible(false);
				((Control)txtRegUsername).set_Visible(false);
				((Control)txtRegCode).set_Visible(false);
				((Control)btnReg).set_Visible(false);
				((Control)linkLblBuy).set_Visible(false);
				((Control)linkAvangate).set_Visible(false);
				return;
			}
			if (Reg.A1K3)
			{
				((Control)lblRegInfo).set_Text("This copy of WebCruiser is licensed to: " + Reg.RegUser);
				((Control)lblRegUsername).set_Visible(false);
				((Control)lblRegCode).set_Visible(false);
				((Control)txtRegUsername).set_Visible(false);
				((Control)txtRegCode).set_Visible(false);
				((Control)btnReg).set_Visible(false);
				((Control)linkLblBuy).set_Visible(false);
				((Control)linkAvangate).set_Visible(false);
			}
			else if (Reg.LeftDays > 0)
			{
				((Control)lblRegInfo).set_Text("This Copy of WebCruiser is UnRegistered! You can use it for " + Reg.LeftDays + " days.");
			}
			else
			{
				((Control)lblRegInfo).set_Text("This Copy of WebCruiser is UnRegistered and Expired! Please Register If You Would Like To Continue Using It!");
				MessageBox.Show("This Copy of WebCruiser is UnRegistered and Expired! Please Register If You Would Like To Continue Using It!", "", (MessageBoxButtons)0, (MessageBoxIcon)48);
			}
			mainfrm.InitFunctionByRegistration(Reg.A1K3, Reg.LeftDays);
		}

		private void linkLblBuy_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			//IL_0057: Unknown result type (might be due to invalid IL or missing references)
			linkLblBuy.set_LinkVisited(true);
			string text = "";
			if (WCRSetting.wvsEdition == WVSEdition.Enterprise)
			{
				text = "https://shopper.mycommerce.com/checkout/product/25854-2";
			}
			else if (WCRSetting.wvsEdition == WVSEdition.Personal)
			{
				text = "https://shopper.mycommerce.com/checkout/product/25854-1";
			}
			try
			{
				Process.Start(text);
			}
			catch
			{
				Clipboard.SetText(text);
				MessageBox.Show("* Default browser not found, please open the following URL for order information.\r\n* " + text + "\r\n* This URL has been set to ClipBoard and you can paste it to you browser directly.", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
			}
		}

		private void btnReg_Click(object sender, EventArgs e)
		{
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Unknown result type (might be due to invalid IL or missing references)
			//IL_00d2: Unknown result type (might be due to invalid IL or missing references)
			//IL_013e: Unknown result type (might be due to invalid IL or missing references)
			string text = ((Control)txtRegUsername).get_Text().Trim();
			if (string.IsNullOrEmpty(text) || text.Length < 2)
			{
				MessageBox.Show("Username should has at least 2 letters!");
				return;
			}
			string text2 = ((Control)txtRegCode).get_Text();
			if (string.IsNullOrEmpty(text2))
			{
				MessageBox.Show("RegCode can not be null!");
			}
			else if (Reg.ValidateRegCode(text, text2) || Reg.ValidateRegCode2(text, text2))
			{
				RegistryKey val = Registry.CurrentUser.CreateSubKey("Software\\Sec4App\\WebCruiser");
				val.SetValue("Username", (object)text);
				val.SetValue("RegCode", (object)text2);
				string toEncrypt = DateTime.Now.ToString("yyyy-MM-dd");
				toEncrypt = Reg.Encrypt(toEncrypt);
				val.SetValue("InitDate", (object)toEncrypt);
				((Control)lblRegInfo).set_Text("This copy of WebCruiser is licensed to: " + text);
				MessageBox.Show("Thank You For Registration!", "Registration OK!");
				((Control)lblRegUsername).set_Visible(false);
				((Control)lblRegCode).set_Visible(false);
				((Control)txtRegUsername).set_Visible(false);
				((Control)txtRegCode).set_Visible(false);
				((Control)btnReg).set_Visible(false);
				((Control)linkLblBuy).set_Visible(false);
				((Control)linkAvangate).set_Visible(false);
				Reg.A1K3 = true;
				Reg.RegUser = text;
			}
			else
			{
				MessageBox.Show("Invalid RegCode !");
			}
		}

		private void linkLblSite_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			string text = "http://www.janusec.com/";
			try
			{
				Process.Start(text);
			}
			catch
			{
				mainfrm.NavigatePage(text, RequestType.GET, "");
			}
		}

		private void linkLabelSite2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			string text = "http://www.janusec.com/";
			try
			{
				Process.Start(text);
			}
			catch
			{
				mainfrm.NavigatePage(text, RequestType.GET, "");
			}
		}

		private void linkLabelMail_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			string text = "mailto:janusecurity@gmail.com?subject=WebCruiserWVS";
			try
			{
				Process.Start(text);
			}
			catch
			{
			}
		}

		private void linkAvangate_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			//IL_0057: Unknown result type (might be due to invalid IL or missing references)
			linkAvangate.set_LinkVisited(true);
			string text = "";
			if (WCRSetting.wvsEdition == WVSEdition.Enterprise)
			{
				text = "https://secure.avangate.com/order/checkout.php?PRODS=4540841&QTY=1&CART=1";
			}
			else if (WCRSetting.wvsEdition == WVSEdition.Personal)
			{
				text = "https://secure.avangate.com/order/checkout.php?PRODS=4540814&QTY=1&CART=1";
			}
			try
			{
				Process.Start(text);
			}
			catch
			{
				Clipboard.SetText(text);
				MessageBox.Show("* Default browser not found, please open the following URL for order information.\r\n* " + text + "\r\n* This URL has been set to ClipBoard and you can paste it to you browser directly.", "Notice", (MessageBoxButtons)0, (MessageBoxIcon)64);
			}
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				((IDisposable)components).Dispose();
			}
			((Form)this).Dispose(disposing);
		}

		private void InitializeComponent()
		{
			//IL_000a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0010: Expected O, but got Unknown
			//IL_0011: Unknown result type (might be due to invalid IL or missing references)
			//IL_001b: Expected O, but got Unknown
			//IL_001c: Unknown result type (might be due to invalid IL or missing references)
			//IL_0026: Expected O, but got Unknown
			//IL_0027: Unknown result type (might be due to invalid IL or missing references)
			//IL_0031: Expected O, but got Unknown
			//IL_0032: Unknown result type (might be due to invalid IL or missing references)
			//IL_003c: Expected O, but got Unknown
			//IL_003d: Unknown result type (might be due to invalid IL or missing references)
			//IL_0047: Expected O, but got Unknown
			//IL_0048: Unknown result type (might be due to invalid IL or missing references)
			//IL_0052: Expected O, but got Unknown
			//IL_0053: Unknown result type (might be due to invalid IL or missing references)
			//IL_005d: Expected O, but got Unknown
			//IL_005e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0068: Expected O, but got Unknown
			//IL_0069: Unknown result type (might be due to invalid IL or missing references)
			//IL_0073: Expected O, but got Unknown
			//IL_0074: Unknown result type (might be due to invalid IL or missing references)
			//IL_007e: Expected O, but got Unknown
			//IL_007f: Unknown result type (might be due to invalid IL or missing references)
			//IL_0089: Expected O, but got Unknown
			//IL_008a: Unknown result type (might be due to invalid IL or missing references)
			//IL_0094: Expected O, but got Unknown
			//IL_00d9: Unknown result type (might be due to invalid IL or missing references)
			//IL_0238: Unknown result type (might be due to invalid IL or missing references)
			//IL_0264: Unknown result type (might be due to invalid IL or missing references)
			//IL_0282: Unknown result type (might be due to invalid IL or missing references)
			//IL_0293: Unknown result type (might be due to invalid IL or missing references)
			//IL_02e1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0327: Unknown result type (might be due to invalid IL or missing references)
			//IL_034b: Unknown result type (might be due to invalid IL or missing references)
			//IL_038b: Unknown result type (might be due to invalid IL or missing references)
			//IL_0395: Expected O, but got Unknown
			//IL_03aa: Unknown result type (might be due to invalid IL or missing references)
			//IL_03d1: Unknown result type (might be due to invalid IL or missing references)
			//IL_0411: Unknown result type (might be due to invalid IL or missing references)
			//IL_041b: Expected O, but got Unknown
			//IL_0430: Unknown result type (might be due to invalid IL or missing references)
			//IL_0457: Unknown result type (might be due to invalid IL or missing references)
			//IL_0497: Unknown result type (might be due to invalid IL or missing references)
			//IL_04a1: Expected O, but got Unknown
			//IL_04ba: Unknown result type (might be due to invalid IL or missing references)
			//IL_04de: Unknown result type (might be due to invalid IL or missing references)
			//IL_051e: Unknown result type (might be due to invalid IL or missing references)
			//IL_0528: Expected O, but got Unknown
			//IL_0535: Unknown result type (might be due to invalid IL or missing references)
			//IL_0559: Unknown result type (might be due to invalid IL or missing references)
			//IL_05b0: Unknown result type (might be due to invalid IL or missing references)
			//IL_05d7: Unknown result type (might be due to invalid IL or missing references)
			//IL_05fb: Unknown result type (might be due to invalid IL or missing references)
			//IL_0622: Unknown result type (might be due to invalid IL or missing references)
			//IL_0652: Unknown result type (might be due to invalid IL or missing references)
			//IL_0676: Unknown result type (might be due to invalid IL or missing references)
			//IL_06b6: Unknown result type (might be due to invalid IL or missing references)
			//IL_06da: Unknown result type (might be due to invalid IL or missing references)
			//IL_0716: Unknown result type (might be due to invalid IL or missing references)
			//IL_073d: Unknown result type (might be due to invalid IL or missing references)
			//IL_076e: Unknown result type (might be due to invalid IL or missing references)
			//IL_078a: Unknown result type (might be due to invalid IL or missing references)
			ComponentResourceManager val = new ComponentResourceManager(typeof(FormAbout));
			splitAbout = new SplitContainer();
			txtHelp = new TextBox();
			linkAvangate = new LinkLabel();
			linkLabelMail = new LinkLabel();
			linkLabelSite2 = new LinkLabel();
			linkLblBuy = new LinkLabel();
			btnReg = new Button();
			txtRegCode = new TextBox();
			txtRegUsername = new TextBox();
			lblRegCode = new Label();
			lblRegUsername = new Label();
			lblRegInfo = new Label();
			((Control)splitAbout.get_Panel1()).SuspendLayout();
			((Control)splitAbout.get_Panel2()).SuspendLayout();
			((Control)splitAbout).SuspendLayout();
			((Control)this).SuspendLayout();
			splitAbout.set_Dock((DockStyle)5);
			((Control)splitAbout).set_Location(new Point(0, 0));
			((Control)splitAbout).set_Name("splitAbout");
			splitAbout.set_Orientation((Orientation)0);
			((Control)splitAbout.get_Panel1()).get_Controls().Add((Control)(object)txtHelp);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)linkAvangate);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)linkLabelMail);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)linkLabelSite2);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)linkLblBuy);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)btnReg);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)txtRegCode);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)txtRegUsername);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)lblRegCode);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)lblRegUsername);
			((Control)splitAbout.get_Panel2()).get_Controls().Add((Control)(object)lblRegInfo);
			((Control)splitAbout).set_Size(new Size(634, 371));
			splitAbout.set_SplitterDistance(257);
			((Control)splitAbout).set_TabIndex(0);
			((Control)txtHelp).set_BackColor(SystemColors.get_Control());
			((Control)txtHelp).set_Dock((DockStyle)5);
			((Control)txtHelp).set_Location(new Point(0, 0));
			((Control)txtHelp).set_Margin(new Padding(2));
			((TextBoxBase)txtHelp).set_Multiline(true);
			((Control)txtHelp).set_Name("txtHelp");
			((TextBoxBase)txtHelp).set_ReadOnly(true);
			txtHelp.set_ScrollBars((ScrollBars)2);
			((Control)txtHelp).set_Size(new Size(634, 257));
			((Control)txtHelp).set_TabIndex(9);
			((Control)txtHelp).set_Text(((ResourceManager)(object)val).GetString("txtHelp.Text"));
			((Control)linkAvangate).set_AutoSize(true);
			((Control)linkAvangate).set_Location(new Point(478, 86));
			((Control)linkAvangate).set_Name("linkAvangate");
			((Control)linkAvangate).set_Size(new Size(53, 12));
			((Control)linkAvangate).set_TabIndex(21);
			((Label)linkAvangate).set_TabStop(true);
			((Control)linkAvangate).set_Text("Avangate");
			linkAvangate.add_LinkClicked(new LinkLabelLinkClickedEventHandler(linkAvangate_LinkClicked));
			((Control)linkLabelMail).set_AutoSize(true);
			((Control)linkLabelMail).set_Location(new Point(3, 82));
			((Control)linkLabelMail).set_Name("linkLabelMail");
			((Control)linkLabelMail).set_Size(new Size(137, 12));
			((Control)linkLabelMail).set_TabIndex(20);
			((Label)linkLabelMail).set_TabStop(true);
			((Control)linkLabelMail).set_Text("janusecurity@gmail.com");
			linkLabelMail.add_LinkClicked(new LinkLabelLinkClickedEventHandler(linkLabelMail_LinkClicked));
			((Control)linkLabelSite2).set_AutoSize(true);
			((Control)linkLabelSite2).set_Location(new Point(3, 59));
			((Control)linkLabelSite2).set_Name("linkLabelSite2");
			((Control)linkLabelSite2).set_Size(new Size(137, 12));
			((Control)linkLabelSite2).set_TabIndex(19);
			((Label)linkLabelSite2).set_TabStop(true);
			((Control)linkLabelSite2).set_Text("http://www.janusec.com");
			linkLabelSite2.add_LinkClicked(new LinkLabelLinkClickedEventHandler(linkLabelSite2_LinkClicked));
			((Control)linkLblBuy).set_AutoSize(true);
			((Control)linkLblBuy).set_Location(new Point(538, 86));
			((Control)linkLblBuy).set_Name("linkLblBuy");
			((Control)linkLblBuy).set_Size(new Size(65, 12));
			((Control)linkLblBuy).set_TabIndex(18);
			((Label)linkLblBuy).set_TabStop(true);
			((Control)linkLblBuy).set_Text("MyCommerce");
			linkLblBuy.add_LinkClicked(new LinkLabelLinkClickedEventHandler(linkLblBuy_LinkClicked));
			((Control)btnReg).set_Location(new Point(394, 81));
			((Control)btnReg).set_Name("btnReg");
			((Control)btnReg).set_Size(new Size(75, 23));
			((Control)btnReg).set_TabIndex(17);
			((Control)btnReg).set_Text("Register");
			((ButtonBase)btnReg).set_UseVisualStyleBackColor(true);
			((Control)btnReg).add_Click((EventHandler)btnReg_Click);
			((Control)txtRegCode).set_Location(new Point(394, 56));
			((Control)txtRegCode).set_Name("txtRegCode");
			((Control)txtRegCode).set_Size(new Size(193, 21));
			((Control)txtRegCode).set_TabIndex(16);
			((Control)txtRegUsername).set_Location(new Point(394, 30));
			((Control)txtRegUsername).set_Name("txtRegUsername");
			((Control)txtRegUsername).set_Size(new Size(193, 21));
			((Control)txtRegUsername).set_TabIndex(15);
			((Control)lblRegCode).set_AutoSize(true);
			((Control)lblRegCode).set_Location(new Point(321, 59));
			((Control)lblRegCode).set_Name("lblRegCode");
			((Control)lblRegCode).set_Size(new Size(53, 12));
			((Control)lblRegCode).set_TabIndex(14);
			((Control)lblRegCode).set_Text("RegCode:");
			((Control)lblRegUsername).set_AutoSize(true);
			((Control)lblRegUsername).set_Location(new Point(321, 33));
			((Control)lblRegUsername).set_Name("lblRegUsername");
			((Control)lblRegUsername).set_Size(new Size(59, 12));
			((Control)lblRegUsername).set_TabIndex(13);
			((Control)lblRegUsername).set_Text("Username:");
			((Control)lblRegInfo).set_AutoSize(true);
			((Control)lblRegInfo).set_Location(new Point(3, 10));
			((Control)lblRegInfo).set_Name("lblRegInfo");
			((Control)lblRegInfo).set_Size(new Size(461, 12));
			((Control)lblRegInfo).set_TabIndex(1);
			((Control)lblRegInfo).set_Text("This Copy of WebCruiser is UnRegistered! You can use it for another 30 days.");
			((ContainerControl)this).set_AutoScaleDimensions(new SizeF(6f, 12f));
			((ContainerControl)this).set_AutoScaleMode((AutoScaleMode)1);
			((Form)this).set_ClientSize(new Size(634, 371));
			((Control)this).get_Controls().Add((Control)(object)splitAbout);
			((Form)this).set_FormBorderStyle((FormBorderStyle)0);
			((Control)this).set_Name("FormAbout");
			((Control)this).set_Text("FormAbout");
			((Control)splitAbout.get_Panel1()).ResumeLayout(false);
			((Control)splitAbout.get_Panel1()).PerformLayout();
			((Control)splitAbout.get_Panel2()).ResumeLayout(false);
			((Control)splitAbout.get_Panel2()).PerformLayout();
			((Control)splitAbout).ResumeLayout(false);
			((Control)this).ResumeLayout(false);
		}
	}
}
